/* do not edit automatically generated by mc from M2Reserved.  */
/* M2Reserved.mod determines is a token is a reserved word.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2Reserved_C

#include "GM2Reserved.h"
#   include "GSymbolKey.h"
#   include "GNameKey.h"
#   include "GASCII.h"

#   define eof (char) 032
static SymbolKey_SymbolTree NameTotok;
static SymbolKey_SymbolTree tokToName;

/*
   IsReserved - returns TRUE if the symbol, Name, is a reserved word.
                If TRUE it also sets tok to the appropriate enumerated
                value. It will set tok to eoftok if appropriate.
*/

extern "C" bool M2Reserved_IsReserved (NameKey_Name n, M2Reserved_toktype *tok);

/*
   tokToTok - returns a Tok given the enumerated variable, t.
*/

extern "C" NameKey_Name M2Reserved_tokToTok (M2Reserved_toktype t);

/*
   AddKeyword - adds the Name and enumerated value of a keyword
                into the binary tree.
*/

static void AddKeyword (NameKey_Name n, M2Reserved_toktype tok);

/*
   AddKeyword - adds the Name and enumerated value of a keyword
                into the binary tree.
*/

static void Init (void);


/*
   AddKeyword - adds the Name and enumerated value of a keyword
                into the binary tree.
*/

static void AddKeyword (NameKey_Name n, M2Reserved_toktype tok)
{
  SymbolKey_PutSymKey (NameTotok, n, static_cast<unsigned int> (tok));
  SymbolKey_PutSymKey (tokToName, (NameKey_Name) (tok), n);
}


/*
   AddKeyword - adds the Name and enumerated value of a keyword
                into the binary tree.
*/

static void Init (void)
{
  typedef struct Init__T1_a Init__T1;

  struct Init__T1_a { char array[1+1]; };
  Init__T1 a;

  SymbolKey_InitTree (&NameTotok);
  SymbolKey_InitTree (&tokToName);
  M2Reserved_NulTok = NameKey_NulName;
  M2Reserved_PlusTok = NameKey_MakeKey ((const char *) "+", 1);
  AddKeyword (M2Reserved_PlusTok, M2Reserved_plustok);
  M2Reserved_MinusTok = NameKey_MakeKey ((const char *) "-", 1);
  AddKeyword (M2Reserved_MinusTok, M2Reserved_minustok);
  M2Reserved_TimesTok = NameKey_MakeKey ((const char *) "*", 1);
  AddKeyword (M2Reserved_TimesTok, M2Reserved_timestok);
  M2Reserved_DivideTok = NameKey_MakeKey ((const char *) "/", 1);
  AddKeyword (M2Reserved_DivideTok, M2Reserved_dividetok);
  M2Reserved_BecomesTok = NameKey_MakeKey ((const char *) ":=", 2);
  AddKeyword (M2Reserved_BecomesTok, M2Reserved_becomestok);
  M2Reserved_AmbersandTok = NameKey_MakeKey ((const char *) "&", 1);
  AddKeyword (M2Reserved_AmbersandTok, M2Reserved_ambersandtok);
  M2Reserved_PeriodTok = NameKey_MakeKey ((const char *) ".", 1);
  AddKeyword (M2Reserved_PeriodTok, M2Reserved_periodtok);
  M2Reserved_CommaTok = NameKey_MakeKey ((const char *) ",", 1);
  AddKeyword (M2Reserved_CommaTok, M2Reserved_commatok);
  M2Reserved_SemiColonTok = NameKey_MakeKey ((const char *) ";", 1);
  AddKeyword (M2Reserved_SemiColonTok, M2Reserved_semicolontok);
  M2Reserved_LParaTok = NameKey_MakeKey ((const char *) "(", 1);
  AddKeyword (M2Reserved_LParaTok, M2Reserved_lparatok);
  M2Reserved_LSBraTok = NameKey_MakeKey ((const char *) "[", 1);
  AddKeyword (M2Reserved_LSBraTok, M2Reserved_lsbratok);
  M2Reserved_LCBraTok = NameKey_MakeKey ((const char *) "{", 1);
  AddKeyword (M2Reserved_LCBraTok, M2Reserved_lcbratok);
  M2Reserved_UpArrowTok = NameKey_MakeKey ((const char *) "^", 1);
  AddKeyword (M2Reserved_UpArrowTok, M2Reserved_uparrowtok);
  M2Reserved_SingleQuoteTok = NameKey_MakeKey ((const char *) "'", 1);
  AddKeyword (M2Reserved_SingleQuoteTok, M2Reserved_singlequotetok);
  M2Reserved_EqualTok = NameKey_MakeKey ((const char *) "=", 1);
  AddKeyword (M2Reserved_EqualTok, M2Reserved_equaltok);
  M2Reserved_HashTok = NameKey_MakeKey ((const char *) "#", 1);
  AddKeyword (M2Reserved_HashTok, M2Reserved_hashtok);
  M2Reserved_LessTok = NameKey_MakeKey ((const char *) "<", 1);
  AddKeyword (M2Reserved_LessTok, M2Reserved_lesstok);
  M2Reserved_GreaterTok = NameKey_MakeKey ((const char *) ">", 1);
  AddKeyword (M2Reserved_GreaterTok, M2Reserved_greatertok);
  M2Reserved_LessGreaterTok = NameKey_MakeKey ((const char *) "<>", 2);
  AddKeyword (M2Reserved_LessGreaterTok, M2Reserved_lessgreatertok);
  M2Reserved_LessEqualTok = NameKey_MakeKey ((const char *) "<=", 2);
  AddKeyword (M2Reserved_LessEqualTok, M2Reserved_lessequaltok);
  M2Reserved_GreaterEqualTok = NameKey_MakeKey ((const char *) ">=", 2);
  AddKeyword (M2Reserved_GreaterEqualTok, M2Reserved_greaterequaltok);
  M2Reserved_LDirectiveTok = NameKey_MakeKey ((const char *) "<*", 2);
  AddKeyword (M2Reserved_LDirectiveTok, M2Reserved_ldirectivetok);
  M2Reserved_RDirectiveTok = NameKey_MakeKey ((const char *) "*>", 2);
  AddKeyword (M2Reserved_RDirectiveTok, M2Reserved_rdirectivetok);
  M2Reserved_PeriodPeriodTok = NameKey_MakeKey ((const char *) "..", 2);
  AddKeyword (M2Reserved_PeriodPeriodTok, M2Reserved_periodperiodtok);
  M2Reserved_ColonTok = NameKey_MakeKey ((const char *) ":", 1);
  AddKeyword (M2Reserved_ColonTok, M2Reserved_colontok);
  M2Reserved_RParaTok = NameKey_MakeKey ((const char *) ")", 1);
  AddKeyword (M2Reserved_RParaTok, M2Reserved_rparatok);
  M2Reserved_RSBraTok = NameKey_MakeKey ((const char *) "]", 1);
  AddKeyword (M2Reserved_RSBraTok, M2Reserved_rsbratok);
  M2Reserved_RCBraTok = NameKey_MakeKey ((const char *) "}", 1);
  AddKeyword (M2Reserved_RCBraTok, M2Reserved_rcbratok);
  M2Reserved_BarTok = NameKey_MakeKey ((const char *) "|", 1);
  AddKeyword (M2Reserved_BarTok, M2Reserved_bartok);
  M2Reserved_DoubleQuotesTok = NameKey_MakeKey ((const char *) "\"", 1);
  AddKeyword (M2Reserved_DoubleQuotesTok, M2Reserved_doublequotestok);
  M2Reserved_AndTok = NameKey_MakeKey ((const char *) "AND", 3);
  AddKeyword (M2Reserved_AndTok, M2Reserved_andtok);
  M2Reserved_ArrayTok = NameKey_MakeKey ((const char *) "ARRAY", 5);
  AddKeyword (M2Reserved_ArrayTok, M2Reserved_arraytok);
  M2Reserved_BeginTok = NameKey_MakeKey ((const char *) "BEGIN", 5);
  AddKeyword (M2Reserved_BeginTok, M2Reserved_begintok);
  M2Reserved_ByTok = NameKey_MakeKey ((const char *) "BY", 2);
  AddKeyword (M2Reserved_ByTok, M2Reserved_bytok);
  M2Reserved_CaseTok = NameKey_MakeKey ((const char *) "CASE", 4);
  AddKeyword (M2Reserved_CaseTok, M2Reserved_casetok);
  M2Reserved_ConstTok = NameKey_MakeKey ((const char *) "CONST", 5);
  AddKeyword (M2Reserved_ConstTok, M2Reserved_consttok);
  M2Reserved_DefinitionTok = NameKey_MakeKey ((const char *) "DEFINITION", 10);
  AddKeyword (M2Reserved_DefinitionTok, M2Reserved_definitiontok);
  M2Reserved_DivTok = NameKey_MakeKey ((const char *) "DIV", 3);
  AddKeyword (M2Reserved_DivTok, M2Reserved_divtok);
  M2Reserved_DoTok = NameKey_MakeKey ((const char *) "DO", 2);
  AddKeyword (M2Reserved_DoTok, M2Reserved_dotok);
  M2Reserved_ElseTok = NameKey_MakeKey ((const char *) "ELSE", 4);
  AddKeyword (M2Reserved_ElseTok, M2Reserved_elsetok);
  M2Reserved_ElsifTok = NameKey_MakeKey ((const char *) "ELSIF", 5);
  AddKeyword (M2Reserved_ElsifTok, M2Reserved_elsiftok);
  M2Reserved_EndTok = NameKey_MakeKey ((const char *) "END", 3);
  AddKeyword (M2Reserved_EndTok, M2Reserved_endtok);
  M2Reserved_ExitTok = NameKey_MakeKey ((const char *) "EXIT", 4);
  AddKeyword (M2Reserved_ExitTok, M2Reserved_exittok);
  M2Reserved_ExceptTok = NameKey_MakeKey ((const char *) "EXCEPT", 6);
  AddKeyword (M2Reserved_ExceptTok, M2Reserved_excepttok);
  M2Reserved_ExportTok = NameKey_MakeKey ((const char *) "EXPORT", 6);
  AddKeyword (M2Reserved_ExportTok, M2Reserved_exporttok);
  M2Reserved_FinallyTok = NameKey_MakeKey ((const char *) "FINALLY", 7);
  AddKeyword (M2Reserved_FinallyTok, M2Reserved_finallytok);
  M2Reserved_ForTok = NameKey_MakeKey ((const char *) "FOR", 3);
  AddKeyword (M2Reserved_ForTok, M2Reserved_fortok);
  M2Reserved_ForwardTok = NameKey_MakeKey ((const char *) "FORWARD", 7);
  AddKeyword (M2Reserved_ForwardTok, M2Reserved_forwardtok);
  M2Reserved_FromTok = NameKey_MakeKey ((const char *) "FROM", 4);
  AddKeyword (M2Reserved_FromTok, M2Reserved_fromtok);
  M2Reserved_IfTok = NameKey_MakeKey ((const char *) "IF", 2);
  AddKeyword (M2Reserved_IfTok, M2Reserved_iftok);
  M2Reserved_ImplementationTok = NameKey_MakeKey ((const char *) "IMPLEMENTATION", 14);
  AddKeyword (M2Reserved_ImplementationTok, M2Reserved_implementationtok);
  M2Reserved_ImportTok = NameKey_MakeKey ((const char *) "IMPORT", 6);
  AddKeyword (M2Reserved_ImportTok, M2Reserved_importtok);
  M2Reserved_InTok = NameKey_MakeKey ((const char *) "IN", 2);
  AddKeyword (M2Reserved_InTok, M2Reserved_intok);
  M2Reserved_LoopTok = NameKey_MakeKey ((const char *) "LOOP", 4);
  AddKeyword (M2Reserved_LoopTok, M2Reserved_looptok);
  M2Reserved_ModTok = NameKey_MakeKey ((const char *) "MOD", 3);
  AddKeyword (M2Reserved_ModTok, M2Reserved_modtok);
  M2Reserved_ModuleTok = NameKey_MakeKey ((const char *) "MODULE", 6);
  AddKeyword (M2Reserved_ModuleTok, M2Reserved_moduletok);
  M2Reserved_NotTok = NameKey_MakeKey ((const char *) "NOT", 3);
  AddKeyword (M2Reserved_NotTok, M2Reserved_nottok);
  M2Reserved_OfTok = NameKey_MakeKey ((const char *) "OF", 2);
  AddKeyword (M2Reserved_OfTok, M2Reserved_oftok);
  M2Reserved_OrTok = NameKey_MakeKey ((const char *) "OR", 2);
  AddKeyword (M2Reserved_OrTok, M2Reserved_ortok);
  /* 
   PackedTok := MakeKey('PACKED') ;
   AddKeyword(PackedTok, packedtok) ;
  */
  M2Reserved_PackedSetTok = NameKey_MakeKey ((const char *) "PACKEDSET", 9);
  AddKeyword (M2Reserved_PackedSetTok, M2Reserved_packedsettok);
  M2Reserved_PointerTok = NameKey_MakeKey ((const char *) "POINTER", 7);
  AddKeyword (M2Reserved_PointerTok, M2Reserved_pointertok);
  M2Reserved_ProcedureTok = NameKey_MakeKey ((const char *) "PROCEDURE", 9);
  AddKeyword (M2Reserved_ProcedureTok, M2Reserved_proceduretok);
  M2Reserved_QualifiedTok = NameKey_MakeKey ((const char *) "QUALIFIED", 9);
  AddKeyword (M2Reserved_QualifiedTok, M2Reserved_qualifiedtok);
  M2Reserved_UnQualifiedTok = NameKey_MakeKey ((const char *) "UNQUALIFIED", 11);
  AddKeyword (M2Reserved_UnQualifiedTok, M2Reserved_unqualifiedtok);
  M2Reserved_RecordTok = NameKey_MakeKey ((const char *) "RECORD", 6);
  AddKeyword (M2Reserved_RecordTok, M2Reserved_recordtok);
  M2Reserved_RemTok = NameKey_MakeKey ((const char *) "REM", 3);
  AddKeyword (M2Reserved_RemTok, M2Reserved_remtok);
  M2Reserved_RepeatTok = NameKey_MakeKey ((const char *) "REPEAT", 6);
  AddKeyword (M2Reserved_RepeatTok, M2Reserved_repeattok);
  M2Reserved_RetryTok = NameKey_MakeKey ((const char *) "RETRY", 5);
  AddKeyword (M2Reserved_RetryTok, M2Reserved_retrytok);
  M2Reserved_ReturnTok = NameKey_MakeKey ((const char *) "RETURN", 6);
  AddKeyword (M2Reserved_ReturnTok, M2Reserved_returntok);
  M2Reserved_SetTok = NameKey_MakeKey ((const char *) "SET", 3);
  AddKeyword (M2Reserved_SetTok, M2Reserved_settok);
  M2Reserved_ThenTok = NameKey_MakeKey ((const char *) "THEN", 4);
  AddKeyword (M2Reserved_ThenTok, M2Reserved_thentok);
  M2Reserved_ToTok = NameKey_MakeKey ((const char *) "TO", 2);
  AddKeyword (M2Reserved_ToTok, M2Reserved_totok);
  M2Reserved_TypeTok = NameKey_MakeKey ((const char *) "TYPE", 4);
  AddKeyword (M2Reserved_TypeTok, M2Reserved_typetok);
  M2Reserved_UntilTok = NameKey_MakeKey ((const char *) "UNTIL", 5);
  AddKeyword (M2Reserved_UntilTok, M2Reserved_untiltok);
  M2Reserved_VarTok = NameKey_MakeKey ((const char *) "VAR", 3);
  AddKeyword (M2Reserved_VarTok, M2Reserved_vartok);
  M2Reserved_WhileTok = NameKey_MakeKey ((const char *) "WHILE", 5);
  AddKeyword (M2Reserved_WhileTok, M2Reserved_whiletok);
  M2Reserved_WithTok = NameKey_MakeKey ((const char *) "WITH", 4);
  AddKeyword (M2Reserved_WithTok, M2Reserved_withtok);
  M2Reserved_AsmTok = NameKey_MakeKey ((const char *) "ASM", 3);
  AddKeyword (M2Reserved_AsmTok, M2Reserved_asmtok);
  M2Reserved_VolatileTok = NameKey_MakeKey ((const char *) "VOLATILE", 8);
  AddKeyword (M2Reserved_VolatileTok, M2Reserved_volatiletok);
  M2Reserved_DateTok = NameKey_MakeKey ((const char *) "__DATE__", 8);  /* C compatible preprocessor primatives  */
  AddKeyword (M2Reserved_DateTok, M2Reserved_datetok);  /* C compatible preprocessor primatives  */
  M2Reserved_LineTok = NameKey_MakeKey ((const char *) "__LINE__", 8);
  AddKeyword (M2Reserved_LineTok, M2Reserved_linetok);
  M2Reserved_FileTok = NameKey_MakeKey ((const char *) "__FILE__", 8);
  AddKeyword (M2Reserved_FileTok, M2Reserved_filetok);
  M2Reserved_AttributeTok = NameKey_MakeKey ((const char *) "__ATTRIBUTE__", 13);  /* GCC extension incorporated into gm2  */
  AddKeyword (M2Reserved_AttributeTok, M2Reserved_attributetok);  /* GCC extension incorporated into gm2  */
  M2Reserved_BuiltinTok = NameKey_MakeKey ((const char *) "__BUILTIN__", 11);  /* GCC extension incorporated into gm2  */
  AddKeyword (M2Reserved_BuiltinTok, M2Reserved_builtintok);  /* GCC extension incorporated into gm2  */
  M2Reserved_InlineTok = NameKey_MakeKey ((const char *) "__INLINE__", 10);  /* GCC extension incorporated into gm2  */
  AddKeyword (M2Reserved_InlineTok, M2Reserved_inlinetok);  /* GCC extension incorporated into gm2  */
  a.array[0] = eof;
  a.array[1] = ASCII_nul;
  M2Reserved_EofTok = NameKey_MakeKey ((const char *) &a.array[0], 1);  /* Not a reserved token  */
}


/*
   IsReserved - returns TRUE if the symbol, Name, is a reserved word.
                If TRUE it also sets tok to the appropriate enumerated
                value. It will set tok to eoftok if appropriate.
*/

extern "C" bool M2Reserved_IsReserved (NameKey_Name n, M2Reserved_toktype *tok)
{
  unsigned int t;

  t = static_cast<unsigned int> (SymbolKey_GetSymKey (NameTotok, n));
  if (t == 0)
    {
      /* eoftok is not a reserved word  */
      if (n == M2Reserved_EofTok)
        {
          (*tok) = M2Reserved_eoftok;
        }
      return false;
    }
  else
    {
      (*tok) = (M2Reserved_toktype) (t);
      return true;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   tokToTok - returns a Tok given the enumerated variable, t.
*/

extern "C" NameKey_Name M2Reserved_tokToTok (M2Reserved_toktype t)
{
  return static_cast<NameKey_Name> (SymbolKey_GetSymKey (tokToName, (NameKey_Name) (t)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Reserved_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2Reserved_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
