/* do not edit automatically generated by mc from M2Pass.  */
/* M2Pass.mod provides setting and testing of the current pass.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _M2Pass_C

#include "GM2Pass.h"
#   include "GM2Error.h"

typedef enum {M2Pass_NoPass, M2Pass_Pass0, M2Pass_Pass1, M2Pass_Pass2, M2Pass_PassC, M2Pass_Pass3, M2Pass_CodeGeneration, M2Pass_ErrorPass, M2Pass_HiddenPass} M2Pass_Pass;

static M2Pass_Pass CurrentPass;

/*
   SetPassToNoPass - sets the pass state to no Pass.
*/

extern "C" void M2Pass_SetPassToNoPass (void);

/*
   SetPassToPass0 - sets the pass state to Pass 0.
*/

extern "C" void M2Pass_SetPassToPass0 (void);

/*
   SetPassToPass1 - sets the pass state to Pass 1.
*/

extern "C" void M2Pass_SetPassToPass1 (void);

/*
   SetPassToPass2 - sets the pass state to Pass 2.
*/

extern "C" void M2Pass_SetPassToPass2 (void);

/*
   SetPassToPassC - sets the pass state to Pass C.
*/

extern "C" void M2Pass_SetPassToPassC (void);

/*
   SetPassToPass3 - sets the pass state to Pass 3.
*/

extern "C" void M2Pass_SetPassToPass3 (void);

/*
   SetPassToPassHidden - sets the pass state to the hidden type pass.
*/

extern "C" void M2Pass_SetPassToPassHidden (void);

/*
   SetPassToCodeGeneration - sets the pass state to CodeGeneration.
*/

extern "C" void M2Pass_SetPassToCodeGeneration (void);

/*
   SetPassToErrorPass - sets the pass state to no Error Pass.
*/

extern "C" void M2Pass_SetPassToErrorPass (void);

/*
   IsNoPass - returns true if currently in no Pass.
*/

extern "C" bool M2Pass_IsNoPass (void);

/*
   IsPass0 - returns true if currently in Pass 0.
*/

extern "C" bool M2Pass_IsPass0 (void);

/*
   IsPass1 - returns true if currently in Pass 1.
*/

extern "C" bool M2Pass_IsPass1 (void);

/*
   IsPass2 - returns true if currently in Pass 2.
*/

extern "C" bool M2Pass_IsPass2 (void);

/*
   IsPassC - returns true if currently in Pass C.
*/

extern "C" bool M2Pass_IsPassC (void);

/*
   IsPass3 - returns true if currently in Pass 3.
*/

extern "C" bool M2Pass_IsPass3 (void);

/*
   IsPassHidden - returns TRUE if currently parsing for hidden types.
*/

extern "C" bool M2Pass_IsPassHidden (void);

/*
   IsPassCodeGeneration - returns true if currently in the CodeGeneration Pass.
*/

extern "C" bool M2Pass_IsPassCodeGeneration (void);

/*
   IsErrorPass - returns true if currently in the Error Pass.
*/

extern "C" bool M2Pass_IsErrorPass (void);


/*
   SetPassToNoPass - sets the pass state to no Pass.
*/

extern "C" void M2Pass_SetPassToNoPass (void)
{
  CurrentPass = M2Pass_NoPass;
}


/*
   SetPassToPass0 - sets the pass state to Pass 0.
*/

extern "C" void M2Pass_SetPassToPass0 (void)
{
  if (CurrentPass == M2Pass_NoPass)
    {
      CurrentPass = M2Pass_Pass0;
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to set CurrentPass to Pass1", 38);
    }
}


/*
   SetPassToPass1 - sets the pass state to Pass 1.
*/

extern "C" void M2Pass_SetPassToPass1 (void)
{
  if (CurrentPass == M2Pass_NoPass)
    {
      CurrentPass = M2Pass_Pass1;
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to set CurrentPass to Pass1", 38);
    }
}


/*
   SetPassToPass2 - sets the pass state to Pass 2.
*/

extern "C" void M2Pass_SetPassToPass2 (void)
{
  if (CurrentPass == M2Pass_NoPass)
    {
      CurrentPass = M2Pass_Pass2;
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to set CurrentPass to Pass2", 38);
    }
}


/*
   SetPassToPassC - sets the pass state to Pass C.
*/

extern "C" void M2Pass_SetPassToPassC (void)
{
  if (CurrentPass == M2Pass_NoPass)
    {
      CurrentPass = M2Pass_PassC;
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to set CurrentPass to PassC", 38);
    }
}


/*
   SetPassToPass3 - sets the pass state to Pass 3.
*/

extern "C" void M2Pass_SetPassToPass3 (void)
{
  if (CurrentPass == M2Pass_NoPass)
    {
      CurrentPass = M2Pass_Pass3;
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to set CurrentPass to Pass3", 38);
    }
}


/*
   SetPassToPassHidden - sets the pass state to the hidden type pass.
*/

extern "C" void M2Pass_SetPassToPassHidden (void)
{
  CurrentPass = M2Pass_HiddenPass;
}


/*
   SetPassToCodeGeneration - sets the pass state to CodeGeneration.
*/

extern "C" void M2Pass_SetPassToCodeGeneration (void)
{
  if (CurrentPass == M2Pass_NoPass)
    {
      CurrentPass = M2Pass_CodeGeneration;
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to set CurrentPass to CodeGeneration", 47);
    }
}


/*
   SetPassToErrorPass - sets the pass state to no Error Pass.
*/

extern "C" void M2Pass_SetPassToErrorPass (void)
{
  CurrentPass = M2Pass_ErrorPass;
}


/*
   IsNoPass - returns true if currently in no Pass.
*/

extern "C" bool M2Pass_IsNoPass (void)
{
  return CurrentPass == M2Pass_NoPass;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPass0 - returns true if currently in Pass 0.
*/

extern "C" bool M2Pass_IsPass0 (void)
{
  return CurrentPass == M2Pass_Pass0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPass1 - returns true if currently in Pass 1.
*/

extern "C" bool M2Pass_IsPass1 (void)
{
  return CurrentPass == M2Pass_Pass1;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPass2 - returns true if currently in Pass 2.
*/

extern "C" bool M2Pass_IsPass2 (void)
{
  return CurrentPass == M2Pass_Pass2;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPassC - returns true if currently in Pass C.
*/

extern "C" bool M2Pass_IsPassC (void)
{
  return CurrentPass == M2Pass_PassC;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPass3 - returns true if currently in Pass 3.
*/

extern "C" bool M2Pass_IsPass3 (void)
{
  return CurrentPass == M2Pass_Pass3;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPassHidden - returns TRUE if currently parsing for hidden types.
*/

extern "C" bool M2Pass_IsPassHidden (void)
{
  return CurrentPass == M2Pass_HiddenPass;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPassCodeGeneration - returns true if currently in the CodeGeneration Pass.
*/

extern "C" bool M2Pass_IsPassCodeGeneration (void)
{
  return CurrentPass == M2Pass_CodeGeneration;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsErrorPass - returns true if currently in the Error Pass.
*/

extern "C" bool M2Pass_IsErrorPass (void)
{
  return CurrentPass == M2Pass_ErrorPass;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Pass_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  M2Pass_SetPassToNoPass ();
}

extern "C" void _M2_M2Pass_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
