/* do not edit automatically generated by mc from M2Search.  */
/* M2Search.def provides a mechanism to search selected directories.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Search_H)
#   define _M2Search_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"

#   if defined (_M2Search_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   FindSourceFile - attempts to locate the source file FileName.
                    If a file is found then TRUE is returned otherwise
                    FALSE is returned.
                    The parameter FullPath is set indicating the
                    absolute location of source FileName.
                    FullPath will be totally overwritten and should
                    not be initialized by InitString before this function
                    is called.
                    FullPath is set to NIL if this function returns FALSE.
                    FindSourceFile sets FullPath to a new string if successful.
                    The string FileName is not altered.
*/

EXTERN bool M2Search_FindSourceFile (DynamicStrings_String FileName, DynamicStrings_String *FullPath, DynamicStrings_String *named);

/*
   FindSourceDefFile - attempts to find the definition module for
                       a module, Stem. If successful it returns
                       the full path and returns TRUE. If unsuccessful
                       then FALSE is returned and FullPath is set to NIL.
*/

EXTERN bool M2Search_FindSourceDefFile (DynamicStrings_String Stem, DynamicStrings_String *FullPath, DynamicStrings_String *named);

/*
   FindSourceModFile - attempts to find the implementation module for
                       a module, Stem. If successful it returns
                       the full path and returns TRUE. If unsuccessful
                       then FALSE is returned and FullPath is set to NIL.
*/

EXTERN bool M2Search_FindSourceModFile (DynamicStrings_String Stem, DynamicStrings_String *FullPath, DynamicStrings_String *named);

/*
   SetDefExtension - sets the default extension for definition modules to, ext.
                     The string, ext, should be deallocated by the caller at
                     an appropriate time.
*/

EXTERN void M2Search_SetDefExtension (DynamicStrings_String ext);

/*
   SetModExtension - sets the default extension for implementation and program
                     modules to, ext. The string, ext, should be deallocated
                     by the caller at an appropriate time.
*/

EXTERN void M2Search_SetModExtension (DynamicStrings_String ext);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
