/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import schemacrawler.ermodel.model.TableBacked;
import schemacrawler.schema.Column;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Table;

abstract class AbstractTableBacked
implements TableBacked {
    private static final long serialVersionUID = -1252099222675350939L;
    private final Table table;

    public AbstractTableBacked(Table table) {
        this.table = Objects.requireNonNull(table, "No table provided");
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.table.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        return this.table.getAttribute(name, defaultValue);
    }

    @Override
    public Collection<Column> getAttributeColumns() {
        return this.table.getColumns().stream().filter(column -> !column.isPartOfPrimaryKey() && !column.isPartOfForeignKey()).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.table.getAttributes();
    }

    @Override
    public String getFullName() {
        return this.table.getFullName();
    }

    @Override
    public String getName() {
        return this.table.getName();
    }

    @Override
    public String getRemarks() {
        return this.table.getRemarks();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.table.hasAttribute(name);
    }

    @Override
    public boolean hasRemarks() {
        return this.table.hasRemarks();
    }

    @Override
    public NamedObjectKey key() {
        return this.table.key();
    }

    @Override
    public <T> Optional<T> lookupAttribute(String name) {
        return this.table.lookupAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.table.removeAttribute(name);
    }

    @Override
    public <T> void setAttribute(String name, T value) {
        this.table.setAttribute(name, value);
    }

    @Override
    public void setRemarks(String remarks) {
        this.table.setRemarks(remarks);
    }

    public String toString() {
        return this.table.toString();
    }
}

