/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.time.Duration;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.postgresql.util.LazyCleaner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class LazyCleanerImpl
implements LazyCleaner {
    private static final Logger LOGGER = Logger.getLogger(LazyCleanerImpl.class.getName());
    private static final LazyCleanerImpl instance = new LazyCleanerImpl("PostgreSQL-JDBC-Cleaner", Duration.ofMillis(Long.getLong("pgjdbc.config.cleanup.thread.ttl", 30000L)));
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final String threadName;
    private final Duration threadTtl;
    private boolean threadRunning;
    private @Nullable Node<?> first;

    public LazyCleanerImpl(String threadName, Duration threadTtl) {
        this.threadName = threadName;
        this.threadTtl = threadTtl;
    }

    public static LazyCleanerImpl getInstance() {
        return instance;
    }

    @Override
    public <T extends Throwable> LazyCleaner.Cleanable<T> register(Object obj, LazyCleaner.CleaningAction<T> action) {
        assert (obj != action) : "object handle should not be the same as cleaning action, otherwise the object will never become phantom reachable, so the action will never trigger";
        return this.add(new Node<T>(obj, action));
    }

    public synchronized boolean isThreadRunning() {
        return this.threadRunning;
    }

    private synchronized boolean checkEmpty() {
        if (this.first == null) {
            this.threadRunning = false;
            return true;
        }
        return false;
    }

    private synchronized <T extends Throwable> Node<T> add(Node<T> node) {
        if (this.first != null) {
            ((Node)node).next = (Node)this.first;
            ((Node)this.first).prev = (Node)node;
        }
        this.first = node;
        if (!this.threadRunning) {
            this.threadRunning = this.startThread();
        }
        return node;
    }

    private boolean startThread() {
        ForkJoinPool.commonPool().execute(() -> {
            Thread.currentThread().setContextClassLoader(null);
            RefQueueBlocker<Object> blocker = new RefQueueBlocker<Object>(this.queue, this.threadName, this.threadTtl, this::checkEmpty);
            while (!this.checkEmpty()) {
                try {
                    ForkJoinPool.managedBlock(blocker);
                    Node ref = (Node)blocker.drainOne();
                    if (ref == null) continue;
                    ref.onClean(true);
                }
                catch (InterruptedException e) {
                    if (!blocker.isReleasable()) {
                        LOGGER.log(Level.FINE, "Got interrupt and the cleanup queue is empty, will terminate the cleanup thread");
                        break;
                    }
                    LOGGER.log(Level.FINE, "Got interrupt and the cleanup queue is NOT empty. Will ignore the interrupt");
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "Unexpected exception while executing onClean", e);
                }
            }
        });
        return true;
    }

    private synchronized boolean remove(Node<?> node) {
        if (((Node)node).next == node) {
            return false;
        }
        if (this.first == node) {
            this.first = ((Node)node).next;
        }
        if (((Node)node).next != null) {
            ((Node)((Node)node).next).prev = (Node)((Node)node).prev;
        }
        if (((Node)node).prev != null) {
            ((Node)((Node)node).prev).next = (Node)((Node)node).next;
        }
        ((Node)node).next = (Node)node;
        ((Node)node).prev = (Node)node;
        return true;
    }

    private class Node<T extends Throwable>
    extends PhantomReference<Object>
    implements LazyCleaner.Cleanable<T>,
    LazyCleaner.CleaningAction<T> {
        private final LazyCleaner.CleaningAction<T> action;
        private @Nullable Node<?> prev;
        private @Nullable Node<?> next;

        Node(Object referent, LazyCleaner.CleaningAction<T> action) {
            super(referent, LazyCleanerImpl.this.queue);
            this.action = action;
        }

        @Override
        public void clean() throws T {
            this.onClean(false);
        }

        @Override
        public void onClean(boolean leak) throws T {
            if (!LazyCleanerImpl.this.remove(this)) {
                return;
            }
            this.action.onClean(leak);
        }
    }

    private static class RefQueueBlocker<T>
    implements ForkJoinPool.ManagedBlocker {
        private final ReferenceQueue<T> queue;
        private final String threadName;
        private @Nullable Reference<? extends T> ref;
        private final long blockTimeoutMillis;
        private final BooleanSupplier shouldTerminate;

        RefQueueBlocker(ReferenceQueue<T> queue, String threadName, Duration blockTimeout, BooleanSupplier shouldTerminate) {
            this.queue = queue;
            this.threadName = threadName;
            this.blockTimeoutMillis = blockTimeout.toMillis();
            this.shouldTerminate = shouldTerminate;
        }

        @Override
        public boolean isReleasable() {
            if (this.ref != null || this.shouldTerminate.getAsBoolean()) {
                return true;
            }
            this.ref = this.queue.poll();
            return this.ref != null;
        }

        @Override
        public boolean block() throws InterruptedException {
            if (this.isReleasable()) {
                return true;
            }
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            try {
                currentThread.setName(this.threadName);
                this.ref = this.queue.remove(this.blockTimeoutMillis);
            }
            finally {
                currentThread.setName(oldName);
            }
            return false;
        }

        public @Nullable Reference<? extends T> drainOne() {
            Reference<? extends T> ref = this.ref;
            this.ref = null;
            return ref;
        }
    }
}

