/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal32;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.extern.decimal.OverflowHandling;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jaybird.util.LegacyDatetimeConversions;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.field.FBBigDecimalField;
import org.firebirdsql.jdbc.field.FBBinaryField;
import org.firebirdsql.jdbc.field.FBBlobField;
import org.firebirdsql.jdbc.field.FBBooleanField;
import org.firebirdsql.jdbc.field.FBCachedBlobField;
import org.firebirdsql.jdbc.field.FBCachedLongVarCharField;
import org.firebirdsql.jdbc.field.FBDateField;
import org.firebirdsql.jdbc.field.FBDecfloatField;
import org.firebirdsql.jdbc.field.FBDoubleField;
import org.firebirdsql.jdbc.field.FBFloatField;
import org.firebirdsql.jdbc.field.FBIntegerField;
import org.firebirdsql.jdbc.field.FBLongField;
import org.firebirdsql.jdbc.field.FBLongVarCharField;
import org.firebirdsql.jdbc.field.FBNullField;
import org.firebirdsql.jdbc.field.FBRowIdField;
import org.firebirdsql.jdbc.field.FBShortField;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FBTimeField;
import org.firebirdsql.jdbc.field.FBTimeTzField;
import org.firebirdsql.jdbc.field.FBTimestampField;
import org.firebirdsql.jdbc.field.FBTimestampTzField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.jdbc.field.TypeConversionException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullUnmarked
public abstract class FBField {
    static final String SQL_TYPE_NOT_SUPPORTED = "SQL type for this field is not yet supported";
    static final String SQL_ARRAY_NOT_SUPPORTED = "Types.ARRAY: SQL type for this field is not yet supported";
    static final byte BYTE_NULL_VALUE = 0;
    static final short SHORT_NULL_VALUE = 0;
    static final int INT_NULL_VALUE = 0;
    static final long LONG_NULL_VALUE = 0L;
    static final float FLOAT_NULL_VALUE = 0.0f;
    static final double DOUBLE_NULL_VALUE = 0.0;
    static final boolean BOOLEAN_NULL_VALUE = false;
    static final byte MAX_BYTE_VALUE = 127;
    static final byte MIN_BYTE_VALUE = -128;
    static final short MAX_SHORT_VALUE = Short.MAX_VALUE;
    static final short MIN_SHORT_VALUE = Short.MIN_VALUE;
    static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    static final int MIN_INT_VALUE = Integer.MIN_VALUE;
    static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    static final long MIN_LONG_VALUE = Long.MIN_VALUE;
    static final float MAX_FLOAT_VALUE = Float.MAX_VALUE;
    static final float MIN_FLOAT_VALUE = -3.4028235E38f;
    static final double MAX_DOUBLE_VALUE = Double.MAX_VALUE;
    static final double MIN_DOUBLE_VALUE = -1.7976931348623157E308;
    protected final @NonNull FieldDescriptor fieldDescriptor;
    private final @NonNull FieldDataProvider dataProvider;
    protected GDSHelper gdsHelper;
    protected int requiredType;

    FBField(@NonNull FieldDescriptor fieldDescriptor, @NonNull FieldDataProvider dataProvider, int requiredType) throws SQLException {
        if (fieldDescriptor == null) {
            throw new SQLNonTransientException("Cannot create FBField instance with fieldDescriptor null", "HY009");
        }
        this.fieldDescriptor = fieldDescriptor;
        this.dataProvider = Objects.requireNonNull(dataProvider, "dataProvider");
        this.requiredType = requiredType;
    }

    protected final byte @Nullable [] getFieldData() {
        return this.dataProvider.getFieldData();
    }

    protected final void setFieldData(byte @Nullable [] data) {
        this.dataProvider.setFieldData(data);
    }

    protected final @NonNull DatatypeCoder getDatatypeCoder() {
        return this.fieldDescriptor.getDatatypeCoder();
    }

    public final boolean isNull() throws SQLException {
        return this.getFieldData() == null;
    }

    public void setNull() {
        this.setFieldData(null);
    }

    public final void setConnection(GDSHelper gdsHelper) {
        this.gdsHelper = gdsHelper;
    }

    public void setRequiredType(int requiredType) {
        this.requiredType = requiredType;
    }

    @NullMarked
    public static FBField createField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, @Nullable GDSHelper gdsHelper, boolean cached) throws SQLException {
        int jdbcType = JdbcTypeConverter.toJdbcType(fieldDescriptor);
        switch (jdbcType) {
            case -1: {
                if (cached) {
                    return new FBCachedLongVarCharField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
                }
                return new FBLongVarCharField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
            }
            case -4: 
            case 2004: {
                if (cached) {
                    return new FBCachedBlobField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
                }
                return new FBBlobField(fieldDescriptor, dataProvider, jdbcType, gdsHelper);
            }
        }
        FBField result = FBField.createField(jdbcType, fieldDescriptor, dataProvider);
        result.setConnection(gdsHelper);
        return result;
    }

    @NullMarked
    private static FBField createField(int jdbcType, FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider) throws SQLException {
        return switch (jdbcType) {
            case 5 -> new FBShortField(fieldDescriptor, dataProvider, jdbcType);
            case 4 -> new FBIntegerField(fieldDescriptor, dataProvider, jdbcType);
            case -5 -> new FBLongField(fieldDescriptor, dataProvider, jdbcType);
            case 2, 3 -> new FBBigDecimalField(fieldDescriptor, dataProvider, jdbcType);
            case -6001 -> {
                switch (fieldDescriptor.getType() & 0xFFFFFFFE) {
                    case 32760: {
                        yield new FBDecfloatField<Decimal64>(fieldDescriptor, dataProvider, jdbcType, Decimal64.class);
                    }
                    case 32762: {
                        yield new FBDecfloatField<Decimal128>(fieldDescriptor, dataProvider, jdbcType, Decimal128.class);
                    }
                }
                throw new FBDriverNotCapableException("Unexpected field type for DECFLOAT: " + fieldDescriptor.getType());
            }
            case 6 -> new FBFloatField(fieldDescriptor, dataProvider, jdbcType);
            case 8 -> new FBDoubleField(fieldDescriptor, dataProvider, jdbcType);
            case 92 -> new FBTimeField(fieldDescriptor, dataProvider, jdbcType);
            case 91 -> new FBDateField(fieldDescriptor, dataProvider, jdbcType);
            case 93 -> new FBTimestampField(fieldDescriptor, dataProvider, jdbcType);
            case 2014 -> new FBTimestampTzField(fieldDescriptor, dataProvider, jdbcType);
            case 2013 -> new FBTimeTzField(fieldDescriptor, dataProvider, jdbcType);
            case 1, 12 -> new FBStringField(fieldDescriptor, dataProvider, jdbcType);
            case -3, -2 -> new FBBinaryField(fieldDescriptor, dataProvider, jdbcType);
            case 16 -> new FBBooleanField(fieldDescriptor, dataProvider, jdbcType);
            case 0 -> new FBNullField(fieldDescriptor, dataProvider, jdbcType);
            case -8 -> new FBRowIdField(fieldDescriptor, dataProvider, jdbcType);
            case 2003 -> throw new FBDriverNotCapableException(SQL_ARRAY_NOT_SUPPORTED);
            default -> throw new FBDriverNotCapableException(SQL_TYPE_NOT_SUPPORTED);
        };
    }

    public String getName() {
        return this.fieldDescriptor.getOriginalName();
    }

    public String getAlias() {
        return this.fieldDescriptor.getFieldName();
    }

    public String getRelationName() {
        return this.fieldDescriptor.getOriginalTableName();
    }

    public byte getByte() throws SQLException {
        throw this.invalidGetConversion("byte");
    }

    public short getShort() throws SQLException {
        throw this.invalidGetConversion("short");
    }

    public int getInt() throws SQLException {
        throw this.invalidGetConversion("int");
    }

    public long getLong() throws SQLException {
        throw this.invalidGetConversion("long");
    }

    public float getFloat() throws SQLException {
        throw this.invalidGetConversion("float");
    }

    public double getDouble() throws SQLException {
        throw this.invalidGetConversion("double");
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw this.invalidGetConversion(BigDecimal.class);
    }

    public final BigDecimal getBigDecimal(int scale) throws SQLException {
        return this.getBigDecimal();
    }

    public boolean getBoolean() throws SQLException {
        throw this.invalidGetConversion("boolean");
    }

    public String getString() throws SQLException {
        throw this.invalidGetConversion(String.class);
    }

    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        throw this.invalidGetConversion(Object.class);
    }

    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public <T> T getObject(@NonNull Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLNonTransientException("getObject called with type null");
        }
        Decimal32 result = switch (type.getName()) {
            case "java.lang.Boolean" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield this.getBoolean();
            }
            case "java.lang.Byte" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield this.getByte();
            }
            case "java.lang.Short" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield this.getShort();
            }
            case "java.lang.Integer" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield this.getInt();
            }
            case "java.lang.Long" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield this.getLong();
            }
            case "java.lang.Float" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield Float.valueOf(this.getFloat());
            }
            case "java.lang.Double" -> {
                if (this.isNull()) {
                    yield null;
                }
                yield this.getDouble();
            }
            case "java.math.BigDecimal" -> this.getBigDecimal();
            case "java.math.BigInteger" -> this.getBigInteger();
            case "java.lang.String" -> this.getString();
            case "[B" -> this.getBytes();
            case "java.sql.Date" -> this.getDate();
            case "java.time.LocalDate" -> this.getLocalDate();
            case "java.util.Date", "java.sql.Timestamp" -> this.getTimestamp();
            case "java.time.LocalDateTime" -> this.getLocalDateTime();
            case "java.sql.Time" -> this.getTime();
            case "java.time.LocalTime" -> this.getLocalTime();
            case "java.util.Calendar" -> {
                if (this.isNull()) {
                    yield null;
                }
                Timestamp timestamp = this.getTimestamp();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(timestamp.getTime());
                yield calendar;
            }
            case "java.time.OffsetTime" -> this.getOffsetTime();
            case "java.time.OffsetDateTime" -> this.getOffsetDateTime();
            case "java.time.ZonedDateTime" -> this.getZonedDateTime();
            case "java.sql.Clob", "java.sql.NClob" -> this.getClob();
            case "java.sql.Blob", "org.firebirdsql.jdbc.FirebirdBlob" -> this.getBlob();
            case "java.io.InputStream" -> this.getBinaryStream();
            case "java.io.Reader" -> this.getCharacterStream();
            case "java.sql.RowId", "org.firebirdsql.jdbc.FBRowId" -> this.getRowId();
            case "org.firebirdsql.extern.decimal.Decimal" -> this.getDecimal();
            case "org.firebirdsql.extern.decimal.Decimal32" -> this.getDecimal(Decimal32.class);
            case "org.firebirdsql.extern.decimal.Decimal64" -> this.getDecimal(Decimal64.class);
            case "org.firebirdsql.extern.decimal.Decimal128" -> this.getDecimal(Decimal128.class);
            default -> throw this.invalidGetConversion(type);
        };
        return type.cast(result);
    }

    private @NonNull String getJdbcTypeName() {
        return FBField.getJdbcTypeName(this.requiredType);
    }

    static @NonNull String getJdbcTypeName(int jdbcType) {
        if (jdbcType == -6001) {
            return "DECFLOAT";
        }
        try {
            return JDBCType.valueOf(jdbcType).name();
        }
        catch (IllegalArgumentException e) {
            return String.valueOf(jdbcType);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        throw this.invalidGetConversion(InputStream.class);
    }

    public Reader getCharacterStream() throws SQLException {
        InputStream is = this.getBinaryStream();
        return is != null ? this.getDatatypeCoder().createReader(is) : null;
    }

    public byte[] getBytes() throws SQLException {
        throw this.invalidGetConversion("byte[]");
    }

    public Blob getBlob() throws SQLException {
        throw this.invalidGetConversion(Blob.class);
    }

    public Date getDate() throws SQLException {
        return this.getDate(null);
    }

    public Date getDate(Calendar cal) throws SQLException {
        return this.convertForGet(this.getLocalDate(), v -> LegacyDatetimeConversions.toDate(v, cal), Date.class);
    }

    LocalDate getLocalDate() throws SQLException {
        throw this.invalidGetConversion(LocalDate.class);
    }

    public Time getTime() throws SQLException {
        return this.getTime(null);
    }

    public Time getTime(Calendar cal) throws SQLException {
        return this.convertForGet(this.getLocalTime(), v -> LegacyDatetimeConversions.toTime(v, cal), Time.class);
    }

    LocalTime getLocalTime() throws SQLException {
        throw this.invalidGetConversion(LocalTime.class);
    }

    public Timestamp getTimestamp() throws SQLException {
        return this.getTimestamp(null);
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        return this.convertForGet(this.getLocalDateTime(), v -> LegacyDatetimeConversions.toTimestamp(v, cal), Timestamp.class);
    }

    LocalDateTime getLocalDateTime() throws SQLException {
        throw this.invalidGetConversion(LocalDateTime.class);
    }

    OffsetTime getOffsetTime() throws SQLException {
        throw this.invalidGetConversion(OffsetTime.class);
    }

    OffsetDateTime getOffsetDateTime() throws SQLException {
        throw this.invalidGetConversion(OffsetDateTime.class);
    }

    ZonedDateTime getZonedDateTime() throws SQLException {
        throw this.invalidGetConversion(ZonedDateTime.class);
    }

    public Ref getRef() throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    public Clob getClob() throws SQLException {
        throw this.invalidGetConversion(Clob.class);
    }

    public Array getArray() throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    public BigInteger getBigInteger() throws SQLException {
        throw this.invalidGetConversion(BigInteger.class);
    }

    public RowId getRowId() throws SQLException {
        throw this.invalidGetConversion(RowId.class);
    }

    public void setByte(byte value) throws SQLException {
        throw this.invalidSetConversion("byte");
    }

    public void setShort(short value) throws SQLException {
        throw this.invalidSetConversion("short");
    }

    public void setInteger(int value) throws SQLException {
        throw this.invalidSetConversion("int");
    }

    public void setLong(long value) throws SQLException {
        throw this.invalidSetConversion("long");
    }

    public void setFloat(float value) throws SQLException {
        throw this.invalidSetConversion("float");
    }

    public void setDouble(double value) throws SQLException {
        throw this.invalidSetConversion("double");
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        throw this.invalidSetConversion(BigDecimal.class);
    }

    public void setBoolean(boolean value) throws SQLException {
        throw this.invalidSetConversion("boolean");
    }

    public void setString(String value) throws SQLException {
        throw this.invalidSetConversion(String.class);
    }

    public void setBigInteger(BigInteger value) throws SQLException {
        throw this.invalidSetConversion(BigInteger.class);
    }

    public void setObject(Object value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        switch (value.getClass().getName()) {
            case "java.math.BigDecimal": {
                this.setBigDecimal((BigDecimal)value);
                break;
            }
            case "org.firebirdsql.jdbc.FBBlob": {
                this.setBlob((FBBlob)value);
                break;
            }
            case "org.firebirdsql.jdbc.FBClob": {
                this.setClob((FBClob)value);
                break;
            }
            case "java.lang.Boolean": {
                this.setBoolean((Boolean)value);
                break;
            }
            case "java.lang.Byte": {
                this.setByte((Byte)value);
                break;
            }
            case "[B": {
                this.setBytes((byte[])value);
                break;
            }
            case "java.sql.Date": {
                this.setDate((Date)value);
                break;
            }
            case "java.time.LocalDate": {
                this.setLocalDate((LocalDate)value);
                break;
            }
            case "java.lang.Double": {
                this.setDouble((Double)value);
                break;
            }
            case "java.lang.Float": {
                this.setFloat(((Float)value).floatValue());
                break;
            }
            case "java.lang.Integer": {
                this.setInteger((Integer)value);
                break;
            }
            case "java.lang.Long": {
                this.setLong((Long)value);
                break;
            }
            case "java.lang.Short": {
                this.setShort((Short)value);
                break;
            }
            case "java.lang.String": {
                this.setString((String)value);
                break;
            }
            case "java.sql.Time": {
                this.setTime((Time)value);
                break;
            }
            case "java.time.LocalTime": {
                this.setLocalTime((LocalTime)value);
                break;
            }
            case "java.sql.Timestamp": {
                this.setTimestamp((Timestamp)value);
                break;
            }
            case "java.time.LocalDateTime": {
                this.setLocalDateTime((LocalDateTime)value);
                break;
            }
            case "java.time.OffsetTime": {
                this.setOffsetTime((OffsetTime)value);
                break;
            }
            case "java.time.OffsetDateTime": {
                this.setOffsetDateTime((OffsetDateTime)value);
                break;
            }
            case "java.time.ZonedDateTime": {
                this.setZonedDateTime((ZonedDateTime)value);
                break;
            }
            case "java.util.Date": {
                this.setTimestamp(new Timestamp(((java.util.Date)value).getTime()));
                break;
            }
            case "java.math.BigInteger": {
                this.setBigInteger((BigInteger)value);
                break;
            }
            case "org.firebirdsql.jdbc.FBRowId": {
                this.setRowId((RowId)value);
                break;
            }
            case "org.firebirdsql.extern.decimal.Decimal32": 
            case "org.firebirdsql.extern.decimal.Decimal64": 
            case "org.firebirdsql.extern.decimal.Decimal128": {
                this.setDecimal((Decimal)value);
                break;
            }
            default: {
                this.setObjectWithInstanceOf(value);
            }
        }
    }

    public void setObject(Object value, int scaleOrLength) throws SQLException {
        if (value instanceof InputStream) {
            this.setBinaryStream((InputStream)value, scaleOrLength);
        } else if (value instanceof Reader) {
            this.setCharacterStream((Reader)value, scaleOrLength);
        } else {
            this.setObject(value);
        }
    }

    private void setObjectWithInstanceOf(Object value) throws SQLException {
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            this.setBigDecimal(bigDecimal);
        } else if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            this.setBigInteger(bigInteger);
        } else if (value instanceof RowId) {
            RowId rowId = (RowId)value;
            this.setRowId(rowId);
        } else if (value instanceof InputStream) {
            InputStream inputStream = (InputStream)value;
            this.setBinaryStream(inputStream);
        } else if (value instanceof Reader) {
            Reader reader = (Reader)value;
            this.setCharacterStream(reader);
        } else if (value instanceof FBClob) {
            FBClob fbClob = (FBClob)value;
            this.setClob(fbClob);
        } else if (value instanceof Clob) {
            Clob clob = (Clob)value;
            this.setCharacterStream(clob.getCharacterStream());
        } else if (value instanceof FBBlob) {
            FBBlob fbBlob = (FBBlob)value;
            this.setBlob(fbBlob);
        } else if (value instanceof Blob) {
            Blob blob = (Blob)value;
            this.setBinaryStream(blob.getBinaryStream());
        } else if (value instanceof Date) {
            Date date = (Date)value;
            this.setDate(date);
        } else if (value instanceof Time) {
            Time time = (Time)value;
            this.setTime(time);
        } else if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            this.setTimestamp(timestamp);
        } else if (value instanceof java.util.Date) {
            java.util.Date juDate = (java.util.Date)value;
            this.setTimestamp(new Timestamp(juDate.getTime()));
        } else if (value instanceof Decimal) {
            Decimal decimal = (Decimal)value;
            this.setDecimal(decimal);
        } else {
            throw this.invalidSetConversion(value.getClass());
        }
    }

    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        throw this.invalidSetConversion(InputStream.class);
    }

    public final void setBinaryStream(InputStream in, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLNonTransientException("Length needs to be >= 0, was: " + length);
        }
        this.setBinaryStreamInternal(in, length);
    }

    public final void setBinaryStream(InputStream in) throws SQLException {
        this.setBinaryStreamInternal(in, -1L);
    }

    public final void setBinaryStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, (long)length);
    }

    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        throw this.invalidSetConversion(Reader.class);
    }

    public final void setCharacterStream(Reader in, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLNonTransientException("Length needs to be >= 0, was: " + length);
        }
        this.setCharacterStreamInternal(in, length);
    }

    public final void setCharacterStream(Reader in) throws SQLException {
        this.setCharacterStreamInternal(in, -1L);
    }

    public final void setCharacterStream(Reader in, int length) throws SQLException {
        this.setCharacterStream(in, (long)length);
    }

    public void setBytes(byte[] value) throws SQLException {
        throw this.invalidSetConversion("byte[]");
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        this.setLocalDate(this.convertForSet(value, v -> LegacyDatetimeConversions.toLocalDate(v, cal), Date.class));
    }

    public void setDate(Date value) throws SQLException {
        this.setDate(value, null);
    }

    void setLocalDate(LocalDate value) throws SQLException {
        throw this.invalidSetConversion(LocalDate.class);
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        this.setLocalTime(this.convertForSet(value, v -> LegacyDatetimeConversions.toLocalTime(v, cal), Time.class));
    }

    public void setTime(Time value) throws SQLException {
        this.setTime(value, null);
    }

    void setLocalTime(LocalTime value) throws SQLException {
        throw this.invalidSetConversion(LocalTime.class);
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        this.setLocalDateTime(this.convertForSet(value, v -> LegacyDatetimeConversions.toLocalDateTime(v, cal), Timestamp.class));
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        this.setTimestamp(value, null);
    }

    void setLocalDateTime(LocalDateTime value) throws SQLException {
        throw this.invalidSetConversion(LocalDateTime.class);
    }

    void setOffsetTime(OffsetTime value) throws SQLException {
        throw this.invalidSetConversion(OffsetTime.class);
    }

    void setOffsetDateTime(OffsetDateTime value) throws SQLException {
        throw this.invalidSetConversion(OffsetDateTime.class);
    }

    void setZonedDateTime(ZonedDateTime value) throws SQLException {
        throw this.invalidSetConversion(ZonedDateTime.class);
    }

    public void setBlob(FBBlob blob) throws SQLException {
        throw this.invalidSetConversion(Blob.class);
    }

    public void setBlob(Blob blob) throws SQLException {
        throw this.invalidSetConversion(Blob.class);
    }

    @NonNull FBBlob createBlob() throws SQLException {
        throw this.invalidSetConversion(Blob.class);
    }

    public void setClob(FBClob clob) throws SQLException {
        throw this.invalidSetConversion(Clob.class);
    }

    public void setClob(Clob clob) throws SQLException {
        throw this.invalidSetConversion(Clob.class);
    }

    final @NonNull FBClob createClob() throws SQLException {
        return new FBClob(this.createBlob());
    }

    public void setRowId(RowId rowId) throws SQLException {
        throw this.invalidSetConversion(RowId.class);
    }

    final boolean setWhenNull(Object value) {
        if (value != null) {
            return false;
        }
        this.setNull();
        return true;
    }

    public Decimal<?> getDecimal() throws SQLException {
        return this.convertForGet(this.getBigDecimal(), v -> Decimal128.valueOf(v, OverflowHandling.THROW_EXCEPTION), Decimal128.class, arg_0 -> FBField.lambda$getDecimal$7("value %s out of range", arg_0));
    }

    public final <D extends Decimal<D>> D getDecimal(@NonNull Class<D> targetType) throws SQLException {
        return (D)this.convertForGet(this.getDecimal(), v -> v.toDecimal(targetType, OverflowHandling.THROW_EXCEPTION), targetType, arg_0 -> FBField.lambda$getDecimal$9("value %s out of range", arg_0));
    }

    public void setDecimal(Decimal<?> decimal) throws SQLException {
        this.setBigDecimal(this.convertForSet(decimal, v -> decimal.toBigDecimal(), Decimal.class, arg_0 -> FBField.lambda$setDecimal$11("value %s out of range", arg_0)));
    }

    @NullMarked
    final SQLException invalidGetConversion(Class<?> requestedType) {
        return this.invalidGetConversion(requestedType, null, null);
    }

    @NullMarked
    final SQLException invalidGetConversion(Class<?> requestedType, @Nullable String reason) {
        return this.invalidGetConversion(requestedType, reason, null);
    }

    @NullMarked
    final SQLException invalidGetConversion(Class<?> requestedType, @Nullable String reason, @Nullable Throwable cause) {
        return this.invalidGetConversion(requestedType.getName(), reason, cause);
    }

    @NullMarked
    final SQLException invalidGetConversion(String requestedTypeName) {
        return this.invalidGetConversion(requestedTypeName, null, null);
    }

    @NullMarked
    final SQLException invalidGetConversion(String requestedTypeName, @Nullable String reason) {
        return this.invalidGetConversion(requestedTypeName, reason, null);
    }

    @NullMarked
    final SQLException invalidGetConversion(String requestedTypeName, @Nullable String reason, @Nullable Throwable cause) {
        Object message = String.format("Unsupported get conversion requested for field %s at index %d (JDBC type %s), target type: %s", this.getAlias(), this.fieldDescriptor.getPosition() + 1, this.getJdbcTypeName(), requestedTypeName);
        if (reason != null) {
            message = (String)message + ", reason: " + reason;
        }
        return cause != null ? new TypeConversionException((String)message, cause) : new TypeConversionException((String)message);
    }

    @NullMarked
    final SQLException invalidSetConversion(Class<?> sourceType) {
        return this.invalidSetConversion(sourceType, null, null);
    }

    @NullMarked
    final SQLException invalidSetConversion(Class<?> sourceType, @Nullable Throwable cause) {
        return this.invalidSetConversion(sourceType, null, cause);
    }

    @NullMarked
    final SQLException invalidSetConversion(Class<?> sourceType, @Nullable String reason) {
        return this.invalidSetConversion(sourceType, reason, null);
    }

    @NullMarked
    final SQLException invalidSetConversion(Class<?> sourceType, @Nullable String reason, @Nullable Throwable cause) {
        return this.invalidSetConversion(sourceType.getName(), reason, cause);
    }

    @NullMarked
    final SQLException invalidSetConversion(String sourceTypeName) {
        return this.invalidSetConversion(sourceTypeName, null, null);
    }

    @NullMarked
    final SQLException invalidSetConversion(String sourceTypeName, @Nullable String reason) {
        return this.invalidSetConversion(sourceTypeName, reason, null);
    }

    @NullMarked
    final SQLException invalidSetConversion(String sourceTypeName, @Nullable String reason, @Nullable Throwable cause) {
        Object message = "Unsupported set conversion requested for field %s at index %d (JDBC type %s), source type: %s".formatted(this.getAlias(), this.fieldDescriptor.getPosition() + 1, this.getJdbcTypeName(), sourceTypeName);
        if (reason != null) {
            message = (String)message + ", reason: " + reason;
        }
        return cause != null ? new TypeConversionException((String)message, cause) : new TypeConversionException((String)message);
    }

    final <T> T fromString(String value, @NonNull Function<String, T> converter) throws SQLException {
        return this.convertForSet(value, converter.compose(String::trim), String.class);
    }

    final <S, T> T convertForSet(S value, @NonNull Function<S, T> converter, @NonNull Class<? extends S> sourceType) throws SQLException {
        return this.convertForSet(value, converter, sourceType, String::valueOf);
    }

    final <S, T> T convertForSet(S value, @NonNull Function<S, T> converter, @NonNull Class<? extends S> sourceType, @NonNull Function<S, String> reasonFactory) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return converter.apply(value);
        }
        catch (RuntimeException e) {
            throw this.invalidSetConversion(sourceType, reasonFactory.apply(value), (Throwable)e);
        }
    }

    final <S, T> T convertForGet(S value, @NonNull Function<S, T> converter, @NonNull Class<? extends T> requestedType) throws SQLException {
        return this.convertForGet(value, converter, requestedType, String::valueOf);
    }

    final <S, T> T convertForGet(S value, @NonNull Function<S, T> converter, @NonNull Class<? extends T> requestedType, @NonNull Function<S, String> reasonFactory) throws SQLException {
        if (value == null) {
            return null;
        }
        try {
            return converter.apply(value);
        }
        catch (RuntimeException e) {
            throw this.invalidGetConversion(requestedType, reasonFactory.apply(value), (Throwable)e);
        }
    }

    private static /* synthetic */ String lambda$setDecimal$11(String rec$, Object xva$0) {
        return "value %s out of range".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getDecimal$9(String rec$, Object xva$0) {
        return "value %s out of range".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$getDecimal$7(String rec$, Object xva$0) {
        return "value %s out of range".formatted(xva$0);
    }
}

