/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Base64;
import java.util.HexFormat;
import java.util.Objects;

public final class ByteArrayHelper {
    private static final HexFormat HEX_FORMAT = HexFormat.of().withUpperCase();
    private static final byte[] EMPTY = new byte[0];

    private ByteArrayHelper() {
    }

    public static String toHexString(byte[] bytes) {
        return HEX_FORMAT.formatHex(bytes);
    }

    public static byte[] fromHexString(String hexString) {
        return HEX_FORMAT.parseHex(hexString);
    }

    public static byte[] fromBase64String(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static byte[] fromBase64urlString(String base64url) {
        return Base64.getUrlDecoder().decode(base64url);
    }

    public static int indexOf(byte[] array, byte b) {
        for (int idx = 0; idx < array.length; ++idx) {
            if (array[idx] != b) continue;
            return idx;
        }
        return -1;
    }

    public static byte[] emptyByteArray() {
        return EMPTY;
    }

    public static void validateBufferLength(byte[] b, int off, int len) throws SQLException {
        try {
            Objects.checkFromIndexSize(off, len, b.length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLNonTransientException(e.toString(), "HY090");
        }
    }
}

