/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TransactionState {
    ACTIVE{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.of(PREPARING, COMMITTING, ROLLING_BACK);
        }
    }
    ,
    PREPARING{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.of(PREPARED);
        }
    }
    ,
    PREPARED{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.of(COMMITTING, ROLLING_BACK);
        }
    }
    ,
    COMMITTING{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.of(COMMITTED, ROLLING_BACK);
        }
    }
    ,
    COMMITTED{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.noneOf(TransactionState.class);
        }
    }
    ,
    ROLLING_BACK{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.of(ROLLED_BACK);
        }
    }
    ,
    ROLLED_BACK{

        @Override
        Set<TransactionState> createValidTransitionSet() {
            return EnumSet.noneOf(TransactionState.class);
        }
    };

    private Set<TransactionState> validTransitions;

    public final boolean isValidTransition(TransactionState toState) {
        return this.validTransitionSet().contains((Object)toState);
    }

    public final Set<TransactionState> validTransitionSet() {
        if (this.validTransitions == null) {
            this.validTransitions = Collections.unmodifiableSet(this.createValidTransitionSet());
        }
        return this.validTransitions;
    }

    abstract Set<TransactionState> createValidTransitionSet();
}

