/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorageFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Array;

abstract class SequenceFromStackNode
extends PNodeWithContext {
    @CompilerDirectives.CompilationFinal
    protected final int length;
    @CompilerDirectives.CompilationFinal
    protected SequenceStorage.StorageType type = SequenceStorage.StorageType.Uninitialized;

    SequenceFromStackNode(int length) {
        this.length = length;
    }

    @ExplodeLoop
    protected SequenceStorage createSequenceStorageForDirect(VirtualFrame frame, int start, int stop) {
        SequenceStorage storage;
        CompilerAsserts.partialEvaluationConstant((int)start);
        CompilerAsserts.partialEvaluationConstant((int)stop);
        if (this.type == SequenceStorage.StorageType.Uninitialized) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            try {
                Object[] elements = new Object[this.length];
                int j = 0;
                int i = start;
                while (i < stop) {
                    elements[j] = frame.getObject(i);
                    frame.setObject(i, null);
                    ++i;
                    ++j;
                }
                storage = SequenceStorageFactory.createStorage(elements);
                this.type = ((SequenceStorage)storage).getElementType();
            }
            catch (Throwable t) {
                this.type = SequenceStorage.StorageType.Generic;
                throw t;
            }
        }
        int j = 0;
        Object[] array = null;
        try {
            switch (this.type) {
                case Empty: {
                    assert (this.length == 0);
                    storage = EmptySequenceStorage.INSTANCE;
                    break;
                }
                case Boolean: {
                    boolean[] elements;
                    array = elements = new boolean[this.getCapacityEstimate()];
                    int i = start;
                    while (i < stop) {
                        elements[j] = SequenceFromStackNode.castBoolean(frame.getObject(i));
                        frame.setObject(i, null);
                        ++i;
                        ++j;
                    }
                    storage = new BoolSequenceStorage(elements, this.length);
                    break;
                }
                case Byte: {
                    byte[] elements = new byte[this.getCapacityEstimate()];
                    array = elements;
                    int i = start;
                    while (i < stop) {
                        int element = SequenceFromStackNode.castInt(frame.getObject(i));
                        if (element > 127 || element < -128) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            throw new UnexpectedResultException((Object)element);
                        }
                        elements[j] = (byte)element;
                        frame.setObject(i, null);
                        ++i;
                        ++j;
                    }
                    storage = new ByteSequenceStorage(elements, this.length);
                    break;
                }
                case Int: {
                    int[] elements = new int[this.getCapacityEstimate()];
                    array = elements;
                    int i = start;
                    while (i < stop) {
                        elements[j] = SequenceFromStackNode.castInt(frame.getObject(i));
                        frame.setObject(i, null);
                        ++i;
                        ++j;
                    }
                    storage = new IntSequenceStorage(elements, this.length);
                    break;
                }
                case Long: {
                    long[] elements = new long[this.getCapacityEstimate()];
                    array = elements;
                    int i = start;
                    while (i < stop) {
                        elements[j] = SequenceFromStackNode.castLong(frame.getObject(i));
                        frame.setObject(i, null);
                        ++i;
                        ++j;
                    }
                    storage = new LongSequenceStorage(elements, this.length);
                    break;
                }
                case Double: {
                    double[] elements = new double[this.getCapacityEstimate()];
                    array = elements;
                    int i = start;
                    while (i < stop) {
                        elements[j] = SequenceFromStackNode.castDouble(frame.getObject(i));
                        frame.setObject(i, null);
                        ++i;
                        ++j;
                    }
                    storage = new DoubleSequenceStorage(elements, this.length);
                    break;
                }
                case Generic: {
                    Object[] elements = new Object[this.getCapacityEstimate()];
                    int i = start;
                    while (i < stop) {
                        elements[j] = frame.getObject(i);
                        frame.setObject(i, null);
                        ++i;
                        ++j;
                    }
                    storage = new ObjectSequenceStorage(elements, this.length);
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new RuntimeException("unexpected state");
                }
            }
        }
        catch (UnexpectedResultException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            storage = this.genericFallback(frame, array, start, stop, j, e.getResult());
        }
        return storage;
    }

    private SequenceStorage genericFallback(VirtualFrame frame, Object array, int start, int stop, int count, Object result) {
        int j;
        this.type = SequenceStorage.StorageType.Generic;
        Object[] elements = new Object[this.getCapacityEstimate()];
        for (j = 0; j < count; ++j) {
            elements[j] = Array.get(array, j);
        }
        elements[j++] = result;
        int i = start + count + 1;
        while (i < stop) {
            elements[j] = frame.getObject(i);
            frame.setObject(i, null);
            ++i;
            ++j;
        }
        return new ObjectSequenceStorage(elements, this.length);
    }

    private static int castInt(Object o) throws UnexpectedResultException {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new UnexpectedResultException(o);
    }

    private static long castLong(Object o) throws UnexpectedResultException {
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new UnexpectedResultException(o);
    }

    private static double castDouble(Object o) throws UnexpectedResultException {
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new UnexpectedResultException(o);
    }

    private static boolean castBoolean(Object o) throws UnexpectedResultException {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new UnexpectedResultException(o);
    }

    protected abstract int getCapacityEstimate();

    public static abstract class TupleFromStackNode
    extends SequenceFromStackNode {
        public TupleFromStackNode(int length) {
            super(length);
        }

        public abstract SequenceStorage execute(Frame var1, int var2, int var3);

        @Specialization
        SequenceStorage doIt(VirtualFrame virtualFrame, int start, int stop) {
            return this.createSequenceStorageForDirect(virtualFrame, start, stop);
        }

        @Override
        protected int getCapacityEstimate() {
            return this.length;
        }
    }

    public static abstract class ListFromStackNode
    extends SequenceFromStackNode
    implements PList.ListOrigin {
        private static final TruffleLogger LOGGER = PythonLanguage.getLogger(ListFromStackNode.class);
        private final PList.ListOrigin.SizeEstimate initialCapacity;

        public ListFromStackNode(int length) {
            super(length);
            this.initialCapacity = new PList.ListOrigin.SizeEstimate(length);
        }

        public abstract SequenceStorage execute(Frame var1, int var2, int var3);

        @Specialization
        SequenceStorage doIt(VirtualFrame virtualFrame, int start, int stop) {
            return this.createSequenceStorageForDirect(virtualFrame, start, stop);
        }

        @Override
        protected int getCapacityEstimate() {
            return this.initialCapacity.estimate();
        }

        @Override
        public SourceSection getSourceSection() {
            return null;
        }

        @Override
        public void reportUpdatedCapacity(ArrayBasedSequenceStorage newStore) {
            if (CompilerDirectives.inInterpreter() && PythonContext.get(this).getOption(PythonOptions.OverallocateLiteralLists).booleanValue()) {
                if (newStore.getCapacity() > this.initialCapacity.estimate()) {
                    this.initialCapacity.updateFrom(newStore.getCapacity());
                    LOGGER.finest(() -> {
                        SourceSection encapsulatingSourceSection = this.getEncapsulatingSourceSection();
                        String sourceSection = encapsulatingSourceSection == null ? "<unavailable source>" : encapsulatingSourceSection.toString();
                        return String.format("Updating list size estimate at %s. Observed capacity: %d, new estimate: %d", sourceSection, newStore.getCapacity(), this.initialCapacity.estimate());
                    });
                }
                if (newStore.getElementType().generalizesFrom(this.type)) {
                    this.type = newStore.getElementType();
                    LOGGER.finest(() -> {
                        SourceSection encapsulatingSourceSection = this.getEncapsulatingSourceSection();
                        String sourceSection = encapsulatingSourceSection == null ? "<unavailable source>" : encapsulatingSourceSection.toString();
                        return String.format("Updating list type estimate at %s. New type: %s", sourceSection, this.type.name());
                    });
                }
            }
        }
    }
}

