/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.generator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNode;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.generator.ThrowData;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.GeneratorReturnException;
import com.oracle.graal.python.nodes.bytecode.GeneratorYieldResult;
import com.oracle.graal.python.nodes.call.CallDispatchers;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.bytecode.ContinuationResult;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCoroutine, PythonBuiltinClassType.PGenerator})
public final class CommonGeneratorBuiltins
extends PythonBuiltins {
    private static Object[] prepareArguments(PGenerator self) {
        Object[] generatorArguments = self.getArguments();
        Object[] arguments = new Object[generatorArguments.length];
        PythonUtils.arraycopy(generatorArguments, 0, arguments, 0, arguments.length);
        return arguments;
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CommonGeneratorBuiltinsFactory.getFactories();
    }

    private static void checkResumable(Node inliningTarget, PGenerator self, PRaiseNode raiseNode) {
        if (self.isFinished()) {
            if (self.isAsyncGen()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.StopAsyncIteration);
            }
            if (self.isCoroutine()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_CORO);
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.StopIteration);
        }
        if (self.isRunning()) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object close(VirtualFrame frame, PGenerator self, @Bind Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isGeneratorExit, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIteration, @Cached ResumeGeneratorNode resumeGeneratorNode, @Cached InlinedConditionProfile isStartedPorfile, @Cached PRaiseNode raiseNode) {
            if (self.isRunning()) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
            }
            if (isStartedPorfile.profile(inliningTarget, self.isStarted() && !self.isFinished())) {
                PBaseException pythonException = PFactory.createBaseException(PythonLanguage.get(inliningTarget), PythonBuiltinClassType.GeneratorExit);
                boolean withJavaStacktrace = PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(inliningTarget));
                try {
                    resumeGeneratorNode.execute(frame, inliningTarget, self, new ThrowData(pythonException, withJavaStacktrace));
                }
                catch (IteratorExhausted e) {
                    PNone pNone = PNone.NONE;
                    return pNone;
                }
                catch (PException pe) {
                    if (isGeneratorExit.profileException(inliningTarget, pe, PythonBuiltinClassType.GeneratorExit) || isStopIteration.profileException(inliningTarget, pe, PythonErrorType.StopIteration)) {
                        PNone pNone = PNone.NONE;
                        return pNone;
                    }
                    throw pe;
                }
                finally {
                    self.markAsFinished();
                }
                throw raiseNode.raise(inliningTarget, PythonErrorType.RuntimeError, ErrorMessages.GENERATOR_IGNORED_EXIT);
            }
            self.markAsFinished();
            return PNone.NONE;
        }
    }

    @Builtin(name="throw", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class ThrowNode
    extends PythonQuaternaryBuiltinNode {
        @Specialization
        static Object sendThrow(VirtualFrame frame, PGenerator self, Object typ, Object val, Object tb, @Bind Node inliningTarget, @Cached InlinedConditionProfile hasTbProfile, @Cached InlinedConditionProfile hasValProfile, @Cached InlinedConditionProfile startedProfile, @Cached InlinedBranchProfile invalidTbProfile, @Cached InlinedBranchProfile runningProfile, @Cached PrepareExceptionNode prepareExceptionNode, @Cached ResumeGeneratorNode resumeGeneratorNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached ExceptionNodes.SetTracebackNode setTracebackNode, @Cached ExceptionNodes.SetContextNode setContextNode, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode raiseNode) {
            PTraceback existingTraceback;
            boolean hasTb = hasTbProfile.profile(inliningTarget, !(tb instanceof PNone));
            boolean hasVal = hasValProfile.profile(inliningTarget, !(val instanceof PNone));
            if (hasVal || hasTb) {
                warnNode.warnEx((Frame)frame, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.TYPE_EXC_TB_OF_THROW_IS_DEPRECATED, 1);
            }
            if (hasTb && !(tb instanceof PTraceback)) {
                invalidTbProfile.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.THROW_THIRD_ARG_MUST_BE_TRACEBACK);
            }
            if (self.isRunning()) {
                runningProfile.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.GENERATOR_ALREADY_EXECUTING);
            }
            Object instance = prepareExceptionNode.execute(frame, typ, val);
            if (hasTb) {
                setTracebackNode.execute(inliningTarget, instance, tb);
            }
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            setContextNode.execute(inliningTarget, instance, PNone.NONE);
            if (self.isCoroutine() && self.isFinished()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CANNOT_REUSE_CORO);
            }
            if (startedProfile.profile(inliningTarget, self.isStarted() && !self.isFinished())) {
                try {
                    return resumeGeneratorNode.execute(frame, inliningTarget, self, new ThrowData(instance, PythonOptions.isPExceptionWithJavaStacktrace(language)));
                }
                catch (IteratorExhausted e) {
                    throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.StopIteration);
                }
            }
            self.markAsFinished();
            RootNode location = self.getCurrentCallTarget().getRootNode();
            MaterializedFrame generatorFrame = PythonOptions.ENABLE_BYTECODE_DSL_INTERPRETER ? Truffle.getRuntime().createMaterializedFrame(PArguments.create(), self.getRootNode().getFrameDescriptor()) : PArguments.getGeneratorFrame(self.getArguments());
            PFrame pFrame = MaterializeFrameNode.materializeGeneratorFrame((Node)location, generatorFrame, PFrame.Reference.EMPTY);
            FrameInfo info = (FrameInfo)generatorFrame.getFrameDescriptor().getInfo();
            pFrame.setLine(info.getFirstLineNumber());
            Object existingTracebackObj = getTracebackNode.execute(inliningTarget, instance);
            PTraceback newTraceback = PFactory.createTraceback(language, pFrame, pFrame.getLine(), existingTracebackObj instanceof PTraceback ? (existingTraceback = (PTraceback)existingTracebackObj) : null);
            setTracebackNode.execute(inliningTarget, instance, newTraceback);
            throw PException.fromObject(instance, inliningTarget, PythonOptions.isPExceptionWithJavaStacktrace(language));
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object send(VirtualFrame frame, PGenerator self, Object value, @Bind Node inliningTarget, @Cached ResumeGeneratorNode resumeGeneratorNode, @Cached PRaiseNode raiseNode) {
            CommonGeneratorBuiltins.checkResumable(inliningTarget, self, raiseNode);
            if (!self.isStarted() && value != PNone.NONE) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SEND_NON_NONE_TO_UNSTARTED_GENERATOR);
            }
            try {
                return resumeGeneratorNode.execute(frame, inliningTarget, self, value);
            }
            catch (IteratorExhausted e) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.StopIteration);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class, PythonOptions.class, CallDispatchers.class})
    static abstract class ResumeGeneratorNode
    extends Node {
        ResumeGeneratorNode() {
        }

        public abstract Object execute(VirtualFrame var1, Node var2, PGenerator var3, Object var4);

        @Specialization(guards={"!isBytecodeDSLInterpreter()", "sameCallTarget(self.getCurrentCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object cached(VirtualFrame frame, Node inliningTarget, PGenerator self, Object sendValue, @Cached(parameters={"self.getCurrentCallTarget()"}, inline=false) DirectCallNode callNode, @Cached.Exclusive @Cached CallDispatchers.SimpleDirectInvokeNode invoke, @Cached.Exclusive @Cached InlinedBranchProfile returnProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            GeneratorYieldResult result;
            self.setRunning(true);
            Object[] arguments = CommonGeneratorBuiltins.prepareArguments(self);
            if (sendValue != null) {
                PArguments.setSpecialArgument(arguments, sendValue);
            }
            try {
                result = (GeneratorYieldResult)invoke.execute(frame, inliningTarget, callNode, arguments);
            }
            catch (PException e) {
                throw ResumeGeneratorNode.handleException(self, inliningTarget, errorProfile, raiseNode, e);
            }
            catch (GeneratorReturnException e) {
                returnProfile.enter(inliningTarget);
                throw ResumeGeneratorNode.handleReturn(inliningTarget, self, e.value);
            }
            finally {
                self.setRunning(false);
            }
            return ResumeGeneratorNode.handleResult(inliningTarget, self, result);
        }

        @Specialization(guards={"isBytecodeDSLInterpreter()", "sameCallTarget(self.getCurrentCallTarget(), callNode)"}, limit="getCallSiteInlineCacheMaxDepth()")
        static Object cachedBytecodeDSL(VirtualFrame frame, Node inliningTarget, PGenerator self, Object sendValue, @Cached(parameters={"self.getCurrentCallTarget()"}, inline=false) DirectCallNode callNode, @Cached.Exclusive @Cached CallDispatchers.SimpleDirectInvokeNode invoke, @Cached(value="self.getContinuation() == null") boolean firstCall, @Cached.Exclusive @Cached InlinedBranchProfile returnProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object generatorResult;
            ContinuationResult continuation;
            self.setRunning(true);
            try {
                continuation = self.getContinuation();
                Object[] arguments = firstCall ? CommonGeneratorBuiltins.prepareArguments(self) : new Object[]{continuation.getFrame(), sendValue};
                generatorResult = invoke.execute(frame, inliningTarget, callNode, arguments);
            }
            catch (PException e) {
                throw ResumeGeneratorNode.handleException(self, inliningTarget, errorProfile, raiseNode, e);
            }
            finally {
                self.setRunning(false);
            }
            if (generatorResult instanceof ContinuationResult) {
                continuation = (ContinuationResult)generatorResult;
                return ResumeGeneratorNode.handleResult(inliningTarget, self, continuation);
            }
            returnProfile.enter(inliningTarget);
            throw ResumeGeneratorNode.handleReturn(inliningTarget, self, generatorResult);
        }

        @Specialization(replaces={"cached"}, guards={"!isBytecodeDSLInterpreter()"})
        @ReportPolymorphism.Megamorphic
        static Object generic(VirtualFrame frame, Node inliningTarget, PGenerator self, Object sendValue, @Cached.Exclusive @Cached CallDispatchers.SimpleIndirectInvokeNode invoke, @Cached.Exclusive @Cached InlinedBranchProfile returnProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            GeneratorYieldResult result;
            self.setRunning(true);
            Object[] arguments = CommonGeneratorBuiltins.prepareArguments(self);
            if (sendValue != null) {
                PArguments.setSpecialArgument(arguments, sendValue);
            }
            try {
                result = (GeneratorYieldResult)invoke.execute((Frame)frame, inliningTarget, self.getCurrentCallTarget(), arguments);
            }
            catch (PException e) {
                throw ResumeGeneratorNode.handleException(self, inliningTarget, errorProfile, raiseNode, e);
            }
            catch (GeneratorReturnException e) {
                returnProfile.enter(inliningTarget);
                throw ResumeGeneratorNode.handleReturn(inliningTarget, self, e.value);
            }
            finally {
                self.setRunning(false);
            }
            return ResumeGeneratorNode.handleResult(inliningTarget, self, result);
        }

        @Specialization(replaces={"cachedBytecodeDSL"}, guards={"isBytecodeDSLInterpreter()"})
        @ReportPolymorphism.Megamorphic
        static Object genericBytecodeDSL(VirtualFrame frame, Node inliningTarget, PGenerator self, Object sendValue, @Cached.Exclusive @Cached CallDispatchers.SimpleIndirectInvokeNode invoke, @Cached.Exclusive @Cached InlinedConditionProfile firstInvocationProfile, @Cached.Exclusive @Cached InlinedBranchProfile returnProfile, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            Object generatorResult;
            ContinuationResult continuation;
            self.setRunning(true);
            try {
                continuation = self.getContinuation();
                Object[] arguments = firstInvocationProfile.profile(inliningTarget, continuation == null) ? CommonGeneratorBuiltins.prepareArguments(self) : new Object[]{continuation.getFrame(), sendValue};
                generatorResult = invoke.execute((Frame)frame, inliningTarget, self.getCurrentCallTarget(), arguments);
            }
            catch (PException e) {
                throw ResumeGeneratorNode.handleException(self, inliningTarget, errorProfile, raiseNode, e);
            }
            finally {
                self.setRunning(false);
            }
            if (generatorResult instanceof ContinuationResult) {
                continuation = (ContinuationResult)generatorResult;
                return ResumeGeneratorNode.handleResult(inliningTarget, self, continuation);
            }
            returnProfile.enter(inliningTarget);
            throw ResumeGeneratorNode.handleReturn(inliningTarget, self, generatorResult);
        }

        private static PException handleException(PGenerator self, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile, PRaiseNode raiseNode, PException e) {
            self.markAsFinished();
            if (self.isAsyncGen() && profile.profileException(inliningTarget, e, PythonBuiltinClassType.StopAsyncIteration)) {
                throw raiseNode.raiseWithCause(inliningTarget, PythonErrorType.RuntimeError, e, ErrorMessages.ASYNCGEN_RAISED_ASYNCSTOPITER);
            }
            e.expectStopIteration(inliningTarget, profile);
            throw raiseNode.raiseWithCause(inliningTarget, PythonErrorType.RuntimeError, e, ErrorMessages.GENERATOR_RAISED_STOPITER);
        }

        private static Object handleResult(Node node, PGenerator self, Object result) {
            return self.handleResult(PythonLanguage.get(node), result);
        }

        private static PException handleReturn(Node inliningTarget, PGenerator self, Object returnValue) {
            self.markAsFinished();
            if (self.isAsyncGen()) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.StopAsyncIteration);
            }
            if (returnValue != PNone.NONE) {
                throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.StopIteration, new Object[]{returnValue});
            }
            throw TpSlotIterNext.TpIterNextBuiltin.iteratorExhausted();
        }
    }
}

