/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.bytecode;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.bytecode.BytecodeLocation;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class)
final class DefaultBytecodeStackTraceElement
implements TruffleObject {
    private final TruffleStackTraceElement stackTrace;

    DefaultBytecodeStackTraceElement(TruffleStackTraceElement stackTraceElement) {
        this.stackTrace = stackTraceElement;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasExecutableName() {
        return this.getExecutableNameImpl() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getExecutableName() {
        return this.getExecutableNameImpl();
    }

    private String getExecutableNameImpl() {
        return this.stackTrace.getTarget().getRootNode().getName();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean hasSourceLocation() {
        return this.getSourceSectionImpl() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    SourceSection getSourceLocation() throws UnsupportedMessageException {
        SourceSection sc = this.getSourceSectionImpl();
        if (sc == null) {
            throw UnsupportedMessageException.create();
        }
        return sc;
    }

    private SourceSection getSourceSectionImpl() {
        BytecodeLocation location = BytecodeLocation.get(this.stackTrace);
        if (location == null) {
            return null;
        }
        return location.ensureSourceInformation().getSourceLocation();
    }

    @ExportMessage
    boolean hasDeclaringMetaObject() {
        return false;
    }

    @ExportMessage
    Object getDeclaringMetaObject() throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }
}

