/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.Environment;
import com.ibm.db2.cmx.MonitoredData;
import com.ibm.db2.cmx.MonitoredDataCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class MonitoredDataCacheImpl
implements MonitoredDataCache {
    boolean preventNewDataFromBeingAddedToCache_ = false;
    ArrayList<MonitoredData> cachedMonitoredData_ = new ArrayList();
    HashMap<String, ArrayList<MonitoredData>> cachedMonitoredDataByDataSource_ = new HashMap();
    HashMap<String, ArrayList<MonitoredData>> cachedMonitoredDataByDispatchToken_ = new HashMap();
    HashMap<String, ArrayList<MonitoredData>> cachedMonitoredDataByDriver_ = new HashMap();

    @Override
    public ArrayList<MonitoredData> getCachedMonitoredData() {
        return this.cachedMonitoredData_;
    }

    @Override
    public ArrayList<MonitoredData> getCachedMonitoredDataByDataSource(String string) {
        return this.cachedMonitoredDataByDataSource_.get(string);
    }

    @Override
    public ArrayList<MonitoredData> getCachedMonitoredDataByDispatchToken(int n2) {
        return this.cachedMonitoredDataByDispatchToken_.get(String.valueOf(n2));
    }

    @Override
    public ArrayList<MonitoredData> getCachedMonitoredDataByDriver(String string) {
        return this.cachedMonitoredDataByDriver_.get(string);
    }

    synchronized void add(MonitoredData monitoredData) {
        if (this.preventNewDataFromBeingAddedToCache_) {
            return;
        }
        this.cachedMonitoredData_.add(monitoredData);
        String string = monitoredData.getDatasourceId();
        ArrayList<MonitoredData> arrayList = this.cachedMonitoredDataByDataSource_.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(monitoredData);
            this.cachedMonitoredDataByDataSource_.put(string, arrayList);
        } else {
            arrayList.add(monitoredData);
        }
        String string2 = monitoredData.getDriverId();
        ArrayList<MonitoredData> arrayList2 = this.cachedMonitoredDataByDataSource_.get(string2);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
            arrayList2.add(monitoredData);
            this.cachedMonitoredDataByDriver_.put(string2, arrayList2);
        } else {
            arrayList2.add(monitoredData);
        }
        String string3 = String.valueOf(monitoredData.getDispatchToken());
        ArrayList<MonitoredData> arrayList3 = this.cachedMonitoredDataByDispatchToken_.get(string3);
        if (arrayList3 == null) {
            arrayList3 = new ArrayList();
            arrayList3.add(monitoredData);
            this.cachedMonitoredDataByDispatchToken_.put(string3, arrayList3);
        } else {
            arrayList3.add(monitoredData);
        }
    }

    synchronized void reap(long l2) {
        Object object;
        Object object2;
        Set<String> set;
        Object object3;
        Object object4;
        while (this.cachedMonitoredData_ != null && this.cachedMonitoredData_.iterator().hasNext()) {
            object4 = this.cachedMonitoredData_.iterator().next();
            if (((MonitoredData)object4).reapOnNextIteration) {
                this.cachedMonitoredData_.remove(object4);
                continue;
            }
            ((MonitoredData)object4).reapOnNextIteration = true;
        }
        if (MonitoredDataCacheImpl.estimatedByteSize(this.cachedMonitoredData_) > l2) {
            Environment.getMonitor().logInMemoryLimitExceededForMonitoredData(this);
            this.preventNewDataFromBeingAddedToCache_ = true;
        } else {
            this.preventNewDataFromBeingAddedToCache_ = false;
        }
        object4 = null;
        if (this.cachedMonitoredDataByDataSource_ != null) {
            object4 = this.cachedMonitoredDataByDataSource_.keySet();
        }
        while (object4 != null && object4.iterator().hasNext()) {
            object3 = (String)object4.iterator().next();
            set = this.cachedMonitoredDataByDataSource_.get(object3);
            while (set != null && ((ArrayList)((Object)set)).iterator().hasNext()) {
                object2 = (MonitoredData)((ArrayList)((Object)set)).iterator().next();
                if (((MonitoredData)object2).reapOnNextIteration) {
                    ((ArrayList)((Object)set)).remove(object2);
                    continue;
                }
                ((MonitoredData)object2).reapOnNextIteration = true;
            }
            if (!((ArrayList)((Object)set)).isEmpty()) continue;
            this.cachedMonitoredDataByDataSource_.remove(object3);
        }
        object3 = null;
        if (this.cachedMonitoredDataByDispatchToken_ != null) {
            object3 = this.cachedMonitoredDataByDispatchToken_.keySet();
        }
        while (object3 != null && object3.iterator().hasNext()) {
            set = (String)object3.iterator().next();
            object2 = this.cachedMonitoredDataByDispatchToken_.get(set);
            while (object2 != null && ((ArrayList)object2).iterator().hasNext()) {
                object = (MonitoredData)((ArrayList)object2).iterator().next();
                if (((MonitoredData)object).reapOnNextIteration) {
                    ((ArrayList)object2).remove(object);
                    continue;
                }
                ((MonitoredData)object).reapOnNextIteration = true;
            }
            if (!((ArrayList)object2).isEmpty()) continue;
            this.cachedMonitoredDataByDispatchToken_.remove(set);
        }
        set = null;
        if (this.cachedMonitoredDataByDriver_ != null) {
            set = this.cachedMonitoredDataByDriver_.keySet();
        }
        while (set != null && set.iterator().hasNext()) {
            object2 = set.iterator().next();
            object = this.cachedMonitoredDataByDriver_.get(object2);
            while (object != null && ((ArrayList)object).iterator().hasNext()) {
                MonitoredData monitoredData = (MonitoredData)((ArrayList)object).iterator().next();
                if (monitoredData.reapOnNextIteration) {
                    ((ArrayList)object).remove(monitoredData);
                    continue;
                }
                monitoredData.reapOnNextIteration = true;
            }
            if (!((ArrayList)object).isEmpty()) continue;
            this.cachedMonitoredDataByDriver_.remove(object2);
        }
    }

    private static long estimatedByteSize(ArrayList<MonitoredData> arrayList) {
        long l2 = 0L;
        while (arrayList.iterator().hasNext()) {
            MonitoredData monitoredData = arrayList.iterator().next();
            l2 += 200L;
            if (monitoredData.getFirstConnectDataSourceAttributes() != null) {
                l2 += 600L;
                l2 += 160L;
            }
            while (monitoredData.getCompletedStatementExecutionData().iterator().hasNext()) {
                monitoredData.getCompletedStatementExecutionData().iterator().next();
                l2 += 180L;
                l2 += 192L;
                l2 += 576L;
            }
            while (monitoredData.getCompletedTransactionData().iterator().hasNext()) {
                monitoredData.getCompletedTransactionData().iterator().next();
                l2 += 360L;
                l2 += 200L;
                l2 += 288L;
                l2 += 832L;
            }
        }
        return l2;
    }
}

