/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;

public final class FinishedJobs
extends EventManager {
    private static FinishedJobs theInstance;
    private IJobProgressManagerListener listener;
    private final Set<JobTreeElement> keptjobinfos = new LinkedHashSet<JobTreeElement>();
    private final Map<JobTreeElement, Long> finishedTime = new HashMap<JobTreeElement, Long>();
    private static JobTreeElement[] emptyInfos;

    public static synchronized FinishedJobs getInstance() {
        if (theInstance == null) {
            theInstance = new FinishedJobs();
            emptyInfos = new JobTreeElement[0];
        }
        return theInstance;
    }

    private FinishedJobs() {
        this.listener = new IJobProgressManagerListener(){

            @Override
            public void addJob(JobInfo info) {
                FinishedJobs.this.removeDuplicates(info);
            }

            @Override
            public void addGroup(GroupInfo info) {
                FinishedJobs.this.removeDuplicates(info);
            }

            @Override
            public void refreshJobInfo(JobInfo info) {
                FinishedJobs.this.checkTasks(info);
            }

            @Override
            public void refreshGroup(GroupInfo info) {
            }

            @Override
            public void refreshAll() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeJob(JobInfo info) {
                if (FinishedJobs.keep(info)) {
                    Set<JobTreeElement> set = FinishedJobs.this.keptjobinfos;
                    synchronized (set) {
                        FinishedJobs.this.removeDuplicates(info);
                        FinishedJobs.this.add(info);
                    }
                }
            }

            @Override
            public void removeGroup(GroupInfo group) {
            }

            @Override
            public boolean showsDebug() {
                return false;
            }
        };
        ProgressManager.getInstance().addListener(this.listener);
    }

    static boolean keep(JobInfo info) {
        Job job = info.getJob();
        if (job != null) {
            Object prop = job.getProperty(ProgressManagerUtil.KEEP_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            prop = job.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY);
            if (prop instanceof Boolean && ((Boolean)prop).booleanValue()) {
                return true;
            }
            IStatus status = job.getResult();
            if (status != null && status.getSeverity() == 4) {
                return true;
            }
        }
        return false;
    }

    public void addListener(KeptJobsListener l) {
        this.addListenerObject(l);
    }

    public void removeListener(KeptJobsListener l) {
        this.removeListenerObject(l);
    }

    private void removeDuplicates(GroupInfo info) {
        Object[] objectArray = info.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof JobInfo) {
                this.removeDuplicates((JobInfo)child);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDuplicates(JobTreeElement info) {
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            for (JobTreeElement element : this.findJobsToRemove(info)) {
                this.remove(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(JobInfo info) {
        boolean fire = false;
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            if (!this.keptjobinfos.contains(info)) {
                this.keptjobinfos.add(info);
                long now = System.currentTimeMillis();
                this.finishedTime.put(info, now);
                GroupInfo parent = info.getParent();
                if (parent != null && !this.keptjobinfos.contains(parent)) {
                    this.keptjobinfos.add(parent);
                    this.finishedTime.put(parent, now);
                }
                fire = true;
            }
        }
        if (fire) {
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                KeptJobsListener jv = (KeptJobsListener)listener;
                jv.finished(info);
                ++n2;
            }
        }
    }

    static void disposeAction(JobTreeElement jte) {
        Object prop;
        JobInfo ji;
        Job job;
        if (jte.isJobInfo() && (job = (ji = (JobInfo)jte).getJob()) != null && (prop = job.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof ActionFactory.IWorkbenchAction) {
            ((ActionFactory.IWorkbenchAction)prop).dispose();
        }
    }

    private Iterable<JobTreeElement> findJobsToRemove(JobTreeElement info) {
        JobTreeElement[] all;
        Boolean keepOne;
        if (!info.isJobInfo()) {
            return Collections.emptyList();
        }
        Job myJob = ((JobInfo)info).getJob();
        if (myJob == null) {
            return Collections.emptyList();
        }
        Object object = myJob.getProperty(ProgressManagerUtil.KEEPONE_PROPERTY);
        if (!(object instanceof Boolean) || !(keepOne = (Boolean)object).booleanValue()) {
            return Collections.emptyList();
        }
        ArrayList<JobTreeElement> found = null;
        JobTreeElement[] jobTreeElementArray = all = this.getKeptElements();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            Job job;
            JobTreeElement jobTreeElement = jobTreeElementArray[n2];
            if (jobTreeElement != info && jobTreeElement.isJobInfo() && (job = ((JobInfo)jobTreeElement).getJob()) != null && job != myJob && job.belongsTo((Object)myJob)) {
                if (found == null) {
                    found = new ArrayList<JobTreeElement>();
                }
                found.add(jobTreeElement);
            }
            ++n2;
        }
        if (found != null) {
            return found;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTasks(JobInfo info) {
        Optional<TaskInfo> optional;
        if (FinishedJobs.keep(info) && (optional = info.getTaskInfo()).isPresent()) {
            TaskInfo tinfo = optional.get();
            boolean fire = false;
            JobInfo element = tinfo.getParent();
            Set<JobTreeElement> set = this.keptjobinfos;
            synchronized (set) {
                if (element == info && !this.keptjobinfos.contains(tinfo)) {
                    Iterable<JobTreeElement> toBeRemoved = this.findJobsToRemove(element);
                    this.keptjobinfos.add(tinfo);
                    this.finishedTime.put(tinfo, System.currentTimeMillis());
                    for (JobTreeElement jobTreeElement : toBeRemoved) {
                        this.remove(jobTreeElement);
                    }
                }
            }
            if (fire) {
                Object[] objectArray = this.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    KeptJobsListener jv = (KeptJobsListener)listener;
                    jv.finished(info);
                    ++n2;
                }
            }
        }
    }

    public void removeErrorJobs() {
        JobTreeElement[] infos;
        JobTreeElement[] jobTreeElementArray = infos = this.getKeptElements();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            JobInfo info1;
            Job job;
            JobTreeElement info = jobTreeElementArray[n2];
            if (info.isJobInfo() && (job = (info1 = (JobInfo)info).getJob()) != null && (status = job.getResult()) != null && status.getSeverity() == 4) {
                JobTreeElement topElement = info1.getParent();
                if (topElement == null) {
                    topElement = info1;
                }
                this.remove(topElement);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(JobTreeElement jte) {
        boolean fire = false;
        boolean removed = false;
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            if (this.keptjobinfos.remove(jte)) {
                JobTreeElement[] jtes;
                removed = true;
                this.finishedTime.remove(jte);
                FinishedJobs.disposeAction(jte);
                JobTreeElement[] jobTreeElementArray = jtes = this.getKeptElements();
                int n = jtes.length;
                int n2 = 0;
                while (n2 < n) {
                    JobTreeElement jobTreeElement = jobTreeElementArray[n2];
                    JobTreeElement parent = jobTreeElement.getParent();
                    if (parent != null && (parent == jte || parent.getParent() == jte)) {
                        if (this.keptjobinfos.remove(jobTreeElement)) {
                            FinishedJobs.disposeAction(jobTreeElement);
                        }
                        this.finishedTime.remove(jobTreeElement);
                    }
                    ++n2;
                }
                fire = true;
            }
        }
        if (fire) {
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object listener = objectArray[n3];
                KeptJobsListener jv = (KeptJobsListener)listener;
                jv.removed(jte);
                ++n3;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobTreeElement[] getKeptElements() {
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            if (this.keptjobinfos.isEmpty()) {
                return emptyInfos;
            }
            return this.keptjobinfos.toArray(new JobTreeElement[this.keptjobinfos.size()]);
        }
    }

    public Date getFinishDate(JobTreeElement jte) {
        Long o = this.finishedTime.get(jte);
        if (o != null) {
            return new Date(o);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKept(JobTreeElement element) {
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            return this.keptjobinfos.contains(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Set<JobTreeElement> set = this.keptjobinfos;
        synchronized (set) {
            JobTreeElement[] all;
            JobTreeElement[] jobTreeElementArray = all = this.getKeptElements();
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                JobTreeElement jobTreeElement = jobTreeElementArray[n2];
                FinishedJobs.disposeAction(jobTreeElement);
                ++n2;
            }
            this.keptjobinfos.clear();
            this.finishedTime.clear();
        }
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object listener = objectArray[n3];
            KeptJobsListener jv = (KeptJobsListener)listener;
            jv.removed(null);
            ++n3;
        }
    }

    public static interface KeptJobsListener {
        public void finished(JobTreeElement var1);

        public void removed(JobTreeElement var1);
    }
}

