/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.datatype;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerDescriptor;
import org.jkiss.dbeaver.model.data.DBDRegistry;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.datatype.AttributeTransformerDescriptor;
import org.jkiss.dbeaver.registry.datatype.ValueHandlerDescriptor;

public class DataTypeProviderRegistry
implements DBDRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataTypeProvider";
    private static final Log log = Log.getLog(DataTypeProviderRegistry.class);
    private static DataTypeProviderRegistry instance = null;
    private final List<ValueHandlerDescriptor> dataTypeProviders = new ArrayList<ValueHandlerDescriptor>();
    private final Map<String, ValueHandlerDescriptor> dataTypeProvidersMap = new HashMap<String, ValueHandlerDescriptor>();
    private final List<AttributeTransformerDescriptor> dataTypeTransformers = new ArrayList<AttributeTransformerDescriptor>();

    public static synchronized DataTypeProviderRegistry getInstance() {
        if (instance == null) {
            instance = new DataTypeProviderRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataTypeProviderRegistry() {
    }

    public void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("provider".equals(ext.getName())) {
                ValueHandlerDescriptor provider = new ValueHandlerDescriptor(ext);
                this.dataTypeProviders.add(provider);
                this.dataTypeProvidersMap.put(provider.getId(), provider);
            } else if ("transformer".equals(ext.getName())) {
                this.dataTypeTransformers.add(new AttributeTransformerDescriptor(ext));
            }
            ++n2;
        }
        try {
            this.dataTypeProviders.sort((o1, o2) -> {
                ValueHandlerDescriptor parent2;
                if (o1.isGlobal()) {
                    return o2.isGlobal() ? 0 : -1;
                }
                if (o2.isGlobal()) {
                    return 1;
                }
                String p1 = o1.getParentProvider();
                String p2 = o2.getParentProvider();
                if (p1 == null) {
                    return p2 == null ? o1.getId().compareTo(o2.getId()) : 1;
                }
                if (p2 == null) {
                    return -1;
                }
                ValueHandlerDescriptor parent1 = this.getValueHandler(p1);
                if (parent1 == (parent2 = this.getValueHandler(p2))) {
                    return o1.getId().compareTo(o2.getId());
                }
                if (parent1.isChildOf(parent2)) {
                    return -1;
                }
                if (parent2.isChildOf(parent1)) {
                    return 1;
                }
                return o1.getId().compareTo(o2.getId());
            });
        }
        catch (Exception e) {
            log.debug((Object)"Internal error during providers sort", (Throwable)e);
        }
    }

    private static boolean isChildOfAnyProvider(List<DataSourceProviderDescriptor> dsList1, List<DataSourceProviderDescriptor> dsList2) {
        for (DataSourceProviderDescriptor ds1 : dsList1) {
            for (DataSourceProviderDescriptor ds2 : dsList2) {
                DataSourceProviderDescriptor parent = ds2.getParentProvider();
                while (parent != null) {
                    if (parent == ds1) {
                        return true;
                    }
                    parent = parent.getParentProvider();
                }
            }
        }
        return false;
    }

    public void dispose() {
        this.dataTypeProviders.clear();
    }

    ValueHandlerDescriptor getValueHandler(@NotNull String id) {
        return this.dataTypeProvidersMap.get(id);
    }

    @Nullable
    public DBDValueHandlerProvider getValueHandlerProvider(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject typedObject) {
        for (ValueHandlerDescriptor dtProvider : this.dataTypeProviders) {
            if (dtProvider.isGlobal() || !dtProvider.supportsDataSource(dataSource) || !dtProvider.supportsType(typedObject)) continue;
            return (DBDValueHandlerProvider)dtProvider.getInstance();
        }
        for (ValueHandlerDescriptor dtProvider : this.dataTypeProviders) {
            if (!dtProvider.isGlobal() || !dtProvider.supportsType(typedObject)) continue;
            return (DBDValueHandlerProvider)dtProvider.getInstance();
        }
        return null;
    }

    public List<AttributeTransformerDescriptor> findTransformers(DBPDataSource dataSource, DBSTypedObject typedObject, Boolean custom) {
        ArrayList<AttributeTransformerDescriptor> result = null;
        for (AttributeTransformerDescriptor descriptor : this.dataTypeTransformers) {
            if (custom != null && custom.booleanValue() != descriptor.isCustom() || (descriptor.isGlobal() || !descriptor.supportsDataSource(dataSource) || !descriptor.supportsType(typedObject)) && (!descriptor.isGlobal() || !descriptor.supportsType(typedObject))) continue;
            if (result == null) {
                result = new ArrayList<AttributeTransformerDescriptor>();
            }
            result.add(descriptor);
        }
        if (result != null) {
            result.sort(Comparator.comparing(AttributeTransformerDescriptor::getName));
        }
        return result;
    }

    public DBDAttributeTransformerDescriptor getTransformer(String id) {
        for (AttributeTransformerDescriptor descriptor : this.dataTypeTransformers) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }
}

