/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xapp-statusicon-interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_UINT_UINT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntUintUintIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_x,
        gint arg_y,
        guint arg_button,
        guint arg_time,
        gint arg_panel_position,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntUintUintIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 7);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntUintUintIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              g_marshal_value_peek_uint (param_values + 5),
              g_marshal_value_peek_int (param_values + 6),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_delta,
        gint arg_orientation,
        guint arg_time,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.x.StatusIcon
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XAppStatusIconInterface
 * @title: XAppStatusIconInterface
 * @short_description: Generated C code for the org.x.StatusIcon D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.x.StatusIcon ---- */

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_press_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_press_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_press_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_press_IN_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_press_IN_ARG_panel_position =
{
  {
    -1,
    (gchar *) "panel_position",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xapp_status_icon_interface_method_info_button_press_IN_ARG_pointers[] =
{
  &_xapp_status_icon_interface_method_info_button_press_IN_ARG_x.parent_struct,
  &_xapp_status_icon_interface_method_info_button_press_IN_ARG_y.parent_struct,
  &_xapp_status_icon_interface_method_info_button_press_IN_ARG_button.parent_struct,
  &_xapp_status_icon_interface_method_info_button_press_IN_ARG_time.parent_struct,
  &_xapp_status_icon_interface_method_info_button_press_IN_ARG_panel_position.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xapp_status_icon_interface_method_info_button_press =
{
  {
    -1,
    (gchar *) "ButtonPress",
    (GDBusArgInfo **) &_xapp_status_icon_interface_method_info_button_press_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-button-press",
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_release_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_release_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_release_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_release_IN_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_button_release_IN_ARG_panel_position =
{
  {
    -1,
    (gchar *) "panel_position",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xapp_status_icon_interface_method_info_button_release_IN_ARG_pointers[] =
{
  &_xapp_status_icon_interface_method_info_button_release_IN_ARG_x.parent_struct,
  &_xapp_status_icon_interface_method_info_button_release_IN_ARG_y.parent_struct,
  &_xapp_status_icon_interface_method_info_button_release_IN_ARG_button.parent_struct,
  &_xapp_status_icon_interface_method_info_button_release_IN_ARG_time.parent_struct,
  &_xapp_status_icon_interface_method_info_button_release_IN_ARG_panel_position.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xapp_status_icon_interface_method_info_button_release =
{
  {
    -1,
    (gchar *) "ButtonRelease",
    (GDBusArgInfo **) &_xapp_status_icon_interface_method_info_button_release_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-button-release",
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_scroll_IN_ARG_delta =
{
  {
    -1,
    (gchar *) "delta",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_scroll_IN_ARG_orientation =
{
  {
    -1,
    (gchar *) "orientation",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xapp_status_icon_interface_method_info_scroll_IN_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xapp_status_icon_interface_method_info_scroll_IN_ARG_pointers[] =
{
  &_xapp_status_icon_interface_method_info_scroll_IN_ARG_delta.parent_struct,
  &_xapp_status_icon_interface_method_info_scroll_IN_ARG_orientation.parent_struct,
  &_xapp_status_icon_interface_method_info_scroll_IN_ARG_time.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xapp_status_icon_interface_method_info_scroll =
{
  {
    -1,
    (gchar *) "Scroll",
    (GDBusArgInfo **) &_xapp_status_icon_interface_method_info_scroll_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-scroll",
  FALSE
};

static const GDBusMethodInfo * const _xapp_status_icon_interface_method_info_pointers[] =
{
  &_xapp_status_icon_interface_method_info_button_press.parent_struct,
  &_xapp_status_icon_interface_method_info_button_release.parent_struct,
  &_xapp_status_icon_interface_method_info_scroll.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_icon_name =
{
  {
    -1,
    (gchar *) "IconName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "icon-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_tooltip_text =
{
  {
    -1,
    (gchar *) "TooltipText",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tooltip-text",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_label =
{
  {
    -1,
    (gchar *) "Label",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "label",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_visible =
{
  {
    -1,
    (gchar *) "Visible",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "visible",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_icon_size =
{
  {
    -1,
    (gchar *) "IconSize",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "icon-size",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_primary_menu_is_open =
{
  {
    -1,
    (gchar *) "PrimaryMenuIsOpen",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "primary-menu-is-open",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_secondary_menu_is_open =
{
  {
    -1,
    (gchar *) "SecondaryMenuIsOpen",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "secondary-menu-is-open",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xapp_status_icon_interface_property_info_metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "metadata",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xapp_status_icon_interface_property_info_pointers[] =
{
  &_xapp_status_icon_interface_property_info_name.parent_struct,
  &_xapp_status_icon_interface_property_info_icon_name.parent_struct,
  &_xapp_status_icon_interface_property_info_tooltip_text.parent_struct,
  &_xapp_status_icon_interface_property_info_label.parent_struct,
  &_xapp_status_icon_interface_property_info_visible.parent_struct,
  &_xapp_status_icon_interface_property_info_icon_size.parent_struct,
  &_xapp_status_icon_interface_property_info_primary_menu_is_open.parent_struct,
  &_xapp_status_icon_interface_property_info_secondary_menu_is_open.parent_struct,
  &_xapp_status_icon_interface_property_info_metadata.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xapp_status_icon_interface_interface_info =
{
  {
    -1,
    (gchar *) "org.x.StatusIcon",
    (GDBusMethodInfo **) &_xapp_status_icon_interface_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xapp_status_icon_interface_property_info_pointers,
    NULL
  },
  "status-icon-interface",
};


/**
 * xapp_status_icon_interface_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xapp_status_icon_interface_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xapp_status_icon_interface_interface_info.parent_struct;
}

/**
 * xapp_status_icon_interface_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XAppStatusIconInterface interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xapp_status_icon_interface_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "icon-name");
  g_object_class_override_property (klass, property_id_begin++, "tooltip-text");
  g_object_class_override_property (klass, property_id_begin++, "label");
  g_object_class_override_property (klass, property_id_begin++, "visible");
  g_object_class_override_property (klass, property_id_begin++, "icon-size");
  g_object_class_override_property (klass, property_id_begin++, "primary-menu-is-open");
  g_object_class_override_property (klass, property_id_begin++, "secondary-menu-is-open");
  g_object_class_override_property (klass, property_id_begin++, "metadata");
  return property_id_begin - 1;
}


inline static void
xapp_status_icon_interface_method_marshal_button_press (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_UINT_UINT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xapp_status_icon_interface_method_marshal_button_release (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_UINT_UINT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
xapp_status_icon_interface_method_marshal_scroll (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * XAppStatusIconInterface:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link>.
 */

/**
 * XAppStatusIconInterfaceIface:
 * @parent_iface: The parent interface.
 * @handle_button_press: Handler for the #XAppStatusIconInterface::handle-button-press signal.
 * @handle_button_release: Handler for the #XAppStatusIconInterface::handle-button-release signal.
 * @handle_scroll: Handler for the #XAppStatusIconInterface::handle-scroll signal.
 * @get_icon_name: Getter for the #XAppStatusIconInterface:icon-name property.
 * @get_icon_size: Getter for the #XAppStatusIconInterface:icon-size property.
 * @get_label: Getter for the #XAppStatusIconInterface:label property.
 * @get_metadata: Getter for the #XAppStatusIconInterface:metadata property.
 * @get_name: Getter for the #XAppStatusIconInterface:name property.
 * @get_primary_menu_is_open: Getter for the #XAppStatusIconInterface:primary-menu-is-open property.
 * @get_secondary_menu_is_open: Getter for the #XAppStatusIconInterface:secondary-menu-is-open property.
 * @get_tooltip_text: Getter for the #XAppStatusIconInterface:tooltip-text property.
 * @get_visible: Getter for the #XAppStatusIconInterface:visible property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link>.
 */

typedef XAppStatusIconInterfaceIface XAppStatusIconInterfaceInterface;
G_DEFINE_INTERFACE (XAppStatusIconInterface, xapp_status_icon_interface, G_TYPE_OBJECT)

static void
xapp_status_icon_interface_default_init (XAppStatusIconInterfaceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XAppStatusIconInterface::handle-button-press:
   * @object: A #XAppStatusIconInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_button: Argument passed by remote caller.
   * @arg_time: Argument passed by remote caller.
   * @arg_panel_position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-x-StatusIcon.ButtonPress">ButtonPress()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xapp_status_icon_interface_complete_button_press() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-button-press",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XAppStatusIconInterfaceIface, handle_button_press),
    g_signal_accumulator_true_handled,
    NULL,
      xapp_status_icon_interface_method_marshal_button_press,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INT);

  /**
   * XAppStatusIconInterface::handle-button-release:
   * @object: A #XAppStatusIconInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   * @arg_button: Argument passed by remote caller.
   * @arg_time: Argument passed by remote caller.
   * @arg_panel_position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-x-StatusIcon.ButtonRelease">ButtonRelease()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xapp_status_icon_interface_complete_button_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-button-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XAppStatusIconInterfaceIface, handle_button_release),
    g_signal_accumulator_true_handled,
    NULL,
      xapp_status_icon_interface_method_marshal_button_release,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INT);

  /**
   * XAppStatusIconInterface::handle-scroll:
   * @object: A #XAppStatusIconInterface.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_delta: Argument passed by remote caller.
   * @arg_orientation: Argument passed by remote caller.
   * @arg_time: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-x-StatusIcon.Scroll">Scroll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xapp_status_icon_interface_complete_scroll() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-scroll",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XAppStatusIconInterfaceIface, handle_scroll),
    g_signal_accumulator_true_handled,
    NULL,
      xapp_status_icon_interface_method_marshal_scroll,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * XAppStatusIconInterface:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:icon-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.IconName">"IconName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("icon-name", "IconName", "IconName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:tooltip-text:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.TooltipText">"TooltipText"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("tooltip-text", "TooltipText", "TooltipText", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:label:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.Label">"Label"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("label", "Label", "Label", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:visible:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.Visible">"Visible"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("visible", "Visible", "Visible", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:icon-size:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.IconSize">"IconSize"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("icon-size", "IconSize", "IconSize", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:primary-menu-is-open:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.PrimaryMenuIsOpen">"PrimaryMenuIsOpen"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("primary-menu-is-open", "PrimaryMenuIsOpen", "PrimaryMenuIsOpen", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:secondary-menu-is-open:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.SecondaryMenuIsOpen">"SecondaryMenuIsOpen"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("secondary-menu-is-open", "SecondaryMenuIsOpen", "SecondaryMenuIsOpen", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XAppStatusIconInterface:metadata:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-x-StatusIcon.Metadata">"Metadata"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("metadata", "Metadata", "Metadata", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xapp_status_icon_interface_get_name: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use xapp_status_icon_interface_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
xapp_status_icon_interface_get_name (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), NULL);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_name (object);
}

/**
 * xapp_status_icon_interface_dup_name: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-x-StatusIcon.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
xapp_status_icon_interface_dup_name (XAppStatusIconInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * xapp_status_icon_interface_set_name: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_name (XAppStatusIconInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * xapp_status_icon_interface_get_icon_name: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.IconName">"IconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use xapp_status_icon_interface_dup_icon_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
xapp_status_icon_interface_get_icon_name (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), NULL);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_icon_name (object);
}

/**
 * xapp_status_icon_interface_dup_icon_name: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-x-StatusIcon.IconName">"IconName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
xapp_status_icon_interface_dup_icon_name (XAppStatusIconInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "icon-name", &value, NULL);
  return value;
}

/**
 * xapp_status_icon_interface_set_icon_name: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.IconName">"IconName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_icon_name (XAppStatusIconInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "icon-name", value, NULL);
}

/**
 * xapp_status_icon_interface_get_tooltip_text: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.TooltipText">"TooltipText"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use xapp_status_icon_interface_dup_tooltip_text() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
xapp_status_icon_interface_get_tooltip_text (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), NULL);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_tooltip_text (object);
}

/**
 * xapp_status_icon_interface_dup_tooltip_text: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-x-StatusIcon.TooltipText">"TooltipText"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
xapp_status_icon_interface_dup_tooltip_text (XAppStatusIconInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "tooltip-text", &value, NULL);
  return value;
}

/**
 * xapp_status_icon_interface_set_tooltip_text: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.TooltipText">"TooltipText"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_tooltip_text (XAppStatusIconInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "tooltip-text", value, NULL);
}

/**
 * xapp_status_icon_interface_get_label: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use xapp_status_icon_interface_dup_label() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
xapp_status_icon_interface_get_label (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), NULL);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_label (object);
}

/**
 * xapp_status_icon_interface_dup_label: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-x-StatusIcon.Label">"Label"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
xapp_status_icon_interface_dup_label (XAppStatusIconInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "label", &value, NULL);
  return value;
}

/**
 * xapp_status_icon_interface_set_label: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.Label">"Label"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_label (XAppStatusIconInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "label", value, NULL);
}

/**
 * xapp_status_icon_interface_get_visible: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.Visible">"Visible"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xapp_status_icon_interface_get_visible (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), FALSE);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_visible (object);
}

/**
 * xapp_status_icon_interface_set_visible: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.Visible">"Visible"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_visible (XAppStatusIconInterface *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "visible", value, NULL);
}

/**
 * xapp_status_icon_interface_get_icon_size: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.IconSize">"IconSize"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
xapp_status_icon_interface_get_icon_size (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), 0);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_icon_size (object);
}

/**
 * xapp_status_icon_interface_set_icon_size: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.IconSize">"IconSize"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xapp_status_icon_interface_set_icon_size (XAppStatusIconInterface *object, gint value)
{
  g_object_set (G_OBJECT (object), "icon-size", value, NULL);
}

/**
 * xapp_status_icon_interface_get_primary_menu_is_open: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.PrimaryMenuIsOpen">"PrimaryMenuIsOpen"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xapp_status_icon_interface_get_primary_menu_is_open (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), FALSE);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_primary_menu_is_open (object);
}

/**
 * xapp_status_icon_interface_set_primary_menu_is_open: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.PrimaryMenuIsOpen">"PrimaryMenuIsOpen"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_primary_menu_is_open (XAppStatusIconInterface *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "primary-menu-is-open", value, NULL);
}

/**
 * xapp_status_icon_interface_get_secondary_menu_is_open: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.SecondaryMenuIsOpen">"SecondaryMenuIsOpen"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xapp_status_icon_interface_get_secondary_menu_is_open (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), FALSE);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_secondary_menu_is_open (object);
}

/**
 * xapp_status_icon_interface_set_secondary_menu_is_open: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.SecondaryMenuIsOpen">"SecondaryMenuIsOpen"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_secondary_menu_is_open (XAppStatusIconInterface *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "secondary-menu-is-open", value, NULL);
}

/**
 * xapp_status_icon_interface_get_metadata: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets the value of the <link linkend="gdbus-property-org-x-StatusIcon.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use xapp_status_icon_interface_dup_metadata() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
xapp_status_icon_interface_get_metadata (XAppStatusIconInterface *object)
{
  g_return_val_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (object), NULL);

  return XAPP_STATUS_ICON_INTERFACE_GET_IFACE (object)->get_metadata (object);
}

/**
 * xapp_status_icon_interface_dup_metadata: (skip)
 * @object: A #XAppStatusIconInterface.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-x-StatusIcon.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
xapp_status_icon_interface_dup_metadata (XAppStatusIconInterface *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "metadata", &value, NULL);
  return value;
}

/**
 * xapp_status_icon_interface_set_metadata: (skip)
 * @object: A #XAppStatusIconInterface.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-x-StatusIcon.Metadata">"Metadata"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xapp_status_icon_interface_set_metadata (XAppStatusIconInterface *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "metadata", value, NULL);
}

/**
 * xapp_status_icon_interface_call_button_press:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @arg_panel_position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-x-StatusIcon.ButtonPress">ButtonPress()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_status_icon_interface_call_button_press_finish() to get the result of the operation.
 *
 * See xapp_status_icon_interface_call_button_press_sync() for the synchronous, blocking version of this method.
 */
void
xapp_status_icon_interface_call_button_press (
    XAppStatusIconInterface *proxy,
    gint arg_x,
    gint arg_y,
    guint arg_button,
    guint arg_time,
    gint arg_panel_position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ButtonPress",
    g_variant_new ("(iiuui)",
                   arg_x,
                   arg_y,
                   arg_button,
                   arg_time,
                   arg_panel_position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xapp_status_icon_interface_call_button_press_finish:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_status_icon_interface_call_button_press().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xapp_status_icon_interface_call_button_press().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xapp_status_icon_interface_call_button_press_finish (
    XAppStatusIconInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xapp_status_icon_interface_call_button_press_sync:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @arg_panel_position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-x-StatusIcon.ButtonPress">ButtonPress()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xapp_status_icon_interface_call_button_press() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xapp_status_icon_interface_call_button_press_sync (
    XAppStatusIconInterface *proxy,
    gint arg_x,
    gint arg_y,
    guint arg_button,
    guint arg_time,
    gint arg_panel_position,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ButtonPress",
    g_variant_new ("(iiuui)",
                   arg_x,
                   arg_y,
                   arg_button,
                   arg_time,
                   arg_panel_position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xapp_status_icon_interface_call_button_release:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @arg_panel_position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-x-StatusIcon.ButtonRelease">ButtonRelease()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_status_icon_interface_call_button_release_finish() to get the result of the operation.
 *
 * See xapp_status_icon_interface_call_button_release_sync() for the synchronous, blocking version of this method.
 */
void
xapp_status_icon_interface_call_button_release (
    XAppStatusIconInterface *proxy,
    gint arg_x,
    gint arg_y,
    guint arg_button,
    guint arg_time,
    gint arg_panel_position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ButtonRelease",
    g_variant_new ("(iiuui)",
                   arg_x,
                   arg_y,
                   arg_button,
                   arg_time,
                   arg_panel_position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xapp_status_icon_interface_call_button_release_finish:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_status_icon_interface_call_button_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xapp_status_icon_interface_call_button_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xapp_status_icon_interface_call_button_release_finish (
    XAppStatusIconInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xapp_status_icon_interface_call_button_release_sync:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @arg_panel_position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-x-StatusIcon.ButtonRelease">ButtonRelease()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xapp_status_icon_interface_call_button_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xapp_status_icon_interface_call_button_release_sync (
    XAppStatusIconInterface *proxy,
    gint arg_x,
    gint arg_y,
    guint arg_button,
    guint arg_time,
    gint arg_panel_position,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ButtonRelease",
    g_variant_new ("(iiuui)",
                   arg_x,
                   arg_y,
                   arg_button,
                   arg_time,
                   arg_panel_position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xapp_status_icon_interface_call_scroll:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @arg_delta: Argument to pass with the method invocation.
 * @arg_orientation: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-x-StatusIcon.Scroll">Scroll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_status_icon_interface_call_scroll_finish() to get the result of the operation.
 *
 * See xapp_status_icon_interface_call_scroll_sync() for the synchronous, blocking version of this method.
 */
void
xapp_status_icon_interface_call_scroll (
    XAppStatusIconInterface *proxy,
    gint arg_delta,
    gint arg_orientation,
    guint arg_time,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Scroll",
    g_variant_new ("(iiu)",
                   arg_delta,
                   arg_orientation,
                   arg_time),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xapp_status_icon_interface_call_scroll_finish:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_status_icon_interface_call_scroll().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xapp_status_icon_interface_call_scroll().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xapp_status_icon_interface_call_scroll_finish (
    XAppStatusIconInterface *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xapp_status_icon_interface_call_scroll_sync:
 * @proxy: A #XAppStatusIconInterfaceProxy.
 * @arg_delta: Argument to pass with the method invocation.
 * @arg_orientation: Argument to pass with the method invocation.
 * @arg_time: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-x-StatusIcon.Scroll">Scroll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xapp_status_icon_interface_call_scroll() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xapp_status_icon_interface_call_scroll_sync (
    XAppStatusIconInterface *proxy,
    gint arg_delta,
    gint arg_orientation,
    guint arg_time,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Scroll",
    g_variant_new ("(iiu)",
                   arg_delta,
                   arg_orientation,
                   arg_time),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xapp_status_icon_interface_complete_button_press:
 * @object: A #XAppStatusIconInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-x-StatusIcon.ButtonPress">ButtonPress()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xapp_status_icon_interface_complete_button_press (
    XAppStatusIconInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xapp_status_icon_interface_complete_button_release:
 * @object: A #XAppStatusIconInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-x-StatusIcon.ButtonRelease">ButtonRelease()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xapp_status_icon_interface_complete_button_release (
    XAppStatusIconInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xapp_status_icon_interface_complete_scroll:
 * @object: A #XAppStatusIconInterface.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-x-StatusIcon.Scroll">Scroll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xapp_status_icon_interface_complete_scroll (
    XAppStatusIconInterface *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XAppStatusIconInterfaceProxy:
 *
 * The #XAppStatusIconInterfaceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XAppStatusIconInterfaceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XAppStatusIconInterfaceProxy.
 */

struct _XAppStatusIconInterfaceProxyPrivate
{
  GData *qdata;
};

static void xapp_status_icon_interface_proxy_iface_init (XAppStatusIconInterfaceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XAppStatusIconInterfaceProxy, xapp_status_icon_interface_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XAppStatusIconInterfaceProxy)
                         G_IMPLEMENT_INTERFACE (XAPP_TYPE_STATUS_ICON_INTERFACE, xapp_status_icon_interface_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XAppStatusIconInterfaceProxy, xapp_status_icon_interface_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XAPP_TYPE_STATUS_ICON_INTERFACE, xapp_status_icon_interface_proxy_iface_init))

#endif
static void
xapp_status_icon_interface_proxy_finalize (GObject *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xapp_status_icon_interface_proxy_parent_class)->finalize (object);
}

static void
xapp_status_icon_interface_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _xapp_status_icon_interface_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xapp_status_icon_interface_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.x.StatusIcon: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xapp_status_icon_interface_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _xapp_status_icon_interface_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.x.StatusIcon", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xapp_status_icon_interface_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xapp_status_icon_interface_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xapp_status_icon_interface_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XAPP_TYPE_STATUS_ICON_INTERFACE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XAPP_TYPE_STATUS_ICON_INTERFACE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xapp_status_icon_interface_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xapp_status_icon_interface_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xapp_status_icon_interface_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
xapp_status_icon_interface_proxy_get_name (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
xapp_status_icon_interface_proxy_get_icon_name (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
xapp_status_icon_interface_proxy_get_tooltip_text (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "TooltipText");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
xapp_status_icon_interface_proxy_get_label (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Label");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xapp_status_icon_interface_proxy_get_visible (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Visible");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
xapp_status_icon_interface_proxy_get_icon_size (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IconSize");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xapp_status_icon_interface_proxy_get_primary_menu_is_open (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PrimaryMenuIsOpen");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xapp_status_icon_interface_proxy_get_secondary_menu_is_open (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SecondaryMenuIsOpen");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
xapp_status_icon_interface_proxy_get_metadata (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceProxy *proxy = XAPP_STATUS_ICON_INTERFACE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metadata");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
xapp_status_icon_interface_proxy_init (XAppStatusIconInterfaceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xapp_status_icon_interface_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XAPP_TYPE_STATUS_ICON_INTERFACE_PROXY, XAppStatusIconInterfaceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xapp_status_icon_interface_interface_info ());
}

static void
xapp_status_icon_interface_proxy_class_init (XAppStatusIconInterfaceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xapp_status_icon_interface_proxy_finalize;
  gobject_class->get_property = xapp_status_icon_interface_proxy_get_property;
  gobject_class->set_property = xapp_status_icon_interface_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xapp_status_icon_interface_proxy_g_signal;
  proxy_class->g_properties_changed = xapp_status_icon_interface_proxy_g_properties_changed;

  xapp_status_icon_interface_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XAppStatusIconInterfaceProxyPrivate));
#endif
}

static void
xapp_status_icon_interface_proxy_iface_init (XAppStatusIconInterfaceIface *iface)
{
  iface->get_name = xapp_status_icon_interface_proxy_get_name;
  iface->get_icon_name = xapp_status_icon_interface_proxy_get_icon_name;
  iface->get_tooltip_text = xapp_status_icon_interface_proxy_get_tooltip_text;
  iface->get_label = xapp_status_icon_interface_proxy_get_label;
  iface->get_visible = xapp_status_icon_interface_proxy_get_visible;
  iface->get_icon_size = xapp_status_icon_interface_proxy_get_icon_size;
  iface->get_primary_menu_is_open = xapp_status_icon_interface_proxy_get_primary_menu_is_open;
  iface->get_secondary_menu_is_open = xapp_status_icon_interface_proxy_get_secondary_menu_is_open;
  iface->get_metadata = xapp_status_icon_interface_proxy_get_metadata;
}

/**
 * xapp_status_icon_interface_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_status_icon_interface_proxy_new_finish() to get the result of the operation.
 *
 * See xapp_status_icon_interface_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xapp_status_icon_interface_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XAPP_TYPE_STATUS_ICON_INTERFACE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.x.StatusIcon", NULL);
}

/**
 * xapp_status_icon_interface_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_status_icon_interface_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xapp_status_icon_interface_proxy_new().
 *
 * Returns: (transfer full) (type XAppStatusIconInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
XAppStatusIconInterface *
xapp_status_icon_interface_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XAPP_STATUS_ICON_INTERFACE (ret);
  else
    return NULL;
}

/**
 * xapp_status_icon_interface_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xapp_status_icon_interface_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XAppStatusIconInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
XAppStatusIconInterface *
xapp_status_icon_interface_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XAPP_TYPE_STATUS_ICON_INTERFACE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.x.StatusIcon", NULL);
  if (ret != NULL)
    return XAPP_STATUS_ICON_INTERFACE (ret);
  else
    return NULL;
}


/**
 * xapp_status_icon_interface_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xapp_status_icon_interface_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_status_icon_interface_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xapp_status_icon_interface_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xapp_status_icon_interface_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XAPP_TYPE_STATUS_ICON_INTERFACE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.x.StatusIcon", NULL);
}

/**
 * xapp_status_icon_interface_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_status_icon_interface_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xapp_status_icon_interface_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XAppStatusIconInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
XAppStatusIconInterface *
xapp_status_icon_interface_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XAPP_STATUS_ICON_INTERFACE (ret);
  else
    return NULL;
}

/**
 * xapp_status_icon_interface_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xapp_status_icon_interface_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xapp_status_icon_interface_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XAppStatusIconInterfaceProxy): The constructed proxy object or %NULL if @error is set.
 */
XAppStatusIconInterface *
xapp_status_icon_interface_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XAPP_TYPE_STATUS_ICON_INTERFACE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.x.StatusIcon", NULL);
  if (ret != NULL)
    return XAPP_STATUS_ICON_INTERFACE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XAppStatusIconInterfaceSkeleton:
 *
 * The #XAppStatusIconInterfaceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XAppStatusIconInterfaceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XAppStatusIconInterfaceSkeleton.
 */

struct _XAppStatusIconInterfaceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xapp_status_icon_interface_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XAPP_TYPE_STATUS_ICON_INTERFACE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XAPP_TYPE_STATUS_ICON_INTERFACE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xapp_status_icon_interface_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xapp_status_icon_interface_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xapp_status_icon_interface_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xapp_status_icon_interface_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xapp_status_icon_interface_skeleton_vtable =
{
  _xapp_status_icon_interface_skeleton_handle_method_call,
  _xapp_status_icon_interface_skeleton_handle_get_property,
  _xapp_status_icon_interface_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xapp_status_icon_interface_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xapp_status_icon_interface_interface_info ();
}

static GDBusInterfaceVTable *
xapp_status_icon_interface_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xapp_status_icon_interface_skeleton_vtable;
}

static GVariant *
xapp_status_icon_interface_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_xapp_status_icon_interface_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xapp_status_icon_interface_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xapp_status_icon_interface_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xapp_status_icon_interface_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.x.StatusIcon", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xapp_status_icon_interface_emit_changed (gpointer user_data);

static void
xapp_status_icon_interface_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xapp_status_icon_interface_emit_changed (skeleton);
}

static void xapp_status_icon_interface_skeleton_iface_init (XAppStatusIconInterfaceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XAppStatusIconInterfaceSkeleton, xapp_status_icon_interface_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XAppStatusIconInterfaceSkeleton)
                         G_IMPLEMENT_INTERFACE (XAPP_TYPE_STATUS_ICON_INTERFACE, xapp_status_icon_interface_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XAppStatusIconInterfaceSkeleton, xapp_status_icon_interface_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XAPP_TYPE_STATUS_ICON_INTERFACE, xapp_status_icon_interface_skeleton_iface_init))

#endif
static void
xapp_status_icon_interface_skeleton_finalize (GObject *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xapp_status_icon_interface_skeleton_parent_class)->finalize (object);
}

static void
xapp_status_icon_interface_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xapp_status_icon_interface_emit_changed (gpointer user_data)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.x.StatusIcon",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xapp_status_icon_interface_schedule_emit_changed (XAppStatusIconInterfaceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xapp_status_icon_interface_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xapp_status_icon_interface_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xapp_status_icon_interface_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xapp_status_icon_interface_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _xapp_status_icon_interface_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xapp_status_icon_interface_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xapp_status_icon_interface_skeleton_init (XAppStatusIconInterfaceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xapp_status_icon_interface_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XAPP_TYPE_STATUS_ICON_INTERFACE_SKELETON, XAppStatusIconInterfaceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_INT);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRING);
}

static const gchar *
xapp_status_icon_interface_skeleton_get_name (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
xapp_status_icon_interface_skeleton_get_icon_name (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
xapp_status_icon_interface_skeleton_get_tooltip_text (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
xapp_status_icon_interface_skeleton_get_label (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xapp_status_icon_interface_skeleton_get_visible (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
xapp_status_icon_interface_skeleton_get_icon_size (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xapp_status_icon_interface_skeleton_get_primary_menu_is_open (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xapp_status_icon_interface_skeleton_get_secondary_menu_is_open (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
xapp_status_icon_interface_skeleton_get_metadata (XAppStatusIconInterface *object)
{
  XAppStatusIconInterfaceSkeleton *skeleton = XAPP_STATUS_ICON_INTERFACE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xapp_status_icon_interface_skeleton_class_init (XAppStatusIconInterfaceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xapp_status_icon_interface_skeleton_finalize;
  gobject_class->get_property = xapp_status_icon_interface_skeleton_get_property;
  gobject_class->set_property = xapp_status_icon_interface_skeleton_set_property;
  gobject_class->notify       = xapp_status_icon_interface_skeleton_notify;


  xapp_status_icon_interface_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xapp_status_icon_interface_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xapp_status_icon_interface_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xapp_status_icon_interface_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xapp_status_icon_interface_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XAppStatusIconInterfaceSkeletonPrivate));
#endif
}

static void
xapp_status_icon_interface_skeleton_iface_init (XAppStatusIconInterfaceIface *iface)
{
  iface->get_name = xapp_status_icon_interface_skeleton_get_name;
  iface->get_icon_name = xapp_status_icon_interface_skeleton_get_icon_name;
  iface->get_tooltip_text = xapp_status_icon_interface_skeleton_get_tooltip_text;
  iface->get_label = xapp_status_icon_interface_skeleton_get_label;
  iface->get_visible = xapp_status_icon_interface_skeleton_get_visible;
  iface->get_icon_size = xapp_status_icon_interface_skeleton_get_icon_size;
  iface->get_primary_menu_is_open = xapp_status_icon_interface_skeleton_get_primary_menu_is_open;
  iface->get_secondary_menu_is_open = xapp_status_icon_interface_skeleton_get_secondary_menu_is_open;
  iface->get_metadata = xapp_status_icon_interface_skeleton_get_metadata;
}

/**
 * xapp_status_icon_interface_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link>.
 *
 * Returns: (transfer full) (type XAppStatusIconInterfaceSkeleton): The skeleton object.
 */
XAppStatusIconInterface *
xapp_status_icon_interface_skeleton_new (void)
{
  return XAPP_STATUS_ICON_INTERFACE (g_object_new (XAPP_TYPE_STATUS_ICON_INTERFACE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for Object, ObjectProxy and ObjectSkeleton
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XAppObject
 * @title: XAppObject
 * @short_description: Specialized GDBusObject types
 *
 * This section contains the #XAppObject, #XAppObjectProxy, and #XAppObjectSkeleton types which make it easier to work with objects implementing generated types for D-Bus interfaces.
 */

/**
 * XAppObject:
 *
 * The #XAppObject type is a specialized container of interfaces.
 */

/**
 * XAppObjectIface:
 * @parent_iface: The parent interface.
 *
 * Virtual table for the #XAppObject interface.
 */

typedef XAppObjectIface XAppObjectInterface;
G_DEFINE_INTERFACE_WITH_CODE (XAppObject, xapp_object, G_TYPE_OBJECT, g_type_interface_add_prerequisite (g_define_type_id, G_TYPE_DBUS_OBJECT);)

static void
xapp_object_default_init (XAppObjectIface *iface)
{
  /**
   * XAppObject:status-icon-interface:
   *
   * The #XAppStatusIconInterface instance corresponding to the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link>, if any.
   *
   * Connect to the #GObject::notify signal to get informed of property changes.
   */
  g_object_interface_install_property (iface, g_param_spec_object ("status-icon-interface", "status-icon-interface", "status-icon-interface", XAPP_TYPE_STATUS_ICON_INTERFACE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));

}

/**
 * xapp_object_get_status_icon_interface:
 * @object: A #XAppObject.
 *
 * Gets the #XAppStatusIconInterface instance for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link> on @object, if any.
 *
 * Returns: (transfer full) (nullable): A #XAppStatusIconInterface that must be freed with g_object_unref() or %NULL if @object does not implement the interface.
 */
XAppStatusIconInterface *xapp_object_get_status_icon_interface (XAppObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.x.StatusIcon");
  if (ret == NULL)
    return NULL;
  return XAPP_STATUS_ICON_INTERFACE (ret);
}


/**
 * xapp_object_peek_status_icon_interface: (skip)
 * @object: A #XAppObject.
 *
 * Like xapp_object_get_status_icon_interface() but doesn't increase the reference count on the returned object.
 *
 * It is not safe to use the returned object if you are on another thread than the one where the #GDBusObjectManagerClient or #GDBusObjectManagerServer for @object is running.
 *
 * Returns: (transfer none) (nullable): A #XAppStatusIconInterface or %NULL if @object does not implement the interface. Do not free the returned object, it is owned by @object.
 */
XAppStatusIconInterface *xapp_object_peek_status_icon_interface (XAppObject *object)
{
  GDBusInterface *ret;
  ret = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.x.StatusIcon");
  if (ret == NULL)
    return NULL;
  g_object_unref (ret);
  return XAPP_STATUS_ICON_INTERFACE (ret);
}


static void
xapp_object_notify (GDBusObject *object, GDBusInterface *interface)
{
  _ExtendedGDBusInterfaceInfo *info = (_ExtendedGDBusInterfaceInfo *) g_dbus_interface_get_info (interface);
  /* info can be NULL if the other end is using a D-Bus interface we don't know
   * anything about, for example old generated code in this process talking to
   * newer generated code in the other process. */
  if (info != NULL)
    g_object_notify (G_OBJECT (object), info->hyphen_name);
}

/**
 * XAppObjectProxy:
 *
 * The #XAppObjectProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XAppObjectProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XAppObjectProxy.
 */

static void
xapp_object_proxy__xapp_object_iface_init (XAppObjectIface *iface G_GNUC_UNUSED)
{
}

static void
xapp_object_proxy__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = xapp_object_notify;
  iface->interface_removed = xapp_object_notify;
}


G_DEFINE_TYPE_WITH_CODE (XAppObjectProxy, xapp_object_proxy, G_TYPE_DBUS_OBJECT_PROXY,
                         G_IMPLEMENT_INTERFACE (XAPP_TYPE_OBJECT, xapp_object_proxy__xapp_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, xapp_object_proxy__g_dbus_object_iface_init))

static void
xapp_object_proxy_init (XAppObjectProxy *object G_GNUC_UNUSED)
{
}

static void
xapp_object_proxy_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec)
{
  G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
}

static void
xapp_object_proxy_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  XAppObjectProxy *object = XAPP_OBJECT_PROXY (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.x.StatusIcon");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
xapp_object_proxy_class_init (XAppObjectProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = xapp_object_proxy_set_property;
  gobject_class->get_property = xapp_object_proxy_get_property;

  g_object_class_override_property (gobject_class, 1, "status-icon-interface");
}

/**
 * xapp_object_proxy_new:
 * @connection: A #GDBusConnection.
 * @object_path: An object path.
 *
 * Creates a new proxy object.
 *
 * Returns: (transfer full): The proxy object.
 */
XAppObjectProxy *
xapp_object_proxy_new (GDBusConnection *connection,
  const gchar *object_path)
{
  g_return_val_if_fail (G_IS_DBUS_CONNECTION (connection), NULL);
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return XAPP_OBJECT_PROXY (g_object_new (XAPP_TYPE_OBJECT_PROXY, "g-connection", connection, "g-object-path", object_path, NULL));
}

/**
 * XAppObjectSkeleton:
 *
 * The #XAppObjectSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XAppObjectSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XAppObjectSkeleton.
 */

static void
xapp_object_skeleton__xapp_object_iface_init (XAppObjectIface *iface G_GNUC_UNUSED)
{
}


static void
xapp_object_skeleton__g_dbus_object_iface_init (GDBusObjectIface *iface)
{
  iface->interface_added = xapp_object_notify;
  iface->interface_removed = xapp_object_notify;
}

G_DEFINE_TYPE_WITH_CODE (XAppObjectSkeleton, xapp_object_skeleton, G_TYPE_DBUS_OBJECT_SKELETON,
                         G_IMPLEMENT_INTERFACE (XAPP_TYPE_OBJECT, xapp_object_skeleton__xapp_object_iface_init)
                         G_IMPLEMENT_INTERFACE (G_TYPE_DBUS_OBJECT, xapp_object_skeleton__g_dbus_object_iface_init))

static void
xapp_object_skeleton_init (XAppObjectSkeleton *object G_GNUC_UNUSED)
{
}

static void
xapp_object_skeleton_set_property (GObject      *gobject,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  XAppObjectSkeleton *object = XAPP_OBJECT_SKELETON (gobject);
  GDBusInterfaceSkeleton *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_value_get_object (value);
      if (interface != NULL)
        {
          g_warn_if_fail (XAPP_IS_STATUS_ICON_INTERFACE (interface));
          g_dbus_object_skeleton_add_interface (G_DBUS_OBJECT_SKELETON (object), interface);
        }
      else
        {
          g_dbus_object_skeleton_remove_interface_by_name (G_DBUS_OBJECT_SKELETON (object), "org.x.StatusIcon");
        }
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
xapp_object_skeleton_get_property (GObject      *gobject,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec)
{
  XAppObjectSkeleton *object = XAPP_OBJECT_SKELETON (gobject);
  GDBusInterface *interface;

  switch (prop_id)
    {
    case 1:
      interface = g_dbus_object_get_interface (G_DBUS_OBJECT (object), "org.x.StatusIcon");
      g_value_take_object (value, interface);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop_id, pspec);
      break;
  }
}

static void
xapp_object_skeleton_class_init (XAppObjectSkeletonClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->set_property = xapp_object_skeleton_set_property;
  gobject_class->get_property = xapp_object_skeleton_get_property;

  g_object_class_override_property (gobject_class, 1, "status-icon-interface");
}

/**
 * xapp_object_skeleton_new:
 * @object_path: An object path.
 *
 * Creates a new skeleton object.
 *
 * Returns: (transfer full): The skeleton object.
 */
XAppObjectSkeleton *
xapp_object_skeleton_new (const gchar *object_path)
{
  g_return_val_if_fail (g_variant_is_object_path (object_path), NULL);
  return XAPP_OBJECT_SKELETON (g_object_new (XAPP_TYPE_OBJECT_SKELETON, "g-object-path", object_path, NULL));
}

/**
 * xapp_object_skeleton_set_status_icon_interface:
 * @object: A #XAppObjectSkeleton.
 * @interface_: (nullable): A #XAppStatusIconInterface or %NULL to clear the interface.
 *
 * Sets the #XAppStatusIconInterface instance for the D-Bus interface <link linkend="gdbus-interface-org-x-StatusIcon.top_of_page">org.x.StatusIcon</link> on @object.
 */
void xapp_object_skeleton_set_status_icon_interface (XAppObjectSkeleton *object, XAppStatusIconInterface *interface_)
{
  g_object_set (G_OBJECT (object), "status-icon-interface", interface_, NULL);
}


/* ------------------------------------------------------------------------
 * Code for ObjectManager client
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XAppObjectManagerClient
 * @title: XAppObjectManagerClient
 * @short_description: Generated GDBusObjectManagerClient type
 *
 * This section contains a #GDBusObjectManagerClient that uses xapp_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc.
 */

/**
 * XAppObjectManagerClient:
 *
 * The #XAppObjectManagerClient structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XAppObjectManagerClientClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XAppObjectManagerClient.
 */

G_DEFINE_TYPE (XAppObjectManagerClient, xapp_object_manager_client, G_TYPE_DBUS_OBJECT_MANAGER_CLIENT)

static void
xapp_object_manager_client_init (XAppObjectManagerClient *manager G_GNUC_UNUSED)
{
}

static void
xapp_object_manager_client_class_init (XAppObjectManagerClientClass *klass G_GNUC_UNUSED)
{
}

/**
 * xapp_object_manager_client_get_proxy_type:
 * @manager: A #GDBusObjectManagerClient.
 * @object_path: The object path of the remote object (unused).
 * @interface_name: (nullable): Interface name of the remote object or %NULL to get the object proxy #GType.
 * @user_data: User data (unused).
 *
 * A #GDBusProxyTypeFunc that maps @interface_name to the generated #GDBusObjectProxy derived and #GDBusProxy derived types.
 *
 * Returns: A #GDBusProxy derived #GType if @interface_name is not %NULL, otherwise the #GType for #XAppObjectProxy.
 */
GType
xapp_object_manager_client_get_proxy_type (GDBusObjectManagerClient *manager G_GNUC_UNUSED, const gchar *object_path G_GNUC_UNUSED, const gchar *interface_name, gpointer user_data G_GNUC_UNUSED)
{
  static gsize once_init_value = 0;
  static GHashTable *lookup_hash;
  GType ret;

  if (interface_name == NULL)
    return XAPP_TYPE_OBJECT_PROXY;
  if (g_once_init_enter (&once_init_value))
    {
      lookup_hash = g_hash_table_new (g_str_hash, g_str_equal);
      g_hash_table_insert (lookup_hash, (gpointer) "org.x.StatusIcon", (gpointer) (guintptr) (XAPP_TYPE_STATUS_ICON_INTERFACE_PROXY));
      g_once_init_leave (&once_init_value, 1);
    }
  ret = (GType) (guintptr) (g_hash_table_lookup (lookup_hash, interface_name));
  if (ret == (GType) 0)
    ret = G_TYPE_DBUS_PROXY;
  return ret;
}

/**
 * xapp_object_manager_client_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates #GDBusObjectManagerClient using xapp_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_object_manager_client_new_finish() to get the result of the operation.
 *
 * See xapp_object_manager_client_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xapp_object_manager_client_new (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (XAPP_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", xapp_object_manager_client_get_proxy_type, NULL);
}

/**
 * xapp_object_manager_client_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_object_manager_client_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xapp_object_manager_client_new().
 *
 * Returns: (transfer full) (type XAppObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
xapp_object_manager_client_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * xapp_object_manager_client_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates #GDBusObjectManagerClient using xapp_object_manager_client_get_proxy_type() as the #GDBusProxyTypeFunc. See g_dbus_object_manager_client_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xapp_object_manager_client_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XAppObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
xapp_object_manager_client_new_sync (
    GDBusConnection        *connection,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (XAPP_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "connection", connection, "object-path", object_path, "get-proxy-type-func", xapp_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


/**
 * xapp_object_manager_client_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xapp_object_manager_client_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xapp_object_manager_client_new_for_bus_finish() to get the result of the operation.
 *
 * See xapp_object_manager_client_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xapp_object_manager_client_new_for_bus (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GAsyncReadyCallback     callback,
    gpointer                user_data)
{
  g_async_initable_new_async (XAPP_TYPE_OBJECT_MANAGER_CLIENT, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", xapp_object_manager_client_get_proxy_type, NULL);
}

/**
 * xapp_object_manager_client_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xapp_object_manager_client_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xapp_object_manager_client_new_for_bus().
 *
 * Returns: (transfer full) (type XAppObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
xapp_object_manager_client_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}

/**
 * xapp_object_manager_client_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusObjectManagerClientFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xapp_object_manager_client_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xapp_object_manager_client_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XAppObjectManagerClient): The constructed object manager client or %NULL if @error is set.
 */
GDBusObjectManager *
xapp_object_manager_client_new_for_bus_sync (
    GBusType                bus_type,
    GDBusObjectManagerClientFlags  flags,
    const gchar            *name,
    const gchar            *object_path,
    GCancellable           *cancellable,
    GError                **error)
{
  GInitable *ret;
  ret = g_initable_new (XAPP_TYPE_OBJECT_MANAGER_CLIENT, cancellable, error, "flags", flags, "name", name, "bus-type", bus_type, "object-path", object_path, "get-proxy-type-func", xapp_object_manager_client_get_proxy_type, NULL);
  if (ret != NULL)
    return G_DBUS_OBJECT_MANAGER (ret);
  else
    return NULL;
}


