/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUDeviceDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertRecord.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSGPUFeatureName.h"
#include "JSGPUQueueDescriptor.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Vector.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUDeviceDescriptor>> convertDictionary<GPUDeviceDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUDeviceDescriptor result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLUSVString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue defaultQueueValue;
    if (isNullOrUndefined)
        defaultQueueValue = jsUndefined();
    else {
        defaultQueueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "defaultQueue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!defaultQueueValue.isUndefined()) {
        auto defaultQueueConversionResult = convert<IDLDictionary<GPUQueueDescriptor>>(lexicalGlobalObject, defaultQueueValue);
        if (defaultQueueConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.defaultQueue = defaultQueueConversionResult.releaseReturnValue();
    }
    JSValue requiredFeaturesValue;
    if (isNullOrUndefined)
        requiredFeaturesValue = jsUndefined();
    else {
        requiredFeaturesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requiredFeatures"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto requiredFeaturesConversionResult = convertOptionalWithDefault<IDLSequence<IDLEnumeration<GPUFeatureName>>>(lexicalGlobalObject, requiredFeaturesValue, [&]() -> ConversionResult<IDLSequence<IDLEnumeration<GPUFeatureName>>> { return Converter<IDLSequence<IDLEnumeration<GPUFeatureName>>>::ReturnType { }; });
    if (requiredFeaturesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.requiredFeatures = requiredFeaturesConversionResult.releaseReturnValue();
    JSValue requiredLimitsValue;
    if (isNullOrUndefined)
        requiredLimitsValue = jsUndefined();
    else {
        requiredLimitsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "requiredLimits"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!requiredLimitsValue.isUndefined()) {
        auto requiredLimitsConversionResult = convert<IDLRecord<IDLDOMString, IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>>(lexicalGlobalObject, requiredLimitsValue);
        if (requiredLimitsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.requiredLimits = requiredLimitsConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

