/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemDirectoryEntry.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileSystemDirectoryReader.h"
#include "JSFileSystemEntryCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<FileSystemDirectoryEntry::Flags>> convertDictionary<FileSystemDirectoryEntry::Flags>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FileSystemDirectoryEntry::Flags result;
    JSValue createValue;
    if (isNullOrUndefined)
        createValue = jsUndefined();
    else {
        createValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "create"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto createConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, createValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (createConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.create = createConversionResult.releaseReturnValue();
    JSValue exclusiveValue;
    if (isNullOrUndefined)
        exclusiveValue = jsUndefined();
    else {
        exclusiveValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "exclusive"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto exclusiveConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, exclusiveValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (exclusiveConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.exclusive = exclusiveConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryEntryPrototypeFunction_createReader);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryEntryPrototypeFunction_getFile);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemDirectoryEntryPrototypeFunction_getDirectory);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemDirectoryEntryConstructor);

class JSFileSystemDirectoryEntryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemDirectoryEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemDirectoryEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemDirectoryEntryPrototype>(vm)) JSFileSystemDirectoryEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryEntryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemDirectoryEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemDirectoryEntryPrototype, JSFileSystemDirectoryEntryPrototype::Base);

using JSFileSystemDirectoryEntryDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemDirectoryEntry>;

template<> const ClassInfo JSFileSystemDirectoryEntryDOMConstructor::s_info = { "FileSystemDirectoryEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryEntryDOMConstructor) };

template<> JSValue JSFileSystemDirectoryEntryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSFileSystemEntry::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemDirectoryEntryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemDirectoryEntry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemDirectoryEntry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSFileSystemDirectoryEntryPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemDirectoryEntryConstructor, 0 } },
    HashTableValue { "createReader"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryEntryPrototypeFunction_createReader, 0 } },
    HashTableValue { "getFile"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryEntryPrototypeFunction_getFile, 0 } },
    HashTableValue { "getDirectory"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemDirectoryEntryPrototypeFunction_getDirectory, 0 } },
};

const ClassInfo JSFileSystemDirectoryEntryPrototype::s_info = { "FileSystemDirectoryEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryEntryPrototype) };

void JSFileSystemDirectoryEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemDirectoryEntry::info(), JSFileSystemDirectoryEntryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemDirectoryEntry::s_info = { "FileSystemDirectoryEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemDirectoryEntry) };

JSFileSystemDirectoryEntry::JSFileSystemDirectoryEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemDirectoryEntry>&& impl)
    : JSFileSystemEntry(structure, globalObject, WTFMove(impl))
{
}

Ref<FileSystemDirectoryEntry> JSFileSystemDirectoryEntry::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemDirectoryEntry>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemDirectoryEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemDirectoryEntryPrototype::createStructure(vm, &globalObject, JSFileSystemEntry::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFileSystemDirectoryEntryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemDirectoryEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemDirectoryEntry>(vm, globalObject);
}

JSValue JSFileSystemDirectoryEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemDirectoryEntryDOMConstructor, DOMConstructorID::FileSystemDirectoryEntry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemDirectoryEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemDirectoryEntryPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemDirectoryEntry::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryEntryPrototypeFunction_createReaderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryEntry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<FileSystemDirectoryReader>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createReader(*context))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryEntryPrototypeFunction_createReader, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryEntry>::call<jsFileSystemDirectoryEntryPrototypeFunction_createReaderBody>(*lexicalGlobalObject, *callFrame, "createReader");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryEntryPrototypeFunction_getFileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryEntry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto pathConversionResult = convertOptionalWithDefault<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLNullable<IDLUSVString>> { return typename Converter<IDLNullable<IDLUSVString>>::ReturnType { String() }; });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<FileSystemDirectoryEntry::Flags>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSFileSystemEntryCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "successCallback"_s, "FileSystemDirectoryEntry"_s, "getFile"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, argument3.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback"_s, "FileSystemDirectoryEntry"_s, "getFile"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.getFile(*context, pathConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryEntryPrototypeFunction_getFile, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryEntry>::call<jsFileSystemDirectoryEntryPrototypeFunction_getFileBody>(*lexicalGlobalObject, *callFrame, "getFile");
}

static inline JSC::EncodedJSValue jsFileSystemDirectoryEntryPrototypeFunction_getDirectoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemDirectoryEntry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto pathConversionResult = convertOptionalWithDefault<IDLNullable<IDLUSVString>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLNullable<IDLUSVString>> { return typename Converter<IDLNullable<IDLUSVString>>::ReturnType { String() }; });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<FileSystemDirectoryEntry::Flags>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSFileSystemEntryCallback>>>(*lexicalGlobalObject, argument2.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 2, "successCallback"_s, "FileSystemDirectoryEntry"_s, "getDirectory"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, argument3.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 3, "errorCallback"_s, "FileSystemDirectoryEntry"_s, "getDirectory"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.getDirectory(*context, pathConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemDirectoryEntryPrototypeFunction_getDirectory, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemDirectoryEntry>::call<jsFileSystemDirectoryEntryPrototypeFunction_getDirectoryBody>(*lexicalGlobalObject, *callFrame, "getDirectory");
}

JSC::GCClient::IsoSubspace* JSFileSystemDirectoryEntry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemDirectoryEntry, UseCustomHeapCellType::No>(vm, "JSFileSystemDirectoryEntry"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemDirectoryEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemDirectoryEntry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemDirectoryEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemDirectoryEntry = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemDirectoryEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemDirectoryEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemDirectoryEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFileSystemDirectoryEntry = jsCast<JSFileSystemDirectoryEntry*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsFileSystemDirectoryEntry->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemDirectoryEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemDirectoryEntry = static_cast<JSFileSystemDirectoryEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileSystemDirectoryEntry->protectedWrapped().ptr(), jsFileSystemDirectoryEntry);
}


}
