/* SystemUser.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SystemUser.vala, do not modify */

/*
 * SystemUser.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef struct _SystemUserPrivate SystemUserPrivate;
enum  {
	SYSTEM_USER_0_PROPERTY,
	SYSTEM_USER_IS_SYSTEM_PROPERTY,
	SYSTEM_USER_GROUP_NAMES_PROPERTY,
	SYSTEM_USER_NUM_PROPERTIES
};
static GParamSpec* system_user_properties[SYSTEM_USER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SystemUser {
	GObject parent_instance;
	SystemUserPrivate * priv;
	gchar* name;
	gchar* password;
	gint uid;
	gint gid;
	gchar* user_info;
	gchar* home_path;
	gchar* shell_path;
	gchar* full_name;
	gchar* room_num;
	gchar* phone_work;
	gchar* phone_home;
	gchar* other_info;
	gboolean has_encrypted_home;
	gboolean has_encrypted_private_dirs;
	GeeArrayList* encrypted_dirs;
	GeeArrayList* encrypted_private_dirs;
	gboolean is_selected;
};

struct _SystemUserClass {
	GObjectClass parent_class;
};

static gpointer system_user_parent_class = NULL;
VALA_EXTERN GeeHashMap* system_user_all_users;
GeeHashMap* system_user_all_users = NULL;

VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN SystemUser* system_user_new (const gchar* name);
VALA_EXTERN SystemUser* system_user_construct (GType object_type,
                                   const gchar* name);
VALA_EXTERN void system_user_query_users (void);
VALA_EXTERN GeeHashMap* system_user_read_users_from_file (const gchar* passwd_file);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
static SystemUser* system_user_parse_line_passwd (const gchar* line);
VALA_EXTERN void system_user_check_encrypted_dirs (SystemUser* self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN GeeArrayList* system_user_get_all_users_sorted (void);
static gint _system_user_all_users_sorted___lambda16_ (SystemUser* a,
                                                SystemUser* b);
static gint __system_user_all_users_sorted___lambda16__gcompare_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self);
VALA_EXTERN gboolean system_user_get_is_system (SystemUser* self);
VALA_EXTERN gchar* system_user_get_group_names (SystemUser* self);
static void system_user_finalize (GObject * obj);
static GType system_user_get_type_once (void);
static void _vala_system_user_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

SystemUser*
system_user_construct (GType object_type,
                       const gchar* name)
{
	SystemUser * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SystemUser*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

SystemUser*
system_user_new (const gchar* name)
{
	return system_user_construct (TYPE_SYSTEM_USER, name);
}

void
system_user_query_users (void)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = system_user_read_users_from_file ("/etc/passwd");
	_g_object_unref0 (system_user_all_users);
	system_user_all_users = _tmp0_;
}

GeeHashMap*
system_user_read_users_from_file (const gchar* passwd_file)
{
	GeeHashMap* list = NULL;
	GeeHashMap* _tmp0_;
	gchar* txt = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	GeeHashMap* result;
	g_return_val_if_fail (passwd_file != NULL, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_SYSTEM_USER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	list = _tmp0_;
	_tmp1_ = tee_jee_file_system_file_read (passwd_file);
	txt = _tmp1_;
	_tmp2_ = txt;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = list;
		_g_free0 (txt);
		return result;
	}
	_tmp5_ = txt;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp7_;
		line_collection_length1 = _vala_array_length (_tmp6_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp8_;
			gchar* line = NULL;
			_tmp8_ = g_strdup (line_collection[line_it]);
			line = _tmp8_;
			{
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_;
				SystemUser* user = NULL;
				const gchar* _tmp14_;
				SystemUser* _tmp15_;
				SystemUser* _tmp16_;
				_tmp10_ = line;
				if (_tmp10_ == NULL) {
					_tmp9_ = TRUE;
				} else {
					const gchar* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					_tmp11_ = line;
					_tmp12_ = strlen (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp9_ = _tmp13_ == 0;
				}
				if (_tmp9_) {
					_g_free0 (line);
					continue;
				}
				_tmp14_ = line;
				_tmp15_ = system_user_parse_line_passwd (_tmp14_);
				user = _tmp15_;
				_tmp16_ = user;
				if (_tmp16_ != NULL) {
					GeeHashMap* _tmp17_;
					SystemUser* _tmp18_;
					const gchar* _tmp19_;
					SystemUser* _tmp20_;
					_tmp17_ = list;
					_tmp18_ = user;
					_tmp19_ = _tmp18_->name;
					_tmp20_ = user;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp19_, _tmp20_);
				}
				_g_object_unref0 (user);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = list;
	_g_free0 (txt);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static SystemUser*
system_user_parse_line_passwd (const gchar* line)
{
	gboolean _tmp0_ = FALSE;
	SystemUser* user = NULL;
	gchar** fields = NULL;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint fields_length1;
	gint _fields_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	SystemUser* result;
	g_return_val_if_fail (line != NULL, NULL);
	if (line == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (line);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	user = NULL;
	_tmp4_ = _tmp3_ = g_strsplit (line, ":", 0);
	fields = _tmp4_;
	fields_length1 = _vala_array_length (_tmp3_);
	_fields_size_ = fields_length1;
	_tmp5_ = fields;
	_tmp5__length1 = fields_length1;
	if (_tmp5__length1 == 7) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		SystemUser* _tmp10_;
		SystemUser* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		SystemUser* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		SystemUser* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		SystemUser* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		SystemUser* _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		SystemUser* _tmp33_;
		gchar** _tmp34_;
		gint _tmp34__length1;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar** arr = NULL;
		SystemUser* _tmp37_;
		const gchar* _tmp38_;
		gchar** _tmp39_;
		gchar** _tmp40_;
		gint arr_length1;
		gint _arr_size_;
		gchar** _tmp41_;
		gint _tmp41__length1;
		gchar** _tmp46_;
		gint _tmp46__length1;
		gchar** _tmp51_;
		gint _tmp51__length1;
		gchar** _tmp56_;
		gint _tmp56__length1;
		gchar** _tmp61_;
		gint _tmp61__length1;
		SystemUser* _tmp66_;
		_tmp6_ = fields;
		_tmp6__length1 = fields_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = string_strip (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = system_user_new (_tmp9_);
		_g_object_unref0 (user);
		user = _tmp10_;
		_g_free0 (_tmp9_);
		_tmp11_ = user;
		_tmp12_ = fields;
		_tmp12__length1 = fields_length1;
		_tmp13_ = _tmp12_[1];
		_tmp14_ = string_strip (_tmp13_);
		_g_free0 (_tmp11_->password);
		_tmp11_->password = _tmp14_;
		_tmp15_ = user;
		_tmp16_ = fields;
		_tmp16__length1 = fields_length1;
		_tmp17_ = _tmp16_[2];
		_tmp18_ = string_strip (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp15_->uid = atoi (_tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = user;
		_tmp21_ = fields;
		_tmp21__length1 = fields_length1;
		_tmp22_ = _tmp21_[3];
		_tmp23_ = string_strip (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_->gid = atoi (_tmp24_);
		_g_free0 (_tmp24_);
		_tmp25_ = user;
		_tmp26_ = fields;
		_tmp26__length1 = fields_length1;
		_tmp27_ = _tmp26_[4];
		_tmp28_ = string_strip (_tmp27_);
		_g_free0 (_tmp25_->user_info);
		_tmp25_->user_info = _tmp28_;
		_tmp29_ = user;
		_tmp30_ = fields;
		_tmp30__length1 = fields_length1;
		_tmp31_ = _tmp30_[5];
		_tmp32_ = string_strip (_tmp31_);
		_g_free0 (_tmp29_->home_path);
		_tmp29_->home_path = _tmp32_;
		_tmp33_ = user;
		_tmp34_ = fields;
		_tmp34__length1 = fields_length1;
		_tmp35_ = _tmp34_[6];
		_tmp36_ = string_strip (_tmp35_);
		_g_free0 (_tmp33_->shell_path);
		_tmp33_->shell_path = _tmp36_;
		_tmp37_ = user;
		_tmp38_ = _tmp37_->user_info;
		_tmp40_ = _tmp39_ = g_strsplit (_tmp38_, ",", 0);
		arr = _tmp40_;
		arr_length1 = _vala_array_length (_tmp39_);
		_arr_size_ = arr_length1;
		_tmp41_ = arr;
		_tmp41__length1 = arr_length1;
		if (_tmp41__length1 >= 1) {
			SystemUser* _tmp42_;
			gchar** _tmp43_;
			gint _tmp43__length1;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp42_ = user;
			_tmp43_ = arr;
			_tmp43__length1 = arr_length1;
			_tmp44_ = _tmp43_[0];
			_tmp45_ = g_strdup (_tmp44_);
			_g_free0 (_tmp42_->full_name);
			_tmp42_->full_name = _tmp45_;
		}
		_tmp46_ = arr;
		_tmp46__length1 = arr_length1;
		if (_tmp46__length1 >= 2) {
			SystemUser* _tmp47_;
			gchar** _tmp48_;
			gint _tmp48__length1;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp47_ = user;
			_tmp48_ = arr;
			_tmp48__length1 = arr_length1;
			_tmp49_ = _tmp48_[1];
			_tmp50_ = g_strdup (_tmp49_);
			_g_free0 (_tmp47_->room_num);
			_tmp47_->room_num = _tmp50_;
		}
		_tmp51_ = arr;
		_tmp51__length1 = arr_length1;
		if (_tmp51__length1 >= 3) {
			SystemUser* _tmp52_;
			gchar** _tmp53_;
			gint _tmp53__length1;
			const gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp52_ = user;
			_tmp53_ = arr;
			_tmp53__length1 = arr_length1;
			_tmp54_ = _tmp53_[2];
			_tmp55_ = g_strdup (_tmp54_);
			_g_free0 (_tmp52_->phone_work);
			_tmp52_->phone_work = _tmp55_;
		}
		_tmp56_ = arr;
		_tmp56__length1 = arr_length1;
		if (_tmp56__length1 >= 4) {
			SystemUser* _tmp57_;
			gchar** _tmp58_;
			gint _tmp58__length1;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp57_ = user;
			_tmp58_ = arr;
			_tmp58__length1 = arr_length1;
			_tmp59_ = _tmp58_[3];
			_tmp60_ = g_strdup (_tmp59_);
			_g_free0 (_tmp57_->phone_home);
			_tmp57_->phone_home = _tmp60_;
		}
		_tmp61_ = arr;
		_tmp61__length1 = arr_length1;
		if (_tmp61__length1 >= 5) {
			SystemUser* _tmp62_;
			gchar** _tmp63_;
			gint _tmp63__length1;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp62_ = user;
			_tmp63_ = arr;
			_tmp63__length1 = arr_length1;
			_tmp64_ = _tmp63_[4];
			_tmp65_ = g_strdup (_tmp64_);
			_g_free0 (_tmp62_->other_info);
			_tmp62_->other_info = _tmp65_;
		}
		_tmp66_ = user;
		system_user_check_encrypted_dirs (_tmp66_);
		arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar** _tmp67_;
		gint _tmp67__length1;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp67_ = fields;
		_tmp67__length1 = fields_length1;
		_tmp68_ = g_strdup_printf (": %d", _tmp67__length1);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strconcat ("'passwd' file contains a record with non-standard fields", _tmp69_, NULL);
		_tmp71_ = _tmp70_;
		tee_jee_logging_log_error (_tmp71_, FALSE, FALSE);
		_g_free0 (_tmp71_);
		_g_free0 (_tmp69_);
		result = NULL;
		fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (user);
		return result;
	}
	result = user;
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
system_user_check_encrypted_dirs (SystemUser* self)
{
	gchar* ecryptfs_mount_file = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->name;
	_tmp1_ = g_strdup_printf ("/home/.ecryptfs/%s/.ecryptfs/Private.mnt", _tmp0_);
	ecryptfs_mount_file = _tmp1_;
	_tmp2_ = ecryptfs_mount_file;
	if (tee_jee_file_system_file_exists (_tmp2_)) {
		gchar* txt = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		_tmp3_ = ecryptfs_mount_file;
		_tmp4_ = tee_jee_file_system_file_read (_tmp3_);
		txt = _tmp4_;
		_tmp5_ = txt;
		_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "\n", 0);
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp7_;
			line_collection_length1 = _vala_array_length (_tmp6_);
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp8_;
				gchar* line = NULL;
				_tmp8_ = g_strdup (line_collection[line_it]);
				line = _tmp8_;
				{
					gchar* path = NULL;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					GeeArrayList* _tmp16_;
					const gchar* _tmp17_;
					_tmp9_ = line;
					_tmp10_ = string_strip (_tmp9_);
					path = _tmp10_;
					_tmp11_ = path;
					_tmp12_ = strlen (_tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_ == 0) {
						_g_free0 (path);
						_g_free0 (line);
						continue;
					}
					_tmp14_ = path;
					_tmp15_ = self->home_path;
					if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
						self->has_encrypted_home = TRUE;
					}
					_tmp16_ = self->encrypted_dirs;
					_tmp17_ = path;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
					_g_free0 (path);
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (txt);
	}
	_tmp18_ = self->home_path;
	_tmp19_ = g_strdup_printf ("%s/.ecryptfs/Private.mnt", _tmp18_);
	_g_free0 (ecryptfs_mount_file);
	ecryptfs_mount_file = _tmp19_;
	_tmp20_ = ecryptfs_mount_file;
	if (tee_jee_file_system_file_exists (_tmp20_)) {
		gchar* txt = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		_tmp21_ = ecryptfs_mount_file;
		_tmp22_ = tee_jee_file_system_file_read (_tmp21_);
		txt = _tmp22_;
		_tmp23_ = txt;
		_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, "\n", 0);
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp25_;
			line_collection_length1 = _vala_array_length (_tmp24_);
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp26_;
				gchar* line = NULL;
				_tmp26_ = g_strdup (line_collection[line_it]);
				line = _tmp26_;
				{
					gchar* path = NULL;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					GeeArrayList* _tmp36_;
					const gchar* _tmp37_;
					_tmp27_ = line;
					_tmp28_ = string_strip (_tmp27_);
					path = _tmp28_;
					_tmp29_ = path;
					_tmp30_ = strlen (_tmp29_);
					_tmp31_ = _tmp30_;
					if (_tmp31_ == 0) {
						_g_free0 (path);
						_g_free0 (line);
						continue;
					}
					_tmp32_ = path;
					_tmp33_ = self->home_path;
					if (g_strcmp0 (_tmp32_, _tmp33_) != 0) {
						GeeArrayList* _tmp34_;
						const gchar* _tmp35_;
						self->has_encrypted_private_dirs = TRUE;
						_tmp34_ = self->encrypted_private_dirs;
						_tmp35_ = path;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
					}
					_tmp36_ = self->encrypted_dirs;
					_tmp37_ = path;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp37_);
					_g_free0 (path);
					_g_free0 (line);
				}
			}
			line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (txt);
	}
	_g_free0 (ecryptfs_mount_file);
}

static gint
_system_user_all_users_sorted___lambda16_ (SystemUser* a,
                                           SystemUser* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->name;
	_tmp2_ = b->name;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gint
__system_user_all_users_sorted___lambda16__gcompare_data_func (gconstpointer a,
                                                               gconstpointer b,
                                                               gpointer self)
{
	gint result;
	result = _system_user_all_users_sorted___lambda16_ ((SystemUser*) a, (SystemUser*) b);
	return result;
}

GeeArrayList*
system_user_get_all_users_sorted (void)
{
	GeeArrayList* result;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp12_;
	_tmp0_ = gee_array_list_new (TYPE_SYSTEM_USER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeIterator* _user_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = system_user_all_users;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_user_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			SystemUser* user = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeArrayList* _tmp10_;
			SystemUser* _tmp11_;
			_tmp7_ = _user_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _user_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			user = (SystemUser*) _tmp9_;
			_tmp10_ = list;
			_tmp11_ = user;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			_g_object_unref0 (user);
		}
		_g_object_unref0 (_user_it);
	}
	_tmp12_ = list;
	gee_list_sort ((GeeList*) _tmp12_, __system_user_all_users_sorted___lambda16__gcompare_data_func, NULL, NULL);
	result = list;
	return result;
}

gboolean
system_user_get_is_system (SystemUser* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->uid != 0) {
		_tmp2_ = self->uid < 1000;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->uid == 65534;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->name;
		_tmp0_ = g_strcmp0 (_tmp3_, "PinguyBuilder") == 0;
	}
	result = _tmp0_;
	return result;
}

gchar*
system_user_get_group_names (SystemUser* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}

static void
system_user_class_init (SystemUserClass * klass,
                        gpointer klass_data)
{
	system_user_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_system_user_get_property;
	G_OBJECT_CLASS (klass)->finalize = system_user_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYSTEM_USER_IS_SYSTEM_PROPERTY, system_user_properties[SYSTEM_USER_IS_SYSTEM_PROPERTY] = g_param_spec_boolean ("is-system", "is-system", "is-system", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYSTEM_USER_GROUP_NAMES_PROPERTY, system_user_properties[SYSTEM_USER_GROUP_NAMES_PROPERTY] = g_param_spec_string ("group-names", "group-names", "group-names", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
system_user_instance_init (SystemUser * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	_tmp0_ = g_strdup ("");
	self->name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->password = _tmp1_;
	self->uid = -1;
	self->gid = -1;
	_tmp2_ = g_strdup ("");
	self->user_info = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->home_path = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->shell_path = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->full_name = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->room_num = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->phone_work = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->phone_home = _tmp8_;
	_tmp9_ = g_strdup ("");
	self->other_info = _tmp9_;
	self->has_encrypted_home = FALSE;
	self->has_encrypted_private_dirs = FALSE;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->encrypted_dirs = _tmp10_;
	_tmp11_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->encrypted_private_dirs = _tmp11_;
	self->is_selected = FALSE;
}

static void
system_user_finalize (GObject * obj)
{
	SystemUser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYSTEM_USER, SystemUser);
	_g_free0 (self->name);
	_g_free0 (self->password);
	_g_free0 (self->user_info);
	_g_free0 (self->home_path);
	_g_free0 (self->shell_path);
	_g_free0 (self->full_name);
	_g_free0 (self->room_num);
	_g_free0 (self->phone_work);
	_g_free0 (self->phone_home);
	_g_free0 (self->other_info);
	_g_object_unref0 (self->encrypted_dirs);
	_g_object_unref0 (self->encrypted_private_dirs);
	G_OBJECT_CLASS (system_user_parent_class)->finalize (obj);
}

static GType
system_user_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SystemUserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) system_user_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SystemUser), 0, (GInstanceInitFunc) system_user_instance_init, NULL };
	GType system_user_type_id;
	system_user_type_id = g_type_register_static (G_TYPE_OBJECT, "SystemUser", &g_define_type_info, 0);
	return system_user_type_id;
}

GType
system_user_get_type (void)
{
	static volatile gsize system_user_type_id__once = 0;
	if (g_once_init_enter (&system_user_type_id__once)) {
		GType system_user_type_id;
		system_user_type_id = system_user_get_type_once ();
		g_once_init_leave (&system_user_type_id__once, system_user_type_id);
	}
	return system_user_type_id__once;
}

static void
_vala_system_user_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SystemUser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SYSTEM_USER, SystemUser);
	switch (property_id) {
		case SYSTEM_USER_IS_SYSTEM_PROPERTY:
		g_value_set_boolean (value, system_user_get_is_system (self));
		break;
		case SYSTEM_USER_GROUP_NAMES_PROPERTY:
		g_value_take_string (value, system_user_get_group_names (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

