/* THIS FILE IS AUTOGENERATED FROM LoadURIOptions.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "LoadURIOptionsBinding.h"
#include "MainThreadUtils.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<ForceMediaDocument>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ForceMediaDocument aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<ForceMediaDocument>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<ForceMediaDocument>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<ForceMediaDocument>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



LoadURIOptions::LoadURIOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LoadURIOptions::InitIds(JSContext* cx, LoadURIOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->triggeringWindowId_id.init(cx, "triggeringWindowId") ||
      !atomsCache->triggeringStorageAccess_id.init(cx, "triggeringStorageAccess") ||
      !atomsCache->triggeringSandboxFlags_id.init(cx, "triggeringSandboxFlags") ||
      !atomsCache->triggeringRemoteType_id.init(cx, "triggeringRemoteType") ||
      !atomsCache->triggeringPrincipal_id.init(cx, "triggeringPrincipal") ||
      !atomsCache->textDirectiveUserActivation_id.init(cx, "textDirectiveUserActivation") ||
      !atomsCache->schemelessInput_id.init(cx, "schemelessInput") ||
      !atomsCache->remoteTypeOverride_id.init(cx, "remoteTypeOverride") ||
      !atomsCache->referrerInfo_id.init(cx, "referrerInfo") ||
      !atomsCache->postData_id.init(cx, "postData") ||
      !atomsCache->policyContainer_id.init(cx, "policyContainer") ||
      !atomsCache->loadFlags_id.init(cx, "loadFlags") ||
      !atomsCache->headers_id.init(cx, "headers") ||
      !atomsCache->hasValidUserGestureActivation_id.init(cx, "hasValidUserGestureActivation") ||
      !atomsCache->forceMediaDocument_id.init(cx, "forceMediaDocument") ||
      !atomsCache->cancelContentJSEpoch_id.init(cx, "cancelContentJSEpoch") ||
      !atomsCache->baseURI_id.init(cx, "baseURI")) {
    return false;
  }
  return true;
}

bool
LoadURIOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LoadURIOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LoadURIOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->baseURI_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIURI>::value, "We can only store refcounted classes.");
      RefPtr<nsIURI> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIURI>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'baseURI' member of LoadURIOptions", "URI");
        return false;
      }
      MOZ_ASSERT(holder);
      mBaseURI = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mBaseURI = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'baseURI' member of LoadURIOptions");
      return false;
    }
  } else {
    mBaseURI = nullptr;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->cancelContentJSEpoch_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'cancelContentJSEpoch' member of LoadURIOptions", &mCancelContentJSEpoch)) {
      return false;
    }
  } else {
    mCancelContentJSEpoch = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->forceMediaDocument_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<ForceMediaDocument>::Values,
                                                                         "ForceMediaDocument", "'forceMediaDocument' member of LoadURIOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mForceMediaDocument = static_cast<ForceMediaDocument>(index);
    }
  } else {
    mForceMediaDocument = ForceMediaDocument::None;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->hasValidUserGestureActivation_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'hasValidUserGestureActivation' member of LoadURIOptions", &mHasValidUserGestureActivation)) {
      return false;
    }
  } else {
    mHasValidUserGestureActivation = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->headers_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIInputStream>::value, "We can only store refcounted classes.");
      RefPtr<nsIInputStream> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIInputStream>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'headers' member of LoadURIOptions", "InputStream");
        return false;
      }
      MOZ_ASSERT(holder);
      mHeaders = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mHeaders = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'headers' member of LoadURIOptions");
      return false;
    }
  } else {
    mHeaders = nullptr;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->loadFlags_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'loadFlags' member of LoadURIOptions", &mLoadFlags)) {
      return false;
    }
  } else {
    mLoadFlags = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->policyContainer_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIPolicyContainer>::value, "We can only store refcounted classes.");
      RefPtr<nsIPolicyContainer> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIPolicyContainer>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'policyContainer' member of LoadURIOptions", "PolicyContainer");
        return false;
      }
      MOZ_ASSERT(holder);
      mPolicyContainer = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mPolicyContainer = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'policyContainer' member of LoadURIOptions");
      return false;
    }
  } else {
    mPolicyContainer = nullptr;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->postData_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIInputStream>::value, "We can only store refcounted classes.");
      RefPtr<nsIInputStream> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIInputStream>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'postData' member of LoadURIOptions", "InputStream");
        return false;
      }
      MOZ_ASSERT(holder);
      mPostData = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mPostData = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'postData' member of LoadURIOptions");
      return false;
    }
  } else {
    mPostData = nullptr;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->referrerInfo_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIReferrerInfo>::value, "We can only store refcounted classes.");
      RefPtr<nsIReferrerInfo> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIReferrerInfo>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'referrerInfo' member of LoadURIOptions", "ReferrerInfo");
        return false;
      }
      MOZ_ASSERT(holder);
      mReferrerInfo = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mReferrerInfo = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'referrerInfo' member of LoadURIOptions");
      return false;
    }
  } else {
    mReferrerInfo = nullptr;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->remoteTypeOverride_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRemoteTypeOverride.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, (mRemoteTypeOverride.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->schemelessInput_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint8_t, eDefault>(cx, temp.ref(), "'schemelessInput' member of LoadURIOptions", &mSchemelessInput)) {
      return false;
    }
  } else {
    mSchemelessInput = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->textDirectiveUserActivation_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'textDirectiveUserActivation' member of LoadURIOptions", &mTextDirectiveUserActivation)) {
      return false;
    }
  } else {
    mTextDirectiveUserActivation = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->triggeringPrincipal_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      static_assert(IsRefcounted<nsIPrincipal>::value, "We can only store refcounted classes.");
      RefPtr<nsIPrincipal> holder;
      JS::Rooted<JSObject*> source(cx, &temp.ref().toObject());
      if (NS_FAILED(UnwrapArg<nsIPrincipal>(cx, source, getter_AddRefs(holder)))) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("'triggeringPrincipal' member of LoadURIOptions", "Principal");
        return false;
      }
      MOZ_ASSERT(holder);
      mTriggeringPrincipal = holder;
    } else if (temp.ref().isNullOrUndefined()) {
      mTriggeringPrincipal = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("'triggeringPrincipal' member of LoadURIOptions");
      return false;
    }
  } else {
    mTriggeringPrincipal = nullptr;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->triggeringRemoteType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTriggeringRemoteType.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, (mTriggeringRemoteType.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->triggeringSandboxFlags_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'triggeringSandboxFlags' member of LoadURIOptions", &mTriggeringSandboxFlags)) {
      return false;
    }
  } else {
    mTriggeringSandboxFlags = 0U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->triggeringStorageAccess_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'triggeringStorageAccess' member of LoadURIOptions", &mTriggeringStorageAccess)) {
      return false;
    }
  } else {
    mTriggeringStorageAccess = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->triggeringWindowId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint64_t, eDefault>(cx, temp.ref(), "'triggeringWindowId' member of LoadURIOptions", &mTriggeringWindowId)) {
      return false;
    }
  } else {
    mTriggeringWindowId = 0ULL;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LoadURIOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LoadURIOptions::TraceDictionary(JSTracer* trc)
{
}



LoadURIOptions&
LoadURIOptions::operator=(const LoadURIOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mBaseURI = aOther.mBaseURI;
  mCancelContentJSEpoch = aOther.mCancelContentJSEpoch;
  mForceMediaDocument = aOther.mForceMediaDocument;
  mHasValidUserGestureActivation = aOther.mHasValidUserGestureActivation;
  mHeaders = aOther.mHeaders;
  mLoadFlags = aOther.mLoadFlags;
  mPolicyContainer = aOther.mPolicyContainer;
  mPostData = aOther.mPostData;
  mReferrerInfo = aOther.mReferrerInfo;
  mRemoteTypeOverride.Reset();
  if (aOther.mRemoteTypeOverride.WasPassed()) {
    mRemoteTypeOverride.Construct(aOther.mRemoteTypeOverride.Value());
  }
  mSchemelessInput = aOther.mSchemelessInput;
  mTextDirectiveUserActivation = aOther.mTextDirectiveUserActivation;
  mTriggeringPrincipal = aOther.mTriggeringPrincipal;
  mTriggeringRemoteType.Reset();
  if (aOther.mTriggeringRemoteType.WasPassed()) {
    mTriggeringRemoteType.Construct(aOther.mTriggeringRemoteType.Value());
  }
  mTriggeringSandboxFlags = aOther.mTriggeringSandboxFlags;
  mTriggeringStorageAccess = aOther.mTriggeringStorageAccess;
  mTriggeringWindowId = aOther.mTriggeringWindowId;
  return *this;
}


} // namespace dom


} // namespace mozilla
