// Code generated by smithy-go-codegen DO NOT EDIT.

package ecr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ecr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the artifacts associated with a specified subject image.
func (c *Client) ListImageReferrers(ctx context.Context, params *ListImageReferrersInput, optFns ...func(*Options)) (*ListImageReferrersOutput, error) {
	if params == nil {
		params = &ListImageReferrersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListImageReferrers", params, optFns, c.addOperationListImageReferrersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListImageReferrersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListImageReferrersInput struct {

	// The name of the repository that contains the subject image.
	//
	// This member is required.
	RepositoryName *string

	// An object containing the image digest of the subject image for which to
	// retrieve associated artifacts.
	//
	// This member is required.
	SubjectId *types.SubjectIdentifier

	// The filter key and value with which to filter your ListImageReferrers results.
	// If no filter is specified, only artifacts with ACTIVE status are returned.
	Filter *types.ListImageReferrersFilter

	// The maximum number of image referrer results returned by ListImageReferrers in
	// paginated output. When this parameter is used, ListImageReferrers only returns
	// maxResults results in a single page along with a nextToken response element.
	// The remaining results of the initial request can be seen by sending another
	// ListImageReferrers request with the returned nextToken value. This value can be
	// between 1 and 50. If this parameter is not used, then ListImageReferrers
	// returns up to 50 results and a nextToken value, if applicable.
	MaxResults *int32

	// The nextToken value returned from a previous paginated ListImageReferrers
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value. This value is null when there are no more results
	// to return.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string

	// The Amazon Web Services account ID associated with the registry that contains
	// the repository in which to list image referrers. If you do not specify a
	// registry, the default registry is assumed.
	RegistryId *string

	noSmithyDocumentSerde
}

type ListImageReferrersOutput struct {

	// The nextToken value to include in a future ListImageReferrers request. When the
	// results of a ListImageReferrers request exceed maxResults , this value can be
	// used to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string

	// The list of artifacts associated with the subject image.
	Referrers []types.ImageReferrer

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListImageReferrersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListImageReferrers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListImageReferrers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListImageReferrers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListImageReferrersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListImageReferrers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListImageReferrers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListImageReferrers",
	}
}
