// third_party/blink/public/mojom/ai/ai_summarizer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ai/ai_summarizer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_summarizer.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AISummarizerTypeToStringHelper(AISummarizerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AISummarizerType::kTLDR:
      return "kTLDR";
    case AISummarizerType::kKeyPoints:
      return "kKeyPoints";
    case AISummarizerType::kTeaser:
      return "kTeaser";
    case AISummarizerType::kHeadline:
      return "kHeadline";
    default:
      return nullptr;
  }
}

std::string AISummarizerTypeToString(AISummarizerType value) {
  const char *str = AISummarizerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AISummarizerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AISummarizerType value) {
  return os << AISummarizerTypeToString(value);
}

NOINLINE static const char* AISummarizerFormatToStringHelper(AISummarizerFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AISummarizerFormat::kPlainText:
      return "kPlainText";
    case AISummarizerFormat::kMarkDown:
      return "kMarkDown";
    default:
      return nullptr;
  }
}

std::string AISummarizerFormatToString(AISummarizerFormat value) {
  const char *str = AISummarizerFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AISummarizerFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AISummarizerFormat value) {
  return os << AISummarizerFormatToString(value);
}

NOINLINE static const char* AISummarizerLengthToStringHelper(AISummarizerLength value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AISummarizerLength::kShort:
      return "kShort";
    case AISummarizerLength::kMedium:
      return "kMedium";
    case AISummarizerLength::kLong:
      return "kLong";
    default:
      return nullptr;
  }
}

std::string AISummarizerLengthToString(AISummarizerLength value) {
  const char *str = AISummarizerLengthToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AISummarizerLength value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AISummarizerLength value) {
  return os << AISummarizerLengthToString(value);
}

namespace internal {


// static
bool AISummarizerCreateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AISummarizerCreateOptions_Data* object =
      static_cast<const AISummarizerCreateOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& shared_context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shared_context, validation_context,
                                         &shared_context_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::AISummarizerType_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::blink::mojom::internal::AISummarizerFormat_Data
        ::Validate(object->format, validation_context))
    return false;


  if (!::blink::mojom::internal::AISummarizerLength_Data
        ::Validate(object->length, validation_context))
    return false;

  return true;
}

AISummarizerCreateOptions_Data::AISummarizerCreateOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AISummarizer_Summarize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AISummarizer_Summarize_Params_Data* object =
      static_cast<const AISummarizer_Summarize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->context, validation_context,
                                         &context_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AISummarizer_Summarize_Params_Data::AISummarizer_Summarize_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AISummarizerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AISummarizerType value) {
  return std::move(context).WriteString(::blink::mojom::AISummarizerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AISummarizerFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AISummarizerFormat value) {
  return std::move(context).WriteString(::blink::mojom::AISummarizerFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AISummarizerLength>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AISummarizerLength value) {
  return std::move(context).WriteString(::blink::mojom::AISummarizerLengthToString(value));
}

} // namespace perfetto