// extensions/common/mojom/automation_registry.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_AUTOMATION_REGISTRY_MOJOM_H_
#define EXTENSIONS_COMMON_MOJOM_AUTOMATION_REGISTRY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/automation_registry.mojom-features.h"  // IWYU pragma: export
#include "extensions/common/mojom/automation_registry.mojom-shared.h"  // IWYU pragma: export
#include "extensions/common/mojom/automation_registry.mojom-forward.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/automation.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace extensions::mojom {

class RendererAutomationRegistryProxy;

template <typename ImplRefTraits>
class RendererAutomationRegistryStub;

class RendererAutomationRegistryRequestValidator;


class RendererAutomationRegistry
    : public RendererAutomationRegistryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererAutomationRegistryInterfaceBase;
  using Proxy_ = RendererAutomationRegistryProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererAutomationRegistryStub<ImplRefTraits>;

  using RequestValidator_ = RendererAutomationRegistryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindAutomationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindAutomation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererAutomationRegistry() = default;

  
  virtual void BindAutomation(::mojo::PendingAssociatedRemote<::ax::mojom::Automation> automation) = 0;
};



class  RendererAutomationRegistryProxy
    : public RendererAutomationRegistry {
 public:
  using InterfaceType = RendererAutomationRegistry;

  explicit RendererAutomationRegistryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAutomation(::mojo::PendingAssociatedRemote<::ax::mojom::Automation> automation) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RendererAutomationRegistryStubDispatch {
 public:
  static bool Accept(RendererAutomationRegistry* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererAutomationRegistry* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererAutomationRegistry>>
class RendererAutomationRegistryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererAutomationRegistryStub() = default;
  ~RendererAutomationRegistryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAutomationRegistryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAutomationRegistryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererAutomationRegistryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // extensions::mojom

namespace mojo {

}  // namespace mojo

#endif  // EXTENSIONS_COMMON_MOJOM_AUTOMATION_REGISTRY_MOJOM_H_