// third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_MAIN_SCRIPT_LOAD_PARAMS_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_MAIN_SCRIPT_LOAD_PARAMS_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
WorkerMainScriptLoadParams::WorkerMainScriptLoadParams()
    : response_head(),
      response_body(),
      url_loader_client_endpoints(),
      redirect_infos(),
      redirect_response_heads() {}

WorkerMainScriptLoadParams::WorkerMainScriptLoadParams(
    ::network::mojom::URLResponseHeadPtr response_head_in,
    ::mojo::ScopedDataPipeConsumerHandle response_body_in,
    ::network::mojom::URLLoaderClientEndpointsPtr url_loader_client_endpoints_in,
    std::vector<::net::RedirectInfo> redirect_infos_in,
    std::vector<::network::mojom::URLResponseHeadPtr> redirect_response_heads_in)
    : response_head(std::move(response_head_in)),
      response_body(std::move(response_body_in)),
      url_loader_client_endpoints(std::move(url_loader_client_endpoints_in)),
      redirect_infos(std::move(redirect_infos_in)),
      redirect_response_heads(std::move(redirect_response_heads_in)) {}

WorkerMainScriptLoadParams::~WorkerMainScriptLoadParams() = default;

void WorkerMainScriptLoadParams::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->response_head.is_null()) {
    value->SetString("response_head", "nullptr");
  } else {
    value->BeginDictionary("response_head");
    this->response_head->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("response_body", this->response_body.is_valid());
  if (this->url_loader_client_endpoints.is_null()) {
    value->SetString("url_loader_client_endpoints", "nullptr");
  } else {
    value->BeginDictionary("url_loader_client_endpoints");
    this->url_loader_client_endpoints->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("redirect_infos");
  for (const auto& item0 : this->redirect_infos) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::net::RedirectInfo&>"));
  }
  value->EndArray();
  value->BeginArray("redirect_response_heads");
  for (const auto& item0 : this->redirect_response_heads) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool WorkerMainScriptLoadParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::WorkerMainScriptLoadParams::DataView, ::blink::mojom::WorkerMainScriptLoadParamsPtr>::Read(
    ::blink::mojom::WorkerMainScriptLoadParams::DataView input,
    ::blink::mojom::WorkerMainScriptLoadParamsPtr* output) {
  bool success = true;
  ::blink::mojom::WorkerMainScriptLoadParamsPtr result(::blink::mojom::WorkerMainScriptLoadParams::New());
  
      if (success && !input.ReadResponseHead(&result->response_head))
        success = false;
      if (success)
        result->response_body = input.TakeResponseBody();
      if (success && !input.ReadUrlLoaderClientEndpoints(&result->url_loader_client_endpoints))
        success = false;
      if (success && !input.ReadRedirectInfos(&result->redirect_infos))
        success = false;
      if (success && !input.ReadRedirectResponseHeads(&result->redirect_response_heads))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif