// third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/screen_orientation.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class DeviceEmulationParamsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DeviceEmulationParamsDataView> {
  using Data = ::blink::mojom::internal::DeviceEmulationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class EmulatedScreenType : int32_t {
  
  kDesktop = 0,
  
  kMobile = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EmulatedScreenType value);
inline bool IsKnownEnumValue(EmulatedScreenType value) {
  return internal::EmulatedScreenType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DeviceEmulationParamsDataView {
 public:
  DeviceEmulationParamsDataView() {}

  DeviceEmulationParamsDataView(
      internal::DeviceEmulationParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScreenType(UserType* output) const {
    auto data_value = data_->screen_type;
    return mojo::internal::Deserialize<::blink::mojom::EmulatedScreenType>(
        data_value, output);
  }

  EmulatedScreenType screen_type() const {
    return static_cast<EmulatedScreenType>(data_->screen_type);
  }
  inline void GetScreenSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScreenSize(UserType* output) {
    
    auto* pointer = data_->screen_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetViewPositionDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointDataView, UserType>(),
    "Attempting to read the optional `view_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewPosition` instead "
    "of `ReadViewPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
  inline void GetViewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewSize(UserType* output) {
    
    auto* pointer = data_->view_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float scale() const {
    return data_->scale;
  }
  inline void GetViewportOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewportOffset(UserType* output) {
    
    auto* pointer = data_->viewport_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  float viewport_scale() const {
    return data_->viewport_scale;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScreenOrientationType(UserType* output) const {
    auto data_value = data_->screen_orientation_type;
    return mojo::internal::Deserialize<::blink::mojom::ScreenOrientation>(
        data_value, output);
  }

  ::blink::mojom::ScreenOrientation screen_orientation_type() const {
    return static_cast<::blink::mojom::ScreenOrientation>(data_->screen_orientation_type);
  }
  uint32_t screen_orientation_angle() const {
    return data_->screen_orientation_angle;
  }
  inline void GetWindowSegmentsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadWindowSegments(UserType* output) {
    
    auto* pointer = data_->window_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, context_);
  }
 private:
  internal::DeviceEmulationParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::EmulatedScreenType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EmulatedScreenType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::EmulatedScreenType, ::blink::mojom::EmulatedScreenType> {
  static ::blink::mojom::EmulatedScreenType ToMojom(::blink::mojom::EmulatedScreenType input) { return input; }
  static bool FromMojom(::blink::mojom::EmulatedScreenType input, ::blink::mojom::EmulatedScreenType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmulatedScreenType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EmulatedScreenType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::EmulatedScreenType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeviceEmulationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DeviceEmulationParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DeviceEmulationParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::EmulatedScreenType>(
        Traits::screen_type(input), &(*output)->screen_type);
    decltype(Traits::screen_size(input)) in_screen_size = Traits::screen_size(input);
    typename decltype((*output)->screen_size)::BaseType::BufferWriter
        screen_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_screen_size, buffer, &screen_size_writer, context);
    (*output)->screen_size.Set(
        screen_size_writer.is_null() ? nullptr : screen_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->screen_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_size in DeviceEmulationParams struct");
    decltype(Traits::view_position(input)) in_view_position = Traits::view_position(input);
    typename decltype((*output)->view_position)::BaseType::BufferWriter
        view_position_writer;
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_view_position, buffer, &view_position_writer, context);
    (*output)->view_position.Set(
        view_position_writer.is_null() ? nullptr : view_position_writer.data());
    decltype(Traits::view_size(input)) in_view_size = Traits::view_size(input);
    typename decltype((*output)->view_size)::BaseType::BufferWriter
        view_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_view_size, buffer, &view_size_writer, context);
    (*output)->view_size.Set(
        view_size_writer.is_null() ? nullptr : view_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->view_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_size in DeviceEmulationParams struct");
    (*output)->device_scale_factor = Traits::device_scale_factor(input);
    (*output)->scale = Traits::scale(input);
    decltype(Traits::viewport_offset(input)) in_viewport_offset = Traits::viewport_offset(input);
    typename decltype((*output)->viewport_offset)::BaseType::BufferWriter
        viewport_offset_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_viewport_offset, buffer, &viewport_offset_writer, context);
    (*output)->viewport_offset.Set(
        viewport_offset_writer.is_null() ? nullptr : viewport_offset_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->viewport_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_offset in DeviceEmulationParams struct");
    (*output)->viewport_scale = Traits::viewport_scale(input);
    mojo::internal::Serialize<::blink::mojom::ScreenOrientation>(
        Traits::screen_orientation_type(input), &(*output)->screen_orientation_type);
    (*output)->screen_orientation_angle = Traits::screen_orientation_angle(input);
    decltype(Traits::window_segments(input)) in_window_segments = Traits::window_segments(input);
    typename decltype((*output)->window_segments)::BaseType::BufferWriter
        window_segments_writer;
    const mojo::internal::ContainerValidateParams window_segments_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        in_window_segments, buffer, &window_segments_writer, &window_segments_validate_params,
        context);
    (*output)->window_segments.Set(
        window_segments_writer.is_null() ? nullptr : window_segments_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->window_segments.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null window_segments in DeviceEmulationParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::DeviceEmulationParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DeviceEmulationParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void DeviceEmulationParamsDataView::GetScreenSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->screen_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void DeviceEmulationParamsDataView::GetViewPositionDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->view_position.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}
inline void DeviceEmulationParamsDataView::GetViewSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->view_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void DeviceEmulationParamsDataView::GetViewportOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->viewport_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void DeviceEmulationParamsDataView::GetWindowSegmentsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->window_segments.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SHARED_H_