// third_party/blink/public/mojom/frame/frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-shared-internal.h"
#include "cc/mojom/touch_action.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/ad_tagging/ad_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/blocked_navigation_types.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/sudden_termination_disabler_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-shared.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/portal/portal.mojom-shared.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class SavableSubframeDataView;

class GetSavableResourceLinksReplyDataView;

class FindInPageResultAXParamsDataView;

class DownloadURLParamsDataView;

class TextAutosizerPageInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SavableSubframeDataView> {
  using Data = ::blink::mojom::internal::SavableSubframe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetSavableResourceLinksReplyDataView> {
  using Data = ::blink::mojom::internal::GetSavableResourceLinksReply_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FindInPageResultAXParamsDataView> {
  using Data = ::blink::mojom::internal::FindInPageResultAXParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DownloadURLParamsDataView> {
  using Data = ::blink::mojom::internal::DownloadURLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TextAutosizerPageInfoDataView> {
  using Data = ::blink::mojom::internal::TextAutosizerPageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PluginActionType : int32_t {
  
  kRotate90Clockwise = 0,
  
  kRotate90Counterclockwise = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PluginActionType value);
inline bool IsKnownEnumValue(PluginActionType value) {
  return internal::PluginActionType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class LocalFrameHostInterfaceBase {};

using LocalFrameHostPtrDataView =
    mojo::InterfacePtrDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameHostInterfaceBase>;
class LocalFrameInterfaceBase {};

using LocalFramePtrDataView =
    mojo::InterfacePtrDataView<LocalFrameInterfaceBase>;
using LocalFrameRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameInterfaceBase>;
class HighPriorityLocalFrameInterfaceBase {};

using HighPriorityLocalFramePtrDataView =
    mojo::InterfacePtrDataView<HighPriorityLocalFrameInterfaceBase>;
using HighPriorityLocalFrameRequestDataView =
    mojo::InterfaceRequestDataView<HighPriorityLocalFrameInterfaceBase>;
using HighPriorityLocalFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HighPriorityLocalFrameInterfaceBase>;
using HighPriorityLocalFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HighPriorityLocalFrameInterfaceBase>;
class RemoteFrameHostInterfaceBase {};

using RemoteFrameHostPtrDataView =
    mojo::InterfacePtrDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteFrameHostInterfaceBase>;
class RemoteFrameInterfaceBase {};

using RemoteFramePtrDataView =
    mojo::InterfacePtrDataView<RemoteFrameInterfaceBase>;
using RemoteFrameRequestDataView =
    mojo::InterfaceRequestDataView<RemoteFrameInterfaceBase>;
using RemoteFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteFrameInterfaceBase>;
using RemoteFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteFrameInterfaceBase>;
class LocalMainFrameInterfaceBase {};

using LocalMainFramePtrDataView =
    mojo::InterfacePtrDataView<LocalMainFrameInterfaceBase>;
using LocalMainFrameRequestDataView =
    mojo::InterfaceRequestDataView<LocalMainFrameInterfaceBase>;
using LocalMainFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalMainFrameInterfaceBase>;
using LocalMainFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalMainFrameInterfaceBase>;
class RemoteMainFrameInterfaceBase {};

using RemoteMainFramePtrDataView =
    mojo::InterfacePtrDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameRequestDataView =
    mojo::InterfaceRequestDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteMainFrameInterfaceBase>;
class LocalMainFrameHostInterfaceBase {};

using LocalMainFrameHostPtrDataView =
    mojo::InterfacePtrDataView<LocalMainFrameHostInterfaceBase>;
using LocalMainFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<LocalMainFrameHostInterfaceBase>;
using LocalMainFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalMainFrameHostInterfaceBase>;
using LocalMainFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalMainFrameHostInterfaceBase>;
class RemoteMainFrameHostInterfaceBase {};

using RemoteMainFrameHostPtrDataView =
    mojo::InterfacePtrDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteMainFrameHostInterfaceBase>;


class SavableSubframeDataView {
 public:
  SavableSubframeDataView() {}

  SavableSubframeDataView(
      internal::SavableSubframe_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginalUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetSubframeTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubframeToken(UserType* output) {
    
    auto* pointer = data_->subframe_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::SavableSubframe_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GetSavableResourceLinksReplyDataView {
 public:
  GetSavableResourceLinksReplyDataView() {}

  GetSavableResourceLinksReplyDataView(
      internal::GetSavableResourceLinksReply_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetResourcesListDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResourcesList(UserType* output) {
    
    auto* pointer = data_->resources_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  inline void GetSubframesDataView(
      mojo::ArrayDataView<SavableSubframeDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubframes(UserType* output) {
    
    auto* pointer = data_->subframes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SavableSubframeDataView>>(
        pointer, output, context_);
  }
 private:
  internal::GetSavableResourceLinksReply_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class FindInPageResultAXParamsDataView {
 public:
  FindInPageResultAXParamsDataView() {}

  FindInPageResultAXParamsDataView(
      internal::FindInPageResultAXParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t match_index() const {
    return data_->match_index;
  }
  int32_t start_id() const {
    return data_->start_id;
  }
  int32_t start_offset() const {
    return data_->start_offset;
  }
  int32_t end_id() const {
    return data_->end_id;
  }
  int32_t end_offset() const {
    return data_->end_offset;
  }
 private:
  internal::FindInPageResultAXParams_Data* data_ = nullptr;
};



class DownloadURLParamsDataView {
 public:
  DownloadURLParamsDataView() {}

  DownloadURLParamsDataView(
      internal::DownloadURLParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ReferrerDataView, UserType>(),
    "Attempting to read the optional `referrer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferrer` instead "
    "of `ReadReferrer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetSuggestedNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSuggestedName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `suggested_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSuggestedName` instead "
    "of `ReadSuggestedName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->suggested_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCrossOriginRedirects(UserType* output) const {
    auto data_value = data_->cross_origin_redirects;
    return mojo::internal::Deserialize<::network::mojom::RedirectMode>(
        data_value, output);
  }

  ::network::mojom::RedirectMode cross_origin_redirects() const {
    return static_cast<::network::mojom::RedirectMode>(data_->cross_origin_redirects);
  }
  template <typename UserType>
  UserType TakeBlobUrlToken() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
            &data_->blob_url_token, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDataUrlBlob() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
            &data_->data_url_blob, &result, context_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DownloadURLParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TextAutosizerPageInfoDataView {
 public:
  TextAutosizerPageInfoDataView() {}

  TextAutosizerPageInfoDataView(
      internal::TextAutosizerPageInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t main_frame_width() const {
    return data_->main_frame_width;
  }
  int32_t main_frame_layout_width() const {
    return data_->main_frame_layout_width;
  }
  float device_scale_adjustment() const {
    return data_->device_scale_adjustment;
  }
 private:
  internal::TextAutosizerPageInfo_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PluginActionType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PluginActionType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PluginActionType, ::blink::mojom::PluginActionType> {
  static ::blink::mojom::PluginActionType ToMojom(::blink::mojom::PluginActionType input) { return input; }
  static bool FromMojom(::blink::mojom::PluginActionType input, ::blink::mojom::PluginActionType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PluginActionType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PluginActionType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PluginActionType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SavableSubframeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SavableSubframeDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SavableSubframe_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
    typename decltype((*output)->original_url)::BaseType::BufferWriter
        original_url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_original_url, buffer, &original_url_writer, context);
    (*output)->original_url.Set(
        original_url_writer.is_null() ? nullptr : original_url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->original_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in SavableSubframe struct");
    decltype(Traits::subframe_token(input)) in_subframe_token = Traits::subframe_token(input);
    typename decltype((*output)->subframe_token)::BaseType::BufferWriter
        subframe_token_writer;
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_subframe_token, buffer, &subframe_token_writer, context);
    (*output)->subframe_token.Set(
        subframe_token_writer.is_null() ? nullptr : subframe_token_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subframe_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframe_token in SavableSubframe struct");
  }

  static bool Deserialize(::blink::mojom::internal::SavableSubframe_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SavableSubframeDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetSavableResourceLinksReplyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetSavableResourceLinksReplyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::GetSavableResourceLinksReply_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::resources_list(input)) in_resources_list = Traits::resources_list(input);
    typename decltype((*output)->resources_list)::BaseType::BufferWriter
        resources_list_writer;
    const mojo::internal::ContainerValidateParams resources_list_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_resources_list, buffer, &resources_list_writer, &resources_list_validate_params,
        context);
    (*output)->resources_list.Set(
        resources_list_writer.is_null() ? nullptr : resources_list_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->resources_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resources_list in GetSavableResourceLinksReply struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in GetSavableResourceLinksReply struct");
    decltype(Traits::subframes(input)) in_subframes = Traits::subframes(input);
    typename decltype((*output)->subframes)::BaseType::BufferWriter
        subframes_writer;
    const mojo::internal::ContainerValidateParams subframes_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SavableSubframeDataView>>(
        in_subframes, buffer, &subframes_writer, &subframes_validate_params,
        context);
    (*output)->subframes.Set(
        subframes_writer.is_null() ? nullptr : subframes_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subframes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframes in GetSavableResourceLinksReply struct");
  }

  static bool Deserialize(::blink::mojom::internal::GetSavableResourceLinksReply_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetSavableResourceLinksReplyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FindInPageResultAXParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FindInPageResultAXParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FindInPageResultAXParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->request_id = Traits::request_id(input);
    (*output)->match_index = Traits::match_index(input);
    (*output)->start_id = Traits::start_id(input);
    (*output)->start_offset = Traits::start_offset(input);
    (*output)->end_id = Traits::end_id(input);
    (*output)->end_offset = Traits::end_offset(input);
  }

  static bool Deserialize(::blink::mojom::internal::FindInPageResultAXParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FindInPageResultAXParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DownloadURLParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DownloadURLParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DownloadURLParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in DownloadURLParams struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
    typename decltype((*output)->initiator_origin)::BaseType::BufferWriter
        initiator_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_initiator_origin, buffer, &initiator_origin_writer, context);
    (*output)->initiator_origin.Set(
        initiator_origin_writer.is_null() ? nullptr : initiator_origin_writer.data());
    decltype(Traits::suggested_name(input)) in_suggested_name = Traits::suggested_name(input);
    typename decltype((*output)->suggested_name)::BaseType::BufferWriter
        suggested_name_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_suggested_name, buffer, &suggested_name_writer, context);
    (*output)->suggested_name.Set(
        suggested_name_writer.is_null() ? nullptr : suggested_name_writer.data());
    mojo::internal::Serialize<::network::mojom::RedirectMode>(
        Traits::cross_origin_redirects(input), &(*output)->cross_origin_redirects);
    decltype(Traits::blob_url_token(input)) in_blob_url_token = Traits::blob_url_token(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
        in_blob_url_token, &(*output)->blob_url_token, context);
    decltype(Traits::data_url_blob(input)) in_data_url_blob = Traits::data_url_blob(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
        in_data_url_blob, &(*output)->data_url_blob, context);
  }

  static bool Deserialize(::blink::mojom::internal::DownloadURLParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DownloadURLParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TextAutosizerPageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TextAutosizerPageInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::TextAutosizerPageInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->main_frame_width = Traits::main_frame_width(input);
    (*output)->main_frame_layout_width = Traits::main_frame_layout_width(input);
    (*output)->device_scale_adjustment = Traits::device_scale_adjustment(input);
  }

  static bool Deserialize(::blink::mojom::internal::TextAutosizerPageInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TextAutosizerPageInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void SavableSubframeDataView::GetOriginalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->original_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void SavableSubframeDataView::GetSubframeTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->subframe_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void GetSavableResourceLinksReplyDataView::GetResourcesListDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->resources_list.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, context_);
}
inline void GetSavableResourceLinksReplyDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void GetSavableResourceLinksReplyDataView::GetSubframesDataView(
    mojo::ArrayDataView<SavableSubframeDataView>* output) {
  auto pointer = data_->subframes.Get();
  *output = mojo::ArrayDataView<SavableSubframeDataView>(pointer, context_);
}




inline void DownloadURLParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void DownloadURLParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void DownloadURLParamsDataView::GetInitiatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->initiator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void DownloadURLParamsDataView::GetSuggestedNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->suggested_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}





}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_SHARED_H_