// services/video_capture/public/mojom/video_source_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom-shared.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/devices_changed_observer.mojom.h"
#include "services/video_capture/public/mojom/producer.mojom.h"
#include "services/video_capture/public/mojom/video_source.mojom.h"
#include "services/video_capture/public/mojom/virtual_device.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace video_capture {
namespace mojom {

class VideoSourceProviderProxy;

template <typename ImplRefTraits>
class VideoSourceProviderStub;

class VideoSourceProviderRequestValidator;
class VideoSourceProviderResponseValidator;


class  VideoSourceProvider
    : public VideoSourceProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VideoSourceProviderInterfaceBase;
  using Proxy_ = VideoSourceProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoSourceProviderStub<ImplRefTraits>;

  using RequestValidator_ = VideoSourceProviderRequestValidator;
  using ResponseValidator_ = VideoSourceProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSourceInfosMinVersion = 0,
    kGetVideoSourceMinVersion = 0,
    kAddSharedMemoryVirtualDeviceMinVersion = 0,
    kAddTextureVirtualDeviceMinVersion = 0,
    kRegisterVirtualDevicesChangedObserverMinVersion = 0,
    kCloseMinVersion = 0,
  };
  virtual ~VideoSourceProvider() {}


  using GetSourceInfosCallback = base::OnceCallback<void(const std::vector<::media::VideoCaptureDeviceInfo>&)>;
  
  virtual void GetSourceInfos(GetSourceInfosCallback callback) = 0;

  
  virtual void GetVideoSource(const std::string& source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> stream) = 0;

  
  virtual void AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, bool send_buffer_handles_to_producer_as_raw_file_descriptors, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) = 0;

  
  virtual void AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) = 0;

  
  virtual void RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) = 0;


  using CloseCallback = base::OnceCallback<void()>;
  
  virtual void Close(CloseCallback callback) = 0;
};



class  VideoSourceProviderProxy
    : public VideoSourceProvider {
 public:
  using InterfaceType = VideoSourceProvider;

  explicit VideoSourceProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSourceInfos(GetSourceInfosCallback callback) final;
  
  void GetVideoSource(const std::string& source_id, ::mojo::PendingReceiver<::video_capture::mojom::VideoSource> stream) final;
  
  void AddSharedMemoryVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingRemote<::video_capture::mojom::Producer> producer, bool send_buffer_handles_to_producer_as_raw_file_descriptors, ::mojo::PendingReceiver<::video_capture::mojom::SharedMemoryVirtualDevice> virtual_device_receiver) final;
  
  void AddTextureVirtualDevice(const ::media::VideoCaptureDeviceInfo& device_info, ::mojo::PendingReceiver<::video_capture::mojom::TextureVirtualDevice> virtual_device_receiver) final;
  
  void RegisterVirtualDevicesChangedObserver(::mojo::PendingRemote<::video_capture::mojom::DevicesChangedObserver> observer, bool raise_event_if_virtual_devices_already_present) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoSourceProviderStubDispatch {
 public:
  static bool Accept(VideoSourceProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoSourceProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoSourceProvider>>
class VideoSourceProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoSourceProviderStub() {}
  ~VideoSourceProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoSourceProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoSourceProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_PROVIDER_MOJOM_H_