/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtNetwork/qsslcipher.sip"
#include <qsslcipher.h>
#line 29 "/build/pyqt6/src/pyqt6-6.9.1/build/QtNetwork/sipQtNetworkQSslCipher.cpp"

#line 24 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt6/src/pyqt6-6.9.1/build/QtNetwork/sipQtNetworkQSslCipher.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtNetwork/qssl.sip"
#include <qssl.h>
#line 36 "/build/pyqt6/src/pyqt6-6.9.1/build/QtNetwork/sipQtNetworkQSslCipher.cpp"


PyDoc_STRVAR(doc_QSslCipher_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QSslCipher_isNull(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_isNull, doc_QSslCipher_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_name, "name(self) -> str");

extern "C" {static PyObject *meth_QSslCipher_name(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_name, doc_QSslCipher_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_supportedBits, "supportedBits(self) -> int");

extern "C" {static PyObject *meth_QSslCipher_supportedBits(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_supportedBits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->supportedBits();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_supportedBits, doc_QSslCipher_supportedBits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_usedBits, "usedBits(self) -> int");

extern "C" {static PyObject *meth_QSslCipher_usedBits(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_usedBits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->usedBits();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_usedBits, doc_QSslCipher_usedBits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_keyExchangeMethod, "keyExchangeMethod(self) -> str");

extern "C" {static PyObject *meth_QSslCipher_keyExchangeMethod(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_keyExchangeMethod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->keyExchangeMethod());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_keyExchangeMethod, doc_QSslCipher_keyExchangeMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_authenticationMethod, "authenticationMethod(self) -> str");

extern "C" {static PyObject *meth_QSslCipher_authenticationMethod(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_authenticationMethod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->authenticationMethod());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_authenticationMethod, doc_QSslCipher_authenticationMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_encryptionMethod, "encryptionMethod(self) -> str");

extern "C" {static PyObject *meth_QSslCipher_encryptionMethod(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_encryptionMethod(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->encryptionMethod());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_encryptionMethod, doc_QSslCipher_encryptionMethod);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_protocolString, "protocolString(self) -> str");

extern "C" {static PyObject *meth_QSslCipher_protocolString(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_protocolString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->protocolString());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_protocolString, doc_QSslCipher_protocolString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_protocol, "protocol(self) -> QSsl.SslProtocol");

extern "C" {static PyObject *meth_QSslCipher_protocol(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_protocol(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSslCipher, &sipCpp))
        {
            ::QSsl::SslProtocol sipRes;

            sipRes = sipCpp->protocol();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QSsl_SslProtocol);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_protocol, doc_QSslCipher_protocol);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSslCipher_swap, "swap(self, other: QSslCipher)");

extern "C" {static PyObject *meth_QSslCipher_swap(PyObject *, PyObject *);}
static PyObject *meth_QSslCipher_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSslCipher* a0;
        ::QSslCipher *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QSslCipher, &sipCpp, sipType_QSslCipher, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSslCipher, sipName_swap, doc_QSslCipher_swap);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QSslCipher___ne__(PyObject *, PyObject *);}
static PyObject *slot_QSslCipher___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QSslCipher *sipCpp = reinterpret_cast< ::QSslCipher *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSslCipher));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSslCipher, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QSslCipher::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtNetwork, ne_slot, sipType_QSslCipher, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QSslCipher___eq__(PyObject *, PyObject *);}
static PyObject *slot_QSslCipher___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QSslCipher *sipCpp = reinterpret_cast< ::QSslCipher *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QSslCipher));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSslCipher* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QSslCipher, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QSslCipher::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtNetwork, eq_slot, sipType_QSslCipher, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QSslCipher(void *, int);}
static void release_QSslCipher(void *sipCppV, int)
{
    delete reinterpret_cast< ::QSslCipher *>(sipCppV);
}


extern "C" {static void *array_QSslCipher(Py_ssize_t);}
static void *array_QSslCipher(Py_ssize_t sipNrElem)
{
    return new ::QSslCipher[sipNrElem];
}


extern "C" {static void array_delete_QSslCipher(void *);}
static void array_delete_QSslCipher(void *sipCpp)
{
    delete[] reinterpret_cast< ::QSslCipher *>(sipCpp);
}


extern "C" {static void assign_QSslCipher(void *, Py_ssize_t, void *);}
static void assign_QSslCipher(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QSslCipher *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QSslCipher *>(sipSrc);
}


extern "C" {static void *copy_QSslCipher(const void *, Py_ssize_t);}
static void *copy_QSslCipher(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QSslCipher(reinterpret_cast<const ::QSslCipher *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QSslCipher(sipSimpleWrapper *);}
static void dealloc_QSslCipher(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QSslCipher(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QSslCipher(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QSslCipher(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QSslCipher *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QSslCipher();

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QSslCipher(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        ::QSsl::SslProtocol a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1E", sipType_QString, &a0, &a0State, sipType_QSsl_SslProtocol, &a1))
        {
            sipCpp = new ::QSslCipher(*a0, a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        const ::QSslCipher* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QSslCipher, &a0))
        {
            sipCpp = new ::QSslCipher(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QSslCipher[] = {
    {(void *)slot_QSslCipher___ne__, ne_slot},
    {(void *)slot_QSslCipher___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QSslCipher[] = {
    {sipName_authenticationMethod, meth_QSslCipher_authenticationMethod, METH_VARARGS, doc_QSslCipher_authenticationMethod},
    {sipName_encryptionMethod, meth_QSslCipher_encryptionMethod, METH_VARARGS, doc_QSslCipher_encryptionMethod},
    {sipName_isNull, meth_QSslCipher_isNull, METH_VARARGS, doc_QSslCipher_isNull},
    {sipName_keyExchangeMethod, meth_QSslCipher_keyExchangeMethod, METH_VARARGS, doc_QSslCipher_keyExchangeMethod},
    {sipName_name, meth_QSslCipher_name, METH_VARARGS, doc_QSslCipher_name},
    {sipName_protocol, meth_QSslCipher_protocol, METH_VARARGS, doc_QSslCipher_protocol},
    {sipName_protocolString, meth_QSslCipher_protocolString, METH_VARARGS, doc_QSslCipher_protocolString},
    {sipName_supportedBits, meth_QSslCipher_supportedBits, METH_VARARGS, doc_QSslCipher_supportedBits},
    {sipName_swap, meth_QSslCipher_swap, METH_VARARGS, doc_QSslCipher_swap},
    {sipName_usedBits, meth_QSslCipher_usedBits, METH_VARARGS, doc_QSslCipher_usedBits}
};

PyDoc_STRVAR(doc_QSslCipher, "\1QSslCipher()\n"
"QSslCipher(name: Optional[str])\n"
"QSslCipher(name: Optional[str], protocol: QSsl.SslProtocol)\n"
"QSslCipher(other: QSslCipher)");


sipClassTypeDef sipTypeDef_QtNetwork_QSslCipher = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QSslCipher,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QSslCipher,
        {0, 0, 1},
        10, methods_QSslCipher,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QSslCipher,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QSslCipher,
    init_type_QSslCipher,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QSslCipher,
    assign_QSslCipher,
    array_QSslCipher,
    copy_QSslCipher,
    release_QSslCipher,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QSslCipher,
    sizeof (::QSslCipher),
};
