// python wrapper for vtkEnvironmentAnnotationFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkEnvironmentAnnotationFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkEnvironmentAnnotationFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkEnvironmentAnnotationFilter_ClassNew(); }


static PyObject *
PyvtkEnvironmentAnnotationFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkEnvironmentAnnotationFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkEnvironmentAnnotationFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkEnvironmentAnnotationFilter *tempr = vtkEnvironmentAnnotationFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkEnvironmentAnnotationFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkEnvironmentAnnotationFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkEnvironmentAnnotationFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkEnvironmentAnnotationFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkEnvironmentAnnotationFilter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkEnvironmentAnnotationFilter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SetDisplayUserName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplayUserName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplayUserName(temp0);
    }
    else
    {
      op->vtkEnvironmentAnnotationFilter::SetDisplayUserName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetDisplayUserName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayUserName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplayUserName() :
      op->vtkEnvironmentAnnotationFilter::GetDisplayUserName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SetDisplaySystemName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplaySystemName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplaySystemName(temp0);
    }
    else
    {
      op->vtkEnvironmentAnnotationFilter::SetDisplaySystemName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetDisplaySystemName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplaySystemName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplaySystemName() :
      op->vtkEnvironmentAnnotationFilter::GetDisplaySystemName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SetDisplayFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplayFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplayFileName(temp0);
    }
    else
    {
      op->vtkEnvironmentAnnotationFilter::SetDisplayFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetDisplayFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplayFileName() :
      op->vtkEnvironmentAnnotationFilter::GetDisplayFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SetDisplayFilePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplayFilePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplayFilePath(temp0);
    }
    else
    {
      op->vtkEnvironmentAnnotationFilter::SetDisplayFilePath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetDisplayFilePath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayFilePath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplayFilePath() :
      op->vtkEnvironmentAnnotationFilter::GetDisplayFilePath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_SetDisplayDate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDisplayDate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDisplayDate(temp0);
    }
    else
    {
      op->vtkEnvironmentAnnotationFilter::SetDisplayDate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEnvironmentAnnotationFilter_GetDisplayDate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDisplayDate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEnvironmentAnnotationFilter *op = static_cast<vtkEnvironmentAnnotationFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDisplayDate() :
      op->vtkEnvironmentAnnotationFilter::GetDisplayDate());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkEnvironmentAnnotationFilter_Methods[] = {
  {"IsTypeOf", PyvtkEnvironmentAnnotationFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkEnvironmentAnnotationFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkEnvironmentAnnotationFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkEnvironmentAnnotationFilter\nC++: static vtkEnvironmentAnnotationFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkEnvironmentAnnotationFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkEnvironmentAnnotationFilter\nC++: vtkEnvironmentAnnotationFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkEnvironmentAnnotationFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkEnvironmentAnnotationFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkEnvironmentAnnotationFilter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(std::string _arg)\n\n"},
  {"GetFileName", PyvtkEnvironmentAnnotationFilter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual std::string GetFileName()\n\n"},
  {"SetDisplayUserName", PyvtkEnvironmentAnnotationFilter_SetDisplayUserName, METH_VARARGS,
   "SetDisplayUserName(self, _arg:bool) -> None\nC++: virtual void SetDisplayUserName(bool _arg)\n\n"},
  {"GetDisplayUserName", PyvtkEnvironmentAnnotationFilter_GetDisplayUserName, METH_VARARGS,
   "GetDisplayUserName(self) -> bool\nC++: virtual bool GetDisplayUserName()\n\n"},
  {"SetDisplaySystemName", PyvtkEnvironmentAnnotationFilter_SetDisplaySystemName, METH_VARARGS,
   "SetDisplaySystemName(self, _arg:bool) -> None\nC++: virtual void SetDisplaySystemName(bool _arg)\n\n"},
  {"GetDisplaySystemName", PyvtkEnvironmentAnnotationFilter_GetDisplaySystemName, METH_VARARGS,
   "GetDisplaySystemName(self) -> bool\nC++: virtual bool GetDisplaySystemName()\n\n"},
  {"SetDisplayFileName", PyvtkEnvironmentAnnotationFilter_SetDisplayFileName, METH_VARARGS,
   "SetDisplayFileName(self, _arg:bool) -> None\nC++: virtual void SetDisplayFileName(bool _arg)\n\n"},
  {"GetDisplayFileName", PyvtkEnvironmentAnnotationFilter_GetDisplayFileName, METH_VARARGS,
   "GetDisplayFileName(self) -> bool\nC++: virtual bool GetDisplayFileName()\n\n"},
  {"SetDisplayFilePath", PyvtkEnvironmentAnnotationFilter_SetDisplayFilePath, METH_VARARGS,
   "SetDisplayFilePath(self, _arg:bool) -> None\nC++: virtual void SetDisplayFilePath(bool _arg)\n\n"},
  {"GetDisplayFilePath", PyvtkEnvironmentAnnotationFilter_GetDisplayFilePath, METH_VARARGS,
   "GetDisplayFilePath(self) -> bool\nC++: virtual bool GetDisplayFilePath()\n\n"},
  {"SetDisplayDate", PyvtkEnvironmentAnnotationFilter_SetDisplayDate, METH_VARARGS,
   "SetDisplayDate(self, _arg:bool) -> None\nC++: virtual void SetDisplayDate(bool _arg)\n\n"},
  {"GetDisplayDate", PyvtkEnvironmentAnnotationFilter_GetDisplayDate, METH_VARARGS,
   "GetDisplayDate(self) -> bool\nC++: virtual bool GetDisplayDate()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkEnvironmentAnnotationFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEnvironmentAnnotationFilter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkEnvironmentAnnotationFilter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkEnvironmentAnnotationFilter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_user_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEnvironmentAnnotationFilter_GetDisplayUserName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayUserName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayUserName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplayUserName/SetDisplayUserName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_system_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEnvironmentAnnotationFilter_GetDisplaySystemName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplaySystemName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplaySystemName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplaySystemName/SetDisplaySystemName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEnvironmentAnnotationFilter_GetDisplayFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplayFileName/SetDisplayFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_file_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEnvironmentAnnotationFilter_GetDisplayFilePath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayFilePath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayFilePath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplayFilePath/SetDisplayFilePath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("display_date"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEnvironmentAnnotationFilter_GetDisplayDate(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayDate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkEnvironmentAnnotationFilter_SetDisplayDate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDisplayDate/SetDisplayDate\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkEnvironmentAnnotationFilter_Doc =
  "vtkEnvironmentAnnotationFilter - filter used to generate text\nannotation for the current project.\n\n"
  "Superclass: vtkTableAlgorithm\n\n"
  "vtkEnvironmentAnnotationFilter is designed to help annotate the scene\n"
  "with frequently needed information.\n\n"
  "The variables available in the expression evaluation scope are as\n"
  "follows:\n"
  "\\li FileName: the name of the file that the user is working on.\n"
  "\\li DisplayFileName: Boolean value representing whether the file name\n"
  "is visible.\n"
  "\\li DisplayDate: Boolean value representing whether thedate/time is\n"
  "    visible.\n"
  "\\li DisplaySystemName: Boolean value representing whether the system\n"
  "    type is visible.\n"
  "\\li DisplayUserName: Boolean value representing whether the username\n"
  "    is visible.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkEnvironmentAnnotationFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsMisc.vtkEnvironmentAnnotationFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkEnvironmentAnnotationFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkEnvironmentAnnotationFilter_StaticNew()
{
  return vtkEnvironmentAnnotationFilter::New();
}

PyObject *PyvtkEnvironmentAnnotationFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkEnvironmentAnnotationFilter_Type, PyvtkEnvironmentAnnotationFilter_Methods,
    "vtkEnvironmentAnnotationFilter",
 &PyvtkEnvironmentAnnotationFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTableAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkEnvironmentAnnotationFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkEnvironmentAnnotationFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkEnvironmentAnnotationFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkEnvironmentAnnotationFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

