// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef LegacyGhostCellsGeneratorParallelObjectFactory_h
#define LegacyGhostCellsGeneratorParallelObjectFactory_h

#include "LegacyGhostCellsGeneratorParallelModule.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class LEGACYGHOSTCELLSGENERATORPARALLEL_EXPORT LegacyGhostCellsGeneratorParallelObjectFactory : public vtkObjectFactory
{
public:
  static LegacyGhostCellsGeneratorParallelObjectFactory * New();
  vtkTypeMacro(LegacyGhostCellsGeneratorParallelObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "LegacyGhostCellsGeneratorParallel factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  LegacyGhostCellsGeneratorParallelObjectFactory();

private:
  LegacyGhostCellsGeneratorParallelObjectFactory(const LegacyGhostCellsGeneratorParallelObjectFactory&) = delete;
  void operator=(const LegacyGhostCellsGeneratorParallelObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // LegacyGhostCellsGeneratorParallelObjectFactory_h
