// python wrapper for vtkSMInputArrayDomain
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMInputArrayDomain.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMInputArrayDomain(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMInputArrayDomain_ClassNew(); }

#ifndef DECLARED_PyvtkSMDomain_ClassNew
extern "C" { PyObject *PyvtkSMDomain_ClassNew(); }
#define DECLARED_PyvtkSMDomain_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMInputArrayDomain_AttributeTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMInputArrayDomain.AttributeTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMInputArrayDomain_AttributeTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMInputArrayDomain_AttributeTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMInputArrayDomain_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMInputArrayDomain::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMInputArrayDomain::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMInputArrayDomain *tempr = vtkSMInputArrayDomain::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMInputArrayDomain *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMInputArrayDomain::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMInputArrayDomain::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMInputArrayDomain::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_IsInDomain_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsInDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    int tempr = (ap.IsBound() ?
      op->IsInDomain(temp0) :
      op->vtkSMInputArrayDomain::IsInDomain(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMInputArrayDomain_IsInDomain_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsInDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  unsigned int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->IsInDomain(temp0, temp1) :
      op->vtkSMInputArrayDomain::IsInDomain(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMInputArrayDomain_IsInDomain_Methods[] = {
  {"IsInDomain", PyvtkSMInputArrayDomain_IsInDomain_s1, METH_VARARGS,
   "@V *vtkSMProperty"},
  {"IsInDomain", PyvtkSMInputArrayDomain_IsInDomain_s2, METH_VARARGS,
   "@V|I *vtkSMSourceProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMInputArrayDomain_IsInDomain(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMInputArrayDomain_IsInDomain_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMInputArrayDomain_IsInDomain_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsInDomain");
  return nullptr;
}


static PyObject *
PyvtkSMInputArrayDomain_GetAttributeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAttributeType() :
      op->vtkSMInputArrayDomain::GetAttributeType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_GetAttributeTypeAsString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttributeTypeAsString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetAttributeTypeAsString() :
      op->vtkSMInputArrayDomain::GetAttributeTypeAsString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_GetAcceptableNumbersOfComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAcceptableNumbersOfComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::vector<int> tempr = (ap.IsBound() ?
      op->GetAcceptableNumbersOfComponents() :
      op->vtkSMInputArrayDomain::GetAcceptableNumbersOfComponents());

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_SetAutomaticPropertyConversion(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetAutomaticPropertyConversion");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMInputArrayDomain::SetAutomaticPropertyConversion(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_GetAutomaticPropertyConversion(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetAutomaticPropertyConversion");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkSMInputArrayDomain::GetAutomaticPropertyConversion();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_GetAutoConvertProperties(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutoConvertProperties");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAutoConvertProperties() :
      op->vtkSMInputArrayDomain::GetAutoConvertProperties());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_IsAttributeTypeAcceptable_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsAttributeTypeAcceptable");

  int temp0;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<int> store2(2*size2);
  int *temp2 = store2.Data();
  int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetArray(temp2, size2)))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    bool tempr = vtkSMInputArrayDomain::IsAttributeTypeAcceptable(temp0, temp1, temp2);

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMInputArrayDomain_IsAttributeTypeAcceptable_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsAttributeTypeAcceptable");

  int temp0;
  int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<int> store2(2*size2);
  int *temp2 = store2.Data();
  int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  bool temp3 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2) &&
      ap.GetValue(temp3))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    bool tempr = vtkSMInputArrayDomain::IsAttributeTypeAcceptable(temp0, temp1, temp2, temp3);

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMInputArrayDomain_IsAttributeTypeAcceptable(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 2:
    case 3:
      return PyvtkSMInputArrayDomain_IsAttributeTypeAcceptable_s1(self, args);
    case 4:
      return PyvtkSMInputArrayDomain_IsAttributeTypeAcceptable_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsAttributeTypeAcceptable");
  return nullptr;
}


static PyObject *
PyvtkSMInputArrayDomain_IsArrayAcceptable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsArrayAcceptable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMInputArrayDomain *op = static_cast<vtkSMInputArrayDomain *>(vp);

  vtkPVArrayInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVArrayInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->IsArrayAcceptable(temp0) :
      op->vtkSMInputArrayDomain::IsArrayAcceptable(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMInputArrayDomain_FindApplicableDomain(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "FindApplicableDomain");

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    vtkSMInputArrayDomain *tempr = vtkSMInputArrayDomain::FindApplicableDomain(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMInputArrayDomain_Methods[] = {
  {"IsTypeOf", PyvtkSMInputArrayDomain_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMInputArrayDomain_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMInputArrayDomain_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMInputArrayDomain\nC++: static vtkSMInputArrayDomain *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMInputArrayDomain_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMInputArrayDomain\nC++: vtkSMInputArrayDomain *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMInputArrayDomain_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMInputArrayDomain_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsInDomain", PyvtkSMInputArrayDomain_IsInDomain, METH_VARARGS,
   "IsInDomain(self, property:vtkSMProperty) -> int\nC++: int IsInDomain(vtkSMProperty *property) override;\nIsInDomain(self, proxy:vtkSMSourceProxy, outputport:int=0) -> int\nC++: int IsInDomain(vtkSMSourceProxy *proxy,\n    unsigned int outputport=0)\n\nReturns true if the value of the property is in the domain. The\nproperty has to be a vtkSMProxyProperty which points to a\nvtkSMSourceProxy. The input has to have one or more arrays that\nmatch the requirements.\n"},
  {"GetAttributeType", PyvtkSMInputArrayDomain_GetAttributeType, METH_VARARGS,
   "GetAttributeType(self) -> int\nC++: virtual int GetAttributeType()\n\nGet the attribute type. Valid values are defined in\nAttributeTypes which map to vtkDataObject::AttributeTypes.\n"},
  {"GetAttributeTypeAsString", PyvtkSMInputArrayDomain_GetAttributeTypeAsString, METH_VARARGS,
   "GetAttributeTypeAsString(self) -> str\nC++: const char *GetAttributeTypeAsString()\n\n"},
  {"GetAcceptableNumbersOfComponents", PyvtkSMInputArrayDomain_GetAcceptableNumbersOfComponents, METH_VARARGS,
   "GetAcceptableNumbersOfComponents(self) -> (int, ...)\nC++: std::vector<int> GetAcceptableNumbersOfComponents()\n\nGet the AcceptableNumberOfComponents vector Empty or containing a\nzero means no check.\n"},
  {"SetAutomaticPropertyConversion", PyvtkSMInputArrayDomain_SetAutomaticPropertyConversion, METH_VARARGS,
   "SetAutomaticPropertyConversion(__a:bool) -> None\nC++: static void SetAutomaticPropertyConversion(bool)\n\nGet/Set the application wide setting for automatic conversion of\nproperties. Automatic conversion of properties allows conversion\nbetween cell and point based properties, and the extraction of\nvector components as scalar properties\n"},
  {"GetAutomaticPropertyConversion", PyvtkSMInputArrayDomain_GetAutomaticPropertyConversion, METH_VARARGS,
   "GetAutomaticPropertyConversion() -> bool\nC++: static bool GetAutomaticPropertyConversion()\n\n"},
  {"GetAutoConvertProperties", PyvtkSMInputArrayDomain_GetAutoConvertProperties, METH_VARARGS,
   "GetAutoConvertProperties(self) -> bool\nC++: bool GetAutoConvertProperties()\n\nGet the auto convert property for this specific domain. This\nreturns true if either application settings or local value is\ntrue.\n"},
  {"IsAttributeTypeAcceptable", PyvtkSMInputArrayDomain_IsAttributeTypeAcceptable, METH_VARARGS,
   "IsAttributeTypeAcceptable(required_type:int, attribute_type:int,\n    acceptable_as_type:[int, ...]=...) -> bool\nC++: static bool IsAttributeTypeAcceptable(int required_type,\n    int attribute_type, int *acceptable_as_type=nullptr)\nIsAttributeTypeAcceptable(required_type:int, attribute_type:int,\n    acceptable_as_type:[int, ...], autoconvert:bool) -> bool\nC++: static bool IsAttributeTypeAcceptable(int required_type,\n    int attribute_type, int *acceptable_as_type, bool autoconvert)\n\nMethod to check if a particular attribute-type ( attribute_type)\nwill be accepted by this domain with a required attribute type (\nrequired_type). This takes into consideration the state of\nAutomaticePropertyConversion flag. If a particular attribute_type\nis acceptable only because AutomaticPropertyConversion is true,\nacceptable_as_type value will be set to the attribute type that\nthe particular attribute was automatically converted to. e.g. is\nrequired_type = POINT and attribute_type is CELL and\nAutomaticPropertyConversion is true, this method will return true\nand acceptable_as_type will be set to POINT. In other cases,\nacceptable_as_type is simply set to attribute_type.\n"},
  {"IsArrayAcceptable", PyvtkSMInputArrayDomain_IsArrayAcceptable, METH_VARARGS,
   "IsArrayAcceptable(self, arrayInfo:vtkPVArrayInformation) -> int\nC++: int IsArrayAcceptable(vtkPVArrayInformation *arrayInfo)\n\nThis method will check if the arrayInfo contain info about an\nacceptable array, by checking its number of components against\nthis domain acceptable numbers of components. Note that it takes\ninto account property conversion This method return the accepted\nnumber of components to use.\n"},
  {"FindApplicableDomain", PyvtkSMInputArrayDomain_FindApplicableDomain, METH_VARARGS,
   "FindApplicableDomain(property:vtkSMProperty)\n    -> vtkSMInputArrayDomain\nC++: static vtkSMInputArrayDomain *FindApplicableDomain(\n    vtkSMProperty *property)\n\nHelper method find the first `vtkSMInputArrayDomain` on the\n`property` that is acceptable based on the value of the property.\nThe property is typically `vtkSMInputProperty`. If none of the\ndomains applicable, this will simply return the first\nvtkSMInputArrayDomain that is found.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMInputArrayDomain_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("automatic_property_conversion"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMInputArrayDomain_GetAutomaticPropertyConversion(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMInputArrayDomain_SetAutomaticPropertyConversion(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMInputArrayDomain_SetAutomaticPropertyConversion(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutomaticPropertyConversion/SetAutomaticPropertyConversion\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("attribute_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMInputArrayDomain_GetAttributeType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAttributeType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("acceptable_numbers_of_components"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMInputArrayDomain_GetAcceptableNumbersOfComponents(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAcceptableNumbersOfComponents\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("auto_convert_properties"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMInputArrayDomain_GetAutoConvertProperties(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAutoConvertProperties\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMInputArrayDomain_Doc =
  "vtkSMInputArrayDomain - domain to ensure that input has required\ntypes of arrays.\n\n"
  "Superclass: vtkSMDomain\n\n"
  "vtkSMInputArrayDomain is a domain that can be used on a\n"
  "vtkSMInputProperty to check if the pipeline input provides attribute\n"
  "arrays of the required types e.g. if a filter can only work if the\n"
  "input data set has cell data arrays, then one can use this domain.\n\n"
  "vtkSMInputArrayDomain also provides a mechanism to check if the\n"
  "attribute arrays have a certain number of components.\n\n"
  "When enabled, ParaView supports automatic array conversion i.e.\n"
  "extracting components or converting cell data to point data and\n"
  "vice-versa is done implicitly. In that case, vtkSMInputArrayDomain's\n"
  "behavior also changes as appropriate.\n\n"
  "Supported XML attributes:\n"
  "\\li attribute_type : (optional) value can be 'point', 'cell',\n"
  "    'field',\n"
  "                        'vertex', 'edge', 'row', 'none',\n"
  "'any-except-field', 'any'.\n"
  "                        If not specified, 'any-except-field' is\n"
  "assumed. This\n"
  "                        indicates the attribute type for acceptable\n"
  "arrays.\n"
  "\\li number_of_components : (optional) Indicates the number of\n"
  "    components\n"
  "                              required in arrays that are considered\n"
  "acceptable.\n"
  "                              0 (default) indicates any number of\n"
  "components is acceptable.\n"
  "                              A comma-separated list (e.g., \"1\" or\n"
  "\"1,3,4\") of component counts\n"
  "                              limits acceptable arrays to those with\n"
  "a number of components that\n"
  "                              appear in the list.\n"
  "\\li data_type: (optional) when specified must be the class name for\n"
  "                  data type that this domain is applicable to. This\n"
  "is\n"
  "                  useful when adding multiple input-array-domains a\n"
  "                  property with different requirements based on the\n"
  "                  type (see `(\"filters\", \"Contour\")` filter, for\n"
  "example).\n"
  "\\li auto_convert_association: (optional) Indicates if an automatic\n"
  "    attribute type conversion\n"
  "                                 can be applied to the input arrays\n"
  "to match the attribute_type\n"
  "                                 criteria.\n\n"
  "This domain doesn't support any required properties (to help clean\n"
  "old code, we print a warning if any required properties are\n"
  "specified).\n\n"
  "@attention Prior to ParaView 5.0, attribute_type=\"any\" meant all\n"
  "attributes excepting field data. For being consistent with general\n"
  "understanding of \"any\", this has been changed to include field data\n"
  "arrays since 5.0. Use \"any-except-field\" for cases where the\n"
  "intention is to match any attribute arrays except field data arrays.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMInputArrayDomain_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMInputArrayDomain", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMInputArrayDomain_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMInputArrayDomain_StaticNew()
{
  return vtkSMInputArrayDomain::New();
}

PyObject *PyvtkSMInputArrayDomain_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMInputArrayDomain_Type, PyvtkSMInputArrayDomain_Methods,
    "vtkSMInputArrayDomain",
 &PyvtkSMInputArrayDomain_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMDomain_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMInputArrayDomain_AttributeTypes_Type);
  PyVTKEnum_Add(&PyvtkSMInputArrayDomain_AttributeTypes_Type, "vtkSMInputArrayDomain.AttributeTypes");

  o = (PyObject *)&PyvtkSMInputArrayDomain_AttributeTypes_Type;
  if (PyDict_SetItemString(d, "AttributeTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 9; c++)
  {
    typedef vtkSMInputArrayDomain::AttributeTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[9] = {
        { "POINT", vtkSMInputArrayDomain::POINT },
        { "CELL", vtkSMInputArrayDomain::CELL },
        { "FIELD", vtkSMInputArrayDomain::FIELD },
        { "ANY_EXCEPT_FIELD", vtkSMInputArrayDomain::ANY_EXCEPT_FIELD },
        { "VERTEX", vtkSMInputArrayDomain::VERTEX },
        { "EDGE", vtkSMInputArrayDomain::EDGE },
        { "ROW", vtkSMInputArrayDomain::ROW },
        { "ANY", vtkSMInputArrayDomain::ANY },
        { "NUMBER_OF_ATTRIBUTE_TYPES", vtkSMInputArrayDomain::NUMBER_OF_ATTRIBUTE_TYPES },
      };

    o = PyvtkSMInputArrayDomain_AttributeTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMInputArrayDomain_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMInputArrayDomain(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMInputArrayDomain_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMInputArrayDomain", o) != 0)
  {
    Py_DECREF(o);
  }

}

