#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBumpMapMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBumpMapRepresentation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLBumpMapMapperDelegator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLExtrusionMapperDelegator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtrusionMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExtrusionRepresentation_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkEmbossingRepresentationsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBumpMapMapper_Init(csi);
  vtkBumpMapRepresentation_Init(csi);
  vtkOpenGLBumpMapMapperDelegator_Init(csi);
  vtkOpenGLExtrusionMapperDelegator_Init(csi);
  vtkExtrusionMapper_Init(csi);
  vtkExtrusionRepresentation_Init(csi);
}
