// python wrapper for vtkThreeSliceFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkThreeSliceFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkThreeSliceFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkThreeSliceFilter_ClassNew(); }


static PyObject *
PyvtkThreeSliceFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkThreeSliceFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkThreeSliceFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkThreeSliceFilter *tempr = vtkThreeSliceFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkThreeSliceFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkThreeSliceFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkThreeSliceFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkThreeSliceFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkThreeSliceFilter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SetCutNormal(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCutNormal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  int temp0;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->SetCutNormal(temp0, temp1);
    }
    else
    {
      op->vtkThreeSliceFilter::SetCutNormal(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SetCutOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCutOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  int temp0;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetArray(temp1, size1))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    if (ap.IsBound())
    {
      op->SetCutOrigin(temp0, temp1);
    }
    else
    {
      op->vtkThreeSliceFilter::SetCutOrigin(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SetCutValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCutValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  int temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCutValue(temp0, temp1, temp2);
    }
    else
    {
      op->vtkThreeSliceFilter::SetCutValue(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SetNumberOfSlice(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfSlice");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfSlice(temp0, temp1);
    }
    else
    {
      op->vtkThreeSliceFilter::SetNumberOfSlice(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SetToDefaultSettings(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetToDefaultSettings");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetToDefaultSettings();
    }
    else
    {
      op->vtkThreeSliceFilter::SetToDefaultSettings();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_SetCutOrigins_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCutOrigins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  double save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetCutOrigins(temp0);
    }
    else
    {
      op->vtkThreeSliceFilter::SetCutOrigins(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkThreeSliceFilter_SetCutOrigins_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCutOrigins");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCutOrigins(temp0, temp1, temp2);
    }
    else
    {
      op->vtkThreeSliceFilter::SetCutOrigins(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkThreeSliceFilter_SetCutOrigins(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkThreeSliceFilter_SetCutOrigins_s1(self, args);
    case 3:
      return PyvtkThreeSliceFilter_SetCutOrigins_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCutOrigins");
  return nullptr;
}


static PyObject *
PyvtkThreeSliceFilter_EnableProbe(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableProbe");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->EnableProbe(temp0);
    }
    else
    {
      op->vtkThreeSliceFilter::EnableProbe(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkThreeSliceFilter_GetProbedPointData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProbedPointData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkThreeSliceFilter *op = static_cast<vtkThreeSliceFilter *>(vp);

  const char *temp0 = nullptr;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->GetProbedPointData(temp0, temp1) :
      op->vtkThreeSliceFilter::GetProbedPointData(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(1, temp1);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkThreeSliceFilter_Methods[] = {
  {"IsTypeOf", PyvtkThreeSliceFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkThreeSliceFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkThreeSliceFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkThreeSliceFilter\nC++: static vtkThreeSliceFilter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkThreeSliceFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkThreeSliceFilter\nC++: vtkThreeSliceFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkThreeSliceFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkThreeSliceFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetMTime", PyvtkThreeSliceFilter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nOverride GetMTime because we rely on internal filters that have\ntheir own MTime\n"},
  {"SetCutNormal", PyvtkThreeSliceFilter_SetCutNormal, METH_VARARGS,
   "SetCutNormal(self, cutIndex:int, normal:[float, float, float])\n    -> None\nC++: void SetCutNormal(int cutIndex, double normal[3])\n\nSet a Slice Normal for a given cutter\n"},
  {"SetCutOrigin", PyvtkThreeSliceFilter_SetCutOrigin, METH_VARARGS,
   "SetCutOrigin(self, cutIndex:int, origin:[float, float, float])\n    -> None\nC++: void SetCutOrigin(int cutIndex, double origin[3])\n\nSet a slice Origin for a given cutter\n"},
  {"SetCutValue", PyvtkThreeSliceFilter_SetCutValue, METH_VARARGS,
   "SetCutValue(self, cutIndex:int, index:int, value:float) -> None\nC++: void SetCutValue(int cutIndex, int index, double value)\n\nSet a slice value for a given cutter\n"},
  {"SetNumberOfSlice", PyvtkThreeSliceFilter_SetNumberOfSlice, METH_VARARGS,
   "SetNumberOfSlice(self, cutIndex:int, size:int) -> None\nC++: void SetNumberOfSlice(int cutIndex, int size)\n\nSet number of slices for a given cutter\n"},
  {"SetToDefaultSettings", PyvtkThreeSliceFilter_SetToDefaultSettings, METH_VARARGS,
   "SetToDefaultSettings(self) -> None\nC++: void SetToDefaultSettings()\n\nDefault settings:\n- reset the plan origin to be (0,0,0)\n- number of slice for X, Y and Z to be 0\n- Normal for SliceX=[1,0,0], SliceY=[0,1,0], SliceZ=[0,0,1]\n"},
  {"SetCutOrigins", PyvtkThreeSliceFilter_SetCutOrigins, METH_VARARGS,
   "SetCutOrigins(self, origin:[float, float, float]) -> None\nC++: void SetCutOrigins(double origin[3])\nSetCutOrigins(self, x:float, y:float, z:float) -> None\nC++: void SetCutOrigins(double x, double y, double z)\n\nSet slice Origin for all cutter\n"},
  {"EnableProbe", PyvtkThreeSliceFilter_EnableProbe, METH_VARARGS,
   "EnableProbe(self, enable:int) -> None\nC++: void EnableProbe(int enable)\n\nEnable to probe the dataset at the given cut origin.\n"},
  {"GetProbedPointData", PyvtkThreeSliceFilter_GetProbedPointData, METH_VARARGS,
   "GetProbedPointData(self, arrayName:str, value:float) -> bool\nC++: bool GetProbedPointData(const char *arrayName, double &value)\n\nReturn true if any data is available and provide the value as\nargument\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkThreeSliceFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("number_of_slice"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkThreeSliceFilter_SetNumberOfSlice(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkThreeSliceFilter_SetNumberOfSlice(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfSlice\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cut_origins"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkThreeSliceFilter_SetCutOrigins(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkThreeSliceFilter_SetCutOrigins(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCutOrigins\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkThreeSliceFilter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkThreeSliceFilter_Doc =
  "vtkThreeSliceFilter - Cut vtkDataSet along 3 planes\n\n"
  "Superclass: vtkPolyDataAlgorithm\n\n"
  "vtkThreeSliceFilter is a filter that slice the input data using 3\n"
  "plane cut. Each axis cut could embed several slices by providing\n"
  "several values. As output you will find 4 output ports. The output\n"
  "ports are defined as follow:\n"
  "- 0: Merge of all the cutter output\n"
  "- 1: Output of the first internal vtkCutter filter\n"
  "- 2: Output of the second internal vtkCutter filter\n"
  "- 3: Output of the third internal vtkCutter filter\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkThreeSliceFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkThreeSliceFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkThreeSliceFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkThreeSliceFilter_StaticNew()
{
  return vtkThreeSliceFilter::New();
}

PyObject *PyvtkThreeSliceFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkThreeSliceFilter_Type, PyvtkThreeSliceFilter_Methods,
    "vtkThreeSliceFilter",
 &PyvtkThreeSliceFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPolyDataAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkThreeSliceFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkThreeSliceFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkThreeSliceFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkThreeSliceFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

