// python wrapper for vtkCPAdaptorAPI
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCPAdaptorAPI.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPAdaptorAPI(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPAdaptorAPI_ClassNew(); }


static PyObject *
PyvtkCPAdaptorAPI_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPAdaptorAPI::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPAdaptorAPI *op = static_cast<vtkCPAdaptorAPI *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPAdaptorAPI::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPAdaptorAPI *tempr = vtkCPAdaptorAPI::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPAdaptorAPI *op = static_cast<vtkCPAdaptorAPI *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPAdaptorAPI *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPAdaptorAPI::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPAdaptorAPI::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPAdaptorAPI *op = static_cast<vtkCPAdaptorAPI *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPAdaptorAPI::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_CoProcessorInitialize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CoProcessorInitialize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkCPAdaptorAPI::CoProcessorInitialize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_CoProcessorFinalize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CoProcessorFinalize");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkCPAdaptorAPI::CoProcessorFinalize();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_RequestDataDescription(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RequestDataDescription");

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<int> store2(2*size2);
  int *temp2 = store2.Data();
  int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetArray(temp0, size0) &&
      ap.GetArray(temp1, size1) &&
      ap.GetArray(temp2, size2))
  {
    vtkPythonArgs::Save(temp0, save0, size0);
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);

    vtkCPAdaptorAPI::RequestDataDescription(temp0, temp1, temp2);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_NeedToCreateGrid(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NeedToCreateGrid");

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    vtkCPAdaptorAPI::NeedToCreateGrid(temp0);

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_CoProcess(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CoProcess");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkCPAdaptorAPI::CoProcess();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_GetCoProcessorData(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCoProcessorData");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkCPDataDescription *tempr = vtkCPAdaptorAPI::GetCoProcessorData();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPAdaptorAPI_GetCoProcessor(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetCoProcessor");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkCPProcessor *tempr = vtkCPAdaptorAPI::GetCoProcessor();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPAdaptorAPI_Methods[] = {
  {"IsTypeOf", PyvtkCPAdaptorAPI_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPAdaptorAPI_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPAdaptorAPI_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPAdaptorAPI\nC++: static vtkCPAdaptorAPI *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPAdaptorAPI_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPAdaptorAPI\nC++: vtkCPAdaptorAPI *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPAdaptorAPI_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPAdaptorAPI_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CoProcessorInitialize", PyvtkCPAdaptorAPI_CoProcessorInitialize, METH_VARARGS,
   "CoProcessorInitialize() -> None\nC++: static void CoProcessorInitialize()\n\ncall at the start of the simulation\n"},
  {"CoProcessorFinalize", PyvtkCPAdaptorAPI_CoProcessorFinalize, METH_VARARGS,
   "CoProcessorFinalize() -> None\nC++: static void CoProcessorFinalize()\n\ncall at the end of the simulation\n"},
  {"RequestDataDescription", PyvtkCPAdaptorAPI_RequestDataDescription, METH_VARARGS,
   "RequestDataDescription(timeStep:[int, ...], time:[float, ...],\n    coprocessThisTimeStep:[int, ...]) -> None\nC++: static void RequestDataDescription(int *timeStep,\n    double *time, int *coprocessThisTimeStep)\n\nthis is the function that determines whether or not there is\nanything to coprocess this time step\n"},
  {"NeedToCreateGrid", PyvtkCPAdaptorAPI_NeedToCreateGrid, METH_VARARGS,
   "NeedToCreateGrid(needGrid:[int, ...]) -> None\nC++: static void NeedToCreateGrid(int *needGrid)\n\nthis function sets needgrid to 1 if it does not have a copy of\nthe grid it sets needgrid to 0 if it does have a copy of the grid\nbut does not check if the grid is modified or needs to be updated\n"},
  {"CoProcess", PyvtkCPAdaptorAPI_CoProcess, METH_VARARGS,
   "CoProcess() -> None\nC++: static void CoProcess()\n\ndo the actual coprocessing.  it is assumed that the\nvtkCPDataDescription has been filled in elsewhere.\n"},
  {"GetCoProcessorData", PyvtkCPAdaptorAPI_GetCoProcessorData, METH_VARARGS,
   "GetCoProcessorData() -> vtkCPDataDescription\nC++: static vtkCPDataDescription *GetCoProcessorData()\n\nprovides access to the vtkCPDataDescription instance.\n"},
  {"GetCoProcessor", PyvtkCPAdaptorAPI_GetCoProcessor, METH_VARARGS,
   "GetCoProcessor() -> vtkCPProcessor\nC++: static vtkCPProcessor *GetCoProcessor()\n\nprovides access to the vtkCPProcessor instance.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPAdaptorAPI_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("co_processor_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPAdaptorAPI_GetCoProcessorData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCoProcessorData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("co_processor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCPAdaptorAPI_GetCoProcessor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCoProcessor\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPAdaptorAPI_Doc =
  "vtkCPAdaptorAPI - vtkCPAdaptorAPI provides the implementation for API\nexposed to typical adaptor, such as C, Fortran.\n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPAdaptorAPI_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVCatalyst.vtkCPAdaptorAPI", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPAdaptorAPI_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkCPAdaptorAPI_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPAdaptorAPI_Type, PyvtkCPAdaptorAPI_Methods,
    "vtkCPAdaptorAPI",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPAdaptorAPI_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPAdaptorAPI(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPAdaptorAPI_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPAdaptorAPI", o) != 0)
  {
    Py_DECREF(o);
  }

}

