// ClientServer wrapper for vtkInteractorStyleMultiTouchCamera object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkInteractorStyleMultiTouchCamera.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkInteractorStyleMultiTouchCameraClientServerNewCommand(void* /*ctx*/)
{
  return vtkInteractorStyleMultiTouchCamera::New();
}


static int vtkInteractorStyleMultiTouchCameraCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkInteractorStyleMultiTouchCamera *op = vtkInteractorStyleMultiTouchCamera::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkInteractorStyleMultiTouchCamera.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInteractorStyleMultiTouchCamera  *temp20;
      {
      temp20 = vtkInteractorStyleMultiTouchCamera::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkInteractorStyleMultiTouchCamera::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkInteractorStyleMultiTouchCamera  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkInteractorStyleMultiTouchCamera::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkInteractorStyleMultiTouchCamera  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkInteractorStyleMultiTouchCamera::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("OnStartRotate",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnStartRotate();
      return 1;
      }
    }
  if (!strcmp("OnRotate",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnRotate();
      return 1;
      }
    }
  if (!strcmp("OnEndRotate",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnEndRotate();
      return 1;
      }
    }
  if (!strcmp("OnStartPinch",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnStartPinch();
      return 1;
      }
    }
  if (!strcmp("OnPinch",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnPinch();
      return 1;
      }
    }
  if (!strcmp("OnEndPinch",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnEndPinch();
      return 1;
      }
    }
  if (!strcmp("OnStartPan",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnStartPan();
      return 1;
      }
    }
  if (!strcmp("OnPan",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnPan();
      return 1;
      }
    }
  if (!strcmp("OnEndPan",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->OnEndPan();
      return 1;
      }
    }

  {
    const char* commandName = "vtkInteractorStyleTrackballCamera";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkInteractorStyleMultiTouchCamera, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkInteractorStyleMultiTouchCamera_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkInteractorStyleMultiTouchCamera", vtkInteractorStyleMultiTouchCameraClientServerNewCommand);
    csi->AddCommandFunction("vtkInteractorStyleMultiTouchCamera", vtkInteractorStyleMultiTouchCameraCommand);
    }
}
}
