//===- Pipeline.cpp - Create Rock compilation pipeline ---------------===//
//
// Copyright 2021 The MLIR Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// =============================================================================
//
// This interface adds the Rock compilation pipeline for various flows but
// keeping a unified ordering of the pipeline.
//
//===----------------------------------------------------------------------===//

#include "mlir/Dialect/MIGraphX/Pipeline/Pipeline.h"

#include "mlir/Conversion/RocMLIRPasses.h"
#include "mlir/Dialect/MIGraphX/Passes.h"
#include "mlir/Dialect/Rock/Passes.h"
#include "mlir/IR/Builders.h"
#include "mlir/IR/BuiltinOps.h"
#include "mlir/Transforms/Passes.h"

#include "mlir/Conversion/FuncToLLVM/ConvertFuncToLLVM.h"
#include "mlir/Conversion/FuncToLLVM/ConvertFuncToLLVMPass.h"
#include "mlir/Conversion/GPUToROCDL/GPUToROCDLPass.h"
#include "mlir/Dialect/Func/IR/FuncOps.h"
#include "llvm/Support/TargetSelect.h"

using namespace mlir;

//===- Consolidate the Rock Pipelines here ---------------------===//

void migraphx::addHighLevelPipeline(PassManager &pm) {
  // passes for MIXR to TOSA
  auto &funcPm = pm.nest<func::FuncOp>();
  funcPm.addPass(migraphx::createMIGraphXRealizeInt4Pass());
  funcPm.addPass(migraphx::createMIGraphXTransformPass());
  funcPm.addPass(createCanonicalizerPass());
  funcPm.addPass(createMIGraphXToTosaPass());
  funcPm.addPass(createCSEPass());
  funcPm.addPass(migraphx::createMIGraphXTosaSimplifyPass());
}
