/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2024 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#pragma once

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgsystemservice/peer-manager.h>
#include <libmalcontent/manager.h>
#include <libmalcontent-timer/timer-store.h>

G_BEGIN_DECLS

/**
 * MctChildTimerServiceError:
 * @MCT_CHILD_TIMER_SERVICE_ERROR_INVALID_RECORD: A submitted record was invalid.
 * @MCT_CHILD_TIMER_SERVICE_ERROR_STORAGE_ERROR: The database is corrupt or there
 *   was an I/O error when using it.
 * @MCT_CHILD_TIMER_SERVICE_ERROR_BUSY: The database is already busy for this username.
 * @MCT_CHILD_TIMER_SERVICE_ERROR_IDENTIFYING_USER: The calling user could not be
 *   identified.
 * @MCT_CHILD_TIMER_SERVICE_ERROR_QUERYING_POLICY: There was an error reading the
 *   user’s parental controls policy from [class@Malcontent.Manager].
 * @MCT_CHILD_TIMER_SERVICE_ERROR_DISABLED: Storing usage information is disabled for
 *   all users.
 * @MCT_CHILD_TIMER_SERVICE_ERROR_COMMUNICATING_WITH_AGENT: There was an error
 *   communicating with the timer extension agent to request a screen time
 *   extension.
 * @MCT_CHILD_TIMER_SERVICE_ERROR_REQUEST_CANCELLED: The screen time extension
 *   request was cancelled before it received a response.
 *
 * Errors which can be returned by [class@Malcontent.ChildTimerService].
 *
 * Since: 0.14.0
 */
typedef enum
{
  MCT_CHILD_TIMER_SERVICE_ERROR_INVALID_RECORD = 0,
  MCT_CHILD_TIMER_SERVICE_ERROR_STORAGE_ERROR,
  MCT_CHILD_TIMER_SERVICE_ERROR_BUSY,
  MCT_CHILD_TIMER_SERVICE_ERROR_IDENTIFYING_USER,
  MCT_CHILD_TIMER_SERVICE_ERROR_QUERYING_POLICY,
  MCT_CHILD_TIMER_SERVICE_ERROR_DISABLED,
  MCT_CHILD_TIMER_SERVICE_ERROR_COMMUNICATING_WITH_AGENT,
  MCT_CHILD_TIMER_SERVICE_ERROR_REQUEST_CANCELLED,
} MctChildTimerServiceError;
#define MCT_CHILD_TIMER_SERVICE_N_ERRORS (MCT_CHILD_TIMER_SERVICE_ERROR_REQUEST_CANCELLED + 1)

GQuark mct_child_timer_service_error_quark (void);
#define MCT_CHILD_TIMER_SERVICE_ERROR mct_child_timer_service_error_quark ()

#define MCT_TYPE_CHILD_TIMER_SERVICE mct_child_timer_service_get_type ()
G_DECLARE_FINAL_TYPE (MctChildTimerService, mct_child_timer_service, MCT,
                      CHILD_TIMER_SERVICE, GObject)

MctChildTimerService *mct_child_timer_service_new (GDBusConnection *connection,
                                                   const char      *object_path,
                                                   MctTimerStore   *timer_store,
                                                   GssPeerManager  *peer_manager,
                                                   MctManager      *policy_manager);

gboolean mct_child_timer_service_register   (MctChildTimerService  *self,
                                             GError               **error);
void     mct_child_timer_service_unregister (MctChildTimerService  *self);

gboolean mct_child_timer_service_get_busy   (MctChildTimerService  *self);

G_END_DECLS
