/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/include/uhdlib/usrp/common/rpc.py on Wed Dec 17 09:05:05 2025
 **********************************************************************/

//
// Copyright 2021 Ettus Research, a National Instruments Brand
//
// SPDX-License-Identifier: GPL-3.0-or-later
//

#pragma once

#include <uhd/types/sensors.hpp>
#include <uhdlib/utils/rpc.hpp>
#include <stddef.h>
#include <memory>
#include <string>
#include <vector>

namespace uhd { namespace usrp {

    class mpmd_rpc_iface {
    public:
        using sptr = std::shared_ptr<mpmd_rpc_iface>;

        virtual ~mpmd_rpc_iface() = default;

            virtual size_t get_num_timekeepers() = 0;
            virtual std::vector<std::string> get_mb_sensors() = 0;
            virtual sensor_value_t::sensor_map_t get_mb_sensor(const std::string& sensor) = 0;
            virtual std::vector<std::string> get_gpio_banks() = 0;
            virtual std::vector<std::string> get_gpio_srcs(const std::string& bank) = 0;
            virtual bool supports_feature(const std::string& feature) = 0;
            virtual void set_tick_period(size_t tick_index,uint64_t period_ns) = 0;
            virtual uint64_t get_timekeeper_time(size_t timekeeper_idx,bool last_pps) = 0;
            virtual void set_timekeeper_time(size_t timekeeper_idx,uint64_t ticks,bool last_pps) = 0;
            virtual void set_time_source(const std::string& source) = 0;
            virtual std::string get_time_source() = 0;
            virtual std::vector<std::string> get_time_sources() = 0;
            virtual void set_clock_source(const std::string& source) = 0;
            virtual std::string get_clock_source() = 0;
            virtual std::vector<std::string> get_clock_sources() = 0;
            virtual void set_sync_source(const std::map<std::string, std::string>& source) = 0;
            virtual std::map<std::string, std::string> get_sync_source() = 0;
            virtual std::vector<std::map<std::string, std::string>> get_sync_sources() = 0;
            virtual void set_clock_source_out(bool enb) = 0;
            virtual void set_trigger_io(const std::string& direction) = 0;
            virtual std::map<std::string, std::string> get_mb_eeprom() = 0;
            virtual std::vector<std::string> get_gpio_src(const std::string& bank) = 0;
            virtual void set_gpio_src(const std::string& bank,const std::vector<std::string>& src) = 0;
            virtual std::map<std::string, std::string> synchronize(const std::map<std::string, std::string>& sync_data,bool finalize) = 0;
            virtual std::map<std::string, std::string> aggregate_sync_data(const std::list<std::map<std::string, std::string>>& collated_sync_data) = 0;
            virtual std::vector<std::map<std::string, std::string>> pop_host_tasks(const std::string& task) = 0;
            virtual void set_ref_clk_tuning_word(uint32_t tuning_word) = 0;
            virtual uint32_t get_ref_clk_tuning_word() = 0;
            virtual void store_ref_clk_tuning_word(uint32_t tuning_word) = 0;

        // Deprecated
        virtual uhd::rpc_client::sptr get_raw_rpc_client() = 0;
    };

    class mpmd_rpc : public mpmd_rpc_iface {
    public:
            mpmd_rpc(uhd::rpc_client::sptr rpc) : _rpcc(rpc) {}

            size_t get_num_timekeepers() override
            {
                return _rpcc->request_with_token<size_t>
                    ("get_num_timekeepers");
            }
            std::vector<std::string> get_mb_sensors() override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_mb_sensors");
            }
            sensor_value_t::sensor_map_t get_mb_sensor(const std::string& sensor) override
            {
                return _rpcc->request_with_token<sensor_value_t::sensor_map_t>
                    ("get_mb_sensor",sensor);
            }
            std::vector<std::string> get_gpio_banks() override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_gpio_banks");
            }
            std::vector<std::string> get_gpio_srcs(const std::string& bank) override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_gpio_srcs",bank);
            }
            bool supports_feature(const std::string& feature) override
            {
                return _rpcc->request_with_token<bool>
                    ("supports_feature",feature);
            }
            void set_tick_period(size_t tick_index,uint64_t period_ns) override
            {
                _rpcc->notify_with_token
                    ("set_tick_period",tick_index,period_ns);
            }
            uint64_t get_timekeeper_time(size_t timekeeper_idx,bool last_pps) override
            {
                return _rpcc->request_with_token<uint64_t>
                    ("get_timekeeper_time",timekeeper_idx,last_pps);
            }
            void set_timekeeper_time(size_t timekeeper_idx,uint64_t ticks,bool last_pps) override
            {
                _rpcc->notify_with_token
                    ("set_timekeeper_time",timekeeper_idx,ticks,last_pps);
            }
            void set_time_source(const std::string& source) override
            {
                _rpcc->notify_with_token
                    ("set_time_source",source);
            }
            std::string get_time_source() override
            {
                return _rpcc->request_with_token<std::string>
                    ("get_time_source");
            }
            std::vector<std::string> get_time_sources() override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_time_sources");
            }
            void set_clock_source(const std::string& source) override
            {
                _rpcc->notify_with_token
                    ("set_clock_source",source);
            }
            std::string get_clock_source() override
            {
                return _rpcc->request_with_token<std::string>
                    ("get_clock_source");
            }
            std::vector<std::string> get_clock_sources() override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_clock_sources");
            }
            void set_sync_source(const std::map<std::string, std::string>& source) override
            {
                _rpcc->notify_with_token
                    ("set_sync_source",source);
            }
            std::map<std::string, std::string> get_sync_source() override
            {
                return _rpcc->request_with_token<std::map<std::string, std::string>>
                    ("get_sync_source");
            }
            std::vector<std::map<std::string, std::string>> get_sync_sources() override
            {
                return _rpcc->request_with_token<std::vector<std::map<std::string, std::string>>>
                    ("get_sync_sources");
            }
            void set_clock_source_out(bool enb) override
            {
                _rpcc->notify_with_token
                    ("set_clock_source_out",enb);
            }
            void set_trigger_io(const std::string& direction) override
            {
                _rpcc->notify_with_token
                    ("set_trigger_io",direction);
            }
            std::map<std::string, std::string> get_mb_eeprom() override
            {
                return _rpcc->request_with_token<std::map<std::string, std::string>>
                    ("get_mb_eeprom");
            }
            std::vector<std::string> get_gpio_src(const std::string& bank) override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_gpio_src",bank);
            }
            void set_gpio_src(const std::string& bank,const std::vector<std::string>& src) override
            {
                _rpcc->notify_with_token
                    ("set_gpio_src",bank,src);
            }
            std::map<std::string, std::string> synchronize(const std::map<std::string, std::string>& sync_data,bool finalize) override
            {
                return _rpcc->request_with_token<std::map<std::string, std::string>>
                    ("synchronize",sync_data,finalize);
            }
            std::map<std::string, std::string> aggregate_sync_data(const std::list<std::map<std::string, std::string>>& collated_sync_data) override
            {
                return _rpcc->request_with_token<std::map<std::string, std::string>>
                    ("aggregate_sync_data",collated_sync_data);
            }
            std::vector<std::map<std::string, std::string>> pop_host_tasks(const std::string& task) override
            {
                return _rpcc->request_with_token<std::vector<std::map<std::string, std::string>>>
                    ("pop_host_tasks",task);
            }
            void set_ref_clk_tuning_word(uint32_t tuning_word) override
            {
                _rpcc->notify_with_token
                    ("set_ref_clk_tuning_word",tuning_word);
            }
            uint32_t get_ref_clk_tuning_word() override
            {
                return _rpcc->request_with_token<uint32_t>
                    ("get_ref_clk_tuning_word");
            }
            void store_ref_clk_tuning_word(uint32_t tuning_word) override
            {
                _rpcc->notify_with_token
                    ("store_ref_clk_tuning_word",tuning_word);
            }

        // Deprecated
        uhd::rpc_client::sptr get_raw_rpc_client() override { return _rpcc; }

    private:
        uhd::rpc_client::sptr _rpcc;
    };
    class x400_rpc_iface {
    public:
        using sptr = std::shared_ptr<x400_rpc_iface>;

        virtual ~x400_rpc_iface() = default;

            virtual std::vector<std::map<std::string, std::string>> get_dboard_info() = 0;
            virtual void set_calibration_mode(size_t tile_id,size_t block_id,std::string mode) = 0;
            virtual void set_cal_frozen(bool state,size_t block_count,size_t chan) = 0;
            virtual std::vector<int> get_cal_frozen(size_t block_count,size_t chan) = 0;
            virtual double rfdc_set_nco_freq(const std::string& trx,size_t block_count,size_t chan,double freq) = 0;
            virtual double rfdc_get_nco_freq(const std::string& trx,size_t block_count,size_t chan) = 0;
            virtual std::map<std::string, std::vector<uint8_t>> get_db_eeprom(size_t db_idx) = 0;
            virtual bool get_threshold_status(size_t db_number,size_t chan,size_t threshold_block) = 0;
            virtual void set_dac_mux_enable(size_t db_idx,size_t channel,int enable) = 0;
            virtual void set_dac_mux_data(size_t i,size_t q) = 0;
            virtual double get_spll_freq() = 0;
            virtual void setup_threshold(size_t db_number,size_t chan,size_t threshold_block,const std::string& mode,size_t delay,size_t under,size_t over) = 0;
            virtual bool is_db_gpio_ifc_present(size_t db_idx) = 0;
            virtual void dio_set_voltage_level(const std::string& port,const std::string& level) = 0;
            virtual void dio_set_port_mapping(const std::string& mapping) = 0;
            virtual void dio_set_pin_directions(const std::string& port,uint32_t values) = 0;
            virtual std::vector<std::string> get_gpio_src(const std::string& bank) = 0;

        // Deprecated
        virtual uhd::rpc_client::sptr get_raw_rpc_client() = 0;
    };

    class x400_rpc : public x400_rpc_iface {
    public:
            x400_rpc(uhd::rpc_client::sptr rpc) : _rpcc(rpc) {}

            std::vector<std::map<std::string, std::string>> get_dboard_info() override
            {
                return _rpcc->request<std::vector<std::map<std::string, std::string>>>
                    ("get_dboard_info");
            }
            void set_calibration_mode(size_t tile_id,size_t block_id,std::string mode) override
            {
                _rpcc->notify_with_token
                    ("set_calibration_mode",tile_id,block_id,mode);
            }
            void set_cal_frozen(bool state,size_t block_count,size_t chan) override
            {
                _rpcc->notify_with_token
                    ("set_cal_frozen",state,block_count,chan);
            }
            std::vector<int> get_cal_frozen(size_t block_count,size_t chan) override
            {
                return _rpcc->request_with_token<std::vector<int>>
                    ("get_cal_frozen",block_count,chan);
            }
            double rfdc_set_nco_freq(const std::string& trx,size_t block_count,size_t chan,double freq) override
            {
                return _rpcc->request_with_token<double>
                    ("rfdc_set_nco_freq",trx,block_count,chan,freq);
            }
            double rfdc_get_nco_freq(const std::string& trx,size_t block_count,size_t chan) override
            {
                return _rpcc->request_with_token<double>
                    ("rfdc_get_nco_freq",trx,block_count,chan);
            }
            std::map<std::string, std::vector<uint8_t>> get_db_eeprom(size_t db_idx) override
            {
                return _rpcc->request_with_token<std::map<std::string, std::vector<uint8_t>>>
                    ("get_db_eeprom",db_idx);
            }
            bool get_threshold_status(size_t db_number,size_t chan,size_t threshold_block) override
            {
                return _rpcc->request_with_token<bool>
                    ("get_threshold_status",db_number,chan,threshold_block);
            }
            void set_dac_mux_enable(size_t db_idx,size_t channel,int enable) override
            {
                _rpcc->notify_with_token
                    ("set_dac_mux_enable",db_idx,channel,enable);
            }
            void set_dac_mux_data(size_t i,size_t q) override
            {
                _rpcc->notify_with_token
                    ("set_dac_mux_data",i,q);
            }
            double get_spll_freq() override
            {
                return _rpcc->request_with_token<double>
                    ("get_spll_freq");
            }
            void setup_threshold(size_t db_number,size_t chan,size_t threshold_block,const std::string& mode,size_t delay,size_t under,size_t over) override
            {
                _rpcc->notify_with_token
                    ("setup_threshold",db_number,chan,threshold_block,mode,delay,under,over);
            }
            bool is_db_gpio_ifc_present(size_t db_idx) override
            {
                return _rpcc->request_with_token<bool>
                    ("is_db_gpio_ifc_present",db_idx);
            }
            void dio_set_voltage_level(const std::string& port,const std::string& level) override
            {
                _rpcc->notify_with_token
                    ("dio_set_voltage_level",port,level);
            }
            void dio_set_port_mapping(const std::string& mapping) override
            {
                _rpcc->notify_with_token
                    ("dio_set_port_mapping",mapping);
            }
            void dio_set_pin_directions(const std::string& port,uint32_t values) override
            {
                _rpcc->notify_with_token
                    ("dio_set_pin_directions",port,values);
            }
            std::vector<std::string> get_gpio_src(const std::string& bank) override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("get_gpio_src",bank);
            }

        // Deprecated
        uhd::rpc_client::sptr get_raw_rpc_client() override { return _rpcc; }

    private:
        uhd::rpc_client::sptr _rpcc;
    };
    class dio_rpc_iface {
    public:
        using sptr = std::shared_ptr<dio_rpc_iface>;

        virtual ~dio_rpc_iface() = default;

            virtual std::vector<std::string> dio_get_supported_voltage_levels(const std::string& port) = 0;
            virtual void dio_set_voltage_level(const std::string& port,const std::string& level) = 0;
            virtual std::string dio_get_voltage_level(const std::string& port) = 0;
            virtual void dio_set_port_mapping(const std::string& mapping) = 0;
            virtual void dio_set_pin_directions(const std::string& port,uint32_t values) = 0;
            virtual void dio_set_external_power(const std::string& port,bool enable) = 0;
            virtual std::string dio_get_external_power_state(const std::string& port) = 0;

        // Deprecated
        virtual uhd::rpc_client::sptr get_raw_rpc_client() = 0;
    };

    class dio_rpc : public dio_rpc_iface {
    public:
            dio_rpc(uhd::rpc_client::sptr rpc) : _rpcc(rpc) {}

            std::vector<std::string> dio_get_supported_voltage_levels(const std::string& port) override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    ("dio_get_supported_voltage_levels",port);
            }
            void dio_set_voltage_level(const std::string& port,const std::string& level) override
            {
                _rpcc->notify_with_token
                    ("dio_set_voltage_level",port,level);
            }
            std::string dio_get_voltage_level(const std::string& port) override
            {
                return _rpcc->request_with_token<std::string>
                    ("dio_get_voltage_level",port);
            }
            void dio_set_port_mapping(const std::string& mapping) override
            {
                _rpcc->notify_with_token
                    ("dio_set_port_mapping",mapping);
            }
            void dio_set_pin_directions(const std::string& port,uint32_t values) override
            {
                _rpcc->notify_with_token
                    ("dio_set_pin_directions",port,values);
            }
            void dio_set_external_power(const std::string& port,bool enable) override
            {
                _rpcc->notify_with_token
                    ("dio_set_external_power",port,enable);
            }
            std::string dio_get_external_power_state(const std::string& port) override
            {
                return _rpcc->request_with_token<std::string>
                    ("dio_get_external_power_state",port);
            }

        // Deprecated
        uhd::rpc_client::sptr get_raw_rpc_client() override { return _rpcc; }

    private:
        uhd::rpc_client::sptr _rpcc;
    };
    class dboard_base_rpc_iface {
    public:
        using sptr = std::shared_ptr<dboard_base_rpc_iface>;

        virtual ~dboard_base_rpc_iface() = default;

            virtual std::vector<std::string> get_sensors(const std::string& trx) = 0;
            virtual sensor_value_t::sensor_map_t get_sensor(const std::string& trx,const std::string& sensor,size_t chan) = 0;
            virtual double get_master_clock_rate() = 0;

        // Deprecated
        virtual uhd::rpc_client::sptr get_raw_rpc_client() = 0;
    };

    class dboard_base_rpc : public dboard_base_rpc_iface {
    public:
            dboard_base_rpc(uhd::rpc_client::sptr rpc, const std::string& rpc_prefix) : _rpcc(rpc), _rpc_prefix(rpc_prefix) {}

            std::vector<std::string> get_sensors(const std::string& trx) override
            {
                return _rpcc->request_with_token<std::vector<std::string>>
                    (_rpc_prefix + "get_sensors",trx);
            }
            sensor_value_t::sensor_map_t get_sensor(const std::string& trx,const std::string& sensor,size_t chan) override
            {
                return _rpcc->request_with_token<sensor_value_t::sensor_map_t>
                    (_rpc_prefix + "get_sensor",trx,sensor,chan);
            }
            double get_master_clock_rate() override
            {
                return _rpcc->request_with_token<double>
                    (_rpc_prefix + "get_master_clock_rate");
            }

        // Deprecated
        uhd::rpc_client::sptr get_raw_rpc_client() override { return _rpcc; }

    private:
        uhd::rpc_client::sptr _rpcc;
            const std::string _rpc_prefix;
    };
    class zbx_rpc_iface {
    public:
        using sptr = std::shared_ptr<zbx_rpc_iface>;

        virtual ~zbx_rpc_iface() = default;

            virtual double get_dboard_prc_rate() = 0;
            virtual double get_dboard_sample_rate() = 0;
            virtual void enable_iq_swap(bool is_band_inverted,const std::string& trx,size_t chan) = 0;

        // Deprecated
        virtual uhd::rpc_client::sptr get_raw_rpc_client() = 0;
    };

    class zbx_rpc : public zbx_rpc_iface {
    public:
            zbx_rpc(uhd::rpc_client::sptr rpc, const std::string& rpc_prefix) : _rpcc(rpc), _rpc_prefix(rpc_prefix) {}

            double get_dboard_prc_rate() override
            {
                return _rpcc->request_with_token<double>
                    (_rpc_prefix + "get_dboard_prc_rate");
            }
            double get_dboard_sample_rate() override
            {
                return _rpcc->request_with_token<double>
                    (_rpc_prefix + "get_dboard_sample_rate");
            }
            void enable_iq_swap(bool is_band_inverted,const std::string& trx,size_t chan) override
            {
                _rpcc->notify_with_token
                    (_rpc_prefix + "enable_iq_swap",is_band_inverted,trx,chan);
            }

        // Deprecated
        uhd::rpc_client::sptr get_raw_rpc_client() override { return _rpcc; }

    private:
        uhd::rpc_client::sptr _rpcc;
            const std::string _rpc_prefix;
    };
    class fbx_rpc_iface {
    public:
        using sptr = std::shared_ptr<fbx_rpc_iface>;

        virtual ~fbx_rpc_iface() = default;

            virtual double get_dboard_sample_rate() = 0;
            virtual void enable_iq_swap(bool is_band_inverted,const std::string& trx,size_t chan) = 0;

        // Deprecated
        virtual uhd::rpc_client::sptr get_raw_rpc_client() = 0;
    };

    class fbx_rpc : public fbx_rpc_iface {
    public:
            fbx_rpc(uhd::rpc_client::sptr rpc, const std::string& rpc_prefix) : _rpcc(rpc), _rpc_prefix(rpc_prefix) {}

            double get_dboard_sample_rate() override
            {
                return _rpcc->request_with_token<double>
                    (_rpc_prefix + "get_dboard_sample_rate");
            }
            void enable_iq_swap(bool is_band_inverted,const std::string& trx,size_t chan) override
            {
                _rpcc->notify_with_token
                    (_rpc_prefix + "enable_iq_swap",is_band_inverted,trx,chan);
            }

        // Deprecated
        uhd::rpc_client::sptr get_raw_rpc_client() override { return _rpcc; }

    private:
        uhd::rpc_client::sptr _rpcc;
            const std::string _rpc_prefix;
    };

}}
