
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kcursor_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qobject.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCursor_Type = nullptr;
static PyTypeObject *Sbk_KCursor_TypeF(void)
{
    return _Sbk_KCursor_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KCursor_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("KCursor");
    return -1;
}

static PyObject *Sbk_KCursorFunc_autoHideEventFilter(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "autoHideEventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KCursor::autoHideEventFilter(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // autoHideEventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "autoHideEventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // autoHideEventFilter(QObject*,QEvent*)
            ::KCursor::autoHideEventFilter(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCursorFunc_hideCursorDelay(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hideCursorDelay()
        int cppResult = ::KCursor::hideCursorDelay();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCursorFunc_setAutoHideCursor(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setAutoHideCursor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setAutoHideCursor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KCursor::setAutoHideCursor(QWidget*,bool,bool=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setAutoHideCursor(QWidget*,bool,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // setAutoHideCursor(QWidget*,bool,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setAutoHideCursor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"customEventFilter", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setAutoHideCursor", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoHideCursor(QWidget*,bool,bool)
            ::KCursor::setAutoHideCursor(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCursorFunc_setHideCursorDelay(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KCursor::setHideCursorDelay(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHideCursorDelay(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHideCursorDelay", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHideCursorDelay(int)
            ::KCursor::setHideCursorDelay(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KCursor_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCursor_methods[] = {
    {"autoHideEventFilter", reinterpret_cast<PyCFunction>(Sbk_KCursorFunc_autoHideEventFilter), METH_VARARGS|METH_STATIC, nullptr},
    {"hideCursorDelay", reinterpret_cast<PyCFunction>(Sbk_KCursorFunc_hideCursorDelay), METH_NOARGS|METH_STATIC, nullptr},
    {"setAutoHideCursor", reinterpret_cast<PyCFunction>(Sbk_KCursorFunc_setAutoHideCursor), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"setHideCursorDelay", reinterpret_cast<PyCFunction>(Sbk_KCursorFunc_setHideCursorDelay), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KCursor_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCursor_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCursor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCursor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCursor_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCursor_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCursor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCursor_spec = {
    "1:KWidgetsAddons.KCursor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCursor_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCursor_PythonToCpp_KCursor_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCursor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCursor_PythonToCpp_KCursor_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCursor_TypeF()))
        return KCursor_PythonToCpp_KCursor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCursor_PTR_CppToPython_KCursor(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KCursor_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KCursor_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCursor_SignatureStrings[] = {
    "KWidgetsAddons.KCursor.autoHideEventFilter(arg__1:PySide6.QtCore.QObject,arg__2:PySide6.QtCore.QEvent)",
    "KWidgetsAddons.KCursor.hideCursorDelay()->int",
    "KWidgetsAddons.KCursor.setAutoHideCursor(w:PySide6.QtWidgets.QWidget,enable:bool,customEventFilter:bool=false)",
    "KWidgetsAddons.KCursor.setHideCursorDelay(ms:int)",
    nullptr}; // Sentinel
#else
static constexpr size_t KCursor_SignatureByteSize = 169;
static constexpr uint8_t KCursor_SignatureBytes[169] = {
    0x78, 0xda, 0x7d, 0x4f, 0x4d, 0x0b, 0x82, 0x40, 0x14, 0xbc, 0xf7, 0x4b, 0x14, 0x6c, 0xa1, 0x0e,
    0x1d, 0x84, 0x02, 0xb1, 0x42, 0xf0, 0x50, 0xd2, 0xa1, 0xa3, 0xac, 0xee, 0xcb, 0x36, 0xd6, 0x7d,
    0xb0, 0xef, 0x59, 0xf8, 0xef, 0x33, 0xf5, 0x20, 0x7d, 0xdd, 0x86, 0x99, 0x79, 0x6f, 0x66, 0xd2,
    0xb3, 0x56, 0x15, 0x30, 0x45, 0x4a, 0xa1, 0x25, 0x91, 0xc6, 0x8d, 0x23, 0x74, 0x42, 0x36, 0x8c,
    0x89, 0x56, 0xb0, 0xbb, 0x83, 0xe5, 0xbd, 0x36, 0x0c, 0xce, 0x93, 0xae, 0xca, 0xf3, 0x45, 0x78,
    0x6c, 0x4f, 0x9d, 0xb0, 0x12, 0x19, 0xc7, 0xe8, 0x40, 0x64, 0x87, 0xe2, 0x06, 0x25, 0x07, 0xbd,
    0xba, 0xfc, 0x50, 0xfb, 0x07, 0xfe, 0x2c, 0xfd, 0x1e, 0x73, 0xed, 0xbc, 0x03, 0xdc, 0x82, 0x91,
    0xad, 0xe7, 0xcf, 0x37, 0xda, 0xf2, 0x2f, 0x37, 0x01, 0x47, 0x63, 0xaf, 0x81, 0xf1, 0x1e, 0x93,
    0xbc, 0xf1, 0x46, 0x64, 0x03, 0x08, 0xc0, 0xca, 0xc2, 0x40, 0x58, 0x20, 0x9a, 0xa0, 0x6c, 0x88,
    0xb1, 0x9e, 0x8c, 0xe9, 0xe9, 0xf5, 0x45, 0x1a, 0x02, 0xff, 0x4f, 0x5c, 0xf2, 0xd6, 0xaf, 0xa6,
    0x50, 0xbf, 0xe6, 0x3c, 0x01, 0xd4, 0x55, 0x71, 0xbc
};
#endif

PyTypeObject *init_KCursor(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX].type;

    Shiboken::AutoDecRef Sbk_KCursor_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KCursor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCursor",
        "KCursor*",
        &Sbk_KCursor_spec,
        &Shiboken::callCppDestructor< ::KCursor >,
        Sbk_KCursor_Type_bases.object(),
        0);
    auto *pyType = Sbk_KCursor_TypeF(); // references _Sbk_KCursor_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCursor_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCursor_SignatureBytes, KCursor_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCursor_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KCursor_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCursor_PythonToCpp_KCursor_PTR,
        is_KCursor_PythonToCpp_KCursor_PTR_Convertible,
        KCursor_PTR_CppToPython_KCursor);

    Shiboken::Conversions::registerConverterName(converter, "KCursor");
    Shiboken::Conversions::registerConverterName(converter, "KCursor*");
    Shiboken::Conversions::registerConverterName(converter, "KCursor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCursor).name());

    qRegisterMetaType< ::KCursor *>();

    return pyType;
}
