{-# LANGUAGE CPP #-}
{-# LANGUAGE NoRebindableSyntax #-}
{-# OPTIONS_GHC -fno-warn-missing-import-lists #-}
{-# OPTIONS_GHC -w #-}
module Paths_pandoc_types (
    version,
    getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where


import qualified Control.Exception as Exception
import qualified Data.List as List
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude


#if defined(VERSION_base)

#if MIN_VERSION_base(4,0,0)
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#else
catchIO :: IO a -> (Exception.Exception -> IO a) -> IO a
#endif

#else
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#endif
catchIO = Exception.catch

version :: Version
version = Version [1,23,1] []

getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir `joinFileName` name)

getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir, getSysconfDir :: IO FilePath



bindir, libdir, dynlibdir, datadir, libexecdir, sysconfdir :: FilePath
bindir     = "/usr/bin"
libdir     = "/usr/lib/ghc-9.4.8/site-local/pandoc-types-1.23.1"
dynlibdir  = "/usr/lib"
datadir    = "/usr/share/haskell-pandoc-types"
libexecdir = "/usr/libexec/x86_64-linux-ghc-9.4.8/pandoc-types-1.23.1"
sysconfdir = "/usr/etc"

getBinDir     = catchIO (getEnv "pandoc_types_bindir")     (\_ -> return bindir)
getLibDir     = catchIO (getEnv "pandoc_types_libdir")     (\_ -> return libdir)
getDynLibDir  = catchIO (getEnv "pandoc_types_dynlibdir")  (\_ -> return dynlibdir)
getDataDir    = catchIO (getEnv "pandoc_types_datadir")    (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "pandoc_types_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "pandoc_types_sysconfdir") (\_ -> return sysconfdir)




joinFileName :: String -> String -> FilePath
joinFileName ""  fname = fname
joinFileName "." fname = fname
joinFileName dir ""    = dir
joinFileName dir fname
  | isPathSeparator (List.last dir) = dir ++ fname
  | otherwise                       = dir ++ pathSeparator : fname

pathSeparator :: Char
pathSeparator = '/'

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/'
