{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays a Gregorian calendar, one month at a time.
-- 
-- \<picture>
--   \<source srcset=\"calendar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkCalendar\" src=\"calendar.png\">
-- \<\/picture>
-- 
-- A @GtkCalendar@ can be created with 'GI.Gtk.Objects.Calendar.calendarNew'.
-- 
-- The selected date can be retrieved from a @GtkCalendar@ using
-- 'GI.Gtk.Objects.Calendar.calendarGetDate'.
-- It can be altered with 'GI.Gtk.Objects.Calendar.calendarSetDate'.
-- 
-- To place a visual marker on a particular day, use
-- 'GI.Gtk.Objects.Calendar.calendarMarkDay' and to remove the marker,
-- 'GI.Gtk.Objects.Calendar.calendarUnmarkDay'. Alternative, all
-- marks can be cleared with 'GI.Gtk.Objects.Calendar.calendarClearMarks'.
-- 
-- Users should be aware that, although the Gregorian calendar is the
-- legal calendar in most countries, it was adopted progressively
-- between 1582 and 1929. Display before these dates is likely to be
-- historically incorrect.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkCalendar@ supports the following gestures:
-- 
-- * Scrolling up or down will switch to the previous or next month.
-- * Date strings can be dropped for setting the current day.
-- 
-- 
-- = CSS nodes
-- 
-- 
-- 	
-- >calendar.view
-- >├── header
-- >│   ├── button
-- >│   ├── stack.month
-- >│   ├── button
-- >│   ├── button
-- >│   ├── label.year
-- >│   ╰── button
-- >╰── grid
-- >    ╰── label[.day-name][.week-number][.day-number][.other-month][.today]
-- 
-- 
-- @GtkCalendar@ has a main node with name calendar. It contains a subnode
-- called header containing the widgets for switching between years and months.
-- 
-- The grid subnode contains all day labels, including week numbers on the left
-- (marked with the .week-number css class) and day names on top (marked with the
-- .day-name css class).
-- 
-- Day labels that belong to the previous or next month get the .other-month
-- style class. The label of the current day get the .today style class.
-- 
-- Marked day labels get the :selected state assigned.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Calendar
    ( 

-- * Exported types
    Calendar(..)                            ,
    IsCalendar                              ,
    toCalendar                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [clearMarks]("GI.Gtk.Objects.Calendar#g:method:clearMarks"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [markDay]("GI.Gtk.Objects.Calendar#g:method:markDay"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [selectDay]("GI.Gtk.Objects.Calendar#g:method:selectDay"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmarkDay]("GI.Gtk.Objects.Calendar#g:method:unmarkDay"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDate]("GI.Gtk.Objects.Calendar#g:method:getDate"), [getDay]("GI.Gtk.Objects.Calendar#g:method:getDay"), [getDayIsMarked]("GI.Gtk.Objects.Calendar#g:method:getDayIsMarked"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMonth]("GI.Gtk.Objects.Calendar#g:method:getMonth"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowDayNames]("GI.Gtk.Objects.Calendar#g:method:getShowDayNames"), [getShowHeading]("GI.Gtk.Objects.Calendar#g:method:getShowHeading"), [getShowWeekNumbers]("GI.Gtk.Objects.Calendar#g:method:getShowWeekNumbers"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getYear]("GI.Gtk.Objects.Calendar#g:method:getYear").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDate]("GI.Gtk.Objects.Calendar#g:method:setDate"), [setDay]("GI.Gtk.Objects.Calendar#g:method:setDay"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMonth]("GI.Gtk.Objects.Calendar#g:method:setMonth"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowDayNames]("GI.Gtk.Objects.Calendar#g:method:setShowDayNames"), [setShowHeading]("GI.Gtk.Objects.Calendar#g:method:setShowHeading"), [setShowWeekNumbers]("GI.Gtk.Objects.Calendar#g:method:setShowWeekNumbers"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setYear]("GI.Gtk.Objects.Calendar#g:method:setYear").

#if defined(ENABLE_OVERLOADING)
    ResolveCalendarMethod                   ,
#endif

-- ** clearMarks #method:clearMarks#

#if defined(ENABLE_OVERLOADING)
    CalendarClearMarksMethodInfo            ,
#endif
    calendarClearMarks                      ,


-- ** getDate #method:getDate#

#if defined(ENABLE_OVERLOADING)
    CalendarGetDateMethodInfo               ,
#endif
    calendarGetDate                         ,


-- ** getDay #method:getDay#

#if defined(ENABLE_OVERLOADING)
    CalendarGetDayMethodInfo                ,
#endif
    calendarGetDay                          ,


-- ** getDayIsMarked #method:getDayIsMarked#

#if defined(ENABLE_OVERLOADING)
    CalendarGetDayIsMarkedMethodInfo        ,
#endif
    calendarGetDayIsMarked                  ,


-- ** getMonth #method:getMonth#

#if defined(ENABLE_OVERLOADING)
    CalendarGetMonthMethodInfo              ,
#endif
    calendarGetMonth                        ,


-- ** getShowDayNames #method:getShowDayNames#

#if defined(ENABLE_OVERLOADING)
    CalendarGetShowDayNamesMethodInfo       ,
#endif
    calendarGetShowDayNames                 ,


-- ** getShowHeading #method:getShowHeading#

#if defined(ENABLE_OVERLOADING)
    CalendarGetShowHeadingMethodInfo        ,
#endif
    calendarGetShowHeading                  ,


-- ** getShowWeekNumbers #method:getShowWeekNumbers#

#if defined(ENABLE_OVERLOADING)
    CalendarGetShowWeekNumbersMethodInfo    ,
#endif
    calendarGetShowWeekNumbers              ,


-- ** getYear #method:getYear#

#if defined(ENABLE_OVERLOADING)
    CalendarGetYearMethodInfo               ,
#endif
    calendarGetYear                         ,


-- ** markDay #method:markDay#

#if defined(ENABLE_OVERLOADING)
    CalendarMarkDayMethodInfo               ,
#endif
    calendarMarkDay                         ,


-- ** new #method:new#

    calendarNew                             ,


-- ** selectDay #method:selectDay#

#if defined(ENABLE_OVERLOADING)
    CalendarSelectDayMethodInfo             ,
#endif
    calendarSelectDay                       ,


-- ** setDate #method:setDate#

#if defined(ENABLE_OVERLOADING)
    CalendarSetDateMethodInfo               ,
#endif
    calendarSetDate                         ,


-- ** setDay #method:setDay#

#if defined(ENABLE_OVERLOADING)
    CalendarSetDayMethodInfo                ,
#endif
    calendarSetDay                          ,


-- ** setMonth #method:setMonth#

#if defined(ENABLE_OVERLOADING)
    CalendarSetMonthMethodInfo              ,
#endif
    calendarSetMonth                        ,


-- ** setShowDayNames #method:setShowDayNames#

#if defined(ENABLE_OVERLOADING)
    CalendarSetShowDayNamesMethodInfo       ,
#endif
    calendarSetShowDayNames                 ,


-- ** setShowHeading #method:setShowHeading#

#if defined(ENABLE_OVERLOADING)
    CalendarSetShowHeadingMethodInfo        ,
#endif
    calendarSetShowHeading                  ,


-- ** setShowWeekNumbers #method:setShowWeekNumbers#

#if defined(ENABLE_OVERLOADING)
    CalendarSetShowWeekNumbersMethodInfo    ,
#endif
    calendarSetShowWeekNumbers              ,


-- ** setYear #method:setYear#

#if defined(ENABLE_OVERLOADING)
    CalendarSetYearMethodInfo               ,
#endif
    calendarSetYear                         ,


-- ** unmarkDay #method:unmarkDay#

#if defined(ENABLE_OVERLOADING)
    CalendarUnmarkDayMethodInfo             ,
#endif
    calendarUnmarkDay                       ,




 -- * Properties


-- ** date #attr:date#
-- | The selected date.
-- 
-- This property gets initially set to the current date.

#if defined(ENABLE_OVERLOADING)
    CalendarDatePropertyInfo                ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarDate                            ,
#endif
    constructCalendarDate                   ,
    getCalendarDate                         ,
    setCalendarDate                         ,


-- ** day #attr:day#
-- | The selected day (as a number between 1 and 31).

#if defined(ENABLE_OVERLOADING)
    CalendarDayPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarDay                             ,
#endif
    constructCalendarDay                    ,
    getCalendarDay                          ,
    setCalendarDay                          ,


-- ** month #attr:month#
-- | The selected month (as a number between 0 and 11).
-- 
-- This property gets initially set to the current month.

#if defined(ENABLE_OVERLOADING)
    CalendarMonthPropertyInfo               ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarMonth                           ,
#endif
    constructCalendarMonth                  ,
    getCalendarMonth                        ,
    setCalendarMonth                        ,


-- ** showDayNames #attr:showDayNames#
-- | Determines whether day names are displayed.

#if defined(ENABLE_OVERLOADING)
    CalendarShowDayNamesPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarShowDayNames                    ,
#endif
    constructCalendarShowDayNames           ,
    getCalendarShowDayNames                 ,
    setCalendarShowDayNames                 ,


-- ** showHeading #attr:showHeading#
-- | Determines whether a heading is displayed.

#if defined(ENABLE_OVERLOADING)
    CalendarShowHeadingPropertyInfo         ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarShowHeading                     ,
#endif
    constructCalendarShowHeading            ,
    getCalendarShowHeading                  ,
    setCalendarShowHeading                  ,


-- ** showWeekNumbers #attr:showWeekNumbers#
-- | Determines whether week numbers are displayed.

#if defined(ENABLE_OVERLOADING)
    CalendarShowWeekNumbersPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarShowWeekNumbers                 ,
#endif
    constructCalendarShowWeekNumbers        ,
    getCalendarShowWeekNumbers              ,
    setCalendarShowWeekNumbers              ,


-- ** year #attr:year#
-- | The selected year.
-- 
-- This property gets initially set to the current year.

#if defined(ENABLE_OVERLOADING)
    CalendarYearPropertyInfo                ,
#endif
#if defined(ENABLE_OVERLOADING)
    calendarYear                            ,
#endif
    constructCalendarYear                   ,
    getCalendarYear                         ,
    setCalendarYear                         ,




 -- * Signals


-- ** daySelected #signal:daySelected#

    CalendarDaySelectedCallback             ,
#if defined(ENABLE_OVERLOADING)
    CalendarDaySelectedSignalInfo           ,
#endif
    afterCalendarDaySelected                ,
    onCalendarDaySelected                   ,


-- ** nextMonth #signal:nextMonth#

    CalendarNextMonthCallback               ,
#if defined(ENABLE_OVERLOADING)
    CalendarNextMonthSignalInfo             ,
#endif
    afterCalendarNextMonth                  ,
    onCalendarNextMonth                     ,


-- ** nextYear #signal:nextYear#

    CalendarNextYearCallback                ,
#if defined(ENABLE_OVERLOADING)
    CalendarNextYearSignalInfo              ,
#endif
    afterCalendarNextYear                   ,
    onCalendarNextYear                      ,


-- ** prevMonth #signal:prevMonth#

    CalendarPrevMonthCallback               ,
#if defined(ENABLE_OVERLOADING)
    CalendarPrevMonthSignalInfo             ,
#endif
    afterCalendarPrevMonth                  ,
    onCalendarPrevMonth                     ,


-- ** prevYear #signal:prevYear#

    CalendarPrevYearCallback                ,
#if defined(ENABLE_OVERLOADING)
    CalendarPrevYearSignalInfo              ,
#endif
    afterCalendarPrevYear                   ,
    onCalendarPrevYear                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Structs.DateTime as GLib.DateTime
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Calendar = Calendar (SP.ManagedPtr Calendar)
    deriving (Eq)

instance SP.ManagedPtrNewtype Calendar where
    toManagedPtr (Calendar p) = p

foreign import ccall "gtk_calendar_get_type"
    c_gtk_calendar_get_type :: IO B.Types.GType

instance B.Types.TypedObject Calendar where
    glibType = c_gtk_calendar_get_type

instance B.Types.GObject Calendar

-- | Type class for types which can be safely cast to t'Calendar', for instance with `toCalendar`.
class (SP.GObject o, O.IsDescendantOf Calendar o) => IsCalendar o
instance (SP.GObject o, O.IsDescendantOf Calendar o) => IsCalendar o

instance O.HasParentTypes Calendar
type instance O.ParentTypes Calendar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'Calendar', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCalendar :: (MIO.MonadIO m, IsCalendar o) => o -> m Calendar
toCalendar = MIO.liftIO . B.ManagedPtr.unsafeCastTo Calendar

-- | Convert t'Calendar' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Calendar) where
    gvalueGType_ = c_gtk_calendar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Calendar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Calendar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Calendar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCalendarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCalendarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveCalendarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveCalendarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveCalendarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveCalendarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveCalendarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveCalendarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveCalendarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveCalendarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveCalendarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveCalendarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCalendarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCalendarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveCalendarMethod "clearMarks" o = CalendarClearMarksMethodInfo
    ResolveCalendarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveCalendarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveCalendarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveCalendarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveCalendarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveCalendarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveCalendarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveCalendarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveCalendarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveCalendarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveCalendarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCalendarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCalendarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCalendarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveCalendarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveCalendarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveCalendarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveCalendarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveCalendarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveCalendarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveCalendarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveCalendarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveCalendarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveCalendarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveCalendarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveCalendarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveCalendarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCalendarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveCalendarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveCalendarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveCalendarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveCalendarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveCalendarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveCalendarMethod "markDay" o = CalendarMarkDayMethodInfo
    ResolveCalendarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveCalendarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveCalendarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCalendarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCalendarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveCalendarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveCalendarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveCalendarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveCalendarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveCalendarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveCalendarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveCalendarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCalendarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCalendarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveCalendarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveCalendarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveCalendarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveCalendarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveCalendarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveCalendarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveCalendarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCalendarMethod "selectDay" o = CalendarSelectDayMethodInfo
    ResolveCalendarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveCalendarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveCalendarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveCalendarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveCalendarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCalendarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCalendarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCalendarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveCalendarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveCalendarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveCalendarMethod "unmarkDay" o = CalendarUnmarkDayMethodInfo
    ResolveCalendarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveCalendarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveCalendarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCalendarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveCalendarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveCalendarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveCalendarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveCalendarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveCalendarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveCalendarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCalendarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveCalendarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveCalendarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveCalendarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveCalendarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveCalendarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveCalendarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveCalendarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveCalendarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveCalendarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveCalendarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveCalendarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveCalendarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveCalendarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveCalendarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveCalendarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveCalendarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveCalendarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveCalendarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveCalendarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCalendarMethod "getDate" o = CalendarGetDateMethodInfo
    ResolveCalendarMethod "getDay" o = CalendarGetDayMethodInfo
    ResolveCalendarMethod "getDayIsMarked" o = CalendarGetDayIsMarkedMethodInfo
    ResolveCalendarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveCalendarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveCalendarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveCalendarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveCalendarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveCalendarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveCalendarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveCalendarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveCalendarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveCalendarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveCalendarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveCalendarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveCalendarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveCalendarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveCalendarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveCalendarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveCalendarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveCalendarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveCalendarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveCalendarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveCalendarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveCalendarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveCalendarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveCalendarMethod "getMonth" o = CalendarGetMonthMethodInfo
    ResolveCalendarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveCalendarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveCalendarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveCalendarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveCalendarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveCalendarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveCalendarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveCalendarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveCalendarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveCalendarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveCalendarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveCalendarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveCalendarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCalendarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCalendarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveCalendarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveCalendarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveCalendarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveCalendarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveCalendarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveCalendarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveCalendarMethod "getShowDayNames" o = CalendarGetShowDayNamesMethodInfo
    ResolveCalendarMethod "getShowHeading" o = CalendarGetShowHeadingMethodInfo
    ResolveCalendarMethod "getShowWeekNumbers" o = CalendarGetShowWeekNumbersMethodInfo
    ResolveCalendarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveCalendarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveCalendarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveCalendarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveCalendarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveCalendarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveCalendarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveCalendarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveCalendarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveCalendarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveCalendarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveCalendarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveCalendarMethod "getYear" o = CalendarGetYearMethodInfo
    ResolveCalendarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveCalendarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveCalendarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveCalendarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveCalendarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveCalendarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveCalendarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveCalendarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCalendarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCalendarMethod "setDate" o = CalendarSetDateMethodInfo
    ResolveCalendarMethod "setDay" o = CalendarSetDayMethodInfo
    ResolveCalendarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveCalendarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveCalendarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveCalendarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveCalendarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveCalendarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveCalendarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveCalendarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveCalendarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveCalendarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveCalendarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveCalendarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveCalendarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveCalendarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveCalendarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveCalendarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveCalendarMethod "setMonth" o = CalendarSetMonthMethodInfo
    ResolveCalendarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveCalendarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveCalendarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveCalendarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveCalendarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCalendarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveCalendarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveCalendarMethod "setShowDayNames" o = CalendarSetShowDayNamesMethodInfo
    ResolveCalendarMethod "setShowHeading" o = CalendarSetShowHeadingMethodInfo
    ResolveCalendarMethod "setShowWeekNumbers" o = CalendarSetShowWeekNumbersMethodInfo
    ResolveCalendarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveCalendarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveCalendarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveCalendarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveCalendarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveCalendarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveCalendarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveCalendarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveCalendarMethod "setYear" o = CalendarSetYearMethodInfo
    ResolveCalendarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCalendarMethod t Calendar, O.OverloadedMethod info Calendar p) => OL.IsLabel t (Calendar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCalendarMethod t Calendar, O.OverloadedMethod info Calendar p, R.HasField t Calendar p) => R.HasField t Calendar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCalendarMethod t Calendar, O.OverloadedMethodInfo info Calendar) => OL.IsLabel t (O.MethodProxy info Calendar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Calendar::day-selected
-- | Emitted when the user selects a day.
type CalendarDaySelectedCallback =
    IO ()

type C_CalendarDaySelectedCallback =
    Ptr Calendar ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CalendarDaySelectedCallback`.
foreign import ccall "wrapper"
    mk_CalendarDaySelectedCallback :: C_CalendarDaySelectedCallback -> IO (FunPtr C_CalendarDaySelectedCallback)

wrap_CalendarDaySelectedCallback :: 
    GObject a => (a -> CalendarDaySelectedCallback) ->
    C_CalendarDaySelectedCallback
wrap_CalendarDaySelectedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [daySelected](#signal:daySelected) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' calendar #daySelected callback
-- @
-- 
-- 
onCalendarDaySelected :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarDaySelectedCallback) -> m SignalHandlerId
onCalendarDaySelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarDaySelectedCallback wrapped
    wrapped'' <- mk_CalendarDaySelectedCallback wrapped'
    connectSignalFunPtr obj "day-selected" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [daySelected](#signal:daySelected) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' calendar #daySelected callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCalendarDaySelected :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarDaySelectedCallback) -> m SignalHandlerId
afterCalendarDaySelected obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarDaySelectedCallback wrapped
    wrapped'' <- mk_CalendarDaySelectedCallback wrapped'
    connectSignalFunPtr obj "day-selected" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CalendarDaySelectedSignalInfo
instance SignalInfo CalendarDaySelectedSignalInfo where
    type HaskellCallbackType CalendarDaySelectedSignalInfo = CalendarDaySelectedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CalendarDaySelectedCallback cb
        cb'' <- mk_CalendarDaySelectedCallback cb'
        connectSignalFunPtr obj "day-selected" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar::day-selected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:signal:daySelected"})

#endif

-- signal Calendar::next-month
-- | Emitted when the user switches to the next month.
type CalendarNextMonthCallback =
    IO ()

type C_CalendarNextMonthCallback =
    Ptr Calendar ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CalendarNextMonthCallback`.
foreign import ccall "wrapper"
    mk_CalendarNextMonthCallback :: C_CalendarNextMonthCallback -> IO (FunPtr C_CalendarNextMonthCallback)

wrap_CalendarNextMonthCallback :: 
    GObject a => (a -> CalendarNextMonthCallback) ->
    C_CalendarNextMonthCallback
wrap_CalendarNextMonthCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [nextMonth](#signal:nextMonth) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' calendar #nextMonth callback
-- @
-- 
-- 
onCalendarNextMonth :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarNextMonthCallback) -> m SignalHandlerId
onCalendarNextMonth obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarNextMonthCallback wrapped
    wrapped'' <- mk_CalendarNextMonthCallback wrapped'
    connectSignalFunPtr obj "next-month" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [nextMonth](#signal:nextMonth) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' calendar #nextMonth callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCalendarNextMonth :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarNextMonthCallback) -> m SignalHandlerId
afterCalendarNextMonth obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarNextMonthCallback wrapped
    wrapped'' <- mk_CalendarNextMonthCallback wrapped'
    connectSignalFunPtr obj "next-month" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CalendarNextMonthSignalInfo
instance SignalInfo CalendarNextMonthSignalInfo where
    type HaskellCallbackType CalendarNextMonthSignalInfo = CalendarNextMonthCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CalendarNextMonthCallback cb
        cb'' <- mk_CalendarNextMonthCallback cb'
        connectSignalFunPtr obj "next-month" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar::next-month"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:signal:nextMonth"})

#endif

-- signal Calendar::next-year
-- | Emitted when user switches to the next year.
type CalendarNextYearCallback =
    IO ()

type C_CalendarNextYearCallback =
    Ptr Calendar ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CalendarNextYearCallback`.
foreign import ccall "wrapper"
    mk_CalendarNextYearCallback :: C_CalendarNextYearCallback -> IO (FunPtr C_CalendarNextYearCallback)

wrap_CalendarNextYearCallback :: 
    GObject a => (a -> CalendarNextYearCallback) ->
    C_CalendarNextYearCallback
wrap_CalendarNextYearCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [nextYear](#signal:nextYear) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' calendar #nextYear callback
-- @
-- 
-- 
onCalendarNextYear :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarNextYearCallback) -> m SignalHandlerId
onCalendarNextYear obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarNextYearCallback wrapped
    wrapped'' <- mk_CalendarNextYearCallback wrapped'
    connectSignalFunPtr obj "next-year" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [nextYear](#signal:nextYear) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' calendar #nextYear callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCalendarNextYear :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarNextYearCallback) -> m SignalHandlerId
afterCalendarNextYear obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarNextYearCallback wrapped
    wrapped'' <- mk_CalendarNextYearCallback wrapped'
    connectSignalFunPtr obj "next-year" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CalendarNextYearSignalInfo
instance SignalInfo CalendarNextYearSignalInfo where
    type HaskellCallbackType CalendarNextYearSignalInfo = CalendarNextYearCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CalendarNextYearCallback cb
        cb'' <- mk_CalendarNextYearCallback cb'
        connectSignalFunPtr obj "next-year" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar::next-year"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:signal:nextYear"})

#endif

-- signal Calendar::prev-month
-- | Emitted when the user switches to the previous month.
type CalendarPrevMonthCallback =
    IO ()

type C_CalendarPrevMonthCallback =
    Ptr Calendar ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CalendarPrevMonthCallback`.
foreign import ccall "wrapper"
    mk_CalendarPrevMonthCallback :: C_CalendarPrevMonthCallback -> IO (FunPtr C_CalendarPrevMonthCallback)

wrap_CalendarPrevMonthCallback :: 
    GObject a => (a -> CalendarPrevMonthCallback) ->
    C_CalendarPrevMonthCallback
wrap_CalendarPrevMonthCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [prevMonth](#signal:prevMonth) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' calendar #prevMonth callback
-- @
-- 
-- 
onCalendarPrevMonth :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarPrevMonthCallback) -> m SignalHandlerId
onCalendarPrevMonth obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarPrevMonthCallback wrapped
    wrapped'' <- mk_CalendarPrevMonthCallback wrapped'
    connectSignalFunPtr obj "prev-month" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [prevMonth](#signal:prevMonth) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' calendar #prevMonth callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCalendarPrevMonth :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarPrevMonthCallback) -> m SignalHandlerId
afterCalendarPrevMonth obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarPrevMonthCallback wrapped
    wrapped'' <- mk_CalendarPrevMonthCallback wrapped'
    connectSignalFunPtr obj "prev-month" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CalendarPrevMonthSignalInfo
instance SignalInfo CalendarPrevMonthSignalInfo where
    type HaskellCallbackType CalendarPrevMonthSignalInfo = CalendarPrevMonthCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CalendarPrevMonthCallback cb
        cb'' <- mk_CalendarPrevMonthCallback cb'
        connectSignalFunPtr obj "prev-month" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar::prev-month"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:signal:prevMonth"})

#endif

-- signal Calendar::prev-year
-- | Emitted when user switches to the previous year.
type CalendarPrevYearCallback =
    IO ()

type C_CalendarPrevYearCallback =
    Ptr Calendar ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_CalendarPrevYearCallback`.
foreign import ccall "wrapper"
    mk_CalendarPrevYearCallback :: C_CalendarPrevYearCallback -> IO (FunPtr C_CalendarPrevYearCallback)

wrap_CalendarPrevYearCallback :: 
    GObject a => (a -> CalendarPrevYearCallback) ->
    C_CalendarPrevYearCallback
wrap_CalendarPrevYearCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [prevYear](#signal:prevYear) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' calendar #prevYear callback
-- @
-- 
-- 
onCalendarPrevYear :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarPrevYearCallback) -> m SignalHandlerId
onCalendarPrevYear obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarPrevYearCallback wrapped
    wrapped'' <- mk_CalendarPrevYearCallback wrapped'
    connectSignalFunPtr obj "prev-year" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [prevYear](#signal:prevYear) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' calendar #prevYear callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterCalendarPrevYear :: (IsCalendar a, MonadIO m) => a -> ((?self :: a) => CalendarPrevYearCallback) -> m SignalHandlerId
afterCalendarPrevYear obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_CalendarPrevYearCallback wrapped
    wrapped'' <- mk_CalendarPrevYearCallback wrapped'
    connectSignalFunPtr obj "prev-year" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data CalendarPrevYearSignalInfo
instance SignalInfo CalendarPrevYearSignalInfo where
    type HaskellCallbackType CalendarPrevYearSignalInfo = CalendarPrevYearCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_CalendarPrevYearCallback cb
        cb'' <- mk_CalendarPrevYearCallback cb'
        connectSignalFunPtr obj "prev-year" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar::prev-year"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:signal:prevYear"})

#endif

-- VVV Prop "date"
   -- Type: TInterface (Name {namespace = "GLib", name = "DateTime"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@date@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #date
-- @
getCalendarDate :: (MonadIO m, IsCalendar o) => o -> m (Maybe GLib.DateTime.DateTime)
getCalendarDate obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "date" GLib.DateTime.DateTime

-- | Set the value of the “@date@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #date 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarDate :: (MonadIO m, IsCalendar o) => o -> GLib.DateTime.DateTime -> m ()
setCalendarDate obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "date" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@date@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarDate :: (IsCalendar o, MIO.MonadIO m) => GLib.DateTime.DateTime -> m (GValueConstruct o)
constructCalendarDate val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "date" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data CalendarDatePropertyInfo
instance AttrInfo CalendarDatePropertyInfo where
    type AttrAllowedOps CalendarDatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarDatePropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarDatePropertyInfo = (~) GLib.DateTime.DateTime
    type AttrTransferTypeConstraint CalendarDatePropertyInfo = (~) GLib.DateTime.DateTime
    type AttrTransferType CalendarDatePropertyInfo = GLib.DateTime.DateTime
    type AttrGetType CalendarDatePropertyInfo = (Maybe GLib.DateTime.DateTime)
    type AttrLabel CalendarDatePropertyInfo = "date"
    type AttrOrigin CalendarDatePropertyInfo = Calendar
    attrGet = getCalendarDate
    attrSet = setCalendarDate
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarDate
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.date"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:date"
        })
#endif

-- VVV Prop "day"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@day@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #day
-- @
getCalendarDay :: (MonadIO m, IsCalendar o) => o -> m Int32
getCalendarDay obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "day"

-- | Set the value of the “@day@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #day 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarDay :: (MonadIO m, IsCalendar o) => o -> Int32 -> m ()
setCalendarDay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "day" val

-- | Construct a t'GValueConstruct' with valid value for the “@day@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarDay :: (IsCalendar o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructCalendarDay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "day" val

#if defined(ENABLE_OVERLOADING)
data CalendarDayPropertyInfo
instance AttrInfo CalendarDayPropertyInfo where
    type AttrAllowedOps CalendarDayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarDayPropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarDayPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint CalendarDayPropertyInfo = (~) Int32
    type AttrTransferType CalendarDayPropertyInfo = Int32
    type AttrGetType CalendarDayPropertyInfo = Int32
    type AttrLabel CalendarDayPropertyInfo = "day"
    type AttrOrigin CalendarDayPropertyInfo = Calendar
    attrGet = getCalendarDay
    attrSet = setCalendarDay
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarDay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.day"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:day"
        })
#endif

-- VVV Prop "month"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@month@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #month
-- @
getCalendarMonth :: (MonadIO m, IsCalendar o) => o -> m Int32
getCalendarMonth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "month"

-- | Set the value of the “@month@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #month 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarMonth :: (MonadIO m, IsCalendar o) => o -> Int32 -> m ()
setCalendarMonth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "month" val

-- | Construct a t'GValueConstruct' with valid value for the “@month@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarMonth :: (IsCalendar o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructCalendarMonth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "month" val

#if defined(ENABLE_OVERLOADING)
data CalendarMonthPropertyInfo
instance AttrInfo CalendarMonthPropertyInfo where
    type AttrAllowedOps CalendarMonthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarMonthPropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarMonthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint CalendarMonthPropertyInfo = (~) Int32
    type AttrTransferType CalendarMonthPropertyInfo = Int32
    type AttrGetType CalendarMonthPropertyInfo = Int32
    type AttrLabel CalendarMonthPropertyInfo = "month"
    type AttrOrigin CalendarMonthPropertyInfo = Calendar
    attrGet = getCalendarMonth
    attrSet = setCalendarMonth
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarMonth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.month"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:month"
        })
#endif

-- VVV Prop "show-day-names"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-day-names@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #showDayNames
-- @
getCalendarShowDayNames :: (MonadIO m, IsCalendar o) => o -> m Bool
getCalendarShowDayNames obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-day-names"

-- | Set the value of the “@show-day-names@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #showDayNames 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarShowDayNames :: (MonadIO m, IsCalendar o) => o -> Bool -> m ()
setCalendarShowDayNames obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-day-names" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-day-names@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarShowDayNames :: (IsCalendar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCalendarShowDayNames val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-day-names" val

#if defined(ENABLE_OVERLOADING)
data CalendarShowDayNamesPropertyInfo
instance AttrInfo CalendarShowDayNamesPropertyInfo where
    type AttrAllowedOps CalendarShowDayNamesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarShowDayNamesPropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarShowDayNamesPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CalendarShowDayNamesPropertyInfo = (~) Bool
    type AttrTransferType CalendarShowDayNamesPropertyInfo = Bool
    type AttrGetType CalendarShowDayNamesPropertyInfo = Bool
    type AttrLabel CalendarShowDayNamesPropertyInfo = "show-day-names"
    type AttrOrigin CalendarShowDayNamesPropertyInfo = Calendar
    attrGet = getCalendarShowDayNames
    attrSet = setCalendarShowDayNames
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarShowDayNames
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.showDayNames"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:showDayNames"
        })
#endif

-- VVV Prop "show-heading"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-heading@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #showHeading
-- @
getCalendarShowHeading :: (MonadIO m, IsCalendar o) => o -> m Bool
getCalendarShowHeading obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-heading"

-- | Set the value of the “@show-heading@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #showHeading 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarShowHeading :: (MonadIO m, IsCalendar o) => o -> Bool -> m ()
setCalendarShowHeading obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-heading" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-heading@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarShowHeading :: (IsCalendar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCalendarShowHeading val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-heading" val

#if defined(ENABLE_OVERLOADING)
data CalendarShowHeadingPropertyInfo
instance AttrInfo CalendarShowHeadingPropertyInfo where
    type AttrAllowedOps CalendarShowHeadingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarShowHeadingPropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarShowHeadingPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CalendarShowHeadingPropertyInfo = (~) Bool
    type AttrTransferType CalendarShowHeadingPropertyInfo = Bool
    type AttrGetType CalendarShowHeadingPropertyInfo = Bool
    type AttrLabel CalendarShowHeadingPropertyInfo = "show-heading"
    type AttrOrigin CalendarShowHeadingPropertyInfo = Calendar
    attrGet = getCalendarShowHeading
    attrSet = setCalendarShowHeading
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarShowHeading
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.showHeading"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:showHeading"
        })
#endif

-- VVV Prop "show-week-numbers"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-week-numbers@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #showWeekNumbers
-- @
getCalendarShowWeekNumbers :: (MonadIO m, IsCalendar o) => o -> m Bool
getCalendarShowWeekNumbers obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-week-numbers"

-- | Set the value of the “@show-week-numbers@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #showWeekNumbers 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarShowWeekNumbers :: (MonadIO m, IsCalendar o) => o -> Bool -> m ()
setCalendarShowWeekNumbers obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-week-numbers" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-week-numbers@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarShowWeekNumbers :: (IsCalendar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructCalendarShowWeekNumbers val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-week-numbers" val

#if defined(ENABLE_OVERLOADING)
data CalendarShowWeekNumbersPropertyInfo
instance AttrInfo CalendarShowWeekNumbersPropertyInfo where
    type AttrAllowedOps CalendarShowWeekNumbersPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarShowWeekNumbersPropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarShowWeekNumbersPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint CalendarShowWeekNumbersPropertyInfo = (~) Bool
    type AttrTransferType CalendarShowWeekNumbersPropertyInfo = Bool
    type AttrGetType CalendarShowWeekNumbersPropertyInfo = Bool
    type AttrLabel CalendarShowWeekNumbersPropertyInfo = "show-week-numbers"
    type AttrOrigin CalendarShowWeekNumbersPropertyInfo = Calendar
    attrGet = getCalendarShowWeekNumbers
    attrSet = setCalendarShowWeekNumbers
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarShowWeekNumbers
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.showWeekNumbers"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:showWeekNumbers"
        })
#endif

-- VVV Prop "year"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@year@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' calendar #year
-- @
getCalendarYear :: (MonadIO m, IsCalendar o) => o -> m Int32
getCalendarYear obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "year"

-- | Set the value of the “@year@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' calendar [ #year 'Data.GI.Base.Attributes.:=' value ]
-- @
setCalendarYear :: (MonadIO m, IsCalendar o) => o -> Int32 -> m ()
setCalendarYear obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "year" val

-- | Construct a t'GValueConstruct' with valid value for the “@year@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCalendarYear :: (IsCalendar o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructCalendarYear val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "year" val

#if defined(ENABLE_OVERLOADING)
data CalendarYearPropertyInfo
instance AttrInfo CalendarYearPropertyInfo where
    type AttrAllowedOps CalendarYearPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint CalendarYearPropertyInfo = IsCalendar
    type AttrSetTypeConstraint CalendarYearPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint CalendarYearPropertyInfo = (~) Int32
    type AttrTransferType CalendarYearPropertyInfo = Int32
    type AttrGetType CalendarYearPropertyInfo = Int32
    type AttrLabel CalendarYearPropertyInfo = "year"
    type AttrOrigin CalendarYearPropertyInfo = Calendar
    attrGet = getCalendarYear
    attrSet = setCalendarYear
    attrTransfer _ v = do
        return v
    attrConstruct = constructCalendarYear
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.year"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#g:attr:year"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Calendar
type instance O.AttributeList Calendar = CalendarAttributeList
type CalendarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("date", CalendarDatePropertyInfo), '("day", CalendarDayPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("month", CalendarMonthPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showDayNames", CalendarShowDayNamesPropertyInfo), '("showHeading", CalendarShowHeadingPropertyInfo), '("showWeekNumbers", CalendarShowWeekNumbersPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("year", CalendarYearPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
calendarDate :: AttrLabelProxy "date"
calendarDate = AttrLabelProxy

calendarDay :: AttrLabelProxy "day"
calendarDay = AttrLabelProxy

calendarMonth :: AttrLabelProxy "month"
calendarMonth = AttrLabelProxy

calendarShowDayNames :: AttrLabelProxy "showDayNames"
calendarShowDayNames = AttrLabelProxy

calendarShowHeading :: AttrLabelProxy "showHeading"
calendarShowHeading = AttrLabelProxy

calendarShowWeekNumbers :: AttrLabelProxy "showWeekNumbers"
calendarShowWeekNumbers = AttrLabelProxy

calendarYear :: AttrLabelProxy "year"
calendarYear = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Calendar = CalendarSignalList
type CalendarSignalList = ('[ '("daySelected", CalendarDaySelectedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("nextMonth", CalendarNextMonthSignalInfo), '("nextYear", CalendarNextYearSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("prevMonth", CalendarPrevMonthSignalInfo), '("prevYear", CalendarPrevYearSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Calendar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Calendar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_new" gtk_calendar_new :: 
    IO (Ptr Calendar)

-- | Creates a new calendar, with the current date being selected.
calendarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Calendar
    -- ^ __Returns:__ a newly @GtkCalendar@ widget
calendarNew  = liftIO $ do
    result <- gtk_calendar_new
    checkUnexpectedReturnNULL "calendarNew" result
    result' <- (newObject Calendar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Calendar::clear_marks
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "calendar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_clear_marks" gtk_calendar_clear_marks :: 
    Ptr Calendar ->                         -- calendar : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO ()

-- | Remove all visual markers.
calendarClearMarks ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@calendar@/: a @GtkCalendar@
    -> m ()
calendarClearMarks calendar = liftIO $ do
    calendar' <- unsafeManagedPtrCastPtr calendar
    gtk_calendar_clear_marks calendar'
    touchManagedPtr calendar
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarClearMarksMethodInfo
instance (signature ~ (m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarClearMarksMethodInfo a signature where
    overloadedMethod = calendarClearMarks

instance O.OverloadedMethodInfo CalendarClearMarksMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarClearMarks",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarClearMarks"
        })


#endif

-- method Calendar::get_date
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "DateTime" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_date" gtk_calendar_get_date :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO (Ptr GLib.DateTime.DateTime)

-- | Returns a @GDateTime@ representing the shown
-- year, month and the selected day.
-- 
-- The returned date is in the local time zone.
calendarGetDate ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m GLib.DateTime.DateTime
    -- ^ __Returns:__ the @GDateTime@ representing the selected date
calendarGetDate self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_date self'
    checkUnexpectedReturnNULL "calendarGetDate" result
    result' <- (wrapBoxed GLib.DateTime.DateTime) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CalendarGetDateMethodInfo
instance (signature ~ (m GLib.DateTime.DateTime), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetDateMethodInfo a signature where
    overloadedMethod = calendarGetDate

instance O.OverloadedMethodInfo CalendarGetDateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetDate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetDate"
        })


#endif

-- method Calendar::get_day
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_day" gtk_calendar_get_day :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO Int32

-- | Gets the day of the selected date.
-- 
-- /Since: 4.14/
calendarGetDay ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m Int32
    -- ^ __Returns:__ the day of the selected date.
calendarGetDay self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_day self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data CalendarGetDayMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetDayMethodInfo a signature where
    overloadedMethod = calendarGetDay

instance O.OverloadedMethodInfo CalendarGetDayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetDay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetDay"
        })


#endif

-- method Calendar::get_day_is_marked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "calendar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "day"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the day number between 1 and 31."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_day_is_marked" gtk_calendar_get_day_is_marked :: 
    Ptr Calendar ->                         -- calendar : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Word32 ->                               -- day : TBasicType TUInt
    IO CInt

-- | Returns if the /@day@/ of the /@calendar@/ is already marked.
calendarGetDayIsMarked ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@calendar@/: a @GtkCalendar@
    -> Word32
    -- ^ /@day@/: the day number between 1 and 31.
    -> m Bool
    -- ^ __Returns:__ whether the day is marked.
calendarGetDayIsMarked calendar day = liftIO $ do
    calendar' <- unsafeManagedPtrCastPtr calendar
    result <- gtk_calendar_get_day_is_marked calendar' day
    let result' = (/= 0) result
    touchManagedPtr calendar
    return result'

#if defined(ENABLE_OVERLOADING)
data CalendarGetDayIsMarkedMethodInfo
instance (signature ~ (Word32 -> m Bool), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetDayIsMarkedMethodInfo a signature where
    overloadedMethod = calendarGetDayIsMarked

instance O.OverloadedMethodInfo CalendarGetDayIsMarkedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetDayIsMarked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetDayIsMarked"
        })


#endif

-- method Calendar::get_month
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_month" gtk_calendar_get_month :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO Int32

-- | Gets the month of the selected date.
-- 
-- /Since: 4.14/
calendarGetMonth ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m Int32
    -- ^ __Returns:__ The month of the selected date (as a number between 0 and 11).
calendarGetMonth self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_month self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data CalendarGetMonthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetMonthMethodInfo a signature where
    overloadedMethod = calendarGetMonth

instance O.OverloadedMethodInfo CalendarGetMonthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetMonth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetMonth"
        })


#endif

-- method Calendar::get_show_day_names
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_show_day_names" gtk_calendar_get_show_day_names :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO CInt

-- | Returns whether /@self@/ is currently showing the names
-- of the week days.
-- 
-- This is the value of the [Calendar:showDayNames]("GI.Gtk.Objects.Calendar#g:attr:showDayNames")
-- property.
calendarGetShowDayNames ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m Bool
    -- ^ __Returns:__ Whether the calendar shows day names.
calendarGetShowDayNames self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_show_day_names self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CalendarGetShowDayNamesMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetShowDayNamesMethodInfo a signature where
    overloadedMethod = calendarGetShowDayNames

instance O.OverloadedMethodInfo CalendarGetShowDayNamesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetShowDayNames",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetShowDayNames"
        })


#endif

-- method Calendar::get_show_heading
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_show_heading" gtk_calendar_get_show_heading :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO CInt

-- | Returns whether /@self@/ is currently showing the heading.
-- 
-- This is the value of the [Calendar:showHeading]("GI.Gtk.Objects.Calendar#g:attr:showHeading")
-- property.
calendarGetShowHeading ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m Bool
    -- ^ __Returns:__ Whether the calendar is showing a heading.
calendarGetShowHeading self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_show_heading self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CalendarGetShowHeadingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetShowHeadingMethodInfo a signature where
    overloadedMethod = calendarGetShowHeading

instance O.OverloadedMethodInfo CalendarGetShowHeadingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetShowHeading",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetShowHeading"
        })


#endif

-- method Calendar::get_show_week_numbers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_show_week_numbers" gtk_calendar_get_show_week_numbers :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO CInt

-- | Returns whether /@self@/ is showing week numbers right
-- now.
-- 
-- This is the value of the [Calendar:showWeekNumbers]("GI.Gtk.Objects.Calendar#g:attr:showWeekNumbers")
-- property.
calendarGetShowWeekNumbers ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m Bool
    -- ^ __Returns:__ Whether the calendar is showing week numbers.
calendarGetShowWeekNumbers self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_show_week_numbers self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data CalendarGetShowWeekNumbersMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetShowWeekNumbersMethodInfo a signature where
    overloadedMethod = calendarGetShowWeekNumbers

instance O.OverloadedMethodInfo CalendarGetShowWeekNumbersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetShowWeekNumbers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetShowWeekNumbers"
        })


#endif

-- method Calendar::get_year
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_get_year" gtk_calendar_get_year :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    IO Int32

-- | Gets the year of the selected date.
-- 
-- /Since: 4.14/
calendarGetYear ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> m Int32
    -- ^ __Returns:__ the year of the selected date.
calendarGetYear self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_calendar_get_year self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data CalendarGetYearMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarGetYearMethodInfo a signature where
    overloadedMethod = calendarGetYear

instance O.OverloadedMethodInfo CalendarGetYearMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarGetYear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarGetYear"
        })


#endif

-- method Calendar::mark_day
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "calendar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "day"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the day number to mark between 1 and 31."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_mark_day" gtk_calendar_mark_day :: 
    Ptr Calendar ->                         -- calendar : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Word32 ->                               -- day : TBasicType TUInt
    IO ()

-- | Places a visual marker on a particular day of the current month.
calendarMarkDay ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@calendar@/: a @GtkCalendar@
    -> Word32
    -- ^ /@day@/: the day number to mark between 1 and 31.
    -> m ()
calendarMarkDay calendar day = liftIO $ do
    calendar' <- unsafeManagedPtrCastPtr calendar
    gtk_calendar_mark_day calendar' day
    touchManagedPtr calendar
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarMarkDayMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarMarkDayMethodInfo a signature where
    overloadedMethod = calendarMarkDay

instance O.OverloadedMethodInfo CalendarMarkDayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarMarkDay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarMarkDay"
        })


#endif

-- method Calendar::select_day
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "date"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DateTime" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GDateTime` representing the day to select"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_select_day" gtk_calendar_select_day :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Ptr GLib.DateTime.DateTime ->           -- date : TInterface (Name {namespace = "GLib", name = "DateTime"})
    IO ()

{-# DEPRECATED calendarSelectDay ["(Since version 4.20)","Use [method/@calendar@/.set_date] instead."] #-}
-- | Switches to /@date@/\'s year and month and select its day.
calendarSelectDay ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@.
    -> GLib.DateTime.DateTime
    -- ^ /@date@/: a @GDateTime@ representing the day to select
    -> m ()
calendarSelectDay self date = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    date' <- unsafeManagedPtrGetPtr date
    gtk_calendar_select_day self' date'
    touchManagedPtr self
    touchManagedPtr date
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSelectDayMethodInfo
instance (signature ~ (GLib.DateTime.DateTime -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSelectDayMethodInfo a signature where
    overloadedMethod = calendarSelectDay

instance O.OverloadedMethodInfo CalendarSelectDayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSelectDay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSelectDay"
        })


#endif

-- method Calendar::set_date
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "date"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DateTime" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GDateTime` representing the day to select"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_date" gtk_calendar_set_date :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Ptr GLib.DateTime.DateTime ->           -- date : TInterface (Name {namespace = "GLib", name = "DateTime"})
    IO ()

-- | Switches to /@date@/\'s year and month and selects its day.
-- 
-- /Since: 4.20/
calendarSetDate ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@.
    -> GLib.DateTime.DateTime
    -- ^ /@date@/: a @GDateTime@ representing the day to select
    -> m ()
calendarSetDate self date = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    date' <- unsafeManagedPtrGetPtr date
    gtk_calendar_set_date self' date'
    touchManagedPtr self
    touchManagedPtr date
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetDateMethodInfo
instance (signature ~ (GLib.DateTime.DateTime -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetDateMethodInfo a signature where
    overloadedMethod = calendarSetDate

instance O.OverloadedMethodInfo CalendarSetDateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetDate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetDate"
        })


#endif

-- method Calendar::set_day
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "day"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The desired day for the selected date (as a number between 1 and 31)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_day" gtk_calendar_set_day :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Int32 ->                                -- day : TBasicType TInt
    IO ()

-- | Sets the day for the selected date.
-- 
-- The new date must be valid. For example, setting the day to 31 when the
-- month is February will fail.
-- 
-- /Since: 4.14/
calendarSetDay ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> Int32
    -- ^ /@day@/: The desired day for the selected date (as a number between 1 and 31).
    -> m ()
calendarSetDay self day = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_calendar_set_day self' day
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetDayMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetDayMethodInfo a signature where
    overloadedMethod = calendarSetDay

instance O.OverloadedMethodInfo CalendarSetDayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetDay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetDay"
        })


#endif

-- method Calendar::set_month
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "month"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The desired month for the selected date (as a number between 0 and 11)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_month" gtk_calendar_set_month :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Int32 ->                                -- month : TBasicType TInt
    IO ()

-- | Sets the month for the selected date.
-- 
-- The new date must be valid. For example, setting the month to 1 (February)
-- when the day is 31 will fail.
-- 
-- /Since: 4.14/
calendarSetMonth ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> Int32
    -- ^ /@month@/: The desired month for the selected date (as a number between 0 and 11).
    -> m ()
calendarSetMonth self month = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_calendar_set_month self' month
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetMonthMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetMonthMethodInfo a signature where
    overloadedMethod = calendarSetMonth

instance O.OverloadedMethodInfo CalendarSetMonthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetMonth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetMonth"
        })


#endif

-- method Calendar::set_show_day_names
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "Whether to show day names above the day numbers"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_show_day_names" gtk_calendar_set_show_day_names :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()

-- | Sets whether the calendar shows day names.
calendarSetShowDayNames ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> Bool
    -- ^ /@value@/: Whether to show day names above the day numbers
    -> m ()
calendarSetShowDayNames self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = (P.fromIntegral . P.fromEnum) value
    gtk_calendar_set_show_day_names self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetShowDayNamesMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetShowDayNamesMethodInfo a signature where
    overloadedMethod = calendarSetShowDayNames

instance O.OverloadedMethodInfo CalendarSetShowDayNamesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetShowDayNames",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetShowDayNames"
        })


#endif

-- method Calendar::set_show_heading
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Whether to show the heading in the calendar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_show_heading" gtk_calendar_set_show_heading :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()

-- | Sets whether the calendar should show a heading.
-- 
-- The heading contains the current year and month as well as
-- buttons for changing both.
calendarSetShowHeading ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> Bool
    -- ^ /@value@/: Whether to show the heading in the calendar
    -> m ()
calendarSetShowHeading self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = (P.fromIntegral . P.fromEnum) value
    gtk_calendar_set_show_heading self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetShowHeadingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetShowHeadingMethodInfo a signature where
    overloadedMethod = calendarSetShowHeading

instance O.OverloadedMethodInfo CalendarSetShowHeadingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetShowHeading",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetShowHeading"
        })


#endif

-- method Calendar::set_show_week_numbers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to show week numbers alongside the days"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_show_week_numbers" gtk_calendar_set_show_week_numbers :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()

-- | Sets whether week numbers are shown in the calendar.
calendarSetShowWeekNumbers ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> Bool
    -- ^ /@value@/: whether to show week numbers alongside the days
    -> m ()
calendarSetShowWeekNumbers self value = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let value' = (P.fromIntegral . P.fromEnum) value
    gtk_calendar_set_show_week_numbers self' value'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetShowWeekNumbersMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetShowWeekNumbersMethodInfo a signature where
    overloadedMethod = calendarSetShowWeekNumbers

instance O.OverloadedMethodInfo CalendarSetShowWeekNumbersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetShowWeekNumbers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetShowWeekNumbers"
        })


#endif

-- method Calendar::set_year
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "year"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The desired year for the selected date (within [struct@GLib.DateTime]\n  limits, i.e. from 0001 to 9999)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_set_year" gtk_calendar_set_year :: 
    Ptr Calendar ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Int32 ->                                -- year : TBasicType TInt
    IO ()

-- | Sets the year for the selected date.
-- 
-- The new date must be valid. For example, setting the year to 2023 when the
-- date is February 29 will fail.
-- 
-- /Since: 4.14/
calendarSetYear ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@self@/: a @GtkCalendar@
    -> Int32
    -- ^ /@year@/: The desired year for the selected date (within t'GI.GLib.Structs.DateTime.DateTime'
    --   limits, i.e. from 0001 to 9999).
    -> m ()
calendarSetYear self year = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_calendar_set_year self' year
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarSetYearMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarSetYearMethodInfo a signature where
    overloadedMethod = calendarSetYear

instance O.OverloadedMethodInfo CalendarSetYearMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarSetYear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarSetYear"
        })


#endif

-- method Calendar::unmark_day
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "calendar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Calendar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkCalendar`." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "day"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the day number to unmark between 1 and 31."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_calendar_unmark_day" gtk_calendar_unmark_day :: 
    Ptr Calendar ->                         -- calendar : TInterface (Name {namespace = "Gtk", name = "Calendar"})
    Word32 ->                               -- day : TBasicType TUInt
    IO ()

-- | Removes the visual marker from a particular day.
calendarUnmarkDay ::
    (B.CallStack.HasCallStack, MonadIO m, IsCalendar a) =>
    a
    -- ^ /@calendar@/: a @GtkCalendar@.
    -> Word32
    -- ^ /@day@/: the day number to unmark between 1 and 31.
    -> m ()
calendarUnmarkDay calendar day = liftIO $ do
    calendar' <- unsafeManagedPtrCastPtr calendar
    gtk_calendar_unmark_day calendar' day
    touchManagedPtr calendar
    return ()

#if defined(ENABLE_OVERLOADING)
data CalendarUnmarkDayMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsCalendar a) => O.OverloadedMethod CalendarUnmarkDayMethodInfo a signature where
    overloadedMethod = calendarUnmarkDay

instance O.OverloadedMethodInfo CalendarUnmarkDayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Calendar.calendarUnmarkDay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Calendar.html#v:calendarUnmarkDay"
        })


#endif


