{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Renders a GSK rendernode tree with OpenGL.
-- 
-- See t'GI.Gsk.Objects.Renderer.Renderer'.
-- 
-- /Since: 4.2/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.GLRenderer
    ( 

-- * Exported types
    GLRenderer(..)                          ,
    IsGLRenderer                            ,
    toGLRenderer                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRealized]("GI.Gsk.Objects.Renderer#g:method:isRealized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gsk.Objects.Renderer#g:method:realize"), [realizeForDisplay]("GI.Gsk.Objects.Renderer#g:method:realizeForDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [render]("GI.Gsk.Objects.Renderer#g:method:render"), [renderTexture]("GI.Gsk.Objects.Renderer#g:method:renderTexture"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gsk.Objects.Renderer#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gsk.Objects.Renderer#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveGLRendererMethod                 ,
#endif

-- ** new #method:new#

    gLRendererNew                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#endif

-- | Memory-managed wrapper type.
newtype GLRenderer = GLRenderer (SP.ManagedPtr GLRenderer)
    deriving (Eq)

instance SP.ManagedPtrNewtype GLRenderer where
    toManagedPtr (GLRenderer p) = p

foreign import ccall "gsk_gl_renderer_get_type"
    c_gsk_gl_renderer_get_type :: IO B.Types.GType

instance B.Types.TypedObject GLRenderer where
    glibType = c_gsk_gl_renderer_get_type

instance B.Types.GObject GLRenderer

-- | Type class for types which can be safely cast to t'GLRenderer', for instance with `toGLRenderer`.
class (SP.GObject o, O.IsDescendantOf GLRenderer o) => IsGLRenderer o
instance (SP.GObject o, O.IsDescendantOf GLRenderer o) => IsGLRenderer o

instance O.HasParentTypes GLRenderer
type instance O.ParentTypes GLRenderer = '[Gsk.Renderer.Renderer, GObject.Object.Object]

-- | Cast to t'GLRenderer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGLRenderer :: (MIO.MonadIO m, IsGLRenderer o) => o -> m GLRenderer
toGLRenderer = MIO.liftIO . B.ManagedPtr.unsafeCastTo GLRenderer

-- | Convert t'GLRenderer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GLRenderer) where
    gvalueGType_ = c_gsk_gl_renderer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GLRenderer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GLRenderer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GLRenderer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGLRendererMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGLRendererMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGLRendererMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGLRendererMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGLRendererMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGLRendererMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGLRendererMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGLRendererMethod "isRealized" o = Gsk.Renderer.RendererIsRealizedMethodInfo
    ResolveGLRendererMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGLRendererMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGLRendererMethod "realize" o = Gsk.Renderer.RendererRealizeMethodInfo
    ResolveGLRendererMethod "realizeForDisplay" o = Gsk.Renderer.RendererRealizeForDisplayMethodInfo
    ResolveGLRendererMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGLRendererMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGLRendererMethod "render" o = Gsk.Renderer.RendererRenderMethodInfo
    ResolveGLRendererMethod "renderTexture" o = Gsk.Renderer.RendererRenderTextureMethodInfo
    ResolveGLRendererMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGLRendererMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGLRendererMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGLRendererMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGLRendererMethod "unrealize" o = Gsk.Renderer.RendererUnrealizeMethodInfo
    ResolveGLRendererMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGLRendererMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGLRendererMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGLRendererMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGLRendererMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGLRendererMethod "getSurface" o = Gsk.Renderer.RendererGetSurfaceMethodInfo
    ResolveGLRendererMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGLRendererMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGLRendererMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGLRendererMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGLRendererMethod t GLRenderer, O.OverloadedMethod info GLRenderer p) => OL.IsLabel t (GLRenderer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGLRendererMethod t GLRenderer, O.OverloadedMethod info GLRenderer p, R.HasField t GLRenderer p) => R.HasField t GLRenderer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGLRendererMethod t GLRenderer, O.OverloadedMethodInfo info GLRenderer) => OL.IsLabel t (O.MethodProxy info GLRenderer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GLRenderer
type instance O.AttributeList GLRenderer = GLRendererAttributeList
type GLRendererAttributeList = ('[ '("realized", Gsk.Renderer.RendererRealizedPropertyInfo), '("surface", Gsk.Renderer.RendererSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GLRenderer = GLRendererSignalList
type GLRendererSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GLRenderer::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "GLRenderer" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_gl_renderer_new" gsk_gl_renderer_new :: 
    IO (Ptr GLRenderer)

-- | Creates an instance of the GL renderer.
gLRendererNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GLRenderer
    -- ^ __Returns:__ a GL renderer
gLRendererNew  = liftIO $ do
    result <- gsk_gl_renderer_new
    checkUnexpectedReturnNULL "gLRendererNew" result
    result' <- (wrapObject GLRenderer) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


