/**************************************************************************/
/*  editor_icons.gen.h                                                    */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

/* THIS FILE IS GENERATED. EDITS WILL BE LOST. */

#pragma once

inline constexpr int editor_icons_count = 990;
inline constexpr const char *editor_icons_sources[] = {
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m3.308 15-2-2a1 1 0 0 1 1.414-1.414l.293.293V3.293h8.586L11.308 3a1 1 0 0 1 1.415-1.414l2 2a1 1 0 0 1 0 1.414l-2 2a1 1 0 0 1-1.415-1.414l.293-.293H5.015v6.586l.294-.293A1 1 0 0 1 6.723 13l-2 2a1 1 0 0 1-1.414 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16"><path fill="none" stroke="#8da5f3" stroke-width="2" d="M 8,13 C 5.2385763,13 3,10.761424 3,8 3,5.2385763 5.2385763,3 8,3"/><path fill="none" stroke="#8eef97" stroke-width="2" d="m 8,13 c 2.761424,0 5,-2.238576 5,-5 C 13,5.2385763 10.761424,3 8,3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m3.309 1.291-2 2a1 1 0 0 0 1.414 1.414l.293-.293v8.586h8.586l-.293.293a1 1 0 0 0 1.414 1.414l2-2a1 1 0 0 0 0-1.414l-2-2a1 1 0 0 0-1.414 1.414l.293.293H6.43l5.586-5.586v.416a1 1 0 0 0 2 0v-2.83a1 1 0 0 0-1-1h-2.83a1 1 0 0 0 0 2h.416L5.016 9.584V4.412l.293.293a1 1 0 0 0 1.414-1.414l-2-2a1 1 0 0 0-1.414 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#ee5677" d="M5 1a3 3 0 0 0-2.223 5.012A3 3 0 0 0 3 12h2V7h2V1H5zm6 0v5.174A3 3 0 0 0 10 6V4H8v8h2a3 3 0 0 0 3-3 3 3 0 0 0 0-6V1h-2zM5 3v2a1 1 0 0 1 0-2zm8 2a1 1 0 0 1 0 2zM3 8v2a1 1 0 0 1 0-2zm7 0a1 1 0 0 1 0 2z"/><path fill="#fff" fill-opacity=".235" d="M8 4v8h2a3 3 0 0 0 0-6V4zM3 6a3 3 0 0 0 0 6h2V6zm0 2v2a1 1 0 0 1 0-2zm7 0a1 1 0 0 1 0 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v1h14V3a2 2 0 0 0-2-2zm9 1h1v1h-1zM1 5v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5zm9.475 1.637 1.414 1.414L6.939 13l-2.828-2.828 1.414-1.414 1.415 1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h1V3h9V2a1 1 0 0 0-1-1zm3 3a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h9a1 1 0 0 0 1-1V5a1 1 0 0 0-1-1zm1 2h7v7H6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3.635.51C.67 3.376 4.17 9.439 6.402 9.305l.442.765-.565.979a3 3 0 1 0 .315 3.449L8 11.998l1.406 2.5a3 3 0 1 0 .315-3.45l-.567-.982.442-.765c2.232.134 5.731-5.93 2.767-8.795L8 8zM4 12a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm8 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 3a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1h-3.184a3 3 0 0 0-5.632 0zm6 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM3 5h2v2h6V5h2v8H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m7 1v6h-6v2h6v6h2v-6h6v-2h-6v-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="M2.55 9.942c.61-.92 1.634-1.469 2.739-1.469.363 0 .72.06 1.059.175l2.301-2.302c-.067-.197-.115-.4-.143-.606-.248-1.787.996-3.44 2.777-3.702-.086-.022-.169-.053-.256-.065-.175-1.251-1.329-2.124-2.581-1.95-1.251.173-2.124 1.328-1.95 2.58.047.34.17.665.36.952l-3.301 3.3c-1.052-.699-2.472-.414-3.171.64-.7 1.052-.414 2.47.638 3.17.286.189.611.313.952.361.014.101.044.194.07.289.063-.476.222-.946.506-1.373zM12.208 9.5c-1.386 0-3.138 1.056-3.767 3.092-.027.096-.027.198 0 .296.604 2.145 2.415 3.112 3.767 3.112 1.355 0 3.161-.967 3.771-3.1.029-.098.029-.201 0-.301-.596-2.049-2.387-3.099-3.771-3.099zm0 5.419c-1.195 0-2.164-.974-2.164-2.169s.969-2.167 2.164-2.167c1.198 0 2.168.972 2.168 2.167s-.97 2.169-2.168 2.169z"/><circle cx="12.208" cy="12.75" r="1.081"/><path d="m7.478 13.157c-.077-.276-.077-.566.007-.86.771-2.493 2.959-3.797 4.723-3.797.806 0 1.688.277 2.487.794.36-.173.685-.434.922-.79.699-1.051.414-2.471-.638-3.17-.287-.19-.613-.313-.952-.361-.174-1.251-1.329-2.125-2.581-1.951-1.251.174-2.124 1.329-1.95 2.581.047.34.17.666.36.952l-3.301 3.301c-1.053-.699-2.473-.415-3.172.639-.699 1.052-.414 2.471.639 3.171.285.189.61.313.951.361.174 1.251 1.33 2.124 2.581 1.95.461-.064.87-.264 1.195-.55-.551-.585-1.007-1.332-1.271-2.27z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7 7H5v2h2v3.898a5 5 0 0 1-3.828-3.603l-1.934.518a7 7 0 0 0 13.524 0l-1.938-.52A5 5 0 0 1 9 12.896V9h2V7H9v-.176a3 3 0 1 0-2 0zm1-4a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M11 4h2v2h-2zm0 7h2v2h-2zm-7 0h2v2H4z"/><g fill="none" stroke="#8da5f3" stroke-linecap="round"><path d="M2.5 8v5A1.5 1.5 0 0 0 4 14.5h9a1.5 1.5 0 0 0 1.5-1.5V4A1.5 1.5 0 0 0 13 2.5H8"/><path stroke-width="1.5" d="m2 2 6 6M7 1.75l2 2M1.75 7l2 2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M11 4h2v2h-2zm0 7h2v2h-2zm-7 0h2v2H4z"/><g fill="none" stroke="#fc7f7f" stroke-linecap="round"><path d="M2.5 8v5A1.5 1.5 0 0 0 4 14.5h9a1.5 1.5 0 0 0 1.5-1.5V4A1.5 1.5 0 0 0 13 2.5H8"/><path stroke-width="1.5" d="m2 2 6 6M7 1.75l2 2M1.75 7l2 2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#8da5f3"><path fill-opacity=".4" d="M7 0a2 2 0 0 0-2 2h7a2 2 0 0 1 2 2v6a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z"/><path fill-opacity=".6" d="M5 2a2 2 0 0 0-2 2h7a2 2 0 0 1 2 2v7a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z"/><path d="M3 4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h7a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM2 9a1 1 0 0 1 2 0v1a1 1 0 0 1-2 0zm7 0a1 1 0 0 1 2 0v1a1 1 0 0 1-2 0zm0 3a2.5 2 0 0 1-5 0z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path fill-opacity=".4" d="M7 0a2 2 0 0 0-2 2h7a2 2 0 0 1 2 2v6a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z"/><path fill-opacity=".6" d="M5 2a2 2 0 0 0-2 2h7a2 2 0 0 1 2 2v7a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2z"/><path d="M3 4a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h7a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2zM2 9a1 1 0 0 1 2 0v1a1 1 0 0 1-2 0zm7 0a1 1 0 0 1 2 0v1a1 1 0 0 1-2 0zm0 3a2.5 2 0 0 1-5 0z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v14h1v-2h2v2h8v-2h2v2h1V1h-1v2h-2V1H4v2H2V1zm1 4h2v2H2zm10 0h2v2h-2zM2 9h2v2H2zm10 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12 14a2 2 0 0 0 2 2h1v-2h-.5a.5.5 0 0 1-.5-.5V8a6 6 0 1 0-2 4.465zM8 3a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm3.441 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM4.488 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm.024 4a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6.904 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM8 11a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m15.477 0.99862v14h-2.1017v-14zm-14.954 14.003v-14h2.1017v14zm11.946-6.823-3.5-3v6zm-8.9343 0.023985 3.5 3v-2h2.1464l0.00376-2h-2.1501v-2zm4.6005-7.0028c8.9077 15.09 8.9077 15.09 0 0zm-0.23085 14.003c-8.9077-15.09-8.9077-15.09 0 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m12.469 8.1784-3.5-3v6zm-8.9343 0.023985 3.5 3v-2h2.1464l0.00376-2h-2.1501v-2zm9.4532 0.53338c-10.763 8.9077-10.763 8.9077 0 0zm0 7h-9.9859v-2h9.9859zm-9.9806-8.5564c10.763-8.9077 10.763-8.9077 0 0zm0-7h9.9859v2h-9.9859zm5.4684 2.8277c8.9077 10.763 8.9077 10.763 0 0zm7 0v9.9859h-2v-9.9859zm-7.8862 9.9859c-8.9077-10.763-8.9077-10.763 0 0zm-7 0v-9.9859h2v9.9859z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M14.783 1.55H1.77a.454.454 0 0 0-.318.779l4.615 4.507v7.086a.45.45 0 0 0 .738.354l3.511-2.812a.454.454 0 0 0 .17-.354V6.836L15.1 2.33a.454.454 0 0 0-.317-.779z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M14.5 2a6 6 0 0 0 0 12v-1.01a1 1 0 0 1 0-2v-6a1 1 0 0 1 0-2zM11 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm0 4a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm0-7a6 6 0 0 0 0 12 6 6 0 0 1-2.95-3.133A1 1 0 1 1 7.53 9a6 6 0 0 1 0-2 1 1 0 1 1 .52-1.867A5.795 6.506 0 0 1 11 2zM7.5 2a6 6 0 0 0 0 12 6 6 0 0 1-2.95-3.133A1 1 0 1 1 4.03 9a6 6 0 0 1 0-2 1 1 0 1 1 .52-1.867A5.795 6.506 0 0 1 7.5 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="M1 1v14h1v-2h2v2h8v-2h2v2h1V1h-1v2h-2V1H4v2H2V1zm1 4h2v2H2zm10 0h2v2h-2zM2 9h2v2H2zm10 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#c38ef1" d="M1 1v14h1v-2h2v2h8v-2h2v2h1V1h-1v2h-2V1H4v2H2V1zm1 4h2v2H2zm10 0h2v2h-2zM2 9h2v2H2zm10 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5.05 2v2H14V2zm-3.32-.017v2h2v-2zM8.983 7v2H14V7zm-3.525 5v2h2v-2zm3.525 0v2H14v-2zM5.492 6.932v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 2v2h2v-2zm4 0v2h8v-2zm-4 5v2h2v-2zm4 0v2h8v-2zm-4 5v2h2v-2zm4 0v2h8v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#c38ef1" d="M1 1v14h1v-2h2v2h8v-2h2v2h1V1h-1v2h-2V1H4v2H2V1zm4 3h2v2h4v2H9v2h2v2H8a1 1 0 0 1-1-1V8H6a1 1 0 0 1-1-1zM2 5h2v2H2zm10 0h2v2h-2zM2 9h2v2H2zm10 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M1 1v4h2V3h2V1zm10 0v2h2v2h2V1zM4 4v8h8V4zm2 2h4v4H6zm-5 5v4h4v-2H3v-2zm12 0v2h-2v2h4v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M1 1v4h2V3h2V1zm10 0v2h2v2h2V1zM4 4v8h8V4zm2 2h4v4H6zm-5 5v4h4v-2H3v-2zm12 0v2h-2v2h4v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M4 4a3 3 0 0 0 0 6h2V4zm6 0a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4zm4 0a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4zM4 6v2a1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M3 1a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-2 7v3H8v2h3v3h2v-3h3v-2h-3V8zm-8 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M13 1a2 2 0 1 0 0 4 2 2 0 0 0 0-4zm-2 7v3H8v2h3v3h2v-3h3v-2h-3V8zm-8 3a2 2 0 1 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5v7l4-4m-4 4L4 8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 8H4l4 4M4 8l4-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h7L8 4m4 4-4 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 11V4L4 8m4-4 4 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M5 1a2 2 0 0 0-2 2h2zm2 0v2h2V1zm4 0v2h2a2 2 0 0 0-2-2zM3 5v2h2V5zm8 0v2h2V5zM3 9v2h2V9zm8 0v2h2V9zm-8 4a2 2 0 0 0 2 2v-2zm4 0v2h2v-2zm4 0v2a2 2 0 0 0 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="2"><path d="M8 1v9l4-4m-4 4L4 6"/><path stroke-linecap="round" d="M2 10v4h12v-4"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1 1 3v12l5-2 4 2 5-2V1l-5 2zm0 2 4 2v8l-4-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5 3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h4a3 3 0 0 0 .787-5.894A3 3 0 0 0 7 3zm1 2h1a1 1 0 0 1 0 2H6zm0 4h3a1 1 0 0 1 0 2H6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm8 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zM3 2h2a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 12V4l4 5 4-5v8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7 3a3 3 0 0 0 0 6h2a1 1 0 0 1 0 2H6a1 1 0 0 0 0 2h3a1 1 0 0 0 0-6H7a1 1 0 0 1 0-2h3a1 1 0 0 0 0-2H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#8da5f3" stroke-linejoin="round" stroke-width="2" d="M2 6a4 4 0 0 1 8 0c0 1 0 3-3 4.75 0 3-1.47 3.25-3 3.25H3M13.05 2.5a7 7 0 0 1 0 7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-linejoin="round" stroke-width="2" d="M2 6a4 4 0 0 1 8 0c0 1 0 3-3 4.75 0 3-1.47 3.25-3 3.25H3M13.05 2.5a7 7 0 0 1 0 7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16" version="1.0" viewBox="0 0 2.4 2.4"><path fill="#e0e0e0" d="M 1.2518555 0.15 A 0.1 0.1 0 0 0 1.1701172 0.17988281 L 0.6 0.75 L 0.31787109 0.75 C 0.22487119 0.75 0.15 0.81700008 0.15 0.9 L 0.15 1.5 C 0.15 1.5424221 0.16969512 1.5805593 0.20126953 1.6078125 L 1.35 0.45527344 L 1.35 0.25605469 A 0.106 0.106 0 0 0 1.2518555 0.15 z M 1.35 1.6438477 L 0.97236328 2.0223633 L 1.1701172 2.2201172 C 1.2361171 2.2871171 1.35 2.239996 1.35 2.1459961 L 1.35 1.6438477 z"/><path fill="#e0e0e0" d="M 2.1984375 0.79306641 L 2.0660156 0.92578125 C 2.1142629 1.1320246 2.0935608 1.3239034 2.0487305 1.4882812 C 1.9692536 1.7796963 1.8105469 1.9725586 1.8105469 1.9725586 A 0.0825 0.0825 0 0 0 1.8222656 2.0879883 A 0.0825 0.0825 0 0 0 1.9394531 2.0780273 C 1.9394531 2.0780273 2.1176607 1.8586814 2.2069336 1.5313477 C 2.2638362 1.3227069 2.2834498 1.0648044 2.1984375 0.79306641 z M 1.8539062 1.1384766 L 1.6790039 1.3136719 C 1.6747238 1.3346601 1.6697313 1.3550615 1.6640625 1.3749023 C 1.6131343 1.5531513 1.5117188 1.6719727 1.5117187 1.6719727 A 0.0825 0.0825 0 0 0 1.5213867 1.7871094 A 0.0825 0.0825 0 0 0 1.6368164 1.7791992 C 1.6368164 1.7791992 1.7606941 1.6355198 1.8222656 1.4200195 C 1.8460259 1.3368593 1.8597024 1.2410136 1.8539062 1.1384766 z" color="#000" paint-order="markers stroke fill" style="-inkscape-stroke:none"/><path fill="#fc7f7f" d="M.08295 2.0529 2.0502.07965 2.31705.34725.34965 2.32035ZM-1.2804596 3.0939027 3.0879072-1.2877874Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="m12 2a-1 1 0 0 1 0 2a 8 8 0 0 0-8 8a-1 1 0 0 1-2 0a10 10 0 0 1 10-10zm0 4A-1 1 0 0 1 12 8a 4 4 0 0 0-4 4A-1 1 0 0 1 6 12a6 6 0 0 1 6-6zm0 4A-2 2 0 0 1 12 14A-2 2 0 0 1 12 10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m14 9-3 5-3-12-3 7-3-2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M13 2a1 1 0 0 0-1-1L4.754 3A1 1 0 0 0 4 4v5.55A2.5 2.5 0 1 0 6 12V4.756l5-1.428V6.5l2-1z"/><path fill="none" stroke="url(#a)" stroke-linecap="round" d="M10.5 8v5m2-4v3m-4-2v1m6-1v1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M7 1a2 2 0 0 0-2 2h2v1H5v2h2v1H5a2 2 0 0 0 2 2v4l-2 2h6l-2-2V9a2 2 0 0 0 2-2H9V6h2V4H9V3h2a2 2 0 0 0-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M13 2a1 1 0 0 0-1-1L4.754 3A1 1 0 0 0 4 4v5.55A2.5 2.5 0 1 0 6 12V4.756l5-1.428V6.5l2-1z"/><path fill="none" stroke="url(#a)" stroke-linecap="round" d="M10.5 8v5m2-4v3m-4-2v1m6-1v1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16" version="1.0" viewBox="0 0 2.4 2.4"><path fill="#e0e0e0" d="M1.252.15a.1.1 0 0 0-.082.03L.6.75H.318C.225.75.15.817.15.9v.6c0 .083.075.15.168.15H.6l.57.57c.066.067.18.02.18-.074V.256A.106.106 0 0 0 1.252.15" paint-order="markers stroke fill"/><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width=".165" d="M1.575.675c.45.525 0 1.05 0 1.05m.3-1.35c.675.825 0 1.65 0 1.65" paint-order="markers stroke fill"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16" version="1.0" viewBox="0 0 2.4 2.4"><path fill="#8da5f3" d="M1.252.15a.1.1 0 0 0-.082.03L.6.75H.318C.225.75.15.817.15.9v.6c0 .083.075.15.168.15H.6l.57.57c.066.067.18.02.18-.074V.256A.106.106 0 0 0 1.252.15" paint-order="markers stroke fill"/><path fill="none" stroke="#8da5f3" stroke-linecap="round" stroke-linejoin="round" stroke-width=".165" d="M1.575.675c.45.525 0 1.05 0 1.05m.3-1.35c.675.825 0 1.65 0 1.65" paint-order="markers stroke fill"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16" version="1.0" viewBox="0 0 2.4 2.4"><path fill="#fc7f7f" d="M1.252.15a.1.1 0 0 0-.082.03L.6.75H.318C.225.75.15.817.15.9v.6c0 .083.075.15.168.15H.6l.57.57c.066.067.18.02.18-.074V.256A.106.106 0 0 0 1.252.15" paint-order="markers stroke fill"/><path fill="none" stroke="#fc7f7f" stroke-linecap="round" stroke-linejoin="round" stroke-width=".165" d="M1.575.675c.45.525 0 1.05 0 1.05m.3-1.35c.675.825 0 1.65 0 1.65" paint-order="markers stroke fill"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M13 2a1 1 0 0 0-1-1L4.754 3A1 1 0 0 0 4 4v5.55A2.5 2.5 0 1 0 6 12V4.756l5-1.428V6.5l2-1zm-3 6h2v2h2v2h-2v2h-2v-2H8v-2h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x1="8" x2="8" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M8 1C1 1 1 1 1 8s0 7 7 7 7 0 7-7 0-7-7-7zm3.75 1.25a1 1 0 0 1 0 4 1 1 0 0 1 0-4zM8 6a1 1 0 0 1 0 4 1 1 0 0 1 0-4zM4.25 9.75a1 1 0 0 1 0 4 1 1 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="1" y2="15" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="url(#a)" d="M13 2a1 1 0 0 0-1-1L4.754 3A1 1 0 0 0 4 4v5.55A2.5 2.5 0 1 0 6 12V4.756l5-1.428V6.5l2-1z"/><path fill="none" stroke="url(#a)" stroke-linecap="round" d="M10.5 8v5m2-4v3m-4-2v1m6-1v1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M14 14a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H6a1 1 0 0 0-.781.375l-4 5a1 1 0 0 0 0 1.248l4 5a1 1 0 0 0 .78.377zm-1-2H6.48L3.281 8l3.2-4H13zm-6-2V6L5 8zm1-5h4v1.2H9.4v1.2h2.2v1.2H9.4v1.2H12V11H8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><circle cx="8" cy="5" r="4"/><path d="M11 13a3 3 0 0 0 3 3h1v-2h-1a1 1 0 0 1 0-2h1v-2h-1a3 3 0 0 0-3 3zm-7-3a3 3 0 0 0-3 3v3h2v-3a1 1 0 0 1 1-1h1v-2zm4 6h1v-2H8a1 1 0 0 1-1-1h4a3 3 0 1 0-3 3zm-1-4a1.08 1.08 0 0 1 2 0z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 2a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h8a1 1 0 0 0 .781-.375l4-5a1 1 0 0 0 0-1.248l-4-5A1 1 0 0 0 10 2H2zm1 2h6.52l3.199 4-3.2 4H3zm5 3a2 2 0 0 0-4 0v4h1V9h2v2h1zM5 7a1 1 0 0 1 2 0v1H5zm4-1v4l2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8.232.678.645 15.289h14.71zm-1.29 4.765H9.21l4.203 9.004H10.87l-.777-1.949h-4.11l-.778 1.95H2.738l4.203-9.005zm1.081 2.04-1.492 3.404h3L8.023 7.482z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 2 2 8l4 6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m1 1v11h5v-2h-3v-7h6v-2zm6 3v11h8v-11zm2 2h4v7h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 1v2h12v-2zm-1 3v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-9zm2 1h1v1h-1zm3 0h1v1h-1zm3 0h1v1h-1zm3 0h1v1h-1zm-9 2h10v6h-10zm3 1v1h4v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#76ad7b" d="M5.5 9C4.669 9 4 9.669 4 10.5V12H2v2h12v-2h-2v-1.5c0-.831-.669-1.5-1.5-1.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e1ec41" d="M0 2v8h2a3 3 0 0 0 0-6V2zm10 0v2h2V2zM7 4a2 2 0 0 0 0 4H5v2h2a2 2 0 0 0 0-4h2V4zm7 0a2 2 0 0 0 0 4h-2V6h-2v4h4a2 2 0 0 0 0-4h2V4zM2 6a1 1 0 0 1 1 1 1 1 0 0 1-1 1z"/><path fill="#fff" fill-opacity=".4" d="M10 2v2h2V2zm0 4v4h2V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#87b1d7" stroke-width=".5" d="M1.8 13.5s1.3-6.7 6.6-8c5.1 1 6 8 6 8"/><path stroke="#61b2ff" stroke-width="1.5" d="M2.5 7.7 12.7 4"/><g fill="#e0e0e0"><circle cx="1.8" cy="13.5" r="1.25"/><circle cx="14.2" cy="13.5" r="1.25"/><circle cx="8.25" cy="5.7" r="1.25"/></g><g fill="none" stroke="#e0e0e0" stroke-width=".5"><circle cx="1.75" cy="7.9" r="1"/><circle cx="13.5" cy="3.7" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#87b1d7" stroke-width=".5" d="m1.8 13.5s1.3-5.2 6.6-6.5c5.1 1 6 6.5 6 6.5"/><path fill="none" stroke="#61b3ff" stroke-width="1.5" d="M2.7 8.4 8.4 7.2 10.4 2.7"/><g fill="#e0e0e0"><circle cx="1.8" cy="13.5" r="1.25"/><circle cx="14.2" cy="13.5" r="1.25"/><circle cx="8.25" cy="7.2" r="1.25"/></g><g fill="none" stroke="#e0e0e0" stroke-width=".5"><circle cx="1.75" cy="8.5" r="1"/><circle cx="10.75" cy="1.75" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#87b1d7" stroke-width=".5" d="m1.8 13.5 6.2-9 6.2 9"/><path fill="none" stroke="#61b3ff" stroke-width="1.5" d="M5.3 8.4 7.9 4.6m.2 0l2.6 3.8"/><g fill="#e0e0e0"><circle cx="1.8" cy="13.5" r="1.25"/><circle cx="14.2" cy="13.5" r="1.25"/><circle cx="8" cy="4.5" r="1.25"/></g><g fill="none" stroke="#e0e0e0" stroke-width=".5"><circle cx="4.8" cy="9.1" r="1"/><circle cx="11.2" cy="9.1" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#87b1d7" stroke-width=".5" d="M1.8 13.5c2.2-10 10.2-10 12.4 0"/><path stroke="#61b2ff" stroke-width="1.5" d="M2.7 5.7h10.6"/><g fill="#e0e0e0"><circle cx="1.8" cy="13.5" r="1.25"/><circle cx="14.2" cy="13.5" r="1.25"/><circle cx="8" cy="5.7" r="1.25"/></g><g fill="none" stroke="#e0e0e0" stroke-width=".5"><circle cx="1.8" cy="5.7" r="1"/><circle cx="14.2" cy="5.7" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v2h2v-2zm2 2v2h2v-2zm2 0h2v-2h-2zm2 0v2h2v-2zm2 0h2v-2h-2zm2 0v2h2v-2zm2 0h2v-2h-2zm0 2v2h2v-2zm0 2h-2v2h2zm0 2v2h2v-2zm0 2h-2v2h2zm0 2v2h2v-2zm-2 0h-2v2h2zm-2 0v-2h-2v2zm-2 0h-2v2h2zm-2 0v-2h-2v2zm-2 0h-2v2h2zm0-2v-2h-2v2zm0-2h2v-2h-2zm0-2v-2h-2v2zm2 0h2v-2h-2zm2 0v2h2v-2zm2 0h2v-2h-2zm0 2v2h2v-2zm-2 0h-2v2h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M9 1v2h2.586L8 6.586 3.707 2.293 2.293 3.707 6.586 8l-4.293 4.293 1.414 1.414L8 9.414 11.586 13H9v2h5a1 1 0 0 0 1-1V9h-2v2.586L9.414 8 13 4.414V7h2V2a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.824 8.384a2.466 2.466 0 1 0-1.705 4.496 2.466 2.466 0 1 0 4.496-1.705l3.56-3.56a2.466 2.466 0 1 0 1.705-4.496 2.466 2.466 0 1 0-4.496 1.705z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M4.824 8.384a2.466 2.466 0 1 0-1.705 4.496 2.466 2.466 0 1 0 4.496-1.705l3.56-3.56a2.466 2.466 0 1 0 1.705-4.496 2.466 2.466 0 1 0-4.496 1.705z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16"><path fill="#FC7F7F" d="M9.264,8.125L8.119,9.27c-0.219,0.228-0.212,0.589,0.014,0.81c0.222,0.213,0.574,0.213,0.794,0l0.169-0.168	v4.912h4.909l-0.167,0.165c-0.219,0.229-0.212,0.591,0.015,0.81c0.222,0.214,0.573,0.214,0.794,0l1.145-1.145	c0.224-0.224,0.224-0.584,0-0.809l-1.145-1.143c-0.226-0.221-0.588-0.215-0.809,0.014c-0.213,0.221-0.213,0.573,0,0.795l0.167,0.168	h-2.957l3.195-3.196v0.237c0,0.317,0.256,0.573,0.572,0.573c0.315,0,0.571-0.256,0.571-0.573V9.102c0-0.315-0.256-0.571-0.571-0.571	h-1.619c-0.316,0-0.572,0.256-0.572,0.571c0,0.316,0.256,0.572,0.572,0.572h0.237l-3.194,3.194V9.911l0.167,0.168	c0.228,0.218,0.59,0.213,0.81-0.015c0.214-0.223,0.214-0.572,0-0.795l-1.144-1.145C9.848,7.903,9.486,7.903,9.264,8.125L9.264,8.125	z"/><path fill="#FC7F7F" d="M7.615,11.175l0.326-0.326c-0.119-0.06-0.23-0.135-0.328-0.229c-0.524-0.511-0.538-1.349-0.035-1.871	l1.155-1.155c0.5-0.499,1.367-0.497,1.865-0.003l0.3,0.3l0.276-0.276c0.399,0.266,0.849,0.393,1.296,0.405	c0.211-0.142,0.453-0.24,0.726-0.24h0.399c0.391-0.186,0.741-0.467,0.998-0.854c0.754-1.134,0.446-2.665-0.688-3.419	c-0.309-0.205-0.66-0.338-1.026-0.389c-0.188-1.349-1.433-2.291-2.782-2.103c-1.349,0.188-2.29,1.433-2.103,2.782	c0.051,0.367,0.184,0.717,0.389,1.026l-3.56,3.56C3.69,7.63,2.159,7.938,1.405,9.072c-0.754,1.134-0.446,2.664,0.688,3.419	c0.308,0.204,0.659,0.338,1.026,0.389c0.188,1.349,1.433,2.29,2.782,2.103c1.349-0.188,2.291-1.433,2.103-2.781	C7.953,11.834,7.82,11.483,7.615,11.175z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#b56d6d"><path d="M2.55 9.942c.61-.92 1.634-1.469 2.739-1.469.363 0 .72.06 1.059.175l2.301-2.302c-.067-.197-.115-.4-.143-.606-.248-1.787.996-3.44 2.777-3.702-.086-.022-.169-.053-.256-.065-.175-1.251-1.329-2.124-2.581-1.95-1.251.173-2.124 1.328-1.95 2.58.047.34.17.665.36.952l-3.301 3.3c-1.052-.699-2.472-.414-3.171.64-.7 1.052-.414 2.47.638 3.17.286.189.611.313.952.361.014.101.044.194.07.289.063-.476.222-.946.506-1.373zM11.87 10.784c.308-.043.62.01.896.153l.927-.927c.357-.359.938-.359 1.298 0 .358.357.358.938 0 1.298l-1.483 1.482c-.271.308-.74.337-1.047.065-.023-.021-.045-.042-.065-.065-.147-.142-.382-.138-.524.009-.139.144-.139.372 0 .516.561.597 1.5.627 2.097.064.021-.021.043-.042.064-.064l1.483-1.482c.647-.648.647-1.699 0-2.347-.648-.648-1.699-.648-2.347 0z"/><path d="m13.077 14.216c-.307.044-.62-.01-.895-.154l-.928.927c-.358.36-.938.36-1.299 0-.357-.357-.357-.938 0-1.297l1.484-1.483c.271-.307.739-.337 1.048-.065.021.021.044.042.064.065.147.143.382.139.524-.009.139-.144.139-.371 0-.516-.561-.597-1.499-.625-2.097-.063-.023.02-.043.042-.064.063l-1.483 1.483c-.647.648-.647 1.698 0 2.346.648.649 1.699.649 2.347 0z"/><path d="m8.482 12.71c.088-.116.188-.224.296-.32l3.611-3.611c.836-.932 2.246-1.028 3.21-.253.006-.008.013-.014.018-.021.699-1.051.414-2.471-.638-3.17-.287-.19-.613-.313-.952-.361-.174-1.251-1.329-2.125-2.581-1.951-1.251.174-2.124 1.329-1.95 2.581.047.34.17.666.36.952l-3.301 3.3c-1.053-.699-2.473-.415-3.172.639-.699 1.052-.414 2.471.639 3.171.285.189.61.313.951.361.174 1.251 1.33 2.124 2.581 1.95.361-.05.685-.189.967-.381-.659-.822-.707-2.011-.039-2.886z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256"><path fill="#3f3f3f" d="M0 0h256v256H0V0Z"/><path fill="#b2b2b2" d="M128 134.04c1.75 8.75 2.911 16.725 3.5 28.5.5 10 1 12.75.5 16.5-1.846 13.843 1.692 45.975 2.166 51.667.5 6-1.913 6.06-2.666 11.583-.612 4.49 19.75 4.61 16.25-2.25-6.25-12.25-.5-21 1-55.25.13-2.98-2.242-11.968-.5-23.5 2.771-18.353 2.105-26.81 1.625-36.415-.311-7.993-.25-14.241-2.25-34.741-.244-2.5 1.479-19.817 2.988-19.772 10.5.313 24.329-1.252 29.537-3.67 7.225.933 24.452-3.012 31.971-4.031 3.636 2.351 4.169.833 9.379 2.254 1.375.375 4.334-.36 3-1.25-1.852-1.234-5.187-2.062-5.75-3 2.688-.625 5.591-2.394 9-3.291 2.375-.625 4.717-2.937 3.875-3.084-2.875-.5-6.507 1.137-9.375 1.625-3.931.67-6.309.81-8.333 1.292-.307.073-.776.19-1.448.24l-.013.109c-9.205.248-20.081-2.431-32.578-1.392-8.506-.982-23.545-1.29-28.378-1.374-3.478-.06-14.823-.645-17.938-.125-.167-1.02-.375-2.437.238-4.117 3.72-1.811 4.797-4.449 6.825-8.673.23 1.106 1.563 1.232 3.115-3.558 1.415-4.37.58-5.563-.579-5.631.043-.514.07-1.026.079-1.536.196-12.01-1.74-20.61-15.24-20.61s-15.437 8.6-15.24 20.61c.009.51.036 1.022.078 1.536-1.159.068-1.993 1.262-.578 5.631 1.552 4.79 2.884 4.664 3.115 3.558 2.028 4.224 3.105 6.862 6.825 8.673.612 1.68.404 3.097.237 4.117-3.114-.52-14.459.066-17.937.126-4.833.083-19.872.392-28.378 1.373-12.497-1.039-23.373 1.64-32.578 1.392a24.54 24.54 0 0 0-.013-.11c-.672-.048-1.141-.166-1.448-.239-2.024-.482-4.402-.622-8.333-1.291-2.868-.489-6.5-2.125-9.375-1.625-.842.146 1.5 2.458 3.875 3.083 3.408.897 6.312 2.666 9 3.291-.563.938-3.898 1.766-5.75 3-1.334.89 1.625 1.625 3 1.25 5.21-1.42 5.743.097 9.378-2.254 7.52 1.02 24.747 4.964 31.972 4.031 5.208 2.418 19.036 3.983 29.536 3.67 1.51-.045 3.233 17.272 2.989 19.772-2 20.5-1.939 26.748-2.25 34.741-.48 9.605-1.147 18.062 1.625 36.416 1.742 11.531-.63 20.519-.5 23.5 1.5 34.25 7.25 43 1 55.25-3.5 6.859 16.862 6.739 16.25 2.25-.753-5.523-3.167-5.584-2.667-11.584.474-5.692 4.013-37.824 2.167-51.666-.5-3.75 0-6.5.5-16.5.589-11.776 1.75-19.751 3.5-28.501Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256"><path fill="#3f3f3f" d="M0 0h256v256H0V0Z"/><path fill="#b2b2b2" d="M197.026 138.242c4.499-14.473 7.974-31.142 7.719-49.518-.94-67.6-62.462-62.87-73.892-61.237C40.886 40.34 76.091 140.577 75.74 151.594c-1.225 38.374 20.921 42.748 40.416 53.888.661.378 1.815.447 3.328.278 1.806 6.295 2.941 14.759 2.387 18.909-.816 6.124 52.255 6.124 52.255 0 0-15.72 3.059-31.09 8.457-47.222 1.786-.571 4.014-1.9 6.491-4.237 3.42-3.227 8.71-5.444 11.431-15.787 3.904-14.834.968-19.018-3.479-19.181Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256"><path fill="#3f3f3f" d="M0 0h256v256H0V0Z"/><path fill="#b2b2b2" d="M175.976 196.525c1.762-16.733 7.034-38.341 4.633-65.048-.286-3.178-1.125-12.071-1.115-20.683.006-5.294-.528-12.127-.494-16.044.042-4.833-.107-10.396-.156-13.939-.263-18.86-3.307-21.456-7.704-21.456-4.311 0-6.692 3.566-6.765 21.145-.015 3.605.125 12.75.125 14.625 0 4.377-.083 8.542 0 13.375.112 6.489-1.07 17-2.25 17-.976 0-2.025-9.825-2.394-19.25-.189-4.831-.805-14.584-.65-17.525.44-8.353.119-14.729.384-22.541.796-23.402-3.254-27.933-8.673-27.933-5.494 0-8.995 14.422-8.713 28.556.032 1.599-.291 12.685.047 22.465.189 5.453-.267 12.407-.42 17.418-.274 8.942-1.439 15.974-2.218 15.974-.66 0-1.033-8.146-1.364-16.427-.214-5.389-1.117-14.62-.916-20.904.472-14.753-.284-27.556-.265-30.375.158-23.739-3.665-30.775-9.013-30.775-5.369 0-9.297 7.548-9.15 30.835.016 2.633-.655 24.982-.44 30.454.216 5.498-.693 16.266-.879 21.205-.325 8.63-1.623 15.987-2.281 15.987-.821 0-2.699-6.41-2.931-15.242-.147-5.568.307-12.747.156-17.672-.315-10.176-.794-16.157-.97-24.927-.486-24.295-4.088-26.572-9.535-26.572-4.49 0-8.113 7.168-8.164 28.758-.017 6.925-.608 15.656-.079 23.582.201 3.02-.156 10.628-.469 18.473-.2 5.002-.275 11.876-.284 15.944-.042 19.649-6.678 33.356-9.139 32.827-7.583-1.63-12.912-10.979-17.805-29.327-2.637-9.891-9.166-17.787-17.474-19.453-6.475-1.298-4.946 11.54-.33 31.323 2.162 9.267 6.977 21.557 9.891 30.664 7.913 24.729 31.394 47.141 40.226 57.137 4.286 4.85 59.223 4.85 66.147 0 2.882-2.018 10.772-25.39 11.431-31.654Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="256" height="256"><path fill="#3f3f3f" d="M0 0h256v256H0V0Z"/><path fill="#b2b2b2" d="M80.023 196.525c-1.761-16.733-7.033-38.341-4.632-65.048.286-3.178 1.125-12.071 1.115-20.683-.006-5.294.528-12.127.494-16.044-.042-4.833.107-10.396.156-13.939.263-18.86 3.306-21.456 7.703-21.456 4.312 0 6.693 3.566 6.766 21.145.015 3.605-.125 12.75-.125 14.625 0 4.377.083 8.542 0 13.375-.112 6.489 1.07 17 2.25 17 .975 0 2.025-9.825 2.394-19.25.189-4.831.804-14.584.65-17.525-.44-8.353-.119-14.729-.385-22.541-.795-23.402 3.254-27.933 8.674-27.933 5.493 0 8.995 14.422 8.712 28.556-.032 1.599.292 12.685-.047 22.465-.188 5.453.268 12.407.421 17.418.274 8.942 1.439 15.974 2.217 15.974.661 0 1.034-8.146 1.364-16.427.215-5.389 1.117-14.62.916-20.904-.471-14.753.285-27.556.266-30.375-.159-23.739 3.665-30.775 9.013-30.775 5.369 0 9.297 7.548 9.15 30.835-.017 2.633.655 24.982.44 30.454-.216 5.498.693 16.266.879 21.205.325 8.63 1.623 15.987 2.281 15.987.82 0 2.699-6.41 2.931-15.242.147-5.568-.308-12.747-.156-17.672.314-10.176.794-16.157.969-24.927.487-24.295 4.088-26.572 9.536-26.572 4.489 0 8.113 7.168 8.164 28.758.016 6.925.607 15.656.079 23.582-.202 3.02.155 10.628.468 18.473.2 5.002.276 11.876.285 15.944.042 19.649 6.678 33.356 9.139 32.827 7.583-1.63 12.912-10.979 17.804-29.327 2.638-9.891 9.167-17.787 17.475-19.453 6.475-1.298 4.946 11.54.33 31.323-2.162 9.267-6.977 21.557-9.892 30.664-7.913 24.729-31.393 47.141-40.225 57.137-4.287 4.85-59.224 4.85-66.148 0-2.88-2.018-10.771-25.39-11.43-31.654Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="5" fill-opacity=".294"/><circle cx="6" cy="6" r="4" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="3" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="5" fill-opacity=".294"/><g fill="#fff"><circle cx="6" cy="6" r="4"/><path d="M7 0h5v5h-1V1H7zm5 7v5H7v-1h4V7zm-7 5H0V7h1v4h4zM0 5V0h5v1H1v4z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v2H3zm0 4h10v2H3zm0 4h10v2H3z" transform="rotate(45 4.241 9.083)scale(.737)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="m8 2 6 3v6l-6 3-6-3V5zm0 12V8l6-3M8 8 2 5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="m8 .889-.506.254A4.5 4.5 0 1 1 1 7.314v4.297l7 3.5 7-3.5V4.39z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#2998ff" d="m8 1-7 3v8l7 3 7-3v-8z"/><path fill="#5fb2ff" d="m8 15-7-3v-8l7 3z"/><path fill="#a2d2ff" d="m1 4 7 3 7-3-7-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5.308" fill="#e0e0e0"/><circle cx="8" cy="8" r="3.033" fill="#fefefe"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8.693 2.51a.754.754 0 0 0-1.067 0l-.8.8 1.538 1.54a1.132 1.132 0 1 1-1.066 1.066l-1.54-1.54-.8.8-1.6-1.6A.754.754 0 0 1 4.425 2.51l3.273 3.273a.754.754 0 1 0 .533-.533L4.958 1.977A1.509 1.509 0 0 0 2.824 4.11l1.6 1.6-3.2 3.201a.754.754 0 0 0 0 1.067l4.268 4.268a.754.754 0 0 0 1.067 0l6.935-6.935zm4.801 5.869c-1.51 2.263-1.51 2.263-1.51 3.018 0 .754.756 1.509 1.51 1.509s1.51-.755 1.51-1.51c0-.754 0-.754-1.51-3.017z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="128"><linearGradient id="a" x1="8" x2="8" y1="2" y2="126" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff5f5f"/><stop offset=".5" stop-color="#e1da5b"/><stop offset="1" stop-color="#5fff97"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-width="2" d="M3 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 5H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="128"><linearGradient id="a" x1="8" x2="8" y1="2" y2="126" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#62aeff"/><stop offset=".5" stop-color="#75d1e6"/><stop offset="1" stop-color="#84ffee"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-width="2" d="M3 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 5H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10m0 3H3m0 3h10" opacity=".7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M7 1v3.133l-1.445-.965-1.11 1.664 3 2a1 1 0 0 0 1.11 0l3-2-1.11-1.664L9 4.133V1zM5.5 9A1.5 1.5 0 0 0 4 10.5V12H2v2h12v-2h-2v-1.5A1.5 1.5 0 0 0 10.5 9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 1h2a1 1 0 0 1 0 2H5a1 1 0 0 1 0-2zm6 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM6 6a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm5 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm0 4a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm-7 2h1v2H4zm2 0h1v2H6zm2 0h1v2H8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M4.586.5a.764.764 0 0 0-.764.764v.6h-1.2a.764.764 0 0 0-.764.764v1.2h-.6a.764.764 0 0 0-.764.764v.4a.764.764 0 0 0 .764.764h.6v4.5h-.6a.764.764 0 0 0-.764.764v.4a.764.764 0 0 0 .764.764h.6v1.2a.764.764 0 0 0 .764.764h1.2v.6a.764.764 0 0 0 .764.764h.4a.764.764 0 0 0 .764-.764v-.6h4.5v.6a.764.764 0 0 0 .764.764h.4a.764.764 0 0 0 .764-.764v-.6h1.2a.764.764 0 0 0 .764-.764v-1.2h.6a.764.764 0 0 0 .764-.764v-.4a.764.764 0 0 0-.764-.764h-.6v-4.5h.6a.764.764 0 0 0 .764-.764v-.4a.764.764 0 0 0-.764-.764h-.6v-1.2a.764.764 0 0 0-.764-.763h-1.2v-.6a.764.764 0 0 0-.764-.764h-.4a.764.764 0 0 0-.764.764v.6h-4.5v-.6a.764.764 0 0 0-.764-.764zm6.575 5.3a2.186 2.186 0 0 1-.3 4.349h-5.83a2.186 2.186 0 0 1-.3-4.349 3.28 3.644 0 0 1 6.434 0zM5.084 11a.729.729 0 0 1 0 1.459.729.729 0 0 1 0-1.459zm5.83 0a.729.729 0 0 1 0 1.459.729.729 0 0 1 0-1.459zM8 11.729a.729.729 0 0 1 0 1.459.729.729 0 0 1 0-1.46z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4.586.5a.764.764 0 0 0-.764.764v.6h-1.2a.764.764 0 0 0-.764.764v1.2h-.6a.764.764 0 0 0-.764.764v.4a.764.764 0 0 0 .764.764h.6v4.5h-.6a.764.764 0 0 0-.764.764v.4a.764.764 0 0 0 .764.764h.6v1.2a.764.764 0 0 0 .764.764h1.2v.6a.764.764 0 0 0 .764.764h.4a.764.764 0 0 0 .764-.764v-.6h4.5v.6a.764.764 0 0 0 .764.764h.4a.764.764 0 0 0 .764-.764v-.6h1.2a.764.764 0 0 0 .764-.764v-1.2h.6a.764.764 0 0 0 .764-.764v-.4a.764.764 0 0 0-.764-.764h-.6v-4.5h.6a.764.764 0 0 0 .764-.764v-.4a.764.764 0 0 0-.764-.764h-.6v-1.2a.764.764 0 0 0-.764-.763h-1.2v-.6a.764.764 0 0 0-.764-.764h-.4a.764.764 0 0 0-.764.764v.6h-4.5v-.6a.764.764 0 0 0-.764-.764zm6.575 5.3a2.186 2.186 0 0 1-.3 4.349h-5.83a2.186 2.186 0 0 1-.3-4.349 3.28 3.644 0 0 1 6.434 0zM5.084 11a.729.729 0 0 1 0 1.459.729.729 0 0 1 0-1.459zm5.83 0a.729.729 0 0 1 0 1.459.729.729 0 0 1 0-1.459zM8 11.729a.729.729 0 0 1 0 1.459.729.729 0 0 1 0-1.46z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m12 1c-2 2-4 4-7 4h-4v5h4c3 0 5 2 7 4zm1 4v5c2.59-.016 2.59-4.985 0-5zm-11 6v4h2l1-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16"><path fill="#e0e0e0" d="M9 2a3 3 0 0 0-3 2.777 3 3 0 1 0-3 5.047V12a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-1l3 2V7l-3 2V7.23A3 3 0 0 0 9 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M9 2a3 3 0 0 0-3 2.777 3 3 0 1 0-3 5.047V12a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-1l3 2V7l-3 2V7.23A3 3 0 0 0 9 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M9 2a3 3 0 0 0-3 2.777 3 3 0 1 0-3 5.047V12a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-1l3 2V7l-3 2V7.23A3 3 0 0 0 9 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M6 2a3 3 0 0 0-2 5.23V9L1 7v6l3-2v1a1 1 0 0 0 1 1h3a2 2 0 0 1 .73-1.24 1.83 1.83 0 0 1 1.828-3.143 1.8 1.8 0 0 1 3.313-.75 3 3 0 0 0-4.883-3.09A3 3 0 0 0 6 2zm6.36 6.598a.533 3.2 0 0 0-.51 2.275 3.2.533 30 0 0-.515.887.533 3.2 60 0 0 .515.887.533 3.2 0 0 0 1.02 0 3.2.533 30 0 0 .515-.887.533 3.2 60 0 0-.515-.887.533 3.2 0 0 0-.51-2.275z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 2a3 3 0 0 0-2 5.23V9L1 7v6l3-2v1a1 1 0 0 0 1 1h3a2 2 0 0 1 .73-1.24 1.83 1.83 0 0 1 1.828-3.143 1.8 1.8 0 0 1 3.313-.75 3 3 0 0 0-4.883-3.09A3 3 0 0 0 6 2z"/><path fill="#5fb2ff" d="M12.36 8.598a.533 3.2 0 0 0-.51 2.275 3.2.533 30 0 0-.515.887.533 3.2 60 0 0 .515.887.533 3.2 0 0 0 1.02 0 3.2.533 30 0 0 .515-.887.533 3.2 60 0 0-.515-.887.533 3.2 0 0 0-.51-2.275z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 2a3 3 0 0 0-2 5.23V9L1 7v6l3-2v1a1 1 0 0 0 1 1h3a2 2 0 0 1 .73-1.24 1.83 1.83 0 0 1 1.828-3.143 1.8 1.8 0 0 1 3.313-.75 3 3 0 0 0-4.883-3.09A3 3 0 0 0 6 2z"/><path fill="#ffca5f" d="M12.36 8.598a.533 3.2 0 0 0-.51 2.275 3.2.533 30 0 0-.515.887.533 3.2 60 0 0 .515.887.533 3.2 0 0 0 1.02 0 3.2.533 30 0 0 .515-.887.533 3.2 60 0 0-.515-.887.533 3.2 0 0 0-.51-2.275z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3zm4 1-.75 1H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H9.75L9 4zm1 2a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" fill-opacity=".6" d="M7 1v6H1v8h8V9h6V1zm2 2h4v4H9z"/><path fill="#8da5f3" d="M1 1v2h2V1H1zm12 0v2h2V1h-2zM1 13v2h2v-2H1zm12 0v2h2v-2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M2.92 10c-.263.3-.42.73-.42 1.238 0 1.628-3.138-.178-.337 2.67.884.9 2.654.67 3.538-.228a2.33 2.33 0 0 0 0-3.256c-1.1-1.119-2.2-1.084-2.78-.424zm2.3-1.64 2.4 2.4 6.8-6.8a1.7 1.7 0 0 0-2.4-2.45z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><circle cx="8" cy="8" r="7" fill="url(#a)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v6h1V3a1 1 0 0 1 1-1h6V1zm-.08 9c-.263.3-.42.73-.42 1.238 0 1.628-3.138-.178-.337 2.67.884.9 2.654.67 3.538-.228a2.33 2.33 0 0 0 0-3.256c-1.1-1.119-2.2-1.084-2.78-.424zm2.381-1.61 2.4 2.441 6.802-6.917a1.7 1.7 0 0 0-2.4-2.442zm8.7-1.39v6a1 1 0 0 1-1 1H7v1h6a2 2 0 0 0 2-2V7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M1 1v14h14V1zm2 2h10v10H3z"/><path fill="#45d7ff" d="M12 12H7.2L12 7.2z"/><path fill="#ff4545" d="M4 4h4.8L4 8.8z"/><path fill="#80ff45" d="M4 12V8.8L8.8 4H12v3.2L7.2 12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v8.5c1.5.5 1-1 2-1V3h10v2.2a2.415 2.415 0 0 1 2 .5V2a1 1 0 0 0-1-1zm1.36 10.18c-.283.169-.516.466-.645.865-.416 1.277-2.417-.94-.946 2.009.465.931 1.912 1.202 2.835.723a1.922 1.922 0 0 0 .83-2.555c-.578-1.158-1.45-1.411-2.074-1.041zm2.222-.7 1.272 2.495 7.069-3.602a1.415 1.415 0 0 0-1.259-2.534zM9 5v1H8v1H6v1H5v1H4v1h.25L11 6.527V6h-1V5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="M4 6a4 4 0 0 1 8 0v4a4 4 0 0 1-8 0zm0 1.25a2.5 1 0 0 0 8 0m-4-5v12"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-width="2" d="M4 6v4a4 4 0 0 0 8 0V6a4 4 0 0 0-8 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" d="M3 6v4a5 5 0 0 0 10 0V6A5 5 0 0 0 3 6z"/><circle cx="6.5" cy="4.5" r="1.5" fill="#a2d2ff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m3 1c-1.1046 0-2 .89543-2 2v10c0 1.1046.89543 2 2 2h10c1.1046 0 2-.89543 2-2v-10c0-1.1046-.89543-2-2-2zm0 2h10v10h-10zm3 1 2 2 2-2zm-2 2v4l2-2zm8 0-2 2 2 2zm-4 4-2 2h4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="4" height="4" x="6" y="6" fill="#e0e0e0" rx="1"/><path fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="1.5" d="M1.5 5.5 4 8l-2.5 2.5m13 0L12 8l2.5-2.5m-4-4L8 4 5.5 1.5m0 13L8 12l2.5 2.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M6.492 1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h1v.99a1 1 0 0 0-.316.062l-2.051.684-.684-2.051a1 1 0 0 0-1.898.631l1 3a1 1 0 0 0 1.265.633l1.684-.56v.61c0 .041.019.076.024.116l-4.579 3.052a1 1 0 1 0 1.11 1.664l5.056-3.37 1.495 2.986a1 1 0 0 0 1.21.502l3-1a1 1 0 1 0-.632-1.897l-2.178.725-.975-1.951a.981.981 0 0 0 .469-.827V9h1.383l.722 1.448a1 1 0 1 0 1.79-.895l-1-2A1 1 0 0 0 12.492 7h-3V6h1a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm0 2h1v2h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M6.492 1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h1v.99a1 1 0 0 0-.316.062l-2.051.684-.684-2.051a1 1 0 0 0-1.898.631l1 3a1 1 0 0 0 1.265.633l1.684-.56v.61c0 .041.019.076.024.116l-4.579 3.052a1 1 0 1 0 1.11 1.664l5.056-3.37 1.495 2.986a1 1 0 0 0 1.21.502l3-1a1 1 0 1 0-.632-1.897l-2.178.725-.975-1.951a.981.981 0 0 0 .469-.827V9h1.383l.722 1.448a1 1 0 1 0 1.79-.895l-1-2A1 1 0 0 0 12.492 7h-3V6h1a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm0 2h1v2h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 2a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2-2V8l-2 2v3H3V4h7l2-2zm9.363 2.05L7.414 9 6 7.586 4.586 9l2.828 2.828 6.363-6.363z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m5 4a4 4 0 0 0 -4 4 4 4 0 0 0 4 4h6a4 4 0 0 0 4-4 4 4 0 0 0 -4-4zm0 2h2.541a4 4 0 0 0 -.54102 2 4 4 0 0 0 .54102 2h-2.541a2 2 0 0 1 -2-2 2 2 0 0 1 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><g fill="#fff"><path fill-opacity=".2" d="M0 0h64v64H0z"/><path fill-opacity=".4" d="M0 0v16h16V0zm16 16v16h16V16zm16 0h16V0H32zm16 0v16h16V16zm0 16H32v16h16zm0 16v16h16V48zm-16 0H16v16h16zm-16 0V32H0v16z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="6" fill="none" stroke="#5fb2ff" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m6 1v1h-5v1h2v10h6v1h6v-3h-6v1h-5v-4h5v1h6v-3h-6v1h-5v-4h2v1h6v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m8 1a1 1 0 0 0 -1 1v5h-2c-1.108 0-2 .892-2 2v1h10v-1c0-1.108-.892-2-2-2h-2v-5a1 1 0 0 0 -1-1zm-5 10v4l10-1v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-width="2" d="m3 3 10 10M3 13 13 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3zm2 1L4 5l1 1-1 1 1 1 2-2zm2 3v1h2V7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m3 5 3 3 3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m4 9 3-3-3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a"><stop offset=".25" stop-color="#ffe345"/><stop offset=".75" stop-color="#919191"/></linearGradient><path fill="#45d7ff" d="m5.914 4-2 2H9.01V4z"/><path fill="#ff4596" d="M11 4v2h4V4Z"/><path fill="#ff4545" d="M1 8v2h3V8z"/><path fill="url(#a)" d="M6 8v2h7V8z"/><path fill="#919191" d="M1 12v2h5v-2zm7 0v2h6v-2z"/><path fill="#e0e0e0" d="M2 1 1 2l1.5 1.5L1 5l1 1 2.5-2.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="#fff" d="M10 3a1 1 0 0 0-1-1H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1zM3 5.75a1 1 0 0 1 1.414-1.414L6 5.922l1.586-1.586A1 1 0 0 1 9 5.75L6.707 8.043a1 1 0 0 1-1.414 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="#fff" d="M3 2a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1zm2.75 7a1 1 0 0 1-1.414-1.414L5.922 6 4.336 4.414A1 1 0 0 1 5.75 3l2.293 2.293a1 1 0 0 1 0 1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m3 8 5 4 5-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m8 9.669-3.536 2.583H7v2.537h2v-2.537h2.536zm0-3.314L4.464 3.772H7V1.235h2v2.537h2.536zm-7.296.73h14.591v1.831H.704z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#7582a8" d="M4 4v8h8V4zm2 2h4v4H6zM3 1a2 2 0 0 0 -2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0 -2-2H3zm0 1h10a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1H3a1 1 0 0 1 -1-1V3a1 1 0 0 1 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#b56d6d" d="M4 4v8h8V4zm2 2h4v4H6zM3 1a2 2 0 0 0 -2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0 -2-2H3zm0 1h10a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1H3a1 1 0 0 1 -1-1V3a1 1 0 0 1 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#8da5f3" stroke-linejoin="round" stroke-width="2" d="M14 14H2V2h12L8 8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-linejoin="round" stroke-width="2" d="m8 2 6 3.5v5L8 14l-6-3.5v-5h6zm6 3.5L8 9 2 5.5M8 9v5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#8da5f3" stroke-linejoin="round" stroke-width="2" d="M14 14H2V2h12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-width="2" d="m8 2 6 3v6l-6 3-6-3V5zm0 12V8l6-3M8 8 2 5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#ff5f5f" d="M4 4a3 3 0 0 0 0 6h1V8H4a1 1 0 0 1 0-2h1V4z"/><path fill="#5fff97" d="M6 2v5a3 3 0 0 0 3 3h1V8H9a1 1 0 0 1-1-1V2z"/><path fill="#5fb2ff" d="M14 4a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m8 1c-1.108 0-2 .892-2 2v2h-1v2h1v5a2 2 0 0 0 1 1.7285v1.2715h2v-1.2695a2 2 0 0 0 1-1.7305v-5h1v-2h-1v-2c0-1.108-.892-2-2-2zm-1 6h2v5a1 1 0 0 1 -1 1 1 1 0 0 1 -1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M6 5H5v2h1v5a2 2 0 0 0 1 1.728V15h2v-1.27A2 2 0 0 0 10 12V7h1V5h-1V3a1 1 0 0 0-4 0zm1 2h2v5a1 1 0 0 1-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="20"><path fill="#e0e0e0" d="M2 16h12l-6-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M11 5h-1v2h1v5a2 2 0 0 0 1 1.728V15h2v-1.27A2 2 0 0 0 15 12V7h1V5h-1V3a1 1 0 0 0-4 0zm1 2h2v5a1 1 0 0 1-2 0zM4 2v3.133l-1.445-.965-1.11 1.664 3 2a1 1 0 0 0 1.11 0l3-2-1.11-1.664L6 5.133V2zm-.5 8A1.5 1.5 0 0 0 2 11.5V13H1v2h8v-2H8v-1.5A1.5 1.5 0 0 0 6.5 10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M1 1v14h14V1zm2 2h10v10H3z"/><path fill="#45d7ff" d="M12 12H7.2L12 7.2z"/><path fill="#ff4545" d="M4 4h4.8L4 8.8z"/><path fill="#80ff45" d="M4 12V8.8L8.8 4H12v3.2L7.2 12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="24"><linearGradient id="a" x1="8" x2="8" y1="24" y2="0" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#288027"/><stop offset=".75" stop-color="#dbee15"/><stop offset=".75" stop-color="#eec315"/><stop offset="1" stop-color="#f70000"/></linearGradient><path fill="url(#a)" d="M0 0h16v24H0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 2v2h14V2zm7 5v2h7V7zm0 5v2h7v-2zM4.976 14V9h2l-1.5-2-1.5-2-1.5 2-1.5 2h2v5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h6v-2h2v-2H3V3h5V1zm6 2v2h2V3zm2 0h2V1h-2zm2 0v2h2V3zm0 2h-2v2h2zm0 2v2h2V7zm0 2h-2v2h2zm0 2v2h2v-2zm0 2h-2v2h2zm-2-4V7H8V6H7v1H6v1H5v1H4v1h4V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 14a1 1 0 0 0 1 1h6v-2h2v-2H8v1H2.25V5H10V3H8v.75H3.25L5 2h3V1H4.5a1 1 0 0 0-.707.293l-2.5 2.5A1 1 0 0 0 1 4.5Zm6.675-8L8 6.5V7h2v2H8v1.75l-.325.25-1.5-.5-1.75.75-1.75-.75L4.25 8l.875 1.25ZM10 3h2V1h-2zm2 0v2h2V3zm0 2h-2v2h2zm0 2v2h2V7zm0 2h-2v2h2zm0 2v2h2v-2zm0 2h-2v2h2z"/><path fill-opacity=".4" d="M7.675 6v5L6 10.5l-.875-1.25zM4.25 8v3.25L2.5 10.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-linejoin="round" stroke-width="2" d="M14 14H2V2l6 6 6-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#2998ff" d="M8 1 1 4v8l7 3 7-3V4zm7 3-2 1v6l-5 2v2l7-3z"/><path fill="#a2d2ff" d="m8 13 5-2-5-2-5 2zM8 1 1 4l2 1 5-2 5 2 2-1z"/><path fill="#5fb2ff" d="m8 9 5 2V5L8 3zM1 4v8l7 3v-2l-5-2V5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m8 2-6 9a6 3 0 0 0 12 0 6 3 0 0 0-12 0m12 0L8 2v9"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v1h14V3a2 2 0 0 0-2-2zm9 1h1v1h-1zM1 5v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5zm6.986 1.002A3 3 0 0 1 9 11.822V12H7v-1a1 1 0 0 1 1-1 1 1 0 1 0-.865-1.5 1 1 0 0 1-1.733-1 3 3 0 0 1 2.584-1.498zM7 13h2v1H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2h2zm2 0v2h2V1zm4 0v2h2V1zm4 0v2h2a2 2 0 0 0-2-2zM1 5v2h2V5zm12 0v2h2V5zM1 9v2h2V9zm12 0v2h2V9zM1 13a2 2 0 0 0 2 2v-2zm4 0v2h2v-2zm4 0v2h2v-2zm4 0v2a2 2 0 0 0 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2h2zm2 0v2h2V1zm4 0v2h2V1zm4 0v2h2a2 2 0 0 0-2-2zM1 5v2h2V5zm12 0v2h2V5zM1 9v2h2V9zm12 0v2h2V9zM1 13a2 2 0 0 0 2 2v-2zm4 0v2h2v-2zm4 0v2h2v-2zm4 0v2a2 2 0 0 0 2-2z"/><path fill="#d6d6d6" d="M7 7h4v4H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5" fill="none" stroke="#8eef97" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 10h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m10 10h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 10h12v4h-12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m6 6h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m6 10h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 6h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m10 6h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m6 2h4v3.9999h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#d6d6d6" d="m2 2h12v12h-12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 6h12v4h-12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 2h4v12h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m10 2h4v12h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 2h4v3.9999h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m10 2h4v3.9999h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="m0 0h16v16h-16z"/><path fill="#474747" d="m2 2h12v12h-12z"/><path fill="#d6d6d6" d="m2 2h12v3.9999h-12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#919191" d="M0 0h16v16H0z"/><path fill="#474747" d="M2 2h12v12H2z"/><path fill="#d6d6d6" d="M10 2v12H6V2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#d6d6d6" d="M11.793 8V6H8V3.887H6V6H3.858v2H6v3.967h2V8z"/><path fill="#8eef97" d="M8 .5a7.5 7.5 0 0 0 0 15 7.5 7.5 0 0 0 0-15zm0 2a5.5 5.5 0 0 1 0 11 5.5 5.5 0 0 1 0-11z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="M2.55 9.942c.61-.92 1.634-1.469 2.739-1.469.363 0 .72.06 1.059.175l2.301-2.302c-.067-.197-.115-.4-.143-.606-.248-1.787.996-3.44 2.777-3.702-.086-.022-.169-.053-.256-.065-.175-1.251-1.329-2.124-2.581-1.95-1.251.173-2.124 1.328-1.95 2.58.047.34.17.665.36.952l-3.301 3.3c-1.052-.699-2.472-.414-3.171.64-.7 1.052-.414 2.47.638 3.17.286.189.611.313.952.361.014.101.044.194.07.289.063-.476.222-.946.506-1.373zM12.5 9v1h-1.001c-1.38 0-2.499 1.119-2.499 2.5 0 .542.176 1.068.501 1.5l.706-.707c-.438-.702-.224-1.629.479-2.067.245-.151.525-.229.813-.226h1.001v.999l2-1.499zm2.999 2-.706.707c.438.702.224 1.629-.479 2.068-.246.15-.525.229-.813.225h-1.001v-.999l-2 1.499 2 1.5v-1.002h1.002c1.381 0 2.498-1.117 2.498-2.498 0-.542-.174-1.067-.501-1.5z"/><path d="m8.702 14.602c-.452-.601-.702-1.348-.702-2.102 0-1.93 1.569-3.5 3.499-3.5h.001c0-.379.214-.725.553-.895.141-.07.295-.105.447-.105.212 0 .424.068.6.2l1.515 1.136c.395-.169.747-.448 1.003-.832.699-1.051.414-2.471-.638-3.17-.287-.19-.613-.313-.952-.361-.174-1.251-1.329-2.125-2.581-1.951-1.251.174-2.124 1.329-1.95 2.581.047.34.17.666.36.952l-3.302 3.301c-1.053-.699-2.473-.415-3.172.639-.699 1.052-.414 2.471.639 3.171.285.189.61.313.951.361.174 1.251 1.33 2.124 2.581 1.95.697-.097 1.268-.504 1.614-1.057-.181-.065-.348-.162-.466-.318z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-linejoin="round" stroke-width="2" d="M14 14H2V8l6-6 6 6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" d="m8 15-7-3V4l7 3z"/><path fill="#2998ff" d="M8 1 1 4l7 11 7-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6l-5-5zm1 2h6v3a1 1 0 0 0 1 1h3v6H3zm3 5-2 4h2l2-4zm4 0-2 4h2l2-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="M2.55 9.942c.61-.92 1.634-1.469 2.739-1.469.363 0 .72.06 1.059.175l2.301-2.302c-.067-.197-.115-.4-.143-.606-.248-1.787.996-3.44 2.777-3.702-.086-.022-.169-.053-.256-.065-.175-1.251-1.329-2.124-2.581-1.95-1.251.173-2.124 1.328-1.95 2.58.047.34.17.665.36.952l-3.301 3.3c-1.052-.699-2.472-.414-3.171.64-.7 1.052-.414 2.47.638 3.17.286.189.611.313.952.361.014.101.044.194.07.289.063-.476.222-.946.506-1.373zM10.142 9.146l-1.001 1.002c-.191.199-.186.516.012.709.194.186.503.186.695 0l.147-.147v4.298h4.295l-.146.144c-.191.2-.186.518.014.709.194.188.501.188.693 0l1.003-1.002c.195-.196.195-.511 0-.707l-1.003-1c-.197-.194-.514-.189-.707.012-.187.193-.187.501 0 .696l.146.146h-2.587l2.795-2.797v.209c0 .276.224.5.5.5.275 0 .5-.224.5-.5v-1.418c0-.275-.225-.499-.5-.499h-1.417c-.275 0-.499.224-.499.499 0 .277.224.501.499.501h.209l-2.796 2.794v-2.587l.147.147c.199.19.516.187.708-.013.188-.196.188-.501 0-.695l-1-1.003c-.196-.193-.512-.193-.707.002z"/><path d="m8.995 15.007v-3.099c-.198-.071-.383-.185-.543-.338-.586-.575-.601-1.523-.019-2.13l1.003-1.004c.284-.281.66-.436 1.06-.436.397 0 .772.154 1.062.439l.758.76c.266-.419.733-.697 1.266-.697h1.417c.189 0 .369.039.536.104.026-.035.059-.063.083-.101.699-1.051.414-2.471-.638-3.17-.287-.19-.613-.313-.952-.361-.174-1.251-1.329-2.125-2.581-1.951-1.251.174-2.124 1.329-1.95 2.581.047.34.17.666.36.952l-3.302 3.3c-1.053-.699-2.473-.415-3.172.639-.699 1.052-.414 2.471.639 3.171.285.189.61.313.951.361.174 1.251 1.33 2.124 2.581 1.95.59-.082 1.09-.387 1.441-.813z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m14.564 2-2.244.328.818 1.9 1.715-.25zm-4.223.615-1.978.29.818 1.902 1.979-.29zm-3.959.578-1.978.29.818 1.902 1.979-.29zm-3.957.578-1.714.25L1 6l2.244-.328zM1 7v6a2 2 0 0 0 2 2h7v-1H8v-4h2V8h4v2h1V7z"/><path fill="#5fff97" d="M13 13h2v-2h-2V9h-2v2H9v2h2v2h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 4.233 4.233"><path fill="#e0e0e0" d="m2.397.34-.749.747v.375l.188.187L.339 3.145v.375l.374.374h.374l.187-.188.282-.092.092-.282.282-.093.187-.56.28-.095.187-.187.187.187h.374l.748-.748.001-.374L2.772.34zm.374.858a.264.264 0 1 1 .002.528.264.264 0 0 1-.002-.528z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fff97" d="m0 6v4h4v-4zm8 0v4h4v-4z"/><path fill="#ff5f5f" d="m4 6v4h4v-4zm8 0v4h4v-4z"/><path fill="#5fb2ff" d="m4 2v4h4v-4zm0 8v4h4v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fff97" d="m2 6v4h2v-4zm6 0v4h4v-4z"/><path fill="#ff5f5f" d="m4 6v4h4v-4zm8 0v4h2v-4z"/><path fill="#5fb2ff" d="m4 2v4h4v-4zm0 8v4h4v-4z"/><path fill="#e0e0e0" d="m-.00000002 2v12h4.00000002v-2h-2v-8h2v-2h-2zm12.00000002 0v2h2.000001v8h-2.000001v2h4.000001v-12h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0" stroke-width="2"><path stroke-opacity=".325" d="M2 1v13h13"/><path stroke-linecap="round" d="M2 14c8 0 12-4 12-12"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M 2 14 C 14 14 2 2 14 2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 2 2 5l6 3 6-3v6l-6 3-6-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" d="M13 1c-2.667 0-2.667 4 0 4s2.667-4 0-4M3 11c-2.667 0-2.667 4 0 4s2.667-4 0-4m10 0c-2.667 0-2.667 4 0 4s2.667-4 0-4M3 1C.333 1 .333 5 3 5s2.667-4 0-4"/><path fill="#e0e0e0" fill-opacity=".4" d="M1.836 1.836v4.53h2v-2.53h2.537v-2zm7.791 0v2h2.537v2.53h2v-4.53zM1.836 9.619v4.545h4.537v-2H3.836V9.62zm10.328 0v2.545H9.627v2h4.537V9.62z"/><path fill="#5fff97" d="M7.999 6.06c-2.667 0-2.667 4 0 4s2.667-4 0-4M6.999 1.95v3a4 4 0 0 1 2 0v-3zM1.95 7v2h3a4 4 0 0 1 0-2zm9.1 0a4 4 0 0 1 0 2h3V7Zm-4.051 4.05v3h2v-3a4 4 0 0 1-2 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-opacity=".4" stroke-width="2" d="M5 13C3 4 4 3 13 5"/><path fill="#fff" d="M5 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm8 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-8 8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/><path fill="#5fb2ff" d="M10 6v2h2V6zm0 2H8v2h2zm-2 2H6v2h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M2 6h8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-opacity=".4" stroke-width="2" d="M5 13C3 4 4 3 13 5"/><path fill="#5fff97" d="M5 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm6 5v3H8v2h3v3h2v-3h3v-2h-3V8z"/><path fill="#fff" d="M13 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-8 8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-opacity=".4" stroke-width="2" d="M5 13C3 4 4 3 13 5"/><path fill="#5fb2ff" d="M8.469.47 5.78 3.159a2 2 0 0 0-2.62 2.62L.47 8.47l1.06 1.062 2.69-2.69a2 2 0 0 0 2.62-2.62L9.53 1.53 8.47.471z"/><path fill="#fff" d="M13 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-8 8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-opacity=".4" stroke-width="2" d="M5 13C3 4 4 3 13 5"/><path fill="#ff5f5f" d="M5 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm4.879 5.465L8.465 9.879 10.585 12l-2.12 2.121 1.414 1.414L12 13.415l2.121 2.12 1.414-1.414L13.415 12l2.12-2.121-1.414-1.414L12 10.585z"/><path fill="#fff" d="M13 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-8 8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-opacity=".4" stroke-width="2" d="M5 13C3 4 4 3 13 5"/><path fill="#5fb2ff" d="M5 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm3 5 3.291 8 .947-2.82 1.883 1.883.943-.942-1.884-1.883 2.82-.947L8 8z"/><path fill="#fff" d="M13 3a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-8 8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#80ff45" stroke-linecap="round" stroke-width="2" d="M2 10c5 0 8-3 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#45d7ff" stroke-linecap="round" stroke-width="2" d="M2 10c5 0 3-8 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#ffe345" stroke-linecap="round" stroke-width="2" d="m2 10 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#45ffa2" stroke-linecap="round" stroke-width="2" d="M2 10c0-5 3-8 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#ff4596" stroke-linecap="round" stroke-width="2" d="M2 10c0-5 8-3 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v9.16A3 3 0 0 1 2 11h1V3h10v1.135a3 3 0 0 1 2 0V2a1 1 0 0 0-1-1zm7 4v1H8v1H6v1H5v1H4v1h4.39c1.113-.567 1.968-1.454 2.61-3.473V6h-1V5zm4.039 1.727c-.927 3.246-2.636 4.682-4.652 5.466C6.37 12.978 4 13 2 13a1 1 0 1 0 0 2c2 0 4.63.024 7.113-.941 2.484-.966 4.775-3.03 5.848-6.784a1 1 0 0 0-1.922-.548z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><circle cx="8" cy="8" r="5" fill="none" stroke="#ff6" stroke-miterlimit="10" stroke-width="2"/><path fill="none" stroke="#ff6" stroke-linecap="round" stroke-miterlimit="10" stroke-width="2" d="m8 8v-5"/><path fill="#fff" d="m8 1c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v10a2 2 0 0 1 .75-.1Q3 11.9 3 10.62V3h10v6.5a2 2 0 0 1 2 0V2a1 1 0 0 0-1-1zm7 4v1H8v1H6v1H5v1H4v.5a2 2 0 0 1 2.7.5h1.2a2 2 0 0 1 3.2 0h.9V8h-1V6h-1V5z"/><g fill="none" stroke-linecap="round" stroke-width="1.6"><path stroke="#ff5f5f" d="M2 14.2q2.5 0 3-3"/><path stroke="#5fff97" d="M6.5 14.2q2.5 0 3-3"/><path stroke="#5fb2ff" d="M11 14.2q2.5 0 3-3"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="M2 4v8a6 2 0 0 0 12 0V4A6 2 0 0 0 2 4a6 2 0 0 0 12 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" d="M1 4h14v8H1z"/><ellipse cx="8" cy="4" fill="#a2d2ff" rx="7" ry="3"/><ellipse cx="8" cy="12" fill="#5fb2ff" rx="7" ry="3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M12 1 4 3v2l4.8 1.8L4 8v2l4.8 1.8L4 13v2l8-2v-2L7.2 9.2 12 8V6L7.2 4.2 12 3V1"/><path fill="#010101" fill-opacity=".235" d="m4 5 4.8 1.8L12 6 7.2 4.2M4 10l4.8 1.8L12 11 7.2 9.2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1a5 5 0 0 0-3.535 1.465 1 1 0 0 0 1.414 1.414 3 3 0 0 1 4.242 0 1 1 0 0 0 1.414-1.414A5 5 0 0 0 8 1zM3 4.996a1 1 0 0 0-1 1c0 .833.327 1.697.969 2.5.33.413.77.796 1.3 1.072a4 4 0 0 0-.136.432H2a1 1 0 0 0 0 2h2.131a4 4 0 0 0 .18.537c-.142.09-.279.185-.41.283-.586.44-1.108.97-1.608 1.47a1 1 0 0 0 1.414 1.413c.5-.5.978-.972 1.393-1.283.17-.127.31-.203.443-.27a4 4 0 0 0 4.914 0c.133.067.273.142.442.268.414.311.892.783 1.392 1.283a1 1 0 0 0 1.414-1.414c-.5-.5-1.022-1.03-1.607-1.469a6.236 6.236 0 0 0-.408-.28 4 4 0 0 0 .175-.54h2.133a1 1 0 0 0 0-2h-2.13a4 4 0 0 0-.135-.434 4.117 4.117 0 0 0 1.296-1.07c.643-.803.97-1.666.97-2.5a1 1 0 0 0-2 0c0 .167-.174.803-.532 1.25-.25.314-.549.55-.932.666a4 4 0 0 0-.603-.412 2 2 0 1 0-3.867 0 4 4 0 0 0-.604.408c-.383-.117-.68-.352-.931-.666-.358-.447-.532-1.083-.532-1.25a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="M10 4v3H5v2h5v3l2.5-2L15 8l-2.5-2z"/><circle cx="4" cy="8" r="3" fill="#e0e0e0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="m3 1v10h-2l1.5 2 1.5 2 1.5-2 1.5-2h-2v-10z"/><path fill="#e0e0e0" d="m7 1v2h8v-2zm2 4v2h6v-2zm0 4v2h6v-2zm-2 4v2h8v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"><circle cx="8.5" cy="8.5" r="6" fill="#fc7f7f"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17"><circle cx="8.5" cy="8.5" r="6" fill="#fc7f7f"/><path fill="#e0e0e0" d="M1.077 14.239 14.192 1.084l1.779 1.784L2.855 16.022z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="m1 1v8 2h2 1v2l2-1.5 2-1.5-2-1.5-2-1.5v2h-1v-8z"/><path fill="#e0e0e0" d="m7 1v2h8v-2zm2 4v2h6v-2zm0 4v2h6v-2zm-2 4v2h8v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M13.91 7A6 6 0 1 0 5 13.191z"/><path fill="#ff5f5f" d="M13.91 7A6 6 0 0 0 5 13.191z"/><path fill="#fc7f7f" fill-opacity=".4" d="M5 13.191A6 6 0 0 0 13.91 7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><rect width="124" height="124" x="2" y="2" fill="#363d52" stroke="#212532" stroke-width="4" rx="14"/><g fill="#fff" transform="translate(12.322 12.322)scale(.101)"><path d="M105 673v33q407 354 814 0v-33z"/><path fill="#478cbf" d="m105 673 152 14q12 1 15 14l4 67 132 10 8-61q2-11 15-15h162q13 4 15 15l8 61 132-10 4-67q3-13 15-14l152-14V427q30-39 56-81-35-59-83-108-43 20-82 47-40-37-88-64 7-51 8-102-59-28-123-42-26 43-46 89-49-7-98 0-20-46-46-89-64 14-123 42 1 51 8 102-48 27-88 64-39-27-82-47-48 49-83 108 26 42 56 81zm0 33v39c0 276 813 276 814 0v-39l-134 12-5 69q-2 10-14 13l-162 11q-12 0-16-11l-10-65H446l-10 65q-4 11-16 11l-162-11q-12-3-14-13l-5-69z"/><path d="M483 600c0 34 58 34 58 0v-86c0-34-58-34-58 0z"/><circle cx="725" cy="526" r="90"/><circle cx="299" cy="526" r="90"/></g><g fill="#414042" transform="translate(12.322 12.322)scale(.101)"><circle cx="307" cy="532" r="60"/><circle cx="717" cy="532" r="60"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#54ed9e" d="M3 2v2a3 3 0 0 0 0 6h2V2zm3 0v2h2V2zm7 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2zm-2 2a3 3 0 0 0 0 6h1V8h-1a1 1 0 0 1 0-2h1V4zM8 7V6H6v4h2zM3 6v2a1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="2" d="M3 10v3h11V5H9.5l-1-2H3v3"/><path fill="#e0e0e0" d="M6 11V9H1V7h5V5l3 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M7 1v3h2V1zM4.465 3.05 3.05 4.466 4.464 5.88l1.414-1.414zm7.07 0-1.414 1.415 1.414 1.414 1.414-1.414zM8 5a2 2 0 0 0 0 6 2 2 0 0 0 0-6zM1 7v2h3V7zm11 0v2h3V7zm-7.535 3.121L3.05 11.535l1.414 1.414 1.414-1.414zm7.07 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 12v3h2v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M7 1v3h2V1zM4.465 3.05 3.05 4.466 4.464 5.88l1.414-1.414zm7.07 0-1.414 1.415 1.414 1.414 1.414-1.414zM8 5a2 2 0 0 0 0 6 2 2 0 0 0 0-6zM1 7v2h3V7zm11 0v2h3V7zm-7.535 3.121L3.05 11.535l1.414 1.414 1.414-1.414zm7.07 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 12v3h2v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v5l1.793-1.793 2.5 2.5 1.4141-1.4141-2.5-2.5 1.793-1.793h-5zm9 0 1.793 1.793-2.5 2.5 1.4141 1.4141 2.5-2.5 1.793 1.793v-5h-5zm-4.707 8.293-2.5 2.5-1.793-1.793v5h5l-1.793-1.793 2.5-2.5-1.4141-1.4141zm5.4141 0-1.4141 1.4141 2.5 2.5-1.793 1.793h5v-5l-1.793 1.793-2.5-2.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#def"><circle cx="4" cy="3" r="2"/><circle cx="4" cy="8" r="2"/><circle cx="4" cy="13" r="2"/><circle cx="12" cy="3" r="2"/><circle cx="12" cy="8" r="2"/><circle cx="12" cy="13" r="2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m5 1v11h9v-6h-5v-5zm5 0v4h4zm-8 3v11h2 8v-2h-8v-9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m7 1c-.554 0-1 .446-1 1v2h4v-2c0-.554-.446-1-1-1zm-1 4v7l2 3 2-3v-7zm1 1h1v5h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a1 1 0 0 0-1 1v2h4V2a1 1 0 0 0-1-1zM2 5v7l2 3 2-3V5zm1 1h1v5H3zm7.75-.25v2h-2v1.5h2v2h1.5v-2h2v-1.5h-2v-2zm-2 7v1.5h5.5v-1.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-width="2.2" d="M1.476 13.906c11.65.72 3.11-11.497 12.233-11.347"/><g fill="#e0e0e0"><circle cx="13.5" cy="2.5" r="1.823"/><circle cx="2.5" cy="14" r="1.823"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M3.678 1c-.554 0-1 .446-1 1v2h4V2c0-.554-.446-1-1-1zm-1 4v7l2 3 2-3V5zm1 1h1v5h-1z"/><circle cx="10.508" cy="12.678" r="2.373"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12 1a1 1 0 0 0-1 1v2h4V2a1 1 0 0 0-1-1zM1.226 7.46a.76.76 0 0 0 0 1.078l3.236 3.236a.76.76 0 0 0 1.078 0L8.775 8.54a.76.76 0 0 0 0-1.078L5.54 4.225a.76.76 0 0 0-1.08 0zM11 5v7l2 3 2-3V5zm1 1h1v5h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m7 1v4h2v-4zm-6 6v2h4v-2zm10 0v.61328l3.3711 1.3867h.62891v-2h-4zm-3 1 3.291 8 .94726-2.8203 1.8828 1.8828.94336-.94141-1.8848-1.8828 2.8203-.94726-8-3.291zm-1 3v4h2v-.625l-1.3887-3.375h-.61133z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="8" fill-opacity=".294"/><circle cx="8" cy="8" r="6" fill="#ff5f5f" stroke="#fff" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><circle cx="4" cy="4" r="3.25" stroke="#fff" stroke-width="1.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill-opacity=".4" d="M16 16 9.883 6.06a5 5 0 1 0-3.826 3.82z"/><path fill="#8eef97" d="M16 16 8.832 6.144A4 4 0 1 0 6.14 8.83z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="4.4" fill="#fff" stroke="#000" stroke-linecap="square" stroke-width="1.6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v1h14V3a2 2 0 0 0-2-2zm9 1h1v1h-1zM1 5v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5zm3 2h3c1 0 1 2 2 2h3v4H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><circle cx="5" cy="5" r="5" fill-opacity=".294"/><circle cx="5" cy="5" r="3.5" fill="#ff5f5f" stroke="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><circle cx="5" cy="5" r="5" fill-opacity=".294"/><circle cx="5" cy="5" r="4" fill="#474747"/><path fill="#5fff97" d="m4 2v2h-2v2h2v2h2v-2h2v-2h-2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><circle cx="5" cy="5" r="4" fill="none" stroke="#fff" stroke-opacity=".294" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5.764" fill="#fff" stroke="#000" stroke-width="1.6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" stroke="#000" stroke-width="1.6" d="M14.869 8 8 14.869 1.131 8 8 1.131z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" stroke="#000" stroke-linecap="square" stroke-width="1.6" d="m13.6 2.4v11.2h-11.2v-11.2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" fill-opacity=".706" d="m6 0v6h-6v4h6v6h4v-6h6v-4h-6v-6zm1 7h2v2h-2z"/><path fill="#ff5f5f" d="m7 1v5h2v-5zm-6 6v2h5v-2zm9 0v2h5v-2zm-3 3v5h2v-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h3v.25a2 2 0 1 0 2 0V11h3a1 1 0 0 0 1-1V7h.25a2 2 0 1 0 0-2H11V2a1 1 0 0 0-1-1H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" fill-opacity=".706" d="M6 0v4.42A4 4 0 0 0 4.42 6H0v4h4.42A4 4 0 0 0 6 11.58V16h4v-4.42A4 4 0 0 0 11.58 10H16V6h-4.42A4 4 0 0 0 10 4.42V0Z"/><path fill="#ff5f5f" d="M7 1v3a4 4 0 0 1 2 0V1Zm1 4a3 3 0 0 0 0 6 3 3 0 0 0 0-6ZM1 7v2h3a4 4 0 0 1 0-2H1Zm11 0a4 4 0 0 1 0 2h3V7Zm-5 8h2v-3a4 4 0 0 1-2 0Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" fill-opacity=".698" d="M7 1v3a4 4 0 0 1 2 0V1zm1 4a3 3 0 0 0 0 6 3 3 0 0 0 0-6zM1 7v2h2.87a4 4 0 0 1 0-2H1zm11 0a4 4 0 0 1 0 2h3V7zm-5 8h2v-3a4 4 0 0 1-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill-opacity=".411" d="M6 0v4.42A4 4 0 0 0 4.291 6H0v4h4.42A4 4 0 0 0 6 11.582V16h4v-4.42A4 4 0 0 0 11.709 10H16V6h-4.42A4 4 0 0 0 10 4.418V0z"/><path fill="#d6d6d6" d="M7 1v3a4 4 0 0 1 2 0V1zm1 4a3 3 0 0 0 0 6 3 3 0 0 0 0-6zM1 7v2h2.87a4 4 0 0 1 0-2H1zm11 0a4 4 0 0 1 0 2h3V7zm-5 8h2v-3a4 4 0 0 1-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M3 2a2 2 0 0 0-2 2v1a1 1 0 0 0 0 2v1a2 2 0 0 0 2 2h1V8H3V4h1V2zm3 0v8h4V8H8V7h2V5H8V4h2V2zm6 0v2h1v4h-1v2h1a2 2 0 0 0 2-2V7a1 1 0 0 0 0-2V4a2 2 0 0 0-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0"><circle cx="8" cy="8" r="6" stroke-width="2"/><path stroke-width="1.5" d="M2 8a6.5 2 0 0 0 12 0M8 2c-3 4-3 8 0 12M8 2c3 4 3 8 0 12"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M10 1.5.5 11 4 14.5h4L15.5 7Zm-4.5 7 3 3-1 1h-3L3 11Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><circle cx="4" cy="4" r="4" fill="#ff5f5f"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><path fill="#ff5f5f" d="M4 8a1 1 0 0 1 0-8z"/><path fill="#ffdd65" d="M4 0a1 1 0 0 1 0 8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 4.5 1 8h2v5h2V8h2zm8 0L9 8h2v5h2V8h2zM1 1h14v2H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m8 16-3.5-2.5H7V11h2v2.5h2.5zM8 0 4.5 2.5H7V5h2V2.5h2.5zM1 7h14v2H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m5 9 5.5-5.5L8 1h7v7l-2.5-2.5L7 11zm7 6H4a3 3 0 0 1-3-3V4a3 3 0 0 1 3-3h2a1 1 0 0 1 0 2H4a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-2a1 1 0 0 1 2 0v2a3 3 0 0 1-3 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7.25 4h-2v8h2v-2c1.656 0 3-1.344 3-3 0-1.657-1.344-3-3-3zm0 4v-2c.553 0 1 .448 1 1s-.447 1-1 1zM.25 7v5h2v-2h2v-2h-2v-1c0-.553.447-1 1-1h1v-2h-1c-1.656 0-3 1.344-3 3zM13.25 7c-.276 0-.5-.224-.5-.5s.224-.5.5-.5h2v-2h-2c-1.381 0-2.5 1.119-2.5 2.5s1.119 2.5 2.5 2.5c.276 0 .5.224.5.5s-.224.5-.5.5h-2v2h2c1.381 0 2.5-1.119 2.5-2.5s-1.119-2.5-2.5-2.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m9 1v2h2.586l-3.586 3.586-4.293-4.293-1.414 1.414 4.293 4.293-4.293 4.293 1.414 1.414 4.293-4.293 3.586 3.586h-2.586v2h5a1 1 0 0 0 1-1v-5h-2v2.586l-3.586-3.586 3.586-3.586v2.586h2v-5a1 1 0 0 0 -1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m11.032091 3.1108593-1.4142134 1.4142136 1.8285784 1.8285781h-9.8600786v1.999698h9.8600786l-1.8285784 1.828578 1.4142134 1.414214 3.535534-3.5355342c.390524-.3905243.390525-1.0236891 0-1.4142136z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m9 1v2h2.586c-9.293 9.293-.896067.8960673-9.293 9.293l1.414 1.414c9.293-9.293 3.7072139-3.7072139 9.293-9.293v2.586h2v-5c0-.5522847-.447715-1-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m3.707 2.293-1.414 1.414c9.293 9.293 1.4503342 1.4503342 9.293 9.293h-2.586v2h5c.552285 0 1-.447715 1-1v-5h-2v2.586c-9.293-9.293-2.832166-2.8321664-9.293-9.293z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1.7 5.626 5.797 1 6.895l3.236 3.408-.359 4.673 4.14-1.977 4.157 1.942-.396-4.653L15 6.895l-4.626-1.098z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 1v14h12v-9h-5v-5zm8 0v4h4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M15 6v8a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1v-3h2v2h8V7h-3a1 1 0 0 1-1-1V3H5v4H3V2a1 1 0 0 1 1-1h6zm-9 6v-2H1V8h5V6l3 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="#fff" fill-opacity=".6" d="M14 5a4 4 0 0 0-4 4v46a4 4 0 0 0 4 4h36a4 4 0 0 0 4-4V22a1 1 0 0 0-.29-.707l-16-16a1 1 0 0 0-.707-.29V5H14zm0 2h22v12a4 4 0 0 0 4 4h12v32a2 2 0 0 1-2 2H14a2 2 0 0 1-2-2V9a2 2 0 0 1 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="M2 1v8.586l1.293-1.293a1 1 0 0 1 1.414 0L7 10.587l2.293-2.293a1 1 0 0 1 1.414 0L13 10.586l1-1V6H9V1H2zm8 0v4h4zm-6 9.414-2 2V15h12v-2.586l-.293.293a1 1 0 0 1-1.414 0L10 10.414l-2.293 2.293a1 1 0 0 1-1.414 0L4 10.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="#ff5f5f" d="M14 5c-2.199 0-4 1.801-4 4v26.172a1 1 0 0 0 1.707.707L15 32.586l9.293 9.293a1 1 0 0 0 1.414 0L35 32.586l9.293 9.293a1 1 0 0 0 1.414 0l8-8a1 1 0 0 0 .293-.707V22a1 1 0 0 0-.293-.707l-16-16A1 1 0 0 0 37 5H14zm0 2h22v12c0 2.199 1.801 4 4 4h12v9.758l-7 7-9.293-9.293a1 1 0 0 0-1.414 0L25 39.758l-9.293-9.293a1 1 0 0 0-1.414 0L12 32.758V9c0-1.126.875-2 2-2zm.984 28.83a1 1 0 0 0-.691.293l-4 4a1 1 0 0 0-.293.707V55c0 2.199 1.801 4 4 4h36c2.199 0 4-1.801 4-4V38.83a1 1 0 0 0-1.707-.707L45 45.416l-9.293-9.293a1 1 0 0 0-1.414 0L25 45.416l-9.293-9.293a1 1 0 0 0-.723-.293zM15 38.244l9.293 9.293a1 1 0 0 0 1.414 0L35 38.244l9.293 9.293a1 1 0 0 0 1.414 0L52 41.244V55c0 1.125-.875 2-2 2H14c-1.125 0-2-.875-2-2V41.244l3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1v14h2.707a2.5 2.5 0 0 1-.207-1A2.49 2.49 0 0 1 7 11.5c.565 0 1.083.188 1.5.5a2.494 2.494 0 0 1 3 0 2.51 2.51 0 0 1 2.5-.293V6H9V1Zm8 0v4h4z"/><path fill="#e0e0e0" d="M8 14a1 1 0 1 1-2 0 1 1 0 0 1 2 0m3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0m3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="M2 1v14h12V6H9V1zm8 0v4h4zM5 7.793l.646-.646a.353.353 0 0 1 .707.707l-.646.646.646.646a.353.353 0 0 1-.707.707L5 9.207l-.646.646a.353.353 0 0 1-.707-.706l.646-.647-.646-.646a.353.353 0 0 1 .707-.707zm6 0 .646-.646a.353.353 0 0 1 .707.707l-.646.646.646.646a.353.353 0 0 1-.706.707L11 9.207l-.646.646a.353.353 0 0 1-.707-.706l.646-.647-.646-.646a.353.353 0 0 1 .706-.707zM3.5 11h9a.5.5 0 0 1 0 1H8a2 2 0 0 1-4 0h-.5a.5.5 0 0 1 0-1zM5 12a1 1 0 0 0 2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="#ff5f5f" d="M14 5a4 4 0 0 0-4 4v46a4 4 0 0 0 4 4h36a4 4 0 0 0 4-4V22a.967.967 0 0 0-.285-.707l-16-16a1 1 0 0 0-.707-.29V5zm0 2h22v12a4 4 0 0 0 4 4h12v32a2 2 0 0 1-2 2H14a2 2 0 0 1-2-2V9a2 2 0 0 1 2-2zm2.951 22.002a1 1 0 0 0-.703 1.658L19.172 34l-2.924 3.342a1 1 0 0 0 1.504 1.318l2.748-3.14 2.748 3.14a1 1 0 0 0 1.504-1.318L21.828 34l2.924-3.34a1 1 0 0 0-1.504-1.318l-2.748 3.14-2.748-3.14a1 1 0 0 0-.8-.34zm23 0a1 1 0 0 0-.703 1.658L42.172 34l-2.924 3.342a1 1 0 0 0 1.504 1.318l2.748-3.14 2.748 3.14a1 1 0 0 0 1.504-1.318L44.828 34l2.924-3.34a1 1 0 0 0-1.504-1.318l-2.748 3.14-2.748-3.14a1 1 0 0 0-.8-.34zM21 43a1 1 0 0 0 0 2h3v3a5 5 0 0 0 10 0v-3h9a1 1 0 0 0 0-2zm5 2h6v3a3 3 0 0 1-6 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"><path fill="#ff5f5f" d="M5 1a3 3 0 0 0-3 3v24a3 3 0 0 0 3 3h22a3 3 0 0 0 3-3V11.191a1 1 0 0 0-.293-.707l-9.182-9.19A1 1 0 0 0 19.818 1H5zm0 2h14v6a3 3 0 0 0 3 3h6v16a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1zm1.986 11.002a1 1 0 0 0-.693 1.705L7.586 17l-1.293 1.293a1 1 0 0 0 1.414 1.414L9 18.414l1.293 1.293a1 1 0 0 0 1.414-1.414L10.414 17l1.293-1.293a1 1 0 0 0-1.414-1.414L9 15.586l-1.293-1.293a1 1 0 0 0-.72-.291zm14 0a1 1 0 0 0-.693 1.705L21.586 17l-1.293 1.293a1 1 0 0 0 1.414 1.414L23 18.414l1.293 1.293a1 1 0 0 0 1.414-1.414L24.414 17l1.293-1.293a1 1 0 0 0-1.414-1.414L23 15.586l-1.293-1.293a1 1 0 0 0-.72-.291zM7 22a1 1 0 0 0 0 2h1a4 4 0 0 0 8 0h9a1 1 0 0 0 0-2zm3 2h4a2 2 0 0 1-4 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v1h14V3a2 2 0 0 0-2-2zm9 1h1v1h-1zM1 5v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5zm3 2h3c1 0 1 2 2 2h3v4H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 2v2h2v-2zm4 0v2h8v-2zm-4 5v2h2v-2zm4 0v2h8v-2zm-4 5v2h2v-2zm4 0v2h8v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"><path fill="#fff" fill-opacity=".6" d="M5 1a3 3 0 0 0-3 3v24a3 3 0 0 0 3 3h22a3 3 0 0 0 3-3V11.191a1 1 0 0 0-.293-.707l-9.182-9.182A1 1 0 0 0 19.818 1zm0 2h14v6a3 3 0 0 0 3 3h6v16a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 2v5h5v-5zm7 0v5h5v-5zm-7 7v5h5v-5zm7 0v5h5v-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 2v2h2v5h2v5h8v-2h-6v-3h6v-2h-8v-3h8v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="m13.297.714h-13.013a.454.454 0 0 0 -.318.779l4.615 4.507v7.086a.45.45 0 0 0 .738.354l3.511-2.812a.454.454 0 0 0 .17-.354v-4.274l4.614-4.506a.454.454 0 0 0 -.317-.779z"/><path d="m11.085832 14.18196c3.399443 1.97457 6.855925-2.441094 4.074102-5.1815164-2.781825-2.7404217-7.2642008.6646174-5.2597994 4.0134654l-1.9001346 1.871854 1.1856973 1.168051zm1.699723-4.4945981c2.236109 0 2.236109 3.3042441 0 3.3042441-2.236108 0-2.236108-3.3042441 0-3.3042441z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v5h2v8h1 5v1h6v-3h-6v1h-5v-4h5v1h6v-3h-6v1h-5v-2h3v-4h-2l-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m11.032 6.8435a3.032 2.8914 0 0 0-6.064 0v1.1565h-0.6064v4.0479h7.2768v-4.0479h-0.6064zm-4.8512 0a1.8192 1.7348 0 0 1 3.6384 0v1.1565h-3.6384zm1.2128 2.3131h1.2128v1.7348h-1.2128z"/><g fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-miterlimit="0"><path d="m2.1058 5.8844v-2.7749h2.9127m5.8565 0.0498h2.7749v2.9127" transform="matrix(1.1315 0 0 1.1398 -.914 -1.888)"/><path d="m13.757 11.466v2.7749h-2.9127m-5.856-0.0499h-2.7749v-2.9127" transform="matrix(1.1315 0 0 1.1398 -1.035 -1.888)"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="4.596" height="4.596" x="5.7" y="5.7" fill="#e0e0e0" fill-opacity=".6" rx="1" ry="1" transform="rotate(45 8 8)"/><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 2a6 6 0 00-2.5 11m.5-3L6 14H2M9 14a6 6 0 002.5-11M11 6 10 2h4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#8eef97" stroke-width="2" transform="rotate(45 4.241 9.083)scale(.737)"><rect width="12" height="12" x="2" y="2" rx="1"/><path stroke-linecap="round" d="M5 5h2m3 0h1M5 8h0m3 0h3m-6 3h4"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M2.5 8S1 8 1 6.5 3 5 3 5s0-4 3.5-4S10 4 10 4s1.26-2 3-1 .5 3 .5 3S15 6 15 7s-1 1-1 1z"/><path stroke="url(#a)" stroke-linecap="round" d="M4.5 9.5h8m-9 2h5m2 0H13m-7.5 2h5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M2.5 8S1 8 1 6.5 3 5 3 5s0-4 3.5-4S10 4 10 4s1.26-2 3-1 .5 3 .5 3S15 6 15 7s-1 1-1 1z"/><path stroke="#fc7f7f" stroke-linecap="round" d="M4.5 9.5h8m-9 2h5m2 0H13m-7.5 2h5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m3 1c-1.1045684 0-2 .8954316-2 2v10c0 1.104568.8954316 2 2 2h10c1.104568 0 2-.895432 2-2v-10c0-1.1045684-.895432-2-2-2zm1 2h8l-4 4zm-1 5h10v5h-10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 2a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1h-4a1 1 0 0 1-1-1V3a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="#e0e0e0" d="M12 10a4 4 0 0 0-4 4v36a4 4 0 0 0 4 4h40a4 4 0 0 0 4-4V22a4 4 0 0 0-4-4H36l-2-4c-1-2-2-4-4-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16"><path fill="#e0e0e0" d="M2 2a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h3.738a2.5 2.5 0 0 1-.238-1.074 2.49 2.49 0 0 1 2.5-2.5c.565 0 1.083.187 1.5.5.417-.313.935-.5 1.5-.5s1.083.187 1.5.5a2.5 2.5 0 0 1 2.5-.295V6a1 1 0 0 0-1-1h-4a1 1 0 0 1-1-1V3a1 1 0 0 0-1-1Zm5.408 13.355.074.018q-.038-.008-.074-.018m.35.06"/><path fill="#e0e0e0" d="M9 13a1 1 0 1 1-2 0 1 1 0 0 1 2 0m3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0m3 0a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 3a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h8v-1H8v-4h2V8h4v2h1V7a1 1 0 0 0-1-1h-4a1 1 0 0 1-1-1V4a1 1 0 0 0-1-1Z"/><path fill="#5fff97" d="M13 13h2v-2h-2V9h-2v2H9v2h2v2h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32"><path fill="#e0e0e0" d="M6 5a2 2 0 0 0-2 2v18.5h.065A2 2 0 0 0 6 27h20a2 2 0 0 0 2-2V11a2 2 0 0 0-2-2h-8l-1-2c-.5-1-1-2-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M1 1h14v4h-1a2 2 0 0 0-2-2H9v9a2 2 0 0 0 2 2v1H5v-1a2 2 0 0 0 2-2V3H4a2 2 0 0 0-2 2H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7.5 7.5h-1A.491.491 0 0 0 6 8v.5h-.5V9a1 1 0 0 1-1 1v1H8V9.854A1 1 0 0 1 7.5 9zM1.5 1v3h1a1 1 0 0 1 1-1h2v1.5h2V3h2a1 1 0 0 1 1 1h1V1z"/><path fill="#ff5f5f" d="M4.5 5v3h1a1 1 0 0 1 1-1h2v6a1 1 0 0 1-1 1v1h4v-1a1 1 0 0 1-1-1V7h2a1 1 0 0 1 1 1h1V5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1h14v4h-1a2 2 0 0 0-2-2H9v9a2 2 0 0 0 2 2v1H5v-1a2 2 0 0 0 2-2V3H4a2 2 0 0 0-2 2H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 6.992h6.025v2.4h-.43a.861 1.2 0 0 0-.861-1.2H4.62v3.913a1.214.93 0 0 0 1.214.93v.465H2.19v-.465a1.214.93 0 0 0 1.214-.93V8.192H2.29a.861 1.2 0 0 0-.861 1.2h-.43zm3-3.961h10.773v3.078h-.77a1.539 1.539 0 0 0-1.539-1.539h-2.308v6.926a1.539 1.539 0 0 0 1.539 1.539v.465H7.078v-.465a1.539 1.539 0 0 0 1.539-1.539V4.57H6.309A1.539 1.539 0 0 0 4.77 6.109H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5.975 11 7.21 7.5H5.916a.75 1 0 0 0-.416.152V9a1 1 0 0 1-1 1v1zM1.5 1v3h1a1 1 0 0 1 1-1h2v1.5h2V3h2a1 1 0 0 1 1 1h1V1z"/><path fill="#ff5f5f" d="M4.621 5 3.563 8h1a.84 1.192 50 0 1 1.353-1h2L5.8 13a.84 1.192 50 0 1-1.353 1l-.353 1h4l.353-1a.84 1.192 50 0 1-.647-1l2.116-6h2a.84 1.192 50 0 1 .647 1h1l1.058-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m2 2 4 6-4 6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M12 11a3 3 0 0 0 .414-5.969 4.5 5 0 0 0-8.824 0 3 3 0 0 0 .414 5.967zm-8 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm8 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M12 11a3 3 0 0 0 .414-5.969 4.5 5 0 0 0-8.824 0 3 3 0 0 0 .414 5.967zm-8 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm8 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="1" fill="#fc7f7f"/><g fill="none" stroke="#fc7f7f"><ellipse cx="8" cy="8" rx="4.8" ry="2.4"/><ellipse cx="8" cy="8" rx="2.4" ry="4.8"/><path d="m1.5 1.5h13v13h-13z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="1" fill="#fc7f7f"/><g fill="none" stroke="#fc7f7f"><circle cx="8" cy="8" r="6.5"/><ellipse cx="11.314" rx="2.4" ry="4.8" transform="rotate(45)"/><ellipse cy="11.314" rx="2.4" ry="4.8" transform="rotate(-45)"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><ellipse cx="6.673" cy="9.387" fill="none" stroke="#fc7f7f" rx="2.4" ry="4.8"/><ellipse cx="6.672" cy="9.387" fill="none" stroke="#fc7f7f" rx="4.8" ry="2.4"/><g fill="#fc7f7f"><circle cx="6.664" cy="9.3" r="1"/><path d="m11.8 15 2.4-2.4.8.8V11h-2.4l.8.8-2.4 2.4zM11 6l3-3 1 1V1h-3l1 1-3 3zM1.8 5l2.4-2.4.8.8V1H2.6l.8.8L1 4.2z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-width="1.75" d="m7.5 4 5.25 2.625v5.25L7.5 14.5l-5.25-2.625v-5.25zm0 10.5V9.25l5.25-2.625M7.5 9.25 2.25 6.625"/><g fill="#fc7f7f"><circle cx="1.875" cy="3.75" r="1"/><circle cx="13.125" cy="3.75" r="1"/><circle cx="9.375" cy="1.875" r="1"/><circle cx="5.625" cy="1.875" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="m1 10c1-1 3-2 3-4s2-4 4-4 4 2 4 4 2 3 3 4l-7 5z"/><circle cx="2" cy="6" r="1"/><circle cx="14" cy="6" r="1"/><circle cx="12" cy="2" r="1"/><circle cx="4" cy="2" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-linejoin="round" stroke-width="2" d="M14 14H2V5s3 4 6 4 6-4 6-4z"/><g fill="#fc7f7f"><circle cx="2" cy="2" r="1"/><circle cx="14" cy="2" r="1"/><circle cx="10" cy="5" r="1"/><circle cx="6" cy="5" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-width="1.667" d="M 8 4 a 5 5 0 0 0 0 10 a 5 5 0 0 0 0 -10 v 10 m -4.95 -5.6 a 5 2 0 0 0 9.9 0"/><g fill="#fc7f7f"><circle cx="2" cy="5" r="1"/><circle cx="14" cy="5" r="1"/><circle cx="10" cy="2" r="1"/><circle cx="6" cy="2" r="1"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M 1,15 V 12 C 1,11.5 1.5,11 2,11 H 3 V 10 C 3,9.5 3.5,9 4,9 h 1 c 0.5,0 1,0.5 1,1 v 1 H 8 V 5 h 2 v 6 h 4 c 0.5,0 1,0.5 1,1 v 3 z"/><circle cx="9" cy="4" r="3" fill="#e0e0e0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 2v12M3 6l10 5M3 11l10-5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#99c4ff" d="M1 1v14h14v-1L2 1zm2 4 8 8H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffa6bd" d="M1 1v14h14v-1L2 1zm2 4 8 8H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#b56d6d" d="M4.729 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541a2 2 0 1 0 2.698-2.75H14V4.729A2 2 0 1 0 11.27 2H4.729zm6.542 2a2 2 0 0 0 .729.729v6.542a2 2 0 0 0-.729.729H4.729A2 2 0 0 0 4 11.271V4.729A2 2 0 0 0 4.729 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M63.766 8a8 8 0 0 0-5.42 2.336L28.682 40H16a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8h12.682l29.664 29.664A8 8 0 0 0 72 112V16a8 8 0 0 0-8.234-8zM112 12a8 8 0 0 0-8 8v88a8 8 0 0 0 16 0V20a8 8 0 0 0-8-8zM88 36a8 8 0 0 0-8 8v40a8 8 0 0 0 16 0V44a8 8 0 0 0-8-8z"/><path fill="#f7f5cf" d="M63.883 12.004a4 4 0 0 0-2.71 1.168l-30.829 30.83H16a4 4 0 0 0-4 4v32a4 4 0 0 0 4 4h14.344l30.828 30.828c2.52 2.518 6.827.734 6.828-2.828V16a4 4 0 0 0-4.117-3.996zM112 16a4 4 0 0 0-4 4v88a4 4 0 0 0 4 4 4 4 0 0 0 4-4V20a4 4 0 0 0-4-4zM88 40a4 4 0 0 0-4 4v40a4 4 0 0 0 4 4 4 4 0 0 0 4-4V44a4 4 0 0 0-4-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".294" stroke-width="8" d="M48 8A40 40 0 0 0 8 48h16a24 24 0 0 1 48 0c0 14-4.33 18.86-9.12 22.852-2.396 1.996-5.038 3.53-7.814 5.536-1.388 1-2.866 2.126-4.304 3.94-1.44 1.774-2.762 4.63-2.762 7.63 0 10.22-2.54 12.59-5.118 14.138-2.578 1.546-6.882 1.86-10.882 1.86h-8v16h8c4 0 11.696.31 19.116-4.14 7.06-4.238 12.2-13.28 12.696-26 .184-.166.148-.156.62-.498 1.724-1.244 5.084-3.21 8.688-6.214C80.33 77.096 88 65.958 88 47.958A40 40 0 0 0 48 8zm63.426 8L97.52 24a48 48 0 0 1 .016 47.942l13.89 8a64 64 0 0 0 0-64z"/><path fill="#f7f5cf" d="M48 8A40 40 0 0 0 8 48h16a24 24 0 0 1 48 0c0 14-4.33 18.86-9.12 22.852-2.396 1.996-5.038 3.53-7.814 5.536-1.388 1-2.866 2.126-4.304 3.94-1.44 1.774-2.762 4.63-2.762 7.63 0 10.22-2.54 12.59-5.118 14.138-2.578 1.546-6.882 1.86-10.882 1.86h-8v16h8c4 0 11.696.31 19.116-4.14 7.06-4.238 12.2-13.28 12.696-26 .184-.166.148-.156.62-.498 1.724-1.244 5.084-3.21 8.688-6.214C80.33 77.096 88 65.958 88 47.958A40 40 0 0 0 48 8zm63.426 8L97.52 24a48 48 0 0 1 .016 47.942l13.89 8a64 64 0 0 0 0-64z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill="none" stroke="#000" stroke-opacity=".3" stroke-width="8" d="M36.688 4a6.112 6.112 0 0 0-6.112 6.112v4.8h-9.6a6.112 6.112 0 0 0-6.112 6.112v9.6h-4.8a6.112 6.112 0 0 0-6.112 6.112v3.2a6.112 6.112 0 0 0 6.112 6.112h4.8v36h-4.8a6.112 6.112 0 0 0-6.112 6.112v3.2a6.112 6.112 0 0 0 6.112 6.112h4.8v9.6a6.112 6.112 0 0 0 6.112 6.112h9.6v4.8a6.112 6.112 0 0 0 6.112 6.112h3.2A6.112 6.112 0 0 0 46 117.984v-4.8h36v4.8a6.112 6.112 0 0 0 6.112 6.112h3.2a6.112 6.112 0 0 0 6.112-6.112v-4.8h9.6a6.112 6.112 0 0 0 6.112-6.112v-9.6h4.8a6.112 6.112 0 0 0 6.112-6.112v-3.2a6.112 6.112 0 0 0-6.112-6.112h-4.8v-36h4.8a6.112 6.112 0 0 0 6.112-6.112v-3.2a6.112 6.112 0 0 0-6.112-6.112h-4.8v-9.6a6.112 6.112 0 0 0-6.112-6.104h-9.6v-4.8a6.112 6.112 0 0 0-6.112-6.112h-3.2A6.112 6.112 0 0 0 82 10.12v4.8H46v-4.8a6.112 6.112 0 0 0-6.112-6.112z"/><path fill="#f7f5cf" d="M36.688 4a6.112 6.112 0 0 0-6.112 6.112v4.8h-9.6a6.112 6.112 0 0 0-6.112 6.112v9.6h-4.8a6.112 6.112 0 0 0-6.112 6.112v3.2a6.112 6.112 0 0 0 6.112 6.112h4.8v36h-4.8a6.112 6.112 0 0 0-6.112 6.112v3.2a6.112 6.112 0 0 0 6.112 6.112h4.8v9.6a6.112 6.112 0 0 0 6.112 6.112h9.6v4.8a6.112 6.112 0 0 0 6.112 6.112h3.2A6.112 6.112 0 0 0 46 117.984v-4.8h36v4.8a6.112 6.112 0 0 0 6.112 6.112h3.2a6.112 6.112 0 0 0 6.112-6.112v-4.8h9.6a6.112 6.112 0 0 0 6.112-6.112v-9.6h4.8a6.112 6.112 0 0 0 6.112-6.112v-3.2a6.112 6.112 0 0 0-6.112-6.112h-4.8v-36h4.8a6.112 6.112 0 0 0 6.112-6.112v-3.2a6.112 6.112 0 0 0-6.112-6.112h-4.8v-9.6a6.112 6.112 0 0 0-6.112-6.104h-9.6v-4.8a6.112 6.112 0 0 0-6.112-6.112h-3.2A6.112 6.112 0 0 0 82 10.12v4.8H46v-4.8a6.112 6.112 0 0 0-6.112-6.112z"/><path fill="#e1b44c" d="M88 82a18 18 0 0 0 2.484-35.814 27 30 0 0 0-52.944 0 18 18 0 0 0 2.484 35.802zm-48 6a6 6 0 0 0 0 12 6 6 0 0 0 0-12zm48 0a6 6 0 0 0 0 12 6 6 0 0 0 0-12zm-24 6a6 6 0 0 0 0 12 6 6 0 0 0 0-12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".294" stroke-width="8" d="M76 20a24 24 0 0 0-24 22.216 24 24 0 1 0-24 40.376V100a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-8l24 16V60L92 76V61.84A24 24 0 0 0 76 20zM44 96a4 4 0 0 1-4-4V75a3 3 0 0 0-3-3 12 12 0 1 1 9-19 9.5 9.5 0 0 0 18-6 12 12 0 1 1 18 7 3 3 0 0 0-2 3v35a4 4 0 0 1-4 4z"/><path fill="#f7f5cf" d="M76 20a24 24 0 0 0-24 22.216 24 24 0 1 0-24 40.376V100a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-8l24 16V60L92 76V61.84A24 24 0 0 0 76 20zM44 96a4 4 0 0 1-4-4V75a3 3 0 0 0-3-3 12 12 0 1 1 9-19 9.5 9.5 0 0 0 18-6 12 12 0 1 1 18 7 3 3 0 0 0-2 3v35a4 4 0 0 1-4 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><circle cx="64" cy="64" r="48" fill="none" stroke="#000" stroke-opacity=".3" stroke-width="8"/><path fill="#f7f5cf" d="M111.313 55.934a48 48 0 1 0-71.28 49.528z"/><path fill="#e1b44c" d="M111.313 55.934a48 48 0 0 0-71.28 49.528z"/><path fill="#f7f5cf" fill-opacity=".4" d="M40.033 105.462a48 48 0 0 0 71.28-49.528z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M56 28a8 8 0 0 0 16 0V12a8 8 0 0 0-16 0zM32.886 44.2A8 8 0 0 0 44.2 32.886L32.886 21.575a7.975 7.975 0 0 0-11.312 11.312zm50.913-11.313a8 8 0 0 0 11.314 11.314l11.312-11.314a8 8 0 0 0-11.312-11.312zM64 40a24 24 0 0 0 0 48 24 24 0 0 0 0-48zM12 56a8 8 0 0 0 0 16h16a8 8 0 0 0 0-16zm88 0a8 8 0 0 0 0 16h16a8 8 0 0 0 0-16zM21.574 95.113a7.98 7.98 0 0 0 11.312 11.312L44.2 95.113a8 8 0 0 0-11.314-11.314zm73.538 11.312a8 8 0 0 0 11.312-11.312L95.112 83.799a8 8 0 0 0-11.314 11.314zM56 116a8 8 0 0 0 16 0v-16a8 8 0 0 0-16 0z"/><path fill="#fff" d="M60 28a4 4 0 0 0 8 0V12a4 4 0 0 0-8 0zM35.714 41.373a4 4 0 0 0 5.658-5.658L30.058 24.403a4 4 0 0 0-5.656 5.656zm50.913-5.658a4 4 0 0 0 5.658 5.658l11.313-11.314a4 4 0 0 0-5.657-5.656zM64 44a20 20 0 0 0 0 40 20 20 0 0 0 0-40zM12 60a4 4 0 0 0 0 8h16a4 4 0 0 0 0-8zm88 0a1 1 0 0 0 0 8h16a1 1 0 0 0 0-8zM24.402 97.94a4 4 0 0 0 5.656 5.656l11.314-11.313a4 4 0 0 0-5.658-5.656zm73.538 5.658a4 4 0 0 0 5.656-5.656L92.283 86.628a4 4 0 0 0-5.657 5.657zM60 116a4 4 0 0 0 8 0v-16a4 4 0 0 0-8 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill="none" stroke="#000" stroke-opacity=".3" stroke-width="8" d="M20 68S8 68 8 56s16-12 16-12 0-32 28-32 28 24 28 24 10.08-16 24-8 4 24 4 24 12 0 12 8-8 8-8 8zm16 8a4 4 0 0 0 0 8h64a4 4 0 0 0 0-8zm-8 16a4 4 0 0 0 0 8h40a4 4 0 0 0 0-8zm56 0a4 4 0 0 0 0 8h20a4 4 0 0 0 0-8zm-40 16a4 4 0 0 0 0 8h40a4 4 0 0 0 0-8z"/><path fill="#f7f5cf" d="M20 68S8 68 8 56s16-12 16-12 0-32 28-32 28 24 28 24 10.08-16 24-8 4 24 4 24 12 0 12 8-8 8-8 8zm16 8a4 4 0 0 0 0 8h64a4 4 0 0 0 0-8zm-8 16a4 4 0 0 0 0 8h40a4 4 0 0 0 0-8zm56 0a4 4 0 0 0 0 8h20a4 4 0 0 0 0-8zm-40 16a4 4 0 0 0 0 8h40a4 4 0 0 0 0-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M63.998 4c-18.429.005-34.029 13.88-38.557 32.926C13.041 39.934 4.014 51.006 4 63.996V64c0 15.417 12.583 28 28 28h64c15.417 0 28-12.583 28-28v-.004c-.015-13-9.055-24.076-21.467-27.074C98.006 17.889 82.421 4.019 64.004 4zM96 92c-6.58 0-12 5.42-12 12s5.42 12 12 12 12-5.42 12-12-5.42-12-12-12zm-64 0c-6.58 0-12 5.42-12 12s5.42 12 12 12 12-5.42 12-12-5.42-12-12-12zm32 8c-6.58 0-12 5.42-12 12s5.42 12 12 12 12-5.42 12-12-5.42-12-12-12z"/><path fill="#f7f5cf" d="M64 8a36 40 0 0 0-35.311 32.256A24 24 0 0 0 8 64a24 24 0 0 0 24 24h64a24 24 0 0 0 24-24 24 24 0 0 0-20.715-23.746A36 40 0 0 0 64 8zM32 96a8 8 0 0 0-8 8 8 8 0 0 0 8 8 8 8 0 0 0 8-8 8 8 0 0 0-8-8zm64 0a8 8 0 0 0-8 8 8 8 0 0 0 8 8 8 8 0 0 0 8-8 8 8 0 0 0-8-8zm-32 8a8 8 0 0 0-8 8 8 8 0 0 0 8 8 8 8 0 0 0 8-8 8 8 0 0 0-8-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M64 2a44 44 0 0 0-44 44 44 44 0 0 0 24 39.189v13.81a10.97 10.97 0 0 0 8 10.579v16.421h24v-16.421a10.97 10.97 0 0 0 8-10.579V85.142A44 44 0 0 0 108 46 44 44 0 0 0 64 2zm0 20a24 24 0 0 1 24 24 24 24 0 0 1-24 24 24 24 0 0 1-24-24 24 24 0 0 1 24-24z"/><path fill="#fff" d="M64 6a40 40 0 0 0-40 40 40 40 0 0 0 24 36.607V98a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V82.637A40 40 0 0 0 104 46 40 40 0 0 0 64 6zm0 12a28 28 0 0 1 28 28 28 28 0 0 1-28 28 28 28 0 0 1-28-28 28 28 0 0 1 28-28zm-8 96v8h16v-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M18 8a4 4 0 0 0-4 4v20H8a4 4 0 0 0-4 4v71a17 17 0 0 0 17 17h61a4 4 0 0 0 4-4v-12a4 4 0 0 0-4-4H24V64h20v12a4 4 0 0 0 4 4h32a4 4 0 0 0 4-4V64h20v4a4 4 0 0 0 .576 2.059A20 20 0 0 0 92 105.756v2.238a8 8 0 0 0 4 6.75V120a4 4 0 0 0 4 4h8a4 4 0 0 0 4-4v-5.248a8 8 0 0 0 4-6.752v-2.234A20 20 0 0 0 112.541 72H120a4 4 0 0 0 4-4V36a4 4 0 0 0-4-4h-6V12a4 4 0 0 0-4-4zm8 38a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm25 0a1 1 0 0 1 0 4 1 1 0 0 1 0-4zm26 0a1 1 0 0 1 0 4 1 1 0 0 1 0-4zm25 0a1 1 0 0 1 0 4 1 1 0 0 1 0-4zm2 38a1 1 0 0 1 0 12 1 1 0 0 1 0-12z"/><path fill="#f7f5cf" d="M18 12v16h92V12zM8 36v71.076A13 13 0 0 0 20.924 120H82v-12H20V60h88v8h12V36zm18 6a6 6 0 1 1 0 12 6 6 0 0 1 0-12zm25 0a6 6 0 1 1 0 12 6 6 0 0 1 0-12zm26 0a6 6 0 1 1 0 12 6 6 0 0 1 0-12zm25 0a6 6 0 1 1 0 12 6 6 0 0 1 0-12zM48 68v8h32v-8zm48 40a4 4 0 0 0 4 4h8a4 4 0 0 0 4-4v-4.16a16 16 0 1 0-16 0zm8-28a10 10 0 0 1 0 20 10 10 0 0 1 0-20zm-4 36v4h8v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill="none" stroke="#000" stroke-opacity=".3" stroke-width="8" d="M8 72h24V56H8zm16.4 20.28 11.32 11.312L47.032 92.28 35.72 80.968zm0-56.56 11.32 11.312L47.032 35.72 35.72 24.4zM40 64a24 24 0 0 0 48 0 24 24 0 0 0-48 0zm24 56A56 56 0 0 0 64 8v18.672a37.328 37.328 0 0 1 0 74.656z"/><path fill="#f7f5cf" d="M8 72h24V56H8zm16.4 20.28 11.32 11.312L47.032 92.28 35.72 80.968zm0-56.56 11.32 11.312L47.032 35.72 35.72 24.4zM40 64a24 24 0 0 0 48 0 24 24 0 0 0-48 0zm24 56A56 56 0 0 0 64 8v18.672a37.328 37.328 0 0 1 0 74.656z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M12 4c-4.37 0-8 3.63-8 8v28h16V20h88v8h16V12c0-4.37-3.63-8-8-8zm76 28c-4.37 0-8 3.63-8 8s3.63 8 8 8h10.035L63.549 88.236 18.828 43.513 7.516 54.829l50.828 50.828c3.254 3.251 8.737 3.04 11.73-.453L108 60.96v7.039c0 4.37 3.63 8 8 8s8-3.63 8-8v-28c0-4.37-3.63-8-8-8zM4 84v32c0 4.37 3.63 8 8 8h104c4.37 0 8-3.63 8-8V84h-16v24H20V84z"/><path fill="#f7f5cf" d="M12 8a4 4 0 0 0-4 4v24h8V16h96v8h8V12a4 4 0 0 0-4-4zm76 28a4 4 0 0 0 0 8h18.732L63.775 94.119 18.828 49.172l-5.656 5.658 48 48a4 4 0 0 0 5.865-.226L112 50.147v17.854a4 4 0 0 0 8 0v-28a4 4 0 0 0-4-4zM8 88v28a4 4 0 0 0 4 4h104a4 4 0 0 0 4-4V88h-8v24H16V88z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M52 4a12 12 0 0 0-12 12v26.625A38 38 0 0 0 20 76v4h28.578a16 16 0 0 0 30.856 0H108v-4a38 38 0 0 0-20-33.385V16A12 12 0 0 0 76 4zM40.311 82a8 8 0 0 0-4.559 1.055l-10.393 6a8 8 0 0 0 8 13.86l10.394-6A8 8 0 0 0 40.311 82zm47.379 0a8 8 0 0 0-3.441 14.93l10.393 6a8 8 0 0 0 8-13.86l-10.393-6a8 8 0 0 0-4.559-1.054zM64 96a8 8 0 0 0-8 8v12a8 8 0 0 0 16 0v-12a8 8 0 0 0-8-8z"/><path fill="#fff" d="M52 8a8 8 0 0 0-8 8v28.875A40 36 0 0 0 24 76h28a12 12 0 0 0 24 0h28a40 36 0 0 0-20-31.141V16a8 8 0 0 0-8-8zM40.031 86a4 4 0 0 0-2.28.53l-10.392 6a4 4 0 0 0 4 6.929l10.393-6a4 4 0 0 0-1.721-7.453zm47.938 0a4 4 0 0 0-1.721 7.465l10.393 6a4 4 0 0 0 4-6.93l-10.393-6a4 4 0 0 0-2.279-.529zM64 100a4 4 0 0 0-4 4v12a4 4 0 0 0 8 0v-12a4 4 0 0 0-4-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="128" height="128"><path fill-opacity=".294" d="M12 4a8 8 0 0 0-8 8v104a8 8 0 0 0 8 8h64v-16H20V20h88v7.768A36 36 0 0 0 72 89.9V98a9.977 9.977 0 0 0 8 9.8V124h24v-16.2a9.977 9.977 0 0 0 8-9.8v-8.088A36 36 0 0 0 108.477 28H124V12a8 8 0 0 0-8-8H12zm34.432 38.928a8 8 0 0 0 8-13.856l-10.393-6a1 1 0 0 0-8 13.856zM92 44a16 16 0 0 1 0 32 16 16 0 0 1 0-32zm-60 8a8 8 0 0 0 0 16h12a8 8 0 0 0 0-16zm4.039 31.076a8 8 0 0 0 8 13.856l10.393-6a8 8 0 0 0-8.001-13.856z"/><path fill="#f7f5cf" d="M12 8a4 4 0 0 0-4 4v104a4 4 0 0 0 4 4h60v-8H16V16h96v8h8V12a4 4 0 0 0-4-4zm36.558 31.539a4 4 0 0 0 4-6.93L41.91 26.461a4 4 0 0 0-4 6.93zM92 28a32 32 0 0 0-16 59.668V96a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-8.323A32 32 0 0 0 92 28zm0 12a20 20 0 0 1 0 40 20 20 0 0 1 0-40zM31.852 56a4 4 0 0 0 0 8h12.297a4 4 0 0 0 0-8zm6.058 30.61a4 4 0 0 0 4 6.93l10.648-6.148a4 4 0 0 0-4-6.93zM84 112v8h16v-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fff" transform="scale(.01563)"><path d="M105 673v33q407 354 814 0v-33z"/><path fill="#478cbf" d="m105 673 152 14q12 1 15 14l4 67 132 10 8-61q2-11 15-15h162q13 4 15 15l8 61 132-10 4-67q3-13 15-14l152-14V427q30-39 56-81-35-59-83-108-43 20-82 47-40-37-88-64 7-51 8-102-59-28-123-42-26 43-46 89-49-7-98 0-20-46-46-89-64 14-123 42 1 51 8 102-48 27-88 64-39-27-82-47-48 49-83 108 26 42 56 81zm0 33v39c0 276 813 276 814 0v-39l-134 12-5 69q-2 10-14 13l-162 11q-12 0-16-11l-10-65H446l-10 65q-4 11-16 11l-162-11q-12-3-14-13l-5-69z"/><path d="M483 600c0 34 58 34 58 0v-86c0-34-58-34-58 0z"/><circle cx="725" cy="526" r="90"/><circle cx="299" cy="526" r="90"/></g><g fill="#414042" transform="scale(.01563)"><circle cx="307" cy="532" r="60"/><circle cx="717" cy="532" r="60"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><g fill="#fff" transform="matrix(.03 0 0 .03 16.65 21.75)"><path d="M105 673v33q407 354 814 0v-33z"/><path fill="#478cbf" d="m105 673 152 14q12 1 15 14l4 67 132 10 8-61q2-11 15-15h162q13 4 15 15l8 61 132-10 4-67q3-13 15-14l152-14V427q30-39 56-81-35-59-83-108-43 20-82 47-40-37-88-64 7-51 8-102-59-28-123-42-26 43-46 89-49-7-98 0-20-46-46-89-64 14-123 42 1 51 8 102-48 27-88 64-39-27-82-47-48 49-83 108 26 42 56 81zm0 33v39c0 276 813 276 814 0v-39l-134 12-5 69q-2 10-14 13l-162 11q-12 0-16-11l-10-65H446l-10 65q-4 11-16 11l-162-11q-12-3-14-13l-5-69z"/><path d="M483 600c0 34 58 34 58 0v-86c0-34-58-34-58 0z"/><circle cx="725" cy="526" r="90"/><circle cx="299" cy="526" r="90"/></g><g fill="#414042" transform="matrix(.03 0 0 .03 16.65 21.75)"><circle cx="307" cy="532" r="60"/><circle cx="717" cy="532" r="60"/></g><path fill="#fff" fill-opacity=".6" d="M14 5a4 4 0 0 0-4 4v46a4 4 0 0 0 4 4h36a4 4 0 0 0 4-4V22a1 1 0 0 0-.285-.707l-16-16A1 1 0 0 0 37 5zm0 2h22v12a4 4 0 0 0 4 4h12v32a2 2 0 0 1-2 2H14a2 2 0 0 1-2-2V9a2 2 0 0 1 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fff" transform="scale(.01563)"><path d="m105 673 152 14q12 1 15 14l4 67 132 10 8-61q2-11 15-15h162q13 4 15 15l8 61 132-10 4-67q3-13 15-14l152-14V427q30-39 56-81-35-59-83-108-43 20-82 47-40-37-88-64 7-51 8-102-59-28-123-42-26 43-46 89-49-7-98 0-20-46-46-89-64 14-123 42 1 51 8 102-48 27-88 64-39-27-82-47-48 49-83 108 26 42 56 81zm0 33v39c0 276 813 276 814 0v-39l-134 12-5 69q-2 10-14 13l-162 11q-12 0-16-11l-10-65H446l-10 65q-4 11-16 11l-162-11q-12-3-14-13l-5-69zM725 436a90 90 0 0 1 0 180 90 90 0 0 1 0-180zM299 436a90 90 0 0 1 0 180 90 90 0 0 1 0-180zM483 514c0-34 58-34 58 0v86c0 34-58 34-58 0z"/><circle cx="307" cy="532" r="60"/><circle cx="717" cy="532" r="60"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3zm4.5 2.5h1v1h-1zm-4-2v9h3v-1h1v-1h-1v-1h1v-1h-1v-1h1v-1h-1v-1h1v-1h-1v-1zm4 0h1v1h-1zm0 6h1v1h-1zm0-2h1v1h-1zm0 4h1v1h-1zm1-7h1v1h-1zm0 2h1v1h-1zm0 2h1v1h-1zm0 2h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12.5 10.5v-7h-3v1h-1v1h1v1h-1v1h1v1h-1v1h1v1zm-4-1h-1v1h1zm-1 0v-1h-1v1zm0-1h1v-1h-1zm0-1v-1h-1v1zm0-1h1v-1h-1zm0-1v-1h-1v1zm0-1h1v-1h-1zM2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3Zm2.5.5v1h1v-1zm1 1v1h1v-1zm1 0h1v1h-1v1h1v1h1v1h1v-1h1v1h1v-5h-5zm4 4h-1v1h1zm0 1v1h1v-1zm-1 0h-1v1h1zm-1 0v-1h-1v1zm-1-1v-1h-1v1zm-1 0h-1v1h1zm0-1v-1h-1v1zm-1-1v-1h-1v1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M11 1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zM6.732 5A2 2 0 0 1 7 6v1.117L9.268 6A2 2 0 0 1 9 5V3.883zM2 5a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1zm5 3.883V10a2 2 0 0 1-.268 1L9 12.117V11a2 2 0 0 1 .268-1zM11 10a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h3a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="2" fill="#8eef97"/><circle cx="8" cy="8" r="5" fill="none" stroke="#8eef97" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1c-1.108 0-2 .892-2 2v10c0 1.108.892 2 2 2h10c1.108 0 2-.892 2-2V3c0-1.108-.892-2-2-2zm1.25 2h6.5c.692 0 1.25.558 1.25 1.25V5c-1.645 0-3 1.355-3 3s1.355 3 3 3v.75c0 .692-.558 1.25-1.25 1.25h-6.5C3.558 13 3 12.442 3 11.75v-7.5C3 3.558 3.558 3 4.25 3zM12 6a2 2 0 110 4 2 2 0 010-4z" paint-order="stroke markers fill"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M5 2a2 2 0 0 0-2 2h10a2 2 0 0 0-2-2zM3 5v1a3 3 0 0 1 0 6 2 2 0 0 0 2 2h6a2 2 0 0 0 2-2 3 3 0 0 1 0-6V5zm0 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm10 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v14h14V1zm2 2h2v2H3zm4 0h2v2H7zm4 0h2v2h-2zM3 7h2v2H3zm4 0h2v2H7zm4 0h2v2h-2zm-8 4h2v2H3zm4 0h2v2H7zm4 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h2v2H3zm4 0h2v2H7zm4 0h2v2h-2zM3 7h2v2H3zm4 0h2v2H7zm4 0h2v2h-2zm-8 4h2v2H3zm4 0h2v2H7zm4 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-width="1.3" d="M1.87 6.541h2.917v2.917H1.87zm4.666 0h2.917v2.917H6.536zm4.666 0h2.917v2.917h-2.917zm-5.77-5.429-1.95 1.95 1.95 1.95m-1.95-1.95h9.386m-2.137 8.05 1.95 1.95-1.95 1.95m-7.437-1.95h9.387"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M14 2.199v2.615l-2.625 1.313V3.512zM2 6.264l2.625 1.312v2.551L2 8.814zm12 0v2.55l-2.625 1.313V7.576zM6 7.719h4v2.64H6zm-4 2.56 2.625 1.313v2.521L2 12.801zm12 0v2.522l-2.625 1.312v-2.521zm-8 1.455h4v2.641H6zm4-8.109v2.734H5.844s-.749.647-.875.641c-.131-.007-1.51-1.456-1.51-1.456L2 4.814V2.199l.117.06s-.064-.775.424-1.216L1.279.441A.626.626 0 0 0 .375 1v12c0 .237.134.453.346.559l4 2a.626.626 0 0 0 .279.066h6a.626.626 0 0 0 .279-.066l4-2a.625.625 0 0 0 .346-.559V1a.625.625 0 0 0-.904-.559l-3.869 1.934H7.888s.084.624-.218 1.25z"/><path fill="#fff" fill-opacity=".686" d="M5 6.25c-4-3.5-2-6 0-6s4 2.5 0 6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0v2H0v1h2v4H0v1h2v4H0v1h2v2h1v-2h3.125A5.5 5 0 0 1 6 12H3V8h4v1.143a5.5 5 0 0 1 1-.99V8h.223A5.5 5 0 0 1 11.5 7H8V3h4v4h-.5a5.5 5 0 0 1 3.297 1H15V7h-2V3h2V2h-2V0h-1v2H8V0H7v2H3V0H2zm1 3h4v4H3V3zm8.485 5.261c-1.648 0-3.734 1.256-4.485 3.68a.645.645 0 0 0-.004.367C7.721 14.846 9.873 16 11.486 16c1.612 0 3.764-1.154 4.489-3.692a.645.645 0 0 0 0-.356c-.71-2.443-2.842-3.691-4.49-3.691zm0 1.29a2.58 2.58 0 0 1 0 5.16 2.58 2.58 0 0 1 0-5.16zm0 1.29a1.29 1.29 0 0 0 0 2.58 1.29 1.29 0 0 0 0-2.58z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M15 1h-5v6H5v2h5v6h5zM8 1H1v14h7v-4H3V5h5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" fill-opacity=".4" d="M7 1v6H1v8h8V9h6V1zm2 2h4v4H9z"/><path fill="#fff" d="M1 1v2h2V1H1zm12 0v2h2V1h-2zM1 13v2h2v-2H1zm12 0v2h2v-2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill-opacity=".4" d="M0 0v4h4V0zm6 0v6H0v10h10v-6h6V0zm4 4h2v2h-2zm2 8v4h4v-4z"/><path fill="#e0e0e0" d="M7 1v6H1v8h8V9h6V1zm2 2h4v4H9z"/><path fill="#fff" d="M1 1v2h2V1H1zm12 0v2h2V1h-2zM1 13v2h2v-2H1zm12 0v2h2v-2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v10H3zm5 2a3 3 0 0 0 0 6 3 3 0 0 0 0-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".4" stroke-width="2" d="m3 7.9999586 3-3 3 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="#699ce8" rx="2.33"/><path fill="#fff" d="M11.5 3.734 5.89 9.346 4.185 7.665l-1.5 1.499 3.204 3.18L13 5.235z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="gray" rx="2.33"/><path fill="#b3b3b3" d="M11.5 3.734 5.89 9.346 4.185 7.665l-1.5 1.499 3.204 3.18L13 5.235z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fff" stroke-opacity=".898" stroke-width="2" d="m3 3 10 10M3 13 13 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".6" stroke-width="2" d="m4 7 3 3 3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="8"><path fill="#fff" fill-opacity=".4" d="M3.86 0A3.851 3.851 0 0 0 0 3.86v.28A3.851 3.851 0 0 0 3.86 8h6.28A3.851 3.851 0 0 0 14 4.14v-.28A3.851 3.851 0 0 0 10.14 0zM3 3a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"><circle cx="12" cy="12" r="10" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="2" height="64"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-opacity=".4" stroke-width="2" d="M1 2v60"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="#699ce8" rx="2.33"/><path fill="#fff" d="M3 7h10v2H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="gray" rx="2.33"/><path fill="#b3b3b3" d="M3 7h10v2H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M0 0v8h8V0zm8 8v8h8V8z"/><path fill="#fff" d="M8 0v8h8V0zm0 8H0v8h8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m2 4 4 4 4-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="none" stroke="#e0e0e0" stroke-opacity=".4" stroke-width="2" rx="1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="8" height="8" x="4" y="4" fill="#e0e0e0" fill-opacity=".4" ry="1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="7" fill="#699ce8"/><circle cx="8" cy="8" r="4" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="7" fill="gray"/><circle cx="8" cy="8" r="4" fill="#b3b3b3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="7" fill="#e0e0e0" fill-opacity=".2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="7" fill="gray" fill-opacity=".2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".6" stroke-width="2" d="M4 11h7V4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".6" stroke-width="2" d="M4 11V4h7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 14A6 6 0 0 0 8 2a6 6 0 0 0 0 12zM5.293 8.707a1 1 0 0 1 0-1.414l3-3a1 1 0 0 1 1.414 1.414L7.414 8l2.293 2.293a1 1 0 0 1-1.414 1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" fill-opacity=".8" d="M8 14A6 6 0 0 0 8 2a6 6 0 0 0 0 12zM5.293 8.707a1 1 0 0 1 0-1.414l3-3a1 1 0 0 1 1.414 1.414L7.414 8l2.293 2.293a1 1 0 0 1-1.414 1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" fill-opacity=".8" d="M8 2a6 6 0 0 0 0 12A6 6 0 0 0 8 2zm2.707 5.293a1 1 0 0 1 0 1.414l-3 3a1 1 0 0 1-1.414-1.414L8.586 8 6.293 5.707a1 1 0 0 1 1.414-1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 2a6 6 0 0 0 0 12A6 6 0 0 0 8 2zm2.707 5.293a1 1 0 0 1 0 1.414l-3 3a1 1 0 0 1-1.414-1.414L8.586 8 6.293 5.707a1 1 0 0 1 1.414-1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="2" fill="#fff" fill-opacity=".082"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="3" fill="#fff" fill-opacity=".29"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="3" fill="#f9f9f9" fill-opacity=".73"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="3" fill="#b3b3b3" fill-opacity=".729"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="3" fill="#fff" fill-opacity=".9"/><circle cx="8" cy="8" r="6" fill="none" stroke="#e0e0e0" stroke-opacity=".29" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="3" fill="#fff" fill-opacity=".9"/><circle cx="8" cy="8" r="6" fill="none" stroke="#e0e0e0" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><circle cx="4" cy="4" r="1.5" fill="#fff" fill-opacity=".2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m12 2-4 4-4-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m4 6 4-4 4 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m4 6 4-4 4 4m0 4-4 4-4-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#b3b3b3" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m4 6 4-4 4 4m0 4-4 4-4-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><path fill="#fff" fill-opacity=".2" d="M6 0v8h2V0zM1 0a1 1 0 0 0-.693 1.705L2.6 3.998.307 6.291A1 1 0 0 0 1.72 7.705l3-3a1 1 0 0 0 0-1.414l-3-3A1 1 0 0 0 1 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="32"><path fill="#fff" d="m5 2h6v30h-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" fill-opacity=".4" d="M8 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm0 6a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm0 6a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm0 6a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm0 6a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><g fill="#e0e0e0"><rect width="36" height="14" x="1" y="1" fill-opacity=".2" rx="7"/><circle cx="8" cy="8" r="5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><g fill="gray"><rect width="36" height="14" x="1" y="1" fill-opacity=".2" rx="7"/><circle cx="8" cy="8" r="5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><g fill="gray"><rect width="36" height="14" x="1" y="1" fill-opacity=".2" rx="7"/><circle cx="30" cy="8" r="5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><g fill="#e0e0e0"><rect width="36" height="14" x="1" y="1" fill-opacity=".2" rx="7"/><circle cx="30" cy="8" r="5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><rect width="36" height="14" x="1" y="1" fill="#699ce8" rx="7"/><circle cx="30" cy="8" r="5" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><rect width="36" height="14" x="1" y="1" fill="gray" rx="7"/><circle cx="30" cy="8" r="5" fill="#b3b3b3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><rect width="36" height="14" x="1" y="1" fill="gray" rx="7"/><circle cx="8" cy="8" r="5" fill="#b3b3b3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="38" height="16"><rect width="36" height="14" x="1" y="1" fill="#699ce8" rx="7"/><circle cx="8" cy="8" r="5" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".4" stroke-width="2" d="m3 5 3 3 3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".4" stroke-width="2" d="M7 3 4 6l3 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".4" stroke-width="2" d="m5 9 3-3-3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-opacity=".6" stroke-width="2" d="m5 6 3-3 3 3m0 4-3 3-3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="#e0e0e0" fill-opacity=".2" rx="2.333"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="gray" fill-opacity=".2" rx="2.333"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="34"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-opacity=".4" stroke-width="2" d="M32 2V32M2 2h60"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="34" height="64"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-opacity=".4" stroke-width="2" d="M32 32H2m30-30v60"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-opacity=".4" stroke-width="2" d="M32 2v60M2 32h60"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2.96 7.727-1.921.548c.32 1.12.824 2.06 1.432 2.84l-.834.834 1.414 1.414.843-.843c.986.747 2.077 1.206 3.106 1.386V15h2v-1.094c1.029-.18 2.12-.639 3.105-1.386l.844.843 1.414-1.414-.834-.834a8.285 8.285 0 0 0 1.432-2.84l-1.922-.548C12.163 10.79 9.499 12 7.999 12s-4.163-1.209-5.038-4.273z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 2C5.443 2 2.209 3.948 1.045 7.705a1 1 0 0 0 0 .55C2.163 12.211 5.5 14 8 14s5.836-1.789 6.961-5.725a1 1 0 0 0 0-.55C13.861 3.935 10.554 2 8 2zm0 2a4 4 0 0 1 0 8 4 4 0 0 1 0-8zm0 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".4" d="M8 14c2.557 0 5.79-1.948 6.955-5.705a1 1 0 0 0 0-.55C13.837 3.789 10.5 2 8 2v2a4 4 0 0 1 0 8zm0-4a2 2 0 0 0 0-4z"/><path d="M8 2C5.443 2 2.21 3.948 1.045 7.705a1 1 0 0 0 0 .55C2.163 12.211 5.5 14 8 14v-2a4 4 0 0 1 0-8zm0 4a2 2 0 0 0 0 4z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="2"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-opacity=".4" stroke-width="2" d="M2 1h60"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h2v10H3zm4 0h2v10H7zm4 0h2v10h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#8eef97" stroke-width="2"><rect width="12" height="12" x="2" y="2" rx="1"/><path stroke-linecap="round" d="M5 5h2m3 0h1M5 8h0m3 0h3m-6 3h4"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M15 5a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2zm-1 2.988a1 1 0 0 1-.168.567l-2 3a1 1 0 1 1-1.664-1.11L11.797 8l-1.629-2.445a1 1 0 1 1 1.664-1.11l2 3a1 1 0 0 1 .168.543zM6.008 4.99a1 1 0 0 1-.176.565L4.202 8l1.63 2.445a1 1 0 1 1-1.664 1.11l-2-3a1 1 0 0 1 0-1.11l2-3a1 1 0 0 1 1.84.545z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M5 2v3h6V2zM1 7v2h14V7zm4 4v3h6v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M1 11a2 2 0 0 0 4 0 2 2 0 0 0-4 0zm0-5a1 1 0 0 0 2 0V4a1 1 0 0 0-2 0zm5.867 4a4 4 0 0 1 0 2h7.13a1 1 0 0 0 0-2zM7 5a1 1 0 1 0 2 0 1 1 0 0 0-2 0zm6 1a1 1 0 0 0 2 0V4a1 1 0 0 0-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h4v3L5 8l2 2v3H3zm6 0h4v10H9v-3l2-2-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m4 1-3 4h2v3h2v-3h2zm7 0v3h-2l3 4 3-4h-2v-3zm-10 9v2 1 2h1v-2h1v2h1v-5h-1v2h-1v-2zm4 0v1h1v4h1v-4h1v-1zm4 0v1h1v4h1v-4h1v-1zm4 0v2 1 2h1v-2h1 1v-1-2h-2zm1 1h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M2.781 9.155C2.72 9.102 1 7.531 1 5.656 1 3.367 2.398 2 4.734 2 6.102 2 7.383 3.39 8 4c.617-.61 1.898-2 3.266-2C13.602 2 15 3.367 15 5.656c0 1.875-1.719 3.446-1.79 3.516l-4.866 4.687a.485.485 0 0 1-.688 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="7" y2="10" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#a2d2ff"/><stop offset="1" stop-color="#5fb2ff"/></linearGradient><path fill="#5fb2ff" d="m1 10 7 3 7-3-7-3z"/><path fill="url(#a)" d="M3 10c1-1 2-2 2-4s1-3 3-3 3 1 3 3 1 3 2 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 2C6 .7 4 .7 2 2v7c2-1.3 4-1.3 6 0 2-1.3 4-1.3 6 0V2C12 .7 10.2.9 9 1.5V6H8zm-8 8v6h2a3 3 0 0 0 0-6zm5 3a3 3 0 0 0 6 0 3 3 0 0 0-6 0zm9 3h1v-2h-1a1 1 0 0 1 0-2h1v-2h-1a3 3 0 0 0 0 6zM2 12a1 1 0 0 1 0 2zm6 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6.973 7.441a4 4 0 1 0-1.414-1.414L3.293 8.293l1.414 1.414zM9 2a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm-9 8v6h2a3 3 0 1 0 0-6zm5 3a3 3 0 1 0 6 0 3 3 0 0 0-6 0zm6 0a3 3 0 0 0 3 3h1v-2h-1a1 1 0 0 1 0-2h1v-2h-1a3 3 0 0 0-3 3zm-9-1a1 1 0 0 1 0 2zm6 0a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m6.403 1.84-3.69 6.39a4 4 0 0 1 2.349-.068L8.135 2.84a1 1 0 0 0-1.732-1zM4 15h10a1 1 0 0 0 0-2H6.826A3 3 0 1 0 4 15zm0-4a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5 8a4 4 0 1 1 4 4v2a6 6 0 1 0-6-6H1l3 4 3-4zm3-3h2v2h2v2H8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m4 7v-2l-3 3 3 3v-2h8v2l3-3-3-3v2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16"><path fill="#e0e0e0" d="M7 1a2 2 0 0 0-2 2v7.5h-.4a2 2 0 0 0-2-1.5v.8H1v.8h1.6v1.2H1v.8h1.6v.8a2 2 0 0 0 2-1.5H5V13a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h1v.6a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V3h1v10H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="16"><path fill="#e0e0e0" d="M7 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h1v.6a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V3h1v10H7z"/><path fill="none" stroke="#e0e0e0" stroke-linecap="round" d="M3.75 9a1.75 1.75 0 0 1 0-2.5m-1 4a3.5 3.5 0 0 1 0-5.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#4bb7f8" d="M5 3H1v10h4z"/><path fill="#e0e0e0" d="M1.7 3.5v9h2.6v-.8H2.5v-1.3h1.8v-.8H2.5V4.3h1.8v-.8zM7 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h1v.6a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V3h1v10H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2 1a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-12a1 1 0 0 0 -1-1zm1 2h10v8h-10zm6 2-1.5 2.5-.70117 1.168-.099609-.16797-.89844-1.5-.90039 1.5-.90039 1.5h1.8008.19922 1.5996 1.4004 3l-1.5-2.5-1.5-2.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3zm6 2v1H8v1H6v1H5v1H4v1h8V8h-1V6h-1V5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 14a1 1 0 0 0 1 1h9.5a1 1 0 0 0 .707-.293l2.5-2.5A1 1 0 0 0 15 11.5V2a1 1 0 0 0-1-1H4.5a1 1 0 0 0-.707.293l-2.5 2.5A1 1 0 0 0 1 4.5zm1.25-9H11v7H2.25zm10 6V4.75L14 3v6.25zm-1-7.25h-8L5 2h8zM7.675 6l3 4-3 1-1.5-.5-1.75.75-1.75-.75L4.25 8l.875 1.25z"/><path fill-opacity=".4" d="M7.675 6v5L6 10.5l-.875-1.25zM4.25 8v3.25L2.5 10.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M2 2v2h5V2zm5 2v3h2V4zm2-2v2h5V2zM7 9v3h2V9zm-5 3v2h5v-2zm7 0v2h5v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fff97" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m2 8 4 4 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ff5f5f" stroke-linecap="round" stroke-width="2" d="M3 3 13 13M13 3 3 13"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4.729 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541a2 2 0 1 0 2.698-2.75H14V4.729A2 2 0 1 0 11.27 2H4.729zM4 4h8v8H4zm3 3h2v4H7zm0-2h2v1H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1m1 12H7v-2h2v2M4.5 6a3.5 3.4 0 1 1 7 0C11.3 8.9 9 8.5 9 10H7c.1-2.6 2.4-2.8 2.5-4a1.5 1.4 0 0 0-3 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#69c4d4" d="M4.55 5a.85.85 0 0 0-.85.85v7.65a.85.85 0 0 0 .85.85h6.8a.85.85 0 0 0 .85-.85V5.85a.85.85 0 0 0-.85-.85zM8.5 6.2l.282 1.129.345.14.994-.597.707.707-.598.997.143.342L11.5 9.2v1l-1.129.282-.14.344.597.995-.707.707-.997-.598-.343.143-.28 1.127h-1l-.283-1.13-.344-.139-.995.597-.707-.707.598-.997-.143-.343L4.5 10.2v-1l1.13-.282.139-.344-.597-.995.707-.707.997.598.343-.143L7.5 6.2z"/><circle cx="8" cy="9.675" r="1" fill="#69c4d4"/><path fill="#e0e0e0" d="M2 6.36v7.65a1.7 1.7 0 0 0 1.7 1.7h8.5a1.7 1.7 0 0 0 1.7-1.7V6.36h-.85v7.65a.85.85 0 0 1-.85.85H3.7a.85.85 0 0 1-.85-.85V6.36z"/><path fill="none" stroke="#69c4d4" stroke-linecap="round" stroke-width="1.25" d="m10.5 3.6.75-1.5M5.5 3.6l-.75-1.5M8 3.2V1.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5.25 3h2.3A1.15 1.15 0 0 1 8.7 4.15v9.2a1.15 1.15 0 0 1-1.15 1.15h-2.3a1.15 1.15 0 0 1-1.15-1.15v-2.3H1.8A1.15 1.15 0 0 1 .65 9.9V7.6A1.15 1.15 0 0 1 1.8 6.45h2.3v-2.3A1.15 1.15 0 0 1 5.25 3zM6.4 7.025a1.15 1.15 0 0 0 0 3.45 1.15 1.15 0 0 0 0-3.45Z"/><path fill="#69c4d4" d="M8.7 6.3H11a1.15 1.15 0 0 1 1.15 1.15v2.3A1.15 1.15 0 0 1 11 10.9H8.7"/><path stroke="#69c4d4" stroke-linecap="round" stroke-width="1.25" d="m13.25 7.25 1.7-.4m-2.2-1.35 1.3-1.3M11 5l.4-1.7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x1="2" x2="9" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#69c4d4" stop-opacity="0"/><stop offset=".6" stop-color="#69c4d4"/></linearGradient><path fill="#e0e0e0" d="M11.5 16v-1.5a1 1 0 0 0-1-1H10l1.6-4a4 4 0 1 0-3.5-1.4l-2.2 5.4h-.7a1 1 0 0 0-1 1V16z"/><path fill="url(#a)" d="M5.25 12.2 2 4a8 8 0 0 1 7-3 5 5 0 0 0-2.1 7.2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#69c4d4" d="M4.55 5a.85.85 0 0 0-.85.85v7.65a.85.85 0 0 0 .85.85h6.8a.85.85 0 0 0 .85-.85V5.85a.85.85 0 0 0-.85-.85zm.65 1.503h1.75v2.2l2-2.2h2.1L8.166 9.675l2.884 3.172h-2.1l-2-2.2v2.2H5.2z"/><path fill="#e0e0e0" d="M2 6.36v7.65a1.7 1.7 0 0 0 1.7 1.7h8.5a1.7 1.7 0 0 0 1.7-1.7V6.36h-.85v7.65a.85.85 0 0 1-.85.85H3.7a.85.85 0 0 1-.85-.85V6.36z"/><path fill="none" stroke="#69c4d4" stroke-linecap="round" stroke-width="1.25" d="m10.5 3.6.75-1.5M5.5 3.6l-.75-1.5M8 3.2V1.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#69c4d4" fill-opacity=".8" d="M8.5 14.5v-4H9v-4h1.5v4h.5v4z"/><path fill="#e0e0e0" d="M.5 15.5h15v-9a2 2 0 0 0-2-2h-11a2 2 0 0 0-2 2zm1-1v-8h2v4H4v4zm3.5 0v-4h.5v-4H7v4h.5v4zm7 0v-4h.5v-4h2v8zm-3.5 0v-4H9v-4h1.5v4h.5v4z"/><path fill="none" stroke="#e0e0e0" stroke-linecap="square" d="M4.5 4.127a2 2 0 0 0-2-2 2 2 0 0 1-2-2"/><path stroke="#69c4d4" stroke-linecap="round" stroke-width="1.25" d="m11.75 3.3.75-1.5M7.75 3.3 7 1.8m2.75 1.1V1.2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1zm1 0v8h12V3zm0 9v1h5.5v-1zm6.5 0v1H14v-1z"/><path fill="#69c4d4" d="M6.4 3.8a1.7 1.7 0 1 1 3.2 0C8.1 7 8.1 7 9.6 10.2a1.7 1.7 0 1 1-3.2 0C7.9 7 7.9 7 6.4 3.8z" transform="rotate(66 8 7)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3.5 8.5v2.75a4 4 0 0 0 8 0V8.5zm3-1V4a4 4 0 0 0-3 3.5z"/><path fill="none" stroke="#e0e0e0" stroke-linecap="round" d="M7.5 4.127a2 2 0 0 0-2-2H4a2 2 0 0 1-2-2"/><path fill="#69c4d4" d="M11.5 7.5a4 4 0 0 0-3-3.5v3.5z"/><path stroke="#69c4d4" stroke-linecap="round" stroke-width="1.25" d="m12.2 5.5 1.6-.8m-2.5-.75 1.3-1.3m-2.85.4.8-1.6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x1=".5" x2="6" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#69c4d4" stop-opacity="0"/><stop offset=".6" stop-color="#69c4d4"/></linearGradient><path fill="#e0e0e0" d="M6 8v3a4 4 0 0 0 8 0V8a4 4 0 0 0-3-3.873V7.5a1 1 0 0 1-2 0V4.127A4 4 0 0 0 6 8"/><path fill="none" stroke="#e0e0e0" stroke-linecap="round" d="M10 4.127a2 2 0 0 0-2-2H7a2 2 0 0 1-2-2"/><path fill="url(#a)" d="M5 6a4 4 0 0 0-.4 1.5v4a4 4 0 0 0 1.2 2.8l-4 .8q-1.3.26-1.3-2V8q0-1.1 1.3-1.36Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1zm1 0v8h12V3zm0 9v1h5.5v-1zm6.5 0v1H14v-1z"/><path fill="#69c4d4" d="M11.25 4a1.3 1.3 0 1 1 0 2.5 31 31 0 0 0-7.75-.85.4.4 0 1 1 0-.8A31 31 0 0 0 11.25 4zm0 3.5a1.3 1.3 0 1 1 0 2.5 31 31 0 0 0-7.75-.85.4.4 0 1 1 0-.8 31 31 0 0 0 7.75-.85z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1zm1 0v10.75h8V2M8 13.125a.625.625 0 0 0 0 1.5.625.625 0 0 0 0-1.5z"/><path fill="#69c4d4" d="M6 4.1a1.8 1.8 0 1 1 3.3.9 6 6 0 0 0 .3 6.4.6.6 0 1 1-1.2.6A15 15 0 0 1 6 4.1z" transform="rotate(40 8 6.76)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 2a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1zm1 0v10.75h8V2M8 13.125a.625.625 0 0 0 0 1.5.625.625 0 0 0 0-1.5z"/><circle cx="8" cy="6.5" r="1.25" fill="#69c4d4"/><circle cx="8" cy="6.5" r="2.25" fill="none" stroke="#69c4d4" stroke-width=".75"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#69c4d4" d="M4.55 5a.85.85 0 0 0-.85.85v7.65a.85.85 0 0 0 .85.85h6.8a.85.85 0 0 0 .85-.85V5.85a.85.85 0 0 0-.85-.85zM7 7h2.55L8.7 9.55h1.7L7 12.95l.85-2.55h-1.7z"/><path fill="#e0e0e0" d="M2 6.36v7.65a1.7 1.7 0 0 0 1.7 1.7h8.5a1.7 1.7 0 0 0 1.7-1.7V6.36h-.85v7.65a.85.85 0 0 1-.85.85H3.7a.85.85 0 0 1-.85-.85V6.36z"/><path fill="none" stroke="#69c4d4" stroke-linecap="round" stroke-width="1.25" d="m10.5 3.6.75-1.5M5.5 3.6l-.75-1.5M8 3.2V1.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12 1a1 1 0 0 0-.697 1.717l.283.283H9v2h2.586l-.283.283a1 1 0 1 0 1.414 1.414l2-2a1 1 0 0 0 0-1.414l-2-2A1 1 0 0 0 12 1zM3 1a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2z"/><path fill="#5fff97" d="M11 9v2H9v2h2v2h2v-2h2v-2h-2V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 7a1 1 0 0 0 .697-1.717L4.414 5H7V3H4.414l.283-.283a1 1 0 1 0-1.414-1.414l-2 2a1 1 0 0 0 0 1.414l2 2A1 1 0 0 0 4 7zm9 0a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2z"/><path fill="#5fff97" d="M11 9v2H9v2h2v2h2v-2h2v-2h-2V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M9.545 3.627a1 1 0 0 1 2.84 2.818L9.98 8.85a4 4 0 1 0-2.83-2.83zm-5.238 6.664a1 1 0 0 0 1.414 1.414l6-6a1 1 0 0 0-1.414-1.414zm2.148 2.082a2 2 0 0 1-2.84-2.818L6.02 7.15a4 4 0 1 0 2.83 2.828z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 7v6a2 2 0 0 0 2 2h12V7zm4 2h6l-3 4zM.711 4 1 5.98l2.244-.328-.818-1.902L.711 4zm3.694-.539.818 1.902 1.979-.289-.818-1.901zm3.958-.577.818 1.902 1.98-.29-.82-1.9zm3.958-.578.818 1.902 1.714-.25-.288-1.979-2.244.327z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="none" stroke="#5fb2ff" stroke-linecap="round" stroke-width="2" d="M2 6c5 0 3-4 6-4s1 4 6 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><g fill="none" stroke="#5fff95" stroke-linecap="round"><path stroke-width="2" d="m2 6c5 0 3-4 6-4s1 4 6 4"/><circle cx="14" cy="2" r="1.5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="none" stroke="#ffca5f" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m2 6 6-4 6 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><g fill="none" stroke="#fd995f" stroke-linecap="round" stroke-linejoin="round"><path stroke-width="2" d="m2 6 6-4 6 4"/><circle cx="14" cy="2" r="1.5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2 6h3V2h6v4h3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="#fc7f7f" d="M1 1v6h2V1zm2 3.014a1 1 0 0 0 .293.693l2 2a1 1 0 0 0 1.414-1.414L6.414 5h3.172l-.293.293a1 1 0 0 0 1.414 1.414l2-2a1 1 0 0 0 0-1.414l-2-2a1 1 0 0 0-1.414 1.414L9.586 3H6.414l.293-.293a1 1 0 0 0-1.414-1.414l-2 2a1 1 0 0 0-.293.72zm10-3v6h2v-6h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="#c38ef1" d="M9 0 6 2l3 2V3h3a1 1 0 0 1 0 2v2a3 3 0 0 0 0-6H9zM4 1a3 3 0 0 0 0 6h3v1l3-2-3-2v1H4a1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3zm1 1v2h2V4zm3 0v2h2V4zm3 0v2h2V4zM4 7v2h2V7zm3 0v2h2V7zm3 0v2h2V7zm-6 3v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h12V1zm4 2h2a1 1 0 0 1 1 1v2h2a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1h-2v2a1 1 0 0 1-1 1H7a1 1 0 0 1-1-1v-2H4a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h2V4a1 1 0 0 1 1-1z"/><circle cx="8" cy="8" r="1.5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v14h12a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm7 1a2 2 0 0 1 0 4 2 2 0 0 1 0-4zM4 6a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm8 0a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm-4 4a2 2 0 0 1 0 4 2 2 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1zm2 2h2v2h2v2H5v2H3V9H1V7h2zm10.5 0a1.5 1.5 0 0 1 0 3 1.5 1.5 0 0 1 0-3zm-3 3a1.5 1.5 0 0 1 0 3 1.5 1.5 0 0 1 0-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-miterlimit="0"><path d="m10.875 3.1593h2.7749v2.9127" transform="matrix(1.1315 0 0 1.1398 -.914 -1.888)"/><path d="m4.9883 14.191h-2.7749v-2.9127" transform="matrix(1.1315 0 0 1.1398 -1.035 -1.888)"/></g><path fill="#e0e0e0" d="m11.509 10.223-1.1866 1.1424 2.0978 2.0196-1.5046 1.4485h4.1955v-4.0392l-1.5046 1.4485-2.0978-2.0196zm-10.592-9.0557v4.0897l1.5233-1.4666 2.124 2.0448 1.2014-1.1566-2.124-2.0448 1.5233-1.4666h-4.2479z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 7v2h1v2h3V9h2.133a4 4 0 1 0 0-2zm10-1a2 2 0 0 1 0 4 2 2 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#a448f0" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#eae440" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.1" height="6.1" x="1.95" y="1.95" fill="#2877f6" ry=".763" transform="rotate(-45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><path fill="#e0e0e0" d="M7.762 3.434a.8.8 45 0 1 0 1.132L4.566 7.762a.8.8 45 0 1-1.132 0L.238 4.566a.8.8 45 0 1 0-1.132L3.434.238a.8.8 45 0 1 1.132 0zM4.354.974a.5.5 45 0 0-.708 0L.974 3.646a.5.5 45 0 0 0 .708l2.672 2.672a.5.5 45 0 0 .708 0l2.672-2.672a.5.5 45 0 0 0-.708z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><rect width="4.96" height="4.96" x="1.52" y="1.52" fill="#e0e0e0" rx=".6" transform="rotate(45 4 4)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><rect width="4.96" height="4.96" x="1.52" y="1.52" fill="#5fb2ff" ry=".6" transform="rotate(45 4 4)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#5ad5c4" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#3cf34e" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="10" height="10" fill="#5fb2ff" rx="1"/><rect width="5.6" height="5.6" x="2.1" y="2.1" fill="#003e7a" rx=".5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><path fill="none" stroke="#ff5f5f" stroke-width="2" d="m1 1 6 6M1 7 7 1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fff97" d="m11 9v2h-2v2h2v2h2v-2h2v-2h-2v-2z"/><path fill="#e0e0e0" d="m11 1a4 4 0 0 0 -3.8691 3h-6.1309v2h1v2h3v-2h2.1328a4 4 0 0 0 2.8672 2.8691v-.86914h3.6387a4 4 0 0 0 1.3613-3 4 4 0 0 0 -4-4zm0 2a2 2 0 0 1 2 2 2 2 0 0 1 -2 2 2 2 0 0 1 -2-2 2 2 0 0 1 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.226 3.46a.76.76 0 0 0 0 1.078L7.46 7.775a.76.76 0 0 0 1.078 0l3.236-3.236a.76.76 0 0 0 0-1.078L8.54.225a.76.76 0 0 0-1.08 0zM8 9a3 3 0 0 0 0 6 3 3 0 0 0 0-6zm0 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm5-2a1 1 0 0 0 0 4h-2v2h2a1 1 0 0 0 0-4h2V9zM0 9h2a2.7 2.7 0 0 1 0 5.4V16H0zm2 3.7a1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.226 3.46a.76.76 0 0 0 0 1.078L7.46 7.775a.76.76 0 0 0 1.078 0l3.236-3.236a.76.76 0 0 0 0-1.078L8.54.225a.76.76 0 0 0-1.08 0zM11 7v5a3 3 0 0 0 3 3h1v-2h-1a1 1 0 0 1-1-1v-1h2V9h-2V7zm0 5a3 3 0 0 0-6 0 3 3 0 0 0 6 0zM4 9a3 3 0 0 0-3 3v3h2v-3a1 1 0 0 1 1-1h1V9zm4 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.226 3.46a.76.76 0 0 0 0 1.078L7.46 7.775a.76.76 0 0 0 1.078 0l3.236-3.236a.76.76 0 0 0 0-1.078L8.54.225a.76.76 0 0 0-1.08 0zM11 7v5a3 3 0 0 0 3 3h1v-2h-1a1 1 0 0 1-1-1V7zM3 9a2 2 0 1 0 0 4H1v2h2a2 2 0 1 0 0-4h2V9zm6 0a3 3 0 1 0 0 6h1v-2H9a1 1 0 0 1 0-2h1V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="7.5" height="7.5" x="1.25" y="1.25" fill="#5fb2ff" ry="1" transform="rotate(45 5 5)"/><rect width="4.2" height="4.2" x="2.9" y="2.9" fill="#003e7a" ry=".5" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><path fill="#5ad5c4" d="M4.523 1.134A3.909 3.909 0 0 0 .656 5.033a3.909 3.909 0 0 0 3.117 3.816l.18-1.27a2.607 2.607 0 0 1-2.018-2.546 2.608 2.608 0 0 1 2.54-2.616h.2l.18-1.28zM6.2 1.15 6 2.45h1.35a.1.1 0 0 1 .1.1v5a.1.1 0 0 1-.1.1H5.3l-.2 1.3h2.25a1.4 1.4 0 0 0 1.4-1.4v-5a1.4 1.4 0 0 0-1.4-1.4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><g fill="#ea7940"><circle cx="5" cy="5" r="1.25"/><path d="M5 .625a.625.625 0 0 0-.432.182l-1.25 1.25.884.884.808-.808.808.808.884-.884-1.25-1.25A.625.625 0 0 0 5 .625zM2.068 3.307l-1.25 1.25a.625.625 0 0 0 0 .884l1.25 1.25.884-.884-.808-.808.808-.808-.884-.884zm5.884 0-.884.884.808.808-.808.808.884.883 1.25-1.25a.625.625 0 0 0 0-.883l-1.25-1.25zm-3.75 3.75-.884.884 1.25 1.25a.625.625 0 0 0 .884 0l1.25-1.25-.884-.884-.808.808-.808-.808z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><g fill="#ff2b88"><circle cx="5" cy="5" r="1.25"/><path d="M5 .625a4.375 4.375 0 0 0-3.114 7.499h-.692v1.25h2.5a.625.625 0 0 0 .607-.777l-.625-2.5-1.213.304.175.7a3.125 3.125 0 1 1 4.514.106l.885.885A4.375 4.375 0 0 0 5 .625z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><g fill="#eac840"><circle cx="5" cy="5" r="1.25"/><path d="M5.625.625a.625.625 0 0 0 0 1.25h1.616l-.808.808.884.884.808-.808v1.616a.625.625 0 0 0 1.25 0V1.25A.625.625 0 0 0 8.75.625zm-3.75 5a.625.625 0 0 0-1.25 0V8.75a.625.625 0 0 0 .625.625h3.125a.625.625 0 0 0 0-1.25H2.759l.808-.808-.884-.884-.808.808V5.625z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#e0e0e0" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="8" height="8" x="1" y="1" fill="#e0e0e0" rx="1" ry="1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#ea7940" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#ff2b88" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.2" height="6.2" x="1.9" y="1.9" fill="#eac840" ry=".75" transform="rotate(45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6.584 5.135 6.17 4.059l-.412 1.076h.826zm3.203 2.976a.95 1.06 0 0 0 0 2.14.95 1.06 0 0 0 0-2.14zM4 2a1 1 0 0 0-1 1v9a1 1 0 0 0 .995 1h8a1 1 0 0 0 1-1V3A1 1 0 0 0 12 2.007H4Zm1.475.646H6.89l1.865 4.27H7.268l-.286-.744H5.36l-.287.744H3.61l1.866-4.27Zm2.939 8.401a2.42 2.24 0 1 1 2.41.168c.296.465.837-.109 1.06-.007l.544.642c-.64.756-1.883.677-2.605.084-.394-.448-.866-.673-1.409-.887ZM1 4v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-1v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="M4 2a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1H4Zm4.223 1.262c1.06.005 2.29.257 2.92 1.197.532.862.275 2.057-.484 2.703-.346.382-.862.629-1.075 1.117.055.345-.33.172-.537.213H7.148c-.037-.749.503-1.335 1.026-1.796.406-.253.744-1.002.129-1.22-.626-.25-1.374.117-1.645.715l-2.08-1.039c.599-1.147 1.868-1.818 3.136-1.872.17-.013.339-.018.509-.018Zm.127 5.697c.798-.057 1.616.616 1.54 1.45-.023.81-.841 1.413-1.623 1.328-.833.022-1.6-.771-1.443-1.613.097-.721.83-1.195 1.526-1.165zM1 4v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-1v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 1.977a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-9a1 1 0 0 0-1-1zm5.8 2 .58.58-.58.58-.58-.58zm-.6 1 .6.6-.6.6-.6-.6zm1.2 0 .6.6-.6.6-.6-.6zm.717 1.436h1.06c.053.217.093.428.122.63.028.201.043.395.043.58a2.363 2.363 0 0 1-.133.724 1.425 1.425 0 0 1-.31.515c-.249.265-.598.399-1.05.399-.331 0-.594-.08-.785-.235a1.091 1.091 0 0 1-.236-.275c-.063.1-.14.19-.236.265-.206.163-.467.245-.787.245-.252 0-.457-.057-.614-.166a2.75 2.75 0 0 1-.095.42 1.936 1.936 0 0 1-.403.722c-.2.22-.452.383-.756.49-.303.11-.654.166-1.052.166-.466 0-.865-.089-1.2-.265a1.817 1.817 0 0 1-.765-.752c-.18-.327-.27-.715-.27-1.164 0-.256.027-.525.082-.809.055-.284.126-.545.21-.781h1.001c-.062.232-.112.46-.15.684a3.87 3.87 0 0 0-.053.613c0 .37.1.643.3.82.204.177.523.264.96.264.222 0 .425-.03.61-.092a.97.97 0 0 0 .439-.299.803.803 0 0 0 .166-.521 5.463 5.463 0 0 0-.051-.725 11.61 11.61 0 0 0-.068-.482A26.51 26.51 0 0 0 7 6.778h1.135l.043.276c.047.32.123.532.228.634.105.1.24.15.402.15.165 0 .284-.04.358-.124.076-.086.115-.224.115-.412v-.524h1.027v.524c0 .203.032.351.096.447.065.095.202.142.412.142a.637.637 0 0 0 .33-.078c.089-.052.133-.15.133-.297 0-.128-.019-.295-.054-.498zM1 4v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-1v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 2a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1ZM1 4v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-1v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Zm5.762-.232h2.476l3.264 7.464H9.898l-.502-1.3H6.561l-.502 1.3H3.498Zm1.217 2.474L7.254 8.12h1.45z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#99c4ff" d="m8 10-2.75 4 1.75 1zm.5-4 .5-4.5-1.75 1zm-7.75 0 2.5 5 5-2.5-2.5-5zm1.33.44 3.2-1.6 1.6 3.2-3.2 1.6zm6.92.56v6h6v-6zm1 1h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffa6bd" d="m8 10-2.75 4 1.75 1zm.5-4 .5-4.5-1.75 1zm-7.75 0 2.5 5 5-2.5-2.5-5zm1.33.44 3.2-1.6 1.6 3.2-3.2 1.6zm6.92.56v6h6v-6zm1 1h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M6 3a1 1 0 0 0-.707.293l-4 4a1 1 0 0 0 0 1.414l4 4A1 1 0 0 0 6 13h8a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H6zM5 7a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M6 3a1 1 0 0 0-.707.293l-4 4a1 1 0 0 0 0 1.414l4 4A1 1 0 0 0 6 13h8a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1H6zM5 7a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="#8eef97" d="M6 3a1 1 0 0 0-.707.293l-4 4a1 1 0 0 0 0 1.414l4 4A1 1 0 0 0 6 13h2.184C7.25 10.75 9.75 8.75 11.25 6.5a.85.85 0 0 1 1.5 0c1.5 2.25 2 2.5 2.25 3V4a1 1 0 0 0-1-1H6zM5 7a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/><path fill="url(#a)" d="M12 7c-.429.746-.946 1.387-1.429 2-.571.69-1.066 1.342-1.34 2-.138.326-.231.656-.231 1s.072.686.184 1c.413 1.163 1.512 2 2.816 2s2.402-.837 2.816-2c.112-.314.184-.656.184-1s-.094-.674-.231-1c-.275-.658-.77-1.31-1.34-2-.484-.613-1-1.254-1.43-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M6 10.576V13h4v-2.42a5 5 0 1 0-4 0zM8 9a3 3 0 0 1 0-6zm-1 5v1h2v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m2 1v2h12v-2zm-1 3v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2v-9zm2 1h1v1h-1zm3 0h1v1h-1zm3 0h1v1h-1zm3 0h1v1h-1zm-9 2h10v6h-10zm3 1v1h4v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v2h2v-2zm3 0v2h2v-2zm4 0v2h6v-2zm-7 3v2h2v-2zm3 0v2h2v-2zm4 0v3h5v6h-5v2h5a2 2 0 0 0 2-2v-9zm1 1h1v1h-1zm3 0h1v1h-1zm-11 2v2h2v-2zm3 0v2h2v-2zm4 1v1h2v-1zm-7 2v2h2v-2zm3 0v2h2v-2zm-3 3v2h2v-2zm3 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M1 9h3V7H1zm2.05 2.535 1.415 1.414 1.414-1.414-1.414-1.414zm0-7.07 1.415 1.414 1.414-1.414L4.465 3.05zM5 8a3 3 0 0 0 6 0 3 3 0 0 0-6 0zm3 7A7 7 0 0 0 8 1v2.334a1 1 0 0 1 0 9.332z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-width="2" d="m2 10 8-8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#8da5f3" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m2 9 3 4L8 3l3 6 3-2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M2 4v5h2V4zm-1 7a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M6 3a5 5 0 0 0 0 10h1v-2H6a3 3 0 0 1 0-6h1V3zm3 0v2h1a3 3 0 0 1 0 6H9v2h1a5 5 0 0 0 0-10zM6 7a1 1 0 0 0 0 2h4a1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path stroke="#fff" stroke-width=".6" d="M2.08 8.2v1.907h2.465l-4.02 4.02 1.347 1.349 4.021-4.021v2.465H7.8V9.153a.953.953 0 0 0-.953-.953z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v14h8.2578l-.82227-2h-5.4355v-2h4.6113l-.82227-2h-3.7891v-2h3.8867a1.5002 1.5002 0 0 1 1.0977-.49805v-.0019531a1.5002 1.5002 0 0 1 .58594.11133l.94531.38867h.48438v.19922l2 .82227v-7.0215h-11zm2 2h7v2h-7zm5 5 3.291 8 .94726-2.8203 1.8828 1.8828.94336-.94141-1.8848-1.8828 2.8203-.94726-8-3.291z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 2a2 2 0 0 0-2 2v9a2 2 0 0 0 2 2h9c1.105 0 1.818-.91 2-2l1-6a1 1 0 0 0-1-1H6c-.552 0-.909.455-1 1l-1 6c-.091.545-.448 1-1 1a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1 1 1 0 0 0 1 1h5a1 1 0 0 0-1-1H7a2 2 0 0 0-2-2H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M9 5c-4 0-4 6 0 6h2v-6zm0 4c-1.3333 0-1.3333-2 0-2zM14 5c-1.6569 0-3 1.3431-3 3v3h2v-3c0-.55228.44772-1 1-1h1v-2z"/><path d="m1 5v6h2c1.6569 0 3-1.3431 3-3v-3h-2v3c0 0.55228-0.44772 1-1 1v-4z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M13 6A5 5 0 0 0 3 6v2H2v7h12V8h-1V6zM5 6a3 3 0 0 1 6 0v2H5zm2 4h2v3H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill-opacity=".392" d="M2 6v1H1v9h14V7h-1V6A6 6 0 0 0 2 6zm8 0v1H6V6a1 1 0 0 1 4 0z"/><path fill="#e0e0e0" d="M3 6v2H2v7h12V8h-1V6A5 5 0 0 0 3 6zm8 0v2H5V6a3 3 0 0 1 6 0zm-4 4h2v3H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="187" height="69"><path fill="#fff" d="M96.116 30.781c-1.847-.029-3.96.356-3.96.356v3.605h2.125l-.024 1.606q0 .893-1.767.894-1.767-.001-3.12-1.493-1.358-1.495-1.356-4.372 0-2.884 1.32-4.255 1.32-1.372 3.448-1.372a6.3 6.3 0 0 1 1.852.292q.96.291 1.287.546c.217.176.422.258.618.258q.29.002.94-.685.654-.687 1.169-2.074c.342-.929.514-1.64.514-2.145 0-.501-.011-.847-.034-1.029q-.72-.788-2.66-1.252-1.936-.464-4.338-.463-5.282 0-8.265 3.327-2.986 3.328-2.985 8.644 0 6.244 3.051 9.467 3.055 3.224 8.028 3.223 2.674 0 4.75-.463 2.075-.462 2.762-.943l.137-10.734c0-.623-1.646-.906-3.492-.938m17.018-5.01q-1.645 0-2.762 1.509-1.114 1.509-1.114 4.234 0 2.73 1.064 4.186 1.063 1.46 2.795 1.46t2.812-1.478q1.081-1.473 1.082-4.218c.001-2.745-.373-3.237-1.116-4.22q-1.114-1.473-2.761-1.473m-.017 18.074q-4.819 0-7.856-3.153-3.033-3.156-3.033-9.21 0-6.056 3.068-9.178 3.07-3.12 7.924-3.12 4.854-.002 7.837 3.072c1.991 2.045 2.985 5.146 2.985 9.294q0 6.224-3.053 9.263-3.053 3.032-7.872 3.032M133.71 26.01v10.26q0 .717.104.907.103.189.616.189 1.888 0 2.865-1.408.978-1.404.976-4.68-.001-3.278-1.01-4.27-1.013-.996-3.208-.998zm-6.585 15.917V21.348q-.001-.858.43-1.359.427-.496 1.114-.497h5.728q5.454.001 8.281 2.747 2.832 2.742 2.832 8.642 0 12.622-10.772 12.622h-5.864q-1.749.001-1.75-1.577m31.623-16.155q-1.648 0-2.763 1.509-1.113 1.509-1.113 4.234 0 2.73 1.063 4.186 1.062 1.46 2.795 1.46c1.733 0 2.093-.492 2.813-1.478q1.08-1.473 1.081-4.218c.001-2.745-.372-3.237-1.115-4.22q-1.114-1.473-2.761-1.473m-.018 18.074q-4.819 0-7.854-3.153-3.036-3.156-3.036-9.21 0-6.056 3.069-9.178 3.07-3.12 7.925-3.12 4.853-.002 7.837 3.072c1.99 2.045 2.984 5.146 2.984 9.294q0 6.224-3.053 9.263-3.053 3.032-7.872 3.032m23.773-.842c0 .454-1.13.685-3.395.685q-3.396-.001-3.397-.685v-17.22h-4.115q-.584.001-.823-1.58a11 11 0 0 1-.101-1.542q-.001-.787.1-1.543c.16-1.05.435-1.58.824-1.58h14.92q.584.002.825 1.58a11.6 11.6 0 0 1 0 3.086q-.242 1.58-.824 1.579h-4.014z"/><path fill="#e0e0e0" d="M88.866 57.973q-.284.585-1.048 1.069-.764.486-1.942.486-1.554.002-2.503-.987-.946-.983-.947-2.833v-3.073q0-1.808.895-2.776c.596-.64 1.395-.966 2.392-.966q1.462.002 2.265.764.8.765.837 2.128l-.013.04h-.796q-.041-1.042-.61-1.612-.568-.565-1.683-.566-1.128 0-1.782.765-.652.762-.651 2.215v3.091q0 1.507.702 2.3.701.785 1.894.785.873.001 1.398-.313.526-.312.732-.763v-2.692h-2.144v-.748h3.004zm3.95.789q.708.001 1.26-.406.55-.41.777-1.04v-1.661H93.49q-.87 0-1.393.493a1.6 1.6 0 0 0-.522 1.22q0 .616.327 1.006.327.389.915.388m2.165.62a20 20 0 0 1-.097-.652 4 4 0 0 1-.03-.518 3 3 0 0 1-.906.945q-.555.374-1.238.373-.952 0-1.47-.591-.517-.594-.518-1.603 0-1.07.751-1.707.753-.636 2.038-.636h1.342v-.943q-.001-.815-.41-1.28-.415-.457-1.152-.459-.687 0-1.133.441a1.46 1.46 0 0 0-.442 1.078l-.797-.007-.014-.042q-.033-.865.659-1.544.69-.678 1.77-.677 1.064 0 1.719.646.65.653.651 1.86v3.767q0 .412.037.795a5 5 0 0 0 .127.753zm3.415-7.698.072 1.191a2.46 2.46 0 0 1 .808-.989q.505-.345 1.186-.345.697 0 1.17.408.475.408.697 1.237.284-.766.805-1.207.524-.438 1.259-.438 1.01 0 1.566.818.557.819.557 2.518v4.485h-.857v-4.5q-.001-1.413-.384-1.987-.383-.573-1.093-.574-.745-.002-1.165.637-.417.639-.511 1.605v4.82h-.853v-4.497q0-1.381-.393-1.97a1.25 1.25 0 0 0-1.096-.59q-.674.001-1.083.409t-.585 1.119v5.528h-.853v-7.679zm12.414.61q-.801 0-1.317.73c-.516.73-.522 1.089-.536 1.805h3.542v-.328q0-.952-.446-1.58-.449-.628-1.243-.627m.12 7.218q-1.24 0-2.03-.933-.787-.931-.787-2.382V54.92q0-1.454.79-2.42.792-.96 1.907-.959 1.206 0 1.872.858.67.86.67 2.31v.842h-4.395v.639q0 1.115.532 1.856.534.741 1.442.74.631 0 1.09-.22a2.25 2.25 0 0 0 .783-.632l.349.604a2.5 2.5 0 0 1-.9.708q-.548.264-1.322.265m9.375-7.218q-.804 0-1.32.73-.512.73-.535 1.805h3.543V54.5q0-.952-.447-1.58-.446-.629-1.241-.627m.12 7.218q-1.243 0-2.03-.933-.79-.932-.79-2.382V54.92q.001-1.454.79-2.42.794-.96 1.91-.959 1.205 0 1.872.858.668.86.668 2.31v.842h-4.395v.639q0 1.115.535 1.856.53.741 1.44.74.632 0 1.088-.22a2.3 2.3 0 0 0 .787-.632l.347.604a2.5 2.5 0 0 1-.9.708q-.548.264-1.322.265m4.684-7.828.07 1.269q.306-.677.814-1.044a1.97 1.97 0 0 1 1.19-.368q1.028 0 1.576.763.552.764.551 2.374v4.684h-.858v-4.677q0-1.314-.384-1.845-.382-.534-1.113-.533-.655-.001-1.095.43-.441.426-.66 1.144v5.481h-.852v-7.678zm6.72 4.523q0 1.17.447 1.86.445.697 1.348.696.617.001 1.044-.335.424-.338.673-.935V53.69q-.24-.614-.655-.994-.415-.376-1.047-.377-.902 0-1.355.786-.456.79-.455 2.053zm-.86-1.05q0-1.631.66-2.62.659-.984 1.825-.984c.43 0 .81.105 1.132.316.324.207.592.51.807.895l.083-1.068h.723v7.686q0 1.475-.686 2.286c-.46.537-1.111.81-1.953.81q-.454-.001-.976-.14a4 4 0 0 1-.927-.365l.236-.748a2.9 2.9 0 0 0 .774.347 3 3 0 0 0 .879.124q.916 0 1.355-.587.44-.592.44-1.727v-.93a2.3 2.3 0 0 1-.802.795 2.15 2.15 0 0 1-1.1.276q-1.157 0-1.813-.906-.657-.905-.658-2.41zm8.12 4.226h-.862v-7.7h.862zm0-9.892h-.862v-1.213h.862zm2.782 2.193.07 1.269q.307-.677.813-1.044a2 2 0 0 1 1.19-.368q1.03 0 1.58.763.55.764.549 2.374v4.684h-.858v-4.677q0-1.314-.384-1.845-.383-.534-1.114-.533-.654-.001-1.093.43-.441.426-.66 1.144v5.481h-.853v-7.678zm8.499.61q-.804 0-1.317.73-.514.73-.537 1.805h3.543V54.5q0-.952-.446-1.58-.447-.629-1.243-.627m.122 7.218q-1.245 0-2.03-.933-.789-.932-.788-2.382V54.92q0-1.454.79-2.42.792-.96 1.906-.959 1.207 0 1.875.858.666.86.667 2.31v.842h-4.396v.639q.002 1.115.534 1.856.531.741 1.442.74.63 0 1.087-.22a2.25 2.25 0 0 0 .787-.632l.348.604a2.5 2.5 0 0 1-.9.708q-.548.264-1.322.265"/><g fill="#fefefe" transform="translate(-2.69 -2.69)scale(.0727)"><path d="M105 673v33q407 354 814 0v-33z"/><path fill="#478cbf" d="m105 673 152 14q12 1 15 14l4 67 132 10 8-61q2-11 15-15h162q13 4 15 15l8 61 132-10 4-67q3-13 15-14l152-14V427q30-39 56-81-35-59-83-108-43 20-82 47-40-37-88-64 7-51 8-102-59-28-123-42-26 43-46 89-49-7-98 0-20-46-46-89-64 14-123 42 1 51 8 102-48 27-88 64-39-27-82-47-48 49-83 108 26 42 56 81zm0 33v39c0 276 813 276 814 0v-39l-134 12-5 69q-2 10-14 13l-162 11q-12 0-16-11l-10-65H446l-10 65q-4 11-16 11l-162-11q-12-3-14-13l-5-69z"/><path d="M483 600c0 34 58 34 58 0v-86c0-34-58-34-58 0z"/><circle cx="725" cy="526" r="90"/><circle cx="299" cy="526" r="90"/></g><g fill="#414042" transform="translate(-2.69 -2.69)scale(.0727)"><circle cx="307" cy="532" r="60"/><circle cx="717" cy="532" r="60"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="m5.742 11.508c.916-2.959 3.507-4.508 5.592-4.508.803 0 1.673.223 2.492.658.297-.182.563-.423.768-.731.754-1.134.446-2.665-.688-3.419-.309-.205-.66-.338-1.026-.389-.188-1.349-1.433-2.291-2.782-2.103s-2.29 1.433-2.103 2.782c.051.367.184.717.389 1.026l-3.56 3.56c-1.134-.754-2.665-.446-3.419.688s-.446 2.664.688 3.419c.308.205.659.338 1.026.389.188 1.349 1.433 2.29 2.782 2.103.342-.048.658-.164.936-.333-.467-.612-.856-1.337-1.102-2.206-.085-.3-.085-.617.007-.936z"/><path d="m11.334 8c-1.704 0-3.861 1.299-4.637 3.804-.034.119-.034.246 0 .366.745 2.638 2.97 3.83 4.637 3.83s3.891-1.192 4.641-3.816c.034-.12.034-.247 0-.367-.734-2.526-2.938-3.817-4.641-3.817zm0 6.667c-1.473 0-2.667-1.194-2.667-2.667s1.194-2.666 2.667-2.666 2.667 1.193 2.667 2.666-1.194 2.667-2.667 2.667z"/><circle cx="11.334" cy="12" r="1.333"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1v2H6a5 5 0 0 0-4 8l1.414-1.414A3 3 0 0 1 6 5h2v2l4-3-4-3zm6 4-1.414 1.414A3 3 0 0 1 10 11H8V9l-4 3 4 3v-2h2a5 5 0 0 0 4-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12 14a2 2 0 0 0 2 2h1v-2h-.5a.5.5 0 0 1-.5-.5V8a6 6 0 1 0-2 4.465zM8 3a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm3.441 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM4.488 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm.024 4a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6.904 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM8 11a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="2" d="M4 12V4l7 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="11" height="10" x="1" y="5" fill="#919191" rx="1.5"/><path fill="#e0e0e0" d="M5.5 1A1.5 1.5 0 0 0 4 2.5V3h11v-.5A1.5 1.5 0 0 0 13.5 1zM4 4v5.5A1.5 1.5 0 0 0 5.5 11h8A1.5 1.5 0 0 0 15 9.5V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3zm1 3v4l2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="-959.5 540.5 10 10"><path fill="#e0e0e0" d="m-954.5 550-3-3v-6h6v6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m7 1v4h2v-4zm-6 6v2h4v-2zm10 0v2h4v-2zm-4 4v4h2v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m7 1v4h2v-4zm-6 6v2h4v-2zm10 0v2h4v-2zm-4 4v4h2v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="-959.5 540.5 10 10"><path fill="#5fb2ff" d="m-952 541.5v5.086l-2.5 2.5-2.5-2.5v-5.086zm1-1h-7v6.5l3.5 3.5 3.5-3.5z"/><path fill="#003e7a" d="m-957 546.586 2.5 2.5 2.5-2.5v-5.086h-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 1a4 4 0 0 0-4 4v10h2v-4h4v4h2V5a4 4 0 0 0-4-4zm5 11a3 3 0 0 0 4 2.824V15h2V9a3 3 0 0 0-3-3h-1v2h1a1 1 0 0 1 1 1v.174A3 3 0 0 0 9 12zM4 3a2 2 0 0 1 2 2v4H2V5a2 2 0 0 1 2-2zm8 8a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m8 1 7 3v8l-7 3-7-3V4z"/><path fill="#d6d6d6" d="M8 1 1 4v8l7 3 7-3V4z"/><path fill="#f9f9f9" d="m1 4 7 3 7-3-7-3z"/><path fill="#e0e0e0" d="m8 15-7-3V4l7 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2"><path d="M7 1v2h2V1zM3.758 2.344 2.344 3.758l1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM8 4a4 4 0 0 0 0 8 4 4 0 0 0 0-8zM1 7v2h2V7zm12 0v2h2V7zm-9.242 3.828-1.414 1.414 1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 13v2h2v-2z"/><circle cx="8" cy="8" r="3.5" fill="#000"/></g><path fill="#f9f9f9" d="M7 1v2h2V1zM3.758 2.344 2.344 3.758l1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM8 4a4 4 0 0 0 0 8 4 4 0 0 0 0-8zM1 7v2h2V7zm12 0v2h2V7zm-9.242 3.828-1.414 1.414 1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 13v2h2v-2zm1-7.875a.75.75 0 0 1 1.145.625V11h-1.5V7.152l-1 .667-.75-1.2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2"><path d="M7 1v2h2V1zM3.758 2.344 2.344 3.758l1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM8 4a4 4 0 0 0 0 8 4 4 0 0 0 0-8zM1 7v2h2V7zm12 0v2h2V7zm-9.242 3.828-1.414 1.414 1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 13v2h2v-2z"/><circle cx="8" cy="8" r="3.5" fill="#000"/></g><path fill="#f9f9f9" d="M7 1v2h2V1zM3.758 2.344 2.344 3.758l1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM8 4a4 4 0 0 0 0 8 4 4 0 0 0 0-8zM1 7v2h2V7zm12 0v2h2V7zm-9.242 3.828-1.414 1.414 1.414 1.414 1.414-1.414zm8.484 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 13v2h2v-2zM5.9 6.45a1.98 1.98 0 1 1 3.4 1.8L8.05 9.5h2V11H6.8a.9.9 0 0 1-.75-1.5L8.3 7.25a.62.62 0 1 0-1.1-.45z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m2 1 12 1v11l-12 1z"/><path fill="#f9f9f9" d="m2 14 12-1v-11l-12-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="8" fill-opacity=".8"/><path fill="#e0e0e0" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zM6 7a2 2 0 0 1 0-4 2 2 0 0 1 0 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="1.493" d="M13.821 12.756c-5 3.915-12.551 2.248-12.49-4.538.674-11.471 17.312-7.45 12.446 2.117-.8 1.196-2.074 1.462-3.198.433-.3-.3-.448-1.16-.382-1.509.4-1.894 1.088-4.078-.722-4.723-2.417-.865-4.559 1.65-4.97 4.02-.473 2.734 2.285 3.374 4.15 1.987.455-.363 1.55-1.38 1.68-1.974"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12.5 3.67a5 5 0 1 0 0 8.66l-1-1.73a3 3 0 1 1 0-5.2zM3 11a1 1 0 1 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M9 6c-1.33 2.67-1.33 4.33 0 7h2c-1.33-2.67-1.33-4.33 0-7zm4 0c1.33 2.67 1.33 4.33 0 7h2c1.33-2.67 1.33-4.33 0-7zM1 11a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm6 2v-2H6a1 1 0 0 1 0-2h1V7H6a3 3 0 0 0 0 6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6.021 3A3 3 0 0 0 3 6v7h2v-3h2V8H5V6a1 1 0 0 1 1.707-.707l1.414-1.414A3 3 0 0 0 6.021 3zM9 6c-1.326 2.659-1.34 4.325 0 7h2c-1.34-2.675-1.326-4.341 0-7zm4 0c1.326 2.659 1.34 4.325 0 7h2c1.34-2.675 1.326-4.341 0-7zM1 11a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M9 6c-1.33 2.67-1.33 4.33 0 7h2c-1.33-2.67-1.33-4.33 0-7zm4 0c1.33 2.67 1.33 4.33 0 7h2c1.33-2.67 1.33-4.33 0-7zM1 11a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm4-4a3 3 0 0 0 0 6 3 3 0 0 0 0-6zm0 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7 4v9h2v-3h1a3 3 0 0 0 0-6zm2 2h1a1 1 0 0 1 0 2H9zm-5 5a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1a1 1 0 0 0 0 2 8 8 0 0 1 8 8 1 1 0 0 0 2 0A10 10 0 0 0 6 1zm0 4a1 1 0 0 0 0 2 4 4 0 0 1 4 4 1 1 0 0 0 2 0 6 6 0 0 0-6-6zm0 4a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-5 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 11a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm7-9C7.6 6 6 6.79 6 9s1.83 4 4 4 4-1.79 4-4-1.6-3-4-7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M2 6a1 1 0 0 0-1 1v7a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1Zm1 2h10v2H3Zm0 3h10v2H3ZM1 1v4h6V1Zm1 1h4L4 4Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m1 1v4h14v-4zm5 1h4l-2 2zm-4 4a1 1 0 0 0 -1 1v7a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-7a1 1 0 0 0 -1-1zm1 2h10v2h-10zm0 3h10v2h-10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M4.73 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541A2 2 0 1 0 14 11.27V4.729A2 2 0 1 0 11.27 2Zm.683 2h5.857a2 2 0 0 0 .729.73v5.856L5.412 4zM3.999 5.414 10.584 12H4.727a2 2 0 0 0-.729-.73V5.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M4.73 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541A2 2 0 1 0 14 11.27V4.729A2 2 0 1 0 11.27 2Zm.683 2h5.857a2 2 0 0 0 .729.73v5.856L5.412 4zM3.999 5.414 10.584 12H4.727a2 2 0 0 0-.729-.73V5.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4.73 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541A2 2 0 1 0 14 11.27V4.729A2 2 0 1 0 11.27 2Zm.683 2h5.857a2 2 0 0 0 .729.73v5.856L5.412 4zM3.999 5.414 10.584 12H4.727a2 2 0 0 0-.729-.73V5.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.73 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541A2 2 0 1 0 14 11.27V4.729A2 2 0 1 0 11.27 2Zm.683 2h5.857a2 2 0 0 0 .729.73v5.856L5.412 4zM3.999 5.414 10.584 12H4.727a2 2 0 0 0-.729-.73V5.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M4.729 2A2 2 0 1 0 2 4.73v6.542A2 2 0 1 0 4.73 14H7v-2H4.728A2 2 0 0 0 4 11.27V5.414l3 3V8a2 2 0 0 1 .809-1.606L5.414 4h5.858a2 2 0 0 0 .728.73V6a2 2 0 0 1 1 .271A2 2 0 0 1 14 6V4.728A2 2 0 1 0 11.27 2zM9 8v7h5a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1v4l-1-1-1 1V8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.729 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541a2 2 0 1 0 2.698-2.75H14V4.729A2 2 0 1 0 11.27 2H4.729zm6.542 2a2 2 0 0 0 .729.729v6.542a2 2 0 0 0-.729.729H4.729A2 2 0 0 0 4 11.271V4.729A2 2 0 0 0 4.729 4zM8.75 6.125v.75H8v.75H6.5v.75h-.75v.75H5v.75h6v-1.5h-.75v-1.5H9.5v-.75z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" d="M2 12.5h3V10c0-2.5.5-4.2 3.5-4.2H10V3l5 3.8-5 3.8V8H8.5C7.25 8 7 9 7 10v2.5h3v2H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" d="M.5 13.5H2V11c0-2.5.5-4.2 3.5-4.2H6V4l5 3.8-5 3.8V9h-.5C4.25 9 4 10 4 11v2.5h4.5v2h-8z"/><path fill="#5fff97" d="M9 3h6v10H9v-2h4V5H9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#55f3e3" d="M7 2v8h2a3 3 0 0 0 0-6V2zM6 7a3 3 0 0 0-6 0 3 3 0 0 0 6 0zm7-1v3a1 1 0 0 1-1 1h-1v2h1a3 3 0 0 0 3-3V6zM3 6a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6 0a1 1 0 0 1 0 2zm4-4h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6 2 8l2 2M2 8h11m-1-2 2 2-2 2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 4 8 2 6 4m2-2v11m2-1-2 2-2-2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ff5f5f" stroke-linecap="round" stroke-width="2" d="M3 3 13 13M13 3 3 13"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ff5f5f" stroke-linecap="round" stroke-width="2" d="M3 3 13 13M13 3 3 13"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="M12 9h1v2h-1zM9 12h2v1h-2zM14 12h2v1h-2zM12 14h1v2h-1z"/><path d="m14.594 6.927c.754-1.134.446-2.665-.688-3.419-.309-.205-.66-.338-1.026-.389-.188-1.349-1.433-2.291-2.782-2.103s-2.29 1.433-2.103 2.782c.051.367.184.717.389 1.026l-3.56 3.56c-1.134-.754-2.665-.446-3.419.688s-.446 2.664.688 3.419c.308.205.659.338 1.026.389.188 1.349 1.433 2.29 2.782 2.103 1.349-.188 2.291-1.433 2.103-2.781-.051-.367-.184-.718-.389-1.026l3.56-3.56c1.134.753 2.665.445 3.419-.689z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 1 3 3l1 2v4H2v3.5a2.5 2.5 0 0 0 5 0V9H5V5l1-2-1-2zm6 .174a3 3 0 0 0 0 5.652V14a1 1 0 0 0 2 0V6.824a3 3 0 0 0 0-5.648V4a1 1 0 0 1-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7 1a5 5 0 0 0-4 5h4zm2 0a5 5 0 0 1 4 5H9zM3 8v2a5 5 0 0 0 10 0V8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 2H6m2 4v8M4 9l4 5 4-5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10V6m-4 2H2m5-4L2 8l5 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" d="M8 1a7 7 0 1 0 1.213 13.893l-2.6-6.32a1.5 1.5 0 0 1 1.957-1.96l6.319 2.6A7 7 0 0 0 8 1z"/><path fill="#ff5f5f" d="M8 3a5 5 0 1 0 .426 9.979L6.613 8.572A1.5 1.5 0 0 1 8.57 6.613l4.409 1.813A5 5 0 0 0 8 3z"/><path fill="#e0e0e0" d="M16 11.3 8 8.009l3.291 8 .947-2.82 1.884 1.883.942-.941-1.884-1.884z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2 6v4m4-2h8m-5 4 5-4-5-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 14h4m-2-4V2m4 5L8 2 4 7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M4.73 2A2 2 0 1 0 2 4.73v6.541a2 2 0 1 0 2.73 2.73H6v-2H4.73a2 2 0 0 0-.73-.73V5.437l3.564 3.564H9V7.565L5.436 4.001h5.834a2 2 0 0 0 .73.73V6h2V4.731A2 2 0 1 0 11.27 2zM11 8v3H8v2h3v3h2v-3h3v-2h-3V8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M4.73 2A2 2 0 1 0 2 4.73v6.541a2 2 0 1 0 2.73 2.73H6v-2H4.73a2 2 0 0 0-.73-.73V5.437l3.564 3.564H9V7.565L5.436 4.001h5.834a2 2 0 0 0 .73.73V6h2V4.731A2 2 0 1 0 11.27 2zM11 8v3H8v2h3v3h2v-3h3v-2h-3V8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4.73 2A2 2 0 1 0 2 4.73v6.541a2 2 0 1 0 2.73 2.73H6v-2H4.73a2 2 0 0 0-.73-.73V5.437l3.564 3.564H9V7.565L5.436 4.001h5.834a2 2 0 0 0 .73.73V6h2V4.731A2 2 0 1 0 11.27 2zM11 8v3H8v2h3v3h2v-3h3v-2h-3V8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M4.936 7.429a4 4 0 0 1 6.128 0M1.872 4.858a8 8 0 0 1 12.256 0"/><path fill="#5fff97" d="M7 9v2H5v2h2v2h2v-2h2v-2H9V9Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fff97" d="m8 10-2 4-2-4Z"/><path fill="#ff5f5f" d="m12 14-2-4-2 4Z"/><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M4.936 7.429a4 4 0 0 1 6.128 0M1.872 4.858a8 8 0 0 1 12.256 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M8 1v2.5a2.5 2.5 0 0 1 0 5V15c2-3 5-6 5-9s-2-5-5-5z"/><path fill="#e0e0e0" d="M8 1C5 1 3 3 3 6s3 6 5 9V8.5a1 1 0 0 1 0-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1C5 1 3 3 3 6s3 6 5 9V8.5a1 1 0 0 1 0-5z"/><path fill="#fc7f7f" d="M8 1v2.5a2.5 2.5 0 0 1 0 5V15c2-3 5-6 5-9s-2-5-5-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h3.2a3.25 3.25 0 0 1-.2-5l5-5a3.25 3.25 0 0 1 5 .2V2a1 1 0 0 0-1-1zm7.15 6.65a2 2 0 0 1 1.207.207l1.25-1.25a1 1 0 0 1 1.75 1.75l-2 2a1 1 0 0 1-1.5 0 .5.5 0 0 0-.707.707 2 2 0 0 0 2.914 0l2-2A2 2 0 0 0 10.9 5.9zm1.628 4.628a2 2 0 0 1-1.207-.207l-1.25 1.25a1.237 1.237 0 0 1-1.75-1.75l2-2a1 1 0 0 1 1.5 0 .5.5 0 0 0 .707-.707 2 2 0 0 0-2.914 0l-2 2a2.237 2.237 0 0 0 3.164 3.164z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h3.2a3.25 3.25 0 0 1-.2-5l5-5a3.25 3.25 0 0 1 5 .2V2a1 1 0 0 0-1-1zm7.15 6.65a2 2 0 0 1 1.207.207l1.25-1.25a1 1 0 0 1 1.75 1.75l-2 2a1 1 0 0 1-1.5 0 .5.5 0 0 0-.707.707 2 2 0 0 0 2.914 0l2-2A2 2 0 0 0 10.9 5.9zm1.628 4.628a2 2 0 0 1-1.207-.207l-1.25 1.25a1.237 1.237 0 0 1-1.75-1.75l2-2a1 1 0 0 1 1.5 0 .5.5 0 0 0 .707-.707 2 2 0 0 0-2.914 0l-2 2a2.237 2.237 0 0 0 3.164 3.164z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="m3 1a2 2 0 0 0 -2 2 2 2 0 0 0 1 1.7305v6.541a2 2 0 0 0 -1 1.7285 2 2 0 0 0 2 2 2 2 0 0 0 1.7305-1h2.5078l.75-2h-3.2598a2 2 0 0 0 -.72852-.73047v-5.8555l4.6973 4.6973.77148-2.0566-4.0547-4.0547h5.8574a2 2 0 0 0 .72852.73047v.27148a2.0002 2.0002 0 0 1 .023438 0 2.0002 2.0002 0 0 1 1.8496 1.2969l.12695.33789v-1.9082a2 2 0 0 0 1-1.7285 2 2 0 0 0 -2-2 2 2 0 0 0 -1.7305 1h-6.541a2 2 0 0 0 -1.7285-1zm9 6-3 8 3-2 3 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 .875C7.375.875 6.75 1.25 6.5 2l-3 10H8V9H5.5l1-4H8zM2 13c-1 0-1 2 0 2h6v-2z"/><path fill="#8da5f3" d="M8 .875V5h1.5l1 4H8v3h4.5l-3-10C9.25 1.25 8.625.875 8 .875zM8 13v2h6c1 0 1-2 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 .875C7.375.875 6.75 1.25 6.5 2l-3 10H8V9H5.5l1-4H8zM2 13c-1 0-1 2 0 2h6v-2z"/><path fill="#fc7f7f" d="M8 .875V5h1.5l1 4H8v3h4.5l-3-10C9.25 1.25 8.625.875 8 .875zM8 13v2h6c1 0 1-2 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h4.902a2.1 2.1 0 0 1 .131-.736L7.508 13H3V3h8.586L7.293 7.293a1 1 0 0 0 0 1.414l1.326 1.326 1.414-3.77a2.1 2.1 0 0 1 1.992-1.36 2.1 2.1 0 0 1 .436.05l2.246-2.246A1 1 0 0 0 14 1H2zm13 14-3-8-3 8 3-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h4.885a2.118 2.118 0 0 1 .133-.744l3-8a2.118 2.118 0 0 1 3.964 0L15 8.969V2a.992.992 0 0 0-1-1zm10 6-3 8 3-2 3 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h4.885a2.118 2.118 0 0 1 .133-.744l3-8a2.118 2.118 0 0 1 3.964 0L15 8.969V2a.992.992 0 0 0-1-1zm10 6-3 8 3-2 3 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1v14h8v-1H8v-4h2V8h4V6H9V1zm8 0v4h4z"/><path fill="#5fff97" d="M11 9v2H9v2h2v2h2v-2h2v-2h-2V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M13 9h-2v2H9v2h2v2h2v-2h2v-2h-2zm-3 .723A2 2 0 1 1 13 8h1v2h.445a4 4 0 1 0-7.314-3H1v2h1v2h3V9h2.133A4 4 0 0 0 8 10.627V10h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 5v1.5a2 2 0 1 0 2.75 2.75h1.5A2 2 0 0 0 7 10v1.5a2 2 0 1 0 2.75 2.75h1.5a2 2 0 1 0 0-2h-1.5A2 2 0 0 0 9 11.5V10a2 2 0 1 0-2.75-2.75h-1.5A2 2 0 0 0 4 6.5V5z"/><path fill="#5fff97" d="M2 5a2 2 0 1 1 2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m 12,3 c -0.552285,0 -1,0.4477153 -1,1 v 8 c 0,0.552285 0.447715,1 1,1 h 1 c 0.552285,0 1,-0.447715 1,-1 V 4 C 14,3.4477153 13.552285,3 13,3 Z M 2.975,3.002 C 2.4332786,3.0155465 2.0009144,3.45811 2,4 v 8 c -3.148e-4,0.838862 0.9701632,1.305289 1.625,0.781 l 5,-4 c 0.4989606,-0.4003069 0.4989606,-1.1596931 0,-1.56 l -5,-4 C 3.4409271,3.0736532 3.2107095,2.9960875 2.975,3.002 Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M8 2v2h2V2zm3 0v5a3 3 0 0 0 3 3h1V8h-1a1 1 0 0 1-1-1V2zM1 4v6h2V6h1a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3zm7 2v4h2V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M1 1h14v14H1zm2 2v2h2V3zm3 0v2h4V3zm5 0v2h2V3zM3 6v4h2V6zm3 0v4h4V6zm5 0v4h2V6zm-8 5v2h2v-2zm3 0v2h4v-2zm5 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5" fill="none" stroke="#e0e0e0" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5" fill="none" stroke="#8da5f3" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5" fill="none" stroke="#fc7f7f" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5" fill="none" stroke="#919191" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zM7 4h2v2H7zm0 3h2v5H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#417aec" d="M0 2v8h2V8a3 3 0 0 0 0-6zm6 0v5a3 3 0 0 0 3 3h1V8H9a1 1 0 0 1-1-1V6h2V4H8V2zm5 0v8h2V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3V2zM2 4a1 1 0 0 1 0 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffdd65" d="M8 2a1 1 0 0 0-.85.484l-6 10A1 1 0 0 0 2 14h12a1 1 0 0 0 .857-1.514l-6-10a1 1 0 0 0-.85-.484zM7 5h2v5H7zm0 6h2v2H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fff" d="M0 0v16h16V8.24A3 3 0 0 1 11 6V0z"/></mask><path fill="#ffdd65" d="M8 2a1 1 0 0 0-.85.484l-6 10A1 1 0 0 0 2 14h12a1 1 0 0 0 .857-1.514l-6-10a1 1 0 0 0-.85-.484zM7 5h2v5H7zm0 6h2v2H7z" mask="url(#a)"/><path fill="#f95252" d="M14 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm1.447 4.621a3 3 0 0 1-2.892 0 2 2 0 1 0 2.892 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fff" d="M0 0v16h16v-3.76A3 3 0 0 1 11.77 8a3 3 0 0 1 0-4V0z"/></mask><path fill="#ffdd65" d="M8 2a1 1 0 0 0-.85.484l-6 10A1 1 0 0 0 2 14h12a1 1 0 0 0 .857-1.514l-6-10a1 1 0 0 0-.85-.484zM7 5h2v5H7zm0 6h2v2H7z" mask="url(#a)"/><path fill="#f95252" d="M14 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm1.447 4.621a3 3 0 0 1-2.892 0 2 2 0 1 0 2.892 0zm0 4a3 3 0 0 1-2.892 0 2 2 0 1 0 2.892 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fff" d="M0 0v16h11.77a3 3 0 0 1 0-4 3 3 0 0 1 0-4 3 3 0 0 1 0-4V0z"/></mask><path fill="#ffdd65" d="M8 2a1 1 0 0 0-.85.484l-6 10A1 1 0 0 0 2 14h12a1 1 0 0 0 .857-1.514l-6-10a1 1 0 0 0-.85-.484zM7 5h2v5H7zm0 6h2v2H7z" mask="url(#a)"/><path fill="#f95252" d="M14 0a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm1.447 4.621a3 3 0 0 1-2.892 0 2 2 0 1 0 2.892 0zm0 4a3 3 0 0 1-2.892 0 2 2 0 1 0 2.892 0zm0 4a3 3 0 0 1-2.892 0 2 2 0 1 0 2.892 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1.725 5.625 5.822 1 6.92l3.236 3.406L3.876 15l4.14-1.977 4.158 1.942-.397-4.652L15 6.92l-4.625-1.098L8 1.725zM8 4l1.658 2.777 3.233.744-2.25 2.301.275 3.155-2.904-1.317L5.119 13l.252-3.168-2.262-2.31 3.233-.745L8 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none"><path fill="#e0e0e0" d="M10.755 1.795a3 3 0 0 0-4.061 1.517L4.968 6.919s-.864 1.804-1.668 1.3a1 1 0 0 0-.958 2l9.02 4.318a1 1 0 0 0 .957-2c-.902-.432-.038-2.236-.038-2.236l1.727-3.608a3 3 0 0 0-1.41-4 1 1 0 0 0-1.843-.898zM7 13a1.352 1.352 0 1 0 2.438 1.167z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none"><mask id="a"><path fill="#fff" d="M13.5 1H1v10.5zm-11 14H15V4.5z"/></mask><path fill="#e0e0e0" d="M10.755 1.795a3 3 0 0 0-4.061 1.517L4.968 6.919s-.864 1.804-1.668 1.3a1 1 0 0 0-.958 2l9.02 4.318a1 1 0 0 0 .957-2c-.902-.432-.038-2.236-.038-2.236l1.727-3.608a3 3 0 0 0-1.41-4 1 1 0 0 0-1.843-.898zM7 13a1.352 1.352 0 1 0 2.438 1.167z" mask="url(#a)"/><path stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M2 13 14 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#80ff45" d="M7.75 3.375 4 5.25l3.75 1.875L11.5 5.25z"/><path fill="#ff4545" d="M3.375 6.5v3.75L7 12.063v-3.75z"/><path fill="#45d7ff" d="M12.125 6.5 8.5 8.313v3.75l3.625-1.813z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1.553 4.104A1 1 0 0 0 1 5v6a1 1 0 0 0 .553.895l6 3a1 1 0 0 0 .894 0l6-3A1 1 0 0 0 15 11V5a1 1 0 0 0-.553-.894l-6-3a1 1 0 0 0-.894 0zm6.447-1 3.764 1.882L8 6.868 4.236 4.986zm-5 3.5 4 2v3.766l-4-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M1.553 4.104A1 1 0 0 0 1 5v6a1 1 0 0 0 .553.895l6 3a1 1 0 0 0 .894 0l6-3A1 1 0 0 0 15 11V5a1 1 0 0 0-.553-.894l-6-3a1 1 0 0 0-.894 0zm6.447-1 3.764 1.882L8 6.868 4.236 4.986zm-5 3.5 4 2v3.766l-4-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="M8.242 2a4.5 4.5 0 0 1 .729 2h2.3a2 2 0 0 0 .729.73v5.856L8.307 6.893a4.5 4.5 0 0 1-1.414 1.414L10.586 12H4.729A2 2 0 0 0 4 11.27V8.965a4.5 4.5 0 0 1-2-.729v3.035A2 2 0 1 0 4.73 14h6.541a2 2 0 1 0 2.698-2.75H14V4.729A2 2 0 1 0 11.27 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M6.607 1.139A4.5 4.5 0 1 1 1.141 6.61a7 7 0 1 0 5.466-5.47z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m1 9 6 6h8V7L9 1H1z"/><path fill-opacity=".235" d="m9 1 6 6v8H7L1 9h8L6 5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M6 10.576V13h4v-2.42a5 5 0 1 0-4 0zM8 3a3 3 0 0 1 0 6 3 3 0 0 1 0-6zM7 14v1h2v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" stroke-linecap="round" stroke-linejoin="round"><path fill="#fff" d="M10.959 1.5 8.002 4.436 5.043 1.502 4 2.529 8 6.5l4-3.967zm0 8-2.957 2.936-2.959-2.934L4 10.529 8 14.5l4-3.967z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1C6 3 1 5 1 9s3 6 7 6C1 12 1.4 7.25 8 2c-2.25 4-5.5 9 0 13 5-4.25 2.75-8.25 1-12 5.5 4.75 5.5 8.75-1 12 4 0 7-2 7-6s-5-6-7-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm7.293 3.307a1 1 0 0 1 1.424 1.414l-3 3a1 1 0 0 1-1.414 0l-3-3a1 1 0 0 1 1.414-1.414L8 8.6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="#e0e0e0" d="M3 2H6A2 2 0 0 1 8 4V20A2 2 0 0 1 6 22H3A2 2 0 0 1 1 20V4A2 2 0 0 1 3 2M21 15A2 2 0 0 1 23 17V20A2 2 0 0 1 21 22H12V15H21Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" stroke="#000" d="m.5.5v10l10-10z"/><path fill="#000003" d="m0 12 12-12h-1.714286l-10.285714 10.285714z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m5 1c-1.108 0-2 .89199-2 2v1h4v-1h2v1h4v-1c0-1.108-.89199-2-2-2zm-2 5c-1.108 0-2 .89199-2 2v5c0 1.108.89199 2 2 2h10c1.108 0 2-.89199 2-2v-5c0-1.108-.89199-2-2-2h-4v3h2l-3 4-3-4h2v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#5fff97" d="M5 3a3 3 0 0 0-3 3v3h2V6a1 1 0 0 1 1-1h1v4h2a3 3 0 0 0 1-.176V9h2a3 3 0 0 0 3-3V3h-2v3a1 1 0 0 1-1 1V3H9v3a1 1 0 0 1-1 1V3z"/><path fill="#fff" fill-opacity=".4" d="M6 9V3h2v4a1 1 0 0 0 1-1V3h2v4a1 1 0 0 0 1-1V3h2v3a3 3 0 0 1-3 3H9v-.176A3 3 0 0 1 8 9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#ff4545" d="M6 3.5a3 3 0 0 0 0 6h1v-2H6a1 1 0 0 1 0-2h1v-2z"/><path fill="#80ff45" d="M7 1.5v5a3 3 0 0 0 3 3v-2a1 1 0 0 1-1-1v-5z"/><path fill="#45d7ff" d="M13 3.5a3 3 0 0 0-3 3v3h2v-3a1 1 0 0 1 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v10H3zm1 1v2h2V4zm3 0v2h2V4zm3 0v2h2V4zM4 7v2h2V7zm3 0v2h2V7zm3 0v2h2V7zm-6 3v2h2v-2zm3 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#35d4f4" d="M6 2a3 3 0 0 0-3 3v5h2V8h1V6H5V5a1 1 0 0 1 1-1zm1 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V2zm3 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2z"/><path fill="#fff" fill-opacity=".4" d="M7 2v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#35d4f4" d="M6 2a3 3 0 0 0-3 3v5h2V8h1V6H5V5a1 1 0 0 1 1-1zm1 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V2zm3 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2z"/><path fill="#fff" fill-opacity=".4" d="M7 2v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#5abbef" d="M3 2v2h2V2zm2 2v2H3v4h4V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3zm5 3a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2h-2z"/><path fill="#fff" fill-opacity=".4" d="M5 4v6h2V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#5abbef" d="M3 2v2h2V2zm2 2v2H3v4h4V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3zm5 3a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2h-2z"/><path fill="#fff" fill-opacity=".4" d="M5 4v6h2V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m14.564 2-2.244.328.818 1.9 1.715-.25zm-4.223.615-1.978.29.818 1.902 1.979-.29zm-3.959.578-1.978.29.818 1.902 1.979-.29zm-3.957.578-1.714.25L1 6l2.244-.328zM1 7v6a2 2 0 0 0 2 2h12V7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#4593ec" d="M5 2a2.5 2.5 0 0 0 0 5 .5.5 0 0 1 0 1H2v2h3a2.5 2.5 0 0 0 0-5 .5.5 0 0 1 0-1h3v3a3 3 0 0 0 3 3h2V7a1 1 0 0 1 1-1V4a3 3 0 0 0-3 3v1a1 1 0 0 1-1-1V6h1V4h-1V2z"/><path fill="#fff" fill-opacity=".4" d="M8 2v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#ac73f1" d="M9 2v2h1a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8h-3a3 3 0 0 0 0-6zM3 3v6h2a3 3 0 0 0 3-3V3H6v3a1 1 0 0 1-1 1V3z"/><path fill="#fff" fill-opacity=".4" d="M9 2v2h1a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8h-3a3 3 0 0 0 0-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="M0 0v12h4v-2H2V2h2V0zm12 0v2h2v8h-2v2h4V0z"/><path fill="#de66f0" d="M8 1v2h2a1 1 0 0 1-1 1v2a1 1 0 0 1 0 2H8v2h1a3 3 0 0 0 2.232-5A3 3 0 0 0 12 3V1zm0 2H6v3a1 1 0 0 1-1 1V3H3v6h2a3 3 0 0 0 3-3z"/><path fill="#fff" fill-opacity=".4" d="M8 1v2h2a1 1 0 0 1-1 1v2a1 1 0 0 1 0 2H8v2h1a3 3 0 0 0 2.232-5A3 3 0 0 0 12 3V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#e0e0e0" d="m0 0v12h4v-2h-2v-8h2v-2zm12 0v2h2v8h-2v2h4v-12z"/><path fill="#ac73f1" d="M8 3h2v2h1v-3h2v8h-2v-3h-3zM3 3v6h2a3 3 0 003-3v-3h-2v3a1 1 0 01-1 1v-4z"/><path fill="#fff" fill-opacity=".392" d="M8 3h2v2h1v-3h2v8h-2v-3h-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 3 3 6l3 3m3-6v6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m6 9 3-3-3-3M3 9V3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m4.5 9 3-3-3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m7.5 3-3 3 3 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2.92 10c-.263.3-.42.73-.42 1.238 0 1.628-3.138-.178-.337 2.67.884.9 2.654.67 3.538-.228a2.33 2.33 0 0 0 0-3.256c-1.1-1.119-2.2-1.084-2.78-.424zm2.3-1.64 2.4 2.4 6.8-6.8a1.7 1.7 0 0 0-2.4-2.45z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="#8eef97" rx="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0a2 2 0 0 0-2 2v12.002a2 2 0 0 0 2 2h12.002a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 4h12v10H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 4h12v4H2zm12 6v4H2v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 4h5v10H2zm7 0h5v10H9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 4h12v4H2zm0 6h5v4H2zm7 0h5v4H9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 4h5v4H2zm7 0h5v10H9zm-7 6h5v4H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 4h5v4H2zm7 0h5v4H9zm-7 6h5v4H2zm7 0h5v4H9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M1 2q7 4 14 0v12q-7-4-14 0zm2 7a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2zm8 0a1 1 0 0 0 1-1h1a1 1 0 0 0 0-2h-2a1 1 0 0 0-1 1H9a1 1 0 0 0 0 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m3 1a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-10a2 2 0 00-2-2zm10 2v10h-10v-10zM7 5v6l-3-3zm2 0v6l3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="13" height="13" x="1.5" y="1.5" fill="none" stroke="#e0e0e0" rx="1"/><path fill="#e0e0e0" d="M7 5v6L4 8zm2 0v6l3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm4 4v6L4 8zm2 0 3 3-3 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M12 11a3 3 0 0 0 .414-5.969 4.5 5 0 0 0-8.824 0 3 3 0 0 0 .414 5.967zm-8 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm8 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-4 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M13 1a2 2 0 0 0-1.15 3.633c-.193.885-.554 1.34-.987 1.642-.644.451-1.713.606-2.963.73s-2.681.221-3.912 1.083c-.892.625-1.532 1.652-1.818 3.096a2 2 0 1 0 1.98.183c.193-.885.553-1.337.987-1.64.644-.451 1.713-.606 2.963-.73s2.681-.221 3.912-1.083c.892-.625 1.532-1.654 1.818-3.098A2 2 0 0 0 13 1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M13 1a2 2 0 0 0-1.15 3.633c-.193.885-.554 1.34-.987 1.642-.644.451-1.713.606-2.963.73s-2.681.221-3.912 1.083c-.892.625-1.532 1.652-1.818 3.096a2 2 0 1 0 1.98.183c.193-.885.553-1.337.987-1.64.644-.451 1.713-.606 2.963-.73s2.681-.221 3.912-1.083c.892-.625 1.532-1.654 1.818-3.098A2 2 0 0 0 13 1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m13 0-3 4h1.947c-.138 1.32-.558 1.907-1.084 2.275-.644.451-1.713.606-2.963.73s-2.681.221-3.912 1.083c-.892.625-1.532 1.652-1.818 3.096a2 2 0 1 0 1.98.183c.193-.885.553-1.337.987-1.64.644-.451 1.713-.606 2.963-.73s2.681-.221 3.912-1.083c1.053-.737 1.755-2.032 1.937-3.914H16l-3-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m13 0-3 4h1.947c-.138 1.32-.558 1.907-1.084 2.275-.644.451-1.713.606-2.963.73s-2.681.221-3.912 1.083c-.892.625-1.532 1.652-1.818 3.096a2 2 0 1 0 1.98.183c.193-.885.553-1.337.987-1.64.644-.451 1.713-.606 2.963-.73s2.681-.221 3.912-1.083c1.053-.737 1.755-2.032 1.937-3.914H16l-3-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1zm6 0a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-width="1.25" d="m5 12.533-1.5 1.5a6.375 6.375 0 1 1 9 0l-1.5-1.5M2 9.5h2m10 0h-2M3.5 4.967l1.5 1.5m7.5-1.5-1.5 1.5M8 3.52v2"/><path fill="#e0e0e0" d="M7.125 8.93a1.033 1.033 0 1 0 1.867.716l.478-3.03-.672-.258z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M10.478 1a2.466 2.466 0 0 0-1.9.878L10.15 4.15l-1.766.674-3.56 3.56a2.466 2.466 0 1 0-1.705 4.496 2.466 2.466 0 1 0 4.496-1.705l3.56-3.56a2.466 2.466 0 1 0 1.705-4.496A2.466 2.466 0 0 0 10.478 1zm-9.32 1.77.96 4.827 1.397-.525zm2.763-1.743.961 4.827 1.396-.525zM7.133.899l.711 3.514 1.397-.525z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M10.478 1a2.466 2.466 0 0 0-1.9.878L10.15 4.15l-1.766.674-3.56 3.56a2.466 2.466 0 1 0-1.705 4.496 2.466 2.466 0 1 0 4.496-1.705l3.56-3.56a2.466 2.466 0 1 0 1.705-4.496A2.466 2.466 0 0 0 10.478 1zm-9.32 1.77.96 4.827 1.397-.525zm2.763-1.743.961 4.827 1.396-.525zM7.133.899l.711 3.514 1.397-.525z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="m15.209 5.934c-.018.574-.181 1.149-.521 1.662-.594.891-1.588 1.424-2.661 1.424-.343 0-.681-.055-1.002-.162l-2.169 2.169c.061.185.104.374.132.565.117.844-.102 1.684-.616 2.363-.515.681-1.263 1.12-2.107 1.236-.113.016-.224.02-.335.023.469.557 1.201.872 1.975.765 1.2-.167 2.036-1.274 1.87-2.473-.045-.326-.163-.639-.346-.913l3.164-3.163c1.008.67 2.369.396 3.039-.612.625-.939.422-2.176-.423-2.884z"/><path d="m13.452 4.173c-.005.599-.173 1.204-.529 1.738-.593.893-1.588 1.426-2.66 1.426-.344 0-.682-.055-1.003-.162l-2.169 2.169c.062.185.105.374.132.565.118.844-.101 1.684-.615 2.363-.514.681-1.262 1.12-2.107 1.237-.09.013-.179.014-.269.019.47.5 1.165.774 1.896.673 1.2-.166 2.037-1.274 1.87-2.472-.045-.327-.164-.64-.346-.913l3.165-3.164c1.008.67 2.368.396 3.039-.612.619-.931.423-2.157-.404-2.867z"/><path d="m8.432.09c-.651-.004-1.27.283-1.689.78l1.397 2.02-1.57.6-3.164 3.163c-1.008-.67-2.369-.396-3.039.612-.67 1.007-.396 2.369.611 3.039.274.183.586.301.912.346.167 1.199 1.274 2.036 2.473 1.87 1.199-.167 2.036-1.274 1.869-2.473-.044-.326-.163-.639-.345-.913l3.164-3.164c1.008.67 2.369.396 3.039-.612.671-1.008.397-2.368-.61-3.039-.274-.182-.587-.3-.913-.345-.152-1.068-1.056-1.867-2.135-1.884zm-8.285 1.573.854 4.291 1.242-.467zm2.457-1.549.854 4.291 1.241-.466zm2.854-.114.632 3.124 1.242-.466z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M1 3h14v10H1m2-4a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2zm8 0a1 1 0 0 0 1-1h1a1 1 0 0 0 0-2h-2a1 1 0 0 0-1 1H9a1 1 0 0 0 0 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#7582a8" d="M10 5h2v7h-7v-2h5z"/><g fill="none" stroke="#7582a8" stroke-linecap="round"><path d="M2.5 8v5A1.5 1.5 0 0 0 4 14.5h9a1.5 1.5 0 0 0 1.5-1.5V4A1.5 1.5 0 0 0 13 2.5H8"/><path stroke-width="1.5" d="m2 2 6 6M7 1.75l2 2M1.75 7l2 2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#b56d6d" d="M10 5h2v7h-7v-2h5z"/><g fill="none" stroke="#b56d6d" stroke-linecap="round"><path d="M2.5 8v5A1.5 1.5 0 0 0 4 14.5h9a1.5 1.5 0 0 0 1.5-1.5V4A1.5 1.5 0 0 0 13 2.5H8"/><path stroke-width="1.5" d="m2 2 6 6M7 1.75l2 2M1.75 7l2 2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0"><path stroke-linejoin="round" stroke-opacity=".6" stroke-width="2" d="M14 8.5v4L8 15l-6-2.5v-4M8 11v4"/><path stroke-linejoin="round" stroke-width="2" d="m8 6 6 2.5L8 11 2 8.5z"/><path stroke-linecap="round" stroke-width="1.75" d="M3.5 2l1 1.8M8 1v2m4.5-1-1 1.8"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="5" fill="none" stroke="#fff"/><circle cx="6" cy="6" r="4" fill="none" stroke="#000"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"><circle cx="6" cy="6" r="4" fill="#fff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#eaeaea" d="M6.5 2.5a5.5 5.5 0 0 0 0 11 5.5 5.5 0 0 0 0-11m6.5 0h2v11h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#eaeaea" d="M.5 2.5h11v11H.5zm12 0h2v11h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="5.25" fill="none" stroke="#eaeaea" stroke-width="1.75"/><path fill="#eaeaea" d="M4.9 4.9h6.2v6.2H4.9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m4 1v1l1 1v3h6v-3l1-1v-1zm1 6-2 3h10l-2-3zm2 4v2l1 2 1-2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m9 1.272-.707.707v1.414L6.172 5.516l4.242 4.242 2.121-2.121h1.414l.707-.707zm-3.535 4.95L1.93 6.93 9 14l.707-3.535zM4.05 10.466 2.636 11.88 1.93 14l2.12-.707 1.415-1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m9 1.272-.707.707v1.414L6.172 5.516l4.242 4.242 2.121-2.121h1.414l.707-.707zm-3.535 4.95L1.93 6.93 9 14l.707-3.535zM4.05 10.466 2.636 11.88 1.93 14l2.12-.707 1.415-1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m4 1v1l1 1v3h6v-3l1-1v-1zm1 6-2 3h10l-2-3zm2 4v2l1 2 1-2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M10 7H6V5L2 8l4 3V9h4v2l4-3-4-3zM0 1v14h2V1zm14 0v14h2V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><g stroke="url(#a)"><path fill="none" stroke-linejoin="round" stroke-width="2" d="M3 3h10v10H3z"/><path stroke-linecap="round" stroke-width="1.5" d="M7 5.5 5.5 7m5-1.5-5 5m5-1.5L9 10.5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M4.729 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.73 14h6.541a2 2 0 1 0 2.698-2.75H14V4.729A2 2 0 1 0 11.27 2H4.729zm6.542 2a2 2 0 0 0 .729.729v6.542a2 2 0 0 0-.729.729H4.729A2 2 0 0 0 4 11.271V4.729A2 2 0 0 0 4.729 4z"/><path stroke="#ffca5f" stroke-linecap="round" stroke-width="1.5" d="m7.25 5.25-2 2M10.5 5.5l-5 5m5.25-1.75-2 2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3z"/><path stroke="#e0e0e0" stroke-linecap="round" stroke-width="1.5" d="M7 4.25 4.25 7m6.5-2.75-5.5 5.5M11.75 7 9 9.75"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 14a1 1 0 0 0 1 1h9.5a1 1 0 0 0 .707-.293l2.5-2.5A1 1 0 0 0 15 11.5V2a1 1 0 0 0-1-1H4.5a1 1 0 0 0-.707.293l-2.5 2.5A1 1 0 0 0 1 4.5zm1.25-9H11v7H2.25zm10 6.25v-6.5L14 3v6.5zm-1-7.5H3L4.75 2H13z"/><path stroke="#e0e0e0" stroke-linecap="round" stroke-width="1.5" d="M5.25 6.25 3.5 8m5.375-1.75-4.5 4.5M9.75 9 8 10.75"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#f74949" d="M1 2v8h2V8a3 3 0 0 0 0-6zm6 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V2zM3 4a1 1 0 0 1 0 2zm8 0v6h2V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="m8 5 5 3-5 3-5-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 12a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 4 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M12 12a1 1 0 0 1-1.555.832l-6-4a1 1 0 0 1 0-1.664l6-4A1 1 0 0 1 12 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m14.564 2-2.2441.32812.81836 1.9004 1.7148-.25-.28906-1.9785zm-4.2227.61523-1.9785.28906.81836 1.9023 1.9785-.28906zm-3.959.57812-1.9785.28906.81836 1.9023 1.9785-.28906zm-3.957.57812-1.7148.25.28906 1.9785 2.2441-.32812-.81836-1.9004zm-1.4258 3.2285v6a2 2 0 0 0 2 2h12v-8zm3 1h4v1h4v5h-4-4v-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><rect width="64" height="64" fill="#699ce8" fill-opacity=".75" rx="5"/><path fill="#fff" d="m16 16 32 16-32 16"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 2.5a2 2 0 0 0-2 2V9a2 2 0 0 0 2 2h4v1H5.4v.4H3v2h2.4v.4h5.2v-.4H13v-2h-2.4V12H9v-1h4a2 2 0 0 0 2-2V4.5a2 2 0 0 0-2-2zm2.75 1.25 5 3-5 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m14.564 2-2.244.328.818 1.9 1.715-.25zm-4.223.615-1.978.29.818 1.902 1.979-.29zm-3.959.578-1.978.29.818 1.902 1.979-.29zm-3.957.578-1.714.25L1 6l2.244-.328zM1 7v6a2 2 0 0 0 2 2h12V7zm5 1 5 3-5 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 3a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h1a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1zm4.975 0A1 1 0 0 0 7 3.998v8a1 1 0 0 0 1.625.781l5-4a1 1 0 0 0 0-1.56l-5-4A1 1 0 0 0 7.975 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M13 3a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1zM8.025 3A1 1 0 0 1 9 3.998v8a1 1 0 0 1-1.625.781l-5-4a1 1 0 0 1 0-1.56l5-4A1 1 0 0 1 8.025 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1.739 5.44a.595.595 0 0 0-.586.593v4.75a.593.593 0 0 0 .923.494l3.56-2.373h4.25V8h-4.25l-3.56-2.461a.593.593 0 0 0-.336-.098zm8.746 0a.595.595 0 0 0-.587.592v4.746a.593.593 0 0 0 .923.494l3.559-2.373a.593.593 0 0 0 0-1l-3.56-2.373a.593.593 0 0 0-.335-.099z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m7 1-.565 2.258a4.947 4.947 0 0 0-.689.28L3.758 2.343 2.344 3.758l1.195 1.994c-.112.221-.207.45-.285.685L1 7v2l2.258.564c.048.15.115.292.177.436H4c.54-.684 1.222-1.246 2-1.596a2.037 2.037 0 1 1 4 0A4.766 4.766 0 0 1 12 10h.58c.064-.145.132-.287.182-.438L15.014 9V7l-2.257-.565a4.992 4.992 0 0 0-.28-.687l1.194-1.99-1.414-1.414-1.994 1.195a5.012 5.012 0 0 0-.686-.285L9.016 1h-2zm1 6a1 1 0 0 0-1 1v2.174A3 3 0 0 0 5 13h1v2h1v-2h2v2h1v-2h1a3 3 0 0 0-2-2.826V7.998a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M6 10.576V13h4v-2.42a5 5 0 1 0-4 0zM8 3a3 3 0 0 1 0 6 3 3 0 0 1 0-6zM7 14v1h2v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#ffca5f"><circle cx="3.75" cy="3" r="2"/><circle cx="11.75" cy="6.25" r="2"/><circle cx="6.5" cy="12.5" r="2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" stroke="#8da5f3" stroke-linejoin="round" stroke-width="2" d="M14 14H2V2h12L8 8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M7.328 1A4.5 4.5 0 1 1 1 7.314V14a1 1 0 0 0 1 1h12a1 1 0 0 0 .707-1.707L9.414 8l5.293-5.293A1 1 0 0 0 14 1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v1h2V1zm3 0v2h2V1zm4 0v2h2V1zm4 0v2h2V2a1 1 0 0 0-1-1zm0 4h2v2h-2ZM1 5v2h2V5zm11 3-3 7 3-1.5 3 1.5zM1 9v2h2V9zm0 4v1a1 1 0 0 0 1 1h1v-2zm4 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm4 2h2v6H7zm0 8h2v2H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v4h6v-4zm1 1h4l-2 2zm0 4a1 1 0 0 0 -1 1v7a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-7a1 1 0 0 0 -1-1zm1 2h10v2h-10zm0 3h10v2h-10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v4h6v-4zm1 1h4l-2 2zm0 4c-.55228 0-1 .44772-1 1v7c0 .55228.44772 1 1 1h12c.55228 0 1-.44772 1-1v-7c0-.55228-.44772-1-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h7v-4H3V3h6V1zm6 5v1H6v1H5v1H4v1h5V6zm3-5h4v4h-4Zm0 5h4v4h-4Zm0 5h4v4h-4Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0"><circle cx="8" cy="8" r="6" stroke-width="2"/><path stroke-width="1.5" d="M2 8a6.5 2 0 0 0 12 0M8 2c-3 4-3 8 0 12M8 2c3 4 3 8 0 12"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16"><defs><path id="a" d="M8 1a7 7 0 00-4.982 11.998H1.911v2h4a1 1 0 00.97-1.242l-1-4-1.94.486.28 1.121a5 5 0 117.223.168l1.416 1.416A7 7 0 008 1z"/></defs><g fill="none" stroke="#000" stroke-linejoin="round" stroke-width="2" opacity=".8"><circle cx="8" cy="8" r="2"/><use xlink:href="#a"/></g><g fill="#f9f9f9"><circle cx="8" cy="8" r="2"/><use xlink:href="#a"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7 1v3h2V1zM4.465 3.05 3.05 4.466 4.464 5.88l1.414-1.414zm7.07 0-1.414 1.415 1.414 1.414 1.414-1.414zM8 5a2 2 0 0 0 0 6 2 2 0 0 0 0-6zM1 7v2h3V7zm11 0v2h3V7zm-7.535 3.121L3.05 11.535l1.414 1.414 1.414-1.414zm7.07 0-1.414 1.414 1.414 1.414 1.414-1.414zM7 12v3h2v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-linejoin="round" stroke-width="2" d="m5 2 6 3-3 9-6-3zm6 3 3 6-6 3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M1.685 13a7 7 0 1 1 12.631 0zM3 10a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2zm7 0a1 1 0 0 0 1-1h1a1 1 0 0 0 0-2h-2a1 1 0 0 0-1 1H8a1 1 0 0 0 0 2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16"><defs><radialGradient xlink:href="#a" id="b" cx="12.039" cy="6.909" r="5.11" fx="11.285" fy="6.896" gradientTransform="matrix(1.19638 -1.2376 1.21246 1.17207 -11.159 13.888)" gradientUnits="userSpaceOnUse"/><radialGradient xlink:href="#a" id="d" cx="12.039" cy="6.909" r="5.11" fx="11.285" fy="6.896" gradientTransform="matrix(1.19638 -1.2376 1.21246 1.17207 -11.159 13.888)" gradientUnits="userSpaceOnUse"/><linearGradient id="a"><stop offset=".108" stop-color="#ffdd65"/><stop offset="1" stop-color="#ffdd65" stop-opacity="0"/></linearGradient><path id="c" fill="#ffdd65" d="M7.56 10.905L6.355 5.79l4.085 3.304z"/></defs><path fill="#ffdd65" d="M39.087-34.74a.507.507 0 00-.431.247l-3.045 5.074a.507.507 0 00.431.77h6.09a.507.507 0 00.435-.769l-3.045-5.074a.507.507 0 00-.431-.246zm-.507 1.523h1.015v2.538H38.58zm0 3.045h1.015v1.015H38.58zM41.79-25.317a7 7 0 00-7 7 7 7 0 007 7 7 7 0 007-7 7 7 0 00-7-7zm0 2a5 5 0 015 5 5 5 0 01-5 5 5 5 0 01-5-5 5 5 0 015-5z"/><path fill="none" stroke="#ffdd65" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M38.941-19.26a3 3 0 012.76-2.056 3 3 0 012.876 1.89"/><path fill="#ffdd65" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.7" d="M40.79-17.5l1-5 1 5z" paint-order="stroke markers fill"/><circle cx="41.789" cy="-16.317" r="2" fill="#ffdd65"/><g transform="translate(47.69 -41.492)"><path fill="none" stroke="url(#b)" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.797" d="M4.74 9.936a3.757 3.757 0 01.176-4.033 3.757 3.757 0 013.73-1.544 3.757 3.757 0 012.976 2.727"/><use xlink:href="#c" paint-order="stroke markers fill"/><circle cx="2.298" cy="13.837" r="1.797" fill="#ffdd65" transform="rotate(-32.152)"/><circle cx="8" cy="8" r="6.323" fill="none" stroke="#ffdd65" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.355" paint-order="fill markers stroke"/></g><g transform="translate(66.007 -44.302)"><path fill="none" stroke="url(#d)" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.797" d="M4.74 9.936a3.757 3.757 0 01.176-4.033 3.757 3.757 0 013.73-1.544 3.757 3.757 0 012.976 2.727"/><use xlink:href="#c" paint-order="stroke markers fill"/><circle cx="2.298" cy="13.837" r="1.797" fill="#ffdd65" transform="rotate(-32.152)"/><circle cx="8" cy="8" r="6.323" fill="none" stroke="#ffdd65" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.355" paint-order="fill markers stroke"/></g><path fill="#1d2229" d="M8 3a6 6 0 00-6 6 6 6 0 006 6 6 6 0 006-6 6 6 0 00-6-6zm0 2a4 4 0 014 4 4 4 0 01-4 4 4 4 0 01-4-4 4 4 0 014-4z" paint-order="fill markers stroke"/><path fill="#1d2229" d="M7 1h2v3H7z" paint-order="fill markers stroke"/><rect width="2" height="2" x="11.021" y="-6.293" fill="#1d2229" paint-order="fill markers stroke" ry=".5" transform="rotate(45)"/><rect width="6" height="1" x="5" y="1" fill="#1d2229" paint-order="fill markers stroke" ry=".5"/><circle cx="8" cy="9" r="1" fill="#1d2229" paint-order="fill markers stroke"/><path fill="#1d2229" d="M7 9h2L8 5.016z" paint-order="fill markers stroke"/><rect width="2" height="2" x="-1.707" y="5.021" fill="#1d2229" paint-order="fill markers stroke" ry=".5" transform="rotate(-45)"/><rect width="1" height="1" x="4.5" y="8.5" fill="#1d2229" paint-order="fill markers stroke" ry=".5"/><rect width="1" height="1" x="10.5" y="8.5" fill="#1d2229" paint-order="fill markers stroke" ry=".5"/><rect width="1" height="1" x="7.5" y="11.5" fill="#1d2229" paint-order="fill markers stroke" ry=".5"/><circle cx="20" cy="-21" r="6" fill="#ffdd65" paint-order="fill markers stroke"/><circle cx="20" cy="-21" r="4" fill="#fff" paint-order="fill markers stroke"/><path fill="#ffdd65" d="M19-29h2v3h-2z" paint-order="fill markers stroke"/><rect width="2" height="2" x="-1.707" y="-35.991" fill="#ffdd65" paint-order="fill markers stroke" ry=".5" transform="rotate(45)"/><rect width="6" height="1" x="17" y="-29" fill="#ffdd65" paint-order="fill markers stroke" ry=".5"/><circle cx="20" cy="-21" r="1" fill="#ffdd65" paint-order="fill markers stroke"/><path fill="#ffdd65" d="M19-21h2l-1-3.984z" paint-order="fill markers stroke"/><rect width="2" height="2" x="27.991" y="-7.707" fill="#ffdd65" paint-order="fill markers stroke" ry=".5" transform="rotate(-45)"/><rect width="1" height="1" x="16.5" y="-21.5" fill="#ffdd65" paint-order="fill markers stroke" ry=".5"/><rect width="1" height="1" x="22.5" y="-21.5" fill="#ffdd65" paint-order="fill markers stroke" ry=".5"/><rect width="1" height="1" x="19.5" y="-18.5" fill="#ffdd65" paint-order="fill markers stroke" ry=".5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M9 1v3.055a4 4 0 0 1 1.027.426l2.159-2.159A7 7 0 0 0 9 1z"/><path fill-opacity=".2" d="M7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.08zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.815zm11.2 0-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM1.08 9a7 7 0 0 0 1.32 3.186l2.158-2.159A4 4 0 0 1 4.13 9H1.08zm10.786 0a4 4 0 0 1-.425 1.027l2.158 2.159A7 7 0 0 0 14.921 9h-3.055zm-5.894 2.441L3.814 13.6a7 7 0 0 0 3.185 1.322v-3.055a4 4 0 0 1-1.027-.426zm4.055 0a4 4 0 0 1-1.028.428v3.05a7 7 0 0 0 3.186-1.32l-2.158-2.158z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.079zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.814zM1.08 9a7 7 0 0 0 1.32 3.185l2.159-2.158A4 4 0 0 1 4.131 9H1.08zm10.787 0a4 4 0 0 1-.426 1.027l2.159 2.158A7 7 0 0 0 14.922 9h-3.055zm-5.894 2.441L3.814 13.6A7 7 0 0 0 7 14.922v-3.055a4 4 0 0 1-1.027-.426zm4.054 0A4 4 0 0 1 9 11.869v3.05a7 7 0 0 0 3.186-1.32l-2.159-2.158z"/><path d="m13.6 3.8-2.158 2.158a4 4 0 0 1 .428 1.028h3.05A7 7 0 0 0 13.6 3.8z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.079zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.814zm11.2 0-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM1.08 9a7 7 0 0 0 1.32 3.185l2.158-2.158A4 4 0 0 1 4.13 9H1.08zm4.892 2.441L3.814 13.6a7 7 0 0 0 3.185 1.322v-3.055a4 4 0 0 1-1.027-.426zm4.055 0a4 4 0 0 1-1.028.428v3.05a7 7 0 0 0 3.186-1.32l-2.158-2.158z"/><path d="M11.867 9a4 4 0 0 1-.426 1.027l2.158 2.159A7 7 0 0 0 14.922 9h-3.055z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.079zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.814zm11.2 0-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM1.08 9a7 7 0 0 0 1.32 3.185l2.158-2.158A4 4 0 0 1 4.13 9H1.08zm10.786 0a4 4 0 0 1-.425 1.027l2.158 2.158A7 7 0 0 0 14.921 9h-3.055zm-5.894 2.441L3.814 13.6a7 7 0 0 0 3.185 1.322v-3.055a4 4 0 0 1-1.027-.426z"/><path d="M10.027 11.4A4 4 0 0 1 9 11.828v3.05a7 7 0 0 0 3.185-1.32z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.079zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.814zm11.2 0-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM1.08 9a7 7 0 0 0 1.32 3.185l2.158-2.158A4 4 0 0 1 4.13 9H1.08zm10.786 0a4 4 0 0 1-.425 1.027l2.158 2.158A7 7 0 0 0 14.921 9h-3.055zm-1.84 2.441a4 4 0 0 1-1.027.428v3.05a7 7 0 0 0 3.186-1.32l-2.158-2.158z"/><path d="m5.973 11.4-2.159 2.158A7 7 0 0 0 7 14.88v-3.054a4 4 0 0 1-1.027-.426z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.079zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.814zm11.2 0-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM11.867 9a4 4 0 0 1-.426 1.027l2.158 2.158A7 7 0 0 0 14.922 9h-3.055zm-5.895 2.441L3.814 13.6A7 7 0 0 0 7 14.922v-3.055a4 4 0 0 1-1.028-.426zm4.055 0A4 4 0 0 1 9 11.869v3.05a7 7 0 0 0 3.185-1.32l-2.158-2.158z"/><path d="M1.08 9a7 7 0 0 0 1.32 3.186l2.159-2.159A4 4 0 0 1 4.131 9H1.08z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM7 1.08A7 7 0 0 0 3.814 2.4l2.159 2.159A4 4 0 0 1 7 4.13V1.079zm6.6 2.734-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM1.08 9a7 7 0 0 0 1.32 3.185l2.158-2.158A4 4 0 0 1 4.13 9H1.08zm10.787 0a4 4 0 0 1-.426 1.027l2.158 2.158A7 7 0 0 0 14.921 9h-3.054zm-5.895 2.441L3.814 13.6a7 7 0 0 0 3.185 1.322v-3.055a4 4 0 0 1-1.027-.426zm4.055 0A4 4 0 0 1 9 11.869v3.05a7 7 0 0 0 3.185-1.32l-2.158-2.158z"/><path d="M2.4 3.8a7 7 0 0 0-1.322 3.186h3.055a4 4 0 0 1 .426-1.028L2.4 3.8z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path fill-opacity=".2" d="M9 1.078v3.055a4 4 0 0 1 1.027.426L12.186 2.4A7 7 0 0 0 9 1.078zM2.4 3.814A7 7 0 0 0 1.078 7h3.055a4 4 0 0 1 .426-1.027L2.4 3.814zm11.2 0-2.159 2.159A4 4 0 0 1 11.869 7h3.05a7 7 0 0 0-1.32-3.186zM1.08 9a7 7 0 0 0 1.32 3.185l2.158-2.158A4 4 0 0 1 4.13 9H1.08zm10.786 0a4 4 0 0 1-.425 1.027l2.158 2.158A7 7 0 0 0 14.921 9h-3.055zm-5.894 2.441L3.814 13.6a7 7 0 0 0 3.185 1.322v-3.055a4 4 0 0 1-1.027-.426zm4.055 0a4 4 0 0 1-1.028.428v3.05a7 7 0 0 0 3.186-1.32l-2.158-2.158z"/><path d="M7 1a7 7 0 0 0-3.186 1.32l2.159 2.159A4 4 0 0 1 7 4.05z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 2h10v6H3zm1 1v4h1V6zm2 0v4h1V6zm2 0v4h1V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><rect width="64" height="64" fill="#e0e0e0" fill-opacity=".2" rx="8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m1 1v14h14v-14zm3 7c1.104 0 2 .896 2 2s-.896 2-2 2-2-.896-2-2 .896-2 2-2zm9 1v2h-6v-2zm-9-7c1.104 0 2 .896 2 2s-.896 2-2 2-2-.896-2-2 .896-2 2-2zm3 1h6v2h-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#44bd44" d="M0 2v8h2V8a3 3 0 0 0 2-.779V10h2V7a1 1 0 0 1 1-1h1V4H7a3 3 0 0 0-2.02.795A3 3 0 0 0 2 2zm8 4v2a2 2 0 0 0 2 2h1a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-1a2 2 0 0 0-2 2zm6-4v2h2V2zM2 4a1 1 0 0 1 0 2zm8 2h1v2h-1zm4 0v3a1 1 0 0 1-1 1h-1v2h1a3 3 0 0 0 3-3V6z"/><path fill="#fff" fill-opacity=".4" d="M7 4a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m1 1v2 10 2h2 12v-2-12h-12zm3.4141 2h8.5859v8.5859zm-1.4141 1.4141 8.5859 8.5859h-8.5859z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="M2 2h12v12H2zm0 0l12 12"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M7.328 1a4.5 4.5 0 0 1 1.414 2H13v8.586L8.307 6.893a4.5 4.5 0 0 1-1.414 1.414L11.586 13H3V8.732a4.5 4.5 0 0 1-2-1.418V15h14V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#ec418e" d="M3 3a3 3 0 0 0 0 6v2h2V8.236A3 3 0 0 0 7 9h2v-.764A3 3 0 0 0 11 9h2V6a3 3 0 0 0 3 3V7a1 1 0 0 1-1-1V5h1V3h-1V1h-2v2h-2a3 3 0 0 0-2 .764V3H7v4a1 1 0 0 1-1-1V3zm0 4a1 1 0 0 1 0-2zm8 0a1 1 0 0 1 0-2z"/><path fill="#fff" fill-opacity=".4" d="M4 3v3a3 3 0 0 0 3 3h2V3H7v4a1 1 0 0 1-1-1V3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#41ec80" d="M7 2v2h2V2zm7 0v2h-1a3 3 0 0 0 0 6h3V2zM4 4a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4zm3 2v4h2V6zm6 0h1v2h-1a1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" d="M8 1C1 1 1 1 1 8s0 7 7 7 7 0 7-7 0-7-7-7zM4.25 2.25a1 1 0 0 1 0 4 1 1 0 0 1 0-4zM8 6a1 1 0 0 1 0 4 1 1 0 0 1 0-4zm3.75 3.75a1 1 0 0 1 0 4 1 1 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#76ad7b" stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="m3 8 1 4 4 1M8 3l4 1 1 4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="16"><path fill="#fff" d="m10 2-9.99983819 6 9.99983819 6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="12" height="16"><path fill="#fff" d="m2 2 10 6-10 6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m7 1v9h-3l4 5 4-5h-3v-9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m7 1v9h-3l4 5 4-5h-3v-9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#f1738f" d="M13 2v2h-1a3 3 0 0 0-2.5 1.346A3 3 0 1 0 7 10h1V8H7a1 1 0 0 1-1-1h3a3 3 0 0 0 3 3h1V8h-1a1 1 0 0 1 0-2h1v1a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2zM3 4a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#f1738f" d="M9 2v2H8a3 3 0 0 0 0 6h1V8H8a1 1 0 0 1 0-2h1v1a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2zM4 4a3 3 0 0 0-3 3v3h2V7a1 1 0 0 1 1-1h1V4z"/><path fill="#5abbef" d="M13 2v2h2V2zm0 4v4h2V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="2" d="M2 4h12v8H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-linejoin="round" stroke-width="2" d="M2 4h12v8H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 9h7V2l-2 2a6.927 8.938-30 0 0-9 11 4.364 6.234-10 0 1 6-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m1 1v2h2v-2zm3 0v2h8v-2zm9 0v2h2v-2zm-12 3v8h2v-8zm12 0v8h2v-8zm-12 9v2h2v-2zm3 0v2h8v-2zm9 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M10 2a1 1 0 1 0 0 2h1.586l-4.52 4.52-4.298-5.16-1.536 1.28 5 6a1 1 0 0 0 1.475.064L13 5.412V7a1 1 0 1 0 2 0V3a1 1 0 0 0-1-1h-4zM1 9v5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-4h-2v3H3V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M6 6h6v6H6z"/><path fill-opacity=".325" d="M1 1v4h4V1zm5 0v4h6V1zm7 0v4h2V1zM1 6v6h4V6zm12 0v6h2V6zM1 13v2h4v-2zm5 0v2h6v-2zm7 0v2h2v-2z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5 8a4 4 0 1 1 4 4v2a6 6 0 1 0-6-6H1l3 4 3-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#e0e0e0" d="M2 7a6 6 0 1 1 6 6v-2a4 4 0 1 0-4-4h2l-3 4-3-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M8 1a8 8 0 0 0-6.928 4 1 1 0 0 0 1.733 1 6 6 0 0 1 10.39 0 1 1 0 0 0 1.733-1A8 8 0 0 0 8 1zm0 4a4 4 0 0 0-3.863 2.965 1 1 0 0 0 1.931.517 2 2 0 0 1 3.864 0 1 1 0 0 0 1.931-.517A4 4 0 0 0 8 5zm0 4a1 1 0 0 0-1 1v1H4a4 4 0 0 0 8 0H9v-1a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M8 1a8 8 0 0 0-6.928 4 1 1 0 0 0 1.733 1 6 6 0 0 1 10.39 0 1 1 0 0 0 1.733-1A8 8 0 0 0 8 1zm0 4a4 4 0 0 0-3.863 2.965 1 1 0 0 0 1.931.517 2 2 0 0 1 3.864 0 1 1 0 0 0 1.931-.517A4 4 0 0 0 8 5zm0 4a1 1 0 0 0-1 1v1H4a4 4 0 0 0 8 0H9v-1a1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m5 1v1h-4v2h14v-2h-4v-1zm-3 4v8a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2v-8zm1 2h2v6h-2zm4 0h2v6h-2zm4 0h2v6h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><circle cx="10.5" cy="12.627" r="2.373"/><path d="m2.766 2.412-.897.897L4.56 6 1.87 8.691l.896.898 2.692-2.692L8.149 9.59l.897-.898L6.355 6l2.691-2.691-.897-.897-2.691 2.69z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5 2v2h2v8H5v2h2a1 1 0 0 0 1-1 1 1 0 0 0 1 1h2v-2H9V4h2V2H9a1 1 0 0 0-1 1 1 1 0 0 0-1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 2a2 2 0 0 0-1 3.73v5.542A2 2 0 1 0 4.73 14h6.542a2 2 0 1 0-.002-2H4.729A2 2 0 0 0 4 11.27V5.729A2 2 0 0 0 3 2z"/><path fill="#5fff97" d="M9 1 5 4l4 3V5a3 3 0 0 1 3 3v2h2V8a5 5 0 0 0-5-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2.5 11.272A2 2 0 1 0 5.23 14h6.05a2 2 0 1 0 0-2H5.23a2 2 0 0 0-.73-.73V8h-2z"/><path fill="#5fff97" d="M10.422 1.881 7.627 3.977l2.795 2.097V4.676c2.717 0 2.18 1.447 2.18 3.927V10H14V8.603c0-3.863.13-5.324-3.578-5.324zM2.5 1v2h-2v2h2v2h2V5h2V3h-2V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1.553 4.104A1 1 0 0 0 1 4.998v6a1 1 0 0 0 .553.895l6 3a1 1 0 0 0 .894 0l6-3a1 1 0 0 0 .553-.895v-6a1 1 0 0 0-.553-.894l-6-3a1 1 0 0 0-.894 0zM8 3.119 11.764 5l-1.381.692-3.764-1.883L8 3.119zm-5 3.5 4 2v3.764l-4-2zm10 0v3.764l-4 2V8.619z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#fc7f7f"><path d="m11.667 4.166h-3.334c-1.841 0-3.333 1.492-3.333 3.334.003 1.188.638 2.283 1.667 2.877v2.956c0 .597.317 1.146.833 1.444.254.146.54.221.833.221v.002h3.334v-.002c.293 0 .579-.075.833-.221.516-.299.833-.851.833-1.444v-2.956c1.028-.594 1.664-1.689 1.667-2.877 0-1.842-1.492-3.334-3.333-3.334zm-2.5 4.166h1.666v.834h-1.666zm-2.5-.832c0-.461.372-.834.833-.834s.833.373.833.834-.372.832-.833.832-.833-.371-.833-.832zm5.833 3.223v2.61h-.833v-.833h-.834v.833h-1.666v-.833h-.834v.833h-.833v-2.608-.725h.833v.832h.834v-.832h1.666v.832h.834v-.832h.833zm0-2.391c-.461 0-.833-.371-.833-.832s.372-.834.833-.834.833.373.833.834-.372.832-.833.832z"/><path d="m4.418 9.334h-.085v.833h-.833v-2.608-.725h.567c.323-2.072 2.104-3.668 4.266-3.668h2.445c-.473-1.263-1.682-2.166-3.111-2.166h-3.334c-1.841 0-3.333 1.492-3.333 3.334.003 1.188.638 2.283 1.667 2.877v2.956c0 .597.317 1.146.833 1.444.254.146.54.221.833.221v.002h1.334v-.929c-.538-.421-.962-.962-1.249-1.571zm-1.751-5c0-.461.372-.834.833-.834s.833.373.833.834-.372.832-.833.832-.833-.371-.833-.832z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a"><stop offset="0" stop-color="#e0e0e0"/><stop offset="1" stop-color="#e0e0e0" stop-opacity="0"/></linearGradient><linearGradient id="b" x1="1" x2="15" gradientUnits="userSpaceOnUse" href="#a"/><linearGradient id="c" x1="15" x2="1" y1="0" y2="0" gradientUnits="userSpaceOnUse" href="#a"/><path fill="url(#b)" d="M1 1h14v4H1z"/><path fill="url(#c)" d="M1 11h14v4H1z"/><path fill="#e0e0e0" d="m6 6 2 4 2-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="M4 2h8M1 8h14M4 14h8"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v2h7V1zm9 0v2h5V1zM1 5v2h11V5zm0 4v2h4V9zm6 0v2h1a1.8 1.8 0 0 1 .328-2zm-6 4v2h8.281a1.8 1.8 0 0 1-1.426-2z"/><path fill="#c38ef1" d="M12.36 8.598a.533 3.2 0 0 0-.51 2.275 3.2.533 30 0 0-.515.887.533 3.2 60 0 0 .515.887.533 3.2 0 0 0 1.02 0 3.2.533 30 0 0 .515-.887.533 3.2 60 0 0-.515-.887.533 3.2 0 0 0-.51-2.275z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m1 1v2h8v-2zm12 0-3 3h2v8h-2l3 3 3-3h-2v-8h2zm-12 4v2h2v-2zm4 0v2h4v-2zm-4 4v2h8v-2zm0 4v2h4v-2zm6 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zm1.951 1.334A6 6 0 0 1 14.001 8h-7a2 2 0 0 0-.95-1.7c1.346-2.029 2.604-3.263 3.9-3.967zm-6.828 2.18c.146.65.358 1.283.684 1.884A2 2 0 0 0 3 8H2a6 6 0 0 1 1.123-3.486zM3.8 9.6a2 2 0 0 0 2.4 0c1.472 2.027 2.728 3.264 3.8 4a6 6 0 0 1-7.15-2.5c.25-.6.5-1 .95-1.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zm1.951 1.334A6 6 0 0 1 14.001 8h-7a2 2 0 0 0-.95-1.7c1.346-2.029 2.604-3.263 3.9-3.967zm-6.828 2.18c.146.65.358 1.283.684 1.884A2 2 0 0 0 3 8H2a6 6 0 0 1 1.123-3.486zM3.8 9.6a2 2 0 0 0 2.4 0c1.472 2.027 2.728 3.264 3.8 4a6 6 0 0 1-7.15-2.5c.25-.6.5-1 .95-1.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><radialGradient id="a" cx="8" cy="8" r="6" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#fc7f7f"/><stop offset=".833" stop-color="#fc7f7f" stop-opacity=".7"/><stop offset="1" stop-color="#fc7f7f" stop-opacity="0"/></radialGradient><path fill="url(#a)" d="M5 2v3H2v2h3v2H2v2h3v3h2v-3h2v3h2v-3h3V9h-3V7h3V5h-3V2H9v3H7V2zm2 5h2v2H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5 8a4 4 0 1 1 4 4v2a6 6 0 1 0-6-6H1l3 4 3-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M 11 8 a 4 4 0 1 0 -4 4 v 2 a 6 6 0 1 1 6 -6 h 2 l -3 4 l -3 -4 z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v14h14zm3 7 4 4H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1Zm1 2h10v8H3Z"/><path fill="#8da5f3" stroke="#8da5f3" stroke-linejoin="round" stroke-width=".75" d="M10.24 9.24H5.76V4.76h4.48L8 7Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="M9 8v7h5a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1v4l-1-1-1 1V8z"/><path fill="none" stroke="#ff5f5f" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2 6h2l2 4l1-8l2 4h3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4l-3-3h-1v6H3zm1 0v5h3V1zm4 8a1 1 0 0 1 0 4 1 1 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 2a3 3 0 0 0 0 6 3 3 0 0 0 0-6zm0 1.75a1 1 0 0 1 0 2.5 1 1 0 0 1 0-2.5zM10.5 2H12L5.5 14H4zM12 8a3 3 0 0 0 0 6 3 3 0 0 0 0-6zm0 1.75a1 1 0 0 1 0 2.5 1 1 0 0 1 0-2.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 0 0 2 2h7a2 2 0 0 0 2-2V5h3V3a2 2 0 0 0-2-2z"/><path fill-opacity=".2" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 1 0 4 0V3a1 1 0 0 1 2 0v3h5V5H8V3a2 2 0 0 0-2-2zM2 11h2v2a1 1 0 0 1-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 0 0 2 2h7v-1H8v-4h2V8h2V5h3V3a2 2 0 0 0-2-2z"/><path fill-opacity=".2" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 1 0 4 0V3a1 1 0 0 1 2 0v3h5V5H8V3a2 2 0 0 0-2-2zM2 11h2v2a1 1 0 0 1-2 0z"/><path fill="#5fff97" d="M13 13h2v-2h-2V9h-2v2H9v2h2v2h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v1h14V3a2 2 0 0 0-2-2zm9 1h1v1h-1zM1 5v8a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5zm5.572 1h3.998a1.143 1.143 0 0 1 1.143 1.143v1.142H7.715V7.143A1.143 1.143 0 0 0 6.572 6zm.57 2.858H10v4A1.143 1.143 0 0 1 8.857 14h-4A1.143 1.143 0 0 0 6 12.857V7.143a.57.57 0 0 1 1.143 0zm-2.855 2.854H5.43v1.143a.564.564 0 0 1-1.143 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 0 0 2 2h7a2 2 0 0 0 1.723-1H8v-4h4V5h3V3a2 2 0 0 0-2-2z"/><path fill-opacity=".2" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 1 0 4 0V3a1 1 0 0 1 2 0v3h5V5H8V3a2 2 0 0 0-2-2zM2 11h2v2a1 1 0 0 1-2 0z"/><path fill="#5fb2ff" d="m16 12-3-3v2H9v2h4v2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 0 0 2 2h5.635l-1.584-1.584 1.414-1.414-1.414-1.414 3.535-3.535L12 8.467V5h3V3a2 2 0 0 0-2-2z"/><path fill-opacity=".2" d="M6 1a2 2 0 0 0-2 2v7H1v3a2 2 0 1 0 4 0V3a1 1 0 0 1 2 0v3h5V5H8V3a2 2 0 0 0-2-2zM2 11h2v2a1 1 0 0 1-2 0z"/><path fill="#ff5f5f" d="m13.414 12 1.414-1.414-1.414-1.414L12 10.586l-1.414-1.414-1.414 1.414L10.586 12l-1.414 1.414 1.414 1.414L12 13.414l1.414 1.414 1.414-1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3zm5 1L4 8l4 4 4-4zm2 2v4H6V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M10.168 8.754a5 5 0 1 0-1.414 1.414l4.316 4.316 1.414-1.414zM6 3a3 3 0 0 1 0 6 3 3 0 0 1 0-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-linecap="round" stroke-width="2" d="m2 14 12-12"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#5fb2ff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 2v12m3-3-3 3-3-3"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#a2d2ff" d="M8 1 3 6a5 2 0 0 0 3 1.8v6.4a2 .8 0 0 0 2 .8z"/><path fill="#2998ff" d="m8 1 5 5a5 2 0 0 1-3 1.8v6.4a2 .8 0 0 1-2 .8V9.5a5 2 0 0 1-2-.2V7.8A5 2 0 0 0 8 8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6l-5-5zm1 2h6v3a1 1 0 0 0 1 1h3v6H3z"/><path fill="#8045ff" d="M10 11h2v1h-2z"/><path fill="#ffe345" d="M4 6h2v1H4z"/><path fill="#80ff45" d="M8 8h4v1H8z"/><path fill="#45d7ff" d="M7 6h1v1H7z"/><path fill="#ff4596" d="M4 11h5v1H4z"/><path fill="#ff4545" d="M4 4h3v1H4z"/><path fill="#45ffa2" d="M4 8h3v1H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V6l-5-5zm1 2h6v3a1 1 0 0 0 1 1h3v6H3zm1 1v1h3V4zm0 2v1h2V6zm3 0v1h1V6zM5 9l3 3 3-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 10h2v2H2zm0 3h2v3H2zm3 3v-6h2a3 3 0 0 1 3 3v3H8v-3a1 1 0 0 0-1-1v4zm10-6h-1a1 1 0 0 0 0 6h1v-2h-1a1 1 0 0 1 0-2h1zM2 1a1 1 0 0 0-1 1v7h2V3h6v3a1 1 0 0 0 1 1h3v2h2V6l-5-5z"/><path fill="#ffe345" d="M4 6h2v1H4z"/><path fill="#80ff45" d="M8 8h4v1H8z"/><path fill="#45d7ff" d="M7 6h1v1H7z"/><path fill="#ff4545" d="M4 4h3v1H4z"/><path fill="#45ffa2" d="M4 8h3v1H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M1 2a1 1 0 0 1 1-1h8l5 5v8a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1zm2 1v10h10V7h-3a1 1 0 0 1-1-1V3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#869ebf" d="M1.553 4.104A1 1 0 0 0 1 5v6a1 1 0 0 0 .553.895l6 3a1 1 0 0 0 .894 0l6-3A1 1 0 0 0 15 11V5a1 1 0 0 0-.553-.894l-6-3a1 1 0 0 0-.894 0zm6.447-1 3.764 1.882L8 6.868 4.236 4.986zm-5 3.5 4 2v3.766l-4-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#bf909c" d="M1.553 4.104A1 1 0 0 0 1 5v6a1 1 0 0 0 .553.895l6 3a1 1 0 0 0 .894 0l6-3A1 1 0 0 0 15 11V5a1 1 0 0 0-.553-.894l-6-3a1 1 0 0 0-.894 0zm6.447-1 3.764 1.882L8 6.868 4.236 4.986zm-5 3.5 4 2v3.766l-4-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M9 8.7a4 4 0 1 0-2 0V10H4l4 5 4-5H9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M9 8.7a4 4 0 1 0-2 0V10H4l4 5 4-5H9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 2a1 1 0 0 0-1 1v9a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1Zm3 2h3L9 7h2l-4 4 1-3H6zM1 4v9a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-1v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V4Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v2.25h6v4.5h3v4.5h5V10h-2.75V7.75H15V5.5H9.25V3.25H15V1z"/><path fill="#5fb2ff" d="M5.04 8.04c-1.534 0-3.475 1.169-4.173 3.423a.6.6 0 0 0 0 .33c.67 2.374 2.673 3.447 4.173 3.447s3.502-1.073 4.177-3.435a.6.6 0 0 0 0-.33C8.557 9.201 6.572 8.04 5.04 8.04zm0 1.2a2.4 2.4 0 0 1 0 4.8 2.4 2.4 0 0 1 0-4.8zm0 1.2a1.2 1.2 0 0 0 0 2.4 1.2 1.2 0 0 0 0-2.4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="m1 3v10h2 4v-2h-4v-6h4v-2h-4zm9 1v3h-5v2h5v3l2.5-2 2.5-2-2.5-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 2a1 1 0 0 0 0 2 8 8 0 0 1 8 8 1 1 0 0 0 2 0A10 10 0 0 0 4 2zm0 4a1 1 0 0 0 0 2 4 4 0 0 1 4 4 1 1 0 0 0 2 0 6 6 0 0 0-6-6zm0 4a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 0a1 1 0 0 0 0 2 8 8 0 0 1 8 8 1 1 0 0 0 2 0A10 10 0 0 0 6 0zm0 4a1 1 0 0 0 0 2 4 4 0 0 1 4 4 1 1 0 0 0 2 0 6 6 0 0 0-6-6zM1 8a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1zm1 2h4v4H2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M6 2a4 4 0 0 0-2 7.453V13a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V9.453A4 4 0 0 0 10 2zM5 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM7 7h2v1H7zM5 9h1v1h1V9h2v1h1V9h1v4h-1v-1H9v1H7v-1H6v1H5V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M6 2a4 4 0 0 0-2 7.453V13a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V9.453A4 4 0 0 0 10 2zM5 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM7 7h2v1H7zM5 9h1v1h1V9h2v1h1V9h1v4h-1v-1H9v1H7v-1H6v1H5V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 2a4 4 0 0 0-2 7.453V13a2 2 0 0 0 2 2h2v-2H7v-1H6v1H5V9h1v1h1V9h1V8H7V7h1V2zM5 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/><path fill="#fc7f7f" d="M8 2v5h1v1H8v1h1v1h1V9h1v4h-1v-1H9v1H8v2h2a2 2 0 0 0 2-2V9.453A4 4 0 0 0 10 2zm3 3a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#b56d6d" d="M8.445 9.308v-3.001c1.613-.944 2.156-3.016 1.213-4.631-.603-1.033-1.709-1.67-2.905-1.676h-3.385c-1.869.008-3.377 1.532-3.368 3.401.005 1.197.643 2.301 1.676 2.906v3.001c0 .934.758 1.692 1.692 1.692h3.385c.935 0 1.692-.758 1.692-1.692zm-4.23-5.077h1.692v.846h-1.692zm-2.539-.846c0-.468.378-.846.847-.846.468 0 .846.378.846.846 0 .467-.378.846-.846.846-.469 0-.847-.379-.847-.846zm5.923 5.923h-.846v-.847h-.846v.846h-1.692v-.846h-.847v.846h-.846v-3.384h.846v.846h.847v-.846h1.692v.846h.846v-.846h.846zm-.846-5.923c0-.468.378-.846.846-.846s.846.378.846.846c0 .467-.378.846-.846.846s-.846-.379-.846-.846zM15.294 8.617c-.198-.132-.424-.219-.658-.251-.122-.867-.921-1.471-1.787-1.351s-1.472.921-1.353 1.788c.034.235.119.46.251.658l-2.286 2.286c-.729-.484-1.712-.287-2.195.443-.486.727-.287 1.71.441 2.194.198.131.423.217.659.25.121.865.922 1.471 1.787 1.35.866-.12 1.471-.919 1.351-1.786-.034-.235-.118-.46-.25-.658l2.286-2.286c.728.483 1.712.285 2.195-.443.484-.727.287-1.711-.441-2.194z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#eee" d="M6 2a4 4 0 0 0-2 7.453V13a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V9.453A4 4 0 0 0 10 2zM5 5a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM7 7h2v1H7zM5 9h1v1h1V9h2v1h1V9h1v4h-1v-1H9v1H7v-1H6v1H5V8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x1="8" x2="8" y1="3" y2="13" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#1ec3ff"/><stop offset="1" stop-color="#b2e1ff"/></linearGradient><path fill="url(#a)" d="M8 3a7 7 0 0 0-7 7 7 7 0 0 0 .686 3h12.63A7 7 0 0 0 15 10a7 7 0 0 0-7-7z"/><path fill="#fff" d="M10 7a1 1 0 0 0-1 1H8a1 1 0 0 0 0 2h2a1 1 0 0 0 1-1h1a1 1 0 0 0 0-2zm-7 3a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M5 1a1 1 0 0 0 0 2h3l-7 7v3L13 1zm10 2L3 15h8a1 1 0 0 0 0-2H8l7-7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fff97" d="m9 3v2h4v6h-4v2h4 2v-10h-2zm-3 1v3h-5v2h5v3l2.5-2 2.5-2-2.5-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 3v2h2V3zm6 0v2h2V3zM3 9v2h2V9zm4 4v2h2v-2zm6 0v2h2v-2z"/><path fill="#fff" fill-opacity=".686" d="M7 13h2v-2a2 2 0 0 1 4 0v2h2v-2a4 4 0 0 0-8 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" fill-opacity=".686" d="M7 13h2v-2a2 2 0 0 1 4 0v2h2v-2a4 4 0 0 0-8 0z"/><path fill="#e0e0e0" d="M4.54 2.14a.5.5 0 0 0-.705.705l2.142 2.142-2.142 2.142a.5.5 0 1 0 .705.705l2.142-2.142 2.142 2.142a.5.5 0 1 0 .705-.705L7.387 4.987l2.141-2.142a.5.5 0 0 0-.705-.705L6.681 4.282zM7 13v2h2v-2zm6 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 0v2H0v1h2v4H0v1h2v4H0v1h2v2h1v-2h3v-1H3V8h4l1-1V3h4v3h1V3h2V2h-2V0h-1v2H8V0H7v2H3V0zm1 3h4v4H3zm4 10v2h2v-2zm6 0v2h2v-2z"/><path fill="#e0e0e0" fill-opacity=".8" d="M7 13h2v-2a2 2 0 0 1 4 0v2h2v-2a4 4 0 0 0-8 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m 7,13 v 2 h 2 v -2 z m 6,0 v 2 h 2 v -2 z"/><path fill="#fff" fill-opacity=".686" d="m 7,13 h 2 v -2 a 2,2 0 0 1 4,0 v 2 h 2 v -2 a 4,4 0 0 0 -8,0 z"/><path fill="#fff" d="M 5,1 1,5 5,9 9,5 Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m 7,13 v 2 h 2 v -2 z m 6,0 v 2 h 2 v -2 z"/><path fill="#fff" fill-opacity=".686" d="m 7,13 h 2 v -2 a 2,2 0 0 1 4,0 v 2 h 2 v -2 a 4,4 0 0 0 -8,0 z"/><path fill="#fff" d="m 1,2 3,3 v 9 H 6 V 5 L 9,2 Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m2 1s-3 5 0 7-1 7-1 7h13s3-6 0-8 1-6 1-6zm2 2h7s-2 3 1 5 0 5 0 5h-7s2-4-1-6 0-4 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M9 1v2h6V1zM4 1a1 1 0 0 0-.691.291l-2 2a1 1 0 0 0 1.414 1.414l.293-.293v7.172l-.293-.293a1 1 0 0 0-1.414 1.414l2 2a1 1 0 0 0 1.414 0l2-2a1 1 0 0 0-1.414-1.414l-.293.293V4.412l.293.293a1 1 0 0 0 1.414-1.414l-2-2A1 1 0 0 0 4 1zm5 6v2h4V7zm0 6v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-width="2" d="M8 2a6 6 0 0 0 0 12A6 6 0 0 0 8 2v12M2.05 7.4a6 2 0 0 0 11.9 0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M6.607 1.139A4.5 4.5 0 1 1 1.141 6.61a7 7 0 1 0 5.466-5.47z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="7" fill="#5fb2ff"/><circle cx="6" cy="5" r="2" fill="#a2d2ff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h7V3zm10 1-2 3h4zM3 5h5v6H3zm8 4 2 3 2-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M15 3a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2zm-2 0v4h-3L8 5 6 7H3V3zm0 6v4H3V9h3l2 2 2-2z" transform="rotate(45 4.241 9.083)scale(.737)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M6 1a1 1 0 0 0-1 1v3.693A5 5 0 0 0 2 10h4a2 2 0 0 0 4 0h4a5 5 0 0 0-3-4.307V2a1 1 0 0 0-1-1zm-1.098 9.635-1.732 1 1 1.73 1.732-1zm6.196 0-1 1.73 1.732 1 1-1.73zM7 13v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-width="2" d="m8 14 6-6M2 2l7 7M10 9h-6M9 9v-5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#b56d6d" d="M7.375 5.053c-.488.733-.289 1.724.445 2.213.2.133.426.219.664.252.122.873.927 1.481 1.8 1.36.874-.121 1.483-.928 1.36-1.801-.033-.238-.119-.464-.25-.664l1.373-1.372c.733.486 1.724.288 2.211-.445.488-.734.291-1.725-.444-2.213-.199-.132-.427-.219-.664-.251-.121-.874-.927-1.483-1.8-1.362s-1.482.928-1.361 1.803c.033.236.119.465.251.664l-1.372 1.37c-.734-.488-1.725-.289-2.213.446zM8.625 10.949c.488-.734.289-1.727-.444-2.215-.2-.131-.427-.217-.665-.25-.122-.873-.927-1.482-1.8-1.361s-1.482.928-1.36 1.802c.033.236.119.464.252.663l-1.373 1.373c-.734-.488-1.724-.289-2.212.445s-.289 1.724.445 2.212c.199.132.426.219.664.252.121.873.927 1.481 1.8 1.36.874-.123 1.482-.926 1.36-1.801-.033-.236-.118-.465-.252-.664l1.374-1.373c.732.49 1.723.292 2.211-.443z"/><circle cx="12" cy="12" r="3" fill="#5c7d8e"/><circle cx="11.143" cy="10.714" r=".856" fill="#728387"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M7.375 5.053c-.488.733-.289 1.724.445 2.213.2.133.426.219.664.252.122.873.927 1.481 1.8 1.36.874-.121 1.483-.928 1.36-1.801-.033-.238-.119-.464-.25-.664l1.373-1.372c.733.486 1.724.288 2.211-.445.488-.734.291-1.725-.444-2.213-.199-.132-.427-.219-.664-.251-.121-.874-.927-1.483-1.8-1.362s-1.482.928-1.361 1.803c.033.236.119.465.251.664l-1.372 1.37c-.734-.488-1.725-.289-2.213.446zM8.625 10.949c.488-.734.289-1.727-.444-2.215-.2-.131-.427-.217-.665-.25-.122-.873-.927-1.482-1.8-1.361s-1.482.928-1.36 1.802c.033.236.119.464.252.663l-1.373 1.373c-.734-.488-1.724-.289-2.212.445s-.289 1.724.445 2.212c.199.132.426.219.664.252.121.873.927 1.481 1.8 1.36.874-.123 1.482-.926 1.36-1.801-.033-.236-.118-.465-.252-.664l1.374-1.373c.732.49 1.723.292 2.211-.443z"/><path fill="#5fb2ff" d="m10.286 10.857v2.285c0 1.578 1.278 2.856 2.856 2.856s2.858-1.277 2.858-2.855v-2.285c0-1.579-1.279-2.858-2.857-2.858s-2.857 1.279-2.857 2.857z"/><circle cx="12.286" cy="10" r=".857" fill="#a2d2ff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="-399.5 200.5 16 16"><path fill="#fc7f7f" d="M-392.125 205.553c-.488.733-.289 1.725.445 2.213.2.132.426.218.664.252.121.872.927 1.481 1.8 1.36.874-.121 1.483-.928 1.361-1.801-.033-.238-.119-.464-.251-.664l1.373-1.372c.734.487 1.724.288 2.212-.445.488-.734.29-1.725-.445-2.213-.199-.132-.426-.219-.664-.251-.121-.874-.927-1.483-1.8-1.362s-1.482.928-1.361 1.802c.033.236.119.465.251.664l-1.372 1.371c-.734-.488-1.725-.289-2.213.446zM-390.875 211.449c.488-.734.289-1.726-.444-2.214-.2-.132-.427-.218-.665-.251-.122-.873-.927-1.482-1.8-1.361s-1.482.928-1.36 1.802c.033.236.119.463.252.663l-1.373 1.373c-.734-.488-1.724-.289-2.212.445s-.289 1.724.445 2.212c.199.132.426.219.664.252.121.873.927 1.482 1.8 1.36.874-.122 1.482-.926 1.36-1.8-.033-.237-.118-.465-.252-.664l1.374-1.373c.732.489 1.723.29 2.211-.444z"/><path fill="#5fb2ff" d="m-389.5 216.5 6-.5v-5.5l-6-.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M7.375 5.053c-.488.733-.289 1.724.445 2.213.2.133.426.219.664.252.122.873.927 1.481 1.8 1.36.874-.121 1.483-.928 1.36-1.801-.033-.238-.119-.464-.25-.664l1.373-1.372c.733.486 1.724.288 2.211-.445.488-.734.291-1.725-.444-2.213-.199-.132-.427-.219-.664-.251-.121-.874-.927-1.483-1.8-1.362s-1.482.928-1.361 1.803c.033.236.119.465.251.664l-1.372 1.37c-.734-.488-1.725-.289-2.213.446zM8.625 10.949c.488-.734.289-1.727-.444-2.215-.2-.131-.427-.217-.665-.25-.122-.873-.927-1.482-1.8-1.361s-1.482.928-1.36 1.802c.033.236.119.464.252.663l-1.373 1.373c-.734-.488-1.724-.289-2.212.445s-.289 1.724.445 2.212c.199.132.426.219.664.252.121.873.927 1.481 1.8 1.36.874-.123 1.482-.926 1.36-1.801-.033-.236-.118-.465-.252-.664l1.374-1.373c.732.49 1.723.292 2.211-.443z"/><circle cx="12" cy="12" r="3" fill="#5fb2ff"/><circle cx="11.143" cy="10.714" r=".856" fill="#a2d2ff"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="-399.5 200.5 16 16"><g fill="#fc7f7f"><path d="M-392.125 205.553c-.488.733-.289 1.725.445 2.213.2.132.426.218.664.252.121.872.927 1.481 1.8 1.36.874-.121 1.483-.928 1.361-1.801-.033-.238-.119-.464-.251-.664l1.373-1.372c.734.487 1.724.288 2.212-.445.488-.734.29-1.725-.445-2.213-.199-.132-.426-.219-.664-.251-.121-.874-.927-1.483-1.8-1.362s-1.482.928-1.361 1.802c.033.236.119.465.251.664l-1.372 1.371c-.734-.488-1.725-.289-2.213.446zM-390.875 211.449c.488-.734.289-1.726-.444-2.214-.2-.132-.427-.218-.665-.251-.122-.873-.927-1.482-1.8-1.361s-1.482.928-1.36 1.802c.033.236.119.463.252.663l-1.373 1.373c-.734-.488-1.724-.289-2.212.445s-.289 1.724.445 2.212c.199.132.426.219.664.252.121.873.927 1.482 1.8 1.36.874-.122 1.482-.926 1.36-1.8-.033-.237-.118-.465-.252-.664l1.374-1.373c.732.489 1.723.29 2.211-.444z"/><path d="m-397.222 209.5c0 .276.224.5.5.5s.5-.224.5-.5c0-3.263 2.46-5.723 5.722-5.723.276 0 .5-.224.5-.5s-.224-.5-.5-.5c-3.832 0-6.722 2.89-6.722 6.723z"/><path d="M-398 207.723c0-3.263 2.46-5.723 5.722-5.723.276 0 .5-.224.5-.5s-.224-.5-.5-.5c-3.832 0-6.722 2.89-6.722 6.723 0 .276.224.5.5.5s.5-.224.5-.5zM-385.778 207.5c0-.276-.224-.5-.5-.5s-.5.224-.5.5c0 3.263-2.46 5.723-5.722 5.723-.276 0-.5.224-.5.5s.224.5.5.5c3.832 0 6.722-2.89 6.722-6.723z"/><path d="m-384.5 208.777c-.276 0-.5.224-.5.5 0 3.263-2.46 5.723-5.722 5.723-.276 0-.5.224-.5.5s.224.5.5.5c3.832 0 6.722-2.89 6.722-6.723 0-.276-.224-.5-.5-.5z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M5 1a4 4 0 0 0-4 4v6a4 4 0 0 0 4 4h6a4 4 0 0 0 4-4V5a4 4 0 0 0-4-4zM3 7a1 1 0 0 1 2 0v2a1 1 0 0 1-2 0zm10 2a1 1 0 0 1-2 0V7a1 1 0 0 1 2 0zm-2.172 3.828a4 4 0 0 1-5.656 0 1 1 0 0 1 1.414-1.414 2 2 0 0 0 2.828 0 1 1 0 0 1 1.414 1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M5 1a4 4 0 0 0-4 4v6a4 4 0 0 0 4 4h6a4 4 0 0 0 4-4V5a4 4 0 0 0-4-4zM3 7a1 1 0 0 1 2 0v2a1 1 0 0 1-2 0zm10 2a1 1 0 0 1-2 0V7a1 1 0 0 1 2 0zm-2.172 3.828a4 4 0 0 1-5.656 0 1 1 0 0 1 1.414-1.414 2 2 0 0 0 2.828 0 1 1 0 0 1 1.414 1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm10 0v2h2V1zM2 6a1 1 0 0 1 2 0v1a1 1 0 0 1-2 0zm6 0a1 1 0 0 1 2 0v1a1 1 0 0 1-2 0zm5-1v2h2V5zM4 9h4a2 1 0 0 1-4 0zm9 0v2h2V9zM1 13v2h2v-2zm4 0v2h2v-2zm4 0v2h2v-2zm4 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h2v2H3zm4 0h2v2H7zm4 0h2v2h-2zM3 7h2v2H3zm4 0h2v2H7zm4 0h2v2h-2zm-8 4h2v2H3zm4 0h2v2H7zm4 0h2v2h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linejoin="round" stroke-width="2" d="m8 2 6 3v6l-6 3-6-3V5zm0 12V8l6-3M8 8 2 5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H3zm0 1h10a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1zm0 1v2h2V3zm8 0v2h2V3zm-8 8v2h2v-2zm8 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H3zm0 1h10a1 1 0 0 1 1 1v10a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1zm0 1v2h2V3zm8 0v2h2V3zm-8 8v2h2v-2zm8 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ff5f5f" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zM5.172 3.758 8 6.586l2.828-2.828 1.414 1.414L9.414 8l2.828 2.828-1.414 1.414L8 9.414l-2.828 2.828-1.414-1.414L6.586 8 3.758 5.172l1.414-1.414z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 1 5.184 3H2a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1h-3.184ZM3 5h2.584L8 3.4 10.416 5H13v8H3Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fff97" d="M8 1a7 7 0 1 0 0 14A7 7 0 0 0 8 1zm3.293 3.877 1.414 1.414L7 12.001 3.293 8.29l1.414-1.414L7 9.17z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffdd65" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zM7 3h2v7H7zm0 8h2v2H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="10" height="10" x="3" y="3" fill="#e0e0e0" rx="1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m11.505 10.226-1.1835 1.144 2.0923 2.0225-1.5006 1.4505h4.1844v-4.0448l-1.5006 1.4505-2.0923-2.0225zm-6.9268-0.057673-2.1184 2.0477-1.5193-1.4686v4.0954h4.2367l-1.5193-1.4686 2.1184-2.0477-1.1982-1.1582zm6.3009-9.0107 1.513 1.4625-2.1097 2.0393 1.1933 1.1535 2.1097-2.0393 1.513 1.4625v-4.0786zm-9.9385-1.96e-5v4.0954l1.5193-1.4686 2.1184 2.0477 1.1982-1.1583-2.1184-2.0477 1.5193-1.4686h-4.2367z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#4593ec" d="M7 2H4a2.5 2.5 0 0 0 0 5 .5.5 0 0 1 0 1H1v2h3a2.5 2.5 0 0 0 0-5 .5.5 0 0 1 0-1h3zm1 0v5a3 3 0 0 0 3 3V8a1 1 0 0 1-1-1V6h1V4h-1V2zm4 8h2V7a1 1 0 0 1 1-1V4a3 3 0 0 0-3 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#4593ec" d="M3 2a2.5 2.5 0 0 0 0 5 .5.5 0 0 1 0 1H0v2h3a2.5 2.5 0 0 0 0-5 .5.5 0 0 1 0-1h3v3a3 3 0 0 0 3 3h3V6a2 2 0 0 1 2 2v2h2V8a4 4 0 0 0-4-4H8V2zm7 4v2H9a1 1 0 0 1-1-1V6z"/><path fill="#fff" fill-opacity=".4" d="M6 2v5a3 3 0 0 0 3 3h1V8H9a1 1 0 0 1-1-1V6h2V4H8V2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M2 1a1 1 0 0 0-1 1v1h2V1zm3 0v2h2V1zm4 0v2h2V1zm4 0v2h2V2a1 1 0 0 0-1-1zM1 5v2h2V5zm12 0v.232c.316.179.578.438.76.752L14.459 7H15V5zM1 9v2h2V9zm0 4v1a1 1 0 0 0 1 1h1v-2zm4 0v2h2v-2zm7-6c-.429.746-.946 1.387-1.429 2-.571.69-1.066 1.342-1.34 2-.138.326-.231.656-.231 1s.072.686.184 1c.413 1.163 1.512 2 2.816 2s2.402-.837 2.816-2c.112-.314.184-.656.184-1s-.094-.674-.231-1c-.275-.658-.77-1.31-1.34-2-.484-.613-1-1.254-1.43-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M1 14a1 1 0 0 0 1 1h6.037a5.044 5.044 0 0 1-.92-2A4.735 4.735 0 0 1 7 12c0-.356.045-.687.117-1 .18-.784.546-1.435.938-2 .14-.203.285-.402.424-.584.386-.505.763-.968 1.103-1.416.257-.338.495-.67.686-1a2 2 0 0 1 3.465 0c.188.327.428.66.685 1 .186.246.38.494.582.75V2a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1Zm11-7c-.429.746-.946 1.387-1.429 2-.571.69-1.066 1.342-1.34 2-.138.326-.231.656-.231 1s.072.686.184 1c.413 1.163 1.512 2 2.816 2s2.402-.837 2.816-2c.112-.314.184-.656.184-1s-.094-.674-.231-1c-.275-.658-.77-1.31-1.34-2-.484-.613-1-1.254-1.43-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#000b" d="M0 0h16v16H0z"/><path fill="none" stroke="#e0e0e0" stroke-width="2" d="M5 1v14m6 0V1m4 4H1m0 6h14"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M1.734 12.053a1.5 1.5 0 0 0 2.4 2.441l2.893-2.941c.27-1.337.636-1.988 1.028-2.553l2.213-3a2 2 0 0 1 2.845-.64l1.39-1.413a1.5 1.5 0 0 0-2.401-2.441zM12 7c-.429.746-.946 1.387-1.429 2-.571.69-1.066 1.342-1.34 2-.138.326-.231.656-.231 1s.072.686.184 1c.413 1.163 1.512 2 2.816 2s2.402-.837 2.816-2c.112-.314.184-.656.184-1s-.094-.674-.231-1c-.275-.658-.77-1.31-1.34-2-.484-.613-1-1.254-1.43-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M8.1 15a4.5 4.5 0 0 1-1.02-2H3V3h10v2.232a2.031 2.031 0 0 1 .76.752L15 7.75V2a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1zM8 5v1H6v1H5v1H4v1h4l2.24-3a2.031 2.031 0 0 1 .76-.752V5h-1V4H9v1zm4 2c-.429.746-.946 1.387-1.429 2-.571.69-1.066 1.342-1.34 2-.138.326-.231.656-.231 1s.072.686.184 1c.413 1.163 1.512 2 2.816 2s2.402-.837 2.816-2c.112-.314.184-.656.184-1s-.094-.674-.231-1c-.275-.658-.77-1.31-1.34-2-.484-.613-1-1.254-1.43-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0" stroke-width="1.25"><rect width="12.75" height="10.75" x="1.625" y="2.625" rx="1.5"/><rect width="6.75" height="6.75" x="4.625" y="4.625" rx="1.5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#8eef97"><rect width="12" height="12" x="2" y="2" stroke-width="2" rx="1"/><rect width="6.75" height="6.75" x="4.625" y="4.625" stroke-width="1.25" rx="1.5"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a"><stop offset=".25" stop-color="#ffe345"/><stop offset=".75" stop-color="#919191"/></linearGradient><path fill="#45d7ff" d="M4 4v2h5V4z"/><path fill="#ff4596" d="M11 4v2h4V4Z"/><path fill="#ff4545" d="M1 8v2h3V8z"/><path fill="url(#a)" d="M6 8v2h7V8z"/><path fill="#919191" d="M1 12v2h5v-2zm7 0v2h6v-2z"/><path fill="#e0e0e0" d="M1 1.5h1.25V6H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m5.787 1-.402 1.613c-.352.265-.71.122-1.012-.111l-.904-.541L2.46 2.973l.853 1.425c-.058.438-.412.586-.79.635-.343.065-.674.216-1.024.213V6.72c.367 0 .715.157 1.074.224.371.032.716.243.727.65l-.84 1.4 1.008 1.01c.443-.266.895-.53 1.33-.802.349-.044.675.139.674.506l.314 1.258h1.45c.117-.475.242-.954.35-1.428A.67.67 0 0 1 8 9.195V7.5H6.5A.5.5 0 0 0 6 8v.5H4v-4h5.75c-.005-.22.107-.434.254-.625l.543-.902L9.535 1.96l-1.426.853c-.437-.058-.588-.412-.636-.79L7.217 1h-1.43z"/><path fill="#ff5f5f" d="M4.5 5v3h1a1 1 0 0 1 1-1h2v6a1 1 0 0 1-1 1v1h4v-1a1 1 0 0 1-1-1V7h2a1 1 0 0 1 1 1h1V5h-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M5.5 4c-1.108 0-1.818.907-2 2l-1 6H1v2h14v-2h-1.5l-1-6c-.182-1.093-.892-2-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h5v4h5v6H3zm7 0h3v2h-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m2 13 5.0000552-5-5.0000552-5M9 13h5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 16 16"><g fill="#e0e0e0"><circle cx="8" cy="8" r="2"/><path d="M7 3.5H6L8 1l2 2.5H9v2H7zM3.56 4.975l-.706.707L2.5 2.5l3.182.353-.707.708.707.707-1.414 1.414zm7.465-1.415-.707-.706L13.5 2.5l-.353 3.182-.708-.707-.707.707-1.414-1.414zm1.415 7.465.706-.707.354 3.182-3.182-.354.707-.707-.707-.707 1.414-1.414zM4.975 12.44l.707.707L2.5 13.5l.354-3.182.707.707.707-.707 1.414 1.414zM12.5 7V6L15 8l-2.5 2V9h-2V7zM9 12.5h1L8 15l-2-2.5h1v-2h2zM3.5 9v1L1 8l2.5-2v1h2v2z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M15 1H9v3h3v3h3zM1 15h6v-3H4V9H1z"/><path fill="#77ce57" d="M1 1h6v3H4v3H1zM15 15H9v-3h3V9h3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M6 1h4v3H9L8 5 7 4H6z"/><path fill="#77ce57" d="M1 15h4v-3H4v-1H1zm14 0h-4v-3h1v-1h3zm0-14h-4v3h1v1h3zM1 1h4v3H4v1H1z"/><path fill="#ffca5f" d="M6 15h4v-3H9l-1-1-1 1H6zm-5-5V6h3v1l1 1-1 1v1zm14 0V6h-3v1l-1 1 1 1v1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#77ce57" d="M1 14V2l3 3v2l1 1-1 1v2zm14 0V2l-3 2.706v2l-1 1 1 1v2z"/><path fill="#ffca5f" d="M2 15h12l-3-3H9l-1-1-1 1H5zM14 1H2l3 3h2l1 1 1-1h2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 16 16"><g fill="#e0e0e0"><circle cx="3" cy="13" r="2"/><circle cx="13" cy="3" r="2"/><path d="M7 2v10H3v2h6V4h4V2z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v10H3zm1 1v4h1V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" stroke="#e0e0e0" stroke-linejoin="round" stroke-width="2" d="M4 12V4l7 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M14 12h1v-2h-4v2h1v4h2zm-8.3-2h1.7l.6 1.5.6-1.5h1.7l-1.2 3 1.2 3H8.6L8 14.5 7.4 16H5.7l1.2-3zM4 12h1v-2H1v2h1v4h2ZM9 1l.564 2.258.69.28 1.988-1.194 1.414 1.414-1.196 1.994.286.684L15 7v2H9.75a2 2 0 1 0-3.5 0H1V7l2.26-.564.278-.688-1.194-1.99 1.414-1.414L5.752 3.54l.686-.286L7 1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffca5f" d="M1 1h14v4h-1a2 2 0 0 0-2-2H9v9a2 2 0 0 0 2 2v1H5v-1a2 2 0 0 0 2-2V3H4a2 2 0 0 0-2 2H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="gray"><path d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3z"/><path fill-opacity=".2" d="M3.5 3.5h9v7h-9"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3zm1 1h3v1H5.5v4H7v1H4zm8 6H9V9h1.5V5H9V4h3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="gray"><path d="M1 14a1 1 0 0 0 1 1h9.5a1 1 0 0 0 .707-.293l2.5-2.5A1 1 0 0 0 15 11.5V2a1 1 0 0 0-1-1H4.5a1 1 0 0 0-.707.293l-2.5 2.5A1 1 0 0 0 1 4.5zm1.25-9H11v7H2.25zm10 6.25v-6.5L14 3v6.5zm-1-7.5H3L4.75 2H13z"/><path fill-opacity=".2" d="M2.75 5.5h7.75v6H2.75"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M8 1v2h6v10h-4v2h6V1zM3 2v3.133l-1.445-.965-1.11 1.664 3 2a1 1 0 0 0 1.11 0l3-2-1.11-1.664L5 5.133V2zm7 4v1H9v1H8v1h1v2h4V9h-1V7h-1V6zm-7.5 4A1.5 1.5 0 0 0 1 11.5V13H0v2h8v-2H7v-1.5A1.5 1.5 0 0 0 5.5 10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#000" stroke-linejoin="round" stroke-opacity=".8" stroke-width="2" d="m8 1 7 3v8l-7 3-7-3V4Z"/><path fill-opacity=".8" d="M2 5h12v6l-12-.008Z" paint-order="stroke fill markers"/><path fill="#c2c2c2" d="m8 7.5-7 3V12l7 3 7-3v-1.5z"/><path fill="#d6d6d6" d="m8 15-7-3v-1.5l7 3z"/><path fill="#f9f9f9" d="m1 10.5 7 3 7-3-7-3z"/><path fill="#c2c2c2" d="m8 4.25-7 3v1.5l7 3 7-3v-1.5z"/><path fill="#d6d6d6" d="m8 11.75-7-3v-1.5l7 3z"/><path fill="#f9f9f9" d="m1 7.25 7 3 7-3-7-3z"/><path fill="#c2c2c2" d="M8 1 1 4v1.5l7 3 7-3V4Z"/><path fill="#f9f9f9" d="m1 4 7 3 7-3-7-3z"/><path fill="#d6d6d6" d="m8 8.5-7-3V4l7 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 3a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V5a2 2 0 0 0-2-2zm0 2h10v6H3zm1 1h1v2H4zm2 1h1v3H6zm2-1h1v4H8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="m1 1v14h14v-14zm2 2h10v10h-10zm6 3v1h-1v1h-2v1h-1v1h-1v1h2 2 2 2v-2h-1v-2h-1v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="url(#a)" d="M8 1c-.75 1.305-1.654 2.427-2.5 3.5-1 1.208-1.865 2.349-2.346 3.5-.24.57-.404 1.148-.404 1.75s.126 1.2.322 1.75C3.795 13.535 5.718 15 8 15s4.205-1.465 4.928-3.5c.196-.55.322-1.148.322-1.75s-.164-1.18-.404-1.75C12.365 6.849 11.5 5.708 10.5 4.5 9.654 3.427 8.753 2.305 8 1Z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 7h8v2H6zM1 6h4v4H1zm5-4h8v2H6zM1 1h4v4H1zm5 11h8v2H6zm-5-1h4v4H1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><path fill="#8eef97" d="M8 14.25a1 1 0 0 0 1.084-1.084V9.753l3.851 1.927a1.084 1.084 0 0 0 .97-1.94L10.424 8l3.481-1.74a1.084 1.084 0 0 0-.97-1.94L9.084 6.247V2.834A1 1 0 0 0 8 1.75z"/><path fill="url(#a)" d="M8 1.75a1 1 0 0 0-1.084 1.084v3.413L3.065 4.32a1 1 0 0 0-.97 1.94L5.576 8 2.095 9.74a1 1 0 0 0 .97 1.94l3.851-1.927v3.413A1 1 0 0 0 8 14.25z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y2="16" gradientUnits="userSpaceOnUse"><stop offset=".188" stop-color="#ff4545"/><stop stop-color="#ffe345"/><stop offset=".313" stop-color="#ffe345"/><stop stop-color="#80ff45"/><stop offset=".438" stop-color="#80ff45"/><stop stop-color="#45ffa2"/><stop offset=".563" stop-color="#45ffa2"/><stop stop-color="#45d7ff"/><stop offset=".688" stop-color="#45d7ff"/><stop stop-color="#8045ff"/><stop offset=".813" stop-color="#8045ff"/><stop stop-color="#ff4596"/></linearGradient><circle cx="8" cy="8" r="5" fill="none" stroke="url(#a)" stroke-width="2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" stroke="#e0e0e0" d="M1.5 1.5h3v3h-3zm0 5h3v3h-3zm0 5h3v3h-3z"/><path fill="#e0e0e0" d="M6 2h8v2H6zm0 5h8v2H6zm0 5h8v2H6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" stroke="#e0e0e0" d="M1.5 1.5h3v3h-3zm0 5h3v3h-3zm0 5h3v3h-3zm5-10h3v3h-3zm0 5h3v3h-3zm0 5h3v3h-3z"/><path fill="#e0e0e0" d="M11 2h3v2h-3zm0 5h3v2h-3zm0 5h3v2h-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M1 8a7 7 0 0 1 7-7h48a7 7 0 0 1 7 7v48a-7 7 0 0 1-7 7H8 a-7-7 0 0 1-7-7zM8 8l8 8M8 56l8-8M56 56l-8-8M56 8l-8 8"/><path fill="#e0e0e0" d="M22 18a2 2 0 0 0-2 2c0 3 1.934 5.25 3.746 7.32 1.52 1.74 2.832 3.286 3.75 4.68-.918 1.394-2.228 2.944-3.75 4.684C21.934 38.754 20 41 20 44a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2c0-3-1.934-5.246-3.746-7.316-1.52-1.74-2.832-3.29-3.75-4.684.918-1.394 2.228-2.94 3.75-4.68C42.066 25.25 44 23 44 20a2 2 0 0 0-2-2zm16.824 4c-.476.88-.61 1.58-1.578 2.684-1.688 1.928-3.796 3.944-5.036 6.42A2 2 0 0 0 32 32a2 2 0 0 0-.212-.894c-1.238-2.478-3.346-4.494-5.034-6.422-.968-1.106-1.102-1.802-1.58-2.684z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="gray" rx="2.33"/><path fill="#fff" d="M11.5 3.734 5.89 9.346 4.185 7.665l-1.5 1.499 3.204 3.18L13 5.235z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M1 1v2h2V1zm3 0v2h2V1zm3 0v2h2V1zm3 0v2h2V1zm3 0v2h2V1zM1 4v2h2V4zm3 0v2h2V4zm3 0v2h2V4zm3 0v2h2V4zm3 0v2h2V4zM1 7v2h2V7zm3 0v2h2V7zm3 0v2h2V7zm3 0v2h2V7zm3 0v2h2V7zM1 10v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2zM1 13v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2zm3 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4.5 5.25H15v2H4.5zM2 4.283v-1h1l1 2zm0 4v1h1l1-2zm-.621-2.707-.707.707.707.707L3.5 6.283zM4.5 1.75H15v2H4.5zm0 7H15v2H4.5zm0 3.5H15v2H4.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M8 2 6.25 3.375 8 4.75l1.75-1.375zm2.624 2.062-1.75 1.375 1.75 1.375 1.75-1.375Zm2.626 2.063L11.5 7.5l1.75 1.375L15 7.5ZM5.376 4.062l-1.75 1.375 1.75 1.375 1.75-1.375zM8 6.124 6.25 7.499 8 8.874l1.75-1.375zm2.626 2.063-1.75 1.375 1.75 1.375 1.75-1.375ZM2.75 6.125 1 7.5l1.75 1.375L4.5 7.5Zm2.624 2.062-1.75 1.375 1.75 1.375 1.75-1.375ZM8 10.25l-1.75 1.375L8 13l1.75-1.375z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="5" height="5"><g fill="none"><path stroke="#fff" d="M.5.5h4v4h-4z"/><path stroke="#000" d="M1.5 1.5h2v2h-2z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v2h2V1zm3 0v2h2V1zm3 0v2h2V1zm3 0v2h2V1zm3 0v2h2V1zM1 4v2h2V4zm3 0v2h2V4zm3 0v2h2V4zm3 0v2h2V4zm3 0v2h2V4zM1 7v2h2V7zm3 0v2h2V7zm5 1v7h5a1 1 0 0 0 1-1V9a1 1 0 0 0-1-1v4l-1-1-1 1V8zm-8 2v2h2v-2zm3 0v2h2v-2zm-3 3v2h2v-2zm3 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="14" height="14" x="1" y="1" fill="gray" rx="2.333"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="1.25" d="M7 1.5h2m-1 0v2.875m0-1.25a5.625 5.625 0 0 0 0 11.25v-1.25m0 1.25a5.625 5.625 0 0 0 0-11.25m5.375 5.625h-1m-9.875 0h1m4.5 0 2-2"/><circle cx="8" cy="8.75" r="1" fill="#e0e0e0"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fff" d="m3 0h10l-4 4h-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 1a1 1 0 0 0-1 1c0 1.5.967 2.625 1.873 3.66.76.87 1.416 1.643 1.875 2.34-.459.697-1.114 1.472-1.875 2.342C2.967 11.377 2 12.5 2 14a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1c0-1.5-.967-2.623-1.873-3.658-.76-.87-1.416-1.645-1.875-2.342.459-.697 1.114-1.47 1.875-2.34C13.033 4.625 14 3.5 14 2a1 1 0 0 0-1-1zm8.412 2c-.238.44-.305.79-.789 1.342-.844.964-1.898 1.972-2.518 3.21A1 1 0 0 0 8 8a1 1 0 0 0-.106-.447c-.619-1.239-1.673-2.247-2.517-3.211-.484-.553-.551-.901-.79-1.342z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="100" height="24" stroke-linejoin="round"><path fill="#e0e0e0" d="M40.122 11.514c-1.211-.019-2.597.234-2.597.234v2.364h1.393l-.015 1.052q0 .587-1.159.587c-1.159 0-1.454-.328-2.045-.979q-.89-.98-.889-2.867 0-1.89.865-2.79.866-.899 2.261-.899c.411.003.821.067 1.214.191q.63.192.844.358.212.172.405.17.19 0 .616-.45.43-.45.767-1.359c.224-.61.337-1.076.337-1.407a6 6 0 0 0-.023-.674q-.47-.517-1.744-.821-1.268-.305-2.844-.304-3.463 0-5.419 2.181-1.957 2.182-1.957 5.668 0 4.094 2.001 6.207 2.002 2.114 5.263 2.113 1.754 0 3.114-.303 1.361-.303 1.811-.619l.09-7.038c0-.408-1.079-.594-2.289-.615M51.279 8.23q-1.078 0-1.81.989-.73.99-.731 2.776 0 1.79.698 2.745.697.957 1.832.957c1.135 0 1.372-.323 1.844-.969q.709-.966.709-2.766c0-1.8-.244-2.122-.731-2.767q-.73-.965-1.811-.965m-.011 11.85q-3.16 0-5.15-2.067-1.989-2.07-1.989-6.039 0-3.97 2.011-6.017 2.014-2.046 5.196-2.046 3.183-.001 5.138 2.014 1.958 2.013 1.957 6.094t-2.001 6.073q-2.002 1.988-5.162 1.988M64.77 8.386v6.727q0 .47.068.595c.068.125.18.124.404.124q1.238 0 1.879-.923.641-.921.64-3.069c-.001-2.148-.222-2.366-.663-2.799q-.664-.654-2.103-.655zm-4.317 10.436V5.33q0-.563.282-.891a.92.92 0 0 1 .73-.326h3.756q3.575 0 5.429 1.801 1.857 1.798 1.857 5.666 0 8.276-7.063 8.276h-3.845q-1.146 0-1.147-1.034M81.186 8.23q-1.08 0-1.812.989-.73.99-.73 2.776 0 1.79.697 2.745.697.957 1.833.957c1.136 0 1.372-.323 1.844-.969q.709-.966.709-2.766c0-1.8-.244-2.122-.731-2.767q-.73-.965-1.81-.965m-.012 11.85q-3.16 0-5.15-2.067-1.99-2.07-1.99-6.039 0-3.97 2.012-6.017 2.014-2.046 5.196-2.046c3.182 0 3.834.67 5.138 2.014q1.957 2.013 1.957 6.094t-2.002 6.073q-2.001 1.988-5.161 1.988m15.587-.552q0 .448-2.226.449-2.227-.001-2.228-.449V8.238h-2.698q-.382 0-.539-1.036a7 7 0 0 1-.066-1.011q0-.517.065-1.012c.105-.688.285-1.036.54-1.036h9.783q.382.001.541 1.036a7.7 7.7 0 0 1 0 2.023q-.16 1.036-.541 1.036h-2.631z"/><g fill="#fefefe" transform="translate(-.27 -1.335)scale(.02592)"><path d="M105 673v33q407 354 814 0v-33z"/><path fill="#478cbf" d="m105 673 152 14q12 1 15 14l4 67 132 10 8-61q2-11 15-15h162q13 4 15 15l8 61 132-10 4-67q3-13 15-14l152-14V427q30-39 56-81-35-59-83-108-43 20-82 47-40-37-88-64 7-51 8-102-59-28-123-42-26 43-46 89-49-7-98 0-20-46-46-89-64 14-123 42 1 51 8 102-48 27-88 64-39-27-82-47-48 49-83 108 26 42 56 81zm0 33v39c0 276 813 276 814 0v-39l-134 12-5 69q-2 10-14 13l-162 11q-12 0-16-11l-10-65H446l-10 65q-4 11-16 11l-162-11q-12-3-14-13l-5-69z"/><path d="M483 600c0 34 58 34 58 0v-86c0-34-58-34-58 0z"/><circle cx="725" cy="526" r="90"/><circle cx="299" cy="526" r="90"/></g><g fill="#414042" transform="translate(-.27 -1.335)scale(.02592)"><circle cx="307" cy="532" r="60"/><circle cx="717" cy="532" r="60"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 3a1 1 0 0 1 1-1h8a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1zm5.25 0a1 1 0 0 1 1 1v1.75H11a1 1 0 0 1 1 1v.5a1 1 0 0 1-1 1H9.25V11a1 1 0 0 1-1 1h-.5a1 1 0 0 1-1-1V9.25H5a1 1 0 0 1-1-1v-.5a1 1 0 0 1 1-1h1.75V5a1 1 0 0 1 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M16 11.46 9.858 8.933l-1.572-.647.647 1.572L11.46 16l.913-2.72 1.815 1.817.91-.909-1.818-1.815zM10.478 1a2.466 2.466 0 0 0-2.094 3.824l-3.56 3.56a2.466 2.466 0 1 0-1.705 4.496 2.466 2.466 0 1 0 4.496-1.705l.17-.17-.886-2.152a1.48 1.48 0 0 1 1.958-1.957l2.151.885.167-.166a2.466 2.466 0 1 0 1.705-4.496A2.466 2.466 0 0 0 10.478 1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><rect width="14" height="2" x="1" y="7" ry=".75"/><path d="M5 1v14l8-7z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><circle cx="8" cy="8" r="2"/><path d="M8 1a1 1 0 0 0-.691.291l-2 2 1.414 1.414 1.293-1.293 1.293 1.293 1.414-1.414-2-2A1 1 0 0 0 8 1zM3.309 5.291l-2 2a1 1 0 0 0 0 1.414l2 2 1.414-1.414L3.43 7.998l1.293-1.293-1.414-1.414zm9.414 0-1.414 1.414 1.293 1.293-1.293 1.293 1.414 1.414 2-2a1 1 0 0 0 0-1.414l-2-2zm-6 6-1.414 1.414 2 2a1 1 0 0 0 1.414 0l2-2-1.414-1.414-1.293 1.293-1.293-1.293z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M11 2a1 1 0 0 0-2 0v6H8V3a1 1 0 0 0-2 0v8.05l-2.5-1.8A1 1 0 0 0 1.875 11L6 15h6a2 2 0 0 0 2-2V4a1 1 0 0 0-2 0v4h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><circle cx="8" cy="8" r="2"/><path d="M8 1a7 7 0 0 0-4.982 11.998H1.911v2h4a1 1 0 0 0 .97-1.242l-1-4-1.94.486.28 1.121a5 5 0 1 1 7.223.168l1.416 1.416A7 7 0 0 0 8 1z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><circle cx="8" cy="8" r="2"/><path d="M9 1a1 1 0 0 0 0 2h2.586l-1.293 1.293 1.414 1.414L13 4.414V7a1 1 0 0 0 2 0V2a1 1 0 0 0-1-1zM3 9a1 1 0 0 0-2 0v5a1 1 0 0 0 1 1h5a1 1 0 0 0 0-2H4.414l1.293-1.293-1.414-1.414L3 11.586V9z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M14 6.932 2 1.995l4.936 12 1.421-4.23 2.826 2.825 1.412-1.412L9.77 8.352z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1.695 10.034 8.814 2.17l5.83 11.729z"/><g fill="#414042" stroke="#e0e0e0" stroke-width=".5"><circle cx="8.661" cy="2.322" r="1.6"/><circle cx="13.932" cy="13.4" r="1.6"/><circle cx="2.169" cy="10" r="1.6"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M4 1 3 3l1 2v4H2v3.5a2.5 2.5 0 0 0 5 0V9H5V5l1-2-1-2zm6 .174a3 3 0 0 0 0 5.652V14a1 1 0 0 0 2 0V6.824a3 3 0 0 0 0-5.648V4a1 1 0 0 1-2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#ffca5f"><path stroke-width="2" d="M2.5 10a6 4 0 0 0 11 0 4 4 0 0 0 0-4 6 4 0 0 0-11 0 4 4 0 0 0 0 4z"/><path stroke-linecap="round" stroke-width="1.75" d="M6.2 7.2a2 1 0 1 0 3.6 0"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M3 1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2V4H3V2h8v2H9v1h2a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm5 7V4a1 1 0 0 0-2 0v7.05l-2.5-1.8A1 1 0 0 0 1.875 11L6 15h6a2 2 0 0 0 2-2v-3a2 2 0 0 0-2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="#e1da5b" d="M2 1a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h4a1 1 0 0 0 1-1v-.75H3.4c-.3 0-.4-.2-.4-1v-.5c0-.8.1-1 .4-1H7V2a1 1 0 0 0-1-1zm5.5 6h2l.75-1.5h2L13 7h2l-3-6h-1.5zm3.75-4 .5 1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><rect width="6.1" height="6.1" x="1.95" y="1.95" fill="#fff" ry=".763" transform="rotate(-45 5 5)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="none" stroke="#e0e0e0" stroke-linecap="round" stroke-width="2" d="M2 6c6 0 6-4 12-4"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="8"><path fill="#b9ec41" d="M14 1a1 1 0 0 0 0 2 1 1 0 0 0 0-2zM8 3a1 1 0 0 0 0 2 1 1 0 0 0 0-2zM2 5a1 1 0 0 0 0 2 1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#b9ec41" d="M0 2v2h2v6h2V4h3a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h7a4 4 0 0 0 0-8h-2v6H7a3 3 0 0 0 0-6zm12 2a2 2 0 0 1 0 4z"/><path fill="#fff" fill-opacity=".4" d="M6.5 2v2H7a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8H7a3 3 0 0 0 0-6h-.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#f68f45" d="M4 4h3.349a1 1.267 0 0 1-1 1.267v1a.866.866 0 0 1 0 1.732h-1v2h1a2.81 2.81 0 0 0 2.232-4.734A1.32 1.32 0 0 0 9.345 4V2H0v2h2v6h2zm6 6h2a4 4 0 0 0 0-8h-2zm2-6a2 2 0 0 1 0 4z"/><path fill="#fff" fill-opacity=".4" d="M5.5 4h1.849a1 1.267 0 0 1-1 1.267v1a.866.866 0 0 1 0 1.732h-1v2h1a2.81 2.81 0 0 0 2.232-4.734A1.32 1.32 0 0 0 9.345 4V2H5.5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M2.988 3c-.547.01-.987.451-.988.998v8a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 2.988 3z"/><rect width="3.068" height="10.067" x="11.17" y="3.008" ry=".763"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#77ce57"><path d="M3.555 3.168A1 1 0 0 0 2 4v8a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664z"/><rect width="3.068" height="10.067" x="11.17" y="3" ry=".763"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"><g fill="#77ce57" stroke="#414042" stroke-width="1.41"><path d="M2.836 2.996a1.413 1.413 0 0 0-1.394 1.407v11.28a1.41 1.41 0 0 0 2.192 1.173l8.46-5.64a1.41 1.41 0 0 0 0-2.346l-8.46-5.64a1.41 1.41 0 0 0-.798-.234z"/><rect width="4.326" height="14.194" x="14.371" y="3.008" ry="1.076"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"><g fill="#e0e0e0" stroke="#414042" stroke-width="1.42"><path d="M2.79 3.175a1.424 1.424 0 0 0-1.403 1.417v11.363c0 1.134 1.264 1.811 2.208 1.182l8.522-5.681a1.42 1.42 0 0 0 0-2.364L3.595 3.411a1.42 1.42 0 0 0-.805-.236z"/><rect width="4.358" height="14.299" x="14.411" y="3.187" ry="1.084"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 12a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 2 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#77ce57" d="M2 12a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 2 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"><path fill="#77ce57" stroke="#414042" stroke-width="1.571" d="M5.111 2.306c-.86.015-1.55.708-1.553 1.568v12.568c0 1.254 1.399 2.003 2.443 1.307l9.426-6.284a1.571 1.571 0 0 0 0-2.614L6.001 2.567a1.57 1.57 0 0 0-.89-.261z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"><path fill="#e0e0e0" stroke="#414042" stroke-width="1.571" d="M5.111 2.306c-.86.015-1.55.708-1.553 1.568v12.568c0 1.254 1.399 2.003 2.443 1.307l9.426-6.284a1.571 1.571 0 0 0 0-2.614L6.001 2.567a1.57 1.57 0 0 0-.89-.261z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#e0e0e0"><path d="M7.543 3c-.547.01-.988.451-.989.998v8a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 7.543 3z"/><rect width="3.068" height="10.067" x="1.966" y="3.008" ry=".763"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#77ce57"><path d="M8.07 3c-.547.01-.987.451-.988.998v8a1 1 0 0 0 1.554.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 8.07 3z"/><rect width="3.068" height="10.067" x="1.966" y="3.008" ry=".763"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"><g fill="#77ce57" stroke="#414042" stroke-width="1.41"><path d="M9.209 2.996a1.413 1.413 0 0 0-1.394 1.407v11.28a1.41 1.41 0 0 0 2.192 1.173l8.46-5.64a1.41 1.41 0 0 0 0-2.346l-8.46-5.64a1.41 1.41 0 0 0-.798-.234z"/><rect width="4.326" height="14.194" x="1.626" y="3.008" ry="1.076"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"><g fill="#e0e0e0" stroke="#414042" stroke-width="1.42"><path d="M8.96 3.175a1.424 1.424 0 0 0-1.404 1.417v11.363c0 1.134 1.264 1.811 2.208 1.182l8.522-5.681a1.42 1.42 0 0 0 0-2.364L9.764 3.411a1.42 1.42 0 0 0-.804-.236z"/><rect width="4.358" height="14.299" x="1.462" y="3.187" ry="1.084"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M7 2a1 1 0 0 0-1.715-.697 3 3 0 1 0 0 5.392A1 1 0 0 0 7 6zM4 3a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm6.887 3.53-1.79.894.29.576H7v2h.82a5.432 5.432 0 0 0 1.2 2.73c-.616.163-1.357.266-2.266.27v2c1.677-.01 3.041-.313 4.111-.834 1.07.52 2.434.826 4.111.834v-2c-.909 0-1.65-.106-2.266-.27A5.432 5.432 0 0 0 13.932 10H15V8h-3.379zM9.863 10h2.024a3.432 3.432 0 0 1-1.012 1.783A3.432 3.432 0 0 1 9.863 10z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M1 1v13a1 1 0 0 0 1 1h13v-2H3V7h2v3a1 1 0 0 0 1 1h9V9H7V7h8V5H3V3h12V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" d="M2 4h12zm0 4h12zm0 4h12z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#ffca5f" stroke-linejoin="round" stroke-width="2" d="M11.75 2a5 8 0 0 1 0 11h-8.5a5 8 0 0 1 0 -11z M4 7.5 h7"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#c38ef1" d="m7 1v2h6v6h2v-8zm-1 4 1.793 1.793-4.793 4.793v-4.5859h-2v8h8v-2h-4.5859l4.793-4.793 1.793 1.793v-5h-5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" xml:space="preserve" width="16" height="12"><path fill="#41ec80" d="M 5,10 V 4 H 3 V 8 C 2.4477153,8 2,7.5522847 2,7 V 4 H 0 v 3 c 0,1.6568542 1.3431458,3 3,3 z" transform="translate(1)"/><path fill="#41ec80" d="m 6.9999479,2 v 2 h 2 V 2 Z m 7.0000001,0 v 2 h -1 c -3.9999981,0 -3.9999981,6 0,6 h 3 V 2 Z M 6.9999479,6 v 4 h 2 V 6 Z m 6.0000001,0 h 1 v 2 h -1 c -1.333333,0 -1.333333,-2 0,-2 z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M8 9H1V2l2 2a3.875 5 30 0 1 9 11 3.5 5 10 0 0-6-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M 8 1.6992188 L 5.6269531 5.796875 L 1 6.8945312 L 4.2363281 10.302734 L 3.8769531 14.976562 L 8.0175781 12.998047 L 12.173828 14.941406 L 11.777344 10.287109 L 15 6.8945312 L 10.373047 5.796875 L 8 1.6992188 z M 8 4.2773438 L 9.4882812 6.8457031 L 12.388672 7.5332031 L 10.369141 9.6601562 L 10.617188 12.576172 L 8.0097656 11.359375 L 5.4160156 12.599609 L 5.640625 9.6699219 L 3.6113281 7.5332031 L 6.5117188 6.8457031 L 8 4.2773438 z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" fill-opacity=".4" d="M7 1v6H1v8h8V9h6V1zm2 2h4v4H9z"/><path fill="#fff" d="M7 1v2h2V1H7zm6 0v2h2V1h-2zM1 7v2h2V7H1zm6 0v2h2V7H7zm6 0v2h2V7h-2zM1 13v2h2v-2H1zm6 0v2h2v-2H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#e0e0e0" stroke-linecap="round"><path stroke-width="2" d="M4.22 8.1a3 3 0 1 0 3.68 2.1M8.1 4.22a3 3 0 1 1 2.1 3.68"/><path d="M3.5 5.5 h-2 M5.5 3.5 v-2 M4.5 4.5 l-2 -2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M13 6a5 5 0 0 0-7.498-4.326l1 1.732A3 3 0 0 1 11 6v2H2v7h12V8h-1zm-6 4h2v3H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#a3e595" d="M4.5 1h7v14h-7z" opacity=".5"/><path fill="none" stroke="#a3e595" stroke-width="2" d="M10.5 15V2m-5 0v13M15 2H1"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#95c6e8" d="M8 2.744C4 5.1 1 9.519 1 14v1h14v-1c0-4.48-3-8.9-7-11.256z" opacity=".5"/><path fill="none" stroke="#95c6e8" stroke-linecap="square" stroke-width="2" d="M14 2C8 2 2 8 2 14m12 0C14 8 8 2 2 2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 5v4a3 3 0 0 0 6 0V5H5v4a1 1 0 0 1-2 0V5zm8 0 2 7h3l2-7h-2l-1.5 5.25L11 5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v2H3zm0 4h10v2H3zm0 4h10v2H3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#8eef97" stroke-width="2"><rect width="12" height="12" x="2" y="2" rx="1"/><path stroke-linecap="round" d="M5 11V9m0-3V5m3 6h0m0-3V5m3 6V7"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M5 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm2.988 1a1 1 0 0 1 .567.168l3 2a1 1 0 1 1-1.11 1.664L8 4.203l-2.445 1.63a1 1 0 1 1-1.11-1.665l3-2A1 1 0 0 1 7.988 2zM4.99 9.992a1 1 0 0 1 .565.176L8 11.798l2.445-1.63a1 1 0 1 1 1.11 1.664l-3 2a1 1 0 0 1-1.11 0l-3-2a1 1 0 0 1 .545-1.84z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M2 11h3V5H2zm5 4h2V1H7zm4-4h3V5h-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M5 1a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm5 0a1 1 0 0 0 0 2h2a1 1 0 0 0 0-2zM6 6.867a4 4 0 0 1-2 0v7.13a1 1 0 0 0 2 0zM11 7a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm-1 6a1 1 0 0 0 0 2h2a1 1 0 0 0 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M15 3a2 2 0 0 0-2-2H3a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2zm-2 0v4h-3L8 5 6 7H3V3zm0 6v4H3V9h3l2 2 2-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#41ecad" d="M3 3a3 3 0 0 0 0 6h2V3zm3 0v6h2V5a1 1 0 0 1 1 1v3h2V6a3 3 0 0 0-3-3zm5 2a3 3 0 0 0 3 3 1 1 0 0 1-1 1h-1v2h1a3 3 0 0 0 3-3V3h-2v3a1 1 0 0 1-1-1V3h-2zM3 7a1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" stroke-width="1.5" d="M9.5 11.75a2.5 2.5 0 0 0 5 0 2.5 2.5 0 0 0-5 0h-3l-3-3v-2A2.5 2.5 0 0 0 6 4.25h3.5a2.5 2.5 0 0 0 5 0 2.5 2.5 0 0 0-5 0m-3.5 0a2.5 2.5 0 1 0-2.5 2.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#ac73f1" d="M12 2v2h1a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8h-3a3 3 0 0 0 0-6zM1 4v6h2a3 3 0 0 0 3-3V4H4v3a1 1 0 0 1-1 1V4zm9 6V8H9a1 1 0 0 1 0-2h1V4H9a3 3 0 0 0 0 6z"/><path fill="#fff" fill-opacity=".4" d="M12 2v2h1a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8h-3a3 3 0 0 0 0-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#ac73f1" d="M8 2v2h1a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8H9a3 3 0 0 0 0-6zM1 4v6h2a3 3 0 0 0 3-3V4H4v3a1 1 0 0 1-1 1V4z"/><path fill="#fff" fill-opacity=".4" d="M8 2v2h1a1 1 0 0 1 0 2 2 2 0 0 0-2 2v2h5V8H9a3 3 0 0 0 0-6z"/><path fill="#5abbef" d="M13 2v2h2V2zm0 4v4h2V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#de66f0" d="M11 2v2h2a1 1 0 0 1-1 1v2a1 1 0 0 1 0 2h-1v2h1a3 3 0 0 0 2.232-5A3 3 0 0 0 15 4V2zM1 4v6h2a3 3 0 0 0 3-3V4H4v3a1 1 0 0 1-1 1V4zm9 6V8H9a1 1 0 0 1 0-2h1V4H9a3 3 0 0 0 0 6z"/><path fill="#fff" fill-opacity=".4" d="M11 2v2h2a1 1 0 0 1-1 1v2a1 1 0 0 1 0 2h-1v2h1a3 3 0 0 0 2.232-5A3 3 0 0 0 15 4V2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#de66f0" d="M8 2v2h2a1 1 0 0 1-1 1v2a1 1 0 0 1 0 2H8v2h1a3 3 0 0 0 2.232-5A3 3 0 0 0 12 4V2zM1 4v6h2a3 3 0 0 0 3-3V4H4v3a1 1 0 0 1-1 1V4z"/><path fill="#fff" fill-opacity=".4" d="M8 2v2h2a1 1 0 0 1-1 1v2a1 1 0 0 1 0 2H8v2h1a3 3 0 0 0 2.232-5A3 3 0 0 0 12 4V2z"/><path fill="#5abbef" d="M13 2v2h2V2zm0 4v4h2V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#f066bd" d="M11 3v5h3v3h2V2h-2v4h-1V3zM1 4v6h2a3 3 0 0 0 3-3V4H4v3a1 1 0 0 1-1 1V4zm9 6V8H9a1 1 0 0 1 0-2h1V4H9a3 3 0 0 0 0 6z"/><path fill="#fff" fill-opacity=".4" d="M11 3v5h3v3h2V2h-2v4h-1V3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#f066bd" d="M7 3v5h3v3h2V2h-2v4H9V3zM1 4v6h2a3 3 0 0 0 3-3V4H4v3a1 1 0 0 1-1 1V4z"/><path fill="#fff" fill-opacity=".4" d="M7 3v5h3v3h2V2h-2v4H9V3z"/><path fill="#5abbef" d="M13 2v2h2V2zm0 4v4h2V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M5 3a1 1 0 0 0-1 .75L3 7H1v4h1.05A2.5 2.5 0 0 1 4.5 9a2.5 2.5 0 0 1 2.45 2h2.1a2.5 2.5 0 0 1 2.45-2 2.5 2.5 0 0 1 2.45 2H15V7h-4V3zm1 1h4v3H6zm-1.5 6a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3zm7 0a1.5 1.5 0 0 0 0 3 1.5 1.5 0 0 0 0-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zm0 2a5 5 0 0 1 0 10A5 5 0 0 1 8 3zm0 1a4 4 0 0 0 0 8 4 4 0 0 0 0-8zm0 1a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM6 7a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM8 9a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="gray" d="m12 2 a-1 1 0 0 1 0 2a 8 8 0 0 0-8 8a-1 1 0 0 1-2 0a10 10 0 0 1 10-10zm0 4A-1 1 0 0 1 12 8a4 4 0 0 0-4 4A-1 1 0 0 1 6 12a6 6 0 0 1 6-6zm-2 4.5 a.667.667 0 0 1 1-0.566l2.667 1.674a.667.667 0 0 1 0 1.149l-2.667 1.674a.667 0.667 0 0 1-1-.566z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8eef97" d="M3 1a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2zm0 2h10v8H3zm3 2v4l4-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" x2="0" y1="2" y2="14" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ff8dbc"/><stop offset=".4" stop-color="#7260ff"/><stop offset=".6" stop-color="#7260ff"/><stop offset="1" stop-color="#74c9ff"/></linearGradient><path fill="url(#a)" d="M15 1H1v1h2v2H1v8h2v2H1v1h14v-1h-2v-2h2V4h-2V2h2zm-4 1v2H9V2zm0 10v2H9v-2zM7 2v2H5V2zm0 10v2H5v-2zM6 6.107a.75.75 0 0 1 1.125-.637l3 1.883a.75.75 0 0 1 0 1.293l-3 1.883A.75.75 0 0 1 6 9.892z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="12.75" height="10.75" x="1.625" y="2.625" fill="none" stroke="gray" stroke-width="1.25" rx="1.5"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path d="M6.029 0a2 2 0 0 0-2 2v2.31a2 2 0 0 0-2.895 2.334l.996 2.989a2 2 0 0 0 1.106 1.158L.933 12.328a2 2 0 0 0 2.217 3.328l4.101-2.734.986 1.972a2 2 0 0 0 2.422 1.004l3-1a2 2 0 0 0 .594-3.441 2 2 0 0 0 .591-2.36l-1-2A2 2 0 0 0 12.029 6h-.42a2 2 0 0 0 .42-1V2a2 2 0 0 0-2-2z"/><path fill="#fff" d="M6.029 1a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h1v.99a1 1 0 0 0-.317.063l-2.05.683-.684-2.05a1 1 0 0 0-1.899.63l1 3a1 1 0 0 0 1.266.633l1.683-.56v.61c0 .042.02.076.024.116l-4.578 3.053a1 1 0 1 0 1.11 1.664L7.64 11.46l1.494 2.986a1 1 0 0 0 1.21.502l3-1a1 1 0 1 0-.632-1.896l-2.178.724-.974-1.95a.981.981 0 0 0 .468-.827V9h1.383l.723 1.447a1 1 0 1 0 1.789-.894l-1-2A1 1 0 0 0 12.028 7h-3V6h1a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm0 2h1v2h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><rect width="12.75" height="10.75" x="1.625" y="2.625" fill="none" stroke="#e0e0e0" stroke-width="1.25" rx="1.5"/><path fill="#e0e0e0" d="M9 6v1H8v1H6v1H5v1H4v1h8V9h-1V7h-1V6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path d="M10 1.6a5.96 5.96 0 1 0-1.465 9.763l3.8 3.8a1 1 0 0 0 1.414 0l1.414-1.414a1 1 0 0 0 0-1.414l-3.8-3.8A5.85 5.85 0 0 0 11.576 8H13a1 1 0 0 0 1-1V6h1a1 1 0 0 0 1-1V3a1 1 0 0 0-1-1h-1V1a1 1 0 0 0-1-1h-2a1 1 0 0 0-1 1z"/><path fill="#fff" d="M6 1a5 5 0 1 0 2.752 9.166l4.318 4.318 1.414-1.414-4.318-4.318a5 5 0 0 0 .41-.752H10V6H9a3 3 0 1 1-1-2.232V2h.99A5 5 0 0 0 6 1zm5 0v2H9v2h2v2h2V5h2V3h-2V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M1 1v3h1V2h2V1zm11 0v1h2v2h1V1zM8 2C5.443 2 2.209 3.948 1.045 7.705a1 1 0 0 0 0 .55C2.163 12.211 5.5 14 8 14s5.836-1.789 6.961-5.725a1 1 0 0 0 0-.55C13.861 3.935 10.554 2 8 2zm0 2a4 4 0 0 1 0 8 4 4 0 0 1 0-8zm0 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-7 6v3h3v-1H2v-2zm13 0v2h-2v1h3v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M1 1v3h1V2h2V1zm11 0v1h2v2h1V1zM8 2C5.443 2 2.209 3.948 1.045 7.705a1 1 0 0 0 0 .55C2.163 12.211 5.5 14 8 14s5.836-1.789 6.961-5.725a1 1 0 0 0 0-.55C13.861 3.935 10.554 2 8 2zm0 2a4 4 0 0 1 0 8 4 4 0 0 1 0-8zm0 2a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm-7 6v3h3v-1H2v-2zm13 0v2h-2v1h3v-3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="M12 1v6h2V1zM8 3C5.443 3 2.21 4.948 1.045 8.705a1 1 0 0 0 0 .55C2.163 13.211 5.5 15 8 15c1.492 0 3.273-.652 4.712-2H10v-.541a4 4 0 1 1 0-6.918V3.359A6.121 6.121 0 0 0 8 3zm0 4a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm4 2v2h2V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M12 1v6h2V1zM8 3C5.443 3 2.21 4.948 1.045 8.705a1 1 0 0 0 0 .55C2.163 13.211 5.5 15 8 15c1.492 0 3.273-.652 4.712-2H10v-.541a4 4 0 1 1 0-6.918V3.359A6.121 6.121 0 0 0 8 3zm0 4a2 2 0 0 0 0 4 2 2 0 0 0 0-4zm4 2v2h2V9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="#b56d6d"><circle cx="3" cy="3" r="2"/><circle cx="13" cy="3" r="2"/><circle cx="13" cy="13" r="2"/><circle cx="3" cy="13" r="2"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M3 10v6h2a3 3 0 0 0 3-3v-3H6v3a1 1 0 0 1-1 1v-4zm8 0a2 2 0 0 0 0 4H9v2h2a2 2 0 0 0 0-4h2v-2zM2 1a1 1 0 0 0-1 1v7h2V3h6v3a1 1 0 0 0 1 1h3v2h2V6l-5-5z"/><path fill="#ffe345" d="M4 6h2v1H4z"/><path fill="#80ff45" d="M8 8h4v1H8z"/><path fill="#45d7ff" d="M7 6h1v1H7z"/><path fill="#ff4545" d="M4 4h3v1H4z"/><path fill="#45ffa2" d="M4 8h3v1H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 2h10v10H2zm9 2L7 8 5 6 3 9h8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#6f91f0" d="M2 0a2 2 0 0 0-2 2v2h2v2a3 3 0 0 1 2.5 1.346A3 3 0 0 1 9 6.768a3 3 0 0 1 4 0V4h2v5a1 1 0 0 0 1 1V2a2 2 0 0 0-2-2zm0 8v2a1 1 0 0 0 0-2zm5 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm4 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm-6.5 2.654A3 3 0 0 1 2 12H0v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-2a3 3 0 0 1-2.5-1.346 3 3 0 0 1-4.5.578 3 3 0 0 1-4.5-.578z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><g fill-opacity=".4"><path fill="#fff" d="M3.04 5.52a4 4 0 1 0 3.958 6.94 4 4 0 1 0 3.965-6.942 4 4 0 1 0-7.923 0z"/><path fill="#fff" d="M4.21 6.106A3 3 0 1 0 7 11.233 3 3 0 1 0 9.785 6.11a3 3 0 1 0-5.575 0z"/><circle cx="7" cy="5" r="3" fill="red"/><circle cx="5" cy="9" r="3" fill="#00f"/><circle cx="9" cy="9" r="3" fill="#0f0"/><circle cx="7" cy="5" r="3" fill="red"/><circle cx="5" cy="9" r="3" fill="#00f"/><circle cx="9" cy="9" r="3" fill="#0f0"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#fff" d="M4 1a1 1 0 0 0-1 1v1H1v2h2v4H1v2h2v1a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V8h2V6h-2V2a1 1 0 0 0-1-1z"/><g fill-opacity=".863"><path fill="red" d="M5 3h4v2H5z"/><path fill="#0f0" d="M5 6h4v2H5z"/><path fill="#00f" d="M5 9h4v2H5z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#fff" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z"/><g fill-opacity=".4"><path fill="#fff" d="M7 2a3 3 0 0 0-3 3 3 3 0 0 0 .21 1.106A3 3 0 0 0 2 9a3 3 0 0 0 3 3 3 3 0 0 0 2-.767A3 3 0 0 0 9 12a3 3 0 0 0 3-3 3 3 0 0 0-2.215-2.89A3 3 0 0 0 10 5a3 3 0 0 0-3-3z"/><circle cx="7" cy="5" r="3" fill="red"/><circle cx="5" cy="9" r="3" fill="#00f"/><circle cx="9" cy="9" r="3" fill="#0f0"/><circle cx="7" cy="5" r="3" fill="red"/><circle cx="5" cy="9" r="3" fill="#00f"/><circle cx="9" cy="9" r="3" fill="#0f0"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#e0e0e0" d="m3 1v2h-2v2h2v4h-2v2h2v2h2v-2h4v2h2v-2h2v-2h-2v-4h2v-2h-2v-2h-2v2h-4v-2zm2 4h4v4h-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M7 3.5 4 5l3 1.5L10 5zM3.5 6v3l2.9 1.45v-3zm7 0L7.6 7.45v3L10.5 9z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm4.973 2a.714.714 0 0 1 .347.074l4.286 2.143a.714.714 0 0 1 .394.64v4.286a.714.714 0 0 1-.394.638L7.32 11.924a.714.714 0 0 1-.64 0L2.395 9.78A.714.714 0 0 1 2 9.143V4.857a.714.714 0 0 1 .395-.64L6.68 2.074A.714.714 0 0 1 6.973 2zM7 3.514 4.31 4.858 7 6.2l2.69-1.343zM3.428 6.012v2.69l2.857 1.427V7.44zm7.144 0-2.857 1.43v2.687L10.572 8.7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#f9f9f9" stroke-linecap="round" stroke-width="2" d="M2 11c8 0 9 0 9-9"/><path fill="#5fb2ff" d="M10.8 4a2 2 0 0 0 0 4 2 2 0 0 0 0-4zM6 8.8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#f9f9f9" stroke-linecap="round" stroke-width="2" d="M2 11c8 0 9 0 9-9"/><path fill="#5fb2ff" d="M10.8 4a2 2 0 0 0 0 4 2 2 0 0 0 0-4zM6 8.8a2 2 0 0 0 0 4 2 2 0 0 0 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#cf68ea" d="M4.5 3A3.5 3.5 0 0 0 1 6.5V13h2.5v-2.5H6V8H3.5V6.5a1 1 0 0 1 1-1H6V3zm3 0L10 8l-2.5 5H10l1.25-2.5L12.5 13H15l-2.5-5L15 3h-2.5l-1.25 2.5L10 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#cf68ea" stroke-width="2" d="M3 10 a 2 2 0 0 0 4 0v-6a2 2 0 0 1 4 0v1 M4 7h6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#cf68ea" d="M4 1a1 1 0 0 0-1 1v1H1v2h2v4H1v2h2v1a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V8h2V6h-2V2a1 1 0 0 0-1-1zm1 3 4 3-4 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#cf68ea" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm4 2h5v2H6a1 1 0 0 0 0 2h2a3 3 0 1 1 0 6H3v-2h5a1 1 0 0 0 0-2H6a3 3 0 1 1 0-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#35d4f4" d="M4.5 3A3.5 3.5 0 0 0 1 6.5V13h2.5v-2.5H6V8H3.5V6.5a1 1 0 0 1 1-1H6V3zm3 0L10 8l-2.5 5H10l1.25-2.5L12.5 13H15l-2.5-5L15 3h-2.5l-1.25 2.5L10 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><circle cx="7" cy="7" r="6" fill="#f9f9f9"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#cf68ea" stroke-width="2" d="M3 10 a 2 2 0 0 0 4 0v-6a2 2 0 0 1 4 0v1 M4 7h6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#cf68ea" d="M4 1a1 1 0 0 0-1 1v1H1v2h2v4H1v2h2v1a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V8h2V6h-2V2a1 1 0 0 0-1-1zm1 3 4 3-4 3z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#cf68ea" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm4 2h5v2H6a1 1 0 0 0 0 2h2a3 3 0 1 1 0 6H3v-2h5a1 1 0 0 0 0-2H6a3 3 0 1 1 0-6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 2h10v10H2zm9 2L7 8 5 6 3 9h8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 2h10v10H2zm9 2L7 8 5 6 3 9h8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 2h10v10H2zm9 2L7 8 5 6 3 9h8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#eac968" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm0 2h10v10H2zm9 2L7 8 5 6 3 9h8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><linearGradient id="a" x1="1" x2="13" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#77ce57"/><stop offset="1" stop-color="#ea686c"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-width="2" d="m2 2 5 5-5 5m0-5h10"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><linearGradient id="a" x1="1" x2="13" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#ea686c"/><stop offset="1" stop-color="#77ce57"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-width="2" d="M12 2 7 7l5 5m0-5H2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#ea686c" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zM1 1h3v1H2v10h2v1H1zm9 0h3v12h-3v-1h2V2h-2zm1 10H9V6.414L7.707 7.707a1 1 0 0 1-1.414 0L5 6.414V11H3V4a1 1 0 0 1 1.707-.707L7 5.586l2.293-2.293A1 1 0 0 1 11 4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><g fill="none" stroke-linejoin="round" stroke-width="2"><path stroke="#77ce57" d="m9 4 2 6 2-6"/><path stroke="#ea686c" d="M1 11V4l2 3 2-3v7"/></g><circle cx="7.5" cy="7.5" r="1" fill="#77ce57"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#77ce57" d="M2 0a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm6 0 3 3-3 3V4H3V2h5zM4.344 5.629 7 10.056l2.656-4.427 1.715 1.03-3.514 5.857a1 1 0 0 1-1.714 0L2.629 6.658z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><linearGradient id="a" x1="1" x2="13" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#cf68ea"/><stop offset="1" stop-color="#77ce57"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-width="2" d="m2 2 5 5-5 5m0-5h10"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><linearGradient id="a" x1="1" x2="13" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#77ce57"/><stop offset="1" stop-color="#cf68ea"/></linearGradient><path fill="none" stroke="url(#a)" stroke-linecap="round" stroke-width="2" d="M12 2 7 7l5 5m0-5H2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#77ce57" stroke-linecap="round" stroke-width="2" d="M2 12 12 2"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="none" stroke="#77ce57" stroke-width="2" d="M3 10 a 2 2 0 0 0 4 0v-6a2 2 0 0 1 4 0v1 M4 7h6"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"><path fill="#77ce57" d="M8 0v2H3v2h5v2l3-3zM4.344 5.627l-1.715 1.03 3.514 5.857a1 1 0 0 0 1.714 0l3.514-5.858-1.715-1.029L7 10.055z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10"><path fill="#fff" d="M2 0a1 1 0 0 0-1 1v8a1 1 0 0 0 1.555.832l6-4a1 1 0 0 0 0-1.664l-6-4A1 1 0 0 0 2 0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h4v-2H3V3h9V1zm7 11a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-.541a4 4 0 1 0-4 0zm2-6a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm-1 8v1h2v-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h4v-2H3V3h9V1zm7 11a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-.541a4 4 0 1 0-4 0zm2-6a2 2 0 0 1 0 4 2 2 0 0 1 0-4zm-1 8v1h2v-1zM4 4h2v2H4zm0 3h2v2H4zm0 3h2v2H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8"><circle cx="4" cy="4" r="4" fill="#ffdd65"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="64" height="64"><path fill="#fff" d="m0 0v8l8-8zm16 0-16 16v8l24-24zm16 0-32 32v8l40-40zm16 0-48 48v8l56-56zm16 0-64 64h8l56-56zm0 16-48 48h8l40-40zm0 16-32 32h8s24-23 24-24zm0 16-16 16h8l8-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m3 1c-1.1046 0-2 .8954-2 2v1h14v-1c0-1.1046-.89543-2-2-2zm9 1h1v1h-1zm-11 3v8c0 1.1046.89543 2 2 2h10c1.1046 0 2-.8954 2-2v-8z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#99c4ff" d="M12 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2zM6 5a5 5 0 0 0 0 10A5 5 0 0 0 6 5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#ffa6bd" d="M12 2a1 1 0 0 0 0 2 1 1 0 0 0 0-2zM6 5a5 5 0 0 0 0 10A5 5 0 0 0 6 5z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g fill="none" stroke="#5fb2ff" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><path d="M1 11h14"/><path stroke-width="1.5" d="M8 10V1.75l2 2m-2-2-2 2"/></g><path fill="#5fb2ff" fill-opacity=".4" d="M0 11h16v5H0z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" fill-opacity=".4" d="M0 10h16v6H0z"/><path fill="#5fb2ff" d="m0 10 8 2.5 8-2.5-8-2.5z"/><path fill="#a2d2ff" d="M8 1 5.5 3.5a2.5 1 0 0 0 1.5.9v5.2a1 .4 0 0 0 1 .4z"/><path fill="#2998ff" d="m8 1 2.5 2.5a2.5 1 0 0 1-1.5.9v5.2a1 .4 0 0 1-1 .4V5.25a2.5 1 0 0 1-1-.1V4.4a2.5 1 0 0 0 1 .1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><linearGradient id="a" y2="0" gradientUnits="userSpaceOnUse"><stop stop-color="#fc7f7f"/><stop offset=".5" stop-color="#fc7f7f"/><stop stop-color="#8da5f3"/></linearGradient><g fill="none" stroke="url(#a)"><circle cx="8" cy="8" r="6" stroke-width="2"/><path stroke-width="1.5" d="M2 8a6.5 2 0 0 0 12 0M8 2c-3 4-3 8 0 12M8 2c3 4 3 8 0 12"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 1v10h5.4a3.75 3.75 0 1 1 7.2 0H15V1z"/><path fill="#ff5f5f" d="M8 12.25a3 3 0 1 1 4 0V15l-2-1-2 1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#fc7f7f" stroke-width="2" d="M8 1v9M5 4h6M3.2 7.2a5 4 0 0 0 9.6 0"/><path fill="#fc7f7f" d="M4 12v1a1 1 0 0 0 1 1 1 1 0 0 0-1 1v1h1v-1h1v1h1v-1a1 1 0 0 0-1-1 1 1 0 0 0 1-1v-1H6v1H5v-1zm5 0v4h1v-1h1v1h1v-1a1 1 0 0 0-.137-.5A1 1 0 0 0 12 14v-1a1 1 0 0 0-1-1zm1 1h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4 12v1c0 .553.448 1 1 1-.552 0-1 .447-1 1v1h1v-1h1v1h1v-1c0-.553-.448-1-1-1 .552 0 1-.447 1-1v-1h-1v1h-1v-1zm5 0v4h1v-1h1v1h1v-1c-.001-.176-.049-.348-.137-.5.088-.152.136-.324.137-.5v-1c0-.553-.447-1-1-1zm1 1h1v1h-1zM12.091 5.286h-3.384v-.715h.722c.396 0 .714-.319.714-.714v-2.143c0-.394-.319-.714-.714-.714h-2.857c-.395 0-.715.32-.715.714v2.143c0 .395.319.714.715.714h.707v.707l-3.279.008c-.395 0-.714.32-.714.714 0 .395.319.714.714.714h2.04l-.005 3.573c0 .395.32.713.715.713.394 0 .714-.318.714-.713v-1.662h1.073v1.662c0 .395.321.713.716.713.393 0 .713-.318.713-.713v-3.573h2.125c.395 0 .715-.32.715-.714s-.321-.714-.715-.714zm-3.384-3.027h.8v1.598h-.8zm-2.228 1.598v-1.598h.8v1.598z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M9.5 0a3 3 0 0 0-3 2.777 3 3 0 1 0-3 5.047V10a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V9l3 2V5l-3 2V5.23A3 3 0 0 0 9.5 0zM4 12v1a1 1 0 0 0 1 1 1 1 0 0 0-1 1v1h1v-1h1v1h1v-1a1 1 0 0 0-1-1 1 1 0 0 0 1-1v-1H6v1H5v-1zm5 0v4h1v-1h1v1h1v-1a1 1 0 0 0-.137-.5A1 1 0 0 0 12 14v-1a1 1 0 0 0-1-1zm1 1h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M2 1a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm2 1h2v2h2v2H6v2H4V6H2V4h2zm9 1a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm-2 2a1 1 0 0 1 0 2 1 1 0 0 1 0-2zM4 12v1a1 1 0 0 0 1 1 1 1 0 0 0-1 1v1h1v-1h1v1h1v-1a1 1 0 0 0-1-1 1 1 0 0 0 1-1v-1H6v1H5v-1zm5 0v4h1v-1h1v1h1v-1a1 1 0 0 0-.137-.5A1 1 0 0 0 12 14v-1a1 1 0 0 0-1-1zm1 1h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4 12v1c0 .552.448 1 1 1-.552 0-1 .448-1 1v1h1v-1h1v1h1v-1c0-.552-.448-1-1-1 .552 0 1-.448 1-1v-1h-1v1h-1v-1zm5 0v4h1v-1h1v1h1v-1c-.001-.176-.048-.348-.137-.5.089-.152.136-.324.137-.5v-1c0-.552-.448-1-1-1zm1 1h1v1h-1zM11.384 9.462v-2.155c1.613-.944 2.156-3.016 1.213-4.631-.603-1.033-1.709-1.67-2.905-1.676h-3.385c-1.869.008-3.377 1.532-3.368 3.401.005 1.197.643 2.301 1.676 2.906v2.155c0 .934.758 1.692 1.692 1.692h3.385c.935 0 1.692-.758 1.692-1.692zm-4.23-4.231h1.692v.846h-1.692zm-2.539-.846c0-.468.378-.846.847-.846.468 0 .846.378.846.846 0 .467-.378.846-.846.846-.469 0-.847-.379-.847-.846zm5.923 5.077h-.846v-.847h-.846v.846h-1.692v-.846h-.847v.846h-.846v-2.538h.846v.846h.847v-.846h1.692v.846h.846v-.846h.846zm-.846-5.077c0-.468.378-.846.846-.846s.846.378.846.846c0 .467-.378.846-.846.846s-.846-.379-.846-.846z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4 12v1c0 .553.448 1 1 1-.552 0-1 .447-1 1v1h1v-1h1v1h1v-1c0-.553-.448-1-1-1 .552 0 1-.447 1-1v-1h-1v1h-1v-1zm5 0v4h1v-1h1v1h1v-1c-.001-.176-.049-.348-.137-.5.088-.152.136-.324.137-.5v-1c0-.553-.447-1-1-1zm1 1h1v1h-1zM12.375 4.948c-.38-.186-.839-.028-1.025.353l-.916 1.88.688-3.795c.076-.414-.201-.813-.617-.89-.417-.075-.814.2-.891.616l-.575 3.166-.091-.641v-3.869c0-.426-.343-.768-.767-.768s-.766.342-.766.768v3.869 1.146l-.666-3.671c-.076-.416-.475-.693-.891-.617-.417.076-.693.475-.617.89l.745 4.111-1.254-.902c-.37-.344-.949-.322-1.293.047-.344.371-.323.949.048 1.293l3.161 3.066h3.065c.551 0 1.202-1.314 1.202-1.314l1.813-3.712c.185-.383.028-.841-.353-1.026z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="6" r="4" fill="none" stroke="#fc7f7f" stroke-width="2"/><path fill="#fc7f7f" d="m4 12v1c0 .552.448 1 1 1-.552 0-1 .448-1 1v1h1v-1h1v1h1v-1c0-.552-.448-1-1-1 .552 0 1-.448 1-1v-1h-1v1h-1v-1zm5 0v4h1v-1h1v1h1v-1c-.001-.176-.048-.348-.137-.5.089-.152.136-.324.137-.5v-1c0-.552-.448-1-1-1zm1 1h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M7 1v3h2V1zM3 5v2h3V5zm5 0a1 1 0 0 0 0 2 1 1 0 0 0 0-2zm2 0v2h3V5zM7 8v3h2V8zm-3 4v1a1 1 0 0 0 1 1 1 1 0 0 0-1 1v1h1v-1h1v1h1v-1a1 1 0 0 0-1-1 1 1 0 0 0 1-1v-1H6v1H5v-1zm5 0v4h1v-1h1v1h1v-1a1 1 0 0 0-.137-.5A1 1 0 0 0 12 14v-1a1 1 0 0 0-1-1zm1 1h1v1h-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#8da5f3" d="m4 1-3 3h2v8h-2l3 3 3-3h-2v-8h2zm5 1v2h6v-2zm0 5v2h4v-2zm0 5v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 1a5 5 0 1 0 2.752 9.166l4.318 4.318 1.414-1.414-4.318-4.318a5 5 0 0 0 .41-.752H10V6H9a3 3 0 1 1-1-2.232V2h.99a5 5 0 0 0-3-1zm5 0v2H9v2h2v2h2V5h2V3h-2V1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="8" fill-opacity=".4"/><path fill="#e0e0e0" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zM4 7h8v2H4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><g stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><circle cx="8" cy="8" r="8" fill-opacity=".4"/><path fill="#e0e0e0" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zM7 4h2v3h3v2H9v3H7V9H4V7h3z"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><circle cx="8" cy="8" r="8" fill-opacity=".4"/><path fill="#e0e0e0" d="M8 1a7 7 0 0 0 0 14A7 7 0 0 0 8 1zm0 3.166A1 1 0 0 1 9.526 5v7h-2V6.87l-1.445.962-1-1.6z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#6f91f0" d="M0 4v8h2a3 3 0 0 0 2.5-1.346 3 3 0 0 0 4.5.578 3 3 0 0 0 4.5-.578A3 3 0 0 0 16 12v-2a1 1 0 0 1-1-1V4h-2v2.77a3 3 0 0 0-4 0 3 3 0 0 0-4.5.578A3 3 0 0 0 2 6V4zm2 4a1 1 0 0 1 0 2zm5 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2zm4 0a1 1 0 0 1 0 2 1 1 0 0 1 0-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#35d4f4" d="M3 4a3 3 0 0 0-3 3v5h2v-2h2V8H2V7a1 1 0 0 1 1-1h1V4zm3 0v5a3 3 0 0 0 3 3h1v-2H9a1 1 0 0 1-1-1V4zm6 0v5a3 3 0 0 0 3 3h1v-2h-1a1 1 0 0 1-1-1V8h2V6h-2V4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#5abbef" d="m1 2v2h2v-2zm11 0v5a3 3 0 0 0 3 3h1v-2h-1a1 1 0 0 1 -1-1v-1h2v-2h-2v-2zm-8 2v6h2v-4h1a1 1 0 0 1 1 1v3h2v-3a3 3 0 0 0 -3-3h-1zm-3 2v4h2v-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="12"><path fill="#5abbef" d="M5 2v2h2V2zm2 2v2H5V4H3v4a1 1 0 0 1-1-1V4H0v3a3 3 0 0 0 0 .05A3 3 0 0 0 3 10h6V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3zm5 3a3 3 0 0 0 3 3h1V8h-1a1 1 0 0 1-1-1V6h2V4h-2V2h-2z"/><path fill="#fff" fill-opacity=".4" d="M5 10V4H3v4a1 1 0 0 1-1-1V4H0v3a3 3 0 0 0 3 3zm2 0h2V6a1 1 0 0 1 1 1v3h2V7a3 3 0 0 0-3-3H7z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fefefe" d="M0 0h16v10a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2 2 2 0 0 0-2 2v2a2 2 0 0 0 2 2H0z"/></mask><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><path fill="none" stroke="#fc7f7f" stroke-width="2" d="m8 2 6 3v6l-6 3-6-3V5zm0 12V8l6-3M8 8 2 5" mask="url(#a)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fefefe" d="M0 0h16v10a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2 2 2 0 0 0-2 2v2a2 2 0 0 0 2 2H0z"/></mask><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><path fill="none" stroke="#fc7f7f" stroke-width="2" d="M4 6a4 4 0 0 1 8 0v4a4 4 0 0 1-8 0zm0 1.25a2.5 1 0 0 0 8 0m-4-5v12" mask="url(#a)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><path fill="#fc7f7f" d="M3 1a2 2 0 0 0-2 2h2zm2 0v2h2V1zm4 0v2h2V1zm4 0v2h2a2 2 0 0 0-2-2zM1 5v2h2V5zm12 0v2h2V5zM1 9v2h2V9zm0 4a2 2 0 0 0 2 2v-2zm4 0v2h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fefefe" d="M0 0h16v10a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2 2 2 0 0 0-2 2v2a2 2 0 0 0 2 2H0z"/></mask><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><path fill="none" stroke="#fc7f7f" stroke-width="2" d="M2 4v8a6 2 0 0 0 12 0V4A6 2 0 0 0 2 4a6 2 0 0 0 12 0" mask="url(#a)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="M4.73 2A2 2 0 1 0 2 4.73v6.541A2 2 0 1 0 4.729 14H8v-2H4.729A2 2 0 0 0 4 11.271V5.415l4.914 4.916A2 2 0 0 1 9.998 10a2 2 0 0 1 .33-1.084L5.414 4h5.856a2 2 0 0 0 .73.729V8h2V4.729A2 2 0 1 0 11.27 2z"/><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fefefe" d="M0 0h16v10a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2 2 2 0 0 0-2 2v2a2 2 0 0 0 2 2H0z"/></mask><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><path fill="none" stroke="#fc7f7f" stroke-linejoin="round" stroke-width="2" d="m8 2 6 3.5v5L8 14l-6-3.5v-5h6zm6 3.5L8 9 2 5.5M8 9v5" mask="url(#a)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fefefe" d="M0 0h16v10a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2 2 2 0 0 0-2 2v2a2 2 0 0 0 2 2H0z"/></mask><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><path fill="none" stroke="#fc7f7f" stroke-width="2" d="M8 2a6 6 0 0 0 0 12A6 6 0 0 0 8 2v12M2.05 7.4a6 2 0 0 0 11.9 0" mask="url(#a)"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><mask id="a"><path fill="#fefefe" d="M0 0h16v10a2 2 0 0 0-2-2h-2a2 2 0 0 0-2 2 2 2 0 0 0-2 2v2a2 2 0 0 0 2 2H0z"/></mask><path fill="#5fb2ff" d="M12 9a1 1 0 0 0-1 1v1h2v2h1a1 1 0 0 0 1-1v-2a1 1 0 0 0-1-1zm1 4h-2v-2h-1a1 1 0 0 0-1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1z"/><g fill="none" stroke="#fc7f7f" mask="url(#a)"><path stroke-width="2" d="M2.5 10a6 4 0 0 0 11 0 4 4 0 0 0 0-4 6 4 0 0 0-11 0 4 4 0 0 0 0 4z"/><path stroke-linecap="round" stroke-width="1.75" d="M6.2 7.2a2 1 0 1 0 3.6 0"/></g></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m7 1-.565 2.258a5 5 0 0 0-.689.28L3.758 2.343 2.344 3.758l1.195 1.994a5 5 0 0 0-.285.685L1 7v2l2.258.564a5 5 0 0 0 .279.688l-1.193 1.99 1.414 1.414 1.994-1.195a5 5 0 0 0 .685.285L7 15h2l.564-2.258a5 5 0 0 0 .688-.28l1.99 1.194 1.414-1.414-1.195-1.994a5 5 0 0 0 .285-.685L15 9V7l-2.258-.564a5 5 0 0 0-.28-.688l1.194-1.99-1.414-1.414-1.994 1.195a5 5 0 0 0-.686-.285L9 1H7zm1 5a2 2 0 0 1 0 4 2 2 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="none" stroke="#e0e0e0" d="m7 1-.565 2.258a5 5 0 0 0-.689.28L3.758 2.343 2.344 3.758l1.195 1.994a5 5 0 0 0-.285.685L1 7v2l2.258.564a5 5 0 0 0 .279.688l-1.193 1.99 1.414 1.414 1.994-1.195a5 5 0 0 0 .685.285L7 15h2l.564-2.258a5 5 0 0 0 .688-.28l1.99 1.194 1.414-1.414-1.195-1.994a5 5 0 0 0 .285-.685L15 9V7l-2.258-.564a5 5 0 0 0-.28-.688l1.194-1.99-1.414-1.414-1.994 1.195a5 5 0 0 0-.686-.285L9 1H7zm1 5a2 2 0 0 1 0 4 2 2 0 0 1 0-4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#fc7f7f" d="m8 1-6 3v8l6 3 6-3v-2l-2-1-4 2-2-1v-4l2-1v-2l2-1zm4 2-2 1v2l2 1 2-1v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="m2.256 4.85 1.7 2.945 2.598-1.5 4.5 7.794a1 1-30 0 0 2.598-1.5l-4.65-8.054 3.464-2-.25-.433s-1.25-2.165-3.848-.665l-3.464 2-.31.063z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M6 10a3 3 0 1 0 0 6h1v-2H6a1 1 0 0 1 0-2h1v-2zm1-9-.564 2.258a4.91 4.91 0 0 0-.69.28L3.758 2.343 2.344 3.758l1.195 1.994-.285.685L1 7v2h5.27a2 2 0 1 1 3.46 0H15V7l-2.258-.565a5.007 5.007 0 0 0-.28-.687l1.194-1.99-1.414-1.414-1.994 1.195a4.998 4.998 0 0 0-.686-.285L9 1zm4 9a2 2 0 1 0 0 4H9v2h2a2 2 0 1 0 0-4h2v-2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 1a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1zm1 2h10v8H3zm3 1v2h2V4zm2 2v2h2v2h2V4h-2v2zm0 2H6V6H4v4h4z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M1 14a1 1 0 0 0 1 1h9.5a1 1 0 0 0 .707-.293l2.5-2.5A1 1 0 0 0 15 11.5V2a1 1 0 0 0-1-1H4.5a1 1 0 0 0-.707.293l-2.5 2.5A1 1 0 0 0 1 4.5zm1.25-9H11v7H2.25zm10 6.25v-6.5L14 3v6.5zm-1-7.5H3L4.75 2H13zM3 11h4l1.25-1.25V9H9l1.25-1.25v-2h-2L7 7v.75h-.75v-2h-2L3 7z"/><path fill-opacity=".4" d="M3 7h2l1.25-1.25h-2zm2 2h2V7.75h-.75zm2-2h2l1.25-1.25H8z"/><path fill-opacity=".2" d="M5 7v2l1.25-1.25v-2zm2 2v2l1.25-1.25V9zm2 0V7l1.25-1.25v2z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M2 14h3v-3H2zM6.561 2.855a21 21 0 0 1 2.82 1.185A21 21 0 0 1 9.137 1h1.77a21 21 0 0 1-.28 3.027 21 21 0 0 1 2.88-1.171l.562 1.733a21 21 0 0 1-3.04.684 21 21 0 0 1 2.1 2.307l-1.465 1.037a21 21 0 0 1-1.672-2.624 21 21 0 0 1-1.587 2.624L6.965 7.58a21 21 0 0 1 2.026-2.308A21 21 0 0 1 6 4.59z"/></svg>
)<!>",
	R"<!>(<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"><path fill="#e0e0e0" d="M5 13h2v-2H5zm2.5-8a14 14 0 0 1 1.88.79 14 14 0 0 1-.163-2.027h1.18a14 14 0 0 1-.186 2.018 14 14 0 0 1 1.92-.78l.374 1.155a14 14 0 0 1-2.026.456 14 14 0 0 1 1.4 1.538l-.977.691a14 14 0 0 1-1.115-1.75 14 14 0 0 1-1.058 1.75l-.96-.691A14 14 0 0 1 9.12 6.61a14 14 0 0 1-1.993-.454zM1.67 2C0 5 0 11 1.67 14h2C2 11 2 5 3.67 2zm10.66 0c1.67 3 1.67 9 0 12h2c1.67-3 1.67-9 0-12z"/></svg>
)<!>"
};

inline constexpr const char *editor_icons_names[] = {
	"2D",
	"2DNodes",
	"3D",
	"AABB",
	"AcceptDialog",
	"ActionCopy",
	"ActionCut",
	"ActionPaste",
	"Add",
	"AimModifier3D",
	"Anchor",
	"AnimatableBody2D",
	"AnimatableBody3D",
	"AnimatedSprite2D",
	"AnimatedSprite3D",
	"AnimatedTexture",
	"Animation",
	"AnimationAutoFit",
	"AnimationAutoFitBezier",
	"AnimationFilter",
	"AnimationLibrary",
	"AnimationMixer",
	"AnimationPlayer",
	"AnimationTrackGroup",
	"AnimationTrackList",
	"AnimationTree",
	"Area2D",
	"Area3D",
	"Array",
	"ArrayMesh",
	"ArrayOccluder3D",
	"ArrowDown",
	"ArrowLeft",
	"ArrowRight",
	"ArrowUp",
	"AspectRatioContainer",
	"AssetLib",
	"AtlasTexture",
	"AudioBusBypass",
	"AudioBusLayout",
	"AudioBusMute",
	"AudioBusSolo",
	"AudioListener2D",
	"AudioListener3D",
	"AudioMute",
	"AudioStream",
	"AudioStreamGenerator",
	"AudioStreamMP3",
	"AudioStreamMicrophone",
	"AudioStreamOggVorbis",
	"AudioStreamPlayer",
	"AudioStreamPlayer2D",
	"AudioStreamPlayer3D",
	"AudioStreamPolyphonic",
	"AudioStreamRandomizer",
	"AudioStreamWAV",
	"AutoEnd",
	"AutoKey",
	"AutoPlay",
	"AutoTriangle",
	"Back",
	"BackBufferCopy",
	"Bake",
	"BaseButton",
	"Basis",
	"BezierHandlesBalanced",
	"BezierHandlesFree",
	"BezierHandlesLinear",
	"BezierHandlesMirror",
	"BitMap",
	"Blend",
	"Bone",
	"Bone2D",
	"BoneAttachment3D",
	"BoneConstraint3D",
	"BoneMapHumanBody",
	"BoneMapHumanFace",
	"BoneMapHumanLeftHand",
	"BoneMapHumanRightHand",
	"BoneMapperHandle",
	"BoneMapperHandleCircle",
	"BoneMapperHandleSelected",
	"BoxContainer",
	"BoxMesh",
	"BoxOccluder3D",
	"BoxShape3D",
	"Breakpoint",
	"Bucket",
	"BusVuActive",
	"BusVuFrozen",
	"Button",
	"ButtonGroup",
	"CPUParticles2D",
	"CPUParticles3D",
	"Callable",
	"Camera",
	"Camera2D",
	"Camera3D",
	"CameraAttributes",
	"CameraAttributesPhysical",
	"CameraAttributesPractical",
	"CameraTexture",
	"CanvasGroup",
	"CanvasItem",
	"CanvasItemMaterial",
	"CanvasLayer",
	"CanvasModulate",
	"CanvasTexture",
	"CapsuleMesh",
	"CapsuleShape2D",
	"CapsuleShape3D",
	"CenterContainer",
	"CenterView",
	"CharacterBody2D",
	"CharacterBody3D",
	"CheckBox",
	"CheckButton",
	"Checkerboard",
	"CircleShape2D",
	"ClassList",
	"Clear",
	"Close",
	"CodeEdit",
	"CodeFoldDownArrow",
	"CodeFoldedRightArrow",
	"CodeHighlighter",
	"CodeRegionFoldDownArrow",
	"CodeRegionFoldedRightArrow",
	"Collapse",
	"CollapseTree",
	"CollisionObject2D",
	"CollisionObject3D",
	"CollisionPolygon2D",
	"CollisionPolygon3D",
	"CollisionShape2D",
	"CollisionShape3D",
	"Color",
	"ColorPick",
	"ColorPicker",
	"ColorPickerBarArrow",
	"ColorPickerButton",
	"ColorRect",
	"ColorTrackVu",
	"CombineLines",
	"CompressedTexture2D",
	"CompressedTexture3D",
	"ConcavePolygonShape2D",
	"ConcavePolygonShape3D",
	"ConeTwistJoint3D",
	"ConfirmationDialog",
	"Container",
	"ContainerLayout",
	"Control",
	"ControlAlignBottomLeft",
	"ControlAlignBottomRight",
	"ControlAlignBottomWide",
	"ControlAlignCenter",
	"ControlAlignCenterBottom",
	"ControlAlignCenterLeft",
	"ControlAlignCenterRight",
	"ControlAlignCenterTop",
	"ControlAlignFullRect",
	"ControlAlignHCenterWide",
	"ControlAlignLeftWide",
	"ControlAlignRightWide",
	"ControlAlignTopLeft",
	"ControlAlignTopRight",
	"ControlAlignTopWide",
	"ControlAlignVCenterWide",
	"ControlLayout",
	"ConvertTransformModifier3D",
	"ConvexPolygonShape2D",
	"ConvexPolygonShape3D",
	"CopyNodePath",
	"CopyTransformModifier3D",
	"CreateNewSceneFrom",
	"CryptoKey",
	"Cubemap",
	"CubemapArray",
	"Curve",
	"Curve2D",
	"Curve3D",
	"CurveCenter",
	"CurveClose",
	"CurveConstant",
	"CurveCreate",
	"CurveCurve",
	"CurveDelete",
	"CurveEdit",
	"CurveIn",
	"CurveInOut",
	"CurveLinear",
	"CurveOut",
	"CurveOutIn",
	"CurveTexture",
	"CurveTilt",
	"CurveXYZTexture",
	"CylinderMesh",
	"CylinderShape3D",
	"DampedSpringJoint2D",
	"Debug",
	"DebugContinue",
	"DebugNext",
	"DebugSkipBreakpointsOff",
	"DebugSkipBreakpointsOn",
	"DebugStep",
	"Decal",
	"DefaultProjectIcon",
	"Dictionary",
	"DirAccess",
	"DirectionalLight2D",
	"DirectionalLight3D",
	"DistractionFree",
	"DragHandle",
	"Duplicate",
	"Edit",
	"EditAddRemove",
	"EditBezier",
	"EditInternal",
	"EditKey",
	"EditPivot",
	"Editor3DHandle",
	"EditorBoneHandle",
	"EditorControlAnchor",
	"EditorCurveHandle",
	"EditorFileDialog",
	"EditorHandle",
	"EditorHandleAdd",
	"EditorHandleDisabled",
	"EditorPathNullHandle",
	"EditorPathSharpHandle",
	"EditorPathSmoothHandle",
	"EditorPivot",
	"EditorPlugin",
	"EditorPosition",
	"EditorPositionPrevious",
	"EditorPositionUnselected",
	"Enum",
	"Environment",
	"Eraser",
	"Error",
	"ErrorWarning",
	"ExpandBottomDock",
	"ExpandTree",
	"ExternalLink",
	"FPS",
	"FadeCross",
	"FadeDisabled",
	"FadeIn",
	"FadeOut",
	"Favorites",
	"File",
	"FileAccess",
	"FileBigThumb",
	"FileBroken",
	"FileBrokenBigThumb",
	"FileBrowse",
	"FileDead",
	"FileDeadBigThumb",
	"FileDeadMediumThumb",
	"FileDialog",
	"FileList",
	"FileMediumThumb",
	"FileThumbnail",
	"FileTree",
	"FilenameFilter",
	"Filesystem",
	"FixedSize",
	"FlipWinding",
	"FlowContainer",
	"FogMaterial",
	"FogVolume",
	"FoldableContainer",
	"Folder",
	"FolderBigThumb",
	"FolderBrowse",
	"FolderCreate",
	"FolderMediumThumb",
	"Font",
	"FontFile",
	"FontItem",
	"FontSize",
	"FontVariation",
	"Forward",
	"GPUParticles2D",
	"GPUParticles3D",
	"GPUParticlesAttractorBox3D",
	"GPUParticlesAttractorSphere3D",
	"GPUParticlesAttractorVectorField3D",
	"GPUParticlesCollisionBox3D",
	"GPUParticlesCollisionHeightField3D",
	"GPUParticlesCollisionSDF3D",
	"GPUParticlesCollisionSphere3D",
	"Game",
	"Generic6DOFJoint3D",
	"Geometry2D",
	"Geometry3D",
	"GeometryInstance3D",
	"Gizmo3DSamplePlayer",
	"GizmoAudioListener3D",
	"GizmoCPUParticles3D",
	"GizmoCamera3D",
	"GizmoDecal",
	"GizmoDirectionalLight",
	"GizmoFogVolume",
	"GizmoGPUParticles3D",
	"GizmoLight",
	"GizmoLightmapGI",
	"GizmoLightmapProbe",
	"GizmoReflectionProbe",
	"GizmoSpotLight",
	"GizmoVoxelGI",
	"Godot",
	"GodotFile",
	"GodotMonochrome",
	"Gradient",
	"GradientTexture1D",
	"GradientTexture2D",
	"GraphEdit",
	"GraphElement",
	"GraphFrame",
	"GraphNode",
	"Grid",
	"GridContainer",
	"GridLayout",
	"GridMinimap",
	"GridToggle",
	"GrooveJoint2D",
	"Group",
	"GroupViewport",
	"Groups",
	"GuiArrowUp",
	"GuiChecked",
	"GuiCheckedDisabled",
	"GuiClose",
	"GuiDropdown",
	"GuiEllipsis",
	"GuiGraphNodePort",
	"GuiHsplitter",
	"GuiIndeterminate",
	"GuiIndeterminateDisabled",
	"GuiMiniCheckerboard",
	"GuiOptionArrow",
	"GuiProgressBar",
	"GuiProgressFill",
	"GuiRadioChecked",
	"GuiRadioCheckedDisabled",
	"GuiRadioUnchecked",
	"GuiRadioUncheckedDisabled",
	"GuiResizer",
	"GuiResizerTopLeft",
	"GuiScrollArrowLeft",
	"GuiScrollArrowLeftHl",
	"GuiScrollArrowRight",
	"GuiScrollArrowRightHl",
	"GuiScrollBg",
	"GuiScrollGrabber",
	"GuiScrollGrabberHl",
	"GuiScrollGrabberPressed",
	"GuiSliderGrabber",
	"GuiSliderGrabberHl",
	"GuiSpace",
	"GuiSpinboxDown",
	"GuiSpinboxUp",
	"GuiSpinboxUpdown",
	"GuiSpinboxUpdownDisabled",
	"GuiTab",
	"GuiTabDropMark",
	"GuiTabMenu",
	"GuiTabMenuHl",
	"GuiToggleOff",
	"GuiToggleOffDisabled",
	"GuiToggleOffDisabledMirrored",
	"GuiToggleOffMirrored",
	"GuiToggleOn",
	"GuiToggleOnDisabled",
	"GuiToggleOnDisabledMirrored",
	"GuiToggleOnMirrored",
	"GuiTreeArrowDown",
	"GuiTreeArrowLeft",
	"GuiTreeArrowRight",
	"GuiTreeUpdown",
	"GuiUnchecked",
	"GuiUncheckedDisabled",
	"GuiViewportHdiagsplitter",
	"GuiViewportVdiagsplitter",
	"GuiViewportVhsplitter",
	"GuiVisibilityHidden",
	"GuiVisibilityVisible",
	"GuiVisibilityXray",
	"GuiVsplitter",
	"HBoxContainer",
	"HFlowContainer",
	"HScrollBar",
	"HSeparator",
	"HSlider",
	"HSplitContainer",
	"HTTPRequest",
	"Heart",
	"HeightMapShape3D",
	"Help",
	"HelpSearch",
	"HingeJoint3D",
	"History",
	"Hsize",
	"IOSDeviceWired",
	"IOSDeviceWireless",
	"IOSSimulator",
	"Image",
	"ImageTexture",
	"ImageTexture3D",
	"ImmediateMesh",
	"ImportCheck",
	"ImportFail",
	"ImporterMeshInstance3D",
	"Info",
	"InputEventAction",
	"InputEventJoypadButton",
	"InputEventJoypadMotion",
	"InputEventKey",
	"InputEventMIDI",
	"InputEventMagnifyGesture",
	"InputEventMouseButton",
	"InputEventMouseMotion",
	"InputEventPanGesture",
	"InputEventScreenDrag",
	"InputEventScreenTouch",
	"InputEventShortcut",
	"InsertAfter",
	"InsertBefore",
	"Instance",
	"InstanceOptions",
	"InterpCubic",
	"InterpCubicAngle",
	"InterpLinear",
	"InterpLinearAngle",
	"InterpRaw",
	"InterpWrapClamp",
	"InterpWrapLoop",
	"ItemList",
	"JoyAxis",
	"JoyButton",
	"Joypad",
	"KeepAspect",
	"Key",
	"KeyAnimation",
	"KeyAudio",
	"KeyBezier",
	"KeyBezierHandle",
	"KeyBezierPoint",
	"KeyBezierSelected",
	"KeyBlendShape",
	"KeyCall",
	"KeyEasedSelected",
	"KeyInvalid",
	"KeyNext",
	"KeyPosition",
	"KeyRotation",
	"KeyScale",
	"KeySelected",
	"KeyTrackBlendShape",
	"KeyTrackPosition",
	"KeyTrackRotation",
	"KeyTrackScale",
	"KeyValue",
	"KeyValueEased",
	"KeyXPosition",
	"KeyXRotation",
	"KeyXScale",
	"Keyboard",
	"KeyboardError",
	"KeyboardLabel",
	"KeyboardPhysical",
	"KinematicCollision2D",
	"KinematicCollision3D",
	"Label",
	"Label3D",
	"LabelSettings",
	"LightOccluder2D",
	"LightmapGI",
	"LightmapGIData",
	"LightmapProbe",
	"Line",
	"Line2D",
	"LineEdit",
	"LinkButton",
	"LinkOverlay",
	"ListSelect",
	"Load",
	"LocalVariable",
	"Lock",
	"LockViewport",
	"Logo",
	"LookAtModifier3D",
	"Loop",
	"MainMovieWrite",
	"MainPlay",
	"MakeFloating",
	"MarginContainer",
	"Marker",
	"Marker2D",
	"Marker3D",
	"MarkerSelected",
	"MatchCase",
	"MaterialPreviewCube",
	"MaterialPreviewLight1",
	"MaterialPreviewLight2",
	"MaterialPreviewQuad",
	"MaterialPreviewSphere",
	"MemberAnnotation",
	"MemberConstant",
	"MemberConstructor",
	"MemberMethod",
	"MemberOperator",
	"MemberProperty",
	"MemberSignal",
	"MemberTheme",
	"MenuBar",
	"MenuButton",
	"Mesh",
	"MeshInstance2D",
	"MeshInstance3D",
	"MeshItem",
	"MeshLibrary",
	"MeshTexture",
	"MethodOverride",
	"MethodOverrideAndSlot",
	"MiniObject",
	"MirrorX",
	"MirrorY",
	"MissingNode",
	"MissingResource",
	"ModifierBoneTarget3D",
	"Modifiers",
	"Mouse",
	"MoveDown",
	"MoveLeft",
	"MovePoint",
	"MoveRight",
	"MoveUp",
	"MultiMesh",
	"MultiMeshInstance2D",
	"MultiMeshInstance3D",
	"MultiplayerSpawner",
	"MultiplayerSynchronizer",
	"NavigationAgent2D",
	"NavigationAgent3D",
	"NavigationLink2D",
	"NavigationLink3D",
	"NavigationMesh",
	"NavigationObstacle2D",
	"NavigationObstacle3D",
	"NavigationPolygon",
	"NavigationRegion2D",
	"NavigationRegion3D",
	"New",
	"NewKey",
	"NewRoot",
	"NextFrame",
	"Nil",
	"NinePatchRect",
	"Node",
	"Node2D",
	"Node3D",
	"NodeDisabled",
	"NodeInfo",
	"NodePath",
	"NodeWarning",
	"NodeWarnings2",
	"NodeWarnings3",
	"NodeWarnings4Plus",
	"NonFavorite",
	"Notification",
	"NotificationDisabled",
	"ORMMaterial3D",
	"Object",
	"ObjectDisabled",
	"Occluder3D",
	"OccluderInstance3D",
	"OccluderPolygon2D",
	"OmniLight3D",
	"OneWayTile",
	"Onion",
	"OptionButton",
	"Orientation",
	"OverbrightIndicator",
	"Override",
	"PackedByteArray",
	"PackedColorArray",
	"PackedDataContainer",
	"PackedFloat32Array",
	"PackedFloat64Array",
	"PackedInt32Array",
	"PackedInt64Array",
	"PackedScene",
	"PackedStringArray",
	"PackedVector2Array",
	"PackedVector3Array",
	"PackedVector4Array",
	"PageFirst",
	"PageLast",
	"PageNext",
	"PagePrevious",
	"Paint",
	"Panel",
	"PanelContainer",
	"Panels1",
	"Panels2",
	"Panels2Alt",
	"Panels3",
	"Panels3Alt",
	"Panels4",
	"PanoramaSkyMaterial",
	"Parallax2D",
	"ParallaxBackground",
	"ParallaxLayer",
	"ParticleProcessMaterial",
	"Path2D",
	"Path3D",
	"PathFollow2D",
	"PathFollow3D",
	"Pause",
	"Performance",
	"PhysicalBone2D",
	"PhysicalBone3D",
	"PhysicalBoneSimulator3D",
	"PhysicalSkyMaterial",
	"PhysicsBody2D",
	"PhysicsBody3D",
	"PhysicsMaterial",
	"PickerCursor",
	"PickerCursorBg",
	"PickerShapeCircle",
	"PickerShapeRectangle",
	"PickerShapeRectangleWheel",
	"Pin",
	"PinJoint2D",
	"PinJoint3D",
	"PinPressed",
	"PingPongLoop",
	"PlaceholderMaterial",
	"PlaceholderMesh",
	"PlaceholderTexture2D",
	"PlaceholderTexture3D",
	"Plane",
	"PlaneMesh",
	"Play",
	"PlayBackwards",
	"PlayCustom",
	"PlayOverlay",
	"PlayRemote",
	"PlayScene",
	"PlayStart",
	"PlayStartBackwards",
	"PlayTravel",
	"PluginScript",
	"PointLight2D",
	"PointMesh",
	"Polygon2D",
	"PolygonOccluder3D",
	"PolygonPathFinder",
	"Popup",
	"PopupMenu",
	"PopupPanel",
	"PortableCompressedTexture2D",
	"PreviewEnvironment",
	"PreviewRotate",
	"PreviewSun",
	"PrismMesh",
	"ProceduralSkyMaterial",
	"ProfilerAutostartWarning",
	"Progress1",
	"Progress2",
	"Progress3",
	"Progress4",
	"Progress5",
	"Progress6",
	"Progress7",
	"Progress8",
	"ProgressBar",
	"ProjectIconLoading",
	"ProjectList",
	"Projection",
	"Quad",
	"QuadMesh",
	"QuadOccluder3D",
	"Quaternion",
	"RID",
	"RandomNumberGenerator",
	"Range",
	"RangeSliderLeft",
	"RangeSliderRight",
	"RayCast2D",
	"RayCast3D",
	"Rect2",
	"Rect2i",
	"Rectangle",
	"RectangleShape2D",
	"Redo",
	"ReferenceRect",
	"ReflectionProbe",
	"RegionEdit",
	"Reload",
	"ReloadSmall",
	"RemoteTransform2D",
	"RemoteTransform3D",
	"Remove",
	"RemoveInternal",
	"Rename",
	"Reparent",
	"ReparentToNewNode",
	"ResourcePreloader",
	"RetargetModifier3D",
	"ReverseGradient",
	"RibbonTrailMesh",
	"RichTextEffect",
	"RichTextLabel",
	"RigidBody2D",
	"RigidBody3D",
	"RootMotionView",
	"RotateLeft",
	"RotateRight",
	"Ruler",
	"SVGTexture",
	"SampleLibrary",
	"Save",
	"SceneUniqueName",
	"Script",
	"ScriptCreate",
	"ScriptCreateDialog",
	"ScriptExtend",
	"ScriptRemove",
	"ScrollContainer",
	"Search",
	"SegmentShape2D",
	"SeparationRayShape2D",
	"SeparationRayShape3D",
	"Shader",
	"ShaderGlobalsOverride",
	"ShaderInclude",
	"ShaderMaterial",
	"Shape2D",
	"Shape3D",
	"ShapeCast2D",
	"ShapeCast3D",
	"Shortcut",
	"ShowInFileSystem",
	"Signal",
	"Signals",
	"SignalsAndGroups",
	"Skeleton2D",
	"Skeleton3D",
	"SkeletonIK3D",
	"SkeletonModifier3D",
	"SkeletonPreview",
	"Sky",
	"SliderJoint3D",
	"Slot",
	"Snap",
	"SnapDisable",
	"SnapGrid",
	"SnapKeys",
	"SnapTimeline",
	"SoftBody3D",
	"Sort",
	"SphereMesh",
	"SphereOccluder3D",
	"SphereShape3D",
	"SpinBox",
	"SplitContainer",
	"SpotLight3D",
	"SpringArm3D",
	"SpringBoneCollision3D",
	"SpringBoneCollisionCapsule3D",
	"SpringBoneCollisionPlane3D",
	"SpringBoneCollisionSphere3D",
	"SpringBoneSimulator3D",
	"Sprite2D",
	"Sprite3D",
	"SpriteFrames",
	"SpriteSheet",
	"StandardMaterial3D",
	"StaticBody2D",
	"StaticBody3D",
	"StatusError",
	"StatusIndicator",
	"StatusSuccess",
	"StatusWarning",
	"Stop",
	"Stretch",
	"String",
	"StringName",
	"StyleBoxEmpty",
	"StyleBoxFlat",
	"StyleBoxGrid",
	"StyleBoxLine",
	"StyleBoxTexture",
	"SubViewport",
	"SubViewportContainer",
	"SyntaxHighlighter",
	"SystemFont",
	"TabBar",
	"TabContainer",
	"Terminal",
	"TerrainConnect",
	"TerrainMatchCorners",
	"TerrainMatchCornersAndSides",
	"TerrainMatchSides",
	"TerrainPath",
	"TextEdit",
	"TextEditorPlay",
	"TextFile",
	"TextMesh",
	"Texture2D",
	"Texture2DArray",
	"Texture3D",
	"TextureButton",
	"TexturePreviewChannels",
	"TextureProgressBar",
	"TextureRect",
	"Theme",
	"ThemeDeselectAll",
	"ThemeRemoveAllItems",
	"ThemeRemoveCustomItems",
	"ThemeSelectAll",
	"ThemeSelectFull",
	"ThumbnailWait",
	"TileChecked",
	"TileMap",
	"TileMapHighlightSelected",
	"TileMapLayer",
	"TileSelection",
	"TileSet",
	"TileUnchecked",
	"Time",
	"TimelineIndicator",
	"Timer",
	"TitleBarLogo",
	"ToolAddNode",
	"ToolBoneSelect",
	"ToolConnect",
	"ToolMove",
	"ToolPan",
	"ToolRotate",
	"ToolScale",
	"ToolSelect",
	"ToolTriangle",
	"Tools",
	"TorusMesh",
	"TouchScreenButton",
	"TrackCapture",
	"TrackColor",
	"TrackContinuous",
	"TrackDiscrete",
	"Transform2D",
	"Transform3D",
	"TransitionEnd",
	"TransitionEndAuto",
	"TransitionEndAutoBig",
	"TransitionEndBig",
	"TransitionImmediate",
	"TransitionImmediateAuto",
	"TransitionImmediateAutoBig",
	"TransitionImmediateBig",
	"TransitionSync",
	"TransitionSyncAuto",
	"TransitionSyncAutoBig",
	"TransitionSyncBig",
	"Translation",
	"Tree",
	"TripleBar",
	"TubeTrailMesh",
	"Tween",
	"UID",
	"UndoRedo",
	"Unfavorite",
	"Ungroup",
	"Unlinked",
	"Unlock",
	"UseBlendDisable",
	"UseBlendEnable",
	"Uv",
	"VBoxContainer",
	"VFlowContainer",
	"VScrollBar",
	"VSeparator",
	"VSlider",
	"VSplitContainer",
	"Variant",
	"VcsBranches",
	"Vector2",
	"Vector2i",
	"Vector3",
	"Vector3i",
	"Vector4",
	"Vector4i",
	"VehicleBody3D",
	"VehicleWheel3D",
	"VideoStream",
	"VideoStreamPlayer",
	"VideoStreamTheora",
	"Viewport",
	"ViewportSpeed",
	"ViewportTexture",
	"ViewportZoom",
	"VisibleOnScreenEnabler2D",
	"VisibleOnScreenEnabler3D",
	"VisibleOnScreenNotifier2D",
	"VisibleOnScreenNotifier3D",
	"VisualInstance3D",
	"VisualShader",
	"VisualShaderGraphTextureUniform",
	"VisualShaderNodeBooleanUniform",
	"VisualShaderNodeColorConstant",
	"VisualShaderNodeColorOp",
	"VisualShaderNodeColorUniform",
	"VisualShaderNodeComment",
	"VisualShaderNodeCubemap",
	"VisualShaderNodeCubemapUniform",
	"VisualShaderNodeCurveTexture",
	"VisualShaderNodeCurveXYZTexture",
	"VisualShaderNodeExpression",
	"VisualShaderNodeFloatFunc",
	"VisualShaderNodeFloatOp",
	"VisualShaderNodeFloatUniform",
	"VisualShaderNodeGlobalExpression",
	"VisualShaderNodeInput",
	"VisualShaderNodeIntFunc",
	"VisualShaderNodeIntOp",
	"VisualShaderNodeIntUniform",
	"VisualShaderNodeTexture2DArrayUniform",
	"VisualShaderNodeTexture3DUniform",
	"VisualShaderNodeTextureUniform",
	"VisualShaderNodeTextureUniformTriplanar",
	"VisualShaderNodeTransformCompose",
	"VisualShaderNodeTransformDecompose",
	"VisualShaderNodeTransformUniform",
	"VisualShaderNodeTransformVecMult",
	"VisualShaderNodeVec3Uniform",
	"VisualShaderNodeVectorCompose",
	"VisualShaderNodeVectorDecompose",
	"VisualShaderNodeVectorDistance",
	"VisualShaderNodeVectorFunc",
	"VisualShaderNodeVectorLen",
	"VisualShaderPort",
	"VoxelGI",
	"VoxelGIData",
	"Warning",
	"WarningPattern",
	"Window",
	"World2D",
	"World3D",
	"WorldBoundaryShape2D",
	"WorldBoundaryShape3D",
	"WorldEnvironment",
	"X509Certificate",
	"XRAnchor3D",
	"XRBodyModifier3D",
	"XRCamera3D",
	"XRController3D",
	"XRFaceModifier3D",
	"XRHandModifier3D",
	"XRNode3D",
	"XROrigin3D",
	"YSort",
	"Zoom",
	"ZoomLess",
	"ZoomMore",
	"ZoomReset",
	"bool",
	"float",
	"int",
	"uint",
	"CSGBox3D",
	"CSGCapsule3D",
	"CSGCombiner3D",
	"CSGCylinder3D",
	"CSGMesh3D",
	"CSGPolygon3D",
	"CSGSphere3D",
	"CSGTorus3D",
	"GDScript",
	"GDScriptInternal",
	"GridMap",
	"BuildCSharp",
	"CSharpScript",
	"NoiseTexture2D",
	"NoiseTexture3D",
	"RegEx",
	"RegExMatch"
};

inline constexpr int editor_md_thumbs_count = 3;
inline constexpr int editor_md_thumbs_indices[] = { 259, 262, 277 };

inline constexpr int editor_bg_thumbs_count = 5;
inline constexpr int editor_bg_thumbs_indices[] = { 253, 255, 258, 274, 313 };
