/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, pdu, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_pdu_tagged_stream_to_pdu = R"doc(Turns received stream data and tags into PDUs and sends them through a message port.

The sent message is a PMT-pair (created by pmt::cons()). The first element is a dictionary containing all the tags. The second is a vector containing the actual data.

Constructor Specific Documentation:

Construct a tagged_stream_to_pdu block.

Args:
    type : PDU type of gr::types::vector_type
    lengthtagname : The name of the tag that specifies how long the packet is.)doc";


static const char* __doc_gr_pdu_tagged_stream_to_pdu_tagged_stream_to_pdu = R"doc()doc";


static const char* __doc_gr_pdu_tagged_stream_to_pdu_make = R"doc(Turns received stream data and tags into PDUs and sends them through a message port.

The sent message is a PMT-pair (created by pmt::cons()). The first element is a dictionary containing all the tags. The second is a vector containing the actual data.

Constructor Specific Documentation:

Construct a tagged_stream_to_pdu block.

Args:
    type : PDU type of gr::types::vector_type
    lengthtagname : The name of the tag that specifies how long the packet is.)doc";
