/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_ofdm_cyclic_prefixer = R"doc(Adds a cyclic prefix and performs optional pulse shaping on OFDM symbols.

Input: OFDM symbols (in the time domain, i.e. after the IFFT). Optionally, entire frames can be processed. In this case,  must be specified which holds the key of the tag that denotes how many OFDM symbols are in a frame. Output: A stream of (scalar) complex symbols, which include the cyclic prefix and the pulse shaping. Note: If complete frames are processed, and  is greater than zero, the final OFDM symbol is followed by the delay line of the pulse shaping.


The pulse shape is a raised cosine in the time domain.


Different CP lengths as for instance needed in LTE are supported. This is why one of the inputs is std::vector<int>. After every CP given has been prepended to symbols, each with the length of the IFFT operation, the mechanism will wrap around and start over. To give an example, the input tuple for LTE with an FFT length of 2048 would be (160,) + (144,)*6, which is equal to (160, 144, 144, 144, 144, 144, 144). A uniform CP would be indicated by (uniform_cp_length, ).


This block does some sanity checking: 1. It is not allowed to have a vector of CP lengths, which are only 0. 2. Not a single CP in the vector must be longer than the rolloff. 3. Not a single CP is allowed to be < 0.

Constructor Specific Documentation:



Args:
    input_size : IFFT length (i.e. length of the OFDM symbols).
    output_size : FFT length + cyclic prefix length (in samples).
    rolloff_len : Length of the rolloff flank in samples.
    len_tag_key : For framed processing the key of the length tag.)doc";


static const char* __doc_gr_digital_ofdm_cyclic_prefixer_ofdm_cyclic_prefixer =
    R"doc()doc";


static const char* __doc_gr_digital_ofdm_cyclic_prefixer_make_0 = R"doc()doc";


static const char* __doc_gr_digital_ofdm_cyclic_prefixer_make_1 = R"doc()doc";
