/*
 * Copyright 2021 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_rfnoc_block = R"doc(Base class for RFNoC blocks controlled by GNU Radio


Any GNU Radio block that is meant to control an RFNoC block should be derived from this class.)doc";


static const char* __doc_gr_uhd_rfnoc_block_make_block_ref = R"doc(Factory function to create a UHD block controller reference.)doc";


static const char* __doc_gr_uhd_rfnoc_block_get_unique_id = R"doc(Return the unique ID of the underlying block)doc";


static const char* __doc_gr_uhd_rfnoc_block_set_properties = R"doc(Set multiple properties coming from a dictionary


See the  for details.


This function allows the client to override the  parameter for each property key/value pair passed in via the  parameter. If the key consists of the property name, followed by a colon (':') and then a number, the number following the colon is used to determine which instance of the property this set pertains to, and the  parameter is ignored for that property. (Note that if the key does not have the colon and instance number override syntax, then  is still used to determine which instance of the property to set. For example, in the following call: 


instance 1 of node's 'dog' property is set to 10, the 1 coming from the instance parameter, instance 2 of the node's 'cat' property is set to 5 due to the override syntax provided in the string, and instance 0 of the node's 'bird' property is set to 0.5 due to its override.


If the instance override is malformed, that is, there is no number following the colon, or the number cannot be parsed as an integer, a value_error is thrown.


If a key in  is not a valid property of this block, a warning is logged, but no error is raised.)doc";


static const char* __doc_gr_uhd_rfnoc_block_set_property = R"doc(Set a specific user property that belongs to this block.


Setting a user property will trigger a property resolution. This means that changing this block can have effects on other RFNoC blocks or nodes (like streamers).)doc";


static const char* __doc_gr_uhd_rfnoc_block_get_property = R"doc(Get the value of a specific block argument.  type of an argument must be known at compile time.


Note: Despite this being a \"getter\", this function is not declared const. This is because internally, it can resolve properties, which may cause changes within the object.)doc";
