/* do not edit automatically generated by mc from M2Range.  */
/* M2Range.mod exports procedures which maintain the range checking.

Copyright (C) 2008-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Range_C

#include "GM2Range.h"
#   include "GSymbolTable.h"
#   include "GSYSTEM.h"
#   include "Gm2tree.h"
#   include "Gm2linemap.h"
#   include "Gm2type.h"
#   include "Gm2statement.h"
#   include "Gm2expr.h"
#   include "Gm2convert.h"
#   include "Gm2decl.h"
#   include "Gm2builtins.h"
#   include "GM2Debug.h"
#   include "GIndexing.h"
#   include "GStorage.h"
#   include "GM2ALU.h"
#   include "GM2Options.h"
#   include "GM2Error.h"
#   include "GM2ColorString.h"
#   include "GM2MetaError.h"
#   include "GM2LexBuf.h"
#   include "GStrIO.h"
#   include "GNumberIO.h"
#   include "GM2GCCDeclare.h"
#   include "GM2Quads.h"
#   include "GSymbolConversion.h"
#   include "GLists.h"
#   include "GNameKey.h"
#   include "GStdIO.h"
#   include "GDynamicStrings.h"
#   include "GM2GenGCC.h"
#   include "GM2System.h"
#   include "GFormatStrings.h"
#   include "GM2Check.h"
#   include "GM2Base.h"
#   include "GM2CaseList.h"

typedef struct M2Range__T1_r M2Range__T1;

typedef M2Range__T1 *M2Range_Range;

typedef enum {M2Range_assignment, M2Range_returnassignment, M2Range_subrangeassignment, M2Range_inc, M2Range_dec, M2Range_incl, M2Range_excl, M2Range_shift, M2Range_rotate, M2Range_typeindrx, M2Range_typeexpr, M2Range_typeassign, M2Range_typeparam, M2Range_typereturn, M2Range_paramassign, M2Range_staticarraysubscript, M2Range_dynamicarraysubscript, M2Range_forloopbegin, M2Range_forloopto, M2Range_forloopend, M2Range_pointernil, M2Range_noreturn, M2Range_noelse, M2Range_casebounds, M2Range_wholenonposdiv, M2Range_wholenonposmod, M2Range_wholezerodiv, M2Range_wholezerorem, M2Range_none} M2Range_TypeOfRange;

struct M2Range__T1_r {
                       M2Range_TypeOfRange type;
                       unsigned int des;
                       unsigned int expr;
                       unsigned int expr2;
                       unsigned int byconst;
                       unsigned int desLowestType;
                       unsigned int exprLowestType;
                       unsigned int procedure;
                       unsigned int paramNo;
                       bool isLeftValue;
                       unsigned int dimension;
                       unsigned int caseList;
                       unsigned int destok;
                       unsigned int exprtok;
                       unsigned int expr2tok;
                       unsigned int byconsttok;
                       unsigned int tokenNo;
                       unsigned int incrementquad;
                       bool errorReported;
                       bool strict;
                       bool isin;
                       bool cancelled;
                       unsigned int dependantid;
                     };

static unsigned int TopOfRange;
static Indexing_Index RangeIndex;
static unsigned int BreakRange;

/*
   InitAssignmentRangeCheck - returns a range check node which
                              remembers the information necessary
                              so that a range check for des := expr
                              can be generated later on.
*/

extern "C" unsigned int M2Range_InitAssignmentRangeCheck (unsigned int tokno, unsigned int des, unsigned int expr, unsigned int destok, unsigned int exprtok);

/*
   InitReturnRangeCheck - returns a range check node which
                          remembers the information necessary
                          so that a range check for RETURN e
                          from procedure, d, can be generated later on.
*/

extern "C" unsigned int M2Range_InitReturnRangeCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitSubrangeRangeCheck - returns a range check node which
                            remembers the information necessary
                            so that a range check for d := e
                            can be generated later on.
*/

extern "C" unsigned int M2Range_InitSubrangeRangeCheck (unsigned int d, unsigned int e);

/*
   InitStaticArraySubscriptRangeCheck - returns a range check node which
                                        remembers the information necessary
                                        so that a range check for d[e]
                                        can be generated later on.
*/

extern "C" unsigned int M2Range_InitStaticArraySubscriptRangeCheck (unsigned int d, unsigned int e, unsigned int dim);

/*
   InitDynamicArraySubscriptRangeCheck - returns a range check node which
                                         remembers the information necessary
                                         so that a range check for d[e]
                                         can be generated later on.
*/

extern "C" unsigned int M2Range_InitDynamicArraySubscriptRangeCheck (unsigned int d, unsigned int e, unsigned int dim);

/*
   InitIncRangeCheck - returns a range check node which
                       remembers the information necessary
                       so that a range check for INC(d, e)
                       can be generated later on.
*/

extern "C" unsigned int M2Range_InitIncRangeCheck (unsigned int d, unsigned int e);

/*
   InitDecRangeCheck - returns a range check node which
                       remembers the information necessary
                       so that a range check for DEC(d, e)
                       can be generated later on.
*/

extern "C" unsigned int M2Range_InitDecRangeCheck (unsigned int d, unsigned int e);

/*
   InitForLoopBeginRangeCheck - returns a range check node which
                                remembers the information necessary
                                so that a range check for
                                FOR des := expr1 TO expr2 DO
                                can be generated later on.  expr2 is
                                only used to type check with des.
*/

extern "C" unsigned int M2Range_InitForLoopBeginRangeCheck (unsigned int des, unsigned int destok, unsigned int expr1, unsigned int expr1tok, unsigned int expr2, unsigned int expr2tok, unsigned int byconst, unsigned int byconsttok);

/*
   PutRangeForIncrement - places incrementquad into the range record.
*/

extern "C" void M2Range_PutRangeForIncrement (unsigned int range, unsigned int incrementquad);

/*
   InitForLoopToRangeCheck - returns a range check node which
                             remembers the information necessary
                             so that a range check for FOR d := e TO .. DO
                             can be generated later on.
*/

extern "C" unsigned int M2Range_InitForLoopToRangeCheck (unsigned int d, unsigned int e);

/*
   InitForLoopEndRangeCheck - returns a range check node which
                              remembers the information necessary
                              so that a range check for
                              INC or DEC(d, e)
                              can be generated later on.
*/

extern "C" unsigned int M2Range_InitForLoopEndRangeCheck (unsigned int d, unsigned int e);

/*
   InitPointerRangeCheck - creates a pointer # NIL check.
*/

extern "C" unsigned int M2Range_InitPointerRangeCheck (unsigned int tokno, unsigned int d, bool isLeft);

/*
   InitNoReturnRangeCheck - creates a check held in the function
                            to detect the absence of a RETURN
                            statement at runtime.
*/

extern "C" unsigned int M2Range_InitNoReturnRangeCheck (void);

/*
   InitNoElseRangeCheck - creates a check held at the end of
                          a CASE statement without an ELSE
                          clause to detect its absence
                          at runtime.
*/

extern "C" unsigned int M2Range_InitNoElseRangeCheck (void);

/*
   InitWholeNonPosDivCheck - creates a check expression for non positive
                             or zero 2nd operand to division.
*/

extern "C" unsigned int M2Range_InitWholeNonPosDivCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitWholeNonPosModCheck - creates a check expression for non positive
                             or zero 2nd operand to modulus.
*/

extern "C" unsigned int M2Range_InitWholeNonPosModCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitWholeZeroDivisionCheck - creates a check expression for zero 2nd
                                operand for division.
*/

extern "C" unsigned int M2Range_InitWholeZeroDivisionCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitWholeZeroRemainderCheck - creates a check expression for zero 2nd
                                 operand for remainder.
*/

extern "C" unsigned int M2Range_InitWholeZeroRemainderCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitInclCheck - checks to see that bit, e, is type compatible with
                   e and also in range.
*/

extern "C" unsigned int M2Range_InitInclCheck (unsigned int d, unsigned int e);

/*
   InitExclCheck - checks to see that bit, e, is type compatible with
                   e and also in range.
*/

extern "C" unsigned int M2Range_InitExclCheck (unsigned int d, unsigned int e);

/*
   InitShiftCheck - checks to see that bit, e, is type compatible with
                    d and also in range.
*/

extern "C" unsigned int M2Range_InitShiftCheck (unsigned int d, unsigned int e);

/*
   InitRotateCheck - checks to see that bit, e, is type compatible with
                     d and also in range.
*/

extern "C" unsigned int M2Range_InitRotateCheck (unsigned int d, unsigned int e);

/*
   InitTypesAssignmentCheck - checks to see that the types of d and e
                              are assignment compatible.
*/

extern "C" unsigned int M2Range_InitTypesAssignmentCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitTypesParameterCheck - checks to see that the types of, d,
                             and, e, are parameter compatible.
*/

extern "C" unsigned int M2Range_InitTypesParameterCheck (unsigned int tokno, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int depRangeId);

/*
   InitParameterRangeCheck - checks to see that the types of, d, and, e,
                             are parameter compatible.
*/

extern "C" unsigned int M2Range_InitParameterRangeCheck (unsigned int tokno, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int parentRangeId);

/*
   InitTypesExpressionCheck - checks to see that the types of, d, and, e,
                              are expression compatible.
*/

extern "C" unsigned int M2Range_InitTypesExpressionCheck (unsigned int tokno, unsigned int d, unsigned int e, bool strict, bool isin);

/*
   InitTypesIndrXCheck - checks to see that the types of d and e
                         are assignment compatible.  The type checking
                         will dereference *e during the type check.
                         d = *e.
*/

extern "C" unsigned int M2Range_InitTypesIndrXCheck (unsigned int tokno, unsigned int d, unsigned int e);

/*
   InitTypesReturnTypeCheck - checks to see that the types of des and func
                              are assignment compatible.
*/

extern "C" unsigned int M2Range_InitTypesReturnTypeCheck (unsigned int tokno, unsigned int func, unsigned int val);

/*
   InitCaseBounds - creates a case bound range check.
*/

extern "C" unsigned int M2Range_InitCaseBounds (unsigned int b);

/*
   CodeRangeCheck - returns a Tree representing the code for a
                    range test defined by, r.
*/

extern "C" void M2Range_CodeRangeCheck (unsigned int r, DynamicStrings_String function);

/*
   FoldRangeCheck - attempts to resolve the range check.
                    If it evaluates to true then
                       it is replaced by an ErrorOp
                    elsif it evaluates to false then
                       it is removed
                    else
                       it is left alone
*/

extern "C" void M2Range_FoldRangeCheck (unsigned int tokenno, unsigned int quad, unsigned int range);

/*
   CodeErrorCheck - returns a Tree calling the approprate exception handler.
*/

extern "C" tree M2Range_CodeErrorCheck (unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   WriteRangeCheck - displays debugging information about range, r.
*/

extern "C" void M2Range_WriteRangeCheck (unsigned int r);

/*
   OverlapsRange - returns TRUE if a1..a2 overlaps with b1..b2.
*/

extern "C" bool M2Range_OverlapsRange (tree a1, tree a2, tree b1, tree b2);

/*
   IsEqual - returns TRUE if a=b.
*/

extern "C" bool M2Range_IsEqual (tree a, tree b);

/*
   IsGreaterOrEqual - returns TRUE if a>=b.
*/

extern "C" bool M2Range_IsGreaterOrEqual (tree a, tree b);

/*
   IsGreater - returns TRUE if a>b.
*/

extern "C" bool M2Range_IsGreater (tree a, tree b);

/*
   BuildIfCallWholeHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

extern "C" tree M2Range_BuildIfCallWholeHandlerLoc (location_t location, tree condition, const char * scope, const char * message);

/*
   BuildIfCallRealHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

extern "C" tree M2Range_BuildIfCallRealHandlerLoc (location_t location, tree condition, const char * scope, const char * message);

/*
   GetMinMax - returns TRUE if we know the max and min of m2type.
*/

extern "C" bool M2Range_GetMinMax (unsigned int tokenno, unsigned int type, tree *min, tree *max);
static void gdbhook (void);

/*
   BreakWhenRangeCreated - to be called interactively by gdb.
*/

static void BreakWhenRangeCreated (unsigned int r);

/*
   CheckBreak - if sym = BreakRange then call gdbhook.
*/

static void CheckBreak (unsigned int r);

/*
   IsGreaterOrEqualConversion - tests whether t>=e.
*/

static bool IsGreaterOrEqualConversion (location_t location, unsigned int l, unsigned int d, unsigned int e);

/*
   IsEqualConversion - returns TRUE if a=b.
*/

static bool IsEqualConversion (unsigned int l, unsigned int d, unsigned int e);

/*
   lookupExceptionHandler -
*/

static unsigned int lookupExceptionHandler (M2Range_TypeOfRange type);

/*
   InitRange - returns a new range item.
*/

static unsigned int InitRange (void);

/*
   reportedError - returns whether this is the first time this error has been
                   reported.
*/

static bool reportedError (unsigned int r);

/*
   setReported - assigns errorReported to TRUE.
*/

static void setReported (unsigned int r);

/*
   PutRange - initializes contents of, p, to
              d, e and their lowest types.
              It also fills in the current token no
              and returns, p.
*/

static M2Range_Range PutRange (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e);

/*
   PutRangeDesExpr2 - initializes contents of, p, to
                      des, expr1 and their lowest types.
                      It also fills in the token numbers for
                      des, expr, expr2 and returns, p.
*/

static M2Range_Range PutRangeDesExpr2 (M2Range_Range p, M2Range_TypeOfRange t, unsigned int des, unsigned int destok, unsigned int expr1, unsigned int expr1tok, unsigned int expr2, unsigned int expr2tok, unsigned int byconst, unsigned int byconsttok);

/*
   chooseTokenPos - returns, tokenpos, if it is not the unknown location, otherwise
                    it returns GetTokenNo.
*/

static unsigned int chooseTokenPos (unsigned int tokenpos);

/*
   PutRangeNoLow - initializes contents of, p.  It
                   does not set lowest types as they may be
                   unknown at this point.
*/

static M2Range_Range PutRangeNoLow (unsigned int tokpos, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e);

/*
   PutRangeExpr - initializes contents of, p.  It
                  does not set lowest types as they may be
                  unknown at this point.
*/

static M2Range_Range PutRangeExpr (unsigned int tokpos, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e, bool strict, bool isin);

/*
   PutRangePointer - initializes contents of, p, to
                     d, isLeft and their lowest types.
                     It also fills in the current token no
                     and returns, p.
*/

static M2Range_Range PutRangePointer (unsigned int tokpos, M2Range_Range p, unsigned int d, bool isLeft);

/*
   PutRangeNoEval - initializes contents of, p, to a non evaluation
                    runtime check such as a no else clause or
                    no return found in function call.
*/

static M2Range_Range PutRangeNoEval (M2Range_Range p, M2Range_TypeOfRange t);
static M2Range_Range PutRangeUnary (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e);

/*
   PutRangeParam - initializes contents of, p, to contain the parameter
                   type checking information.
                   It also fills in the current token no
                   and returns, p.
*/

static M2Range_Range PutRangeParam (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int depRangeId);

/*
   PutRangeArraySubscript - initializes contents of, p, to
                            d, e and their lowest types.  It also
                            assigns, dim.
                            It also fills in the current token no
                            and returns, p.
*/

static M2Range_Range PutRangeArraySubscript (M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e, unsigned int dim);

/*
   PutRangeParamAssign - initializes contents of, p, to contain the parameter
                         type checking information.
                         It also fills in the current token no
                         and returns, p.
*/

static M2Range_Range PutRangeParamAssign (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int proc, unsigned int i, unsigned int formal, unsigned int actual, unsigned int parentRangeId);

/*
   FoldNil - attempts to fold the pointer against nil comparison.
*/

static void FoldNil (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   OutOfRange - returns TRUE if expr lies outside min..max.
*/

static bool OutOfRange (unsigned int tokenno, tree min, unsigned int expr, tree max, unsigned int type);

/*
   HandlerExists -
*/

static bool HandlerExists (unsigned int r);

/*
   FoldAssignment - attempts to fold the range violation checks.
                    It does not issue errors on type violations as that
                    is performed by FoldTypeAssign.
*/

static void FoldAssignment (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   IsCancelled - return the cancelled flag associated with range.
*/

static bool IsCancelled (unsigned int range);

/*
   Cancel - set the cancelled flag in range.
*/

static void Cancel (unsigned int range);

/*
   FoldParameterAssign -
*/

static void FoldParameterAssign (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldReturn - do we know this is reachable, if so generate an error message.
*/

static void FoldReturn (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldInc -
*/

static void FoldInc (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldDec -
*/

static void FoldDec (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   CheckSetAndBit - returns TRUE if des is a set type and expr is compatible with des.
*/

static bool CheckSetAndBit (unsigned int tokenno, unsigned int des, unsigned int expr, const char *name_, unsigned int _name_high);

/*
   CheckSet - returns TRUE if des is a set type and expr is compatible with INTEGER.
*/

static bool CheckSet (unsigned int tokenno, unsigned int des, unsigned int expr, const char *name_, unsigned int _name_high);

/*
   FoldIncl - folds an INCL statement if the operands are constant.
*/

static void FoldIncl (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldExcl - folds an EXCL statement if the operands are constant.
*/

static void FoldExcl (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldShift - folds an SHIFT test statement if the operands are constant.
*/

static void FoldShift (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldRotate - folds a ROTATE test statement if the operands are constant.
*/

static void FoldRotate (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldTypeReturnFunc - checks to see that val can be returned from func.
*/

static void FoldTypeReturnFunc (unsigned int q, unsigned int tokenNo, unsigned int func, unsigned int val, unsigned int r);

/*
   FoldTypeAssign -
*/

static void FoldTypeAssign (unsigned int q, unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r);

/*
   FoldTypeIndrX - check to see that des = *expr is type compatible.
*/

static void FoldTypeIndrX (unsigned int q, unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r);

/*
   FoldTypeParam - performs a parameter check between actual and formal.
                   The quad is removed if the check succeeds.
*/

static void FoldTypeParam (unsigned int q, unsigned int tokenNo, unsigned int formal, unsigned int actual, unsigned int procedure, unsigned int paramNo, unsigned int depRangeId);

/*
   FoldTypeExpr -
*/

static void FoldTypeExpr (unsigned int q, unsigned int tokenNo, unsigned int left, unsigned int right, bool strict, bool isin, unsigned int r);

/*
   CodeTypeAssign -
*/

static void CodeTypeAssign (unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r);

/*
   CodeTypeReturnFunc -
*/

static void CodeTypeReturnFunc (unsigned int tokenNo, unsigned int func, unsigned int val, unsigned int r);

/*
   CodeTypeIndrX - checks that des = *expr is type compatible and generates an error if they
                   are not compatible.  It skips over the LValue type so that to allow
                   the error messages to pick up the source variable name rather than
                   a temporary name or vague name 'expression'.
*/

static void CodeTypeIndrX (unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r);

/*
   CodeTypeParam -
*/

static void CodeTypeParam (unsigned int tokenNo, unsigned int formal, unsigned int actual, unsigned int procedure, unsigned int paramNo);

/*
   CodeTypeExpr -
*/

static void CodeTypeExpr (unsigned int tokenNo, unsigned int left, unsigned int right, bool strict, bool isin, unsigned int r);

/*
   FoldTypeCheck - folds a type check.  This is a no-op and it used
                   for checking types which are resolved post pass 3.
*/

static void FoldTypeCheck (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   CodeTypeCheck - folds a type check.  This is a no-op and it used
                   for checking types which are resolved post pass 3.
                   It does assume that both, des, and, expr, have been
                   resolved at this point.
*/

static void CodeTypeCheck (unsigned int tokenno, unsigned int r);

/*
   ForLoopBeginTypeCompatible - check for designator assignment compatibility with
                                expr1 and designator expression compatibility with expr2.
                                FOR des := expr1 TO expr2 BY byconst DO
                                END
                                It generates composite tokens if the tokens are on
                                the same source line.
*/

static bool ForLoopBeginTypeCompatible (M2Range_Range p);

/*
   FoldForLoopBegin -
*/

static void FoldForLoopBegin (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldForLoopTo -
*/

static void FoldForLoopTo (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldStaticArraySubscript -
*/

static void FoldStaticArraySubscript (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldDynamicArraySubscript -
*/

static void FoldDynamicArraySubscript (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldCaseBounds -
*/

static void FoldCaseBounds (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   CodeCaseBounds - attempts to resolve whether the case bounds are legal.
                    This should resolve at compile time as all case bounds
                    must be constants.  We introduce a CodeCaseBounds as it
                    might be possible that constants have just been declared
                    during the code generation of this function.
*/

static void CodeCaseBounds (unsigned int tokenno, unsigned int caseList);

/*
   MakeAndDeclareConstLit - creates a constant of value and declares it to GCC.
*/

static unsigned int MakeAndDeclareConstLit (unsigned int tokenno, NameKey_Name value, unsigned int type);

/*
   FoldNonPosDiv - attempts to fold the bound checking for a divide expression.
*/

static void FoldNonPosDiv (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldNonPosMod - attempts to fold the bound checking for a modulus expression.
*/

static void FoldNonPosMod (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldZeroDiv -
*/

static void FoldZeroDiv (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldZeroRem -
*/

static void FoldZeroRem (unsigned int tokenno, unsigned int q, unsigned int r);

/*
   FoldRangeCheckLower - call the appropriate Fold procedure depending upon the type
                         of range.
*/

static void FoldRangeCheckLower (unsigned int tokenno, unsigned int quad, unsigned int range);

/*
   DeReferenceLValue - returns a Tree which is either ModGcc(expr)
                       or Mod2Gcc ( *expr) depending whether, expr,
                       is an LValue.
*/

static tree DeReferenceLValue (unsigned int tokenno, unsigned int expr);

/*
   BuildStringParam - builds a C style string parameter which will be passed
                      as an ADDRESS type.
*/

static void BuildStringParam (unsigned int tokenno, DynamicStrings_String s);

/*
   BuildStringParamLoc - builds a C style string parameter which will be passed
                         as an ADDRESS type.
*/

static void BuildStringParamLoc (location_t location, DynamicStrings_String s);

/*
   IssueWarning - issue a warning.  The compiler knows that this basic block can be reached
                  and we are in scope, function.
*/

static void IssueWarning (DynamicStrings_String function, unsigned int r);

/*
   CodeErrorCheckLoc - generate a runtime error message positioned at location
                       and in function.  If function is NIL then the error scope
                       is used.
*/

static tree CodeErrorCheckLoc (location_t location, const char * function, const char * message, unsigned int func);

/*
   IssueWarningLoc -
*/

static void IssueWarningLoc (location_t location, const char * message);

/*
   BuildIfCallHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

static tree BuildIfCallHandlerLoc (location_t location, tree condition, const char * scope, const char * message, unsigned int func);

/*
   BuildIfCallHandler -
*/

static tree BuildIfCallHandler (tree condition, unsigned int r, DynamicStrings_String function, DynamicStrings_String message, bool warning);

/*
   RangeCheckReal -
*/

static void RangeCheckReal (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   RangeCheckOrdinal -
*/

static void RangeCheckOrdinal (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   DoCodeAssignmentExprType -
*/

static void DoCodeAssignmentExprType (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   DoCodeAssignmentWithoutExprType -
*/

static void DoCodeAssignmentWithoutExprType (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   DoCodeAssignment -
*/

static void DoCodeAssignment (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeAssignment -
*/

static void CodeAssignment (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeParameterAssign -
*/

static void CodeParameterAssign (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeReturn -
*/

static void CodeReturn (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   IfOutsideLimitsDo -
*/

static void IfOutsideLimitsDo (unsigned int tokenno, tree min, tree expr, tree max, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeInc -
*/

static void CodeInc (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeDec -
*/

static void CodeDec (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeInclExcl -
*/

static void CodeInclExcl (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeShiftRotate - ensure that the bit shift is within the range
                     -(MAX(set)-MIN(set)+1)..(MAX(set)-MIN(set)+1)
*/

static void CodeShiftRotate (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeStaticArraySubscript -
*/

static void CodeStaticArraySubscript (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeDynamicArraySubscript -
*/

static void CodeDynamicArraySubscript (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeForLoopBegin -
*/

static void CodeForLoopBegin (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeForLoopTo -
*/

static void CodeForLoopTo (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   SameTypesCodeForLoopEnd - the trivial case.
*/

static void SameTypesCodeForLoopEnd (unsigned int tokenNo, unsigned int r, DynamicStrings_String function, DynamicStrings_String message, M2Range_Range p, tree dmax);
static void DiffTypesCodeForLoopEnd (unsigned int tokenNo, unsigned int r, DynamicStrings_String function, DynamicStrings_String message, M2Range_Range p, tree dmax, tree emin, tree emax);

/*
   CodeForLoopEnd - checks to see that des := des + expr does not overflow.
                    This is called at the end of the for loop.  It is more complex
                    than it initially seems as des and expr might be different types.
*/

static void CodeForLoopEnd (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeNil -
*/

static void CodeNil (unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeWholeNonPos - generates range check code for expr<=0.
*/

static void CodeWholeNonPos (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   CodeWholeZero - generates range check code for expr=0.
*/

static void CodeWholeZero (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message);

/*
   FillInParameters -
*/

static DynamicStrings_String FillInParameters (unsigned int r, DynamicStrings_String s);

/*
   GetRangeErrorMessage - returns a specific error message for the range, r.
                          It assumes the 3 parameters to be supplied on the MetaError
                          parameter list are:  dest, expr, paramNo or dimension.

XYZ
                    'the initial assignment to {%1a} at the start of the FOR loop will cause a range error, as the type range of {%1taD} does not overlap with {%2tad}')
                    'the final TO value {%2a} of the FOR loop will cause a range error with the iterator variable {%1a}')
*/

static DynamicStrings_String GetRangeErrorMessage (unsigned int r);

/*
   Init - initializes the modules global variables.
*/

static void Init (void);

static void gdbhook (void)
{
}


/*
   BreakWhenRangeCreated - to be called interactively by gdb.
*/

static void BreakWhenRangeCreated (unsigned int r)
{
  BreakRange = r;
}


/*
   CheckBreak - if sym = BreakRange then call gdbhook.
*/

static void CheckBreak (unsigned int r)
{
  if (BreakRange == r)
    {
      gdbhook ();
    }
}


/*
   IsGreaterOrEqualConversion - tests whether t>=e.
*/

static bool IsGreaterOrEqualConversion (location_t location, unsigned int l, unsigned int d, unsigned int e)
{
  if ((SymbolTable_GetType (d)) == SymbolTable_NulSym)
    {
      if ((SymbolTable_GetType (e)) == SymbolTable_NulSym)
        {
          return M2Range_IsGreaterOrEqual (SymbolConversion_Mod2Gcc (l), M2GenGCC_LValueToGenericPtr (location, e));
        }
      else
        {
          return M2Range_IsGreaterOrEqual (m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (e))), SymbolConversion_Mod2Gcc (l), false), M2GenGCC_LValueToGenericPtr (location, e));
        }
    }
  else
    {
      return M2Range_IsGreaterOrEqual (m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (d))), SymbolConversion_Mod2Gcc (l), false), M2GenGCC_LValueToGenericPtr (location, e));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsEqualConversion - returns TRUE if a=b.
*/

static bool IsEqualConversion (unsigned int l, unsigned int d, unsigned int e)
{
  location_t location;

  location = M2LexBuf_TokenToLocation (SymbolTable_GetDeclaredMod (l));
  if ((SymbolTable_GetType (d)) == SymbolTable_NulSym)
    {
      if ((SymbolTable_GetType (e)) == SymbolTable_NulSym)
        {
          return M2Range_IsEqual (SymbolConversion_Mod2Gcc (l), M2GenGCC_LValueToGenericPtr (location, e));
        }
      else
        {
          return M2Range_IsEqual (m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (e))), SymbolConversion_Mod2Gcc (l), false), M2GenGCC_LValueToGenericPtr (location, e));
        }
    }
  else
    {
      return M2Range_IsEqual (m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (SymbolTable_SkipType (SymbolTable_GetType (d))), SymbolConversion_Mod2Gcc (l), false), M2GenGCC_LValueToGenericPtr (location, e));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   lookupExceptionHandler -
*/

static unsigned int lookupExceptionHandler (M2Range_TypeOfRange type)
{
  switch (type)
    {
      case M2Range_assignment:
        return M2Base_ExceptionAssign;
        break;

      case M2Range_returnassignment:
        return M2Base_ExceptionReturn;
        break;

      case M2Range_subrangeassignment:
        M2Error_InternalError ((const char *) "not expecting this case value", 29);
        break;

      case M2Range_inc:
        return M2Base_ExceptionInc;
        break;

      case M2Range_dec:
        return M2Base_ExceptionDec;
        break;

      case M2Range_incl:
        return M2Base_ExceptionIncl;
        break;

      case M2Range_excl:
        return M2Base_ExceptionExcl;
        break;

      case M2Range_shift:
        return M2Base_ExceptionShift;
        break;

      case M2Range_rotate:
        return M2Base_ExceptionRotate;
        break;

      case M2Range_typeassign:
      case M2Range_typeparam:
      case M2Range_typeexpr:
      case M2Range_typeindrx:
        M2Error_InternalError ((const char *) "not expecting this case value", 29);
        break;

      case M2Range_paramassign:
        return M2Base_ExceptionParameterBounds;
        break;

      case M2Range_staticarraysubscript:
        return M2Base_ExceptionStaticArray;
        break;

      case M2Range_dynamicarraysubscript:
        return M2Base_ExceptionDynamicArray;
        break;

      case M2Range_forloopbegin:
        return M2Base_ExceptionForLoopBegin;
        break;

      case M2Range_forloopto:
        return M2Base_ExceptionForLoopTo;
        break;

      case M2Range_forloopend:
        return M2Base_ExceptionForLoopEnd;
        break;

      case M2Range_pointernil:
        return M2Base_ExceptionPointerNil;
        break;

      case M2Range_noreturn:
        return M2Base_ExceptionNoReturn;
        break;

      case M2Range_noelse:
        return M2Base_ExceptionCase;
        break;

      case M2Range_casebounds:
        M2Error_InternalError ((const char *) "not expecting this case value", 29);
        break;

      case M2Range_wholenonposdiv:
        return M2Base_ExceptionNonPosDiv;
        break;

      case M2Range_wholenonposmod:
        return M2Base_ExceptionNonPosMod;
        break;

      case M2Range_wholezerodiv:
        return M2Base_ExceptionZeroDiv;
        break;

      case M2Range_wholezerorem:
        return M2Base_ExceptionZeroRem;
        break;

      case M2Range_none:
        return M2Base_ExceptionNo;
        break;


      default:
        M2Error_InternalError ((const char *) "enumeration value unknown", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Range.def", 20, 1);
  __builtin_unreachable ();
}


/*
   InitRange - returns a new range item.
*/

static unsigned int InitRange (void)
{
  unsigned int r;
  M2Range_Range p;

  TopOfRange += 1;
  r = TopOfRange;
  Storage_ALLOCATE ((void **) &p, sizeof (M2Range__T1));
  if (p == NULL)
    {
      M2Error_InternalError ((const char *) "out of memory error", 19);
    }
  else
    {
      CheckBreak (r);
      p->type = M2Range_none;
      p->des = SymbolTable_NulSym;
      p->expr = SymbolTable_NulSym;
      p->expr2 = SymbolTable_NulSym;
      p->byconst = SymbolTable_NulSym;
      p->desLowestType = SymbolTable_NulSym;
      p->exprLowestType = SymbolTable_NulSym;
      p->isLeftValue = false;  /* ignored in all cases other  */
      p->dimension = 0;  /* ignored in all cases other  */
      p->caseList = 0;
      p->tokenNo = M2LexBuf_UnknownTokenNo;  /* than pointernil  */
      p->destok = M2LexBuf_UnknownTokenNo;  /* than pointernil  */
      p->exprtok = M2LexBuf_UnknownTokenNo;
      p->expr2tok = M2LexBuf_UnknownTokenNo;
      p->byconsttok = M2LexBuf_UnknownTokenNo;
      p->incrementquad = 0;
      p->errorReported = false;
      p->cancelled = false;
      p->dependantid = 0;
      Indexing_PutIndice (RangeIndex, r, reinterpret_cast <void *> (p));
    }
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   reportedError - returns whether this is the first time this error has been
                   reported.
*/

static bool reportedError (unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  return p->errorReported;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   setReported - assigns errorReported to TRUE.
*/

static void setReported (unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  p->errorReported = true;
}


/*
   PutRange - initializes contents of, p, to
              d, e and their lowest types.
              It also fills in the current token no
              and returns, p.
*/

static M2Range_Range PutRange (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e)
{
  p->type = t;
  p->des = d;
  p->expr = e;
  p->desLowestType = SymbolTable_GetLowestType (d);
  p->exprLowestType = SymbolTable_GetLowestType (e);
  p->tokenNo = tokno;
  p->strict = false;
  p->isin = false;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeDesExpr2 - initializes contents of, p, to
                      des, expr1 and their lowest types.
                      It also fills in the token numbers for
                      des, expr, expr2 and returns, p.
*/

static M2Range_Range PutRangeDesExpr2 (M2Range_Range p, M2Range_TypeOfRange t, unsigned int des, unsigned int destok, unsigned int expr1, unsigned int expr1tok, unsigned int expr2, unsigned int expr2tok, unsigned int byconst, unsigned int byconsttok)
{
  p->des = des;
  p->destok = destok;
  p->expr = expr1;
  p->exprtok = expr1tok;
  p->expr2 = expr2;
  p->expr2tok = expr2tok;
  p->byconst = byconst;
  p->byconsttok = byconsttok;
  p->type = t;
  p->desLowestType = SymbolTable_GetLowestType (p->des);
  p->exprLowestType = SymbolTable_GetLowestType (expr1);
  p->strict = false;
  p->isin = false;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   chooseTokenPos - returns, tokenpos, if it is not the unknown location, otherwise
                    it returns GetTokenNo.
*/

static unsigned int chooseTokenPos (unsigned int tokenpos)
{
  if (tokenpos == M2LexBuf_UnknownTokenNo)
    {
      return M2LexBuf_GetTokenNo ();
    }
  else
    {
      return tokenpos;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeNoLow - initializes contents of, p.  It
                   does not set lowest types as they may be
                   unknown at this point.
*/

static M2Range_Range PutRangeNoLow (unsigned int tokpos, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e)
{
  p->type = t;
  p->des = d;
  p->expr = e;
  p->desLowestType = SymbolTable_NulSym;
  p->exprLowestType = SymbolTable_NulSym;
  p->isLeftValue = false;
  p->tokenNo = chooseTokenPos (tokpos);
  p->strict = false;
  p->isin = false;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeExpr - initializes contents of, p.  It
                  does not set lowest types as they may be
                  unknown at this point.
*/

static M2Range_Range PutRangeExpr (unsigned int tokpos, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e, bool strict, bool isin)
{
  p->type = t;
  p->des = d;
  p->expr = e;
  p->desLowestType = SymbolTable_NulSym;
  p->exprLowestType = SymbolTable_NulSym;
  p->isLeftValue = false;
  p->tokenNo = chooseTokenPos (tokpos);
  p->strict = strict;
  p->isin = isin;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangePointer - initializes contents of, p, to
                     d, isLeft and their lowest types.
                     It also fills in the current token no
                     and returns, p.
*/

static M2Range_Range PutRangePointer (unsigned int tokpos, M2Range_Range p, unsigned int d, bool isLeft)
{
  p->type = M2Range_pointernil;
  p->des = d;
  p->expr = SymbolTable_NulSym;
  p->desLowestType = SymbolTable_GetLowestType (SymbolTable_GetType (d));
  p->exprLowestType = SymbolTable_NulSym;
  p->isLeftValue = isLeft;
  p->tokenNo = tokpos;
  p->strict = false;
  p->isin = false;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeNoEval - initializes contents of, p, to a non evaluation
                    runtime check such as a no else clause or
                    no return found in function call.
*/

static M2Range_Range PutRangeNoEval (M2Range_Range p, M2Range_TypeOfRange t)
{
  p->type = t;
  p->tokenNo = M2LexBuf_GetTokenNo ();
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

static M2Range_Range PutRangeUnary (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e)
{
  /* 
   PutRange - initializes contents of, p, to
              d, e and its lowest type.
              It also fills in the current token no
              and returns, p.
  */
  p->type = t;
  p->des = d;
  p->expr = e;
  p->desLowestType = SymbolTable_GetLowestType (d);
  p->exprLowestType = SymbolTable_NulSym;
  p->isLeftValue = false;
  p->tokenNo = chooseTokenPos (tokno);
  p->strict = false;
  p->isin = false;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeParam - initializes contents of, p, to contain the parameter
                   type checking information.
                   It also fills in the current token no
                   and returns, p.
*/

static M2Range_Range PutRangeParam (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int depRangeId)
{
  p->type = t;
  p->des = formal;
  p->expr = actual;
  p->desLowestType = SymbolTable_NulSym;
  p->exprLowestType = SymbolTable_NulSym;
  p->procedure = proc;
  p->paramNo = paramno;
  p->isLeftValue = false;
  p->tokenNo = tokno;
  p->strict = false;
  p->isin = false;
  p->dependantid = depRangeId;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeArraySubscript - initializes contents of, p, to
                            d, e and their lowest types.  It also
                            assigns, dim.
                            It also fills in the current token no
                            and returns, p.
*/

static M2Range_Range PutRangeArraySubscript (M2Range_Range p, M2Range_TypeOfRange t, unsigned int d, unsigned int e, unsigned int dim)
{
  p->type = t;
  p->des = d;
  p->expr = e;
  p->desLowestType = SymbolTable_GetLowestType (d);
  p->exprLowestType = SymbolTable_GetLowestType (e);
  p->dimension = dim;
  p->tokenNo = M2LexBuf_GetTokenNo ();
  p->strict = false;
  p->isin = false;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeParamAssign - initializes contents of, p, to contain the parameter
                         type checking information.
                         It also fills in the current token no
                         and returns, p.
*/

static M2Range_Range PutRangeParamAssign (unsigned int tokno, M2Range_Range p, M2Range_TypeOfRange t, unsigned int proc, unsigned int i, unsigned int formal, unsigned int actual, unsigned int parentRangeId)
{
  p->type = t;
  p->des = formal;
  p->expr = actual;
  p->desLowestType = SymbolTable_GetLowestType (p->des);
  p->exprLowestType = SymbolTable_GetLowestType (p->expr);
  p->procedure = proc;
  p->paramNo = i;
  p->dimension = i;
  p->isLeftValue = false;
  p->tokenNo = tokno;
  p->dependantid = parentRangeId;
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldNil - attempts to fold the pointer against nil comparison.
*/

static void FoldNil (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  if ((SymbolConversion_GccKnowsAbout (p->des)) && (SymbolTable_IsConst (p->des)))  /* use quad tokenno, rather than the range tokenNo  */
    {
      SymbolTable_PushValue (p->des);
      SymbolTable_PushValue (M2Base_Nil);
      if (M2ALU_Equ (tokenno))
        {
          M2MetaError_MetaErrorT1 (p->tokenNo, (const char *) "attempting to dereference a pointer {%1Wa} whose value will be NIL", 66, p->des);
          M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
        }
      else
        {
          M2Quads_SubQuad (q);
        }
    }
}


/*
   OutOfRange - returns TRUE if expr lies outside min..max.
*/

static bool OutOfRange (unsigned int tokenno, tree min, unsigned int expr, tree max, unsigned int type)
{
  if (m2expr_TreeOverflow (min))
    {
      StrIO_WriteString ((const char *) "overflow detected in min\\n", 26);
      StrIO_WriteLn ();
      m2tree_debug_tree (min);
    }
  if (m2expr_TreeOverflow (max))
    {
      StrIO_WriteString ((const char *) "overflow detected in max\\n", 26);
      StrIO_WriteLn ();
      m2tree_debug_tree (max);
    }
  if (m2expr_TreeOverflow (max))
    {
      StrIO_WriteString ((const char *) "overflow detected in expr\\n", 27);
      StrIO_WriteLn ();
      m2tree_debug_tree (M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (expr), type, expr));
    }
  M2ALU_PushIntegerTree (M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (expr), type, expr));
  M2ALU_PushIntegerTree (min);
  if (M2ALU_Less (tokenno))
    {
      return true;
    }
  M2ALU_PushIntegerTree (M2GenGCC_StringToChar (SymbolConversion_Mod2Gcc (expr), type, expr));
  M2ALU_PushIntegerTree (max);
  if (M2ALU_Gre (tokenno))
    {
      return true;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   HandlerExists -
*/

static bool HandlerExists (unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  switch (p->type)
    {
      case M2Range_assignment:
        return M2Base_ExceptionAssign != SymbolTable_NulSym;
        break;

      case M2Range_returnassignment:
        return M2Base_ExceptionReturn != SymbolTable_NulSym;
        break;

      case M2Range_subrangeassignment:
        M2Error_InternalError ((const char *) "not expecting this case value", 29);
        break;

      case M2Range_inc:
        return M2Base_ExceptionInc != SymbolTable_NulSym;
        break;

      case M2Range_dec:
        return M2Base_ExceptionDec != SymbolTable_NulSym;
        break;

      case M2Range_incl:
        return M2Base_ExceptionIncl != SymbolTable_NulSym;
        break;

      case M2Range_excl:
        return M2Base_ExceptionExcl != SymbolTable_NulSym;
        break;

      case M2Range_shift:
        return M2Base_ExceptionShift != SymbolTable_NulSym;
        break;

      case M2Range_rotate:
        return M2Base_ExceptionRotate != SymbolTable_NulSym;
        break;

      case M2Range_typereturn:
      case M2Range_typeassign:
      case M2Range_typeparam:
      case M2Range_typeexpr:
      case M2Range_typeindrx:
        return false;
        break;

      case M2Range_paramassign:
        return M2Base_ExceptionParameterBounds != SymbolTable_NulSym;
        break;

      case M2Range_staticarraysubscript:
        return M2Base_ExceptionStaticArray != SymbolTable_NulSym;
        break;

      case M2Range_dynamicarraysubscript:
        return M2Base_ExceptionDynamicArray != SymbolTable_NulSym;
        break;

      case M2Range_forloopbegin:
        return M2Base_ExceptionForLoopBegin != SymbolTable_NulSym;
        break;

      case M2Range_forloopto:
        return M2Base_ExceptionForLoopTo != SymbolTable_NulSym;
        break;

      case M2Range_forloopend:
        return M2Base_ExceptionForLoopEnd != SymbolTable_NulSym;
        break;

      case M2Range_pointernil:
        return M2Base_ExceptionPointerNil != SymbolTable_NulSym;
        break;

      case M2Range_noreturn:
        return M2Base_ExceptionNoReturn != SymbolTable_NulSym;
        break;

      case M2Range_noelse:
        return M2Base_ExceptionCase != SymbolTable_NulSym;
        break;

      case M2Range_casebounds:
        return false;
        break;

      case M2Range_wholenonposdiv:
        return M2Base_ExceptionNonPosDiv != SymbolTable_NulSym;
        break;

      case M2Range_wholenonposmod:
        return M2Base_ExceptionNonPosMod != SymbolTable_NulSym;
        break;

      case M2Range_wholezerodiv:
        return M2Base_ExceptionZeroDiv != SymbolTable_NulSym;
        break;

      case M2Range_wholezerorem:
        return M2Base_ExceptionZeroRem != SymbolTable_NulSym;
        break;

      case M2Range_none:
        return false;
        break;


      default:
        M2Error_InternalError ((const char *) "enumeration value unknown", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Range.def", 20, 1);
  __builtin_unreachable ();
}


/*
   FoldAssignment - attempts to fold the range violation checks.
                    It does not issue errors on type violations as that
                    is performed by FoldTypeAssign.
*/

static void FoldAssignment (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->exprtok, p->expr);
  if (p->desLowestType != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (M2Check_AssignmentTypeCompatible (tokenno, (const char *) "", 0, p->des, p->expr, false))
        {
          /* avoid dangling else.  */
          if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
                {
                  M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "attempting to assign a value {%2Wa} to a designator {%1a} which will exceed the range of type {%1tad}", 101, p->des, p->expr);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  M2Quads_SubQuad (q);
                }
            }
        }
      else
        {
          /* We do not issue an error if these types are incompatible here
               as this is done by FoldTypeAssign.  */
          M2Quads_SubQuad (q);
        }
    }
}


/*
   IsCancelled - return the cancelled flag associated with range.
*/

static bool IsCancelled (unsigned int range)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, range));
  if (p->cancelled)
    {
      return true;
    }
  if ((p->dependantid != 0) && (IsCancelled (p->dependantid)))
    {
      p->cancelled = true;
    }
  return p->cancelled;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Cancel - set the cancelled flag in range.
*/

static void Cancel (unsigned int range)
{
  M2Range_Range p;

  if (range != 0)
    {
      p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, range));
      if (! p->cancelled)
        {
          p->cancelled = true;
          Cancel (p->dependantid);
        }
    }
}


/*
   FoldParameterAssign -
*/

static void FoldParameterAssign (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if (p->desLowestType != SymbolTable_NulSym)
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
            {
              /* this is safer to treat as an error, rather than a warning
                  otherwise the paramater might be widened
                  (if it is a constant).  */
              M2MetaError_MetaErrorT3 (p->tokenNo, (const char *) "the {%3EN} actual parameter {%2a} will exceed the range of formal parameter type {%1tad}", 88, p->des, p->expr, p->dimension);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else
            {
              M2Quads_SubQuad (q);
            }
        }
    }
}


/*
   FoldReturn - do we know this is reachable, if so generate an error message.
*/

static void FoldReturn (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if (p->desLowestType != SymbolTable_NulSym)
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
            {
              M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "attempting to return {%2Wa} from a procedure function {%1a} which will exceed exceed the range of type {%1tad}", 110, p->des, p->expr);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else
            {
              M2Quads_SubQuad (q);
            }
        }
    }
}


/*
   FoldInc -
*/

static void FoldInc (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree t;
  tree min;
  tree max;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (OutOfRange (tokenno, m2expr_GetIntegerZero (location), p->expr, max, p->desLowestType))
            {
              M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "operand to INC {%2Wa} exceeds the range of type {%1ts} of the designator {%1a}", 78, p->des, p->expr);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else if (((SymbolConversion_GccKnowsAbout (p->des)) && (SymbolTable_IsConst (p->des))) && (SymbolConversion_GccKnowsAbout (p->desLowestType)))
            {
              /* avoid dangling else.  */
              t = m2expr_BuildSub (location, max, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), SymbolConversion_Mod2Gcc (p->expr), false), false);
              M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (p->des));
              M2ALU_PushIntegerTree (t);
              if (M2ALU_Gre (p->tokenNo))
                {
                  M2MetaError_MetaErrorT1 (p->tokenNo, (const char *) "the designator to INC {%1Wa} will exceed the range of type {%1ts}", 65, p->des);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  /* range check is unnecessary  */
                  M2Quads_SubQuad (q);
                }
            }
        }
    }
}


/*
   FoldDec -
*/

static void FoldDec (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree t;
  tree min;
  tree max;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (OutOfRange (tokenno, m2expr_GetIntegerZero (location), p->expr, max, p->desLowestType))
            {
              M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "operand to DEC {%2Wa} exceeds the range of type {%1ts} of the designator {%1a}", 78, p->des, p->expr);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else if (((SymbolConversion_GccKnowsAbout (p->des)) && (SymbolTable_IsConst (p->des))) && (SymbolConversion_GccKnowsAbout (p->desLowestType)))
            {
              /* avoid dangling else.  */
              t = m2expr_BuildSub (location, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), SymbolConversion_Mod2Gcc (p->expr), false), min, false);
              M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (p->des));
              M2ALU_PushIntegerTree (t);
              if (M2ALU_Less (p->tokenNo))
                {
                  M2MetaError_MetaErrorT1 (p->tokenNo, (const char *) "the designator to DEC {%1Wa} will exceed the range of type {%1ts}", 65, p->des);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  /* range check is unnecessary  */
                  M2Quads_SubQuad (q);
                }
            }
        }
    }
}


/*
   CheckSetAndBit - returns TRUE if des is a set type and expr is compatible with des.
*/

static bool CheckSetAndBit (unsigned int tokenno, unsigned int des, unsigned int expr, const char *name_, unsigned int _name_high)
{
  DynamicStrings_String s;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  if (SymbolTable_IsSet (des))
    {
      if (M2Base_IsExpressionCompatible (SymbolTable_GetType (des), SymbolTable_GetType (expr)))
        {
          return true;
        }
      else
        {
          s = DynamicStrings_ConCat (DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "operands to ", 12), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) name, _name_high))), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " {%1Etsd:{%2tsd:{%1tsd} and {%2tsd}}} are incompatible", 54)));
          M2MetaError_MetaErrorStringT2 (tokenno, s, des, expr);
          M2Error_FlushErrors ();
        }
    }
  else
    {
      s = DynamicStrings_ConCat (DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "first operand to ", 17), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) name, _name_high))), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " is not a set {%1Etasd}", 23)));
      M2MetaError_MetaErrorStringT1 (tokenno, s, des);
      M2Error_FlushErrors ();
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckSet - returns TRUE if des is a set type and expr is compatible with INTEGER.
*/

static bool CheckSet (unsigned int tokenno, unsigned int des, unsigned int expr, const char *name_, unsigned int _name_high)
{
  DynamicStrings_String s;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  if (SymbolTable_IsSet (des))
    {
      if (M2Base_IsParameterCompatible (M2Base_Integer, SymbolTable_GetType (expr)))
        {
          return true;
        }
      else
        {
          s = DynamicStrings_ConCat (DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "operands to ", 12), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) name, _name_high))), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " {%1Etsd:{%2tsd:{%1tsd} and {%2tsd}}} are incompatible", 54)));
          M2MetaError_MetaErrorStringT2 (tokenno, s, des, expr);
          M2Error_FlushErrors ();
        }
    }
  else
    {
      s = DynamicStrings_ConCat (DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "first operand to ", 17), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) name, _name_high))), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " is not a set {%1Etasd}", 23)));
      M2MetaError_MetaErrorStringT1 (tokenno, s, des);
      M2Error_FlushErrors ();
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldIncl - folds an INCL statement if the operands are constant.
*/

static void FoldIncl (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  p->desLowestType = SymbolTable_SkipType (SymbolTable_GetType (p->des));  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)
    {
      if (CheckSetAndBit (tokenno, p->desLowestType, p->expr, (const char *) "INCL", 4))
        {
          if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
                {
                  M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "operand to INCL {%2Wa} exceeds the range of type {%1tasa}", 57, p->des, p->expr);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  /* range check is unnecessary  */
                  M2Quads_SubQuad (q);
                }
            }
        }
    }
}


/*
   FoldExcl - folds an EXCL statement if the operands are constant.
*/

static void FoldExcl (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  p->desLowestType = SymbolTable_SkipType (SymbolTable_GetType (p->des));  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)
    {
      if (CheckSetAndBit (tokenno, p->desLowestType, p->expr, (const char *) "EXCL", 4))
        {
          if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
                {
                  M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "operand to EXCL {%2Wa} exceeds the range of type {%1tasa}", 57, p->des, p->expr);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  /* range check is unnecessary  */
                  M2Quads_SubQuad (q);
                }
            }
        }
    }
}


/*
   FoldShift - folds an SHIFT test statement if the operands are constant.
*/

static void FoldShift (unsigned int tokenno, unsigned int q, unsigned int r)
{
  unsigned int ofType;
  M2Range_Range p;
  tree shiftMin;
  tree shiftMax;
  tree min;
  tree max;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  p->desLowestType = SymbolTable_SkipType (SymbolTable_GetType (p->des));  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)
    {
      if (CheckSet (tokenno, p->desLowestType, p->expr, (const char *) "SHIFT", 5))
        {
          ofType = SymbolTable_SkipType (SymbolTable_GetType (p->desLowestType));
          if ((((SymbolConversion_GccKnowsAbout (ofType)) && (SymbolConversion_GccKnowsAbout (p->expr))) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, ofType, &min, &max)))
            {
              min = m2convert_BuildConvert (location, m2type_GetIntegerType (), min, false);
              max = m2convert_BuildConvert (location, m2type_GetIntegerType (), max, false);
              shiftMax = m2expr_BuildAdd (location, m2expr_BuildSub (location, max, min, false), m2expr_GetIntegerOne (location), false);
              shiftMin = m2expr_BuildNegate (location, shiftMax, false);
              if (OutOfRange (tokenno, shiftMin, p->expr, shiftMax, p->desLowestType))
                {
                  M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "operand to SHIFT {%2Wa} exceeds the range of type {%1tasa}", 58, p->des, p->expr);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  /* range check is unnecessary  */
                  M2Quads_SubQuad (q);
                }
            }
        }
    }
}


/*
   FoldRotate - folds a ROTATE test statement if the operands are constant.
*/

static void FoldRotate (unsigned int tokenno, unsigned int q, unsigned int r)
{
  unsigned int ofType;
  M2Range_Range p;
  tree rotateMin;
  tree rotateMax;
  tree min;
  tree max;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  p->desLowestType = SymbolTable_SkipType (SymbolTable_GetType (p->des));  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)
    {
      if (CheckSet (tokenno, p->desLowestType, p->expr, (const char *) "ROTATE", 6))
        {
          ofType = SymbolTable_SkipType (SymbolTable_GetType (p->desLowestType));
          if ((((SymbolConversion_GccKnowsAbout (ofType)) && (SymbolConversion_GccKnowsAbout (p->expr))) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, ofType, &min, &max)))
            {
              min = m2convert_BuildConvert (location, m2type_GetIntegerType (), min, false);
              max = m2convert_BuildConvert (location, m2type_GetIntegerType (), max, false);
              rotateMax = m2expr_BuildAdd (location, m2expr_BuildSub (location, max, min, false), m2expr_GetIntegerOne (location), false);
              rotateMin = m2expr_BuildNegate (location, rotateMax, false);
              if (OutOfRange (tokenno, rotateMin, p->expr, rotateMax, p->desLowestType))
                {
                  M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "operand to ROTATE {%2Wa} exceeds the range of type {%1tasa}", 59, p->des, p->expr);
                  M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
                }
              else
                {
                  /* range check is unnecessary  */
                  M2Quads_SubQuad (q);
                }
            }
        }
    }
}


/*
   FoldTypeReturnFunc - checks to see that val can be returned from func.
*/

static void FoldTypeReturnFunc (unsigned int q, unsigned int tokenNo, unsigned int func, unsigned int val, unsigned int r)
{
  unsigned int valType;
  unsigned int returnType;

  returnType = SymbolTable_GetType (func);
  if (returnType == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      if (! (reportedError (r)))
        {
          M2MetaError_MetaErrorsT2 (tokenNo, (const char *) "procedure {%1Da} is not a procedure function", 44, (const char *) "{%2ad} cannot be returned from {%1Da}", 37, func, val);
          M2Quads_SubQuad (q);
        }
    }
  else
    {
      valType = val;
      if ((SymbolTable_IsVar (val)) && ((SymbolTable_GetMode (val)) == SymbolTable_LeftValue))
        {
          valType = SymbolTable_GetType (val);
        }
      if (M2Check_AssignmentTypeCompatible (tokenNo, (const char *) "", 0, returnType, valType, false))
        {
          M2Quads_SubQuad (q);
        }
      else
        {
          if (! (reportedError (r)))
            {
              M2MetaError_MetaErrorsT2 (tokenNo, (const char *) "the return type {%1Etad} used in procedure {%1Da}", 49, (const char *) "is incompatible with the returned expression {%1ad}}", 52, func, val);
              setReported (r);
              M2Error_FlushErrors ();
            }
        }
    }
}


/*
   FoldTypeAssign -
*/

static void FoldTypeAssign (unsigned int q, unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r)
{
  if (! (reportedError (r)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (M2Check_AssignmentTypeCompatible (tokenNo, (const char *) "assignment designator {%1Ea} {%1ta:of type {%1ta}}'' cannot be assigned with'' {%2ad: a {%2td} {%2ad}}{!%2ad: {%2ad} of type {%2tad}}", 133, des, expr, true))
        {
          M2Quads_SubQuad (q);
        }
      else
        {
          setReported (r);
          M2Error_FlushErrors ();
        }
    }
}


/*
   FoldTypeIndrX - check to see that des = *expr is type compatible.
*/

static void FoldTypeIndrX (unsigned int q, unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r)
{
  unsigned int desType;
  unsigned int exprType;

  /* Need to skip over a variable or temporary in des and expr so
      long as expr is not a procedure.  In the case of des = *expr,
      both expr and des will be variables due to the property of
      indirection.  */
  desType = SymbolTable_GetType (des);
  if (SymbolTable_IsProcedure (expr))
    {
      /* Must not GetType for a procedure as it gives the return type.  */
      exprType = expr;
    }
  else
    {
      exprType = SymbolTable_GetType (expr);
    }
  if (M2Check_AssignmentTypeCompatible (tokenNo, (const char *) "", 0, SymbolTable_GetType (des), SymbolTable_GetType (expr), false))
    {
      M2Quads_SubQuad (q);
    }
  else
    {
      if (! (reportedError (r)))
        {
          if (SymbolTable_IsProcedure (des))
            {
              M2MetaError_MetaErrorsT2 (tokenNo, (const char *) "the return type {%1Etad} declared in procedure {%1Da}", 53, (const char *) "is incompatible with the returned expression {%2ad}}", 52, des, expr);
            }
          else
            {
              M2MetaError_MetaErrorT3 (tokenNo, (const char *) "assignment designator {%1Ea} {%1ta:of type {%1ta}}'' {%1d:is a {%1d}} and expression {%2a} {%3ad:of type'' {%3ad}} are incompatible", 131, des, expr, exprType);
            }
          setReported (r);
          M2Error_FlushErrors ();
        }
    }
}


/*
   FoldTypeParam - performs a parameter check between actual and formal.
                   The quad is removed if the check succeeds.
*/

static void FoldTypeParam (unsigned int q, unsigned int tokenNo, unsigned int formal, unsigned int actual, unsigned int procedure, unsigned int paramNo, unsigned int depRangeId)
{
  bool compatible;

  compatible = false;
  if (SymbolTable_IsVarParamAny (procedure, paramNo))
    {
      /* Expression type compatibility rules for pass by reference parameters.  */
      compatible = M2Check_ParameterTypeCompatible (tokenNo, (const char *) "{%4EN} parameter failure due to expression incompatibility between actual parameter {%3ad} and the {%4N} formal {%2ad} parameter in procedure {%1ad}", 148, procedure, formal, actual, paramNo, true);
    }
  else if (M2Options_GetPIM ())
    {
      /* avoid dangling else.  */
      /* Assignment type compatibility rules for pass by value PIM parameters.  */
      compatible = M2Check_ParameterTypeCompatible (tokenNo, (const char *) "{%4EN} parameter failure due to assignment incompatibility between actual parameter {%3ad} and the {%4N} formal {%2ad} parameter in procedure {%1ad}", 148, procedure, formal, actual, paramNo, false);
    }
  else
    {
      /* avoid dangling else.  */
      compatible = M2Check_ParameterTypeCompatible (tokenNo, (const char *) "{%4EN} parameter failure due to parameter incompatibility between actual parameter {%3ad} and the {%4N} formal {%2ad} parameter in procedure {%1ad}", 147, procedure, formal, actual, paramNo, false);
    }
  if (compatible)
    {
      M2Quads_SubQuad (q);
    }
  else
    {
      Cancel (depRangeId);
    }
}


/*
   FoldTypeExpr -
*/

static void FoldTypeExpr (unsigned int q, unsigned int tokenNo, unsigned int left, unsigned int right, bool strict, bool isin, unsigned int r)
{
  if (((left != SymbolTable_NulSym) && (right != SymbolTable_NulSym)) && (! (reportedError (r))))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (M2Check_ExpressionTypeCompatible (tokenNo, (const char *) "expression of type {%1Etad} is incompatible with type {%2tad}", 61, left, right, strict, isin))
        {
          M2Quads_SubQuad (q);
        }
      else
        {
          setReported (r);
        }
    }
}


/*
   CodeTypeAssign -
*/

static void CodeTypeAssign (unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r)
{
  if (! (M2Check_AssignmentTypeCompatible (tokenNo, (const char *) "", 0, des, expr, false)))
    {
      if (! (reportedError (r)))
        {
          M2MetaError_MetaErrorT2 (tokenNo, (const char *) "assignment designator {%1Ea} {%1ta:of type {%1ta}} {%1d:is a {%1d}} and expression {%2a} {%2tad:of type {%2tad}} are incompatible", 129, des, expr);
        }
      setReported (r);
    }
}


/*
   CodeTypeReturnFunc -
*/

static void CodeTypeReturnFunc (unsigned int tokenNo, unsigned int func, unsigned int val, unsigned int r)
{
  unsigned int valType;
  unsigned int returnType;

  returnType = SymbolTable_GetType (func);
  if (returnType == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      if (! (reportedError (r)))
        {
          M2MetaError_MetaErrorsT2 (tokenNo, (const char *) "procedure {%1Da} is not a procedure function", 44, (const char *) "{%2ad} cannot be returned from {%1Da}", 37, func, val);
        }
    }
  else
    {
      valType = val;
      if ((SymbolTable_IsVar (val)) && ((SymbolTable_GetMode (val)) == SymbolTable_LeftValue))
        {
          valType = SymbolTable_GetType (val);
        }
      if (! (M2Check_AssignmentTypeCompatible (tokenNo, (const char *) "", 0, returnType, valType, false)))
        {
          if (! (reportedError (r)))
            {
              M2MetaError_MetaErrorsT2 (tokenNo, (const char *) "the return type {%1Etad} used in procedure function {%1Da}", 58, (const char *) "is incompatible with the returned expression {%2EUa} {%2tad:of type {%2tad}}", 76, func, val);
            }
        }
    }
}


/*
   CodeTypeIndrX - checks that des = *expr is type compatible and generates an error if they
                   are not compatible.  It skips over the LValue type so that to allow
                   the error messages to pick up the source variable name rather than
                   a temporary name or vague name 'expression'.
*/

static void CodeTypeIndrX (unsigned int tokenNo, unsigned int des, unsigned int expr, unsigned int r)
{
  if (! (M2Check_AssignmentTypeCompatible (tokenNo, (const char *) "", 0, SymbolTable_GetType (des), SymbolTable_GetType (expr), false)))
    {
      if (! (reportedError (r)))
        {
          if (SymbolTable_IsProcedure (des))
            {
              M2MetaError_MetaErrorsT2 (tokenNo, (const char *) "the return type {%1Etad} declared in procedure {%1Da}", 53, (const char *) "is incompatible with the returned expression {%2EUa} {%2tad:of type {%2tad}}", 76, des, expr);
            }
          else
            {
              M2MetaError_MetaErrorT2 (tokenNo, (const char *) "assignment designator {%1Ea} {%1ta:of type {%1ta}}'' {%1d:is a {%1d}} and expression {%2a}'' {%2tad:of type {%2tad}} are incompatible", 133, des, expr);
            }
          setReported (r);
        }
      /* FlushErrors  */
    }
}


/*
   CodeTypeParam -
*/

static void CodeTypeParam (unsigned int tokenNo, unsigned int formal, unsigned int actual, unsigned int procedure, unsigned int paramNo)
{
  if (! (M2Check_ParameterTypeCompatible (tokenNo, (const char *) "{%4EN} type failure between actual {%3ad} and the formal {%2ad}", 63, procedure, formal, actual, paramNo, SymbolTable_IsVarParamAny (procedure, paramNo))))
    {}  /* empty.  */
}


/*
   CodeTypeExpr -
*/

static void CodeTypeExpr (unsigned int tokenNo, unsigned int left, unsigned int right, bool strict, bool isin, unsigned int r)
{
  if (! (reportedError (r)))
    {
      if (M2Check_ExpressionTypeCompatible (tokenNo, (const char *) "expression of type {%1Etad} is incompatible with type {%2tad}", 61, left, right, strict, isin))
        {
          setReported (r);
        }
    }
}


/*
   FoldTypeCheck - folds a type check.  This is a no-op and it used
                   for checking types which are resolved post pass 3.
*/

static void FoldTypeCheck (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  /* TryDeclareConstructor(q, expr) ;  */
  if (((SymbolConversion_GccKnowsAbout (p->des)) || ((SymbolTable_IsParameter (p->des)) && (SymbolConversion_GccKnowsAbout (SymbolTable_GetType (p->des))))) && (SymbolConversion_GccKnowsAbout (p->expr)))
    {
      switch (p->type)
        {
          case M2Range_typeassign:
            FoldTypeAssign (q, p->tokenNo, p->des, p->expr, r);
            break;

          case M2Range_typeparam:
            FoldTypeParam (q, p->tokenNo, p->des, p->expr, p->procedure, p->paramNo, r);
            break;

          case M2Range_typeexpr:
            FoldTypeExpr (q, p->tokenNo, p->des, p->expr, p->strict, p->isin, r);
            break;

          case M2Range_typeindrx:
            FoldTypeIndrX (q, p->tokenNo, p->des, p->expr, r);
            break;

          case M2Range_typereturn:
            FoldTypeReturnFunc (q, p->tokenNo, p->des, p->expr, r);
            break;


          default:
            M2Error_InternalError ((const char *) "not expecting to reach this point", 33);
            break;
        }
    }
}


/*
   CodeTypeCheck - folds a type check.  This is a no-op and it used
                   for checking types which are resolved post pass 3.
                   It does assume that both, des, and, expr, have been
                   resolved at this point.
*/

static void CodeTypeCheck (unsigned int tokenno, unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  /* TryDeclareConstructor(0, expr) ;  */
  if (((SymbolConversion_GccKnowsAbout (p->des)) || ((SymbolTable_IsParameter (p->des)) && (SymbolConversion_GccKnowsAbout (SymbolTable_GetType (p->des))))) && (SymbolConversion_GccKnowsAbout (p->expr)))
    {
      switch (p->type)
        {
          case M2Range_typeassign:
            CodeTypeAssign (p->tokenNo, p->des, p->expr, r);
            break;

          case M2Range_typeparam:
            CodeTypeParam (p->tokenNo, p->des, p->expr, p->procedure, p->paramNo);
            break;

          case M2Range_typeexpr:
            CodeTypeExpr (p->tokenNo, p->des, p->expr, p->strict, p->isin, r);
            break;

          case M2Range_typeindrx:
            CodeTypeIndrX (p->tokenNo, p->des, p->expr, r);
            break;

          case M2Range_typereturn:
            CodeTypeReturnFunc (p->tokenNo, p->des, p->expr, r);
            break;


          default:
            M2Error_InternalError ((const char *) "not expecting to reach this point", 33);
            break;
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting des and expr to be resolved", 37);
    }
}


/*
   ForLoopBeginTypeCompatible - check for designator assignment compatibility with
                                expr1 and designator expression compatibility with expr2.
                                FOR des := expr1 TO expr2 BY byconst DO
                                END
                                It generates composite tokens if the tokens are on
                                the same source line.
*/

static bool ForLoopBeginTypeCompatible (M2Range_Range p)
{
  unsigned int combinedtok;
  bool success;

  success = true;
  combinedtok = M2LexBuf_MakeVirtual2Tok (p->destok, p->exprtok);
  if (! (M2Check_AssignmentTypeCompatible (combinedtok, (const char *) "", 0, p->des, p->expr, true)))
    {
      M2MetaError_MetaErrorT2 (combinedtok, (const char *) "type incompatibility between {%1Et} and {%2t} detected during the assignment of the designator {%1a} to the first expression {%2a} in the {%kFOR} loop", 150, p->des, p->expr);
      success = false;
    }
  combinedtok = M2LexBuf_MakeVirtual2Tok (p->destok, p->expr2tok);
  if (! (M2Check_ExpressionTypeCompatible (combinedtok, (const char *) "", 0, p->des, p->expr2, true, false)))
    {
      M2MetaError_MetaErrorT2 (combinedtok, (const char *) "type expression incompatibility between {%1Et} and {%2t} detected when comparing the designator {%1a} against the second expression {%2a} in the {%kFOR} loop", 157, p->des, p->expr2);
      success = false;
    }
  combinedtok = M2LexBuf_MakeVirtual2Tok (p->destok, p->byconsttok);
  if (! (M2Check_ExpressionTypeCompatible (combinedtok, (const char *) "", 0, p->des, p->byconst, true, false)))
    {
      M2MetaError_MetaErrorT2 (combinedtok, (const char *) "type expression incompatibility between {%1Et} and {%2t} detected between the designator {%1a} and the {%kBY} constant expression {%2a} in the {%kFOR} loop", 155, p->des, p->byconst);
      success = false;
    }
  if (! success && (p->incrementquad != 0))
    {
      /* Avoid a subsequent generic type check error.  */
      M2Quads_SubQuad (p->incrementquad);
    }
  return success;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldForLoopBegin -
*/

static void FoldForLoopBegin (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (! (ForLoopBeginTypeCompatible (p)))
            {
              M2Quads_SubQuad (q);
            }
          else if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
            {
              /* avoid dangling else.  */
              M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "attempting to assign a value {%2Wa} to a FOR loop designator {%1a} which will exceed the range of type {%1tad}", 110, p->des, p->expr);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else
            {
              /* avoid dangling else.  */
              M2Quads_SubQuad (q);
            }
        }
    }
}


/*
   FoldForLoopTo -
*/

static void FoldForLoopTo (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
            {
              M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "final value in FOR loop will exceed type range {%1Wtasa} of designator {%2a}", 76, p->des, p->expr);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else
            {
              M2Quads_SubQuad (q);
            }
        }
    }
}


/*
   FoldStaticArraySubscript -
*/

static void FoldStaticArraySubscript (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  tree min;
  tree max;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      if (((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr))) && (M2Range_GetMinMax (tokenno, p->desLowestType, &min, &max)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (OutOfRange (tokenno, min, p->expr, max, p->desLowestType))
            {
              M2MetaError_MetaErrorT3 (p->tokenNo, (const char *) "index {%2Wa} out of range found while attempting to access an element of a static array {%1a} in the {%3N} array subscript", 122, p->des, p->expr, p->dimension);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          else
            {
              /* range check is unnecessary  */
              M2Quads_SubQuad (q);
            }
        }
    }
}


/*
   FoldDynamicArraySubscript -
*/

static void FoldDynamicArraySubscript (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (M2Range_IsGreater (m2expr_GetIntegerZero (location), m2convert_BuildConvert (location, m2type_GetIntegerType (), SymbolConversion_Mod2Gcc (p->expr), false)))
            {
              M2MetaError_MetaErrorT3 (p->tokenNo, (const char *) "index {%2Wa} out of range found while attempting to access an element of a dynamic array {%1a} in the {%3N} array subscript", 123, p->des, p->expr, p->dimension);
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
            }
          /* cannot fold high bounds, so leave that for the runtime  */
        }
    }
}


/*
   FoldCaseBounds -
*/

static void FoldCaseBounds (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  bool errorGenerated;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  if (M2CaseList_CaseBoundsResolved (tokenno, p->caseList))
    {
      errorGenerated = false;
      if (M2CaseList_TypeCaseBounds (p->caseList))
        {}  /* empty.  */
      /* nothing to do  */
      if (M2CaseList_OverlappingCaseBounds (p->caseList))
        {
          M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
          errorGenerated = true;
        }
      if (M2Options_VariantValueChecking && (M2CaseList_MissingCaseBounds (tokenno, p->caseList)))
        {
          if (! errorGenerated)
            {
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
              errorGenerated = true;
            }
        }
      if (M2Options_CaseEnumChecking && (M2CaseList_MissingCaseStatementBounds (tokenno, p->caseList)))
        {
          if (! errorGenerated)
            {
              M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
              errorGenerated = true;
            }
        }
      if (! errorGenerated)
        {
          M2Quads_SubQuad (q);
        }
    }
}


/*
   CodeCaseBounds - attempts to resolve whether the case bounds are legal.
                    This should resolve at compile time as all case bounds
                    must be constants.  We introduce a CodeCaseBounds as it
                    might be possible that constants have just been declared
                    during the code generation of this function.
*/

static void CodeCaseBounds (unsigned int tokenno, unsigned int caseList)
{
  if (M2CaseList_CaseBoundsResolved (tokenno, caseList))
    {
      /* avoid dangling else.  */
      if (M2CaseList_TypeCaseBounds (caseList))
        {}  /* empty.  */
      /* nothing to do  */
      if (M2CaseList_OverlappingCaseBounds (caseList))
        {}  /* empty.  */
      /* nothing to do  */
      if (M2CaseList_MissingCaseBounds (tokenno, caseList))
        {}  /* empty.  */
      /* nothing to do  */
      if (M2Options_CaseEnumChecking && (M2CaseList_MissingCaseStatementBounds (tokenno, caseList)))
        {}  /* empty.  */
      /* nothing to do  */
    }
  else
    {
      M2MetaError_MetaErrorT0 (tokenno, (const char *) "{%E}the CASE statement ranges must be constants", 47);
    }
}


/*
   MakeAndDeclareConstLit - creates a constant of value and declares it to GCC.
*/

static unsigned int MakeAndDeclareConstLit (unsigned int tokenno, NameKey_Name value, unsigned int type)
{
  unsigned int constant;

  constant = SymbolTable_MakeConstLit (tokenno, value, type);
  M2GCCDeclare_TryDeclareConstant (tokenno, constant);  /* use quad tokenno, rather than the range tokenNo  */
  M2Debug_Assert (SymbolConversion_GccKnowsAbout (constant));  /* use quad tokenno, rather than the range tokenNo  */
  return constant;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FoldNonPosDiv - attempts to fold the bound checking for a divide expression.
*/

static void FoldNonPosDiv (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  unsigned int zero;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr)))  /* use quad tokenno, rather than the range tokenNo  */
    {
      zero = MakeAndDeclareConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
      if (IsGreaterOrEqualConversion (M2LexBuf_TokenToLocation (tokenno), zero, p->des, p->expr))
        {
          M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "the divisor {%2Wa} in this division expression is less than or equal to zero, this will cause an exception to be raised before the result is assigned to the designator {%1a}", 173, p->des, p->expr);
          M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
        }
    }
}


/*
   FoldNonPosMod - attempts to fold the bound checking for a modulus expression.
*/

static void FoldNonPosMod (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  unsigned int zero;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr)))  /* use quad tokenno, rather than the range tokenNo  */
    {
      zero = MakeAndDeclareConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
      if (IsGreaterOrEqualConversion (M2LexBuf_TokenToLocation (tokenno), zero, p->des, p->expr))
        {
          M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "the divisor {%2Wa} in this modulus expression is less than or equal to zero, this will cause an exception to be raised before the result is assigned to the designator {%1a}", 172, p->des, p->expr);
          M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
        }
    }
}


/*
   FoldZeroDiv -
*/

static void FoldZeroDiv (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  unsigned int zero;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr)))  /* use quad tokenno, rather than the range tokenNo  */
    {
      zero = MakeAndDeclareConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
      if (IsEqualConversion (zero, p->des, p->expr))
        {
          M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "the divisor {%2Wa} in this division expression is equal to zero, this will cause an exception to be raised before the result is assigned to the designator {%1a}", 160, p->des, p->expr);
          M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
        }
    }
}


/*
   FoldZeroRem -
*/

static void FoldZeroRem (unsigned int tokenno, unsigned int q, unsigned int r)
{
  M2Range_Range p;
  unsigned int zero;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolTable_IsConst (p->expr)))  /* use quad tokenno, rather than the range tokenNo  */
    {
      zero = MakeAndDeclareConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
      if (IsEqualConversion (zero, p->des, p->expr))
        {
          M2MetaError_MetaErrorT2 (p->tokenNo, (const char *) "the divisor {%2Wa} in this remainder expression is equal to zero, this will cause an exception to be raised before the result is assigned to the designator {%1a}", 161, p->des, p->expr);
          M2Quads_PutQuad (q, M2Quads_ErrorOp, SymbolTable_NulSym, SymbolTable_NulSym, r);
        }
    }
}


/*
   FoldRangeCheckLower - call the appropriate Fold procedure depending upon the type
                         of range.
*/

static void FoldRangeCheckLower (unsigned int tokenno, unsigned int quad, unsigned int range)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, range));
  switch (p->type)
    {
      case M2Range_assignment:
        FoldAssignment (tokenno, quad, range);
        break;

      case M2Range_returnassignment:
        FoldReturn (tokenno, quad, range);
        break;

      case M2Range_inc:
        /* subrangeassignment   :  |  unused currently  */
        FoldInc (tokenno, quad, range);
        break;

      case M2Range_dec:
        FoldDec (tokenno, quad, range);
        break;

      case M2Range_incl:
        FoldIncl (tokenno, quad, range);
        break;

      case M2Range_excl:
        FoldExcl (tokenno, quad, range);
        break;

      case M2Range_shift:
        FoldShift (tokenno, quad, range);
        break;

      case M2Range_rotate:
        FoldRotate (tokenno, quad, range);
        break;

      case M2Range_typereturn:
      case M2Range_typeassign:
      case M2Range_typeparam:
      case M2Range_typeexpr:
      case M2Range_typeindrx:
        FoldTypeCheck (tokenno, quad, range);
        break;

      case M2Range_paramassign:
        FoldParameterAssign (tokenno, quad, range);
        break;

      case M2Range_staticarraysubscript:
        FoldStaticArraySubscript (tokenno, quad, range);
        break;

      case M2Range_dynamicarraysubscript:
        FoldDynamicArraySubscript (tokenno, quad, range);
        break;

      case M2Range_forloopbegin:
        FoldForLoopBegin (tokenno, quad, range);
        break;

      case M2Range_forloopto:
        FoldForLoopTo (tokenno, quad, range);
        break;

      case M2Range_forloopend:
        return;  /* unable to fold anything at this point, des, will be variable  */
        break;

      case M2Range_pointernil:
        FoldNil (tokenno, quad, range);
        break;

      case M2Range_noreturn:
        return;  /* nothing to fold  */
        break;

      case M2Range_noelse:
        return;  /* nothing to fold  */
        break;

      case M2Range_casebounds:
        FoldCaseBounds (tokenno, quad, range);
        break;

      case M2Range_wholenonposdiv:
        FoldNonPosDiv (tokenno, quad, range);
        break;

      case M2Range_wholenonposmod:
        FoldNonPosMod (tokenno, quad, range);
        break;

      case M2Range_wholezerodiv:
        FoldZeroDiv (tokenno, quad, range);
        break;

      case M2Range_wholezerorem:
        FoldZeroRem (tokenno, quad, range);
        break;

      case M2Range_none:
        M2Quads_SubQuad (quad);
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;
    }
}


/*
   DeReferenceLValue - returns a Tree which is either ModGcc(expr)
                       or Mod2Gcc ( *expr) depending whether, expr,
                       is an LValue.
*/

static tree DeReferenceLValue (unsigned int tokenno, unsigned int expr)
{
  tree e;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  e = SymbolConversion_Mod2Gcc (expr);
  if ((SymbolTable_GetMode (expr)) == SymbolTable_LeftValue)
    {
      e = m2expr_BuildIndirect (location, e, SymbolConversion_Mod2Gcc (SymbolTable_GetType (expr)));
    }
  return e;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildStringParam - builds a C style string parameter which will be passed
                      as an ADDRESS type.
*/

static void BuildStringParam (unsigned int tokenno, DynamicStrings_String s)
{
  BuildStringParamLoc (M2LexBuf_TokenToLocation (tokenno), s);
}


/*
   BuildStringParamLoc - builds a C style string parameter which will be passed
                         as an ADDRESS type.
*/

static void BuildStringParamLoc (location_t location, DynamicStrings_String s)
{
  m2statement_BuildParam (location, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (M2System_Address), m2expr_BuildAddr (location, m2decl_BuildStringConstant (const_cast <const char * > (static_cast <char * > (DynamicStrings_string (s))), static_cast<int> (DynamicStrings_Length (s))), false), false));
}


/*
   IssueWarning - issue a warning.  The compiler knows that this basic block can be reached
                  and we are in scope, function.
*/

static void IssueWarning (DynamicStrings_String function, unsigned int r)
{
  M2Range_Range p;
  DynamicStrings_String s;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  switch (p->type)
    {
      case M2Range_assignment:
        s = DynamicStrings_InitString ((const char *) "if the assignment is ever executed then the designator {%1Wa} will exceed the type range {%1ts:of {%1ts}}", 105);
        break;

      case M2Range_returnassignment:
        s = DynamicStrings_InitString ((const char *) "if the value {%2Wa} is returned from procedure function {%1Wa} then it will exceed the type range {%1ts:of {%1ts}}", 114);
        break;

      case M2Range_subrangeassignment:
        M2Error_InternalError ((const char *) "not expecting this case value", 29);
        break;

      case M2Range_inc:
        s = DynamicStrings_InitString ((const char *) "if the INC is ever executed the expression {%2Wa} will cause an overflow error for the designator {%1a} as it exceeds the type range {%1ts:of {%1ts}}", 149);
        break;

      case M2Range_dec:
        s = DynamicStrings_InitString ((const char *) "if the DEC is ever executed the expression {%2Wa} will cause an underflow error for the designator {%1a} as it exceeds the type range {%1ts:of {%1ts}}", 150);
        break;

      case M2Range_incl:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the INCL exceeds the type range {%1ts} of the designator {%1a}", 93);
        break;

      case M2Range_excl:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the EXCL exceeds the type range {%1ts} of the designator {%1a}", 93);
        break;

      case M2Range_shift:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the second parameter to SHIFT exceeds the type range {%1ts} of the first parameter {%1a}", 119);
        break;

      case M2Range_rotate:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the second parameter to ROTATE exceeds the type range {%1ts} of the first parameter {%1a}", 120);
        break;

      case M2Range_typeassign:
        s = DynamicStrings_InitString ((const char *) "", 0);
        break;

      case M2Range_typeparam:
        s = DynamicStrings_InitString ((const char *) "", 0);
        break;

      case M2Range_typeexpr:
        s = DynamicStrings_InitString ((const char *) "", 0);
        break;

      case M2Range_paramassign:
        s = DynamicStrings_InitString ((const char *) "if this call is executed then the actual parameter {%2Wa} will be out of range of the {%3N} formal parameter {%1a}", 114);
        break;

      case M2Range_staticarraysubscript:
        s = DynamicStrings_InitString ((const char *) "if this access to the static array {%1Wa:{%2a:{%1a}[{%2a}]}} is ever made then the index will be out of bounds in the {%3N} array subscript", 139);
        break;

      case M2Range_dynamicarraysubscript:
        s = DynamicStrings_InitString ((const char *) "if this access to the dynamic array {%1Wa:{%2a:{%1a}[{%2a}]}} is ever made then the index will be out of bounds in the {%3N} array subscript", 140);
        break;

      case M2Range_forloopbegin:
        s = DynamicStrings_InitString ((const char *) "if the assignment in this FOR loop is ever executed then the designator {%1Wa} will be exceed the type range {%1ts:of {%1ts}}", 125);
        break;

      case M2Range_forloopto:
        s = DynamicStrings_InitString ((const char *) "the final value {%2Wa} in this FOR loop will be out of bounds {%1ts:of type {%1ts}} if ever executed", 100);
        break;

      case M2Range_forloopend:
        s = DynamicStrings_InitString ((const char *) "the FOR loop will cause the designator {%1Wa} to be out of bounds when the BY value {%2a} is added", 98);
        break;

      case M2Range_pointernil:
        s = DynamicStrings_InitString ((const char *) "if this pointer value {%1Wa} is ever dereferenced it will cause an exception", 76);
        break;

      case M2Range_noreturn:
        s = DynamicStrings_InitString ((const char *) "{%1W:}this function will exit without executing a RETURN statement", 66);
        break;

      case M2Range_noelse:
        s = DynamicStrings_InitString ((const char *) "{%1W:}this CASE statement does not have an ELSE statement", 57);
        break;

      case M2Range_casebounds:
        s = DynamicStrings_InitString ((const char *) "{%1W:}this CASE statement has overlapping ranges", 48);
        break;

      case M2Range_wholenonposdiv:
        s = DynamicStrings_InitString ((const char *) "this division expression {%2Wa} will cause an exception as this divisor is less than or equal to zero", 101);
        break;

      case M2Range_wholenonposmod:
        s = DynamicStrings_InitString ((const char *) "this modulus expression {%2Wa} will cause an exception as this divisor is less than or equal to zero", 100);
        break;

      case M2Range_wholezerodiv:
        s = DynamicStrings_InitString ((const char *) "this division expression {%2Wa} will cause an exception as the divisor is zero", 78);
        break;

      case M2Range_wholezerorem:
        s = DynamicStrings_InitString ((const char *) "this remainder expression {%2Wa} will cause an exception as the divisor is zero", 79);
        break;

      case M2Range_none:
        M2Error_InternalError ((const char *) "unexpected value", 16);
        break;


      default:
        M2Error_InternalError ((const char *) "enumeration value unknown", 25);
        break;
    }
  s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " in (", 5)));
  s = DynamicStrings_ConCat (s, function);
  s = DynamicStrings_ConCatChar (s, ')');
  M2MetaError_MetaErrorStringT3 (p->tokenNo, s, p->des, p->expr, p->dimension);
}


/*
   CodeErrorCheckLoc - generate a runtime error message positioned at location
                       and in function.  If function is NIL then the error scope
                       is used.
*/

static tree CodeErrorCheckLoc (location_t location, const char * function, const char * message, unsigned int func)
{
  DynamicStrings_String scope;
  DynamicStrings_String errorMessage;
  tree t;
  DynamicStrings_String filename;
  unsigned int line;
  unsigned int column;

  if (func == SymbolTable_NulSym)
    {
      return NULL;
    }
  else
    {
      t = SymbolConversion_Mod2Gcc (func);
      if (t != NULL)
        {
          filename = DynamicStrings_InitStringCharStar (m2linemap_GetFilenameFromLocation (location));
          M2Debug_Assert (message != NULL);
          errorMessage = DynamicStrings_InitStringCharStar (static_cast <void *> (const_cast <char * > (message)));
          column = m2linemap_GetColumnNoFromLocation (location);
          line = m2linemap_GetLineNoFromLocation (location);
          BuildStringParamLoc (location, errorMessage);
          if (function == NULL)
            {
              scope = M2Error_GetAnnounceScope (filename, static_cast<DynamicStrings_String> (NULL));
            }
          else
            {
              scope = M2ColorString_quoteOpen (DynamicStrings_InitString ((const char *) "", 0));
              scope = DynamicStrings_ConCat (scope, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (static_cast <void *> (const_cast <char * > (function)))));
              scope = DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "procedure ", 10), M2ColorString_quoteClose (scope));
            }
          BuildStringParamLoc (location, scope);
          m2statement_BuildParam (location, m2decl_BuildIntegerConstant (static_cast<int> (column)));
          m2statement_BuildParam (location, m2decl_BuildIntegerConstant (static_cast<int> (line)));
          BuildStringParamLoc (location, filename);
          t = m2statement_BuildProcedureCallTree (location, t, NULL);
        }
      /* 
         filename := KillString (filename) ;
         scope := KillString (scope) ;
         errorMessage := KillString (errorMessage)
  */
      return t;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IssueWarningLoc -
*/

static void IssueWarningLoc (location_t location, const char * message)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitString ((const char *) "numerical overflow detected when performing ", 44);
  s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (static_cast <void *> (const_cast <char * > (message)))));
  m2linemap_ErrorAt (location, DynamicStrings_string (s));
  s = DynamicStrings_KillString (s);
}


/*
   BuildIfCallHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

static tree BuildIfCallHandlerLoc (location_t location, tree condition, const char * scope, const char * message, unsigned int func)
{
  if (m2expr_IsTrue (condition))
    {
      IssueWarningLoc (location, message);
    }
  return m2statement_BuildIfThenDoEnd (condition, CodeErrorCheckLoc (location, scope, message, func));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildIfCallHandler -
*/

static tree BuildIfCallHandler (tree condition, unsigned int r, DynamicStrings_String function, DynamicStrings_String message, bool warning)
{
  if (warning && (m2expr_IsTrue (condition)))
    {
      IssueWarning (function, r);
    }
  return m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RangeCheckReal -
*/

static void RangeCheckReal (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  tree e;
  tree condition;
  location_t location;

  location = M2LexBuf_TokenToLocation (p->tokenNo);
  e = DeReferenceLValue (p->tokenNo, p->expr);
  condition = m2expr_BuildEqualTo (location, m2builtins_BuiltInIsfinite (location, e), m2expr_GetIntegerZero (location));
  m2type_AddStatement (location, BuildIfCallHandler (condition, r, function, message, true));
}


/*
   RangeCheckOrdinal -
*/

static void RangeCheckOrdinal (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  tree condition;
  tree desMin;
  tree desMax;
  tree exprMin;
  tree exprMax;
  location_t location;

  location = M2LexBuf_TokenToLocation (p->tokenNo);
  if ((M2Range_GetMinMax (p->tokenNo, p->exprLowestType, &exprMin, &exprMax)) && (M2Range_GetMinMax (p->tokenNo, p->desLowestType, &desMin, &desMax)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (M2Range_OverlapsRange (desMin, desMax, exprMin, exprMax))
        {
          /* avoid dangling else.  */
          if (M2Range_IsGreater (desMin, exprMin))
            {
              condition = m2expr_BuildLessThan (location, DeReferenceLValue (p->tokenNo, p->expr), m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->exprLowestType), desMin, false));
              m2type_AddStatement (location, BuildIfCallHandler (condition, r, function, message, true));
            }
          if (M2Range_IsGreater (exprMax, desMax))
            {
              condition = m2expr_BuildGreaterThan (location, DeReferenceLValue (p->tokenNo, p->expr), m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->exprLowestType), desMax, false));
              m2type_AddStatement (location, BuildIfCallHandler (condition, r, function, message, true));
            }
        }
      else
        {
          M2MetaError_MetaErrorStringT3 (p->tokenNo, message, p->des, p->expr, p->paramNo);
        }
    }
}


/*
   DoCodeAssignmentExprType -
*/

static void DoCodeAssignmentExprType (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  if ((SymbolConversion_GccKnowsAbout (p->desLowestType)) && (SymbolConversion_GccKnowsAbout (p->exprLowestType)))
    {
      if ((M2Base_IsRealType (p->desLowestType)) && (M2Base_IsRealType (p->exprLowestType)))
        {
          RangeCheckReal (p, r, function, message);
        }
      else
        {
          RangeCheckOrdinal (p, r, function, message);
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "should have resolved these types", 32);
    }
}


/*
   DoCodeAssignmentWithoutExprType -
*/

static void DoCodeAssignmentWithoutExprType (M2Range_Range p, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  tree condition;
  tree desMin;
  tree desMax;
  location_t location;

  location = M2LexBuf_TokenToLocation (p->tokenNo);
  if (SymbolConversion_GccKnowsAbout (p->desLowestType))
    {
      /* avoid dangling else.  */
      if (M2Range_GetMinMax (p->tokenNo, p->desLowestType, &desMin, &desMax))
        {
          condition = m2expr_BuildLessThan (location, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), DeReferenceLValue (p->tokenNo, p->expr), false), desMin);
          m2type_AddStatement (location, BuildIfCallHandler (condition, r, function, message, true));
          condition = m2expr_BuildGreaterThan (location, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), DeReferenceLValue (p->tokenNo, p->expr), false), desMax);
          m2type_AddStatement (location, BuildIfCallHandler (condition, r, function, message, true));
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "should have resolved this type", 30);
    }
}


/*
   DoCodeAssignment -
*/

static void DoCodeAssignment (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->des);
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  M2GCCDeclare_DeclareConstructor (tokenno, 0, p->expr);
  if (p->desLowestType != SymbolTable_NulSym)
    {
      M2Debug_Assert (SymbolConversion_GccKnowsAbout (p->expr));
      if (p->exprLowestType == SymbolTable_NulSym)
        {
          DoCodeAssignmentWithoutExprType (p, r, function, message);
        }
      else
        {
          DoCodeAssignmentExprType (p, r, function, message);
        }
    }
}


/*
   CodeAssignment -
*/

static void CodeAssignment (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  DoCodeAssignment (tokenno, r, function, message);
}


/*
   CodeParameterAssign -
*/

static void CodeParameterAssign (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  DoCodeAssignment (tokenno, r, function, message);
}


/*
   CodeReturn -
*/

static void CodeReturn (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  DoCodeAssignment (tokenno, r, function, message);
}


/*
   IfOutsideLimitsDo -
*/

static void IfOutsideLimitsDo (unsigned int tokenno, tree min, tree expr, tree max, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  tree condition;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  condition = m2expr_BuildGreaterThan (location, min, expr);
  m2type_AddStatement (location, m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message)));
  condition = m2expr_BuildLessThan (location, max, expr);
  m2type_AddStatement (location, m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message)));
}


/*
   CodeInc -
*/

static void CodeInc (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  M2Range_Range p;
  tree t;
  tree condition;
  tree e;
  tree desMin;
  tree desMax;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->des);
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if (p->desLowestType != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolConversion_GccKnowsAbout (p->desLowestType)))
        {
          /* avoid dangling else.  */
          if (M2Range_GetMinMax (tokenno, p->desLowestType, &desMin, &desMax))
            {
              e = m2convert_BuildConvert (location, m2type_GetTreeType (desMin), DeReferenceLValue (tokenno, p->expr), false);
              IfOutsideLimitsDo (p->tokenNo, m2convert_BuildConvert (location, m2type_GetTreeType (desMin), m2expr_GetIntegerZero (location), false), e, desMax, r, function, message);
              t = m2expr_BuildSub (location, desMax, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), e, false), false);
              condition = m2expr_BuildGreaterThan (location, SymbolConversion_Mod2Gcc (p->des), t);
              m2type_AddStatement (location, m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message)));
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "should have resolved these types", 32);
        }
    }
}


/*
   CodeDec -
*/

static void CodeDec (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  M2Range_Range p;
  tree t;
  tree condition;
  tree e;
  tree desMin;
  tree desMax;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->des);
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if (p->desLowestType != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolConversion_GccKnowsAbout (p->desLowestType)))
        {
          /* avoid dangling else.  */
          if (M2Range_GetMinMax (tokenno, p->desLowestType, &desMin, &desMax))
            {
              e = m2convert_BuildConvert (location, m2type_GetTreeType (desMin), DeReferenceLValue (tokenno, p->expr), false);
              IfOutsideLimitsDo (p->tokenNo, m2convert_BuildConvert (location, m2type_GetTreeType (desMin), m2expr_GetIntegerZero (location), false), e, desMax, r, function, message);
              t = m2expr_BuildSub (location, m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), e, false), desMin, false);
              condition = m2expr_BuildLessThan (location, SymbolConversion_Mod2Gcc (p->des), t);
              m2type_AddStatement (location, m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message)));
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "should have resolved these types", 32);
        }
    }
}


/*
   CodeInclExcl -
*/

static void CodeInclExcl (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  M2Range_Range p;
  tree e;
  tree desMin;
  tree desMax;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->des);
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  p->desLowestType = SymbolTable_SkipType (SymbolTable_GetType (p->des));
  if (p->desLowestType != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolConversion_GccKnowsAbout (p->desLowestType)))
        {
          /* avoid dangling else.  */
          if (M2Range_GetMinMax (tokenno, p->desLowestType, &desMin, &desMax))
            {
              e = m2convert_BuildConvert (location, m2type_GetTreeType (desMin), DeReferenceLValue (tokenno, p->expr), false);
              /* this should not be used for incl/excl as des is a set type
               t := BuildSub(location,
                             desMax,
                             BuildConvert(location, Mod2Gcc(desLowestType), e, FALSE),
                             FALSE) ;
               condition := BuildGreaterThan(Mod2Gcc(des), t) ;
               AddStatement(location, BuildIfThenDoEnd(condition, CodeErrorCheck(r, function, message)))
  */
              IfOutsideLimitsDo (p->tokenNo, desMin, e, desMax, r, function, message);
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "should have resolved these types", 32);
        }
    }
}


/*
   CodeShiftRotate - ensure that the bit shift is within the range
                     -(MAX(set)-MIN(set)+1)..(MAX(set)-MIN(set)+1)
*/

static void CodeShiftRotate (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  unsigned int ofType;
  M2Range_Range p;
  tree e;
  tree shiftMin;
  tree shiftMax;
  tree desMin;
  tree desMax;
  location_t location;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->des);
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  p->desLowestType = SymbolTable_SkipType (SymbolTable_GetType (p->des));
  if (p->desLowestType != SymbolTable_NulSym)
    {
      ofType = SymbolTable_SkipType (SymbolTable_GetType (p->desLowestType));
      if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolConversion_GccKnowsAbout (ofType)))
        {
          /* avoid dangling else.  */
          if (M2Range_GetMinMax (tokenno, ofType, &desMin, &desMax))
            {
              location = M2LexBuf_TokenToLocation (p->tokenNo);
              desMin = m2convert_BuildConvert (location, m2type_GetIntegerType (), desMin, false);
              desMax = m2convert_BuildConvert (location, m2type_GetIntegerType (), desMax, false);
              shiftMax = m2expr_BuildAdd (location, m2expr_BuildSub (location, desMax, desMin, false), m2expr_GetIntegerOne (location), false);
              shiftMin = m2expr_BuildNegate (location, shiftMax, false);
              e = m2convert_BuildConvert (location, m2type_GetIntegerType (), DeReferenceLValue (tokenno, p->expr), false);
              IfOutsideLimitsDo (p->tokenNo, shiftMin, e, shiftMax, r, function, message);
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "should have resolved these types", 32);
        }
    }
}


/*
   CodeStaticArraySubscript -
*/

static void CodeStaticArraySubscript (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  M2Range_Range p;
  tree desMin;
  tree desMax;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolConversion_GccKnowsAbout (p->desLowestType)))
    {
      if (M2Range_GetMinMax (tokenno, p->desLowestType, &desMin, &desMax))
        {
          IfOutsideLimitsDo (tokenno, desMin, m2convert_BuildConvert (location, m2type_GetTreeType (desMin), DeReferenceLValue (tokenno, p->expr), false), desMax, r, function, message);
        }
      else
        {
          M2Error_InternalError ((const char *) "should have resolved the bounds of the static array", 51);
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "should have resolved these types", 32);
    }
}


/*
   CodeDynamicArraySubscript -
*/

static void CodeDynamicArraySubscript (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  unsigned int UnboundedType;
  M2Range_Range p;
  tree high;
  tree e;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  M2Debug_Assert (SymbolTable_IsVar (p->des));
  if ((SymbolConversion_GccKnowsAbout (p->expr)) && (SymbolConversion_GccKnowsAbout (p->des)))
    {
      UnboundedType = SymbolTable_GetType (p->des);
      M2Debug_Assert (SymbolTable_IsUnbounded (UnboundedType));
      high = m2convert_BuildConvert (location, m2type_GetIntegerType (), M2GenGCC_GetHighFromUnbounded (location, p->dimension, p->des), false);
      e = m2convert_BuildConvert (location, m2type_GetIntegerType (), DeReferenceLValue (tokenno, p->expr), false);
      IfOutsideLimitsDo (p->tokenNo, m2expr_GetIntegerZero (location), e, high, r, function, message);
    }
  else
    {
      M2Error_InternalError ((const char *) "should have resolved these types", 32);
    }
}


/*
   CodeForLoopBegin -
*/

static void CodeForLoopBegin (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  if (ForLoopBeginTypeCompatible (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r))))
    {
      DoCodeAssignment (tokenno, r, function, message);
    }
}


/*
   CodeForLoopTo -
*/

static void CodeForLoopTo (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  DoCodeAssignment (tokenno, r, function, message);
}


/*
   SameTypesCodeForLoopEnd - the trivial case.
*/

static void SameTypesCodeForLoopEnd (unsigned int tokenNo, unsigned int r, DynamicStrings_String function, DynamicStrings_String message, M2Range_Range p, tree dmax)
{
  tree inc;
  tree room;
  tree statement;
  tree condition;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenNo);
  inc = DeReferenceLValue (p->tokenNo, p->expr);
  room = m2expr_BuildSub (location, dmax, SymbolConversion_Mod2Gcc (p->des), false);
  condition = m2expr_BuildLessThan (location, room, inc);
  statement = BuildIfCallHandler (condition, r, function, message, m2expr_IsTrue (condition));
  m2type_AddStatement (location, statement);
}

static void DiffTypesCodeForLoopEnd (unsigned int tokenNo, unsigned int r, DynamicStrings_String function, DynamicStrings_String message, M2Range_Range p, tree dmax, tree emin, tree emax)
{
  location_t location;
  tree desoftypee;
  tree inc;
  tree room;
  tree c1;
  tree c2;
  tree c3;
  tree c4;
  tree c5;
  tree c6;
  tree c7;
  tree c8;
  tree s1;
  tree s2;
  tree s3;
  tree s4;
  tree s5;
  tree s6;
  tree s7;
  tree s8;
  tree lg1;
  tree lg2;
  tree dz;
  tree ez;

  /* 
   DiffTypesSameForLoopEnd - remember that lowestType will map onto an int, or unsigned int
                             of appropriate size.
  */
  location = M2LexBuf_TokenToLocation (tokenNo);
  inc = DeReferenceLValue (p->tokenNo, p->expr);
  ez = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->exprLowestType), m2expr_GetIntegerZero (location), false);
  dz = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), m2expr_GetIntegerZero (location), false);
  c1 = m2expr_BuildGreaterThanOrEqual (location, inc, ez);
  /* if (inc >= 0)                                           [c1]  */
  c2 = m2expr_BuildGreaterThanOrEqual (location, SymbolConversion_Mod2Gcc (p->des), dz);
  /* if (des >= 0)                                        [c2]  */
  lg1 = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), inc, false);
  room = m2expr_BuildSub (location, dmax, SymbolConversion_Mod2Gcc (p->des), false);
  c3 = m2expr_BuildGreaterThan (location, lg1, room);  /* [c3]  */
  /* WarnIf(IsTrue(c1) AND IsTrue(c2) AND IsTrue(c3), function, message) ; --implement me--  */
  s3 = BuildIfCallHandler (c3, r, function, message, false);
  s2 = m2statement_BuildIfThenDoEnd (c2, s3);
  /* if (des <= val(desLowestType, emax)                  [c4]  */
  c4 = m2expr_BuildLessThanOrEqual (location, SymbolConversion_Mod2Gcc (p->des), m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), emax, false));
  /* des <= MAX(exprLowestType)  */
  desoftypee = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->exprLowestType), SymbolConversion_Mod2Gcc (p->des), false);
  c5 = m2expr_BuildEqualTo (location, desoftypee, emin);  /* [c5]  */
  s5 = BuildIfCallHandler (c5, r, function, message, false);
  /* end  */
  c6 = m2expr_BuildEqualTo (location, inc, emin);  /* [c6]  */
  /* if des = 0                                      [c7]  */
  c7 = m2expr_BuildEqualTo (location, SymbolConversion_Mod2Gcc (p->des), dz);
  s7 = BuildIfCallHandler (c7, r, function, message, false);
  /* lg2 = VAL(desLowestType, -inc)                  [s8]  */
  lg2 = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (p->desLowestType), m2expr_BuildNegate (location, inc, false), false);
  /* error  */
  c8 = m2expr_BuildGreaterThan (location, lg2, SymbolConversion_Mod2Gcc (p->des));
  s8 = BuildIfCallHandler (c8, r, function, message, false);
  /* end  */
  s6 = m2statement_BuildIfThenElseEnd (c6, s7, s8);
  s4 = m2statement_BuildIfThenElseEnd (c4, s5, s6);
  s1 = m2statement_BuildIfThenElseEnd (c1, s2, s4);
  m2type_AddStatement (location, s1);
}


/*
   CodeForLoopEnd - checks to see that des := des + expr does not overflow.
                    This is called at the end of the for loop.  It is more complex
                    than it initially seems as des and expr might be different types.
*/

static void CodeForLoopEnd (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  bool isCard;
  M2Range_Range p;
  tree dmin;
  tree dmax;
  tree emin;
  tree emax;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (tokenno, p->des);  /* use quad tokenno, rather than the range tokenNo  */
  M2GCCDeclare_TryDeclareConstant (tokenno, p->expr);  /* use quad tokenno, rather than the range tokenNo  */
  if (p->desLowestType != SymbolTable_NulSym)  /* use quad tokenno, rather than the range tokenNo  */
    {
      M2Debug_Assert (SymbolConversion_GccKnowsAbout (p->expr));
      if ((((SymbolConversion_GccKnowsAbout (p->desLowestType)) && (M2Range_GetMinMax (tokenno, p->desLowestType, &dmin, &dmax))) && (SymbolConversion_GccKnowsAbout (p->exprLowestType))) && (M2Range_GetMinMax (tokenno, p->exprLowestType, &emin, &emax)))
        {
          M2ALU_PushIntegerTree (dmin);
          M2ALU_PushInt (0);
          isCard = M2ALU_GreEqu (tokenno);
          if ((p->desLowestType == p->exprLowestType) && isCard)
            {
              SameTypesCodeForLoopEnd (tokenno, r, function, message, p, dmax);
            }
          else
            {
              DiffTypesCodeForLoopEnd (tokenno, r, function, message, p, dmax, emin, emax);
            }
        }
    }
}


/*
   CodeNil -
*/

static void CodeNil (unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  M2Range_Range p;
  tree condition;
  tree t;
  location_t location;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->des);
  /* 
      IF GetMode(des)=LeftValue
      THEN
          t := BuildIndirect(Mod2Gcc(des), Mod2Gcc(GetType(des))) 
      ELSE
         t := Mod2Gcc(des)
      END ;
  */
  t = SymbolConversion_Mod2Gcc (p->des);
  location = M2LexBuf_TokenToLocation (p->tokenNo);
  condition = m2expr_BuildEqualTo (location, m2convert_BuildConvert (location, m2type_GetPointerType (), t, false), m2expr_GetPointerZero (location));
  m2type_AddStatement (location, BuildIfCallHandler (condition, r, function, message, true));
}


/*
   CodeWholeNonPos - generates range check code for expr<=0.
*/

static void CodeWholeNonPos (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  unsigned int zero;
  M2Range_Range p;
  tree condition;
  tree e;
  location_t location;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if (SymbolConversion_GccKnowsAbout (p->expr))
    {
      location = M2LexBuf_TokenToLocation (tokenno);
      e = M2GenGCC_ZConstToTypedConst (M2GenGCC_LValueToGenericPtr (location, p->expr), p->expr, p->des);
      zero = MakeAndDeclareConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
      condition = m2expr_BuildLessThanOrEqual (location, e, SymbolConversion_Mod2Gcc (zero));
      m2type_AddStatement (location, m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message)));
    }
  else
    {
      M2Error_InternalError ((const char *) "should have resolved expr", 25);
    }
}


/*
   CodeWholeZero - generates range check code for expr=0.
*/

static void CodeWholeZero (unsigned int tokenno, unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  unsigned int zero;
  M2Range_Range p;
  tree condition;
  tree e;
  location_t location;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2GCCDeclare_TryDeclareConstant (p->tokenNo, p->expr);
  if (SymbolConversion_GccKnowsAbout (p->expr))
    {
      location = M2LexBuf_TokenToLocation (tokenno);
      e = M2GenGCC_ZConstToTypedConst (M2GenGCC_LValueToGenericPtr (location, p->expr), p->expr, p->des);
      zero = MakeAndDeclareConstLit (tokenno, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
      condition = m2expr_BuildEqualTo (location, e, m2convert_BuildConvert (location, m2type_GetTreeType (e), SymbolConversion_Mod2Gcc (zero), false));
      m2type_AddStatement (location, m2statement_BuildIfThenDoEnd (condition, M2Range_CodeErrorCheck (r, function, message)));
    }
  else
    {
      M2Error_InternalError ((const char *) "should have resolved expr", 25);
    }
}


/*
   FillInParameters -
*/

static DynamicStrings_String FillInParameters (unsigned int r, DynamicStrings_String s)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  switch (p->type)
    {
      case M2Range_assignment:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_returnassignment:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_subrangeassignment:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;

      case M2Range_inc:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_dec:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_incl:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_excl:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_shift:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_rotate:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_typeassign:
        break;

      case M2Range_typeparam:
        break;

      case M2Range_typeexpr:
        break;

      case M2Range_paramassign:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->paramNo);
        break;

      case M2Range_staticarraysubscript:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_dynamicarraysubscript:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_forloopbegin:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_forloopto:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_forloopend:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_pointernil:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_noreturn:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_noelse:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_casebounds:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_wholenonposdiv:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_wholenonposmod:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_wholezerodiv:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_wholezerorem:
        s = M2MetaError_MetaString3 (s, p->des, p->expr, p->dimension);
        break;

      case M2Range_none:
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetRangeErrorMessage - returns a specific error message for the range, r.
                          It assumes the 3 parameters to be supplied on the MetaError
                          parameter list are:  dest, expr, paramNo or dimension.

XYZ
                    'the initial assignment to {%1a} at the start of the FOR loop will cause a range error, as the type range of {%1taD} does not overlap with {%2tad}')
                    'the final TO value {%2a} of the FOR loop will cause a range error with the iterator variable {%1a}')
*/

static DynamicStrings_String GetRangeErrorMessage (unsigned int r)
{
  M2Range_Range p;
  DynamicStrings_String s;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  switch (p->type)
    {
      case M2Range_assignment:
        s = DynamicStrings_InitString ((const char *) "assignment will cause a range error, as the runtime instance value of {%1tad} does not overlap with the type {%2tad}", 116);
        break;

      case M2Range_returnassignment:
        s = DynamicStrings_InitString ((const char *) "attempting to return {%2Wa} from a procedure function {%1a} which will exceed exceed the range of type {%1tad}", 110);
        break;

      case M2Range_subrangeassignment:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;

      case M2Range_inc:
        s = DynamicStrings_InitString ((const char *) "if the INC is ever executed the expression {%2Wa} will cause an overflow error for the designator {%1a} as it exceeds the type range {%1ts:of {%1ts}}", 149);
        break;

      case M2Range_dec:
        s = DynamicStrings_InitString ((const char *) "if the DEC is ever executed the expression {%2Wa} will cause an underflow error for the designator {%1a} as it exceeds the type range {%1ts:of {%1ts}}", 150);
        break;

      case M2Range_incl:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the INCL exceeds the type range {%1ts} of the designator {%1a}", 93);
        break;

      case M2Range_excl:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the EXCL exceeds the type range {%1ts} of the designator {%1a}", 93);
        break;

      case M2Range_shift:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the second parameter to SHIFT exceeds the type range {%1ts} of the first parameter {%1a}", 119);
        break;

      case M2Range_rotate:
        s = DynamicStrings_InitString ((const char *) "the expression {%2Wa} given in the second parameter to ROTATE exceeds the type range {%1ts} of the first parameter {%1a}", 120);
        break;

      case M2Range_typeassign:
        s = static_cast<DynamicStrings_String> (NULL);
        break;

      case M2Range_typeparam:
        s = static_cast<DynamicStrings_String> (NULL);
        break;

      case M2Range_typeexpr:
        s = static_cast<DynamicStrings_String> (NULL);
        break;

      case M2Range_typeindrx:
        s = DynamicStrings_InitString ((const char *) "assignment between designator {%1ad} and {%2ad} is incompatible", 63);
        break;

      case M2Range_typereturn:
        s = DynamicStrings_InitString ((const char *) "the value {%2ad} returned from procedure function {%1a} is type incompatible, expecting {%1tad} rather than a {%2tad}", 117);
        break;

      case M2Range_paramassign:
        s = DynamicStrings_InitString ((const char *) "if this call is executed then the actual parameter {%2Wa} will be out of range of the {%3N} formal parameter {%1a}", 114);
        break;

      case M2Range_staticarraysubscript:
        s = DynamicStrings_InitString ((const char *) "if this access to the static array {%1Wa:{%2a:{%1a}[{%2a}]}} is ever made then the index will be out of bounds in the {%3N} array subscript", 139);
        break;

      case M2Range_dynamicarraysubscript:
        s = DynamicStrings_InitString ((const char *) "if this access to the dynamic array {%1Wa:{%2a:{%1a}[{%2a}]}} is ever made then the index will be out of bounds in the {%3N} array subscript", 140);
        break;

      case M2Range_forloopbegin:
        s = DynamicStrings_InitString ((const char *) "if the assignment in this FOR loop is ever executed then the designator {%1Wa} will be exceed the type range {%1ts:of {%1ts}}", 125);
        break;

      case M2Range_forloopto:
        s = DynamicStrings_InitString ((const char *) "the final value {%2Wa} in this FOR loop will be out of bounds {%1ts:of type {%1ts}} if ever executed", 100);
        break;

      case M2Range_forloopend:
        s = DynamicStrings_InitString ((const char *) "the FOR loop will cause the designator {%1Wa} to be out of bounds when the BY value {%2a} is added", 98);
        break;

      case M2Range_pointernil:
        s = DynamicStrings_InitString ((const char *) "if this pointer value {%1Wa} is ever dereferenced it will cause an exception", 76);
        break;

      case M2Range_noreturn:
        s = DynamicStrings_InitString ((const char *) "{%1W:}this function will exit without executing a RETURN statement", 66);
        break;

      case M2Range_noelse:
        s = DynamicStrings_InitString ((const char *) "{%1W:}this CASE statement does not have an ELSE statement", 57);
        break;

      case M2Range_casebounds:
        s = DynamicStrings_InitString ((const char *) "{%1W:}this CASE statement has overlapping ranges", 48);
        break;

      case M2Range_wholenonposdiv:
        s = DynamicStrings_InitString ((const char *) "this division expression {%2Wa} will cause an exception as this divisor is less than or equal to zero", 101);
        break;

      case M2Range_wholenonposmod:
        s = DynamicStrings_InitString ((const char *) "this modulus expression {%2Wa} will cause an exception as this divisor is less than or equal to zero", 100);
        break;

      case M2Range_wholezerodiv:
        s = DynamicStrings_InitString ((const char *) "this division expression {%2Wa} will cause an exception as the divisor is zero", 78);
        break;

      case M2Range_wholezerorem:
        s = DynamicStrings_InitString ((const char *) "this remainder expression {%2Wa} will cause an exception as the divisor is zero", 79);
        break;

      case M2Range_none:
        s = static_cast<DynamicStrings_String> (NULL);
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Init - initializes the modules global variables.
*/

static void Init (void)
{
  TopOfRange = 0;
  RangeIndex = Indexing_InitIndex (1);
  BreakWhenRangeCreated (0);  /* Disable the intereactive range watch.  */
  /* To examine the range when it is created run cc1gm2 from gdb
      and set a break point on gdbhook.
      (gdb) break gdbhook
      (gdb) run
      Now below interactively call BreakWhenRangeCreated with the symbol
      under investigation.  */
  gdbhook ();
}


/*
   InitAssignmentRangeCheck - returns a range check node which
                              remembers the information necessary
                              so that a range check for des := expr
                              can be generated later on.
*/

extern "C" unsigned int M2Range_InitAssignmentRangeCheck (unsigned int tokno, unsigned int des, unsigned int expr, unsigned int destok, unsigned int exprtok)
{
  unsigned int r;
  M2Range_Range p;

  r = InitRange ();
  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  M2Debug_Assert ((PutRange (tokno, p, M2Range_assignment, des, expr)) != NULL);
  p->destok = destok;
  p->exprtok = exprtok;
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitReturnRangeCheck - returns a range check node which
                          remembers the information necessary
                          so that a range check for RETURN e
                          from procedure, d, can be generated later on.
*/

extern "C" unsigned int M2Range_InitReturnRangeCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRange (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_returnassignment, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitSubrangeRangeCheck - returns a range check node which
                            remembers the information necessary
                            so that a range check for d := e
                            can be generated later on.
*/

extern "C" unsigned int M2Range_InitSubrangeRangeCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRange (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_subrangeassignment, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitStaticArraySubscriptRangeCheck - returns a range check node which
                                        remembers the information necessary
                                        so that a range check for d[e]
                                        can be generated later on.
*/

extern "C" unsigned int M2Range_InitStaticArraySubscriptRangeCheck (unsigned int d, unsigned int e, unsigned int dim)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeArraySubscript (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_staticarraysubscript, d, e, dim)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitDynamicArraySubscriptRangeCheck - returns a range check node which
                                         remembers the information necessary
                                         so that a range check for d[e]
                                         can be generated later on.
*/

extern "C" unsigned int M2Range_InitDynamicArraySubscriptRangeCheck (unsigned int d, unsigned int e, unsigned int dim)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeArraySubscript (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_dynamicarraysubscript, d, e, dim)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitIncRangeCheck - returns a range check node which
                       remembers the information necessary
                       so that a range check for INC(d, e)
                       can be generated later on.
*/

extern "C" unsigned int M2Range_InitIncRangeCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRange (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_inc, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitDecRangeCheck - returns a range check node which
                       remembers the information necessary
                       so that a range check for DEC(d, e)
                       can be generated later on.
*/

extern "C" unsigned int M2Range_InitDecRangeCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRange (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_dec, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitForLoopBeginRangeCheck - returns a range check node which
                                remembers the information necessary
                                so that a range check for
                                FOR des := expr1 TO expr2 DO
                                can be generated later on.  expr2 is
                                only used to type check with des.
*/

extern "C" unsigned int M2Range_InitForLoopBeginRangeCheck (unsigned int des, unsigned int destok, unsigned int expr1, unsigned int expr1tok, unsigned int expr2, unsigned int expr2tok, unsigned int byconst, unsigned int byconsttok)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeDesExpr2 (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_forloopbegin, des, destok, expr1, expr1tok, expr2, expr2tok, byconst, byconsttok)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeForIncrement - places incrementquad into the range record.
*/

extern "C" void M2Range_PutRangeForIncrement (unsigned int range, unsigned int incrementquad)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, range));
  p->incrementquad = incrementquad;
}


/*
   InitForLoopToRangeCheck - returns a range check node which
                             remembers the information necessary
                             so that a range check for FOR d := e TO .. DO
                             can be generated later on.
*/

extern "C" unsigned int M2Range_InitForLoopToRangeCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRange (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_forloopto, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitForLoopEndRangeCheck - returns a range check node which
                              remembers the information necessary
                              so that a range check for
                              INC or DEC(d, e)
                              can be generated later on.
*/

extern "C" unsigned int M2Range_InitForLoopEndRangeCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRange (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_forloopend, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitPointerRangeCheck - creates a pointer # NIL check.
*/

extern "C" unsigned int M2Range_InitPointerRangeCheck (unsigned int tokno, unsigned int d, bool isLeft)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangePointer (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), d, isLeft)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitNoReturnRangeCheck - creates a check held in the function
                            to detect the absence of a RETURN
                            statement at runtime.
*/

extern "C" unsigned int M2Range_InitNoReturnRangeCheck (void)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoEval (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_noreturn)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitNoElseRangeCheck - creates a check held at the end of
                          a CASE statement without an ELSE
                          clause to detect its absence
                          at runtime.
*/

extern "C" unsigned int M2Range_InitNoElseRangeCheck (void)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoEval (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_noelse)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitWholeNonPosDivCheck - creates a check expression for non positive
                             or zero 2nd operand to division.
*/

extern "C" unsigned int M2Range_InitWholeNonPosDivCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeUnary (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_wholenonposdiv, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitWholeNonPosModCheck - creates a check expression for non positive
                             or zero 2nd operand to modulus.
*/

extern "C" unsigned int M2Range_InitWholeNonPosModCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeUnary (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_wholenonposmod, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitWholeZeroDivisionCheck - creates a check expression for zero 2nd
                                operand for division.
*/

extern "C" unsigned int M2Range_InitWholeZeroDivisionCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeUnary (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_wholezerodiv, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitWholeZeroRemainderCheck - creates a check expression for zero 2nd
                                 operand for remainder.
*/

extern "C" unsigned int M2Range_InitWholeZeroRemainderCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeUnary (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_wholezerorem, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitInclCheck - checks to see that bit, e, is type compatible with
                   e and also in range.
*/

extern "C" unsigned int M2Range_InitInclCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_incl, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitExclCheck - checks to see that bit, e, is type compatible with
                   e and also in range.
*/

extern "C" unsigned int M2Range_InitExclCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_excl, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitShiftCheck - checks to see that bit, e, is type compatible with
                    d and also in range.
*/

extern "C" unsigned int M2Range_InitShiftCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_shift, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitRotateCheck - checks to see that bit, e, is type compatible with
                     d and also in range.
*/

extern "C" unsigned int M2Range_InitRotateCheck (unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (M2LexBuf_GetTokenNo (), reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_rotate, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitTypesAssignmentCheck - checks to see that the types of d and e
                              are assignment compatible.
*/

extern "C" unsigned int M2Range_InitTypesAssignmentCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_typeassign, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitTypesParameterCheck - checks to see that the types of, d,
                             and, e, are parameter compatible.
*/

extern "C" unsigned int M2Range_InitTypesParameterCheck (unsigned int tokno, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int depRangeId)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeParam (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_typeparam, proc, paramno, formal, actual, depRangeId)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitParameterRangeCheck - checks to see that the types of, d, and, e,
                             are parameter compatible.
*/

extern "C" unsigned int M2Range_InitParameterRangeCheck (unsigned int tokno, unsigned int proc, unsigned int paramno, unsigned int formal, unsigned int actual, unsigned int parentRangeId)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeParamAssign (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_paramassign, proc, paramno, formal, actual, parentRangeId)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitTypesExpressionCheck - checks to see that the types of, d, and, e,
                              are expression compatible.
*/

extern "C" unsigned int M2Range_InitTypesExpressionCheck (unsigned int tokno, unsigned int d, unsigned int e, bool strict, bool isin)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeExpr (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_typeexpr, d, e, strict, isin)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitTypesIndrXCheck - checks to see that the types of d and e
                         are assignment compatible.  The type checking
                         will dereference *e during the type check.
                         d = *e.
*/

extern "C" unsigned int M2Range_InitTypesIndrXCheck (unsigned int tokno, unsigned int d, unsigned int e)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_typeindrx, d, e)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitTypesReturnTypeCheck - checks to see that the types of des and func
                              are assignment compatible.
*/

extern "C" unsigned int M2Range_InitTypesReturnTypeCheck (unsigned int tokno, unsigned int func, unsigned int val)
{
  unsigned int r;

  r = InitRange ();
  M2Debug_Assert ((PutRangeNoLow (tokno, reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_typereturn, func, val)) != NULL);
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitCaseBounds - creates a case bound range check.
*/

extern "C" unsigned int M2Range_InitCaseBounds (unsigned int b)
{
  M2Range_Range p;
  unsigned int r;

  r = InitRange ();
  p = PutRangeNoEval (reinterpret_cast <M2Range_Range> (Indexing_GetIndice (RangeIndex, r)), M2Range_casebounds);
  p->caseList = b;
  return r;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CodeRangeCheck - returns a Tree representing the code for a
                    range test defined by, r.
*/

extern "C" void M2Range_CodeRangeCheck (unsigned int r, DynamicStrings_String function)
{
  M2Range_Range p;
  DynamicStrings_String message;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  message = GetRangeErrorMessage (r);
  switch (p->type)
    {
      case M2Range_assignment:
        CodeAssignment (p->tokenNo, r, function, message);
        break;

      case M2Range_returnassignment:
        CodeReturn (p->tokenNo, r, function, message);
        break;

      case M2Range_subrangeassignment:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;

      case M2Range_inc:
        CodeInc (p->tokenNo, r, function, message);
        break;

      case M2Range_dec:
        CodeDec (p->tokenNo, r, function, message);
        break;

      case M2Range_incl:
      case M2Range_excl:
        CodeInclExcl (p->tokenNo, r, function, message);
        break;

      case M2Range_shift:
      case M2Range_rotate:
        CodeShiftRotate (p->tokenNo, r, function, message);
        break;

      case M2Range_typeassign:
      case M2Range_typeparam:
      case M2Range_typeexpr:
      case M2Range_typeindrx:
      case M2Range_typereturn:
        CodeTypeCheck (p->tokenNo, r);
        break;

      case M2Range_staticarraysubscript:
        CodeStaticArraySubscript (p->tokenNo, r, function, message);
        break;

      case M2Range_dynamicarraysubscript:
        CodeDynamicArraySubscript (p->tokenNo, r, function, message);
        break;

      case M2Range_forloopbegin:
        CodeForLoopBegin (p->tokenNo, r, function, message);
        break;

      case M2Range_forloopto:
        CodeForLoopTo (p->tokenNo, r, function, message);
        break;

      case M2Range_forloopend:
        CodeForLoopEnd (p->tokenNo, r, function, message);
        break;

      case M2Range_pointernil:
        CodeNil (r, function, message);
        break;

      case M2Range_noreturn:
        m2type_AddStatement (M2LexBuf_TokenToLocation (p->tokenNo), M2Range_CodeErrorCheck (r, function, message));
        break;

      case M2Range_noelse:
        m2type_AddStatement (M2LexBuf_TokenToLocation (p->tokenNo), M2Range_CodeErrorCheck (r, function, message));
        break;

      case M2Range_casebounds:
        CodeCaseBounds (p->tokenNo, p->caseList);
        break;

      case M2Range_wholenonposdiv:
        CodeWholeNonPos (p->tokenNo, r, function, message);
        break;

      case M2Range_wholenonposmod:
        CodeWholeNonPos (p->tokenNo, r, function, message);
        break;

      case M2Range_wholezerodiv:
        CodeWholeZero (p->tokenNo, r, function, message);
        break;

      case M2Range_wholezerorem:
        CodeWholeZero (p->tokenNo, r, function, message);
        break;

      case M2Range_paramassign:
        CodeParameterAssign (p->tokenNo, r, function, message);
        break;

      case M2Range_none:
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected case", 15);
        break;
    }
}


/*
   FoldRangeCheck - attempts to resolve the range check.
                    If it evaluates to true then
                       it is replaced by an ErrorOp
                    elsif it evaluates to false then
                       it is removed
                    else
                       it is left alone
*/

extern "C" void M2Range_FoldRangeCheck (unsigned int tokenno, unsigned int quad, unsigned int range)
{
  if (IsCancelled (range))
    {
      M2Quads_SubQuad (quad);
    }
  else
    {
      FoldRangeCheckLower (tokenno, quad, range);
    }
}


/*
   CodeErrorCheck - returns a Tree calling the approprate exception handler.
*/

extern "C" tree M2Range_CodeErrorCheck (unsigned int r, DynamicStrings_String function, DynamicStrings_String message)
{
  DynamicStrings_String filename;
  unsigned int line;
  unsigned int column;
  M2Range_Range p;
  tree f;
  location_t location;

  if (HandlerExists (r))
    {
      if (message == NULL)
        {
          message = GetRangeErrorMessage (r);
        }
      message = FillInParameters (r, message);
      p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
      filename = M2LexBuf_FindFileNameFromToken (p->tokenNo, 0);
      line = M2LexBuf_TokenToLineNo (p->tokenNo, 0);
      column = M2LexBuf_TokenToColumnNo (p->tokenNo, 0);
      location = M2LexBuf_TokenToLocation (p->tokenNo);
      f = SymbolConversion_Mod2Gcc (lookupExceptionHandler (p->type));
      BuildStringParam (p->tokenNo, message);
      BuildStringParam (p->tokenNo, function);
      m2statement_BuildParam (location, m2decl_BuildIntegerConstant (static_cast<int> (column)));
      m2statement_BuildParam (location, m2decl_BuildIntegerConstant (static_cast<int> (line)));
      BuildStringParam (p->tokenNo, filename);
      return m2statement_BuildProcedureCallTree (location, f, NULL);
    }
  else
    {
      return NULL;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   WriteRangeCheck - displays debugging information about range, r.
*/

extern "C" void M2Range_WriteRangeCheck (unsigned int r)
{
  M2Range_Range p;

  p = static_cast<M2Range_Range> (Indexing_GetIndice (RangeIndex, r));
  StrIO_WriteString ((const char *) "range ", 6);
  NumberIO_WriteCard (r, 0);
  StrIO_WriteString ((const char *) " ", 1);
  if (p->cancelled)
    {
      StrIO_WriteString ((const char *) "cancelled ", 10);
    }
  if (p->dependantid != 0)
    {
      StrIO_WriteString ((const char *) "dep ", 4);
      NumberIO_WriteCard (p->dependantid, 0);
      StrIO_WriteString ((const char *) " ", 1);
    }
  switch (p->type)
    {
      case M2Range_assignment:
        StrIO_WriteString ((const char *) "assignment (", 12);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_returnassignment:
        StrIO_WriteString ((const char *) "returnassignment (", 18);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_subrangeassignment:
        StrIO_WriteString ((const char *) "subrangeassignment(", 19);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_inc:
        StrIO_WriteString ((const char *) "inc(", 4);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_dec:
        StrIO_WriteString ((const char *) "dec(", 4);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_incl:
        StrIO_WriteString ((const char *) "incl(", 5);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_excl:
        StrIO_WriteString ((const char *) "excl(", 5);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_shift:
        StrIO_WriteString ((const char *) "shift(", 6);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_rotate:
        StrIO_WriteString ((const char *) "rotate(", 7);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_typeexpr:
        StrIO_WriteString ((const char *) "expr compatible (", 17);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_typeassign:
        StrIO_WriteString ((const char *) "assignment compatible (", 23);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_typeindrx:
        StrIO_WriteString ((const char *) "indrx compatible (", 18);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_typereturn:
        StrIO_WriteString ((const char *) "return compatible (", 19);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_typeparam:
        StrIO_WriteString ((const char *) "parameter compatible (", 22);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_paramassign:
        StrIO_WriteString ((const char *) "parameter range (", 17);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_staticarraysubscript:
        StrIO_WriteString ((const char *) "staticarraysubscript(", 21);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_dynamicarraysubscript:
        StrIO_WriteString ((const char *) "dynamicarraysubscript(", 22);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_forloopbegin:
        StrIO_WriteString ((const char *) "forloopbegin(", 13);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_forloopto:
        StrIO_WriteString ((const char *) "forloopto(", 10);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_forloopend:
        StrIO_WriteString ((const char *) "forloopend(", 11);
        M2Quads_WriteOperand (p->des);
        StrIO_WriteString ((const char *) ", ", 2);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_pointernil:
        StrIO_WriteString ((const char *) "pointernil(", 11);
        M2Quads_WriteOperand (p->des);
        break;

      case M2Range_noreturn:
        StrIO_WriteString ((const char *) "noreturn(", 9);
        break;

      case M2Range_noelse:
        StrIO_WriteString ((const char *) "noelse(", 7);
        break;

      case M2Range_casebounds:
        StrIO_WriteString ((const char *) "casebounds(", 11);
        M2CaseList_WriteCase (p->caseList);
        break;

      case M2Range_wholenonposdiv:
        StrIO_WriteString ((const char *) "wholenonposdiv(", 15);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_wholenonposmod:
        StrIO_WriteString ((const char *) "wholenonposmod(", 15);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_wholezerodiv:
        StrIO_WriteString ((const char *) "wholezerodiv(", 13);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_wholezerorem:
        StrIO_WriteString ((const char *) "wholezerorem(", 13);
        M2Quads_WriteOperand (p->expr);
        break;

      case M2Range_none:
        StrIO_WriteString ((const char *) "none(", 5);
        break;


      default:
        M2Error_InternalError ((const char *) "unknown case", 12);
        break;
    }
  StdIO_Write (')');
}


/*
   OverlapsRange - returns TRUE if a1..a2 overlaps with b1..b2.
*/

extern "C" bool M2Range_OverlapsRange (tree a1, tree a2, tree b1, tree b2)
{
  /* RETURN( ((a1<=b2) AND (a2>=b1)) )  */
  return ((m2expr_CompareTrees (a1, b2)) <= 0) && ((m2expr_CompareTrees (a2, b1)) >= 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsEqual - returns TRUE if a=b.
*/

extern "C" bool M2Range_IsEqual (tree a, tree b)
{
  return (m2expr_CompareTrees (a, b)) == 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsGreaterOrEqual - returns TRUE if a>=b.
*/

extern "C" bool M2Range_IsGreaterOrEqual (tree a, tree b)
{
  return (m2expr_CompareTrees (a, b)) >= 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsGreater - returns TRUE if a>b.
*/

extern "C" bool M2Range_IsGreater (tree a, tree b)
{
  return (m2expr_CompareTrees (a, b)) > 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildIfCallWholeHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

extern "C" tree M2Range_BuildIfCallWholeHandlerLoc (location_t location, tree condition, const char * scope, const char * message)
{
  return BuildIfCallHandlerLoc (location, condition, scope, message, M2Base_ExceptionWholeValue);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildIfCallRealHandlerLoc - return a Tree containing a runtime test whether, condition, is true.
*/

extern "C" tree M2Range_BuildIfCallRealHandlerLoc (location_t location, tree condition, const char * scope, const char * message)
{
  return BuildIfCallHandlerLoc (location, condition, scope, message, M2Base_ExceptionRealValue);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetMinMax - returns TRUE if we know the max and min of m2type.
*/

extern "C" bool M2Range_GetMinMax (unsigned int tokenno, unsigned int type, tree *min, tree *max)
{
  unsigned int minC;
  unsigned int maxC;
  location_t location;

  location = M2LexBuf_TokenToLocation (tokenno);
  M2Debug_Assert (SymbolTable_IsAModula2Type (type));
  if (((((((((((((((((SymbolConversion_GccKnowsAbout (type)) && (! (SymbolTable_IsPointer (type)))) && (! (SymbolTable_IsArray (type)))) && (! (SymbolTable_IsRecord (type)))) && (! (SymbolTable_IsRecord (type)))) && (! (SymbolTable_IsUnbounded (type)))) && (! (SymbolTable_IsProcType (type)))) && (! (M2Base_IsRealType (type)))) && (! (M2System_IsRealN (type)))) && (! (M2Base_IsComplexType (type)))) && (! (M2System_IsComplexN (type)))) && (type != M2System_Address)) && (! (SymbolTable_IsSet (type)))) && (type != M2System_Word)) && (type != M2System_Loc)) && (type != M2System_Byte)) && (! (M2System_IsWordN (type))))
    {
      if (SymbolTable_IsSubrange (type))
        {
          SymbolTable_GetSubrange (type, &maxC, &minC);
          (*max) = SymbolConversion_Mod2Gcc (maxC);
          (*min) = SymbolConversion_Mod2Gcc (minC);
        }
      else if (SymbolTable_IsEnumeration (type))
        {
          /* avoid dangling else.  */
          M2Base_GetBaseTypeMinMax (type, &minC, &maxC);
          (*max) = SymbolConversion_Mod2Gcc (maxC);
          (*min) = SymbolConversion_Mod2Gcc (minC);
        }
      else
        {
          /* avoid dangling else.  */
          (*max) = m2type_GetMaxFrom (location, SymbolConversion_Mod2Gcc (type));
          (*min) = m2type_GetMinFrom (location, SymbolConversion_Mod2Gcc (type));
        }
      (*max) = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), (*max), false);
      M2Debug_Assert (! (m2expr_TreeOverflow ((*max))));
      (*min) = m2convert_BuildConvert (location, SymbolConversion_Mod2Gcc (type), (*min), false);
      M2Debug_Assert (! (m2expr_TreeOverflow ((*min))));
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Range_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  /* Now is the time to interactively call gdb, for example:
      (gdb) print BreakWhenRangeCreated (1234)
      (gdb) cont
      and you will arrive at gdbhook when this symbol is created.  */
  Init ();
}

extern "C" void _M2_M2Range_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
