/* do not edit automatically generated by mc from M2Quads.  */
/* M2Quads.mod generates quadruples.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Quads_C

#include "GM2Quads.h"
#   include "GStorage.h"
#   include "GM2Debug.h"
#   include "GNameKey.h"
#   include "GFormatStrings.h"
#   include "GM2DebugStack.h"
#   include "GStrLib.h"
#   include "GM2Scaffold.h"
#   include "GM2MetaError.h"
#   include "GDynamicStrings.h"
#   include "GSymbolTable.h"
#   include "GM2Batch.h"
#   include "GM2GCCDeclare.h"
#   include "GFifoQueue.h"
#   include "GM2Comp.h"
#   include "GM2LexBuf.h"
#   include "GM2Error.h"
#   include "GM2Printf.h"
#   include "GM2Reserved.h"
#   include "GM2Base.h"
#   include "GM2System.h"
#   include "GM2Size.h"
#   include "GM2Bitset.h"
#   include "GM2ALU.h"
#   include "GLists.h"
#   include "GM2Options.h"
#   include "GM2LangDump.h"
#   include "GM2Pass.h"
#   include "GM2StackAddress.h"
#   include "GM2StackWord.h"
#   include "GIndexing.h"
#   include "GM2Range.h"
#   include "GM2CaseList.h"
#   include "GPCSymBuild.h"
#   include "Gm2builtins.h"
#   include "GFIO.h"
#   include "GSFIO.h"
#   include "GStdIO.h"

#   define DebugStackOn true
#   define DebugVarients false
#   define DebugTokPos false
typedef struct M2Quads__T1_r M2Quads__T1;

typedef M2Quads__T1 *M2Quads_ConstructorFrame;

typedef struct M2Quads__T2_r M2Quads__T2;

typedef M2Quads__T2 *M2Quads_BoolFrame;

typedef struct M2Quads__T3_r M2Quads__T3;

typedef M2Quads__T3 *M2Quads_QuadFrame;

typedef struct M2Quads__T4_r M2Quads__T4;

typedef M2Quads__T4 *M2Quads_WithFrame;

typedef struct M2Quads__T5_r M2Quads__T5;

typedef M2Quads__T5 *M2Quads_ForLoopInfo;

typedef struct M2Quads__T6_r M2Quads__T6;

typedef M2Quads__T6 *M2Quads_LineNote;

#   define DebugAsmTokPos false
struct M2Quads__T1_r {
                       unsigned int type;
                       unsigned int index;
                     };

struct M2Quads__T2_r {
                       unsigned int TrueExit;
                       unsigned int FalseExit;
                       unsigned int Unbounded;
                       bool BooleanOp;
                       unsigned int Dimension;
                       unsigned int ReadWrite;
                       unsigned int name;
                       unsigned int RangeDep;
                       DynamicStrings_String Annotation;
                       unsigned int tokenno;
                     };

struct M2Quads__T3_r {
                       M2Quads_QuadOperator Operator;
                       unsigned int Operand1;
                       unsigned int Operand2;
                       unsigned int Operand3;
                       unsigned int Trash;
                       unsigned int Next;
                       unsigned int LineNo;
                       unsigned int TokenNo;
                       unsigned int NoOfTimesReferenced;
                       bool ConstExpr;
                       bool CheckType;
                       bool CheckOverflow;
                       unsigned int op1pos;
                       unsigned int op2pos;
                       unsigned int op3pos;
                     };

struct M2Quads__T4_r {
                       unsigned int RecordSym;
                       unsigned int RecordType;
                       unsigned int RecordRef;
                       unsigned int rw;
                       unsigned int RecordTokPos;
                     };

struct M2Quads__T5_r {
                       unsigned int IncrementQuad;
                       unsigned int StartOfForLoop;
                       unsigned int EndOfForLoop;
                       unsigned int ForLoopIndex;
                       unsigned int IndexTok;
                     };

struct M2Quads__T6_r {
                       unsigned int Line;
                       NameKey_Name File;
                       M2Quads_LineNote Next;
                     };

static M2StackAddress_StackOfAddress ConstructorStack;
static M2StackAddress_StackOfAddress LineStack;
static M2StackAddress_StackOfAddress BoolStack;
static M2StackAddress_StackOfAddress WithStack;
static M2StackWord_StackOfWord TryStack;
static M2StackWord_StackOfWord CatchStack;
static M2StackWord_StackOfWord ExceptStack;
static M2StackWord_StackOfWord ConstExprStack;
static M2StackWord_StackOfWord ConstParamStack;
static M2StackWord_StackOfWord AutoStack;
static M2StackWord_StackOfWord RepeatStack;
static M2StackWord_StackOfWord WhileStack;
static M2StackWord_StackOfWord ForStack;
static M2StackWord_StackOfWord ExitStack;
static M2StackWord_StackOfWord ReturnStack;
static M2StackWord_StackOfWord PriorityStack;
static bool SuppressWith;
static Indexing_Index QuadArray;
static unsigned int NextQuad;
static unsigned int FreeList;
static unsigned int CurrentProc;
static unsigned int InitQuad;
static unsigned int LastQuadNo;
static NameKey_Name ArithPlusTok;
static NameKey_Name LogicalOrTok;
static NameKey_Name LogicalAndTok;
static NameKey_Name LogicalXorTok;
static NameKey_Name LogicalDifferenceTok;
static bool InConstExpression;
static bool InConstParameters;
static bool IsAutoOn;
static bool MustNotCheckBounds;
static Indexing_Index ForInfo;
static unsigned int GrowInitialization;
static bool BuildingHigh;
static bool BuildingSize;
static bool QuadrupleGeneration;
static M2Quads_LineNote FreeLineList;
static Lists_List VarientFields;
static unsigned int VarientFieldNo;
static unsigned int NoOfQuads;
static unsigned int Head;
static unsigned int BreakQuad;

/*
   SetOptionCoding - builds a code quadruple if the profiling
                     option was given to the compiler.
*/

extern "C" void M2Quads_SetOptionCoding (bool b);

/*
   SetOptionProfiling - builds a profile quadruple if the profiling
                        option was given to the compiler.
*/

extern "C" void M2Quads_SetOptionProfiling (bool b);

/*
   SetOptionOptimizing - builds a quadruple to say that the optimization option
                         has been found in a comment.
*/

extern "C" void M2Quads_SetOptionOptimizing (bool b);

/*
   Opposite - returns the opposite comparison operator.
*/

extern "C" M2Quads_QuadOperator M2Quads_Opposite (M2Quads_QuadOperator Operator);

/*
   IsReferenced - returns true if QuadNo is referenced by another quadruple.
*/

extern "C" bool M2Quads_IsReferenced (unsigned int QuadNo);

/*
   IsBackReference - returns TRUE if quadruple, q, is referenced from a quad further on.
*/

extern "C" bool M2Quads_IsBackReference (unsigned int q);

/*
   IsUnConditional - returns true if QuadNo is an unconditional jump.
*/

extern "C" bool M2Quads_IsUnConditional (unsigned int QuadNo);

/*
   IsConditional - returns true if QuadNo is a conditional jump.
*/

extern "C" bool M2Quads_IsConditional (unsigned int QuadNo);

/*
   IsBackReferenceConditional - returns TRUE if quadruple, q, is referenced from
                                a conditional quad further on.
*/

extern "C" bool M2Quads_IsBackReferenceConditional (unsigned int q);

/*
   IsGoto - returns true if QuadNo is a goto operation.
*/

extern "C" bool M2Quads_IsGoto (unsigned int QuadNo);

/*
   IsCall - returns true if QuadNo is a call operation.
*/

extern "C" bool M2Quads_IsCall (unsigned int QuadNo);

/*
   IsReturn - returns true if QuadNo is a return operation.
*/

extern "C" bool M2Quads_IsReturn (unsigned int QuadNo);

/*
   IsProcedureScope - returns true if QuadNo is a ProcedureScope operation.
*/

extern "C" bool M2Quads_IsProcedureScope (unsigned int QuadNo);

/*
   IsNewLocalVar - returns true if QuadNo is a NewLocalVar operation.
*/

extern "C" bool M2Quads_IsNewLocalVar (unsigned int QuadNo);

/*
   IsKillLocalVar - returns true if QuadNo is a KillLocalVar operation.
*/

extern "C" bool M2Quads_IsKillLocalVar (unsigned int QuadNo);

/*
   IsCatchBegin - returns true if QuadNo is a catch begin quad.
*/

extern "C" bool M2Quads_IsCatchBegin (unsigned int QuadNo);

/*
   IsCatchEnd - returns true if QuadNo is a catch end quad.
*/

extern "C" bool M2Quads_IsCatchEnd (unsigned int QuadNo);

/*
   IsInitStart - returns true if QuadNo is a init start quad.
*/

extern "C" bool M2Quads_IsInitStart (unsigned int QuadNo);

/*
   IsInitEnd - returns true if QuadNo is a init end quad.
*/

extern "C" bool M2Quads_IsInitEnd (unsigned int QuadNo);

/*
   IsFinallyStart - returns true if QuadNo is a finally start quad.
*/

extern "C" bool M2Quads_IsFinallyStart (unsigned int QuadNo);

/*
   IsFinallyEnd - returns true if QuadNo is a finally end quad.
*/

extern "C" bool M2Quads_IsFinallyEnd (unsigned int QuadNo);

/*
   IsBecomes - return TRUE if QuadNo is a BecomesOp.
*/

extern "C" bool M2Quads_IsBecomes (unsigned int QuadNo);

/*
   IsDummy - return TRUE if QuadNo is a DummyOp.
*/

extern "C" bool M2Quads_IsDummy (unsigned int QuadNo);

/*
   IsQuadConstExpr - returns TRUE if QuadNo is part of a constant expression.
*/

extern "C" bool M2Quads_IsQuadConstExpr (unsigned int QuadNo);

/*
   SetQuadConstExpr - sets the constexpr field to value.
*/

extern "C" void M2Quads_SetQuadConstExpr (unsigned int QuadNo, bool value);

/*
   GetQuadDest - returns the jump destination associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadDest (unsigned int QuadNo);

/*
   GetQuadOp1 - returns the 1st operand associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadOp1 (unsigned int QuadNo);

/*
   GetQuadOp2 - returns the 2nd operand associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadOp2 (unsigned int QuadNo);

/*
   GetQuadOp3 - returns the 3rd operand associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadOp3 (unsigned int QuadNo);

/*
   IsInitialisingConst - returns TRUE if the quadruple is setting
                         a const (op1) with a value.
*/

extern "C" bool M2Quads_IsInitialisingConst (unsigned int QuadNo);

/*
   IsConstQuad - return TRUE if the quadruple is marked as a constexpr.
*/

extern "C" bool M2Quads_IsConstQuad (unsigned int quad);

/*
   IsConditionalBooleanQuad - return TRUE if operand 1 is a boolean result.
*/

extern "C" bool M2Quads_IsConditionalBooleanQuad (unsigned int quad);

/*
   IsOptimizeOn - returns true if the Optimize flag was true at QuadNo.
*/

extern "C" bool M2Quads_IsOptimizeOn (unsigned int QuadNo);

/*
   IsProfileOn - returns true if the Profile flag was true at QuadNo.
*/

extern "C" bool M2Quads_IsProfileOn (unsigned int QuadNo);

/*
   IsCodeOn - returns true if the Code flag was true at QuadNo.
*/

extern "C" bool M2Quads_IsCodeOn (unsigned int QuadNo);

/*
   IsPseudoQuad - returns true if QuadNo is a compiler directive.
                  ie code, profile and optimize.
                     StartFile, EndFile,
*/

extern "C" bool M2Quads_IsPseudoQuad (unsigned int QuadNo);

/*
   IsDefOrModFile - returns TRUE if QuadNo is a start of Module or Def file
                    directive.
*/

extern "C" bool M2Quads_IsDefOrModFile (unsigned int QuadNo);

/*
   DumpQuadruples - dump all quadruples providing the -fq, -fdump-lang-quad,
                    -fdump-lang-quad= or -fdump-lang-all were issued to the
                    command line.
*/

extern "C" void M2Quads_DumpQuadruples (const char *title_, unsigned int _title_high);

/*
   DisplayQuadRange - displays all quads in list range, start..end.
*/

extern "C" void M2Quads_DisplayQuadRange (unsigned int scope, unsigned int start, unsigned int end);

/*
   DisplayQuad - displays a quadruple, QuadNo.
*/

extern "C" void M2Quads_DisplayQuad (unsigned int QuadNo);

/*
   GetLastFileQuad - returns the Quadruple number of the last StartDefFile or
                     StartModFile quadruple.
*/

extern "C" unsigned int M2Quads_GetLastFileQuad (unsigned int QuadNo);

/*
   GetLastQuadNo - returns the last quadruple number referenced
                   by a GetQuad.
*/

extern "C" unsigned int M2Quads_GetLastQuadNo (void);

/*
   QuadToTokenNo - Converts a QuadNo into the approprate token number of the
                   source file, the line number is returned.

                   This may be used to yield an idea where abouts in the
                   source file the code generetion is
                   processing.
*/

extern "C" unsigned int M2Quads_QuadToTokenNo (unsigned int QuadNo);

/*
   QuadToLineNo - Converts a QuadNo into the approprate line number of the
                  source file, the line number is returned.

                  This may be used to yield an idea where abouts in the
                  source file the code generetion is
                  processing.
*/

extern "C" unsigned int M2Quads_QuadToLineNo (unsigned int QuadNo);

/*
   GetQuad - returns the Quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuad (unsigned int QuadNo, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3);

/*
   GetQuadOp - returns the operator for quad.
*/

extern "C" M2Quads_QuadOperator M2Quads_GetQuadOp (unsigned int quad);

/*
   GetM2OperatorDesc - returns the Modula-2 string associated with the quad operator
                       (if possible).  It returns NIL if no there is not an obvious match
                       in Modula-2.  It is assummed that the string will be used during
                       construction of error messages and therefore keywords are
                       wrapped with a format specifier.
*/

extern "C" DynamicStrings_String M2Quads_GetM2OperatorDesc (M2Quads_QuadOperator op);

/*
   GetQuadtok - returns the Quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuadtok (unsigned int QuadNo, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos);

/*
   GetQuadOtok - returns the Quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuadOtok (unsigned int QuadNo, unsigned int *tok, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, bool *overflowChecking, bool *constExpr, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos);

/*
   GetQuadOTypetok - returns the fields associated with quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuadOTypetok (unsigned int QuadNo, unsigned int *tok, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, bool *overflowChecking, bool *typeChecking, bool *constExpr, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos);

/*
   PutQuadOtok - alters a quadruple QuadNo with Op, Oper1, Oper2, Oper3, and
                 sets a boolean to determinine whether overflow should be checked.
*/

extern "C" void M2Quads_PutQuadOtok (unsigned int QuadNo, unsigned int tok, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflowChecking, bool constExpr, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos);

/*
   PutQuad - overwrites a quadruple QuadNo with Op, Oper1, Oper2, Oper3
*/

extern "C" void M2Quads_PutQuad (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3);

/*
   GetFirstQuad - returns the first quadruple.
*/

extern "C" unsigned int M2Quads_GetFirstQuad (void);

/*
   GetNextQuad - returns the Quadruple number following QuadNo.
*/

extern "C" unsigned int M2Quads_GetNextQuad (unsigned int QuadNo);

/*
   GetRealQuad - returns the Quadruple number of the real quadruple
                 at QuadNo or beyond.
*/

extern "C" unsigned int M2Quads_GetRealQuad (unsigned int QuadNo);

/*
   SubQuad - subtracts a quadruple QuadNo from a list Head.
*/

extern "C" void M2Quads_SubQuad (unsigned int QuadNo);

/*
   EraseQuad - erases a quadruple QuadNo, the quadruple is still in the list
               but wiped clean.
*/

extern "C" void M2Quads_EraseQuad (unsigned int QuadNo);

/*
   CountQuads - returns the number of quadruples.
*/

extern "C" unsigned int M2Quads_CountQuads (void);

/*
   BuildScaffold - generate the main, init, finish functions if
                   no -c and this is the application module.
*/

extern "C" void M2Quads_BuildScaffold (unsigned int tok, unsigned int moduleSym);

/*
   StartBuildDefFile - generates a StartFileDefOp quadruple indicating the file
                       that has produced the subsequent quadruples.
                       The code generator uses the StartDefFileOp quadruples
                       to relate any error to the appropriate file.


                       Entry                   Exit
                       =====                   ====


                Ptr ->                                        <- Ptr
                       +------------+          +------------+
                       | ModuleName |          | ModuleName |
                       |------------|          |------------|


                       Quadruples Produced

                       q     StartDefFileOp  _  _  ModuleSym
*/

extern "C" void M2Quads_StartBuildDefFile (unsigned int tok);

/*
   StartBuildModFile - generates a StartModFileOp quadruple indicating the file
                       that has produced the subsequent quadruples.
                       The code generator uses the StartModFileOp quadruples
                       to relate any error to the appropriate file.


                       Entry                   Exit
                       =====                   ====


                Ptr ->                                        <- Ptr
                       +------------+          +------------+
                       | ModuleName |          | ModuleName |
                       |------------|          |------------|


                       Quadruples Produced

                       q     StartModFileOp  lineno  filename  ModuleSym
*/

extern "C" void M2Quads_StartBuildModFile (unsigned int tok);

/*
   EndBuildFile - generates an EndFileOp quadruple indicating the file
                  that has produced the previous quadruples has ended.

                  Entry                   Exit
                  =====                   ====


           Ptr ->                                        <- Ptr
                  +------------+          +------------+
                  | ModuleName |          | ModuleName |
                  |------------|          |------------|


                  Quadruples Produced

                  q     EndFileOp  _  _  ModuleSym
*/

extern "C" void M2Quads_EndBuildFile (unsigned int tok);

/*
   StartBuildInit - Sets the start of initialization code of the
                    current module to the next quadruple.
*/

extern "C" void M2Quads_StartBuildInit (unsigned int tok);

/*
   EndBuildInit - Sets the end initialization code of a module.
*/

extern "C" void M2Quads_EndBuildInit (unsigned int tok);

/*
   StartBuildFinally - Sets the start of finalization code of the
                       current module to the next quadruple.
*/

extern "C" void M2Quads_StartBuildFinally (unsigned int tok);

/*
   EndBuildFinally - Sets the end finalization code of a module.
*/

extern "C" void M2Quads_EndBuildFinally (unsigned int tok);

/*
   BuildExceptInitial - adds an CatchBeginOp, CatchEndOp quadruple
                        in the current block.
*/

extern "C" void M2Quads_BuildExceptInitial (unsigned int tok);

/*
   BuildExceptFinally - adds an ExceptOp quadruple in a modules
                        finally block.
*/

extern "C" void M2Quads_BuildExceptFinally (unsigned int tok);

/*
   BuildExceptProcedure - adds an ExceptOp quadruple in a procedure
                          block.
*/

extern "C" void M2Quads_BuildExceptProcedure (unsigned int tok);

/*
   BuildRetry - adds an RetryOp quadruple.
*/

extern "C" void M2Quads_BuildRetry (unsigned int tok);

/*
   BuildReThrow - creates a ThrowOp _ _ NulSym, indicating that
                  the exception needs to be rethrown.  The stack
                  is unaltered.
*/

extern "C" void M2Quads_BuildReThrow (unsigned int tokenno);

/*
   StartBuildInnerInit - Sets the start of initialization code of the
                         inner module to the next quadruple.
*/

extern "C" void M2Quads_StartBuildInnerInit (unsigned int tok);

/*
   EndBuildInnerInit - Sets the end initialization code of a module.
*/

extern "C" void M2Quads_EndBuildInnerInit (unsigned int tok);

/*
   BuildBuiltinConst - makes reference to a builtin constant within gm2.

                              Entry                 Exit

                       Ptr ->
                              +------------+        +------------+
                              | Ident      |        | Sym        |
                              |------------|        |------------|

                       Quadruple produced:

                       q    Sym  BuiltinConstOp  Ident
*/

extern "C" void M2Quads_BuildBuiltinConst (void);

/*
   BuildBuiltinTypeInfo - make reference to a builtin typeinfo function
                          within gm2.

                                 Entry                 Exit

                          Ptr ->
                                 +-------------+
                                 | Type        |
                                 |-------------|       +------------+
                                 | Ident       |       | Sym        |
                                 |-------------|       |------------|

                          Quadruple produced:

                          q    Sym  BuiltinTypeInfoOp  Type Ident
*/

extern "C" void M2Quads_BuildBuiltinTypeInfo (void);

/*
   BuildAssignment - Builds an assignment from the values given on the
                     quad stack. Either an assignment to an
                     arithmetic expression or an assignment to a
                     boolean expression.  This procedure should not
                     be called in CONST declarations.
                     The Stack is expected to contain:


       Either

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Expression |
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  Expression

       OR

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | True |False|
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  TRUE
                     q+1   GotoOp                    q+3
                     q+2   BecomesOp  Designator  _  FALSE

*/

extern "C" void M2Quads_BuildAssignment (unsigned int becomesTokNo);

/*
   BuildAssignConstant - used to create constant in the CONST declaration.
                         The stack is expected to contain:

       Either

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Expression |
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  Expression

       OR

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | True |False|
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  TRUE
                     q+1   GotoOp                    q+3
                     q+2   BecomesOp  Designator  _  FALSE
*/

extern "C" void M2Quads_BuildAssignConstant (unsigned int equalsTokNo);

/*
   BuildAlignment - builds an assignment to an alignment constant.

                    The Stack is expected to contain:


                            Entry                   Exit
                            =====                   ====

                    Ptr ->
                            +---------------+
                            | Expression    |
                            |---------------|
                            | bytealignment |
                            |---------------|       empty
*/

extern "C" void M2Quads_BuildAlignment (unsigned int tokno);

/*
   BuildBitLength - builds an assignment to a bit length constant.

                    The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                    Ptr ->
                           +------------+
                           | Expression |
                           |------------|          empty
*/

extern "C" void M2Quads_BuildBitLength (unsigned int tokno);

/*
   BuildPragmaField - builds an assignment to an alignment constant.

                      The Stack is expected to contain:


                      Entry                   Exit
                      =====                   ====

               Ptr ->
                      +------------+
                      | Expression |
                      |------------|          empty
*/

extern "C" void M2Quads_BuildPragmaField (void);

/*
   BuildDefaultFieldAlignment - builds an assignment to an alignment constant.

                                The Stack is expected to contain:


                                       Entry                   Exit
                                       =====                   ====

                                Ptr ->
                                       +------------+
                                       | Expression |
                                       |------------|          empty
*/

extern "C" void M2Quads_BuildDefaultFieldAlignment (void);

/*
   BuildRepeat - Builds the repeat statement from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====


                 Empty
                                                        <- Ptr
                                         +------------+
                                         | RepeatQuad |
                                         |------------|

*/

extern "C" void M2Quads_BuildRepeat (void);

/*
   BuildUntil - Builds the until part of the repeat statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

        Ptr ->
                +------------+
                | t   | f    |
                |------------|
                | RepeatQuad |          Empty
                |------------|
*/

extern "C" void M2Quads_BuildUntil (void);

/*
   BuildWhile - Builds the While part of the While statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

                                                       <- Ptr
                                        |------------|
                Empty                   | WhileQuad  |
                                        |------------|
*/

extern "C" void M2Quads_BuildWhile (void);

/*
   BuildDoWhile - Builds the Do part of the while statement
                  from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

          Ptr ->
                  +------------+          +------------+
                  | t   | f    |          | 0    | f   |
                  |------------|          |------------|
                  | WhileQuad  |          | WhileQuad  |
                  |------------|          |------------|

                  Quadruples

                  BackPatch t exit to the NextQuad
*/

extern "C" void M2Quads_BuildDoWhile (void);

/*
   BuildEndWhile - Builds the end part of the while statement
                   from the quad stack.
                   The Stack is expected to contain:


                   Entry                   Exit
                   =====                   ====

           Ptr ->
                   +------------+
                   | t   | f    |
                   |------------|
                   | WhileQuad  |          Empty
                   |------------|

                   Quadruples

                   q    GotoOp  WhileQuad
                   False exit is backpatched with q+1
*/

extern "C" void M2Quads_BuildEndWhile (int reltokpos);

/*
   BuildLoop - Builds the Loop part of the Loop statement
               from the quad stack.
               The Stack is expected to contain:


               Entry                   Exit
               =====                   ====

                                                      <- Ptr
               Empty                   +------------+
                                       | LoopQuad   |
                                       |------------|
*/

extern "C" void M2Quads_BuildLoop (void);

/*
   BuildExit - Builds the Exit part of the Loop statement.
*/

extern "C" void M2Quads_BuildExit (void);

/*
   BuildEndLoop - Builds the End part of the Loop statement
                  from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

          Ptr ->
                  +------------+
                  | LoopQuad   |          Empty
                  |------------|

                  Quadruples

                  Goto  _  _  LoopQuad
*/

extern "C" void M2Quads_BuildEndLoop (void);

/*
   BuildThenIf - Builds the Then part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->                                          <- Ptr
                 +------------+          +------------+
                 | t   | f    |          | 0    | f   |
                 |------------|          |------------|

                 Quadruples

                 The true exit is BackPatched to point to
                 the NextQuad.
*/

extern "C" void M2Quads_BuildThenIf (void);

/*
   BuildElse - Builds the Else part of the If statement
               from the quad stack.
               The Stack is expected to contain:


               Entry                   Exit
               =====                   ====

       Ptr ->
               +------------+          +------------+
               | t   | f    |          | t+q  | 0   |
               |------------|          |------------|

               Quadruples

               q    GotoOp  _  _  0
               q+1  <- BackPatched from f
*/

extern "C" void M2Quads_BuildElse (void);

/*
   BuildEndIf - Builds the End part of the If statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

        Ptr ->
                +------------+
                | t   | f    |          Empty
                |------------|

                Quadruples

                Both t and f are backpatched to point to the NextQuad
*/

extern "C" void M2Quads_BuildEndIf (void);

/*
   BuildElsif1 - Builds the Elsif part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+          +------------+
                 | t   | f    |          | t+q  | 0   |
                 |------------|          |------------|

                 Quadruples

                 q    GotoOp  _  _  0
                 q+1  <- BackPatched from f
*/

extern "C" void M2Quads_BuildElsif1 (void);

/*
   BuildElsif2 - Builds the Elsif until part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

          Ptr ->
                 +--------------+
                 | 0    | f1    |                            <- Ptr
                 |--------------|          +---------------+
                 | t2   | f2    |          | t2    | f1+f2 |
                 |--------------|          |---------------|
*/

extern "C" void M2Quads_BuildElsif2 (void);

/*
   BuildForToByDo - Builds the For To By Do part of the For statement
                    from the quad stack.
                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

                                                               <- Ptr
                                            +----------------+
             Ptr ->                         | RangeId        |
                    +----------------+      |----------------|
                    | BySym | ByType |      | ForQuad        |
                    |----------------|      |----------------|
                    | e2             |      | LastValue      |
                    |----------------|      |----------------|
                    | e1             |      | BySym | ByType |
                    |----------------|      |----------------|
                    | Ident          |      | IdentSym       |
                    |----------------|      |----------------|


                    x := e1 ;
                    Note that LASTVALUE is calculated during M2GenGCC
                         after all the types have been resolved.
                    LASTVALUE := ((e2-e1) DIV BySym) * BySym + e1
                    IF BySym<0
                    THEN
                       IF e1<e2
                       THEN
                          goto exit
                       END
                    ELSE
                       IF e1>e2
                       THEN
                          goto exit
                       END
                    END ;
                    LOOP
                       body
                       IF x=LASTVALUE
                       THEN
                          goto exit
                       END ;
                       INC(x, BySym)
                    END

                    Quadruples:

                    q     BecomesOp  IdentSym  _  e1
                    q+    LastForIteratorOp  LastValue  := ((e1-e2) DIV by) * by + e1
                    q+1   if >=      by        0  q+..2
                    q+2   GotoOp                  q+3
                    q+3   If >=      e1  e2       q+5
                    q+4   GotoOp                  exit
                    q+5   ..
                    q+..1 Goto                    q+..5
                    q+..2 If >=      e2  e1       q+..4
                    q+..3 GotoOp                  exit
                    q+..4 ..

                    The For Loop is regarded:

                    For ident := e1 To e2 By by Do

                    End
*/

extern "C" void M2Quads_BuildForToByDo (void);

/*
   BuildPseudoBy - Builds the Non existant part of the By
                   clause of the For statement
                   from the quad stack.
                   The Stack is expected to contain:


                   Entry                   Exit
                   =====                   ====

                                                           <- Ptr
                                           +------------+
            Ptr ->                         | BySym | t  |
                   +------------+          |------------|
                   | e    | t   |          | e     | t  |
                   |------------|          |------------|
*/

extern "C" void M2Quads_BuildPseudoBy (void);

/*
   BuildEndFor - Builds the End part of the For statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +----------------+
                 | RangeId        |
                 |----------------|
                 | ForQuad        |
                 |----------------|
                 | LastValue      |
                 |----------------|
                 | BySym | ByType |
                 |----------------|
                 | IdSym          |      Empty
                 |----------------|
*/

extern "C" void M2Quads_BuildEndFor (unsigned int endpostok);

/*
   BuildCaseStart - starts the case statement.
                    It initializes a backpatch list on the compile
                    time stack, the list is used to contain all
                    case break points. The list is later backpatched
                    and contains all positions of the case statement
                    which jump to the end of the case statement.
                    The stack also contains room for a boolean
                    expression, this is needed to allow , operator
                    in the CaseField alternatives.

                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

                                                           <- Ptr
                                            +------------+
                                            | 0    | 0   |
                                            |------------|
                                            | 0    | 0   |
                    +-------------+         |------------|
                    | Expr |      |         | Expr |     |
                    |-------------|         |------------|
*/

extern "C" void M2Quads_BuildCaseStart (void);

/*
   BuildCaseStartStatementSequence - starts the statement sequence
                                     inside a case clause.
                                     BackPatches the true exit to the
                                     NextQuad.
                                     The Stack:

                                     Entry             Exit

                              Ptr ->                                  <- Ptr
                                     +-----------+     +------------+
                                     | t   | f   |     | 0   | f    |
                                     |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseStartStatementSequence (void);

/*
   BuildCaseEndStatementSequence - ends the statement sequence
                                   inside a case clause.
                                   BackPatches the false exit f1 to the
                                   NextQuad.
                                   Asserts that t1 and f2 is 0
                                   Pushes t2+q and 0

                                   Quadruples:

                                   q  GotoOp  _  _  0

                                   The Stack:

                                   Entry             Exit

                            Ptr ->                                  <- Ptr
                                   +-----------+     +------------+
                                   | t1  | f1  |     | 0    | 0   |
                                   |-----------|     |------------|
                                   | t2  | f2  |     | t2+q | 0   |
                                   |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseEndStatementSequence (void);

/*
   BuildCaseRange - builds the range testing quaruples for
                    a case clause.

                    IF (e1>=ce1) AND (e1<=ce2)
                    THEN

                    ELS..

                    The Stack:

                    Entry             Exit

             Ptr ->
                    +-----------+
                    | ce2       |                   <- Ptr
                    |-----------|     +-----------+
                    | ce1       |     | t   | f   |
                    |-----------|     |-----------|
                    | t1  | f1  |     | t1  | f1  |
                    |-----------|     |-----------|
                    | t2  | f2  |     | t2  | f2  |
                    |-----------|     |-----------|
                    | e1        |     | e1        |
                    |-----------|     |-----------|
*/

extern "C" void M2Quads_BuildCaseRange (void);

/*
   BuildCaseEquality - builds the range testing quadruples for
                       a case clause.

                       IF e1=ce1
                       THEN

                       ELS..

                       The Stack:

                       Entry             Exit

                Ptr ->
                       +-----------+     +-----------+
                       | ce1       |     | t   | f   |
                       |-----------|     |-----------|
                       | t1  | f1  |     | t1  | f1  |
                       |-----------|     |-----------|
                       | t2  | f2  |     | t2  | f2  |
                       |-----------|     |-----------|
                       | e1        |     | e1        |
                       |-----------|     |-----------|
*/

extern "C" void M2Quads_BuildCaseEquality (void);

/*
   BuildCaseList - merges two case tests into one

                   The Stack:

                   Entry             Exit

            Ptr ->
                   +-----------+
                   | t2  | f2  |
                   |-----------|     +-------------+
                   | t1  | f1  |     | t1+t2| f1+f2|
                   |-----------|     |-------------|
*/

extern "C" void M2Quads_BuildCaseList (void);

/*
   BuildCaseOr - builds the , in the case clause.

                 The Stack:

                 Entry             Exit

          Ptr ->                                  <- Ptr
                 +-----------+     +------------+
                 | t   | f   |     | t    | 0   |
                 |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseOr (void);

/*
   BuildCaseElse - builds the else of case clause.

                  The Stack:

                  Entry             Exit

           Ptr ->                                  <- Ptr
                  +-----------+     +------------+
                  | t   | f   |     | t    | 0   |
                  |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseElse (void);

/*
   BuildCaseEnd - builds the end of case clause.

                  The Stack:

                  Entry             Exit

           Ptr ->
                  +-----------+
                  | t1  | f1  |
                  |-----------|
                  | t2  | f2  |
                  |-----------|
                  | e1        |
                  |-----------|     Empty
*/

extern "C" void M2Quads_BuildCaseEnd (void);

/*
   BuildCaseCheck - builds the case checking code to ensure that
                    the program does not need an else clause at runtime.
                    The stack is unaltered.
*/

extern "C" void M2Quads_BuildCaseCheck (void);

/*
   BuildNulParam - Builds a nul parameter on the stack.
                   The Stack:

                   Entry             Exit

                                                    <- Ptr
                   Empty             +------------+
                                     | 0          |
                                     |------------|
*/

extern "C" void M2Quads_BuildNulParam (void);

/*
   BuildProcedureCall - builds a procedure call.
                        Although this procedure does not directly
                        destroy the procedure parameters, it calls
                        routine which will manipulate the stack and
                        so the entry and exit states of the stack are shown.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

extern "C" void M2Quads_BuildProcedureCall (unsigned int tokno);

/*
   CheckBuildFunction - checks to see whether ProcSym is a function
                        and if so it adds a TempSym value which will
                        hold the return value once the function finishes.
                        This procedure also generates an error message
                        if the user is calling a function and ignoring
                        the return result.  The additional TempSym
                        is not created if ProcSym is a procedure
                        and the stack is unaltered.

                        The Stack:


                       Entry                      Exit

                Ptr ->

                                                  +----------------+
                                                  | ProcSym | Type |
                       +----------------+         |----------------|
                       | ProcSym | Type |         | TempSym | Type |
                       |----------------|         |----------------|
*/

extern "C" bool M2Quads_CheckBuildFunction (void);

/*
   BuildFunctionCall - builds a function call.
                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|
*/

extern "C" void M2Quads_BuildFunctionCall (bool ConstExpr);

/*
   BuildConstFunctionCall - builds a function call and checks that this function can be
                            called inside a ConstExpression.

                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |                        <- Ptr
                            |----------------|         +------------+
                            | ProcSym | Type |         | ReturnVar  |
                            |----------------|         |------------|

*/

extern "C" void M2Quads_BuildConstFunctionCall (void);

/*
   BuildBooleanVariable - tests to see whether top of stack is a boolean
                          conditional and if so it converts it into a boolean
                          variable.
*/

extern "C" void M2Quads_BuildBooleanVariable (void);

/*
   BuildModuleStart - starts current module scope.
*/

extern "C" void M2Quads_BuildModuleStart (unsigned int tok);

/*
   BuildProcedureStart - Builds start of the procedure. Generates a
                         quadruple which indicated the start of
                         this procedure declarations scope.
                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
                        | Name       |          | Name      |
                        |------------|          |-----------|


                        Quadruples:

                        q   ProcedureScopeOp  Line#  Scope  ProcSym
*/

extern "C" void M2Quads_BuildProcedureStart (void);

/*
   BuildProcedureBegin - determines the start of the BEGIN END block of
                         the procedure.
                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
                        | Name       |          | Name      |
                        |------------|          |-----------|


                        Quadruples:

                        q   NewLocalVarOp  TokenNo(BEGIN)  _  ProcSym
*/

extern "C" void M2Quads_BuildProcedureBegin (void);

/*
   BuildProcedureEnd - Builds end of the procedure. Destroys space for
                       the local variables.
                       The Stack is expected to contain:


                       Entry                   Exit
                       =====                   ====

                Ptr ->                                       <- Ptr
                       +------------+          +-----------+
                       | ProcSym    |          | ProcSym   |
                       |------------|          |-----------|
                       | Name       |          | Name      |
                       |------------|          |-----------|


                       Quadruples:

                       q   KillLocalVarOp  TokenNo(END)  _  ProcSym
*/

extern "C" void M2Quads_BuildProcedureEnd (void);

/*
   BuildReturn - Builds the Return part of the procedure.
                 tokreturn is the location of the RETURN keyword.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+
                 | e1         |          Empty
                 |------------|
*/

extern "C" void M2Quads_BuildReturn (unsigned int tokreturn);

/*
   BuildModulePriority - assigns the current module with a priority
                         from the top of stack.

                         Entry                   Exit
                         =====                   ====


                  Ptr ->                         Empty
                         +------------+
                         | Priority   |
                         |------------|
*/

extern "C" void M2Quads_BuildModulePriority (void);

/*
   StartBuildWith - performs the with statement.
                    The Stack:

                    Entry                    Exit

                    +------------+
                    | Sym | Type |           Empty
                    |------------|
*/

extern "C" void M2Quads_StartBuildWith (unsigned int withTok);

/*
   EndBuildWith - terminates the innermost with scope.
*/

extern "C" void M2Quads_EndBuildWith (void);

/*
   CheckWithReference - performs the with statement.
                        The Stack:

                        Entry                    Exit

                        +------------+           +------------+
                        | Sym | Type |           | Sym | Type |
                        |------------|           |------------|
*/

extern "C" void M2Quads_CheckWithReference (void);

/*
   BuildDesignatorRecord - Builds the record referencing.
                           The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                   Ptr ->
                           +--------------+
                           | n            |
                           |--------------|
                           | fld1 | type1 |
                           |--------------|
                           .              .
                           .              .
                           .              .
                           |--------------|
                           | fldn | typen |                        <- Ptr
                           |--------------|        +-------------+
                           | Sym  | Type  |        | S    | type1|
                           |--------------|        |-------------|
*/

extern "C" void M2Quads_BuildDesignatorRecord (unsigned int dottok);

/*
   BuildDesignatorArray - Builds the array referencing.
                          The purpose of this procedure is to work out
                          whether the DesignatorArray is a constant string or
                          dynamic array/static array and to call the appropriate
                          BuildRoutine.

                          The Stack is expected to contain:

                          Entry                   Exit
                          =====                   ====

                  Ptr ->
                          +--------------+
                          | e            |                        <- Ptr
                          |--------------|        +------------+
                          | Sym  | Type  |        | S    | T   |
                          |--------------|        |------------|
*/

extern "C" void M2Quads_BuildDesignatorArray (void);

/*
   BuildDesignatorPointer - Builds a pointer reference.
                            The Stack is expected to contain:


                            Entry                   Exit
                            =====                   ====

                    Ptr ->                                           <- Ptr
                            +--------------+        +--------------+
                            | Sym1  | Type1|        | Sym2  | Type2|
                            |--------------|        |--------------|
*/

extern "C" void M2Quads_BuildDesignatorPointer (unsigned int ptrtok);

/*
   BuildNulExpression - Builds a nul expression on the stack.
                        The Stack:

                        Entry             Exit

                                                         <- Ptr
                        Empty             +------------+
                                          | NulSym     |
                                          |------------|
   tokpos is the position of the RETURN token.
*/

extern "C" void M2Quads_BuildNulExpression (unsigned int tokpos);

/*
   BuildSetStart - Pushes a Bitset type on the stack.

                      The Stack:

                      Entry             Exit

               Ptr ->                                        <- Ptr

                      Empty             +--------------+
                                        | Bitset       |
                                        |--------------|
*/

extern "C" void M2Quads_BuildSetStart (unsigned int tokpos);

/*
   BuildSetEnd - pops the set value and type from the stack
                 and pushes the value,type pair.

                    Entry                   Exit

             Ptr ->
                    +--------------+
                    | Set Value    |                         <- Ptr
                    |--------------|        +--------------+
                    | Set Type     |        | Value | Type |
                    |--------------|        |--------------|
*/

extern "C" void M2Quads_BuildSetEnd (void);

/*
   BuildEmptySet - Builds an empty set on the stack.
                   The Stack:

                   Entry             Exit

                                                     <- Ptr
                                     +-------------+
            Ptr ->                   | Value       |
                   +-----------+     |-------------|
      	       	   | SetType   |     | SetType     |
                   |-----------|     |-------------|

   tokpos points to the opening '{'.
*/

extern "C" void M2Quads_BuildEmptySet (unsigned int tokpos);

/*
   BuildInclRange - includes a set range with a set.


                          Entry                   Exit
                          =====                   ====


                   Ptr ->
                          +------------+
                          | El2        |
                          |------------|
                          | El1        |                                 <- Ptr
                          |------------|           +-------------------+
                          | Set Value  |           | Value + {El1..El2}|
                          |------------|           |-------------------|

                   No quadruples produced as the range info is contained within
                   the set value.
*/

extern "C" void M2Quads_BuildInclRange (void);

/*
   BuildInclBit - includes a bit into the set.

                         Entry                   Exit
                         =====                   ====


                  Ptr ->
                         +------------+
                         | Element    |                         <- Ptr
                         |------------|          +------------+
                         | Value      |          | Value      |
                         |------------|          |------------|

*/

extern "C" void M2Quads_BuildInclBit (void);

/*
   SilentBuildConstructor - places NulSym into the constructor fifo queue.
*/

extern "C" void M2Quads_SilentBuildConstructor (void);

/*
   SilentBuildConstructorStart - removes an entry from the constructor fifo queue.
*/

extern "C" void M2Quads_SilentBuildConstructorStart (void);

/*
   BuildConstructor - builds a constructor.
                      Stack

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | Type       |                <- Ptr
                      |------------+
*/

extern "C" void M2Quads_BuildConstructor (unsigned int tokcbrpos);

/*
   BuildConstructorStart - builds a constructor.
                           Stack

                           Entry                 Exit

                    Ptr ->                                          <- Ptr
                           +------------+        +----------------+
                           | Type       |        | ConstructorSym |
                           |------------+        |----------------|
*/

extern "C" void M2Quads_BuildConstructorStart (unsigned int cbratokpos);

/*
   BuildConstructorEnd - removes the current constructor frame from the
                         constructor stack (it does not effect the quad
                         stack)

                         Entry                 Exit

                  Ptr ->                                      <- Ptr
                         +------------+        +------------+
                         | const      |        | const      |
                         |------------|        |------------|

   startpos is the start of the constructor, either the typename or '{'
   cbratokpos is the '}'.
*/

extern "C" void M2Quads_BuildConstructorEnd (unsigned int startpos, unsigned int cbratokpos);

/*
   NextConstructorField - increments the top of constructor stacks index by one.
*/

extern "C" void M2Quads_NextConstructorField (void);

/*
   BuildTypeForConstructor - pushes the type implied by the current constructor.
                             If no constructor is currently being built then
                             it Pushes a Bitset type.
*/

extern "C" void M2Quads_BuildTypeForConstructor (unsigned int tokpos);

/*
   BuildComponentValue -  builds a component value.

                          Entry                 Exit

                   Ptr ->                                      <- Ptr


                          +------------+        +------------+
                          | const      |        | const      |
                          |------------|        |------------|
*/

extern "C" void M2Quads_BuildComponentValue (void);

/*
   PopConstructor - removes the top constructor from the top of stack.
*/

extern "C" void M2Quads_PopConstructor (void);

/*
   BuildNot   - Builds a NOT operation from the quad stack.
                The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

           Ptr ->                                        <- Ptr
                  +------------+          +------------+
                  | t    | f   |          | f    | t   |
                  |------------|          |------------|
*/

extern "C" void M2Quads_BuildNot (unsigned int notTokPos);

/*
   RecordOp - Records the operator passed on the stack.
              This is called when a boolean operator is found in an
              expression.  It is called just after the lhs has been built
              and pushed to the quad stack and prior to the rhs build.
              It checks to see if AND OR or equality tests are required.
              It will short circuit AND and OR expressions.  It also
              converts a lhs to a boolean variable if an xor comparison
              is about to be performed.

              Checks for AND operator or OR operator
              if either of these operators are found then BackPatching
              takes place.
              The Expected Stack:

              Entry                        Exit

       Ptr ->                                               <- Ptr
              +-------------+               +-------------+
              | OperatorTok |               | OperatorTok |
              |-------------|               |-------------|
              | t    | f    |               | t    | f    |
              |-------------|               |-------------|


              If OperatorTok=AndTok
              Then
                 BackPatch(f, NextQuad)
              Elsif OperatorTok=OrTok
              Then
                 BackPatch(t, NextQuad)
              End
*/

extern "C" void M2Quads_RecordOp (void);

/*
   BuildRelOp   - Builds a relative operation from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

           Ptr ->
                  +------------+
                  | e1         |
                  |------------|                          <- Ptr
                  | Operator   |
                  |------------|          +------------+
                  | e2         |          | t    | f   |
                  |------------|          |------------|


                    Quadruples Produced

                    q     IFOperator  e2  e1  TrueExit    ; e2  e1 since
                    q+1   GotoOp              FalseExit   ; relation > etc
                                                          ; requires order.
*/

extern "C" void M2Quads_BuildRelOp (unsigned int optokpos);

/*
   BuildBinaryOp   - Builds a binary operation from the quad stack.
                     Be aware that this procedure will check for
                     the overloading of the bitset operators + - \ *.
                     So do NOT call this procedure if you are building
                     a reference to an array which has a bitset type or
                     the address arithmetic will be wrongly coersed into
                     logical ORs.

                     The Stack is expected to contain:


                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Sym1       |
                     |------------|
                     | Operator   |                          <- Ptr
                     |------------|          +------------+
                     | Sym2       |          | Temporary  |
                     |------------|          |------------|


                     Quadruples Produced

                     q     Operator  Temporary  Sym1  Sym2


                OR


                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | T1   | F1  |
                     |------------|
                     | OrTok      |                          <- Ptr
                     |------------|          +------------+
                     | T2   | F2  |          | T1+T2| F1  |
                     |------------|          |------------|


                     Quadruples Produced

*/

extern "C" void M2Quads_BuildBinaryOp (void);

/*
   BuildUnaryOp   - Builds a unary operation from the quad stack.
                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

             Ptr ->
                    +------------+
                    | Sym        |
                    |------------|          +------------+
                    | Operator   |          | Temporary  | <- Ptr
                    |------------|          |------------|


                    Quadruples Produced

                    q     Operator  Temporary  _ Sym

*/

extern "C" void M2Quads_BuildUnaryOp (void);

/*
   OperandT - returns the ident operand stored in the true position on the boolean stack.
*/

extern "C" unsigned int M2Quads_OperandT (unsigned int pos);

/*
   OperandF - returns the ident operand stored in the false position on the boolean stack.
*/

extern "C" unsigned int M2Quads_OperandF (unsigned int pos);

/*
   PushTF - Push a True and False numbers onto the True/False stack.
            True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTF (unsigned int True, unsigned int False);

/*
   PopTF - Pop a True and False number from the True/False stack.
           True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PopTF (unsigned int *True, unsigned int *False);

/*
   PushT - Push an item onto the stack in the T (true) position.
*/

extern "C" void M2Quads_PushT (unsigned int True);

/*
   PopT - Pops the T value from the stack.
*/

extern "C" void M2Quads_PopT (unsigned int *True);

/*
   PushTtok - Push an item onto the stack in the T (true) position,
              it is assummed to be a token and its token location is recorded.
*/

extern "C" void M2Quads_PushTtok (unsigned int True, unsigned int tokno);

/*
   PushTFtok - Push an item onto the stack in the T (true) position,
               it is assummed to be a token and its token location is recorded.
*/

extern "C" void M2Quads_PushTFtok (unsigned int True, unsigned int False, unsigned int tokno);

/*
   PopTFtok - Pop T/F/tok from the stack.
*/

extern "C" void M2Quads_PopTFtok (unsigned int *True, unsigned int *False, unsigned int *tokno);

/*
   PushTFAtok - Push T/F/A/tok to the stack.
*/

extern "C" void M2Quads_PushTFAtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int tokno);

/*
   PopTtok - Pops the T value from the stack and token position.
*/

extern "C" void M2Quads_PopTtok (unsigned int *True, unsigned int *tok);

/*
   PushTFn - Push a True and False numbers onto the True/False stack.
             True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTFn (unsigned int True, unsigned int False, unsigned int n);

/*
   PushTFntok - Push a True and False numbers onto the True/False stack.
                True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTFntok (unsigned int True, unsigned int False, unsigned int n, unsigned int tokno);

/*
   PopTFn - Pop a True and False number from the True/False stack.
            True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PopTFn (unsigned int *True, unsigned int *False, unsigned int *n);

/*
   PopNothing - pops the top element on the boolean stack.
*/

extern "C" void M2Quads_PopNothing (void);

/*
   PopN - pops multiple elements from the BoolStack.
*/

extern "C" void M2Quads_PopN (unsigned int n);

/*
   PushTFA - Push True, False, Array, numbers onto the
             True/False stack.  True and False are assumed to
             contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTFA (unsigned int True, unsigned int False, unsigned int Array);

/*
   OperandTok - returns the token associated with pos, on the stack.
*/

extern "C" unsigned int M2Quads_OperandTok (unsigned int pos);

/*
   OperandA - returns possible array symbol associated with the ident
              operand stored on the boolean stack.
*/

extern "C" unsigned int M2Quads_OperandA (unsigned int pos);

/*
   OperandAnno - returns the annotation string associated with the
                 position, n, on the stack.
*/

extern "C" DynamicStrings_String M2Quads_OperandAnno (unsigned int n);

/*
   Annotate - annotate the top of stack.
*/

extern "C" void M2Quads_Annotate (const char *a_, unsigned int _a_high);

/*
   DisplayStack - displays the compile time symbol stack.
*/

extern "C" void M2Quads_DisplayStack (void);

/*
   Top - returns the no of items held in the stack.
*/

extern "C" unsigned int M2Quads_Top (void);

/*
   DupFrame - duplicate the top of stack and push the new frame.
*/

extern "C" void M2Quads_DupFrame (void);

/*
   WriteOperand - displays the operands name, symbol id and mode of addressing.
*/

extern "C" void M2Quads_WriteOperand (unsigned int Sym);

/*
   BeginVarient - begin a varient record.
*/

extern "C" void M2Quads_BeginVarient (void);

/*
   EndVarient - end a varient record.
*/

extern "C" void M2Quads_EndVarient (void);

/*
   ElseVarient - associate an ELSE clause with a varient record.
*/

extern "C" void M2Quads_ElseVarient (void);

/*
   BeginVarientList - begin an ident list containing ranges belonging to a
                      varient list.
*/

extern "C" void M2Quads_BeginVarientList (void);

/*
   EndVarientList - end a range list for a varient field.
*/

extern "C" void M2Quads_EndVarientList (void);

/*
   AddRecordToList - adds the record held on the top of stack to the
                     list of records and varient fields.
*/

extern "C" void M2Quads_AddRecordToList (void);

/*
   AddVarientToList - adds varient held on the top of stack to the list.
*/

extern "C" void M2Quads_AddVarientToList (void);

/*
   AddVarientFieldToList - adds varient field, f, to the list of all varient
                           fields created.
*/

extern "C" void M2Quads_AddVarientFieldToList (unsigned int f);

/*
   AddVarientRange - creates a range from the top two contant expressions
                     on the stack which are recorded with the current
                     varient field.  The stack is unaltered.
*/

extern "C" void M2Quads_AddVarientRange (void);

/*
   AddVarientEquality - adds the contant expression on the top of the stack
                        to the current varient field being recorded.
                        The stack is unaltered.
*/

extern "C" void M2Quads_AddVarientEquality (void);

/*
   BuildCodeOn - generates a quadruple declaring that code should be
                 emmitted from henceforth.

                 The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildCodeOn (void);

/*
   BuildCodeOff - generates a quadruple declaring that code should not be
                  emmitted from henceforth.

                  The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildCodeOff (void);

/*
   BuildProfileOn - generates a quadruple declaring that profile timings
                    should be emmitted from henceforth.

                    The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildProfileOn (void);
extern "C" void M2Quads_BuildProfileOff (void);

/*
   BuildOptimizeOn - generates a quadruple declaring that optimization
                     should occur from henceforth.

                     The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildOptimizeOn (void);

/*
   BuildOptimizeOff - generates a quadruple declaring that optimization
                      should not occur from henceforth.

                      The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildOptimizeOff (void);

/*
   BuildAsm - builds an Inline pseudo quadruple operator.
              The inline interface, Sym, is stored as the operand
              to the operator InlineOp.

              The stack is expected to contain:


                        Entry                   Exit
                        =====                   ====

              Ptr ->
                     +--------------+
                     | Sym          |        Empty
                     |--------------|
*/

extern "C" void M2Quads_BuildAsm (unsigned int tok);

/*
   BuildLineNo - builds a LineNumberOp pseudo quadruple operator.
                 This quadruple indicates which source line has been
                 processed, these quadruples are only generated if we
                 are producing runtime debugging information.

                 The stack is not affected, read or altered in any way.


                        Entry                   Exit
                        =====                   ====

                 Ptr ->                              <- Ptr
*/

extern "C" void M2Quads_BuildLineNo (void);

/*
   PushLineNo - pushes the current file and line number to the stack.
*/

extern "C" void M2Quads_PushLineNo (void);

/*
   BuildStmtNote - builds a StatementNoteOp pseudo quadruple operator.
                   This quadruple indicates which source line has been
                   processed and it represents the start of a statement
                   sequence.
                   It differs from LineNumberOp in that multiple successive
                   LineNumberOps will be removed and the final one is attached to
                   the next real GCC tree.  Whereas a StatementNoteOp is always left
                   alone.  Depending upon the debugging level it will issue a nop
                   instruction to ensure that the gdb single step will step into
                   this line.  Practically it allows pedalogical debugging to
                   occur when there is syntax sugar such as:


                         END   step 
                      END   step 
                   END ;  step 
		   a := 1 ;  step 

                   REPEAT  step 
		      i := 1   step 

                   The stack is not affected, read or altered in any way.


                        Entry                   Exit
                        =====                   ====

                 Ptr ->                              <- Ptr
*/

extern "C" void M2Quads_BuildStmtNote (int offset);

/*
   LoopAnalysis - checks whether an infinite loop exists.
*/

extern "C" void M2Quads_LoopAnalysis (unsigned int Scope, unsigned int Current, unsigned int End);

/*
   ForLoopAnalysis - checks all the FOR loops for index variable manipulation
                     and dangerous usage outside the loop.
*/

extern "C" void M2Quads_ForLoopAnalysis (void);

/*
   BuildSizeCheckStart - switches off all quadruple generation if the function SIZE or HIGH
                         is being "called".  This should be done as SIZE only requires the
                         actual type of the expression, not its value.  Consider the problem of
                         SIZE(UninitializedPointer^) which is quite legal and it must
                         also be safe!
                         ISO Modula-2 also allows HIGH(a[0]) for a two dimensional array
                         and there is no need to compute a[0], we just need to follow the
                         type and count dimensions.  However if SIZE(a) or HIGH(a) occurs
                         and, a, is an unbounded array then we turn on quadruple generation.

                         The Stack is expected to contain:


                         Entry                       Exit
                         =====                       ====

                 Ptr ->                                                       <- Ptr
                        +----------------------+     +----------------------+
                        | ProcSym | Type | tok |     | ProcSym | Type | tok |
                        |----------------------|     |----------------------|
*/

extern "C" void M2Quads_BuildSizeCheckStart (void);

/*
   BackPatchSubrangesAndOptParam - runs through all the quadruples and finds SubrangeLow or SubrangeHigh
                                   quadruples and replaces it by an assignment to the Low or High component
                                   of the subrange type.

                                   Input:
                                   SubrangeLow    op1     op3          op3 is a subrange 

                                   Output:
                                   Becomes        op1     low

                                   Input:
                                   SubrangeHigh   op1     op3          op3 is a subrange 

                                   Output:
                                   Becomes        op1     high

                                   Input:
                                   OptParam       op1     op2    op3

                                   Output:
                                   Param          op1     op2    GetOptArgInit(op3)
*/

extern "C" void M2Quads_BackPatchSubrangesAndOptParam (void);

/*
   WriteOperator - writes the name of the quadruple operator.
*/

extern "C" void M2Quads_WriteOperator (M2Quads_QuadOperator Operator);

/*
   PushAutoOn - push the auto flag and then set it to TRUE.
                Any call to ident in the parser will result in the token being pushed.
*/

extern "C" void M2Quads_PushAutoOn (void);

/*
   PushAutoOff - push the auto flag and then set it to FALSE.
*/

extern "C" void M2Quads_PushAutoOff (void);

/*
   IsAutoPushOn - returns the value of the current Auto ident push flag.
*/

extern "C" bool M2Quads_IsAutoPushOn (void);

/*
   PopAuto - restores the previous value of the Auto flag.
*/

extern "C" void M2Quads_PopAuto (void);

/*
   MustCheckOverflow - returns TRUE if the quadruple should test for overflow.
*/

extern "C" bool M2Quads_MustCheckOverflow (unsigned int q);

/*
   PushInConstExpression - push the InConstExpression flag and then set it to TRUE.
*/

extern "C" void M2Quads_PushInConstExpression (void);

/*
   PopInConstExpression - restores the previous value of the InConstExpression.
*/

extern "C" void M2Quads_PopInConstExpression (void);

/*
   IsInConstExpression - returns the value of the InConstExpression.
*/

extern "C" bool M2Quads_IsInConstExpression (void);

/*
   PushInConstParameters - push the InConstParameters flag and then set it to TRUE.
*/

extern "C" void M2Quads_PushInConstParameters (void);

/*
   PopInConstParameters - restores the previous value of the InConstParameters.
*/

extern "C" void M2Quads_PopInConstParameters (void);

/*
   IsInConstParameters - returns the value of the InConstParameters.
*/

extern "C" bool M2Quads_IsInConstParameters (void);

/*
   BuildAsmElement - the stack is expected to contain:


                        Entry                      Exit
                        =====                      ====

                 Ptr ->
                        +------------------+
                        | expr | tokpos    |
                        |------------------|
                        | str              |
                        |------------------|
                        | name             |
                        |------------------|       +------------------+
                        | CurrentInterface |       | CurrentInterface |
                        |------------------|       |------------------|
                        | CurrentAsm       |       | CurrentAsm       |
                        |------------------|       |------------------|
                        | n                |       | n                |
                        |------------------|       |------------------|
*/

extern "C" void M2Quads_BuildAsmElement (bool input, bool output);

/*
   BuildAsmTrash - the stack is expected to contain:


                        Entry                      Exit
                        =====                      ====

                 Ptr ->
                        +------------------+
                        | expr | tokpos    |
                        |------------------|       +------------------+
                        | CurrentInterface |       | CurrentInterface |
                        |------------------|       |------------------|
                        | CurrentAsm       |       | CurrentAsm       |
                        |------------------|       |------------------|
                        | n                |       | n                |
                        |------------------|       |------------------|
*/

extern "C" void M2Quads_BuildAsmTrash (void);

/*
   GetQuadTrash - return the symbol associated with the trashed operand.
*/

extern "C" unsigned int M2Quads_GetQuadTrash (unsigned int quad);

/*
   DSdbEnter -
*/

static void DSdbEnter (void);

/*
   DSdbExit -
*/

static void DSdbExit (void);

/*
   GetQF - returns the QuadFrame associated with, q.
*/

static M2Quads_QuadFrame GetQF (unsigned int q);

/*
   IsQuadA - returns true if QuadNo is a op.
*/

static bool IsQuadA (unsigned int QuadNo, M2Quads_QuadOperator op);

/*
   OpUsesOp1 - return TRUE if op allows op1.
*/

static bool OpUsesOp1 (M2Quads_QuadOperator op);

/*
   AddQuadInformation - adds variable analysis and jump analysis to the new quadruple.
*/

static void AddQuadInformation (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3);

/*
   PutQuadO - alters a quadruple QuadNo with Op, Oper1, Oper2, Oper3, and
              sets a boolean to determinine whether overflow should be checked.
*/

static void PutQuadO (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflow);

/*
   PutQuadOType -
*/

static void PutQuadOType (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflow, bool checktype);

/*
   UndoReadWriteInfo -
*/

static void UndoReadWriteInfo (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3);

/*
   CheckAddTuple2Read - checks to see whether symbol tuple contains variables or
                        parameters and if so it then adds them to the quadruple
                        variable list.
*/

static void CheckAddTuple2Read (unsigned int tuple, bool canDereference, unsigned int Quad);

/*
   CheckAddVariableRead - checks to see whether symbol, Sym, is a variable or
                          a parameter and if so it then adds this quadruple
                          to the variable list.
*/

static void CheckAddVariableRead (unsigned int Sym, bool canDereference, unsigned int Quad);

/*
   CheckRemoveVariableRead - checks to see whether, Sym, is a variable or
                             a parameter and if so then it removes the
                             quadruple from the variable list.
*/

static void CheckRemoveVariableRead (unsigned int Sym, bool canDereference, unsigned int Quad);

/*
   CheckAddVariableWrite - checks to see whether symbol, Sym, is a variable and
                           if so it then adds this quadruple to the variable list.
*/

static void CheckAddVariableWrite (unsigned int Sym, bool canDereference, unsigned int Quad);

/*
   CheckRemoveVariableWrite - checks to see whether, Sym, is a variable and
                              if so then it removes the quadruple from the
                              variable list.
*/

static void CheckRemoveVariableWrite (unsigned int Sym, bool canDereference, unsigned int Quad);

/*
   CheckConst -
*/

static void CheckConst (unsigned int sym);

/*
   AlterReference - alters all references from OldQuad, to NewQuad in a
                    quadruple list Head.
*/

static void AlterReference (unsigned int Head, unsigned int OldQuad, unsigned int NewQuad);

/*
   GrowQuads - grows the list of quadruples to the quadruple, to.
*/

static void GrowQuads (unsigned int to);

/*
   ManipulateReference - manipulates the quadruple, q, so that it now points to quad, to.
*/

static void ManipulateReference (unsigned int q, unsigned int to);

/*
   RemoveReference - remove the reference by quadruple q to wherever
                     it was pointing.
*/

static void RemoveReference (unsigned int q);

/*
   NewQuad - sets QuadNo to a new quadruple.
*/

static void NewQuad (unsigned int *QuadNo);

/*
   CheckVariableAt - checks to see whether, sym, was declared at a particular address.
*/

static void CheckVariableAt (unsigned int sym);

/*
   CheckVariablesAt - checks to see whether we need to initialize any pointers
                      which point to variable declared at addresses.
*/

static void CheckVariablesAt (unsigned int scope);

/*
   GetTurnInterrupts - returns the TurnInterrupts procedure function.
*/

static unsigned int GetTurnInterrupts (unsigned int tok);

/*
   GetProtection - returns the PROTECTION data type.
*/

static unsigned int GetProtection (unsigned int tok);

/*
   CheckNeedPriorityBegin - checks to see whether we need to save the old
                            module priority and change to another module
                            priority.
                            The current module initialization or procedure
                            being built is defined by, scope. The module whose
                            priority will be used is defined by, module.
*/

static void CheckNeedPriorityBegin (unsigned int tok, unsigned int scope, unsigned int module);

/*
   CheckNeedPriorityEnd - checks to see whether we need to restore the old
                          module priority.
                          The current module initialization or procedure
                          being built is defined by, scope.
*/

static void CheckNeedPriorityEnd (unsigned int tok, unsigned int scope, unsigned int module);

/*
   BuildRTExceptEnter - informs RTExceptions that we are about to enter the except state.
*/

static void BuildRTExceptEnter (unsigned int tok);

/*
   BuildRTExceptLeave - informs RTExceptions that we are about to leave the except state.
                        If, destroy, is TRUE then pop the ExceptStack.
*/

static void BuildRTExceptLeave (unsigned int tok, bool destroy);

/*
   SafeRequestSym - only used during scaffold to get argc, argv, envp.
                    It attempts to get symbol name from the current scope(s) and if
                    it fails then it falls back onto default constants.
*/

static unsigned int SafeRequestSym (unsigned int tok, NameKey_Name name);

/*
   callRequestDependant - create a call:
                          RequestDependant (GetSymName (modulesym), GetLibName (modulesym),
                                            GetSymName (depModuleSym), GetLibName (depModuleSym));
*/

static void callRequestDependant (unsigned int tokno, unsigned int moduleSym, unsigned int depModuleSym, unsigned int requestDep);

/*
   ForeachImportInDepDo -
*/

static void ForeachImportInDepDo (Lists_List importStatements, unsigned int moduleSym, unsigned int requestDep);

/*
   ForeachImportedModuleDo -
*/

static void ForeachImportedModuleDo (unsigned int moduleSym, unsigned int requestDep);

/*
   BuildM2DepFunction - creates the dependency graph procedure using IR:
                        static void
                        dependencies (void)
                        {
                           M2RTS_RequestDependant (module_name, libname, "b", "b libname");
                           M2RTS_RequestDependant (module_name, libname, NULL, NULL);
                        }
*/

static void BuildM2DepFunction (unsigned int tokno, unsigned int moduleSym);

/*
   BuildM2LinkFunction - creates the _M2_link procedure which will
                         cause the linker to pull in all the module ctors.
*/

static void BuildM2LinkFunction (unsigned int tokno);

/*
   BuildTry - build the try statement for main.
*/

static void BuildTry (unsigned int tokno);

/*
   BuildExcept - build the except block for main.
*/

static void BuildExcept (unsigned int tokno);

/*
   BuildM2MainFunction - creates the main function with appropriate calls to the scaffold.
*/

static void BuildM2MainFunction (unsigned int tokno);

/*
   DeferMakeConstStringCnul - return a C const string which will be nul terminated.
*/

static unsigned int DeferMakeConstStringCnul (unsigned int tok, unsigned int sym);

/*
   DeferMakeConstStringM2nul - return a const string which will be nul terminated.
*/

static unsigned int DeferMakeConstStringM2nul (unsigned int tok, unsigned int sym);

/*
   BuildStringAdrParam - push the address of a nul terminated string onto the quad stack.
*/

static void BuildStringAdrParam (unsigned int tok, NameKey_Name name);

/*
   BuildM2InitFunction -
*/

static void BuildM2InitFunction (unsigned int tok, unsigned int moduleSym);

/*
   BuildM2FiniFunction -
*/

static void BuildM2FiniFunction (unsigned int tok, unsigned int moduleSym);

/*
   BuildM2CtorFunction - create a constructor function associated with moduleSym.

                         void
                         ctorFunction ()
                         {
                           M2RTS_RegisterModule (GetSymName (moduleSym), GetLibName (moduleSym),
                                                 init, fini, dependencies);
                         }
*/

static void BuildM2CtorFunction (unsigned int tok, unsigned int moduleSym);

/*
   AddForInfo - adds the description of the FOR loop into the record list.
                This is used if -pedantic is turned on to check index variable
                usage.
*/

static void AddForInfo (unsigned int Start, unsigned int End, unsigned int IncQuad, unsigned int Sym, unsigned int idtok);

/*
   CheckForIndex - checks the quadruples: Start..End to see whether a
                   for loop index is manipulated by the programmer.
                   It generates a warning if this is the case.
                   It also checks to see whether the IndexSym is read
                   immediately outside the loop in which case a warning
                   is issued.
*/

static void CheckForIndex (M2Quads_ForLoopInfo forDesc);

/*
   BuildRange - generates a RangeCheckOp quad with, r, as its operand.
*/

static void BuildRange (unsigned int r);

/*
   BuildError - generates a ErrorOp quad, indicating that if this
                quadruple is reachable, then a runtime error would
                occur.
*/

static void BuildError (unsigned int r);

/*
   CheckPointerThroughNil - builds a range quadruple, providing, sym, is
                            a candidate for checking against NIL.
                            This range quadruple is only expanded into
                            code during the code generation phase
                            thus allowing limited compile time checking.
*/

static void CheckPointerThroughNil (unsigned int tokpos, unsigned int sym);

/*
   CollectLow - returns the low of the subrange value.
*/

static unsigned int CollectLow (unsigned int sym);

/*
   CollectHigh - returns the high of the subrange value, sym.
*/

static unsigned int CollectHigh (unsigned int sym);

/*
   CheckCompatibleWithBecomes - checks to see that symbol, sym, is
                                compatible with the := operator.
*/

static void CheckCompatibleWithBecomes (unsigned int des, unsigned int expr, unsigned int destok, unsigned int exprtok);

/*
   BuildAssignmentWithoutBounds - calls BuildAssignment but makes sure we do not
                                  check bounds.
*/

static void BuildAssignmentWithoutBounds (unsigned int tok, bool checkTypes, bool checkOverflow);

/*
   MarkArrayWritten - marks, Array, as being written.
*/

static void MarkArrayWritten (unsigned int Array);

/*
   MarkAsReadWrite - marks the variable or parameter as being
                     read/write.
*/

static void MarkAsReadWrite (unsigned int sym);

/*
   MarkAsRead - marks the variable or parameter as being read.
*/

static void MarkAsRead (unsigned int sym);

/*
   MarkAsWrite - marks the variable or parameter as being written.
*/

static void MarkAsWrite (unsigned int sym);

/*
   doVal - return an expression which is VAL(type, expr).  If
           expr is a constant then return expr.
*/

static unsigned int doVal (unsigned int type, unsigned int expr);

/*
   MoveWithMode -
*/

static void MoveWithMode (unsigned int tokno, unsigned int Des, unsigned int Exp, unsigned int Array, unsigned int destok, unsigned int exptok, bool checkOverflow);

/*
   CheckBecomesMeta - checks to make sure that we are not
                      assigning a variable to a constant.
                      Also check we are not assigning to an
                      unbounded array.
*/

static void CheckBecomesMeta (unsigned int Des, unsigned int Exp, unsigned int combinedtok, unsigned int destok, unsigned int exprtok);

/*
   doBuildAssignment - subsiduary procedure of BuildAssignment.
                       It builds the assignment and optionally
                       checks the types are compatible.
*/

static void doBuildAssignment (unsigned int becomesTokNo, bool checkTypes, bool checkOverflow);

/*
   CheckAssignCompatible - checks to see that an assignment is compatible.
                           It performs limited checking - thorough checking
                           is done in pass 3.  But we do what we can here
                           given knowledge so far.
*/

static void CheckAssignCompatible (unsigned int Des, unsigned int Exp, unsigned int combinedtok, unsigned int destok, unsigned int exprtok);

/*
   CheckBooleanId - Checks to see if the top operand is a boolean.
                    If the operand is not a boolean then it is tested
                    with true and a boolean is generated.
                    The Stack:


                    Entry                     Exit
             Ptr ->                                          <- Ptr
                    +------------+            +------------+
                    | Sym        |            | t   | f    |
                    |------------|            |------------|

                     Quadruples

                     q   If=      Sym   True   _
                     q+1 GotoOp   _     _      _
*/

static void CheckBooleanId (void);

/*
   PushOne - pushes the value one to the stack.
             The Stack is changed:


                    Entry                   Exit
                    =====                   ====

                                                            <- Ptr
                                            +------------+
             Ptr ->                         | 1 | type   |
                                            |------------|
*/

static void PushOne (unsigned int tok, unsigned int type, const char *message_, unsigned int _message_high);

/*
   PushZero - pushes the value zero to the stack.
              The Stack is changed:


                    Entry                   Exit
                    =====                   ====

                                                            <- Ptr
                                            +------------+
             Ptr ->                         | 0 | type   |
                                            |------------|
*/

static void PushZero (unsigned int tok, unsigned int type);

/*
   ForLoopLastIterator - calculate the last iterator value but avoid setting
                         LastIterator twice if it is a constant (in the quads).
                         In the ForLoopLastIteratorVariable case only one
                         path will be chosen but at the time of quadruple
                         generation we do not know the value of BySym.
*/

static void ForLoopLastIterator (unsigned int LastIterator, unsigned int e1, unsigned int e2, unsigned int BySym, unsigned int e1tok, unsigned int e2tok, unsigned int bytok);

/*
   BuildSizeCheckEnd - checks to see whether the function "called" was in fact SIZE.
                       If so then we restore quadruple generation.
*/

static void BuildSizeCheckEnd (unsigned int ProcSym);

/*
   BuildRealProcedureCall - builds a real procedure call.
                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |
                            |----------------|
                            | ProcSym | Type |         Empty
                            |----------------|
*/

static void BuildRealProcedureCall (unsigned int tokno);

/*
   BuildRealFuncProcCall - builds a real procedure or function call.
                           The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |
                            |----------------|
                            | ProcSym | Type |         Empty
                            |----------------|
*/

static void BuildRealFuncProcCall (unsigned int tokno, bool IsFunc, bool IsForC, bool ConstExpr);

/*
   CheckProcedureParameters - Checks the parameters which are being passed to
                              procedure ProcSym.

                              The Stack:


                              Entry                      Exit

                       Ptr ->                                               <- Ptr
                              +----------------+         +----------------+
                              | NoOfParam      |         | NoOfParam      |
                              |----------------|         |----------------|
                              | Param 1        |         | Param 1        |
                              |----------------|         |----------------|
                              | Param 2        |         | Param 2        |
                              |----------------|         |----------------|
                              .                .         .                .
                              .                .         .                .
                              .                .         .                .
                              |----------------|         |----------------|
                              | Param #        |         | Param #        |
                              |----------------|         |----------------|
                              | ProcSym | Type |         | ProcSym | Type |
                              |----------------|         |----------------|

*/

static void CheckProcedureParameters (bool IsForC);

/*
   CheckProcTypeAndProcedure - checks the ProcType with the call.
*/

static void CheckProcTypeAndProcedure (unsigned int tokno, unsigned int ProcType, unsigned int call, unsigned int ParamCheckId);

/*
   IsReallyPointer - returns TRUE is sym is a pointer, address or a type declared
                     as a pointer or address.
*/

static bool IsReallyPointer (unsigned int Sym);

/*
   LegalUnboundedParam - returns TRUE if the parameter, Actual, can legitimately be
                         passed to ProcSym, i, the, Formal, parameter.
*/

static bool LegalUnboundedParam (unsigned int tokpos, unsigned int ProcSym, unsigned int i, unsigned int ActualType, unsigned int Actual, unsigned int Dimension, unsigned int Formal);

/*
   CheckParameter - checks that types ActualType and FormalType are compatible for parameter
                    passing. ProcSym is the procedure and i is the parameter number.

                    We obey the following rules:

                    (1)  we allow WORD, BYTE, LOC to be compitable with any like sized
                         type.
                    (2)  we allow ADDRESS to be compatible with any pointer type.
                    (3)  we relax INTEGER and CARDINAL checking for Temporary variables.

                    Note that type sizes are checked during the code generation pass.
*/

static void CheckParameter (unsigned int tokpos, unsigned int Actual, unsigned int Dimension, unsigned int Formal, unsigned int ProcSym, unsigned int i, Lists_List TypeList, unsigned int ParamCheckId);

/*
   DescribeType - returns a String describing a symbol, Sym, name and its type.
*/

static DynamicStrings_String DescribeType (unsigned int Sym);

/*
   FailParameter - generates an error message indicating that a parameter
                   declaration has failed.

                   The parameters are:

                   CurrentState  - string describing the current failing state.
                   Actual        - actual parameter.
                   ParameterNo   - parameter number that has failed.
                   ProcedureSym  - procedure symbol where parameter has failed.

                   If any parameter is Nul then it is ignored.
*/

static void FailParameter (unsigned int tokpos, const char *CurrentState_, unsigned int _CurrentState_high, unsigned int Actual, unsigned int ProcedureSym, unsigned int ParameterNo);

/*
   WarnParameter - generates a warning message indicating that a parameter
                   use might cause problems on another target.

                   CurrentState  - string describing the current failing state.
                   Actual        - actual parameter.
                   ParameterNo   - parameter number that has failed.
                   ProcedureSym  - procedure symbol where parameter has failed.

                   If any parameter is Nul then it is ignored.
*/

static void WarnParameter (unsigned int tokpos, const char *CurrentState_, unsigned int _CurrentState_high, unsigned int Actual, unsigned int ProcedureSym, unsigned int ParameterNo);

/*
   doIndrX - perform des = *exp with a conversion if necessary.
*/

static void doIndrX (unsigned int tok, unsigned int des, unsigned int exp);

/*
   MakeRightValue - returns a temporary which will have the RightValue of symbol, Sym.
                    If Sym is a right value and has type, type, then no quadruples are
                    generated and Sym is returned. Otherwise a new temporary is created
                    and an IndrX quadruple is generated.
*/

static unsigned int MakeRightValue (unsigned int tok, unsigned int Sym, unsigned int type);

/*
   MakeLeftValue - returns a temporary coresponding to the LeftValue of
                   symbol, Sym. No quadruple is generated if Sym is already
                   a LeftValue and has the same type.
*/

static unsigned int MakeLeftValue (unsigned int tok, unsigned int Sym, SymbolTable_ModeOfAddr with, unsigned int type);

/*
   ManipulatePseudoCallParameters - manipulates the parameters to a pseudo function or
                                    procedure. It dereferences all LeftValue parameters
                                    and Boolean parameters.
                                    The Stack:


                                    Entry                      Exit

                             Ptr ->                            exactly the same
                                    +----------------+
                                    | NoOfParameters |
                                    |----------------|
                                    | Param 1        |
                                    |----------------|
                                    | Param 2        |
                                    |----------------|
                                    .                .
                                    .                .
                                    .                .
                                    |----------------|
                                    | Param #        |
                                    |----------------|
                                    | ProcSym | Type |
                                    |----------------|

*/

static void ManipulatePseudoCallParameters (void);

/*
   ManipulateParameters - manipulates the procedure parameters in
                          preparation for a procedure call.
                          Prepares Boolean, Unbounded and VAR parameters.
                          The Stack:


                          Entry                      Exit

                   Ptr ->                            exactly the same
                          +----------------+
                          | NoOfParameters |
                          |----------------|
                          | Param 1        |
                          |----------------|
                          | Param 2        |
                          |----------------|
                          .                .
                          .                .
                          .                .
                          |----------------|
                          | Param #        |
                          |----------------|
                          | ProcSym | Type |
                          |----------------|
*/

static void ManipulateParameters (bool IsForC);

/*
   CheckParameterOrdinals - check that ordinal values are within type range.
*/

static void CheckParameterOrdinals (void);

/*
   IsSameUnbounded - returns TRUE if unbounded types, t1, and, t2,
                     are compatible.
*/

static bool IsSameUnbounded (unsigned int t1, unsigned int t2);

/*
   AssignUnboundedVar - assigns an Unbounded symbol fields,
                        ArrayAddress and ArrayHigh, from an array symbol.
                        UnboundedSym is not a VAR parameter and therefore
                        this procedure can complete both of the fields.
                        Sym can be a Variable with type Unbounded.
                        Sym can be a Variable with type Array.
                        Sym can be a String Constant.

                        ParamType is the TYPE of the parameter
*/

static void AssignUnboundedVar (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim);

/*
   AssignUnboundedNonVar - assigns an Unbounded symbol fields,
                           The difference between this procedure and
                           AssignUnboundedVar is that this procedure cannot
                           set the Unbounded.Address since the data from
                           Sym will be copied because parameter is NOT a VAR
                           parameter.
                           UnboundedSym is not a VAR parameter and therefore
                           this procedure can only complete the HIGH field
                           and not the ADDRESS field.
                           Sym can be a Variable with type Unbounded.
                           Sym can be a Variable with type Array.
                           Sym can be a String Constant.

                           ParamType is the TYPE of the paramater
*/

static void AssignUnboundedNonVar (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim);

/*
   GenHigh - generates a HighOp but it checks if op3 is a
             L value and if so it dereferences it.  This
             is inefficient, however it is clean and we let the gcc
             backend detect these as common subexpressions.
             It will also detect that a R value -> L value -> R value
             via indirection and eleminate these.
*/

static void GenHigh (unsigned int tok, unsigned int op1, unsigned int op2, unsigned int op3);

/*
   AssignHighField -
*/

static void AssignHighField (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int actuali, unsigned int formali);

/*
   AssignHighFields -
*/

static void AssignHighFields (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim);

/*
   UnboundedNonVarLinkToArray - links an array, ArraySym, to an unbounded
                                array, UnboundedSym. The parameter is a
                                NON VAR variety.
*/

static void UnboundedNonVarLinkToArray (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim);

/*
   UnboundedVarLinkToArray - links an array, ArraySym, to an unbounded array,
                             UnboundedSym. The parameter is a VAR variety.
*/

static void UnboundedVarLinkToArray (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim);

/*
   BuildPseudoProcedureCall - builds a pseudo procedure call.
                              This procedure does not directly alter the
                              stack, but by calling routines the stack
                              will change in the following way when this
                              procedure returns.

                              The Stack:


                              Entry                      Exit

                       Ptr ->
                              +----------------+
                              | NoOfParam      |
                              |----------------|
                              | Param 1        |
                              |----------------|
                              | Param 2        |
                              |----------------|
                              .                .
                              .                .
                              .                .
                              |----------------|
                              | Param #        |
                              |----------------|
                              | ProcSym | Type |         Empty
                              |----------------|
*/

static void BuildPseudoProcedureCall (unsigned int tokno);

/*
   GetItemPointedTo - returns the symbol type that is being pointed to
                      by Sym.
*/

static unsigned int GetItemPointedTo (unsigned int Sym);

/*
   BuildThrowProcedure - builds the pseudo procedure call M2RTS.Throw.
                         The Stack:


                         Entry                      Exit

                Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |
                         |----------------|
                         .                .
                         .                .
                         .                .
                         |----------------|
                         | Param #        |
                         |----------------|
                         | ProcSym | Type |         Empty
                         |----------------|
*/

static void BuildThrowProcedure (unsigned int functok);

/*
   BuildNewProcedure - builds the pseudo procedure call NEW.
                       This procedure is traditionally a "macro" for
                       NEW(x, ...) --> ALLOCATE(x, TSIZE(x^, ...))
                       One method of implementation is to emulate a "macro"
                       processor by pushing the relevant input tokens
                       back onto the input stack.
                       However this causes two problems:

                       (i)  Unnecessary code is produced for x^
                       (ii) SIZE must be imported from SYSTEM
                       Therefore we chose an alternative method of
                       implementation;
                       generate quadruples for ALLOCATE(x, TSIZE(x^, ...))
                       this, although slightly more efficient,
                       is more complex and circumvents problems (i) and (ii).

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildNewProcedure (unsigned int functok);

/*
   BuildDisposeProcedure - builds the pseudo procedure call DISPOSE.
                           This procedure is traditionally a "macro" for
                           DISPOSE(x) --> DEALLOCATE(x, TSIZE(x^))
                           One method of implementation is to emulate a "macro"
                           processor by pushing the relevant input tokens
                           back onto the input stack.
                           However this causes two problems:

                           (i)  Unnecessary code is produced for x^
                           (ii) TSIZE must be imported from SYSTEM
                           Therefore we chose an alternative method of
                           implementation;
                           generate quadruples for DEALLOCATE(x, TSIZE(x^))
                           this, although slightly more efficient,
                           is more complex and circumvents problems (i)
                           and (ii).

                           The Stack:


                           Entry                      Exit

                    Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |
                           |----------------|
                           | ProcSym | Type |         Empty
                           |----------------|
*/

static void BuildDisposeProcedure (unsigned int functok);

/*
   CheckRangeIncDec - performs des := des <tok> expr
                      with range checking (if enabled).

                               Stack
                      Entry              Exit

                                     +------------+
                      empty          | des + expr |
                                     |------------|
*/

static void CheckRangeIncDec (unsigned int tokenpos, unsigned int des, unsigned int expr, NameKey_Name tok);

/*
   BuildIncProcedure - builds the pseudo procedure call INC.
                       INC is a procedure which increments a variable.
                       It takes one or two parameters:
                       INC(a, b)  or  INC(a)
                       a := a+b   or  a := a+1

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildIncProcedure (unsigned int proctok);

/*
   BuildDecProcedure - builds the pseudo procedure call DEC.
                       DEC is a procedure which decrements a variable.
                       It takes one or two parameters:
                       DEC(a, b)  or  DEC(a)
                       a := a-b   or  a := a-1

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildDecProcedure (unsigned int proctok);

/*
   DereferenceLValue - checks to see whether, operand, is declare as an LValue
                       and if so it dereferences it.
*/

static unsigned int DereferenceLValue (unsigned int tok, unsigned int operand);

/*
   BuildInclProcedure - builds the pseudo procedure call INCL.
                        INCL is a procedure which adds bit b into a BITSET a.
                        It takes two parameters:
                        INCL(a, b)

                        a := a + {b}

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildInclProcedure (unsigned int proctok);

/*
   BuildExclProcedure - builds the pseudo procedure call EXCL.
                        INCL is a procedure which removes bit b from SET a.
                        It takes two parameters:
                        EXCL(a, b)

                        a := a - {b}

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildExclProcedure (unsigned int proctok);

/*
   BuildTypeCoercion - builds the type coersion.
                       Modula-2 allows types to be coersed with no runtime
                       penility.
                       It insists that the TSIZE(t1)=TSIZE(t2) where
                       t2 variable := t2(variable of type t1).
                       The ReturnVar on the stack is of type t2.

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|

                       Quadruples:

                       CoerceOp  ReturnVar  Type  Param1

                       A type coercion will only be legal if the different
                       types have exactly the same size.
                       Since we can only decide this after M2Eval has processed
                       the symbol table then we create a quadruple explaining
                       the coercion taking place, the code generator can test
                       this assertion and report an error if the type sizes
                       differ.
*/

static void BuildTypeCoercion (bool ConstExpr);

/*
   BuildRealFunctionCall - builds a function call.
                           The Stack:


                           Entry                      Exit

                    Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |                        <- Ptr
                           |----------------|         +------------+
                           | ProcSym | Type |         | ReturnVar  |
                           |----------------|         |------------|
*/

static void BuildRealFunctionCall (unsigned int tokno, bool ConstExpr);

/*
   BuildPseudoFunctionCall - builds the pseudo function
                             The Stack:


                             Entry                      Exit

                      Ptr ->
                             +----------------+
                             | NoOfParam      |
                             |----------------|
                             | Param 1        |
                             |----------------|
                             | Param 2        |
                             |----------------|
                             .                .
                             .                .
                             .                .
                             |----------------|
                             | Param #        |                        <- Ptr
                             |----------------|         +------------+
                             | ProcSym | Type |         | ReturnVar  |
                             |----------------|         |------------|

*/

static void BuildPseudoFunctionCall (bool ConstExpr);

/*
   BuildAddAdrFunction - builds the pseudo procedure call ADDADR.

                         PROCEDURE ADDADR (addr: ADDRESS; offset: CARDINAL): ADDRESS ;

                         Which returns address given by (addr + offset),
                         [ the standard says that it _may_
                           "raise an exception if this address is not valid."
                           currently we do not generate any exception code ]

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildAddAdrFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildSubAdrFunction - builds the pseudo procedure call ADDADR.

                         PROCEDURE SUBADR (addr: ADDRESS; offset: CARDINAL): ADDRESS ;

                         Which returns address given by (addr - offset),
                         [ the standard says that it _may_
                           "raise an exception if this address is not valid."
                           currently we do not generate any exception code ]

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildSubAdrFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildDifAdrFunction - builds the pseudo procedure call DIFADR.

                         PROCEDURE DIFADR (addr1, addr2: ADDRESS): INTEGER ;

                         Which returns address given by (addr1 - addr2),
                         [ the standard says that it _may_
                           "raise an exception if this address is invalid or
                            address space is non-contiguous."
                           currently we do not generate any exception code ]

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildDifAdrFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildHighFunction - checks the stack in preparation for generating
                       quadruples which perform HIGH.
                       This procedure does not alter the stack but
                       determines whether, a, in HIGH(a) is an ArraySym
                       or UnboundedSym.
                       Both cases are different and appropriate quadruple
                       generating routines are called.

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|

*/

static void BuildHighFunction (void);

/*
   BuildConstHighFromSym - builds the pseudo function HIGH from an Sym.
                           Sym is a constant or an array which has constant bounds
                           and therefore it can be calculated at compile time.

                           The Stack:


                           Entry                      Exit

                   Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |                        <- Ptr
                           |----------------|         +------------+
                           | ProcSym | Type |         | ReturnVar  |
                           |----------------|         |------------|
*/

static void BuildConstHighFromSym (unsigned int tok);

/*
   BuildHighFromUnbounded - builds the pseudo function HIGH from an
                            UnboundedSym.

                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param #        |                        <- Ptr
                            |----------------|         +------------+
                            | ProcSym | Type |         | ReturnVar  |
                            |----------------|         |------------|

*/

static void BuildHighFromUnbounded (unsigned int tok);

/*
   GetQualidentImport - returns the symbol as if it were qualified from, module.n.
                        This is used to reference runtime support procedures and an
                        error is generated if the symbol cannot be obtained.
*/

static unsigned int GetQualidentImport (unsigned int tokno, NameKey_Name n, NameKey_Name module);

/*
   ConstExprError - return TRUE if a constant expression is being built and Var is a variable.
*/

static bool ConstExprError (unsigned int Func, unsigned int Var, unsigned int optok, bool ConstExpr);

/*
   DeferMakeLengthConst - creates a constant which contains the length of string, sym.
*/

static unsigned int DeferMakeLengthConst (unsigned int tok, unsigned int sym);

/*
   BuildLengthFunction - builds the inline standard function LENGTH.

                         The Stack:


                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|

*/

static void BuildLengthFunction (unsigned int Function, bool ConstExpr);

/*
   BuildOddFunction - builds the pseudo procedure call ODD.
                      This procedure is actually a "macro" for
                      ORD(x) --> VAL(BOOLEAN, x MOD 2)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildOddFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildAbsFunction - builds a call to the standard function ABS.

                      We cannot implement it as a macro or inline an
                      IF THEN statement as the IF THEN ELSE requires
                      we write the value to the same variable (or constant)
                      twice. The macro implementation will fail as
                      the compiler maybe building a function
                      call and expecting a ReturnVar on the stack.
                      The only method to implement this is to pass it to the
                      gcc backend.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildAbsFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildCapFunction - builds the pseudo procedure call CAP.
                      We generate a the following quad:


                      StandardFunctionOp  ReturnVal  Cap  Param1

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam = 1  |
                      |----------------|
                      | Param 1        |
                      |----------------|         +-------------+
                      | ProcSym | Type |         | ReturnVal   |
                      |----------------|         |-------------|
*/

static void BuildCapFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildChrFunction - builds the pseudo procedure call CHR.
                      This procedure is actually a "macro" for
                      CHR(x) --> CONVERT(CHAR, x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildChrFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildOrdFunction - builds the pseudo procedure call ORD.
                      This procedure is actually a "macro" for
                      ORD(x) --> CONVERT(GetSType(sym), x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildOrdFunction (unsigned int Sym, bool ConstExpr);

/*
   BuildIntFunction - builds the pseudo procedure call INT.
                      This procedure is actually a "macro" for
                      INT(x) --> CONVERT(INTEGER, x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildIntFunction (unsigned int Sym, bool ConstExpr);

/*
   BuildMakeAdrFunction - builds the pseudo procedure call MAKEADR.

                          The Stack:


                          Entry                      Exit

                   Ptr ->
                          +----------------+
                          | NoOfParam      |
                          |----------------|
                          | Param 1        |
                          |----------------|
                          | Param 2        |
                          |----------------|
                          .                .
                          .                .
                          .                .
                          |----------------|
                          | Param #        |
                          |----------------|
                          | ProcSym | Type |         Empty
                          |----------------|
*/

static void BuildMakeAdrFunction (void);

/*
   BuildShiftFunction - builds the pseudo procedure call SHIFT.

                        PROCEDURE SHIFT (val: <any type>;
                                         num: INTEGER): <any type> ;

                       "Returns a bit sequence obtained from val by
                        shifting up or down (left or right) by the
                        absolute value of num, introducing
                        zeros as necessary.  The direction is down if
                        the sign of num is negative, otherwise the
                        direction is up."

                        The Stack:

                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |                        <- Ptr
                        |----------------|         +------------+
                        | ProcSym | Type |         | ReturnVar  |
                        |----------------|         |------------|
*/

static void BuildShiftFunction (void);

/*
   BuildRotateFunction - builds the pseudo procedure call ROTATE.

                         PROCEDURE ROTATE (val: <any type>;
                                           num: INTEGER): <any type> ;

                        "Returns a bit sequence obtained from val
                         by rotating up or down (left or right) by
                         the absolute value of num.  The direction is
                         down if the sign of num is negative, otherwise
                         the direction is up."

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildRotateFunction (void);

/*
   BuildValFunction - builds the pseudo procedure call VAL.
                      This procedure is actually a "macro" for
                      VAL(Type, x) --> CONVERT(Type, x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildValFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildCastFunction - builds the pseudo procedure call CAST.
                       This procedure is actually a "macro" for
                       CAST(Type, x) --> Type(x)
                       However we cannot push tokens back onto the input stack
                       because the compiler is currently building a function
                       call and expecting a ReturnVar on the stack.
                       Hence we manipulate the stack and call
                       BuildConvertFunction.

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildCastFunction (unsigned int ProcSym, bool ConstExpr);

/*
   BuildConvertFunction - builds the pseudo function CONVERT.
                          CONVERT( Type, Variable ) ;

                          The Stack:


                          Entry                      Exit

                   Ptr ->
                          +----------------+
                          | NoOfParam      |
                          |----------------|
                          | Param 1        |
                          |----------------|
                          | Param 2        |
                          |----------------|
                          .                .
                          .                .
                          .                .
                          |----------------|
                          | Param #        |                                 <- Ptr
                          |----------------|         +---------------------+
                          | ProcSym | Type |         | ReturnVar | Param1  |
                          |----------------|         |---------------------|

                          Quadruples:

                          ConvertOp  ReturnVar  Param1  Param2

                          Converts variable Param2 into a variable Param1
                          with a type Param1.
*/

static void BuildConvertFunction (unsigned int ProcSym, bool ConstExpr);

/*
   CheckBaseTypeValue - checks to see whether the value, min, really exists.
*/

static unsigned int CheckBaseTypeValue (unsigned int tok, unsigned int type, unsigned int min, unsigned int func);

/*
   GetTypeMin - returns the minimium value of type and generate an error
                if this is unavailable.
*/

static unsigned int GetTypeMin (unsigned int tok, unsigned int func, unsigned int type);

/*
   GetTypeMinLower - obtain the maximum value for type.
*/

static unsigned int GetTypeMinLower (unsigned int tok, unsigned int func, unsigned int type);

/*
   GetTypeMax - returns the maximum value of type and generate an error
                if this is unavailable.
*/

static unsigned int GetTypeMax (unsigned int tok, unsigned int func, unsigned int type);

/*
   GetTypeMaxLower - obtain the maximum value for type.
*/

static unsigned int GetTypeMaxLower (unsigned int tok, unsigned int func, unsigned int type);

/*
   BuildMinFunction - builds the pseudo function call Min.

                      The Stack:

                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam=1    |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildMinFunction (void);

/*
   BuildMaxFunction - builds the pseudo function call Max.

                      The Stack:

                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam=1    |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildMaxFunction (void);

/*
   BuildTruncFunction - builds the pseudo procedure call TRUNC.
                        This procedure is actually a "macro" for
                        TRUNC(x) --> CONVERT(INTEGER, x)
                        However we cannot push tokens back onto the input stack
                        because the compiler is currently building a function
                        call and expecting a ReturnVar on the stack.
                        Hence we manipulate the stack and call
                        BuildConvertFunction.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildTruncFunction (unsigned int Sym, bool ConstExpr);

/*
   BuildFloatFunction - builds the pseudo procedure call FLOAT.
                        This procedure is actually a "macro" for
                        FLOAT(x) --> CONVERT(REAL, x)
                        However we cannot push tokens back onto the input stack
                        because the compiler is currently building a function
                        call and expecting a ReturnVar on the stack.
                        Hence we manipulate the stack and call
                        BuildConvertFunction.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildFloatFunction (unsigned int Sym, bool ConstExpr);

/*
   BuildReFunction - builds the pseudo procedure call RE.

                     The Stack:


                         Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildReFunction (unsigned int Sym, bool ConstExpr);

/*
   BuildImFunction - builds the pseudo procedure call IM.

                     The Stack:


                         Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildImFunction (unsigned int Sym, bool ConstExpr);

/*
   BuildCmplxFunction - builds the pseudo procedure call CMPLX.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildCmplxFunction (unsigned int func, bool ConstExpr);

/*
   BuildAdrFunction - builds the pseudo function ADR
                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |                        <- Ptr
                      |----------------|         +------------+
                      | ProcSym | Type |         | ReturnVar  |
                      |----------------|         |------------|

*/

static void BuildAdrFunction (void);

/*
   BuildSizeFunction - builds the pseudo function SIZE
                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|
*/

static void BuildSizeFunction (void);

/*
   BuildTSizeFunction - builds the pseudo function TSIZE
                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |                        <- Ptr
                        |----------------|         +------------+
                        | ProcSym | Type |         | ReturnVar  |
                        |----------------|         |------------|

*/

static void BuildTSizeFunction (void);

/*
   BuildTBitSizeFunction - builds the pseudo function TBITSIZE
                           The Stack:


                           Entry                      Exit

                   Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |                        <- Ptr
                           |----------------|         +------------+
                           | ProcSym | Type |         | ReturnVar  |
                           |----------------|         |------------|

*/

static void BuildTBitSizeFunction (void);

/*
   ExpectingParameterType -
*/

static void ExpectingParameterType (unsigned int BlockSym, unsigned int Type);

/*
   ExpectingVariableType -
*/

static void ExpectingVariableType (unsigned int BlockSym, unsigned int Type);

/*
   CheckVariablesAndParameterTypesInBlock - checks to make sure that block, BlockSym, has
                                            parameters types and variable types which are legal.
*/

static void CheckVariablesAndParameterTypesInBlock (unsigned int BlockSym);

/*
   IsNeverAltered - returns TRUE if variable, sym, is never altered
                    between quadruples: Start..End
*/

static bool IsNeverAltered (unsigned int sym, unsigned int Start, unsigned int End);

/*
   IsConditionVariable - returns TRUE if the condition at quadruple, q, is variable.
*/

static bool IsConditionVariable (unsigned int q, unsigned int Start, unsigned int End);

/*
   IsInfiniteLoop - returns TRUE if an infinite loop is found.
                    Given a backwards jump at, End, it returns a BOOLEAN which depends on
                    whether a jump is found to jump beyond, End. If a conditonal jump is found
                    to pass over, End, the condition is tested for global variables, procedure variables and
                    constants.

                         constant        - ignored
                         variables       - tested to see whether they are altered inside the loop
                         global variable - the procedure tests to see whether it is altered as above
                                           but will also test to see whether this loop calls a procedure
                                           in which case it believes the loop NOT to be infinite
                                           (as this procedure call might alter the global variable)

                    Note that this procedure can easily be fooled by the user altering variables
                    with pointers.
*/

static bool IsInfiniteLoop (unsigned int End);

/*
   CheckVariablesInBlock - given a block, BlockSym, check whether all variables are used.
*/

static void CheckVariablesInBlock (unsigned int BlockSym);

/*
   CheckFunctionReturn - checks to see that a RETURN statement was present in a function.
*/

static void CheckFunctionReturn (unsigned int ProcSym);

/*
   CheckReturnType - checks to see that the return type from currentProc is
                     assignment compatible with actualType.
*/

static void CheckReturnType (unsigned int tokno, unsigned int currentProc, unsigned int actualVal, unsigned int actualType);

/*
   BuildReturnLower - check the return type and value to ensure type
                      compatibility and no range overflow will occur.
*/

static void BuildReturnLower (unsigned int tokcombined, unsigned int tokexpr, unsigned int e1, unsigned int t1);

/*
   IsReadOnly - a helper procedure function to detect constants.
*/

static bool IsReadOnly (unsigned int sym);

/*
   BuildDesignatorError - removes the designator from the stack and replaces
                          it with an error symbol.
*/

static void BuildDesignatorError (const char *message_, unsigned int _message_high);

/*
   BuildDesignatorPointerError - removes the designator from the stack and replaces
                                 it with an error symbol.
*/

static void BuildDesignatorPointerError (unsigned int type, unsigned int rw, unsigned int tokpos, const char *message_, unsigned int _message_high);

/*
   BuildDesignatorArrayStaticDynamic - Builds the array referencing.
                                       The purpose of this procedure is to work out
                                       whether the DesignatorArray is a static or
                                       dynamic array and to call the appropriate
                                       BuildRoutine.

                                       The Stack is expected to contain:


                                       Entry                   Exit
                                       =====                   ====

                                Ptr ->
                                       +--------------+
                                       | e            |                        <- Ptr
                                       |--------------|        +------------+
                                       | Sym  | Type  |        | S    | T   |
                                       |--------------|        |------------|
*/

static void BuildDesignatorArrayStaticDynamic (void);

/*
   BuildStaticArray - Builds the array referencing for static arrays.
                      The Stack is expected to contain:


                      Entry                   Exit
                      =====                   ====

              Ptr ->
                      +--------------+
                      | e            |                       <- Ptr
                      |--------------|        +------------+
                      | Sym  | Type  |        | S    | T   |
                      |--------------|        |------------|
*/

static void BuildStaticArray (void);

/*
   calculateMultipicand - generates quadruples which calculate the
                          multiplicand for the array at dimension, dim.
*/

static unsigned int calculateMultipicand (unsigned int tok, unsigned int arraySym, unsigned int arrayType, unsigned int dim);

/*
   ConvertToAddress - convert sym to an address.
*/

static unsigned int ConvertToAddress (unsigned int tokpos, unsigned int sym);

/*
   BuildDynamicArray - Builds the array referencing for dynamic arrays.
                       The Stack is expected to contain:


                       Entry                          Exit
                       =====                          ====

               Ptr ->
                       +-----------------------+
                       | Index                 |                                    <- Ptr
                       |-----------------------|      +---------------------------+
                       | ArraySym | Type | Dim |      | S  | T | ArraySym | Dim+1 |
                       |-----------------------|      |---------------------------|


   if Dim=1
   then
      S := base of ArraySym + TSIZE(Type)*Index
   else
      S := S + TSIZE(Type)*Index
   fi
*/

static void BuildDynamicArray (void);

/*
   DebugLocation -
*/

static void DebugLocation (unsigned int tok, const char *message_, unsigned int _message_high);

/*
   PushWith - pushes sym and type onto the with stack. It checks for
              previous declaration of this record type.
*/

static void PushWith (unsigned int Sym, unsigned int Type, unsigned int Ref, unsigned int Tok);
static void PopWith (void);

/*
   BuildAccessWithField - similar to BuildDesignatorRecord except it
                          does not perform the address operation.
                          The address will have been computed at the
                          beginning of the WITH statement.
                          It also stops the GenQuad procedure from examining the
                          with stack.

                          The Stack

                          Entry

                   Ptr ->
                          +--------------+
                          | Field | Type1|                          <- Ptr
                          |-------|------|          +-------------+
                          | Adr   | Type2|          | Sym  | Type1|
                          |--------------|          |-------------|
*/

static void BuildAccessWithField (void);

/*
   PushConstructor -
*/

static void PushConstructor (unsigned int sym);

/*
   AddFieldTo - adds field, e, to, value.
*/

static unsigned int AddFieldTo (unsigned int value, unsigned int e);

/*
   CheckLogicalOperator - returns a logical operator if the operands imply
                          a logical operation should be performed.
*/

static NameKey_Name CheckLogicalOperator (NameKey_Name Tok, unsigned int left, unsigned int lefttype);

/*
   CheckDivModRem - initiates calls to check the divisor for DIV, MOD, REM
                    expressions.
*/

static void CheckDivModRem (unsigned int TokPos, NameKey_Name tok, unsigned int d, unsigned int e);

/*
   doConvert - convert, sym, to a new symbol with, type.
               Return the new symbol.
*/

static unsigned int doConvert (unsigned int type, unsigned int sym);

/*
   doBuildBinaryOp - build the binary op, with or without type
                     checking.
*/

static void doBuildBinaryOp (bool checkTypes, bool checkOverflow);

/*
   AreConstant - returns immediate addressing mode if b is true else
                 offset mode is returned. b determines whether the
                 operands are all constant - in which case we can use
                 a constant temporary variable.
*/

static SymbolTable_ModeOfAddr AreConstant (bool b);

/*
   ConvertBooleanToVariable - converts a BoolStack(i) from a Boolean True|False
                              exit pair into a variable containing the value TRUE or
                              FALSE.  The parameter i is relative to the top
                              of the stack.
*/

static void ConvertBooleanToVariable (unsigned int tok, unsigned int i);

/*
   DumpQuadSummary -
*/

static void DumpQuadSummary (unsigned int quad);

/*
   BuildRelOpFromBoolean - builds a relational operator sequence of quadruples
                           instead of using a temporary boolean variable.
                           This function can only be used when we perform
                           the following translation:

                           (a=b) # (c=d)  alternatively   (a=b) = (c=d)
                                 ^                              ^

                           it only allows # = to be used as >= <= > < all
                           assume a particular value for TRUE and FALSE.
                           (In which case the user should specify ORD)


                           before

                           q      if r1      op1     op2     t2
                           q+1    Goto                       f2
                           ...
                           q+n    if r2      op3     op4     t1
                           q+n+1  Goto                       f1

                           after (in case of =)

                           q    if r1      op1     op2     q+2
                           q+1  Goto                       q+4
                           q+2  if r2      op3     op4     t
                           q+3  Goto                       f
                           q+4  if r2      op3     op4     f
                           q+5  Goto                       t

                           after (in case of #)

                           q      if r1      op1     op2     q+2
                           q+1    Goto                       q+n+2
                           q+2    ...
                           ...    ...
                           q+n    if r2      op3     op4     f
                           q+n+1  Goto                       t
                           q+n+2  if r2      op3     op4     t
                           q+n+3  Goto                       f

                           The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                    Ptr ->
                           +------------+
                           | t1 | f1    |
                           |------------|
                           | Operator   |                          <- Ptr
                           |------------|          +------------+
                           | t2 | f2    |          | t    | f   |
                           |------------|          |------------|


*/

static void BuildRelOpFromBoolean (unsigned int tokpos);

/*
   CheckVariableOrConstantOrProcedure - checks to make sure sym is a variable, constant or procedure.
*/

static void CheckVariableOrConstantOrProcedure (unsigned int tokpos, unsigned int sym);

/*
   MakeOp - returns the equalent quadruple operator to a token, t.
*/

static M2Quads_QuadOperator MakeOp (NameKey_Name t);

/*
   GenQuadO - generate a quadruple with Operation, Op1, Op2, Op3, overflow.
*/

static void GenQuadO (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow);

/*
   GenQuadOTrash - generate a quadruple with Operation, Op1, Op2, Op3, overflow.
*/

static void GenQuadOTrash (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow, unsigned int trash);

/*
   GenQuad - Generate a quadruple with Operation, Op1, Op2, Op3.
*/

static void GenQuad (M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3);

/*
   GenQuadOtok - generate a quadruple with Operation, Op1, Op2, Op3, overflow.
*/

static void GenQuadOtok (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos);

/*
   GenQuadOTypetok - assigns the fields of the quadruple with
                     the parameters.
*/

static void GenQuadOTypetok (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow, bool typecheck, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos);

/*
   DumpUntil - dump all quadruples until we seen the ending quadruple
               with procsym in the third operand.
               Return the quad number containing the match.
*/

static unsigned int DumpUntil (M2Quads_QuadOperator ending, unsigned int procsym, unsigned int quad);

/*
   GetCtorInit - return the init procedure for the module.
*/

static unsigned int GetCtorInit (unsigned int sym);

/*
   GetCtorFini - return the fini procedure for the module.
*/

static unsigned int GetCtorFini (unsigned int sym);

/*
   DumpQuadrupleFilter -
*/

static void DumpQuadrupleFilter (void);

/*
   DumpQuadrupleAll - dump all quadruples.
*/

static void DumpQuadrupleAll (void);

/*
   BackPatch - Makes each of the quadruples on the list pointed to by
               QuadNo take quadruple Value as a target.
*/

static void BackPatch (unsigned int QuadNo, unsigned int Value);

/*
   Merge - joins two quad lists, QuadList2 to the end of QuadList1.
           A QuadList of value zero is a nul list.
*/

static unsigned int Merge (unsigned int QuadList1, unsigned int QuadList2);

/*
   DisplayProcedureAttributes -
*/

static void DisplayProcedureAttributes (unsigned int proc);

/*
   WriteQuad - Writes out the Quad BufferQuad.
*/

static void WriteQuad (unsigned int BufferQuad);

/*
   WriteOperand - displays the operands name, symbol id and mode of addressing.
*/

static void WriteMode (SymbolTable_ModeOfAddr Mode);

/*
   PushExit - pushes the exit value onto the EXIT stack.
*/

static void PushExit (unsigned int Exit);

/*
   PopExit - pops the exit value from the EXIT stack.
*/

static unsigned int PopExit (void);

/*
   PushFor - pushes the exit value onto the FOR stack.
*/

static void PushFor (unsigned int Exit);

/*
   PopFor - pops the exit value from the FOR stack.
*/

static unsigned int PopFor (void);

/*
   OperandTno - returns the ident operand stored in the true position
                on the boolean stack.  This is exactly the same as
                OperandT but it has no IsBoolean checking.
*/

static unsigned int OperandTno (unsigned int pos);

/*
   OperandFno - returns the ident operand stored in the false position
                on the boolean stack.  This is exactly the same as
                OperandF but it has no IsBoolean checking.
*/

static unsigned int OperandFno (unsigned int pos);

/*
   OperandTtok - returns the token associated with the position, pos
                 on the boolean stack.
*/

static unsigned int OperandTtok (unsigned int pos);

/*
   PopBooltok - Pops a True and a False exit quad number from the True/False
                stack.
*/

static void PopBooltok (unsigned int *True, unsigned int *False, unsigned int *tokno);

/*
   PushBooltok - Push a True and a False exit quad numbers onto the
                 True/False stack.
*/

static void PushBooltok (unsigned int True, unsigned int False, unsigned int tokno);

/*
   PopBool - Pops a True and a False exit quad number from the True/False
             stack.
*/

static void PopBool (unsigned int *True, unsigned int *False);

/*
   PushBool - Push a True and a False exit quad numbers onto the
              True/False stack.
*/

static void PushBool (unsigned int True, unsigned int False);

/*
   IsBoolean - returns true is the Stack position pos contains a Boolean
               Exit. False is returned if an Ident is stored.
*/

static bool IsBoolean (unsigned int pos);

/*
   OperandD - returns possible array dimension associated with the ident
              operand stored on the boolean stack.
*/

static unsigned int OperandD (unsigned int pos);

/*
   OperandRW - returns the rw operand stored on the boolean stack.
*/

static unsigned int OperandRW (unsigned int pos);

/*
   OperandMergeRW - returns the rw operand if not NulSym else it
                    returns True.
*/

static unsigned int OperandMergeRW (unsigned int pos);

/*
   OperandRangeDep - return the range dependant associated with the quad stack.
*/

static unsigned int OperandRangeDep (unsigned int pos);

/*
   PutRangeDep - assigns the quad stack pos RangeDep to dep.
*/

static void PutRangeDep (unsigned int pos, unsigned int dep);

/*
   UseLineNote - uses the line note and returns it to the free list.
*/

static void UseLineNote (M2Quads_LineNote l);

/*
   PopLineNo - pops a line note from the line stack.
*/

static M2Quads_LineNote PopLineNo (void);

/*
   InitLineNote - creates a line note and initializes it to
                  contain, file, line.
*/

static M2Quads_LineNote InitLineNote (NameKey_Name file, unsigned int line);

/*
   PushLineNote -
*/

static void PushLineNote (M2Quads_LineNote l);

/*
   BuildStmtNoteTok - adds a nop (with an assigned tokenno location) to the code.
*/

static void BuildStmtNoteTok (unsigned int tokenno);

/*
   GetRecordOrField -
*/

static unsigned int GetRecordOrField (void);

/*
   PushTFAD - Push True, False, Array, Dim, numbers onto the
              True/False stack.  True and False are assumed to
              contain Symbols or Ident etc.
*/

static void PushTFAD (unsigned int True, unsigned int False, unsigned int Array, unsigned int Dim);

/*
   PushTFADtok - Push True, False, Array, Dim, numbers onto the
                 True/False stack.  True and False are assumed to
                 contain Symbols or Ident etc.
*/

static void PushTFADtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int Dim, unsigned int tokno);

/*
   PushTFADrwtok - Push True, False, Array, Dim, rw, numbers onto the
                   True/False stack.  True and False are assumed to
                   contain Symbols or Ident etc.
*/

static void PushTFADrwtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int Dim, unsigned int rw, unsigned int Tok);

/*
   PopTFrwtok - Pop a True and False number from the True/False stack.
                True and False are assumed to contain Symbols or Ident etc.
*/

static void PopTFrwtok (unsigned int *True, unsigned int *False, unsigned int *rw, unsigned int *tokno);

/*
   PushTFrwtok - Push an item onto the stack in the T (true) position,
                 it is assummed to be a token and its token location is recorded.
*/

static void PushTFrwtok (unsigned int True, unsigned int False, unsigned int rw, unsigned int tokno);

/*
   PushTFDtok - Push True, False, Dim, numbers onto the
                True/False stack.  True and False are assumed to
                contain Symbols or Ident etc.
*/

static void PushTFDtok (unsigned int True, unsigned int False, unsigned int Dim, unsigned int Tok);

/*
   PopTFDtok - Pop a True, False, Dim number from the True/False stack.
               True and False are assumed to contain Symbols or Ident etc.
*/

static void PopTFDtok (unsigned int *True, unsigned int *False, unsigned int *Dim, unsigned int *Tok);

/*
   PushTFDrwtok - Push True, False, Dim, numbers onto the
                  True/False stack.  True and False are assumed to
                  contain Symbols or Ident etc.
*/

static void PushTFDrwtok (unsigned int True, unsigned int False, unsigned int Dim, unsigned int rw, unsigned int Tok);

/*
   PushTFrw - Push a True and False numbers onto the True/False stack.
              True and False are assumed to contain Symbols or Ident etc.
              It also pushes the higher level symbol which is associated
              with the True symbol.  Eg record variable or array variable.
*/

static void PushTFrw (unsigned int True, unsigned int False, unsigned int rw);

/*
   PopTFrw - Pop a True and False number from the True/False stack.
             True and False are assumed to contain Symbols or Ident etc.
*/

static void PopTFrw (unsigned int *True, unsigned int *False, unsigned int *rw);

/*
   newBoolFrame - creates a new BoolFrame with all fields initialised to their defaults.
*/

static M2Quads_BoolFrame newBoolFrame (void);

/*
   PushTrwtok - Push an item onto the True/False stack. The False value will be zero.
*/

static void PushTrwtok (unsigned int True, unsigned int rw, unsigned int tok);

/*
   PopTrw - Pop a True field and rw symbol from the stack.
*/

static void PopTrw (unsigned int *True, unsigned int *rw);

/*
   PopTrwtok - Pop a True field and rw symbol from the stack.
*/

static void PopTrwtok (unsigned int *True, unsigned int *rw, unsigned int *tok);

/*
   gdbhook - a debugger convenience hook.
*/

static void gdbhook (void);

/*
   BreakWhenQuadCreated - to be called interactively by gdb.
*/

static void BreakWhenQuadCreated (unsigned int quad);

/*
   CheckBreak - if quad = BreakQuad then call gdbhook.
*/

static void CheckBreak (unsigned int quad);

/*
   Init - initialize the M2Quads module, all the stacks, all the lists
          and the quads list.
*/

static void Init (void);


/*
   DSdbEnter -
*/

static void DSdbEnter (void)
{
}


/*
   DSdbExit -
*/

static void DSdbExit (void)
{
}


/*
   GetQF - returns the QuadFrame associated with, q.
*/

static M2Quads_QuadFrame GetQF (unsigned int q)
{
  return (M2Quads_QuadFrame) (Indexing_GetIndice (QuadArray, q));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsQuadA - returns true if QuadNo is a op.
*/

static bool IsQuadA (unsigned int QuadNo, M2Quads_QuadOperator op)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return f->Operator == op;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OpUsesOp1 - return TRUE if op allows op1.
*/

static bool OpUsesOp1 (M2Quads_QuadOperator op)
{
  switch (op)
    {
      case M2Quads_StringConvertCnulOp:
      case M2Quads_StringConvertM2nulOp:
      case M2Quads_StringLengthOp:
      case M2Quads_InclOp:
      case M2Quads_ExclOp:
      case M2Quads_UnboundedOp:
      case M2Quads_FunctValueOp:
      case M2Quads_NegateOp:
      case M2Quads_BecomesOp:
      case M2Quads_HighOp:
      case M2Quads_SizeOp:
      case M2Quads_AddrOp:
      case M2Quads_RecordFieldOp:
      case M2Quads_ArrayOp:
      case M2Quads_LogicalShiftOp:
      case M2Quads_LogicalRotateOp:
      case M2Quads_LogicalOrOp:
      case M2Quads_LogicalAndOp:
      case M2Quads_LogicalXorOp:
      case M2Quads_CoerceOp:
      case M2Quads_ConvertOp:
      case M2Quads_CastOp:
      case M2Quads_AddOp:
      case M2Quads_SubOp:
      case M2Quads_MultOp:
      case M2Quads_ModFloorOp:
      case M2Quads_DivCeilOp:
      case M2Quads_ModCeilOp:
      case M2Quads_DivFloorOp:
      case M2Quads_ModTruncOp:
      case M2Quads_DivTruncOp:
      case M2Quads_DivM2Op:
      case M2Quads_ModM2Op:
      case M2Quads_XIndrOp:
      case M2Quads_IndrXOp:
      case M2Quads_SaveExceptionOp:
      case M2Quads_RestoreExceptionOp:
        return true;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddQuadInformation - adds variable analysis and jump analysis to the new quadruple.
*/

static void AddQuadInformation (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3)
{
  switch (Op)
    {
      case M2Quads_IfInOp:
      case M2Quads_IfNotInOp:
      case M2Quads_IfEquOp:
      case M2Quads_IfNotEquOp:
      case M2Quads_IfLessOp:
      case M2Quads_IfLessEquOp:
      case M2Quads_IfGreOp:
      case M2Quads_IfGreEquOp:
        ManipulateReference (QuadNo, Oper3);
        CheckAddVariableRead (Oper1, false, QuadNo);
        CheckAddVariableRead (Oper2, false, QuadNo);
        break;

      case M2Quads_LastForIteratorOp:
        CheckAddVariableWrite (Oper1, false, QuadNo);
        CheckAddTuple2Read (Oper2, false, QuadNo);
        CheckAddVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_TryOp:
      case M2Quads_RetryOp:
      case M2Quads_GotoOp:
        ManipulateReference (QuadNo, Oper3);
        break;

      case M2Quads_InclOp:
      case M2Quads_ExclOp:
        /* variable references  */
        CheckConst (Oper1);
        CheckAddVariableRead (Oper3, false, QuadNo);
        CheckAddVariableWrite (Oper1, true, QuadNo);
        break;

      case M2Quads_UnboundedOp:
      case M2Quads_FunctValueOp:
      case M2Quads_NegateOp:
      case M2Quads_BecomesOp:
      case M2Quads_HighOp:
      case M2Quads_SizeOp:
        CheckConst (Oper1);
        CheckAddVariableWrite (Oper1, false, QuadNo);
        CheckAddVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_AddrOp:
        CheckConst (Oper1);
        CheckAddVariableWrite (Oper1, false, QuadNo);
        /* the next line is a kludge and assumes we _will_
                          write to the variable as we have taken its address  */
        CheckRemoveVariableWrite (Oper1, true, QuadNo);
        break;

      case M2Quads_ReturnValueOp:
        CheckAddVariableRead (Oper1, false, QuadNo);
        break;

      case M2Quads_ReturnOp:
      case M2Quads_NewLocalVarOp:
      case M2Quads_KillLocalVarOp:
        break;

      case M2Quads_CallOp:
        CheckAddVariableRead (Oper3, true, QuadNo);
        break;

      case M2Quads_ParamOp:
        CheckAddVariableRead (Oper2, false, QuadNo);
        CheckAddVariableRead (Oper3, false, QuadNo);
        if (((Oper1 > 0) && (Oper1 <= (SymbolTable_NoOfParamAny (Oper2)))) && (SymbolTable_IsVarParamAny (Oper2, Oper1)))
          {
            /* _may_ also write to a var parameter, although we dont know  */
            CheckAddVariableWrite (Oper3, true, QuadNo);
          }
        break;

      case M2Quads_RecordFieldOp:
      case M2Quads_ArrayOp:
      case M2Quads_LogicalShiftOp:
      case M2Quads_LogicalRotateOp:
      case M2Quads_LogicalOrOp:
      case M2Quads_LogicalAndOp:
      case M2Quads_LogicalXorOp:
      case M2Quads_CoerceOp:
      case M2Quads_ConvertOp:
      case M2Quads_CastOp:
      case M2Quads_AddOp:
      case M2Quads_SubOp:
      case M2Quads_MultOp:
      case M2Quads_DivM2Op:
      case M2Quads_ModM2Op:
      case M2Quads_ModFloorOp:
      case M2Quads_DivCeilOp:
      case M2Quads_ModCeilOp:
      case M2Quads_DivFloorOp:
      case M2Quads_ModTruncOp:
      case M2Quads_DivTruncOp:
        CheckConst (Oper1);
        CheckAddVariableWrite (Oper1, false, QuadNo);
        CheckAddVariableRead (Oper2, false, QuadNo);
        CheckAddVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_XIndrOp:
        CheckConst (Oper1);
        CheckAddVariableWrite (Oper1, true, QuadNo);
        CheckAddVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_IndrXOp:
        CheckConst (Oper1);
        CheckAddVariableWrite (Oper1, false, QuadNo);
        CheckAddVariableRead (Oper3, true, QuadNo);
        break;

      case M2Quads_SaveExceptionOp:
        /* RangeCheckOp      : CheckRangeAddVariableRead(Oper3, QuadNo) |  */
        CheckConst (Oper1);
        CheckAddVariableWrite (Oper1, false, QuadNo);
        break;

      case M2Quads_RestoreExceptionOp:
        CheckAddVariableRead (Oper1, false, QuadNo);
        break;


      default:
        break;
    }
}


/*
   PutQuadO - alters a quadruple QuadNo with Op, Oper1, Oper2, Oper3, and
              sets a boolean to determinine whether overflow should be checked.
*/

static void PutQuadO (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflow)
{
  PutQuadOType (QuadNo, Op, Oper1, Oper2, Oper3, overflow, true);
}


/*
   PutQuadOType -
*/

static void PutQuadOType (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflow, bool checktype)
{
  M2Quads_QuadFrame f;

  if (QuadrupleGeneration)
    {
      M2Quads_EraseQuad (QuadNo);
      AddQuadInformation (QuadNo, Op, Oper1, Oper2, Oper3);
      f = GetQF (QuadNo);
      f->Operator = Op;
      f->Operand1 = Oper1;
      f->Operand2 = Oper2;
      f->Operand3 = Oper3;
      f->CheckOverflow = overflow;
      f->CheckType = checktype;
      f->ConstExpr = false;  /* IsInConstExpression ()  */
    }
   /* IsInConstExpression ()  */
}


/*
   UndoReadWriteInfo -
*/

static void UndoReadWriteInfo (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3)
{
  switch (Op)
    {
      case M2Quads_IfInOp:
      case M2Quads_IfNotInOp:
      case M2Quads_IfEquOp:
      case M2Quads_IfNotEquOp:
      case M2Quads_IfLessOp:
      case M2Quads_IfLessEquOp:
      case M2Quads_IfGreOp:
      case M2Quads_IfGreEquOp:
        /* jumps, calls and branches  */
        RemoveReference (QuadNo);
        CheckRemoveVariableRead (Oper1, false, QuadNo);
        CheckRemoveVariableRead (Oper2, false, QuadNo);
        break;

      case M2Quads_TryOp:
      case M2Quads_RetryOp:
      case M2Quads_GotoOp:
        RemoveReference (QuadNo);
        break;

      case M2Quads_InclOp:
      case M2Quads_ExclOp:
        /* variable references  */
        CheckRemoveVariableRead (Oper1, false, QuadNo);
        CheckRemoveVariableWrite (Oper1, true, QuadNo);
        break;

      case M2Quads_UnboundedOp:
      case M2Quads_FunctValueOp:
      case M2Quads_NegateOp:
      case M2Quads_BecomesOp:
      case M2Quads_HighOp:
      case M2Quads_SizeOp:
        CheckRemoveVariableWrite (Oper1, false, QuadNo);
        CheckRemoveVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_AddrOp:
        CheckRemoveVariableWrite (Oper1, false, QuadNo);
        /* the next line is a kludge and assumes we _will_
                          write to the variable as we have taken its address  */
        CheckRemoveVariableWrite (Oper1, true, QuadNo);
        break;

      case M2Quads_ReturnValueOp:
        CheckRemoveVariableRead (Oper1, false, QuadNo);
        break;

      case M2Quads_ReturnOp:
      case M2Quads_CallOp:
      case M2Quads_NewLocalVarOp:
      case M2Quads_KillLocalVarOp:
        break;

      case M2Quads_ParamOp:
        CheckRemoveVariableRead (Oper2, false, QuadNo);
        CheckRemoveVariableRead (Oper3, false, QuadNo);
        if (((Oper1 > 0) && (Oper1 <= (SymbolTable_NoOfParamAny (Oper2)))) && (SymbolTable_IsVarParamAny (Oper2, Oper1)))
          {
            /* _may_ also write to a var parameter, although we dont know  */
            CheckRemoveVariableWrite (Oper3, true, QuadNo);
          }
        break;

      case M2Quads_RecordFieldOp:
      case M2Quads_ArrayOp:
      case M2Quads_LogicalShiftOp:
      case M2Quads_LogicalRotateOp:
      case M2Quads_LogicalOrOp:
      case M2Quads_LogicalAndOp:
      case M2Quads_LogicalXorOp:
      case M2Quads_CoerceOp:
      case M2Quads_ConvertOp:
      case M2Quads_CastOp:
      case M2Quads_AddOp:
      case M2Quads_SubOp:
      case M2Quads_MultOp:
      case M2Quads_DivM2Op:
      case M2Quads_ModM2Op:
      case M2Quads_ModFloorOp:
      case M2Quads_DivCeilOp:
      case M2Quads_ModCeilOp:
      case M2Quads_DivFloorOp:
      case M2Quads_ModTruncOp:
      case M2Quads_DivTruncOp:
        CheckRemoveVariableWrite (Oper1, false, QuadNo);
        CheckRemoveVariableRead (Oper2, false, QuadNo);
        CheckRemoveVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_XIndrOp:
        CheckRemoveVariableWrite (Oper1, true, QuadNo);
        CheckRemoveVariableRead (Oper3, false, QuadNo);
        break;

      case M2Quads_IndrXOp:
        CheckRemoveVariableWrite (Oper1, false, QuadNo);
        CheckRemoveVariableRead (Oper3, true, QuadNo);
        break;

      case M2Quads_SaveExceptionOp:
        /* RangeCheckOp      : CheckRangeRemoveVariableRead(Oper3, QuadNo) |  */
        CheckRemoveVariableWrite (Oper1, false, QuadNo);
        break;

      case M2Quads_RestoreExceptionOp:
        CheckRemoveVariableRead (Oper1, false, QuadNo);
        break;


      default:
        break;
    }
}


/*
   CheckAddTuple2Read - checks to see whether symbol tuple contains variables or
                        parameters and if so it then adds them to the quadruple
                        variable list.
*/

static void CheckAddTuple2Read (unsigned int tuple, bool canDereference, unsigned int Quad)
{
  if (SymbolTable_IsTuple (tuple))
    {
      CheckAddVariableRead (SymbolTable_GetNth (tuple, 1), canDereference, Quad);
      CheckAddVariableRead (SymbolTable_GetNth (tuple, 2), canDereference, Quad);
    }
}


/*
   CheckAddVariableRead - checks to see whether symbol, Sym, is a variable or
                          a parameter and if so it then adds this quadruple
                          to the variable list.
*/

static void CheckAddVariableRead (unsigned int Sym, bool canDereference, unsigned int Quad)
{
  if (SymbolTable_IsVar (Sym))
    {
      SymbolTable_PutReadQuad (Sym, SymbolTable_GetMode (Sym), Quad);
      if (((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue) && canDereference)
        {
          SymbolTable_PutReadQuad (Sym, SymbolTable_RightValue, Quad);
        }
    }
}


/*
   CheckRemoveVariableRead - checks to see whether, Sym, is a variable or
                             a parameter and if so then it removes the
                             quadruple from the variable list.
*/

static void CheckRemoveVariableRead (unsigned int Sym, bool canDereference, unsigned int Quad)
{
  if (SymbolTable_IsVar (Sym))
    {
      SymbolTable_RemoveReadQuad (Sym, SymbolTable_GetMode (Sym), Quad);
      if (((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue) && canDereference)
        {
          SymbolTable_RemoveReadQuad (Sym, SymbolTable_RightValue, Quad);
        }
    }
}


/*
   CheckAddVariableWrite - checks to see whether symbol, Sym, is a variable and
                           if so it then adds this quadruple to the variable list.
*/

static void CheckAddVariableWrite (unsigned int Sym, bool canDereference, unsigned int Quad)
{
  if (SymbolTable_IsVar (Sym))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue) && canDereference)
        {
          SymbolTable_PutReadQuad (Sym, SymbolTable_LeftValue, Quad);
          SymbolTable_PutWriteQuad (Sym, SymbolTable_RightValue, Quad);
        }
      else
        {
          SymbolTable_PutWriteQuad (Sym, SymbolTable_GetMode (Sym), Quad);
        }
    }
}


/*
   CheckRemoveVariableWrite - checks to see whether, Sym, is a variable and
                              if so then it removes the quadruple from the
                              variable list.
*/

static void CheckRemoveVariableWrite (unsigned int Sym, bool canDereference, unsigned int Quad)
{
  if (SymbolTable_IsVar (Sym))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue) && canDereference)
        {
          SymbolTable_RemoveReadQuad (Sym, SymbolTable_LeftValue, Quad);
          SymbolTable_RemoveWriteQuad (Sym, SymbolTable_RightValue, Quad);
        }
      else
        {
          SymbolTable_RemoveWriteQuad (Sym, SymbolTable_GetMode (Sym), Quad);
        }
    }
}


/*
   CheckConst -
*/

static void CheckConst (unsigned int sym)
{
  if (SymbolTable_IsConst (sym))
    {
      M2GCCDeclare_PutToBeSolvedByQuads (sym);
    }
}


/*
   AlterReference - alters all references from OldQuad, to NewQuad in a
                    quadruple list Head.
*/

static void AlterReference (unsigned int Head, unsigned int OldQuad, unsigned int NewQuad)
{
  M2Quads_QuadFrame f;
  M2Quads_QuadFrame g;
  unsigned int i;

  f = GetQF (OldQuad);
  while ((f->NoOfTimesReferenced > 0) && (Head != 0))
    {
      g = GetQF (Head);
      switch (g->Operator)
        {
          case M2Quads_IfInOp:
          case M2Quads_IfNotInOp:
          case M2Quads_IfEquOp:
          case M2Quads_IfNotEquOp:
          case M2Quads_IfLessOp:
          case M2Quads_IfLessEquOp:
          case M2Quads_IfGreOp:
          case M2Quads_IfGreEquOp:
          case M2Quads_TryOp:
          case M2Quads_RetryOp:
          case M2Quads_GotoOp:
            if (g->Operand3 == OldQuad)
              {
                ManipulateReference (Head, NewQuad);
              }
            break;


          default:
            break;
        }
      i = g->Next;
      Head = i;
    }
}


/*
   GrowQuads - grows the list of quadruples to the quadruple, to.
*/

static void GrowQuads (unsigned int to)
{
  unsigned int i;
  M2Quads_QuadFrame f;

  if ((to != 0) && (to > GrowInitialization))
    {
      i = GrowInitialization+1;
      while (i <= to)
        {
          if (Indexing_InBounds (QuadArray, i))
            {
              M2Debug_Assert ((Indexing_GetIndice (QuadArray, i)) != NULL);
            }
          else
            {
              Storage_ALLOCATE ((void **) &f, sizeof (M2Quads__T3));
              if (f == NULL)
                {
                  M2Error_InternalError ((const char *) "out of memory error when trying to allocate a quadruple", 55);
                }
              Indexing_PutIndice (QuadArray, i, reinterpret_cast <void *> (f));
              f->NoOfTimesReferenced = 0;
            }
          i += 1;
        }
      GrowInitialization = to;
    }
}


/*
   ManipulateReference - manipulates the quadruple, q, so that it now points to quad, to.
*/

static void ManipulateReference (unsigned int q, unsigned int to)
{
  M2Quads_QuadFrame f;

  M2Debug_Assert ((GrowInitialization >= q) || (to == 0));
  GrowQuads (to);
  RemoveReference (q);
  f = GetQF (q);
  f->Operand3 = to;
  if (to != 0)
    {
      f = GetQF (to);
      f->NoOfTimesReferenced += 1;
    }
}


/*
   RemoveReference - remove the reference by quadruple q to wherever
                     it was pointing.
*/

static void RemoveReference (unsigned int q)
{
  M2Quads_QuadFrame f;
  M2Quads_QuadFrame g;

  f = GetQF (q);
  if ((f->Operand3 != 0) && (f->Operand3 < NextQuad))
    {
      CheckBreak (f->Operand3);
      g = GetQF (f->Operand3);
      M2Debug_Assert (g->NoOfTimesReferenced != 0);
      g->NoOfTimesReferenced -= 1;
    }
}


/*
   NewQuad - sets QuadNo to a new quadruple.
*/

static void NewQuad (unsigned int *QuadNo)
{
  M2Quads_QuadFrame f;

  (*QuadNo) = FreeList;
  if ((Indexing_InBounds (QuadArray, (*QuadNo))) && ((Indexing_GetIndice (QuadArray, (*QuadNo))) != NULL))
    {
      f = static_cast<M2Quads_QuadFrame> (Indexing_GetIndice (QuadArray, (*QuadNo)));
    }
  else
    {
      Storage_ALLOCATE ((void **) &f, sizeof (M2Quads__T3));
      if (f == NULL)
        {
          M2Error_InternalError ((const char *) "out of memory error trying to allocate a quadruple", 50);
        }
      else
        {
          NoOfQuads += 1;
          Indexing_PutIndice (QuadArray, (*QuadNo), reinterpret_cast <void *> (f));
          f->NoOfTimesReferenced = 0;
        }
    }
  f->Operator = M2Quads_DummyOp;
  f->Operand3 = 0;
  f->Next = 0;
  FreeList += 1;
  if (GrowInitialization < FreeList)
    {
      GrowInitialization = FreeList;
    }
}


/*
   CheckVariableAt - checks to see whether, sym, was declared at a particular address.
*/

static void CheckVariableAt (unsigned int sym)
{
  if ((SymbolTable_IsVar (sym)) && (SymbolTable_IsVariableAtAddress (sym)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue)
        {
          GenQuad (M2Quads_InitAddressOp, sym, SymbolTable_NulSym, SymbolTable_GetVariableAtAddress (sym));
        }
      else
        {
          M2Error_InternalError ((const char *) "expecting lvalue for this variable which is declared at an explicit address", 75);
        }
    }
}


/*
   CheckVariablesAt - checks to see whether we need to initialize any pointers
                      which point to variable declared at addresses.
*/

static void CheckVariablesAt (unsigned int scope)
{
  SymbolTable_ForeachLocalSymDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CheckVariableAt});
}


/*
   GetTurnInterrupts - returns the TurnInterrupts procedure function.
*/

static unsigned int GetTurnInterrupts (unsigned int tok)
{
  if (M2Options_Iso)
    {
      return GetQualidentImport (tok, NameKey_MakeKey ((const char *) "TurnInterrupts", 14), NameKey_MakeKey ((const char *) "COROUTINES", 10));
    }
  else
    {
      return GetQualidentImport (tok, NameKey_MakeKey ((const char *) "TurnInterrupts", 14), NameKey_MakeKey ((const char *) "SYSTEM", 6));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetProtection - returns the PROTECTION data type.
*/

static unsigned int GetProtection (unsigned int tok)
{
  if (M2Options_Iso)
    {
      return GetQualidentImport (tok, NameKey_MakeKey ((const char *) "PROTECTION", 10), NameKey_MakeKey ((const char *) "COROUTINES", 10));
    }
  else
    {
      return GetQualidentImport (tok, NameKey_MakeKey ((const char *) "PROTECTION", 10), NameKey_MakeKey ((const char *) "SYSTEM", 6));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckNeedPriorityBegin - checks to see whether we need to save the old
                            module priority and change to another module
                            priority.
                            The current module initialization or procedure
                            being built is defined by, scope. The module whose
                            priority will be used is defined by, module.
*/

static void CheckNeedPriorityBegin (unsigned int tok, unsigned int scope, unsigned int module)
{
  unsigned int ProcSym;
  unsigned int old;

  if ((SymbolTable_GetPriority (module)) != SymbolTable_NulSym)
    {
      /* module has been given a priority  */
      ProcSym = GetTurnInterrupts (tok);
      if (ProcSym != SymbolTable_NulSym)
        {
          old = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
          SymbolTable_PutVar (old, GetProtection (tok));
          GenQuadO (tok, M2Quads_SavePriorityOp, old, scope, ProcSym, false);
          M2StackWord_PushWord (PriorityStack, old);
        }
    }
}


/*
   CheckNeedPriorityEnd - checks to see whether we need to restore the old
                          module priority.
                          The current module initialization or procedure
                          being built is defined by, scope.
*/

static void CheckNeedPriorityEnd (unsigned int tok, unsigned int scope, unsigned int module)
{
  unsigned int ProcSym;
  unsigned int old;

  if ((SymbolTable_GetPriority (module)) != SymbolTable_NulSym)
    {
      /* module has been given a priority  */
      ProcSym = GetTurnInterrupts (tok);
      if (ProcSym != SymbolTable_NulSym)
        {
          old = static_cast<unsigned int> (M2StackWord_PopWord (PriorityStack));
          GenQuad (M2Quads_RestorePriorityOp, old, scope, ProcSym);
        }
    }
}


/*
   BuildRTExceptEnter - informs RTExceptions that we are about to enter the except state.
*/

static void BuildRTExceptEnter (unsigned int tok)
{
  unsigned int old;
  unsigned int ProcSym;

  if (M2Options_Exceptions)
    {
      /* now inform the Modula-2 runtime we are in the exception state  */
      ProcSym = GetQualidentImport (tok, NameKey_MakeKey ((const char *) "SetExceptionState", 17), NameKey_MakeKey ((const char *) "RTExceptions", 12));
      if (ProcSym == SymbolTable_NulSym)
        {
          M2MetaError_MetaErrorT0 (tok, (const char *) "{%W}no procedure SetExceptionState found in RTExceptions which is needed to implement exception handling", 104);
        }
      else
        {
          old = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
          SymbolTable_PutVar (old, M2Base_Boolean);
          GenQuadO (tok, M2Quads_SaveExceptionOp, old, SymbolTable_NulSym, ProcSym, false);
          M2StackWord_PushWord (ExceptStack, old);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (tok, (const char *) "{%E}cannot use {%kEXCEPT} blocks with the -fno-exceptions flag", 62);
    }
}


/*
   BuildRTExceptLeave - informs RTExceptions that we are about to leave the except state.
                        If, destroy, is TRUE then pop the ExceptStack.
*/

static void BuildRTExceptLeave (unsigned int tok, bool destroy)
{
  unsigned int old;
  unsigned int ProcSym;

  if (M2Options_Exceptions)
    {
      /* avoid dangling else.  */
      /* now inform the Modula-2 runtime we are in the exception state  */
      ProcSym = GetQualidentImport (tok, NameKey_MakeKey ((const char *) "SetExceptionState", 17), NameKey_MakeKey ((const char *) "RTExceptions", 12));
      if (ProcSym != SymbolTable_NulSym)
        {
          if (destroy)
            {
              old = static_cast<unsigned int> (M2StackWord_PopWord (ExceptStack));
            }
          else
            {
              old = static_cast<unsigned int> (M2StackWord_PeepWord (ExceptStack, 1));
            }
          GenQuadO (tok, M2Quads_RestoreExceptionOp, old, SymbolTable_NulSym, ProcSym, false);
        }
    }
  /* no need for an error message here as it will be generated in the Enter procedure above  */
}


/*
   SafeRequestSym - only used during scaffold to get argc, argv, envp.
                    It attempts to get symbol name from the current scope(s) and if
                    it fails then it falls back onto default constants.
*/

static unsigned int SafeRequestSym (unsigned int tok, NameKey_Name name)
{
  unsigned int sym;

  sym = SymbolTable_GetSym (name);
  if (sym == SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (name == (NameKey_MakeKey ((const char *) "argc", 4)))
        {
          return SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType);
        }
      else if ((name == (NameKey_MakeKey ((const char *) "argv", 4))) || (name == (NameKey_MakeKey ((const char *) "envp", 4))))
        {
          /* avoid dangling else.  */
          return M2Base_Nil;
        }
      else
        {
          /* avoid dangling else.  */
          M2Error_InternalError ((const char *) "not expecting this parameter name", 33);
          return M2Base_Nil;
        }
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   callRequestDependant - create a call:
                          RequestDependant (GetSymName (modulesym), GetLibName (modulesym),
                                            GetSymName (depModuleSym), GetLibName (depModuleSym));
*/

static void callRequestDependant (unsigned int tokno, unsigned int moduleSym, unsigned int depModuleSym, unsigned int requestDep)
{
  M2Debug_Assert (requestDep != SymbolTable_NulSym);
  M2Quads_PushTtok (requestDep, tokno);
  M2Quads_PushTFtok (M2System_Adr, M2System_Address, tokno);
  M2Quads_PushTtok (SymbolTable_MakeConstString (tokno, SymbolTable_GetSymName (moduleSym)), tokno);
  M2Quads_PushT (static_cast<unsigned int> (1));
  BuildAdrFunction ();
  M2Quads_PushTFtok (M2System_Adr, M2System_Address, tokno);
  M2Quads_PushTtok (SymbolTable_MakeConstString (tokno, SymbolTable_GetLibName (moduleSym)), tokno);
  M2Quads_PushT (static_cast<unsigned int> (1));
  BuildAdrFunction ();
  if (depModuleSym == SymbolTable_NulSym)
    {
      M2Quads_PushTF (M2Base_Nil, M2System_Address);
      M2Quads_PushTF (M2Base_Nil, M2System_Address);
    }
  else
    {
      M2Quads_PushTFtok (M2System_Adr, M2System_Address, tokno);
      M2Quads_PushTtok (SymbolTable_MakeConstString (tokno, SymbolTable_GetSymName (depModuleSym)), tokno);
      M2Quads_PushT (static_cast<unsigned int> (1));
      BuildAdrFunction ();
      M2Quads_PushTFtok (M2System_Adr, M2System_Address, tokno);
      M2Quads_PushTtok (SymbolTable_MakeConstString (tokno, SymbolTable_GetLibName (depModuleSym)), tokno);
      M2Quads_PushT (static_cast<unsigned int> (1));
      BuildAdrFunction ();
    }
  M2Quads_PushT (static_cast<unsigned int> (4));
  M2Quads_BuildProcedureCall (tokno);
}


/*
   ForeachImportInDepDo -
*/

static void ForeachImportInDepDo (Lists_List importStatements, unsigned int moduleSym, unsigned int requestDep)
{
  unsigned int i;
  unsigned int j;
  unsigned int m;
  unsigned int n;
  unsigned int imported;
  unsigned int stmt;
  Lists_List l;

  if (importStatements != NULL)
    {
      i = 1;
      n = Lists_NoOfItemsInList (importStatements);
      while (i <= n)
        {
          stmt = static_cast<unsigned int> (Lists_GetItemFromList (importStatements, i));
          M2Debug_Assert (SymbolTable_IsImportStatement (stmt));
          l = SymbolTable_GetImportStatementList (stmt);
          j = 1;
          m = Lists_NoOfItemsInList (l);
          while (j <= m)
            {
              imported = static_cast<unsigned int> (Lists_GetItemFromList (l, j));
              M2Debug_Assert (SymbolTable_IsImport (imported));
              callRequestDependant (SymbolTable_GetImportDeclared (imported), moduleSym, SymbolTable_GetImportModule (imported), requestDep);
              j += 1;
            }
          i += 1;
        }
    }
}


/*
   ForeachImportedModuleDo -
*/

static void ForeachImportedModuleDo (unsigned int moduleSym, unsigned int requestDep)
{
  Lists_List importStatements;

  importStatements = SymbolTable_GetModuleModImportStatementList (moduleSym);
  ForeachImportInDepDo (importStatements, moduleSym, requestDep);
  importStatements = SymbolTable_GetModuleDefImportStatementList (moduleSym);
  ForeachImportInDepDo (importStatements, moduleSym, requestDep);
}


/*
   BuildM2DepFunction - creates the dependency graph procedure using IR:
                        static void
                        dependencies (void)
                        {
                           M2RTS_RequestDependant (module_name, libname, "b", "b libname");
                           M2RTS_RequestDependant (module_name, libname, NULL, NULL);
                        }
*/

static void BuildM2DepFunction (unsigned int tokno, unsigned int moduleSym)
{
  unsigned int requestDep;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  if (M2Options_ScaffoldDynamic)
    {
      /* Scaffold required and dynamic dependency graph should be produced.  */
      SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
      M2Quads_PushT (dep);
      M2Quads_BuildProcedureStart ();
      M2Quads_BuildProcedureBegin ();
      SymbolTable_StartScope (dep);
      requestDep = GetQualidentImport (tokno, NameKey_MakeKey ((const char *) "RequestDependant", 16), NameKey_MakeKey ((const char *) "M2RTS", 5));
      if (requestDep != SymbolTable_NulSym)
        {
          ForeachImportedModuleDo (moduleSym, requestDep);
          callRequestDependant (tokno, moduleSym, SymbolTable_NulSym, requestDep);
        }
      SymbolTable_EndScope ();
      M2Quads_BuildProcedureEnd ();
      M2Quads_PopN (1);
    }
}


/*
   BuildM2LinkFunction - creates the _M2_link procedure which will
                         cause the linker to pull in all the module ctors.
*/

static void BuildM2LinkFunction (unsigned int tokno)
{
  if (M2Options_ScaffoldDynamic)
    {
      if (M2Scaffold_linkFunction != SymbolTable_NulSym)
        {
          /* void
           _M2_link (void)
           {
              for each module in uselist do
                 PROC foo_%d = _M2_module_ctor
              done
           }.  */
          M2Quads_PushT (M2Scaffold_linkFunction);
          M2Quads_BuildProcedureStart ();
          M2Quads_BuildProcedureBegin ();
          SymbolTable_StartScope (M2Scaffold_linkFunction);
          M2Scaffold_PopulateCtorArray (tokno);
          SymbolTable_EndScope ();
          M2Quads_BuildProcedureEnd ();
          M2Quads_PopN (1);
        }
    }
}


/*
   BuildTry - build the try statement for main.
*/

static void BuildTry (unsigned int tokno)
{
  if (M2Options_Exceptions)
    {
      M2StackWord_PushWord (TryStack, NextQuad);
      M2StackWord_PushWord (CatchStack, static_cast<unsigned int> (0));
      GenQuadO (tokno, M2Quads_TryOp, SymbolTable_NulSym, SymbolTable_NulSym, 0, false);
    }
}


/*
   BuildExcept - build the except block for main.
*/

static void BuildExcept (unsigned int tokno)
{
  unsigned int catchProcedure;

  if (M2Options_Exceptions)
    {
      M2Quads_BuildExceptInitial (tokno);
      catchProcedure = GetQualidentImport (tokno, NameKey_MakeKey ((const char *) "DefaultErrorCatch", 17), NameKey_MakeKey ((const char *) "RTExceptions", 12));
      if (catchProcedure != SymbolTable_NulSym)
        {
          M2Quads_PushTtok (catchProcedure, tokno);
          M2Quads_PushT (static_cast<unsigned int> (0));
          M2Quads_BuildProcedureCall (tokno);
        }
      BuildRTExceptLeave (tokno, true);
      GenQuadO (tokno, M2Quads_CatchEndOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym, false);
    }
}


/*
   BuildM2MainFunction - creates the main function with appropriate calls to the scaffold.
*/

static void BuildM2MainFunction (unsigned int tokno)
{
  if ((M2Options_ScaffoldDynamic || M2Options_ScaffoldStatic) && ! M2Options_SharedFlag)
    {
      /* 
         int
         main (int argc, char *argv[], char *envp[])
         {
            try {
               _M2_init (argc, argv, envp);
               _M2_fini (argc, argv, envp);
               return 0;
            }
            catch (...) {
               RTExceptions_DefaultErrorCatch ();
               return 0;
            }
         }
  */
      M2Quads_PushT (M2Scaffold_mainFunction);
      M2Quads_BuildProcedureStart ();
      M2Quads_BuildProcedureBegin ();
      SymbolTable_StartScope (M2Scaffold_mainFunction);
      BuildTry (tokno);
      /* _M2_init (argc, argv, envp);  */
      M2Quads_PushTtok (M2Scaffold_initFunction, tokno);
      M2Quads_PushTtok (SymbolTable_RequestSym (tokno, NameKey_MakeKey ((const char *) "argc", 4)), tokno);
      M2Quads_PushTtok (SymbolTable_RequestSym (tokno, NameKey_MakeKey ((const char *) "argv", 4)), tokno);
      M2Quads_PushTtok (SymbolTable_RequestSym (tokno, NameKey_MakeKey ((const char *) "envp", 4)), tokno);
      M2Quads_PushT (static_cast<unsigned int> (3));
      M2Quads_BuildProcedureCall (tokno);
      /* _M2_fini (argc, argv, envp);  */
      M2Quads_PushTtok (M2Scaffold_finiFunction, tokno);
      M2Quads_PushTtok (SymbolTable_RequestSym (tokno, NameKey_MakeKey ((const char *) "argc", 4)), tokno);
      M2Quads_PushTtok (SymbolTable_RequestSym (tokno, NameKey_MakeKey ((const char *) "argv", 4)), tokno);
      M2Quads_PushTtok (SymbolTable_RequestSym (tokno, NameKey_MakeKey ((const char *) "envp", 4)), tokno);
      M2Quads_PushT (static_cast<unsigned int> (3));
      M2Quads_BuildProcedureCall (tokno);
      PushZero (tokno, M2Base_Integer);
      M2Quads_BuildReturn (tokno);
      BuildExcept (tokno);
      PushZero (tokno, M2Base_Integer);
      M2Quads_BuildReturn (tokno);
      SymbolTable_EndScope ();
      M2Quads_BuildProcedureEnd ();
      M2Quads_PopN (1);
    }
}


/*
   DeferMakeConstStringCnul - return a C const string which will be nul terminated.
*/

static unsigned int DeferMakeConstStringCnul (unsigned int tok, unsigned int sym)
{
  unsigned int const_;

  const_ = SymbolTable_MakeConstStringCnul (tok, NameKey_NulName, false);
  GenQuadO (tok, M2Quads_StringConvertCnulOp, const_, 0, sym, false);
  return const_;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeferMakeConstStringM2nul - return a const string which will be nul terminated.
*/

static unsigned int DeferMakeConstStringM2nul (unsigned int tok, unsigned int sym)
{
  unsigned int const_;

  const_ = SymbolTable_MakeConstStringM2nul (tok, NameKey_NulName, false);
  GenQuadO (tok, M2Quads_StringConvertM2nulOp, const_, 0, sym, false);
  return const_;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildStringAdrParam - push the address of a nul terminated string onto the quad stack.
*/

static void BuildStringAdrParam (unsigned int tok, NameKey_Name name)
{
  unsigned int str;
  unsigned int m2strnul;

  M2Quads_PushTFtok (M2System_Adr, M2System_Address, tok);
  str = SymbolTable_MakeConstString (tok, name);
  SymbolTable_PutConstStringKnown (tok, str, name, false, true);
  m2strnul = DeferMakeConstStringM2nul (tok, str);
  M2Quads_PushTtok (m2strnul, tok);
  M2Quads_PushT (static_cast<unsigned int> (1));
  BuildAdrFunction ();
}


/*
   BuildM2InitFunction -
*/

static void BuildM2InitFunction (unsigned int tok, unsigned int moduleSym)
{
  unsigned int constructModules;

  if (M2Options_ScaffoldDynamic || M2Options_ScaffoldStatic)
    {
      /* int
         _M2_init (int argc, char *argv[], char *envp[])
         {
            M2RTS_ConstructModules (module_name, libname,
                                    overrideliborder, argc, argv, envp);
         }  */
      M2Quads_PushT (M2Scaffold_initFunction);
      M2Quads_BuildProcedureStart ();
      M2Quads_BuildProcedureBegin ();
      SymbolTable_StartScope (M2Scaffold_initFunction);
      if (M2Options_ScaffoldDynamic)
        {
          /* avoid dangling else.  */
          if (M2Scaffold_linkFunction != SymbolTable_NulSym)
            {
              /* _M2_link ();  */
              M2Quads_PushTtok (M2Scaffold_linkFunction, tok);
              M2Quads_PushT (static_cast<unsigned int> (0));
              M2Quads_BuildProcedureCall (tok);
            }
          /* Lookup ConstructModules and call it.  */
          constructModules = GetQualidentImport (tok, NameKey_MakeKey ((const char *) "ConstructModules", 16), NameKey_MakeKey ((const char *) "M2RTS", 5));
          if (constructModules != SymbolTable_NulSym)
            {
              /* ConstructModules (module_name, argc, argv, envp);  */
              M2Quads_PushTtok (constructModules, tok);
              BuildStringAdrParam (tok, SymbolTable_GetSymName (moduleSym));
              BuildStringAdrParam (tok, SymbolTable_GetLibName (moduleSym));
              BuildStringAdrParam (tok, NameKey_makekey (M2Options_GetRuntimeModuleOverride ()));
              M2Quads_PushTtok (SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argc", 4)), tok);
              M2Quads_PushTtok (SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argv", 4)), tok);
              M2Quads_PushTtok (SafeRequestSym (tok, NameKey_MakeKey ((const char *) "envp", 4)), tok);
              M2Quads_PushT (static_cast<unsigned int> (6));
              M2Quads_BuildProcedureCall (tok);
            }
        }
      else if (M2Options_ScaffoldStatic)
        {
          /* avoid dangling else.  */
          M2Scaffold_ForeachModuleCallInit (tok, SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argc", 4)), SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argv", 4)), SafeRequestSym (tok, NameKey_MakeKey ((const char *) "envp", 4)));
        }
      SymbolTable_EndScope ();
      M2Quads_BuildProcedureEnd ();
      M2Quads_PopN (1);
    }
}


/*
   BuildM2FiniFunction -
*/

static void BuildM2FiniFunction (unsigned int tok, unsigned int moduleSym)
{
  unsigned int deconstructModules;

  if (M2Options_ScaffoldDynamic || M2Options_ScaffoldStatic)
    {
      /* Scaffold required and main should be produced.  */
      M2Quads_PushT (M2Scaffold_finiFunction);
      M2Quads_BuildProcedureStart ();
      M2Quads_BuildProcedureBegin ();
      SymbolTable_StartScope (M2Scaffold_finiFunction);
      if (M2Options_ScaffoldDynamic)
        {
          /* avoid dangling else.  */
          /* static void
            _M2_finish (int argc, char *argv[], char *envp[])
            {
              M2RTS_DeconstructModules (module_name, argc, argv, envp);
            }  */
          deconstructModules = GetQualidentImport (tok, NameKey_MakeKey ((const char *) "DeconstructModules", 18), NameKey_MakeKey ((const char *) "M2RTS", 5));
          if (deconstructModules != SymbolTable_NulSym)
            {
              /* DeconstructModules (module_name, argc, argv, envp);  */
              M2Quads_PushTtok (deconstructModules, tok);
              M2Quads_PushTFtok (M2System_Adr, M2System_Address, tok);
              M2Quads_PushTtok (SymbolTable_MakeConstString (tok, SymbolTable_GetSymName (moduleSym)), tok);
              M2Quads_PushT (static_cast<unsigned int> (1));
              BuildAdrFunction ();
              M2Quads_PushTFtok (M2System_Adr, M2System_Address, tok);
              M2Quads_PushTtok (SymbolTable_MakeConstString (tok, SymbolTable_GetLibName (moduleSym)), tok);
              M2Quads_PushT (static_cast<unsigned int> (1));
              BuildAdrFunction ();
              M2Quads_PushTtok (SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argc", 4)), tok);
              M2Quads_PushTtok (SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argv", 4)), tok);
              M2Quads_PushTtok (SafeRequestSym (tok, NameKey_MakeKey ((const char *) "envp", 4)), tok);
              M2Quads_PushT (static_cast<unsigned int> (5));
              M2Quads_BuildProcedureCall (tok);
            }
        }
      else if (M2Options_ScaffoldStatic)
        {
          /* avoid dangling else.  */
          M2Scaffold_ForeachModuleCallFinish (tok, SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argc", 4)), SafeRequestSym (tok, NameKey_MakeKey ((const char *) "argv", 4)), SafeRequestSym (tok, NameKey_MakeKey ((const char *) "envp", 4)));
        }
      SymbolTable_EndScope ();
      M2Quads_BuildProcedureEnd ();
      M2Quads_PopN (1);
    }
}


/*
   BuildM2CtorFunction - create a constructor function associated with moduleSym.

                         void
                         ctorFunction ()
                         {
                           M2RTS_RegisterModule (GetSymName (moduleSym), GetLibName (moduleSym),
                                                 init, fini, dependencies);
                         }
*/

static void BuildM2CtorFunction (unsigned int tok, unsigned int moduleSym)
{
  unsigned int RegisterModule;
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  if (M2Options_ScaffoldDynamic)
    {
      SymbolTable_GetModuleCtors (moduleSym, &ctor, &init, &fini, &dep);
      if (ctor != SymbolTable_NulSym)
        {
          M2Debug_Assert (SymbolTable_IsProcedure (ctor));
          M2Quads_PushT (ctor);
          M2Quads_BuildProcedureStart ();
          M2Quads_BuildProcedureBegin ();
          SymbolTable_StartScope (ctor);
          RegisterModule = GetQualidentImport (tok, NameKey_MakeKey ((const char *) "RegisterModule", 14), NameKey_MakeKey ((const char *) "M2RTS", 5));
          if (RegisterModule != SymbolTable_NulSym)
            {
              /* RegisterModule (module_name, init, fini, dependencies);  */
              M2Quads_PushTtok (RegisterModule, tok);
              M2Quads_PushTFtok (M2System_Adr, M2System_Address, tok);
              M2Quads_PushTtok (SymbolTable_MakeConstString (tok, SymbolTable_GetSymName (moduleSym)), tok);
              M2Quads_PushT (static_cast<unsigned int> (1));
              BuildAdrFunction ();
              M2Quads_PushTFtok (M2System_Adr, M2System_Address, tok);
              M2Quads_PushTtok (SymbolTable_MakeConstString (tok, SymbolTable_GetLibName (moduleSym)), tok);
              M2Quads_PushT (static_cast<unsigned int> (1));
              BuildAdrFunction ();
              M2Quads_PushTtok (init, tok);
              M2Quads_PushTtok (fini, tok);
              M2Quads_PushTtok (dep, tok);
              M2Quads_PushT (static_cast<unsigned int> (5));
              M2Quads_BuildProcedureCall (tok);
            }
          SymbolTable_EndScope ();
          M2Quads_BuildProcedureEnd ();
          M2Quads_PopN (1);
        }
    }
}


/*
   AddForInfo - adds the description of the FOR loop into the record list.
                This is used if -pedantic is turned on to check index variable
                usage.
*/

static void AddForInfo (unsigned int Start, unsigned int End, unsigned int IncQuad, unsigned int Sym, unsigned int idtok)
{
  M2Quads_ForLoopInfo forDesc;

  if (M2Options_Pedantic)
    {
      Storage_ALLOCATE ((void **) &forDesc, sizeof (M2Quads__T5));
      forDesc->IncrementQuad = IncQuad;
      forDesc->StartOfForLoop = Start;
      forDesc->EndOfForLoop = End;
      forDesc->ForLoopIndex = Sym;
      forDesc->IndexTok = idtok;
      Indexing_IncludeIndiceIntoIndex (ForInfo, reinterpret_cast <void *> (forDesc));
    }
}


/*
   CheckForIndex - checks the quadruples: Start..End to see whether a
                   for loop index is manipulated by the programmer.
                   It generates a warning if this is the case.
                   It also checks to see whether the IndexSym is read
                   immediately outside the loop in which case a warning
                   is issued.
*/

static void CheckForIndex (M2Quads_ForLoopInfo forDesc)
{
  unsigned int ReadStart;
  unsigned int ReadEnd;
  unsigned int WriteStart;
  unsigned int WriteEnd;

  SymbolTable_GetWriteLimitQuads (forDesc->ForLoopIndex, SymbolTable_RightValue, forDesc->StartOfForLoop, forDesc->EndOfForLoop, &WriteStart, &WriteEnd);
  if ((WriteStart < forDesc->IncrementQuad) && (WriteStart > forDesc->StartOfForLoop))
    {
      M2MetaError_MetaErrorT1 (forDesc->IndexTok, (const char *) "{%kFOR} loop index variable {%1Wad} is being manipulated inside the loop", 72, forDesc->ForLoopIndex);
      M2MetaError_MetaErrorT1 (M2Quads_QuadToTokenNo (WriteStart), (const char *) "{%kFOR} loop index variable {%1Wad} is being manipulated, this is considered bad practice and may cause unknown program behaviour", 129, forDesc->ForLoopIndex);
    }
  SymbolTable_GetWriteLimitQuads (forDesc->ForLoopIndex, SymbolTable_RightValue, forDesc->EndOfForLoop, 0, &WriteStart, &WriteEnd);
  SymbolTable_GetReadLimitQuads (forDesc->ForLoopIndex, SymbolTable_RightValue, forDesc->EndOfForLoop, 0, &ReadStart, &ReadEnd);
  if ((ReadStart != 0) && ((ReadStart < WriteStart) || (WriteStart == 0)))
    {
      M2MetaError_MetaErrorT1 (forDesc->IndexTok, (const char *) "{%kFOR} loop index variable {%1Wad} is being read outside the FOR loop (without being reset)", 92, forDesc->ForLoopIndex);
      M2MetaError_MetaErrorT1 (M2Quads_QuadToTokenNo (ReadStart), (const char *) "{%kFOR} loop index variable {%1Wad} is being read outside the FOR loop (without being reset), this is considered extremely bad practice and may cause unknown program behaviour", 175, forDesc->ForLoopIndex);
    }
}


/*
   BuildRange - generates a RangeCheckOp quad with, r, as its operand.
*/

static void BuildRange (unsigned int r)
{
  GenQuad (M2Quads_RangeCheckOp, (unsigned int ) (M2LexBuf_GetLineNo ()), SymbolTable_NulSym, r);
}


/*
   BuildError - generates a ErrorOp quad, indicating that if this
                quadruple is reachable, then a runtime error would
                occur.
*/

static void BuildError (unsigned int r)
{
  GenQuad (M2Quads_ErrorOp, (unsigned int ) (M2LexBuf_GetLineNo ()), SymbolTable_NulSym, r);
}


/*
   CheckPointerThroughNil - builds a range quadruple, providing, sym, is
                            a candidate for checking against NIL.
                            This range quadruple is only expanded into
                            code during the code generation phase
                            thus allowing limited compile time checking.
*/

static void CheckPointerThroughNil (unsigned int tokpos, unsigned int sym)
{
  if ((SymbolTable_IsVar (sym)) && (SymbolTable_GetVarPointerCheck (sym)))
    {
      /* PutVarPointerCheck(sym, FALSE) ;   so we do not detect this again  */
      BuildRange (M2Range_InitPointerRangeCheck (tokpos, sym, (SymbolTable_GetMode (sym)) == SymbolTable_LeftValue));
    }
}


/*
   CollectLow - returns the low of the subrange value.
*/

static unsigned int CollectLow (unsigned int sym)
{
  unsigned int low;
  unsigned int high;

  if (SymbolTable_IsSubrange (sym))
    {
      SymbolTable_GetSubrange (sym, &high, &low);
      return low;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting Subrange symbol", 25);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Quads.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CollectHigh - returns the high of the subrange value, sym.
*/

static unsigned int CollectHigh (unsigned int sym)
{
  unsigned int low;
  unsigned int high;

  if (SymbolTable_IsSubrange (sym))
    {
      SymbolTable_GetSubrange (sym, &high, &low);
      return high;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting Subrange symbol", 25);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Quads.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CheckCompatibleWithBecomes - checks to see that symbol, sym, is
                                compatible with the := operator.
*/

static void CheckCompatibleWithBecomes (unsigned int des, unsigned int expr, unsigned int destok, unsigned int exprtok)
{
  if (SymbolTable_IsType (des))
    {
      M2MetaError_MetaErrorT1 (destok, (const char *) "an assignment cannot assign a value to a type {%1a}", 51, des);
    }
  else if (SymbolTable_IsProcedure (des))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (destok, (const char *) "an assignment cannot assign a value to a procedure {%1a}", 56, des);
    }
  else if (SymbolTable_IsFieldEnumeration (des))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (destok, (const char *) "an assignment cannot assign a value to an enumeration field {%1a}", 65, des);
    }
  if ((M2Base_IsPseudoBaseProcedure (expr)) || (M2Base_IsPseudoBaseFunction (expr)))
    {
      M2MetaError_MetaErrorT1 (exprtok, (const char *) "an assignment cannot assign a {%1d} {%1a}", 41, expr);
    }
}


/*
   BuildAssignmentWithoutBounds - calls BuildAssignment but makes sure we do not
                                  check bounds.
*/

static void BuildAssignmentWithoutBounds (unsigned int tok, bool checkTypes, bool checkOverflow)
{
  bool old;

  old = MustNotCheckBounds;
  MustNotCheckBounds = true;
  doBuildAssignment (tok, checkTypes, checkOverflow);
  MustNotCheckBounds = old;
}


/*
   MarkArrayWritten - marks, Array, as being written.
*/

static void MarkArrayWritten (unsigned int Array)
{
  if ((Array != SymbolTable_NulSym) && (SymbolTable_IsVarAParam (Array)))
    {
      SymbolTable_PutVarWritten (Array, true);
    }
}


/*
   MarkAsReadWrite - marks the variable or parameter as being
                     read/write.
*/

static void MarkAsReadWrite (unsigned int sym)
{
  if ((sym != SymbolTable_NulSym) && (SymbolTable_IsVar (sym)))
    {
      SymbolTable_PutReadQuad (sym, SymbolTable_RightValue, NextQuad);
      SymbolTable_PutWriteQuad (sym, SymbolTable_RightValue, NextQuad);
    }
}


/*
   MarkAsRead - marks the variable or parameter as being read.
*/

static void MarkAsRead (unsigned int sym)
{
  if ((sym != SymbolTable_NulSym) && (SymbolTable_IsVar (sym)))
    {
      SymbolTable_PutReadQuad (sym, SymbolTable_RightValue, NextQuad);
    }
}


/*
   MarkAsWrite - marks the variable or parameter as being written.
*/

static void MarkAsWrite (unsigned int sym)
{
  if ((sym != SymbolTable_NulSym) && (SymbolTable_IsVar (sym)))
    {
      SymbolTable_PutWriteQuad (sym, SymbolTable_RightValue, NextQuad);
    }
}


/*
   doVal - return an expression which is VAL(type, expr).  If
           expr is a constant then return expr.
*/

static unsigned int doVal (unsigned int type, unsigned int expr)
{
  if ((! (SymbolTable_IsConst (expr))) && ((SymbolTable_SkipType (type)) != (SymbolTable_GetDType (expr))))
    {
      M2Quads_PushTF (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym));
      M2Quads_PushT (SymbolTable_SkipType (type));
      M2Quads_PushT (expr);
      M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
      BuildConvertFunction (M2Base_Convert, false);  /* Two parameters  */
      M2Quads_PopT (&expr);
    }
  return expr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MoveWithMode -
*/

static void MoveWithMode (unsigned int tokno, unsigned int Des, unsigned int Exp, unsigned int Array, unsigned int destok, unsigned int exptok, bool checkOverflow)
{
  unsigned int t;

  if ((SymbolTable_IsConstString (Exp)) && (SymbolTable_IsConst (Des)))
    {
      GenQuadOtok (tokno, M2Quads_BecomesOp, Des, SymbolTable_NulSym, Exp, true, destok, M2LexBuf_UnknownTokenNo, exptok);
    }
  else
    {
      if ((SymbolTable_GetMode (Des)) == SymbolTable_RightValue)
        {
          if ((SymbolTable_GetMode (Exp)) == SymbolTable_LeftValue)
            {
              CheckPointerThroughNil (tokno, Exp);  /* Des = *Exp  */
              doIndrX (tokno, Des, Exp);  /* Des = *Exp  */
            }
          else
            {
              GenQuadOtok (tokno, M2Quads_BecomesOp, Des, SymbolTable_NulSym, Exp, true, destok, M2LexBuf_UnknownTokenNo, exptok);
            }
        }
      else if ((SymbolTable_GetMode (Des)) == SymbolTable_LeftValue)
        {
          /* avoid dangling else.  */
          MarkArrayWritten (Array);
          if ((SymbolTable_GetMode (Exp)) == SymbolTable_LeftValue)
            {
              t = SymbolTable_MakeTemporary (tokno, SymbolTable_RightValue);
              SymbolTable_PutVar (t, SymbolTable_GetSType (Exp));
              CheckPointerThroughNil (tokno, Exp);
              doIndrX (tokno, t, Exp);
              CheckPointerThroughNil (tokno, Des);  /* *Des = Exp  */
              GenQuadO (tokno, M2Quads_XIndrOp, Des, SymbolTable_GetSType (Des), doVal (SymbolTable_GetSType (Des), t), checkOverflow);  /* *Des = Exp  */
            }
          else
            {
              CheckPointerThroughNil (tokno, Des);  /* *Des = Exp  */
              GenQuadO (tokno, M2Quads_XIndrOp, Des, SymbolTable_GetSType (Des), doVal (SymbolTable_GetSType (Des), Exp), checkOverflow);  /* *Des = Exp  */
            }
        }
      else
        {
          /* avoid dangling else.  */
          /* This might be inside a const expression.  */
          GenQuadOTypetok (tokno, M2Quads_BecomesOp, Des, SymbolTable_NulSym, Exp, true, true, destok, M2LexBuf_UnknownTokenNo, exptok);
        }
    }
}


/*
   CheckBecomesMeta - checks to make sure that we are not
                      assigning a variable to a constant.
                      Also check we are not assigning to an
                      unbounded array.
*/

static void CheckBecomesMeta (unsigned int Des, unsigned int Exp, unsigned int combinedtok, unsigned int destok, unsigned int exprtok)
{
  if ((SymbolTable_IsConst (Des)) && (SymbolTable_IsVar (Exp)))
    {
      M2MetaError_MetaErrorsT2 (combinedtok, (const char *) "in assignment, cannot assign a variable {%2a} to a constant {%1a}", 65, (const char *) "designator {%1Da} is declared as a {%kCONST}", 44, Des, Exp);
    }
  if ((((SymbolTable_GetDType (Des)) != SymbolTable_NulSym) && (SymbolTable_IsVar (Des))) && (SymbolTable_IsUnbounded (SymbolTable_GetDType (Des))))
    {
      M2MetaError_MetaErrorT1 (destok, (const char *) "in assignment, cannot assign to an unbounded array {%1ad}", 57, Des);
    }
  if ((((SymbolTable_GetDType (Exp)) != SymbolTable_NulSym) && (SymbolTable_IsVar (Exp))) && (SymbolTable_IsUnbounded (SymbolTable_GetDType (Exp))))
    {
      M2MetaError_MetaErrorT1 (exprtok, (const char *) "in assignment, cannot assign from an unbounded array {%1ad}", 59, Exp);
    }
}


/*
   doBuildAssignment - subsiduary procedure of BuildAssignment.
                       It builds the assignment and optionally
                       checks the types are compatible.
*/

static void doBuildAssignment (unsigned int becomesTokNo, bool checkTypes, bool checkOverflow)
{
  unsigned int r;
  unsigned int w;
  unsigned int t;
  unsigned int f;
  unsigned int Array;
  unsigned int Des;
  unsigned int Exp;
  unsigned int combinedtok;
  unsigned int destok;
  unsigned int exptok;

  M2Quads_DisplayStack ();
  if (IsBoolean (1))
    {
      PopBool (&t, &f);
      M2Quads_PopTtok (&Des, &destok);
      SymbolTable_PutVarConditional (Des, true);  /* Des will contain the result of a boolean relop.  */
      /* Conditional Boolean Assignment.  */
      BackPatch (t, NextQuad);
      if ((SymbolTable_GetMode (Des)) == SymbolTable_LeftValue)
        {
          CheckPointerThroughNil (destok, Des);
          GenQuadO (destok, M2Quads_XIndrOp, Des, M2Base_Boolean, M2Base_True, checkOverflow);
          GenQuadO (destok, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, NextQuad+2, false);
        }
      else
        {
          /* This might be inside a const expression.  */
          GenQuadO (becomesTokNo, M2Quads_BecomesOp, Des, SymbolTable_NulSym, M2Base_True, checkOverflow);
          GenQuadO (destok, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, NextQuad+2, false);
        }
      BackPatch (f, NextQuad);
      if ((SymbolTable_GetMode (Des)) == SymbolTable_LeftValue)
        {
          CheckPointerThroughNil (destok, Des);
          GenQuadO (destok, M2Quads_XIndrOp, Des, M2Base_Boolean, M2Base_False, checkOverflow);
        }
      else
        {
          GenQuadO (becomesTokNo, M2Quads_BecomesOp, Des, SymbolTable_NulSym, M2Base_False, checkOverflow);
        }
    }
  else
    {
      PopTrwtok (&Exp, &r, &exptok);
      MarkAsRead (r);
      if (Exp == SymbolTable_NulSym)
        {
          M2MetaError_MetaError0 ((const char *) "{%E}unknown expression found during assignment", 46);
          M2Error_FlushErrors ();
        }
      Array = static_cast<unsigned int> (M2Quads_OperandA (1));
      PopTrwtok (&Des, &w, &destok);
      MarkAsWrite (w);
      CheckCompatibleWithBecomes (Des, Exp, destok, exptok);
      if (DebugTokPos)
        {
          M2MetaError_MetaErrorT1 (becomesTokNo, (const char *) "becomestok {%1Oad}", 18, Des);
          M2MetaError_MetaErrorT1 (destok, (const char *) "destok {%1Oad}", 14, Des);
          M2MetaError_MetaErrorT1 (exptok, (const char *) "exptok {%1Oad}", 14, Exp);
        }
      combinedtok = M2LexBuf_MakeVirtualTok (becomesTokNo, destok, exptok);
      if (DebugTokPos)
        {
          M2MetaError_MetaErrorT1 (combinedtok, (const char *) "combined {%1Oad}", 16, Des);
        }
      if (M2Options_StrictTypeAssignment)
        {
          BuildRange (M2Range_InitTypesAssignmentCheck (combinedtok, Des, Exp));
        }
      if (((SymbolTable_GetSType (Des)) != SymbolTable_NulSym) && (! (SymbolTable_IsSet (SymbolTable_GetDType (Des)))))
        {
          /* Tell code generator to test runtime values of assignment so ensure we
            catch overflow and underflow.  */
          BuildRange (M2Range_InitAssignmentRangeCheck (combinedtok, Des, Exp, destok, exptok));
        }
      if (checkTypes)
        {
          CheckBecomesMeta (Des, Exp, combinedtok, destok, exptok);
        }
      /* Simple assignment.  */
      MoveWithMode (combinedtok, Des, Exp, Array, destok, exptok, checkOverflow);
      if (checkTypes)
        {
          CheckAssignCompatible (Des, Exp, combinedtok, destok, exptok);
        }
    }
  M2Quads_DisplayStack ();
}


/*
   CheckAssignCompatible - checks to see that an assignment is compatible.
                           It performs limited checking - thorough checking
                           is done in pass 3.  But we do what we can here
                           given knowledge so far.
*/

static void CheckAssignCompatible (unsigned int Des, unsigned int Exp, unsigned int combinedtok, unsigned int destok, unsigned int exprtok)
{
  unsigned int DesT;
  unsigned int ExpT;
  unsigned int DesL;

  DesT = SymbolTable_GetSType (Des);
  ExpT = SymbolTable_GetSType (Exp);
  DesL = SymbolTable_GetLType (Des);
  if (((SymbolTable_IsProcedure (Exp)) && ((DesT != SymbolTable_NulSym) && (! (SymbolTable_IsProcType (DesT))))) && ((DesL != SymbolTable_NulSym) && (! (SymbolTable_IsProcType (DesL)))))
    {
      M2MetaError_MetaErrorT1 (destok, (const char *) "incorrectly assigning a procedure to a designator {%1Ead} (designator is not a procedure type, {%1ast})", 103, Des);
    }
  /* We ignore checking of these types in pass 3 - but we do check them thoroughly post pass 3  */
  else if ((SymbolTable_IsProcedure (Exp)) && (SymbolTable_IsProcedureNested (Exp)))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (exprtok, (const char *) "cannot call nested procedure {%1Ead} indirectly as the outer scope will not be known", 84, Exp);
    }
  else if (SymbolTable_IsConstString (Exp))
    {
      /* avoid dangling else.  */
    }
  else if ((DesT != SymbolTable_NulSym) && (SymbolTable_IsUnbounded (DesT)))
    {
      /* avoid dangling else.  */
    }
  else if ((ExpT != SymbolTable_NulSym) && (SymbolTable_IsUnbounded (ExpT)))
    {
      /* avoid dangling else.  */
    }
  else if ((DesL != SymbolTable_NulSym) && (SymbolTable_IsArray (DesL)))
    {
      /* avoid dangling else.  */
    }
  else if (SymbolTable_IsConstructor (Exp))
    {
      /* avoid dangling else.  */
      if (ExpT == SymbolTable_NulSym)
        {}  /* empty.  */
      else if (((DesT == SymbolTable_NulSym) && (SymbolTable_IsConst (Des))) && ((SymbolTable_IsConstructor (Des)) || (SymbolTable_IsConstSet (Des))))
        {
          /* avoid dangling else.  */
          SymbolTable_PutConst (Des, ExpT);
        }
      else if (! (M2Base_IsAssignmentCompatible (DesT, ExpT)))
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (combinedtok, (const char *) "constructor expression is not compatible during assignment to {%1Ead}", 69, Des);
        }
    }
  else if (((DesT != SymbolTable_NulSym) && (SymbolTable_IsSet (DesT))) && (SymbolTable_IsConst (Exp)))
    {
      /* avoid dangling else.  */
    }
  else if ((((((SymbolTable_IsConst (Exp)) && (ExpT != M2System_Address)) && (! (SymbolTable_IsConst (Des)))) && (DesL != SymbolTable_NulSym)) && ((DesL == M2Base_Cardinal) || (! (SymbolTable_IsSubrange (DesL))))) && (! (SymbolTable_IsEnumeration (DesL))))
    {
      /* avoid dangling else.  */
      if ((M2Base_IsBaseType (DesL)) || (M2System_IsSystemType (DesL)))
        {
          M2Base_CheckAssignmentCompatible (combinedtok, ExpT, DesT);
        }
      else
        {
          M2MetaError_MetaErrorT2 (combinedtok, (const char *) "assignment of a constant {%1Ead} can only be made to a variable whose type is equivalent to a Modula-2 base type {%2tsa}", 120, Exp, Des);
        }
    }
  else
    {
      /* avoid dangling else.  */
      if (((DesT != SymbolTable_NulSym) && (SymbolTable_IsProcType (DesT))) && (SymbolTable_IsProcedure (Exp)))
        {
          DesT = SymbolTable_GetSType (DesT);  /* we can at least check RETURN values of procedure variables  */
          /* remember that thorough assignment checking is done post pass 3  */
          M2Base_CheckAssignmentCompatible (combinedtok, ExpT, DesT);
        }
    }
}


/*
   CheckBooleanId - Checks to see if the top operand is a boolean.
                    If the operand is not a boolean then it is tested
                    with true and a boolean is generated.
                    The Stack:


                    Entry                     Exit
             Ptr ->                                          <- Ptr
                    +------------+            +------------+
                    | Sym        |            | t   | f    |
                    |------------|            |------------|

                     Quadruples

                     q   If=      Sym   True   _
                     q+1 GotoOp   _     _      _
*/

static void CheckBooleanId (void)
{
  unsigned int tok;

  if (! (IsBoolean (1)))
    {
      tok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      if (SymbolTable_IsVar (M2Quads_OperandT (1)))
        {
          if ((SymbolTable_GetSType (M2Quads_OperandT (1))) != M2Base_Boolean)
            {
              M2MetaError_MetaError1 ((const char *) "{%1Ua:is not a boolean expression}''{!%1Ua:boolean expression expected}", 71, M2Quads_OperandT (1));
            }
        }
      M2Quads_PushT (M2Reserved_EqualTok);
      M2Quads_PushT (M2Base_True);
      M2Quads_BuildRelOp (tok);
    }
}


/*
   PushOne - pushes the value one to the stack.
             The Stack is changed:


                    Entry                   Exit
                    =====                   ====

                                                            <- Ptr
                                            +------------+
             Ptr ->                         | 1 | type   |
                                            |------------|
*/

static void PushOne (unsigned int tok, unsigned int type, const char *message_, unsigned int _message_high)
{
  unsigned int const_;
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (type == SymbolTable_NulSym)
    {
      const_ = SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1", 1), SymbolTable_NulSym);
      SymbolTable_PutConstLitInternal (const_, true);
      M2Quads_PushTFtok (const_, static_cast<unsigned int> (SymbolTable_NulSym), tok);
    }
  else if (SymbolTable_IsEnumeration (type))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_NoOfElements (type)) == 0)
        {
          M2MetaError_MetaErrorString1 (DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "enumeration type only has one element {%1Dad} and therefore ", 60), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) message, _message_high))), type);
          PushZero (tok, type);
        }
      else
        {
          M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), tok);
          M2Quads_PushT (type);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1", 1), M2Base_ZType), M2Base_ZType, tok);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, true);  /* Two parameters  */
        }
    }
  else
    {
      /* avoid dangling else.  */
      const_ = SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1", 1), type);
      SymbolTable_PutConstLitInternal (const_, true);
      M2Quads_PushTFtok (const_, type, tok);
    }
}


/*
   PushZero - pushes the value zero to the stack.
              The Stack is changed:


                    Entry                   Exit
                    =====                   ====

                                                            <- Ptr
                                            +------------+
             Ptr ->                         | 0 | type   |
                                            |------------|
*/

static void PushZero (unsigned int tok, unsigned int type)
{
  if (type == SymbolTable_NulSym)
    {
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "0", 1), SymbolTable_NulSym), static_cast<unsigned int> (SymbolTable_NulSym), tok);
    }
  else if (SymbolTable_IsEnumeration (type))
    {
      /* avoid dangling else.  */
      M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), tok);
      M2Quads_PushTtok (type, tok);
      M2Quads_PushTtok (SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType), tok);
      M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
      BuildConvertFunction (M2Base_Convert, true);  /* Two parameters  */
    }
  else
    {
      /* avoid dangling else.  */
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "0", 1), type), type, tok);
    }
}


/*
   ForLoopLastIterator - calculate the last iterator value but avoid setting
                         LastIterator twice if it is a constant (in the quads).
                         In the ForLoopLastIteratorVariable case only one
                         path will be chosen but at the time of quadruple
                         generation we do not know the value of BySym.
*/

static void ForLoopLastIterator (unsigned int LastIterator, unsigned int e1, unsigned int e2, unsigned int BySym, unsigned int e1tok, unsigned int e2tok, unsigned int bytok)
{
  if (! (SymbolTable_IsConst (BySym)))
    {
      M2MetaError_MetaErrorT1 (bytok, (const char *) "{%E}the {%kFOR} loop {%kBY} expression must be constant, the expression {%1a} is variable", 89, BySym);
      M2MetaError_MetaErrorDecl (BySym, true);
    }
  else
    {
      e1 = DereferenceLValue (e1tok, e1);
      e2 = DereferenceLValue (e2tok, e2);
      GenQuadOTypetok (bytok, M2Quads_LastForIteratorOp, LastIterator, SymbolTable_Make2Tuple (e1, e2), BySym, false, false, bytok, M2LexBuf_MakeVirtual2Tok (e1tok, e2tok), bytok);
    }
}


/*
   BuildSizeCheckEnd - checks to see whether the function "called" was in fact SIZE.
                       If so then we restore quadruple generation.
*/

static void BuildSizeCheckEnd (unsigned int ProcSym)
{
  if (((ProcSym == M2Size_Size) || (ProcSym == M2System_TSize)) || (ProcSym == M2System_TBitSize))
    {
      QuadrupleGeneration = true;
      BuildingSize = false;
    }
  else if (ProcSym == M2Base_High)
    {
      /* avoid dangling else.  */
      QuadrupleGeneration = true;
      BuildingHigh = false;
    }
}


/*
   BuildRealProcedureCall - builds a real procedure call.
                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |
                            |----------------|
                            | ProcSym | Type |         Empty
                            |----------------|
*/

static void BuildRealProcedureCall (unsigned int tokno)
{
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  M2Quads_PushT (NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+2));
  ProcSym = PCSymBuild_SkipConst (ProcSym);
  /* --checkme--  */
  if (SymbolTable_IsVar (ProcSym))
    {
      /* Procedure Variable ?  */
      ProcSym = SymbolTable_SkipType (M2Quads_OperandF (NoOfParam+2));
    }
  if ((SymbolTable_IsDefImp (SymbolTable_GetScope (ProcSym))) && (SymbolTable_IsDefinitionForC (SymbolTable_GetScope (ProcSym))))
    {
      BuildRealFuncProcCall (tokno, false, true, false);
    }
  else
    {
      BuildRealFuncProcCall (tokno, false, false, false);
    }
}


/*
   BuildRealFuncProcCall - builds a real procedure or function call.
                           The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |
                            |----------------|
                            | ProcSym | Type |         Empty
                            |----------------|
*/

static void BuildRealFuncProcCall (unsigned int tokno, bool IsFunc, bool IsForC, bool ConstExpr)
{
  bool AllocateProc;
  bool DeallocateProc;
  bool ForcedFunc;
  bool ParamConstant;
  unsigned int trash;
  unsigned int resulttok;
  unsigned int paramtok;
  unsigned int proctok;
  unsigned int NoOfParameters;
  unsigned int i;
  unsigned int pi;
  unsigned int ParamType;
  unsigned int Param1;
  unsigned int ReturnVar;
  unsigned int ProcSym;
  unsigned int Proc;

  Param1 = SymbolTable_NulSym;  /* Used to remember first param for allocate/deallocate.  */
  ParamType = SymbolTable_NulSym;
  CheckProcedureParameters (IsForC);
  M2Quads_PopT (&NoOfParameters);
  M2Quads_PushT (NoOfParameters);  /* Restore stack to original state.  */
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParameters+2));  /* Restore stack to original state.  */
  proctok = tokno;  /* OperandTtok (NoOfParameters+2) ;  */
  if (proctok == M2LexBuf_UnknownTokenNo)  /* OperandTtok (NoOfParameters+2) ;  */
    {
      proctok = M2LexBuf_GetTokenNo ();
    }
  paramtok = proctok;
  ProcSym = PCSymBuild_SkipConst (ProcSym);
  ForcedFunc = false;
  AllocateProc = false;
  DeallocateProc = false;
  if (SymbolTable_IsVar (ProcSym))
    {
      /* Procedure Variable ?  */
      Proc = SymbolTable_SkipType (M2Quads_OperandF (NoOfParameters+2));
      ParamConstant = false;
    }
  else
    {
      Proc = ProcSym;
      ParamConstant = true;
      AllocateProc = (SymbolTable_GetSymName (Proc)) == (NameKey_MakeKey ((const char *) "ALLOCATE", 8));
      DeallocateProc = (SymbolTable_GetSymName (Proc)) == (NameKey_MakeKey ((const char *) "DEALLOCATE", 10));
    }
  if (IsFunc)
    {
      /* avoid dangling else.  */
      if ((SymbolTable_GetSType (Proc)) == SymbolTable_NulSym)
        {
          M2MetaError_MetaErrors1 ((const char *) "procedure {%1a} cannot be used as a function", 44, (const char *) "procedure {%1Da} does not have a return type", 44, Proc);
        }
    }
  else
    {
      /* is being called as a procedure  */
      if ((SymbolTable_GetSType (Proc)) != SymbolTable_NulSym)
        {
          /* however it was declared as a procedure function  */
          if (! (SymbolTable_IsReturnOptionalAny (Proc)))
            {
              M2MetaError_MetaErrors1 ((const char *) "function {%1a} is being called but its return value is ignored", 62, (const char *) "function {%1Da} return a type {%1ta:of {%1ta}}", 46, Proc);
            }
          IsFunc = true;
          ForcedFunc = true;
        }
    }
  if (AllocateProc || DeallocateProc)
    {
      Param1 = static_cast<unsigned int> (M2Quads_OperandT (NoOfParameters+1));  /* Remember this before manipulating.  */
    }
  ManipulateParameters (IsForC);
  CheckParameterOrdinals ();
  M2Quads_PopT (&NoOfParameters);
  if (IsFunc)
    {
      GenQuad (M2Quads_ParamOp, 0, Proc, ProcSym);  /* Space for return value  */
    }
  if (((NoOfParameters+1) == (SymbolTable_NoOfParamAny (Proc))) && (SymbolTable_UsesOptArgAny (Proc)))
    {
      GenQuad (M2Quads_OptParamOp, SymbolTable_NoOfParamAny (Proc), Proc, Proc);
    }
  i = NoOfParameters;
  pi = 1;  /* stack index referencing stacked parameter, i  */
  while (i > 0)  /* stack index referencing stacked parameter, i  */
    {
      paramtok = OperandTtok (pi);
      if (((AllocateProc || DeallocateProc) && (i == 1)) && (Param1 != SymbolTable_NulSym))
        {
          ParamType = GetItemPointedTo (Param1);
          if (ParamType == SymbolTable_NulSym)
            {
              GenQuadO (paramtok, M2Quads_ParamOp, i, Proc, M2Quads_OperandT (pi), true);
            }
          else
            {
              if (AllocateProc)
                {
                  trash = SymbolTable_MakeTemporary (paramtok, SymbolTable_RightValue);
                  SymbolTable_PutVar (trash, ParamType);
                  SymbolTable_PutVarHeap (trash, true);
                }
              else
                {
                  M2Debug_Assert (DeallocateProc);
                  trash = M2Base_Nil;
                }
              GenQuadOTrash (paramtok, M2Quads_ParamOp, i, Proc, M2Quads_OperandT (pi), true, trash);
            }
        }
      else
        {
          GenQuadO (paramtok, M2Quads_ParamOp, i, Proc, M2Quads_OperandT (pi), true);
        }
      if (! (SymbolTable_IsConst (M2Quads_OperandT (pi))))
        {
          ParamConstant = false;
        }
      i -= 1;
      pi += 1;
    }
  GenQuadO (proctok, M2Quads_CallOp, SymbolTable_NulSym, SymbolTable_NulSym, ProcSym, true);
  M2Quads_PopN (NoOfParameters+1);  /* Destroy arguments and procedure call  */
  if (IsFunc)
    {
      /* ReturnVar has the type of the procedure.  */
      resulttok = M2LexBuf_MakeVirtualTok (proctok, proctok, paramtok);
      if (ConstExpr && (! (SymbolTable_IsProcedureBuiltinAvailable (Proc))))
        {
          M2MetaError_MetaError1 ((const char *) "{%1d} {%1ad} cannot be used in a constant expression", 52, Proc);
          ParamConstant = false;
        }
      ReturnVar = SymbolTable_MakeTemporary (resulttok, AreConstant (ParamConstant && ConstExpr));
      SymbolTable_PutVar (ReturnVar, SymbolTable_GetSType (Proc));
      GenQuadO (resulttok, M2Quads_FunctValueOp, ReturnVar, SymbolTable_NulSym, Proc, true);
      if (! ForcedFunc)
        {
          M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (Proc), resulttok);
        }
    }
}


/*
   CheckProcedureParameters - Checks the parameters which are being passed to
                              procedure ProcSym.

                              The Stack:


                              Entry                      Exit

                       Ptr ->                                               <- Ptr
                              +----------------+         +----------------+
                              | NoOfParam      |         | NoOfParam      |
                              |----------------|         |----------------|
                              | Param 1        |         | Param 1        |
                              |----------------|         |----------------|
                              | Param 2        |         | Param 2        |
                              |----------------|         |----------------|
                              .                .         .                .
                              .                .         .                .
                              .                .         .                .
                              |----------------|         |----------------|
                              | Param #        |         | Param #        |
                              |----------------|         |----------------|
                              | ProcSym | Type |         | ProcSym | Type |
                              |----------------|         |----------------|

*/

static void CheckProcedureParameters (bool IsForC)
{
  unsigned int proctok;
  unsigned int paramtok;
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int ParamCheckId;
  unsigned int Dim;
  unsigned int Actual;
  unsigned int FormalI;
  unsigned int ParamTotal;
  unsigned int pi;
  unsigned int Proc;
  unsigned int ProcSym;
  unsigned int i;
  DynamicStrings_String s;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PushT (ParamTotal);  /* Restore stack to origional state  */
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT ((ParamTotal+1)+1));  /* Restore stack to origional state  */
  proctok = OperandTtok ((ParamTotal+1)+1);
  if ((SymbolTable_IsVar (ProcSym)) && (SymbolTable_IsProcType (SymbolTable_GetDType (ProcSym))))
    {
      /* Procedure Variable ?  */
      Proc = SymbolTable_SkipType (M2Quads_OperandF ((ParamTotal+1)+1));
    }
  else
    {
      Proc = PCSymBuild_SkipConst (ProcSym);
    }
  if (! ((SymbolTable_IsProcedure (Proc)) || (SymbolTable_IsProcType (Proc))))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsUnknown (Proc))
        {
          M2MetaError_MetaError1 ((const char *) "{%1Ua} is not recognised as a procedure, check declaration or import", 68, Proc);
        }
      else
        {
          M2MetaError_MetaErrors1 ((const char *) "{%1a} is not recognised as a procedure, check declaration or import", 67, (const char *) "{%1Ua} is not recognised as a procedure, check declaration or import", 68, Proc);
        }
    }
  if (M2Options_CompilerDebugging)
    {
      n1 = SymbolTable_GetSymName (Proc);
      M2Printf_printf1 ((const char *) "  %a ( ", 7, (const unsigned char *) &n1, (sizeof (n1)-1));
    }
  if (DebugTokPos)
    {
      s = DynamicStrings_InitString ((const char *) "procedure", 9);
      M2Error_WarnStringAt (s, proctok);
    }
  i = 1;
  pi = ParamTotal+1;  /* stack index referencing stacked parameter, i  */
  while (i <= ParamTotal)  /* stack index referencing stacked parameter, i  */
    {
      if (i <= (SymbolTable_NoOfParamAny (Proc)))
        {
          /* FormalI := GetParam(Proc, i) ;  */
          FormalI = SymbolTable_GetNthParamAnyClosest (Proc, i, SymbolTable_GetCurrentModule ());
          if (M2Options_CompilerDebugging)
            {
              n1 = SymbolTable_GetSymName (FormalI);
              n2 = SymbolTable_GetSymName (SymbolTable_GetSType (FormalI));
              M2Printf_printf2 ((const char *) "%a: %a", 6, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
            }
          Actual = static_cast<unsigned int> (M2Quads_OperandT (pi));
          Dim = static_cast<unsigned int> (OperandD (pi));
          paramtok = OperandTtok (pi);
          if (DebugTokPos)
            {
              s = DynamicStrings_InitString ((const char *) "actual", 6);
              M2Error_WarnStringAt (s, paramtok);
            }
          ParamCheckId = M2Range_InitTypesParameterCheck (paramtok, Proc, i, FormalI, Actual, 0);
          BuildRange (ParamCheckId);
          /* Store the ParamCheckId on the quad stack so that any dependant checks
            can be cancelled if the type check above detects an error.  */
          PutRangeDep (pi, ParamCheckId);
          if (SymbolTable_IsConst (Actual))
            {
              /* avoid dangling else.  */
              if (SymbolTable_IsVarParamAny (Proc, i))
                {
                  FailParameter (paramtok, (const char *) "trying to pass a constant to a VAR parameter", 44, Actual, Proc, i);
                }
              else if (SymbolTable_IsConstString (Actual))
                {
                  /* avoid dangling else.  */
                  if (! (SymbolTable_IsConstStringKnown (Actual)))
                    {}  /* empty.  */
                  else if ((SymbolTable_IsArray (SymbolTable_GetDType (FormalI))) && ((SymbolTable_GetSType (SymbolTable_GetDType (FormalI))) == M2Base_Char))
                    {
                      /* avoid dangling else.  */
                    }
                  else if ((SymbolTable_GetStringLength (paramtok, Actual)) == 1)
                    {
                      /* avoid dangling else.  */
                      CheckParameter (paramtok, Actual, Dim, FormalI, Proc, i, static_cast<Lists_List> (NULL), ParamCheckId);
                    }
                  else if (! (SymbolTable_IsUnboundedParamAny (Proc, i)))
                    {
                      /* avoid dangling else.  */
                      if (IsForC && ((SymbolTable_GetSType (FormalI)) == M2System_Address))
                        {
                          FailParameter (paramtok, (const char *) "a string constant can either be passed to an ADDRESS parameter or an ARRAY OF CHAR", 82, Actual, Proc, i);
                        }
                      else
                        {
                          FailParameter (paramtok, (const char *) "cannot pass a string constant to a non unbounded array parameter", 64, Actual, Proc, i);
                        }
                    }
                }
            }
          else
            {
              CheckParameter (paramtok, Actual, Dim, FormalI, Proc, i, static_cast<Lists_List> (NULL), ParamCheckId);
            }
        }
      else
        {
          if (IsForC && (SymbolTable_UsesVarArgs (Proc)))
            {
              /* these are varargs, therefore we don't check them  */
              i = ParamTotal;
            }
          else
            {
              M2MetaError_MetaErrorT2 (proctok, (const char *) "too many parameters, {%2n} passed to {%1a} ", 43, Proc, i);
            }
        }
      i += 1;
      pi -= 1;
      if (M2Options_CompilerDebugging)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (i <= ParamTotal)
            {
              M2Printf_printf0 ((const char *) "; ", 2);
            }
          else
            {
              M2Printf_printf0 ((const char *) " ) ; \\n", 7);
            }
        }
    }
}


/*
   CheckProcTypeAndProcedure - checks the ProcType with the call.
*/

static void CheckProcTypeAndProcedure (unsigned int tokno, unsigned int ProcType, unsigned int call, unsigned int ParamCheckId)
{
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int i;
  unsigned int n;
  unsigned int t;
  unsigned int CheckedProcedure;
  M2Error_Error e;

  if (((SymbolTable_IsVar (call)) || (SymbolTable_IsTemporary (call))) || (SymbolTable_IsParameter (call)))
    {
      CheckedProcedure = SymbolTable_GetDType (call);
    }
  else
    {
      CheckedProcedure = call;
    }
  if (ProcType != CheckedProcedure)
    {
      n = SymbolTable_NoOfParamAny (ProcType);
      /* We need to check the formal parameters between the procedure and proc type.  */
      if (n != (SymbolTable_NoOfParamAny (CheckedProcedure)))
        {
          e = M2Error_NewError (SymbolTable_GetDeclaredMod (ProcType));
          n1 = SymbolTable_GetSymName (call);
          n2 = SymbolTable_GetSymName (ProcType);
          M2Error_ErrorFormat2 (e, (const char *) "procedure (%a) is a parameter being passed as variable (%a) but they are declared with different number of parameters", 117, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
          e = M2Error_ChainError (SymbolTable_GetDeclaredMod (call), e);
          t = SymbolTable_NoOfParamAny (CheckedProcedure);
          if (n < 2)
            {
              M2Error_ErrorFormat3 (e, (const char *) "procedure (%a) is being called incorrectly with (%d) parameter, declared with (%d)", 82, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &t, (sizeof (t)-1));
            }
          else
            {
              M2Error_ErrorFormat3 (e, (const char *) "procedure (%a) is being called incorrectly with (%d) parameters, declared with (%d)", 83, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &t, (sizeof (t)-1));
            }
        }
      else
        {
          i = 1;
          while (i <= n)
            {
              if ((SymbolTable_IsVarParamAny (ProcType, i)) != (SymbolTable_IsVarParamAny (CheckedProcedure, i)))
                {
                  M2MetaError_MetaError3 ((const char *) "parameter {%3n} in {%1dD} causes a mismatch it was declared as a {%2d}", 70, ProcType, SymbolTable_GetNth (ProcType, i), i);
                  M2MetaError_MetaError3 ((const char *) "parameter {%3n} in {%1dD} causes a mismatch it was declared as a {%2d}", 70, call, SymbolTable_GetNth (call, i), i);
                }
              BuildRange (M2Range_InitTypesParameterCheck (tokno, CheckedProcedure, i, SymbolTable_GetNthParamAnyClosest (CheckedProcedure, i, SymbolTable_GetCurrentModule ()), SymbolTable_GetParam (ProcType, i), ParamCheckId));
              i += 1;
            }
        }
    }
}


/*
   IsReallyPointer - returns TRUE is sym is a pointer, address or a type declared
                     as a pointer or address.
*/

static bool IsReallyPointer (unsigned int Sym)
{
  if (SymbolTable_IsVar (Sym))
    {
      Sym = SymbolTable_GetSType (Sym);
    }
  Sym = SymbolTable_SkipType (Sym);
  return (SymbolTable_IsPointer (Sym)) || (Sym == M2System_Address);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LegalUnboundedParam - returns TRUE if the parameter, Actual, can legitimately be
                         passed to ProcSym, i, the, Formal, parameter.
*/

static bool LegalUnboundedParam (unsigned int tokpos, unsigned int ProcSym, unsigned int i, unsigned int ActualType, unsigned int Actual, unsigned int Dimension, unsigned int Formal)
{
  unsigned int FormalType;
  unsigned int n;
  unsigned int m;

  ActualType = SymbolTable_SkipType (ActualType);
  FormalType = SymbolTable_GetDType (Formal);
  FormalType = SymbolTable_GetSType (FormalType);  /* type of the unbounded ARRAY  */
  if (SymbolTable_IsArray (ActualType))  /* type of the unbounded ARRAY  */
    {
      m = SymbolTable_GetDimension (Formal);
      n = 0;
      while (SymbolTable_IsArray (ActualType))
        {
          n += 1;
          ActualType = SymbolTable_GetDType (ActualType);
          if ((m == n) && (ActualType == FormalType))
            {
              return true;
            }
        }
      if (n == m)
        {}  /* empty.  */
      else
        {
          /* now we fall though and test ActualType against FormalType  */
          if (M2System_IsGenericSystemType (FormalType))
            {
              return true;
            }
          else
            {
              FailParameter (tokpos, (const char *) "attempting to pass an array with the incorrect number dimenisons to an unbounded formal parameter of different dimensions", 121, Actual, ProcSym, i);
              return false;
            }
        }
    }
  else if (SymbolTable_IsUnbounded (ActualType))
    {
      /* avoid dangling else.  */
      if ((Dimension == 0) && ((SymbolTable_GetDimension (Formal)) == (SymbolTable_GetDimension (Actual))))
        {
          /* now we fall though and test ActualType against FormalType  */
          ActualType = SymbolTable_GetSType (ActualType);
        }
      else
        {
          if (M2System_IsGenericSystemType (FormalType))
            {
              return true;
            }
          else
            {
              if (((SymbolTable_GetDimension (Actual))-Dimension) == (SymbolTable_GetDimension (Formal)))
                {
                  ActualType = SymbolTable_GetSType (ActualType);
                }
              else
                {
                  FailParameter (tokpos, (const char *) "attempting to pass an unbounded array with the incorrect number dimenisons to an unbounded formal parameter of different dimensions", 131, Actual, ProcSym, i);
                  return false;
                }
            }
        }
    }
  if (((M2System_IsGenericSystemType (FormalType)) || (M2System_IsGenericSystemType (ActualType))) || (M2Base_IsAssignmentCompatible (FormalType, ActualType)))
    {
      /* we think it is legal, but we ask post pass 3 to check as
         not all types are known at this point  */
      return true;
    }
  else
    {
      FailParameter (tokpos, (const char *) "identifier with an incompatible type is being passed to this procedure", 70, Actual, ProcSym, i);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckParameter - checks that types ActualType and FormalType are compatible for parameter
                    passing. ProcSym is the procedure and i is the parameter number.

                    We obey the following rules:

                    (1)  we allow WORD, BYTE, LOC to be compitable with any like sized
                         type.
                    (2)  we allow ADDRESS to be compatible with any pointer type.
                    (3)  we relax INTEGER and CARDINAL checking for Temporary variables.

                    Note that type sizes are checked during the code generation pass.
*/

static void CheckParameter (unsigned int tokpos, unsigned int Actual, unsigned int Dimension, unsigned int Formal, unsigned int ProcSym, unsigned int i, Lists_List TypeList, unsigned int ParamCheckId)
{
  bool NewList;
  unsigned int ActualType;
  unsigned int FormalType;

  if ((SymbolTable_IsConstString (Actual)) && (! (SymbolTable_IsConstStringKnown (Actual))))
    {
      /* Cannot check if the string content is not yet known.  */
      return;
    }
  FormalType = SymbolTable_GetDType (Formal);
  if ((SymbolTable_IsConstString (Actual)) && ((SymbolTable_GetStringLength (tokpos, Actual)) == 1))  /* if = 1 then it maybe treated as a char  */
    {
      ActualType = M2Base_Char;
    }
  else if (Actual == M2Base_Boolean)
    {
      /* avoid dangling else.  */
      ActualType = Actual;
    }
  else
    {
      /* avoid dangling else.  */
      ActualType = SymbolTable_GetDType (Actual);
    }
  if (TypeList == NULL)
    {
      NewList = true;
      Lists_InitList (&TypeList);
    }
  else
    {
      NewList = false;
    }
  if (Lists_IsItemInList (TypeList, ActualType))
    {
      /* no need to check  */
      return;
    }
  Lists_IncludeItemIntoList (TypeList, ActualType);
  if (SymbolTable_IsProcType (FormalType))
    {
      if ((! (SymbolTable_IsProcedure (Actual))) && ((ActualType == SymbolTable_NulSym) || (! (SymbolTable_IsProcType (SymbolTable_SkipType (ActualType))))))
        {
          FailParameter (tokpos, (const char *) "expecting a procedure or procedure variable as a parameter", 58, Actual, ProcSym, i);
          return;
        }
      if ((SymbolTable_IsProcedure (Actual)) && (SymbolTable_IsProcedureNested (Actual)))
        {
          M2MetaError_MetaError2 ((const char *) "cannot pass a nested procedure {%1Ea} seen in the {%2N} parameter as the outer scope will be unknown at runtime", 111, Actual, i);
        }
      /* we can check the return type of both proc types  */
      if ((ActualType != SymbolTable_NulSym) && (SymbolTable_IsProcType (ActualType)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (((SymbolTable_GetSType (ActualType)) != SymbolTable_NulSym) && ((SymbolTable_GetSType (FormalType)) == SymbolTable_NulSym))
            {
              FailParameter (tokpos, (const char *) "the item being passed is a function whereas the formal procedure parameter is a procedure", 89, Actual, ProcSym, i);
              return;
            }
          else if (((SymbolTable_GetSType (ActualType)) == SymbolTable_NulSym) && ((SymbolTable_GetSType (FormalType)) != SymbolTable_NulSym))
            {
              /* avoid dangling else.  */
              FailParameter (tokpos, (const char *) "the item being passed is a procedure whereas the formal procedure parameter is a function", 89, Actual, ProcSym, i);
              return;
            }
          else if (M2Base_AssignmentRequiresWarning (SymbolTable_GetSType (ActualType), SymbolTable_GetSType (FormalType)))
            {
              /* avoid dangling else.  */
              WarnParameter (tokpos, (const char *) "the return result of the procedure variable parameter may not be compatible on other targets with the return result of the item being passed", 140, Actual, ProcSym, i);
              return;
            }
          else if (((M2System_IsGenericSystemType (SymbolTable_GetSType (FormalType))) || (M2System_IsGenericSystemType (SymbolTable_GetSType (ActualType)))) || (M2Base_IsAssignmentCompatible (SymbolTable_GetSType (ActualType), SymbolTable_GetSType (FormalType))))
            {
              /* avoid dangling else.  */
            }
          else
            {
              /* avoid dangling else.  */
              /* pass  */
              FailParameter (tokpos, (const char *) "the return result of the procedure variable parameter is not compatible with the return result of the item being passed", 119, Actual, ProcSym, i);
              return;
            }
        }
      /* now to check each parameter of the proc type  */
      CheckProcTypeAndProcedure (tokpos, FormalType, Actual, ParamCheckId);
    }
  else if ((ActualType != FormalType) && (ActualType != SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsUnknown (FormalType))
        {
          FailParameter (tokpos, (const char *) "procedure parameter type is undeclared", 38, Actual, ProcSym, i);
          return;
        }
      if ((SymbolTable_IsUnbounded (ActualType)) && (! (SymbolTable_IsUnboundedParamAny (ProcSym, i))))
        {
          FailParameter (tokpos, (const char *) "attempting to pass an unbounded array to a NON unbounded parameter", 66, Actual, ProcSym, i);
          return;
        }
      else if (SymbolTable_IsUnboundedParamAny (ProcSym, i))
        {
          /* avoid dangling else.  */
          if (! (LegalUnboundedParam (tokpos, ProcSym, i, ActualType, Actual, Dimension, Formal)))
            {
              return;
            }
        }
      else if (ActualType != FormalType)
        {
          /* avoid dangling else.  */
          if (M2Base_AssignmentRequiresWarning (FormalType, ActualType))
            {
              WarnParameter (tokpos, (const char *) "identifier being passed to this procedure may contain a possibly incompatible type when compiling for a different target", 120, Actual, ProcSym, i);
            }
          else if (((M2System_IsGenericSystemType (FormalType)) || (M2System_IsGenericSystemType (ActualType))) || (M2Base_IsAssignmentCompatible (ActualType, FormalType)))
            {
              /* avoid dangling else.  */
            }
          else
            {
              /* avoid dangling else.  */
              /* so far we know it is legal, but not all types have been resolved
               and so this is checked later on in another pass.  */
              FailParameter (tokpos, (const char *) "identifier with an incompatible type is being passed to this procedure", 70, Actual, ProcSym, i);
            }
        }
    }
  if (NewList)
    {
      Lists_KillList (&TypeList);
    }
}


/*
   DescribeType - returns a String describing a symbol, Sym, name and its type.
*/

static DynamicStrings_String DescribeType (unsigned int Sym)
{
  DynamicStrings_String s;
  DynamicStrings_String s1;
  DynamicStrings_String s2;
  unsigned int Low;
  unsigned int High;
  unsigned int Subrange;
  unsigned int Subscript;
  unsigned int Type;

  s = static_cast<DynamicStrings_String> (NULL);
  if (SymbolTable_IsConstString (Sym))
    {
      /* If = 1 then it maybe treated as a char.  */
      if ((SymbolTable_IsConstStringKnown (Sym)) && ((SymbolTable_GetStringLength (SymbolTable_GetDeclaredMod (Sym), Sym)) == 1))
        {
          s = DynamicStrings_InitString ((const char *) "(constant string) or {%kCHAR}", 29);
        }
      else
        {
          s = DynamicStrings_InitString ((const char *) "(constant string)", 17);
        }
    }
  else if (SymbolTable_IsConst (Sym))
    {
      /* avoid dangling else.  */
      s = DynamicStrings_InitString ((const char *) "(constant)", 10);
    }
  else if (SymbolTable_IsUnknown (Sym))
    {
      /* avoid dangling else.  */
      s = DynamicStrings_InitString ((const char *) "(unknown)", 9);
    }
  else
    {
      /* avoid dangling else.  */
      Type = SymbolTable_GetSType (Sym);
      if (Type == SymbolTable_NulSym)
        {
          s = DynamicStrings_InitString ((const char *) "(unknown)", 9);
        }
      else if (SymbolTable_IsUnbounded (Type))
        {
          /* avoid dangling else.  */
          s1 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (SymbolTable_GetSType (Type)))));
          s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "{%%kARRAY} {%%kOF} %s", 21)), (const unsigned char *) &s1, (sizeof (s1)-1));
        }
      else if (SymbolTable_IsArray (Type))
        {
          /* avoid dangling else.  */
          s = DynamicStrings_InitString ((const char *) "{%kARRAY} [", 11);
          Subscript = SymbolTable_GetArraySubscript (Type);
          if (Subscript != SymbolTable_NulSym)
            {
              M2Debug_Assert (SymbolTable_IsSubscript (Subscript));
              Subrange = SymbolTable_GetSType (Subscript);
              if (! (SymbolTable_IsSubrange (Subrange)))
                {
                  M2MetaError_MetaError3 ((const char *) "error in definition of array {%1Ead} in the {%2N} subscript which has no subrange, instead type given is {%3a}", 110, Sym, Subscript, Subrange);
                }
              M2Debug_Assert (SymbolTable_IsSubrange (Subrange));
              SymbolTable_GetSubrange (Subrange, &High, &Low);
              s1 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Low))));
              s2 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (High))));
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%s..%s", 6)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) &s2, (sizeof (s2)-1))));
            }
          s1 = DynamicStrings_Mark (DescribeType (Type));
          s = DynamicStrings_ConCat (DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "] OF ", 5))), s1);
        }
      else
        {
          /* avoid dangling else.  */
          if (SymbolTable_IsUnknown (Type))
            {
              s1 = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Type))));
              s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%s (currently unknown, check declaration or import)", 51)), (const unsigned char *) &s1, (sizeof (s1)-1));
            }
          else
            {
              s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Type)));
            }
        }
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FailParameter - generates an error message indicating that a parameter
                   declaration has failed.

                   The parameters are:

                   CurrentState  - string describing the current failing state.
                   Actual        - actual parameter.
                   ParameterNo   - parameter number that has failed.
                   ProcedureSym  - procedure symbol where parameter has failed.

                   If any parameter is Nul then it is ignored.
*/

static void FailParameter (unsigned int tokpos, const char *CurrentState_, unsigned int _CurrentState_high, unsigned int Actual, unsigned int ProcedureSym, unsigned int ParameterNo)
{
  unsigned int FormalParam;
  DynamicStrings_String Msg;
  char CurrentState[_CurrentState_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (CurrentState, CurrentState_, _CurrentState_high+1);

  Msg = DynamicStrings_InitString ((const char *) "parameter mismatch between the {%2N} parameter of procedure {%1Ead}, ", 69);
  Msg = DynamicStrings_ConCat (Msg, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) CurrentState, _CurrentState_high)));
  M2MetaError_MetaErrorStringT2 (tokpos, Msg, ProcedureSym, ParameterNo);
  if ((SymbolTable_NoOfParamAny (ProcedureSym)) >= ParameterNo)
    {
      FormalParam = SymbolTable_GetNthParamAnyClosest (ProcedureSym, ParameterNo, SymbolTable_GetCurrentModule ());
      if (SymbolTable_IsUnboundedParamAny (ProcedureSym, ParameterNo))
        {
          M2MetaError_MetaErrorT2 (SymbolTable_GetVarDeclFullTok (FormalParam), (const char *) "formal parameter {%1ad} has an open array type {%2tad}", 54, FormalParam, SymbolTable_GetSType (SymbolTable_GetSType (FormalParam)));
        }
      else
        {
          M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (FormalParam), (const char *) "formal parameter {%1ad} has type {%1tad}", 40, FormalParam);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (SymbolTable_GetDeclaredMod (ProcedureSym), (const char *) "procedure declaration", 21, ProcedureSym);
    }
  if ((SymbolTable_GetLType (Actual)) == SymbolTable_NulSym)
    {
      M2MetaError_MetaError1 ((const char *) "actual parameter being passed is {%1Eda} {%1ad}", 47, Actual);
    }
  else
    {
      if (SymbolTable_IsVar (Actual))
        {
          M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (Actual), (const char *) "actual parameter variable being passed is {%1Eda} {%1ad} of an incompatible type {%1ts}", 87, Actual);
        }
      else
        {
          M2MetaError_MetaErrorT1 (tokpos, (const char *) "actual parameter being passed is {%1Eda} {%1ad} of an incompatible type {%1ts}", 78, Actual);
        }
    }
}


/*
   WarnParameter - generates a warning message indicating that a parameter
                   use might cause problems on another target.

                   CurrentState  - string describing the current failing state.
                   Actual        - actual parameter.
                   ParameterNo   - parameter number that has failed.
                   ProcedureSym  - procedure symbol where parameter has failed.

                   If any parameter is Nul then it is ignored.
*/

static void WarnParameter (unsigned int tokpos, const char *CurrentState_, unsigned int _CurrentState_high, unsigned int Actual, unsigned int ProcedureSym, unsigned int ParameterNo)
{
  unsigned int FormalParam;
  DynamicStrings_String Msg;
  char CurrentState[_CurrentState_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (CurrentState, CurrentState_, _CurrentState_high+1);

  Msg = DynamicStrings_InitString ((const char *) "{%W}parameter mismatch between the {%2N} parameter of procedure {%1ad}, ", 72);
  Msg = DynamicStrings_ConCat (Msg, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) CurrentState, _CurrentState_high)));
  M2MetaError_MetaErrorStringT2 (tokpos, Msg, ProcedureSym, ParameterNo);
  if ((SymbolTable_NoOfParamAny (ProcedureSym)) >= ParameterNo)
    {
      FormalParam = SymbolTable_GetNthParamAnyClosest (ProcedureSym, ParameterNo, SymbolTable_GetCurrentModule ());
      if (SymbolTable_IsUnboundedParamAny (ProcedureSym, ParameterNo))
        {
          M2MetaError_MetaErrorT2 (SymbolTable_GetVarDeclFullTok (FormalParam), (const char *) "{%W}formal parameter {%1ad} has an open array type {%2tad}", 58, FormalParam, SymbolTable_GetSType (SymbolTable_GetSType (FormalParam)));
        }
      else
        {
          M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (FormalParam), (const char *) "{%W}formal parameter {%1ad} has type {%1tad}", 44, FormalParam);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (SymbolTable_GetDeclaredMod (ProcedureSym), (const char *) "{%W}procedure declaration", 25, ProcedureSym);
    }
  if ((SymbolTable_GetLType (Actual)) == SymbolTable_NulSym)
    {
      M2MetaError_MetaError1 ((const char *) "actual parameter being passed is {%1Wda} {%1ad}", 47, Actual);
    }
  else
    {
      if (SymbolTable_IsVar (Actual))
        {
          M2MetaError_MetaErrorT1 (SymbolTable_GetVarDeclFullTok (Actual), (const char *) "actual parameter variable being passed is {%1Wda} {%1ad} of type {%1ts}", 71, Actual);
        }
      else
        {
          M2MetaError_MetaErrorT1 (tokpos, (const char *) "actual parameter being passed is {%1Wda} {%1ad} of type {%1ts}", 62, Actual);
        }
    }
}


/*
   doIndrX - perform des = *exp with a conversion if necessary.
*/

static void doIndrX (unsigned int tok, unsigned int des, unsigned int exp)
{
  unsigned int t;

  if ((SymbolTable_GetDType (des)) == (SymbolTable_GetDType (exp)))
    {
      GenQuadOtok (tok, M2Quads_IndrXOp, des, SymbolTable_GetSType (des), exp, true, tok, tok, tok);
    }
  else
    {
      if (M2Options_StrictTypeAssignment)
        {
          BuildRange (M2Range_InitTypesIndrXCheck (tok, des, exp));
        }
      t = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (t, SymbolTable_GetSType (exp));
      GenQuadOtok (tok, M2Quads_IndrXOp, t, SymbolTable_GetSType (exp), exp, true, tok, tok, tok);
      GenQuadOtok (tok, M2Quads_BecomesOp, des, SymbolTable_NulSym, doVal (SymbolTable_GetSType (des), t), true, tok, M2LexBuf_UnknownTokenNo, tok);
    }
}


/*
   MakeRightValue - returns a temporary which will have the RightValue of symbol, Sym.
                    If Sym is a right value and has type, type, then no quadruples are
                    generated and Sym is returned. Otherwise a new temporary is created
                    and an IndrX quadruple is generated.
*/

static unsigned int MakeRightValue (unsigned int tok, unsigned int Sym, unsigned int type)
{
  unsigned int t;

  if ((SymbolTable_GetMode (Sym)) == SymbolTable_RightValue)
    {
      if ((SymbolTable_GetSType (Sym)) == type)
        {
          return Sym;
        }
      else
        {
          /* 
            type change or mode change, type changes are a pain, but I've
            left them here as it is perhaps easier to remove them later.
  */
          t = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
          SymbolTable_PutVar (t, type);
          GenQuadOtok (tok, M2Quads_BecomesOp, t, SymbolTable_NulSym, doVal (type, Sym), true, tok, tok, tok);
          return t;
        }
    }
  else
    {
      t = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (t, type);
      CheckPointerThroughNil (tok, Sym);
      doIndrX (tok, t, Sym);
      return t;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeLeftValue - returns a temporary coresponding to the LeftValue of
                   symbol, Sym. No quadruple is generated if Sym is already
                   a LeftValue and has the same type.
*/

static unsigned int MakeLeftValue (unsigned int tok, unsigned int Sym, SymbolTable_ModeOfAddr with, unsigned int type)
{
  unsigned int t;

  if ((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue)
    {
      if ((SymbolTable_GetSType (Sym)) == type)
        {
          return Sym;
        }
      else
        {
          /* 
            type change or mode change, type changes are a pain, but I've
            left them here as it is perhaps easier to remove them later
  */
          t = SymbolTable_MakeTemporary (tok, with);
          SymbolTable_PutVar (t, type);
          GenQuadOtok (tok, M2Quads_BecomesOp, t, SymbolTable_NulSym, Sym, true, tok, M2LexBuf_UnknownTokenNo, tok);
          return t;
        }
    }
  else
    {
      t = SymbolTable_MakeTemporary (tok, with);
      SymbolTable_PutVar (t, type);
      GenQuadOtok (tok, M2Quads_AddrOp, t, SymbolTable_NulSym, Sym, true, tok, M2LexBuf_UnknownTokenNo, tok);
      return t;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ManipulatePseudoCallParameters - manipulates the parameters to a pseudo function or
                                    procedure. It dereferences all LeftValue parameters
                                    and Boolean parameters.
                                    The Stack:


                                    Entry                      Exit

                             Ptr ->                            exactly the same
                                    +----------------+
                                    | NoOfParameters |
                                    |----------------|
                                    | Param 1        |
                                    |----------------|
                                    | Param 2        |
                                    |----------------|
                                    .                .
                                    .                .
                                    .                .
                                    |----------------|
                                    | Param #        |
                                    |----------------|
                                    | ProcSym | Type |
                                    |----------------|

*/

static void ManipulatePseudoCallParameters (void)
{
  unsigned int NoOfParameters;
  unsigned int ProcSym;
  unsigned int Proc;
  unsigned int i;
  unsigned int pi;
  M2Quads_BoolFrame f;

  M2Quads_PopT (&NoOfParameters);
  M2Quads_PushT (NoOfParameters);  /* restored to original state  */
  /* Ptr points to the ProcSym  */
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT ((NoOfParameters+1)+1));
  if (SymbolTable_IsVar (ProcSym))
    {
      M2Error_InternalError ((const char *) "expecting a pseudo procedure or a type", 38);
    }
  else
    {
      Proc = ProcSym;
    }
  i = 1;
  pi = NoOfParameters+1;
  while (i <= NoOfParameters)
    {
      if (((((((SymbolTable_GetMode (M2Quads_OperandT (pi))) == SymbolTable_LeftValue) && (Proc != M2System_Adr)) && (Proc != M2Size_Size)) && (Proc != M2System_TSize)) && (Proc != M2Base_High)) && (((((((Proc != M2Base_Inc) && (Proc != M2Base_Incl)) && (Proc != M2Base_Dec)) && (Proc != M2Base_Excl)) && (Proc != M2Base_New)) && (Proc != M2Base_Dispose)) || (i > 1)))
        {
          /* must dereference LeftValue  */
          f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pi));
          f->TrueExit = MakeRightValue (M2LexBuf_GetTokenNo (), M2Quads_OperandT (pi), SymbolTable_GetSType (M2Quads_OperandT (pi)));
        }
      i += 1;
      pi -= 1;
    }
}


/*
   ManipulateParameters - manipulates the procedure parameters in
                          preparation for a procedure call.
                          Prepares Boolean, Unbounded and VAR parameters.
                          The Stack:


                          Entry                      Exit

                   Ptr ->                            exactly the same
                          +----------------+
                          | NoOfParameters |
                          |----------------|
                          | Param 1        |
                          |----------------|
                          | Param 2        |
                          |----------------|
                          .                .
                          .                .
                          .                .
                          |----------------|
                          | Param #        |
                          |----------------|
                          | ProcSym | Type |
                          |----------------|
*/

static void ManipulateParameters (bool IsForC)
{
  unsigned int tokpos;
  unsigned int np;
  DynamicStrings_String s;
  unsigned int ArraySym;
  unsigned int UnboundedType;
  unsigned int ParamType;
  unsigned int NoOfParameters;
  unsigned int i;
  unsigned int pi;
  unsigned int ProcSym;
  unsigned int rw;
  unsigned int Proc;
  unsigned int t;
  M2Quads_BoolFrame f;

  M2Quads_PopT (&NoOfParameters);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParameters+1));
  tokpos = OperandTtok (NoOfParameters+1);
  if (SymbolTable_IsVar (ProcSym))
    {
      /* Procedure Variable ?  */
      Proc = SymbolTable_SkipType (M2Quads_OperandF (NoOfParameters+1));
    }
  else
    {
      Proc = PCSymBuild_SkipConst (ProcSym);
    }
  if (IsForC && (SymbolTable_UsesVarArgs (Proc)))
    {
      /* avoid dangling else.  */
      if (NoOfParameters < (SymbolTable_NoOfParamAny (Proc)))
        {
          s = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Proc))));
          np = SymbolTable_NoOfParamAny (Proc);
          M2Error_ErrorStringAt2 (FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "attempting to pass (%d) parameters to procedure (%s) which was declared with varargs but contains at least (%d) parameters", 122)), (const unsigned char *) &NoOfParameters, (sizeof (NoOfParameters)-1), (const unsigned char *) &s, (sizeof (s)-1), (const unsigned char *) &np, (sizeof (np)-1)), tokpos, SymbolTable_GetDeclaredMod (ProcSym));
        }
    }
  else if (SymbolTable_UsesOptArgAny (Proc))
    {
      /* avoid dangling else.  */
      if (! ((NoOfParameters == (SymbolTable_NoOfParamAny (Proc))) || ((NoOfParameters+1) == (SymbolTable_NoOfParamAny (Proc)))))
        {
          s = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Proc))));
          np = SymbolTable_NoOfParamAny (Proc);
          M2Error_ErrorStringAt2 (FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "attempting to pass (%d) parameters to procedure (%s) which was declared with an optarg with a maximum of (%d) parameters", 120)), (const unsigned char *) &NoOfParameters, (sizeof (NoOfParameters)-1), (const unsigned char *) &s, (sizeof (s)-1), (const unsigned char *) &np, (sizeof (np)-1)), tokpos, SymbolTable_GetDeclaredMod (ProcSym));
        }
    }
  else if (NoOfParameters != (SymbolTable_NoOfParamAny (Proc)))
    {
      /* avoid dangling else.  */
      s = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (Proc))));
      np = SymbolTable_NoOfParamAny (Proc);
      M2Error_ErrorStringAt2 (FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "attempting to pass (%d) parameters to procedure (%s) which was declared with (%d) parameters", 92)), (const unsigned char *) &NoOfParameters, (sizeof (NoOfParameters)-1), (const unsigned char *) &s, (sizeof (s)-1), (const unsigned char *) &np, (sizeof (np)-1)), tokpos, SymbolTable_GetDeclaredMod (ProcSym));
    }
  i = 1;
  pi = NoOfParameters;
  while (i <= NoOfParameters)
    {
      f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pi));
      rw = static_cast<unsigned int> (OperandMergeRW (pi));
      M2Debug_Assert (SymbolTable_IsLegal (rw));
      if (i > (SymbolTable_NoOfParamAny (Proc)))
        {
          if (IsForC && (SymbolTable_UsesVarArgs (Proc)))
            {
              /* avoid dangling else.  */
              if (((SymbolTable_GetSType (M2Quads_OperandT (pi))) != SymbolTable_NulSym) && (SymbolTable_IsArray (SymbolTable_GetDType (M2Quads_OperandT (pi)))))
                {
                  f->TrueExit = MakeLeftValue (M2Quads_OperandTok (pi), M2Quads_OperandT (pi), SymbolTable_RightValue, M2System_Address);
                  MarkAsReadWrite (rw);
                }
              else if (SymbolTable_IsConstString (M2Quads_OperandT (pi)))
                {
                  /* avoid dangling else.  */
                  f->TrueExit = MakeLeftValue (M2Quads_OperandTok (pi), DeferMakeConstStringCnul (M2Quads_OperandTok (pi), M2Quads_OperandT (pi)), SymbolTable_RightValue, M2System_Address);
                  MarkAsReadWrite (rw);
                }
              else if (((SymbolTable_GetSType (M2Quads_OperandT (pi))) != SymbolTable_NulSym) && (SymbolTable_IsUnbounded (SymbolTable_GetSType (M2Quads_OperandT (pi)))))
                {
                  /* avoid dangling else.  */
                  MarkAsReadWrite (rw);
                  /* pass the address field of an unbounded variable  */
                  M2Quads_PushTFtok (M2System_Adr, M2System_Address, M2Quads_OperandTok (pi));
                  PushTFAD (f->TrueExit, f->FalseExit, f->Unbounded, f->Dimension);
                  M2Quads_PushT (static_cast<unsigned int> (1));
                  BuildAdrFunction ();
                  M2Quads_PopT (&f->TrueExit);
                }
              else if ((SymbolTable_GetMode (M2Quads_OperandT (pi))) == SymbolTable_LeftValue)
                {
                  /* avoid dangling else.  */
                  MarkAsReadWrite (rw);
                  /* must dereference LeftValue (even if we are passing variable as a vararg)  */
                  t = SymbolTable_MakeTemporary (M2Quads_OperandTok (pi), SymbolTable_RightValue);
                  SymbolTable_PutVar (t, SymbolTable_GetSType (M2Quads_OperandT (pi)));
                  CheckPointerThroughNil (tokpos, M2Quads_OperandT (pi));
                  doIndrX (M2Quads_OperandTok (pi), t, M2Quads_OperandT (pi));
                  f->TrueExit = t;
                }
            }
          else
            {
              M2MetaError_MetaErrorT2 (tokpos, (const char *) "attempting to pass too many parameters to procedure {%1a}, the {%2N} parameter does not exist", 93, Proc, i);
            }
        }
      else if (((IsForC && (SymbolTable_IsUnboundedParamAny (Proc, i))) && ((SymbolTable_GetSType (M2Quads_OperandT (pi))) != SymbolTable_NulSym)) && (SymbolTable_IsArray (SymbolTable_GetDType (M2Quads_OperandT (pi)))))
        {
          /* avoid dangling else.  */
          f->TrueExit = MakeLeftValue (M2Quads_OperandTok (pi), M2Quads_OperandT (pi), SymbolTable_RightValue, M2System_Address);
          MarkAsReadWrite (rw);
        }
      else if (((IsForC && (SymbolTable_IsUnboundedParamAny (Proc, i))) && ((SymbolTable_GetSType (M2Quads_OperandT (pi))) != SymbolTable_NulSym)) && (SymbolTable_IsUnbounded (SymbolTable_GetDType (M2Quads_OperandT (pi)))))
        {
          /* avoid dangling else.  */
          MarkAsReadWrite (rw);
          /* pass the address field of an unbounded variable  */
          M2Quads_PushTFtok (M2System_Adr, M2System_Address, M2Quads_OperandTok (pi));
          PushTFAD (f->TrueExit, f->FalseExit, f->Unbounded, f->Dimension);
          M2Quads_PushT (static_cast<unsigned int> (1));
          BuildAdrFunction ();
          M2Quads_PopT (&f->TrueExit);
        }
      else if ((IsForC && (SymbolTable_IsConstString (M2Quads_OperandT (pi)))) && ((SymbolTable_IsUnboundedParamAny (Proc, i)) || ((SymbolTable_GetDType (SymbolTable_GetParam (Proc, i))) == M2System_Address)))
        {
          /* avoid dangling else.  */
          f->TrueExit = MakeLeftValue (M2Quads_OperandTok (pi), DeferMakeConstStringCnul (M2Quads_OperandTok (pi), M2Quads_OperandT (pi)), SymbolTable_RightValue, M2System_Address);
          MarkAsReadWrite (rw);
        }
      else if (SymbolTable_IsUnboundedParamAny (Proc, i))
        {
          /* avoid dangling else.  */
          /* always pass constant strings with a nul terminator, but leave the HIGH as before.  */
          if (SymbolTable_IsConstString (M2Quads_OperandT (pi)))
            {
              /* this is a Modula-2 string which must be nul terminated.  */
              f->TrueExit = DeferMakeConstStringM2nul (M2Quads_OperandTok (pi), M2Quads_OperandT (pi));
            }
          t = SymbolTable_MakeTemporary (M2Quads_OperandTok (pi), SymbolTable_RightValue);
          UnboundedType = SymbolTable_GetSType (SymbolTable_GetParam (Proc, i));
          SymbolTable_PutVar (t, UnboundedType);
          ParamType = SymbolTable_GetSType (UnboundedType);
          if ((OperandD (pi)) == 0)
            {
              ArraySym = static_cast<unsigned int> (M2Quads_OperandT (pi));
            }
          else
            {
              ArraySym = static_cast<unsigned int> (M2Quads_OperandA (pi));
            }
          if (SymbolTable_IsVarParamAny (Proc, i))
            {
              MarkArrayWritten (M2Quads_OperandT (pi));
              MarkArrayWritten (M2Quads_OperandA (pi));
              MarkAsReadWrite (rw);
              AssignUnboundedVar (OperandTtok (pi), M2Quads_OperandT (pi), ArraySym, t, ParamType, OperandD (pi));
            }
          else
            {
              MarkAsRead (rw);
              AssignUnboundedNonVar (OperandTtok (pi), M2Quads_OperandT (pi), ArraySym, t, ParamType, OperandD (pi));
            }
          f->TrueExit = t;
        }
      else if (SymbolTable_IsVarParamAny (Proc, i))
        {
          /* avoid dangling else.  */
          /* must reference by address, but we contain the type of the referenced entity  */
          MarkArrayWritten (M2Quads_OperandT (pi));
          MarkArrayWritten (M2Quads_OperandA (pi));
          MarkAsReadWrite (rw);
          f->TrueExit = MakeLeftValue (M2Quads_OperandTok (pi), M2Quads_OperandT (pi), SymbolTable_LeftValue, SymbolTable_GetSType (SymbolTable_GetParam (Proc, i)));
        }
      else if ((! (SymbolTable_IsVarParamAny (Proc, i))) && ((SymbolTable_GetMode (M2Quads_OperandT (pi))) == SymbolTable_LeftValue))
        {
          /* avoid dangling else.  */
          /* must dereference LeftValue  */
          t = SymbolTable_MakeTemporary (M2Quads_OperandTok (pi), SymbolTable_RightValue);
          SymbolTable_PutVar (t, SymbolTable_GetSType (M2Quads_OperandT (pi)));
          CheckPointerThroughNil (tokpos, M2Quads_OperandT (pi));
          doIndrX (M2Quads_OperandTok (pi), t, M2Quads_OperandT (pi));
          f->TrueExit = t;
          MarkAsRead (rw);
        }
      else
        {
          /* avoid dangling else.  */
          MarkAsRead (rw);
        }
      i += 1;
      pi -= 1;
    }
  M2Quads_PushT (NoOfParameters);
}


/*
   CheckParameterOrdinals - check that ordinal values are within type range.
*/

static void CheckParameterOrdinals (void)
{
  unsigned int tokno;
  unsigned int Proc;
  unsigned int ProcSym;
  unsigned int Actual;
  unsigned int FormalI;
  unsigned int ParamTotal;
  unsigned int pi;
  unsigned int i;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PushT (ParamTotal);  /* Restore stack to origional state  */
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT ((ParamTotal+1)+1));  /* Restore stack to origional state  */
  if ((SymbolTable_IsVar (ProcSym)) && (SymbolTable_IsProcType (SymbolTable_GetDType (ProcSym))))
    {
      /* Indirect procedure call.  */
      Proc = SymbolTable_SkipType (M2Quads_OperandF ((ParamTotal+1)+1));
    }
  else
    {
      Proc = PCSymBuild_SkipConst (ProcSym);
    }
  i = 1;
  pi = ParamTotal+1;  /* stack index referencing stacked parameter, i  */
  while (i <= ParamTotal)  /* stack index referencing stacked parameter, i  */
    {
      if (i <= (SymbolTable_NoOfParamAny (Proc)))
        {
          FormalI = SymbolTable_GetParam (Proc, i);
          Actual = static_cast<unsigned int> (M2Quads_OperandT (pi));
          tokno = static_cast<unsigned int> (M2Quads_OperandTok (pi));
          if (M2Base_IsOrdinalType (SymbolTable_GetLType (FormalI)))
            {
              if (! (SymbolTable_IsSet (SymbolTable_GetDType (FormalI))))
                {
                  /* Tell the code generator to test the runtime values of the assignment
                  so ensure we catch overflow and underflow.  */
                  BuildRange (M2Range_InitParameterRangeCheck (tokno, Proc, i, FormalI, Actual, OperandRangeDep (pi)));
                }
            }
        }
      i += 1;
      pi -= 1;
    }
}


/*
   IsSameUnbounded - returns TRUE if unbounded types, t1, and, t2,
                     are compatible.
*/

static bool IsSameUnbounded (unsigned int t1, unsigned int t2)
{
  M2Debug_Assert (SymbolTable_IsUnbounded (t1));
  M2Debug_Assert (SymbolTable_IsUnbounded (t2));
  return (SymbolTable_GetDType (t1)) == (SymbolTable_GetDType (t2));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AssignUnboundedVar - assigns an Unbounded symbol fields,
                        ArrayAddress and ArrayHigh, from an array symbol.
                        UnboundedSym is not a VAR parameter and therefore
                        this procedure can complete both of the fields.
                        Sym can be a Variable with type Unbounded.
                        Sym can be a Variable with type Array.
                        Sym can be a String Constant.

                        ParamType is the TYPE of the parameter
*/

static void AssignUnboundedVar (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim)
{
  unsigned int Type;

  if (SymbolTable_IsConst (Sym))
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "{%1ad} cannot be passed to a VAR formal parameter", 49, Sym);
    }
  else if (SymbolTable_IsVar (Sym))
    {
      /* avoid dangling else.  */
      Type = SymbolTable_GetDType (Sym);
      if (Type == SymbolTable_NulSym)
        {
          M2MetaError_MetaErrorT1 (tok, (const char *) "{%1ad} has no type and cannot be passed to a VAR formal parameter", 65, Sym);
        }
      else if (SymbolTable_IsUnbounded (Type))
        {
          /* avoid dangling else.  */
          if (Type == (SymbolTable_GetSType (UnboundedSym)))
            {
              /* Copy Unbounded Symbol ie. UnboundedSym := Sym  */
              M2Quads_PushT (UnboundedSym);
              M2Quads_PushT (Sym);
              BuildAssignmentWithoutBounds (tok, false, true);
            }
          else if ((IsSameUnbounded (Type, SymbolTable_GetSType (UnboundedSym))) || (M2System_IsGenericSystemType (ParamType)))
            {
              /* avoid dangling else.  */
              UnboundedVarLinkToArray (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
            }
          else
            {
              /* avoid dangling else.  */
              M2MetaError_MetaErrorT1 (tok, (const char *) "{%1ad} cannot be passed to a VAR formal parameter", 49, Sym);
            }
        }
      else if ((SymbolTable_IsArray (Type)) || (M2System_IsGenericSystemType (ParamType)))
        {
          /* avoid dangling else.  */
          UnboundedVarLinkToArray (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (tok, (const char *) "{%1ad} cannot be passed to a VAR formal parameter", 49, Sym);
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (tok, (const char *) "{%1ad} cannot be passed to a VAR formal parameter", 49, Sym);
    }
}


/*
   AssignUnboundedNonVar - assigns an Unbounded symbol fields,
                           The difference between this procedure and
                           AssignUnboundedVar is that this procedure cannot
                           set the Unbounded.Address since the data from
                           Sym will be copied because parameter is NOT a VAR
                           parameter.
                           UnboundedSym is not a VAR parameter and therefore
                           this procedure can only complete the HIGH field
                           and not the ADDRESS field.
                           Sym can be a Variable with type Unbounded.
                           Sym can be a Variable with type Array.
                           Sym can be a String Constant.

                           ParamType is the TYPE of the paramater
*/

static void AssignUnboundedNonVar (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim)
{
  unsigned int Type;

  if (SymbolTable_IsConst (Sym))  /* was IsConstString(Sym)  */
    {
      UnboundedNonVarLinkToArray (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
    }
  else if (SymbolTable_IsVar (Sym))
    {
      /* avoid dangling else.  */
      Type = SymbolTable_GetDType (Sym);
      if (Type == SymbolTable_NulSym)
        {
          M2MetaError_MetaErrorT1 (tok, (const char *) "{%1ad} has no type and cannot be passed to a non VAR formal parameter", 69, Sym);
        }
      else if (SymbolTable_IsUnbounded (Type))
        {
          /* avoid dangling else.  */
          UnboundedNonVarLinkToArray (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
        }
      else if ((SymbolTable_IsArray (Type)) || (M2System_IsGenericSystemType (ParamType)))
        {
          /* avoid dangling else.  */
          UnboundedNonVarLinkToArray (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (tok, (const char *) "illegal type parameter {%1Ead} expecting array or dynamic array", 63, Sym);
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (tok, (const char *) "illegal parameter {%1Ead} which cannot be passed as {%kVAR} {%kARRAY} {%kOF} {%1tsad}", 85, Sym);
    }
}


/*
   GenHigh - generates a HighOp but it checks if op3 is a
             L value and if so it dereferences it.  This
             is inefficient, however it is clean and we let the gcc
             backend detect these as common subexpressions.
             It will also detect that a R value -> L value -> R value
             via indirection and eleminate these.
*/

static void GenHigh (unsigned int tok, unsigned int op1, unsigned int op2, unsigned int op3)
{
  unsigned int sym;

  if (((SymbolTable_GetMode (op3)) == SymbolTable_LeftValue) && (SymbolTable_IsUnbounded (SymbolTable_GetSType (op3))))
    {
      sym = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (sym, SymbolTable_GetSType (op3));
      doIndrX (tok, sym, op3);
      GenQuadO (tok, M2Quads_HighOp, op1, op2, sym, true);
    }
  else
    {
      GenQuadO (tok, M2Quads_HighOp, op1, op2, op3, true);
    }
}


/*
   AssignHighField -
*/

static void AssignHighField (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int actuali, unsigned int formali)
{
  unsigned int ReturnVar;
  unsigned int ArrayType;
  unsigned int Field;

  /* Unbounded.ArrayHigh := HIGH(ArraySym)  */
  M2Quads_PushTFtok (UnboundedSym, SymbolTable_GetSType (UnboundedSym), tok);
  Field = SymbolTable_GetUnboundedHighOffset (SymbolTable_GetSType (UnboundedSym), formali);
  M2Quads_PushTFtok (Field, SymbolTable_GetSType (Field), tok);
  M2Quads_PushT (static_cast<unsigned int> (1));
  M2Quads_BuildDesignatorRecord (tok);
  if (M2System_IsGenericSystemType (ParamType))
    {
      if (SymbolTable_IsConstString (Sym))
        {
          M2Quads_PushTtok (DeferMakeLengthConst (tok, Sym), tok);
        }
      else
        {
          ArrayType = SymbolTable_GetSType (Sym);
          if (SymbolTable_IsUnbounded (ArrayType))
            {
              /* 
             *  SIZE(parameter) DIV TSIZE(ParamType)
             *  however in this case parameter
             *  is an unbounded symbol and therefore we must use
             *  (HIGH(parameter)+1)*SIZE(unbounded type) DIV TSIZE(ParamType)
             *
             *  we call upon the function SIZE(ArraySym)
             *  remember SIZE doubles as
             *  (HIGH(a)+1) * SIZE(ArrayType) for unbounded symbols
  */
              M2Quads_PushTFtok (calculateMultipicand (tok, ArraySym, ArrayType, actuali-1), M2Base_Cardinal, tok);
              M2Quads_PushT (M2Reserved_DivideTok);  /* Divide by  */
              M2Quads_PushTFtok (M2System_TSize, M2Base_Cardinal, tok);  /* TSIZE(ParamType)  */
              M2Quads_PushTtok (ParamType, tok);  /* TSIZE(ParamType)  */
              M2Quads_PushT (static_cast<unsigned int> (1));  /* 1 parameter for TSIZE()  */
              M2Quads_BuildFunctionCall (false);  /* 1 parameter for TSIZE()  */
              M2Quads_BuildBinaryOp ();
            }
          else
            {
              /* SIZE(parameter) DIV TSIZE(ParamType)  */
              M2Quads_PushTFtok (M2System_TSize, M2Base_Cardinal, tok);  /* TSIZE(ArrayType)  */
              M2Quads_PushTtok (ArrayType, tok);  /* TSIZE(ArrayType)  */
              M2Quads_PushT (static_cast<unsigned int> (1));  /* 1 parameter for TSIZE()  */
              M2Quads_BuildFunctionCall (true);  /* 1 parameter for TSIZE()  */
              M2Quads_PushT (M2Reserved_DivideTok);  /* Divide by  */
              M2Quads_PushTFtok (M2System_TSize, M2Base_Cardinal, tok);  /* TSIZE(ParamType)  */
              M2Quads_PushTtok (ParamType, tok);  /* TSIZE(ParamType)  */
              M2Quads_PushT (static_cast<unsigned int> (1));  /* 1 parameter for TSIZE()  */
              M2Quads_BuildFunctionCall (true);  /* 1 parameter for TSIZE()  */
              M2Quads_BuildBinaryOp ();
            }
          /* now convert from no of elements into HIGH by subtracting 1  */
          M2Quads_PushT (M2Reserved_MinusTok);  /* -1  */
          M2Quads_PushTtok (SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1", 1), M2Base_Cardinal), tok);  /* -1  */
          M2Quads_BuildBinaryOp ();
        }
    }
  else
    {
      ReturnVar = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
      if (((actuali != formali) && (ArraySym != SymbolTable_NulSym)) && (SymbolTable_IsUnbounded (SymbolTable_GetSType (ArraySym))))
        {
          GenHigh (tok, ReturnVar, actuali, ArraySym);
        }
      else
        {
          GenHigh (tok, ReturnVar, formali, Sym);
        }
      M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (ReturnVar), tok);
    }
  BuildAssignmentWithoutBounds (tok, false, true);
}


/*
   AssignHighFields -
*/

static void AssignHighFields (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim)
{
  unsigned int type;
  unsigned int actuali;
  unsigned int formali;
  unsigned int actualn;
  unsigned int formaln;

  type = SymbolTable_GetDType (Sym);
  actualn = 1;
  if ((type != SymbolTable_NulSym) && ((SymbolTable_IsUnbounded (type)) || (SymbolTable_IsArray (type))))
    {
      actualn = SymbolTable_GetDimension (type);
    }
  actuali = dim+1;
  formali = 1;
  formaln = SymbolTable_GetDimension (SymbolTable_GetDType (UnboundedSym));
  while ((actuali < actualn) && (formali < formaln))
    {
      AssignHighField (tok, Sym, ArraySym, UnboundedSym, SymbolTable_NulSym, actuali, formali);
      actuali += 1;
      formali += 1;
    }
  AssignHighField (tok, Sym, ArraySym, UnboundedSym, ParamType, actuali, formali);
}


/*
   UnboundedNonVarLinkToArray - links an array, ArraySym, to an unbounded
                                array, UnboundedSym. The parameter is a
                                NON VAR variety.
*/

static void UnboundedNonVarLinkToArray (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim)
{
  unsigned int Field;
  unsigned int AddressField;

  /* Unbounded.ArrayAddress := to be assigned at runtime.  */
  M2Quads_PushTFtok (UnboundedSym, SymbolTable_GetSType (UnboundedSym), tok);
  Field = SymbolTable_GetUnboundedAddressOffset (SymbolTable_GetSType (UnboundedSym));
  M2Quads_PushTFtok (Field, SymbolTable_GetSType (Field), tok);
  M2Quads_PushT (static_cast<unsigned int> (1));
  M2Quads_BuildDesignatorRecord (tok);
  M2Quads_PopT (&AddressField);
  /* caller saves non var unbounded array contents.  */
  GenQuadO (tok, M2Quads_UnboundedOp, AddressField, SymbolTable_NulSym, Sym, false);
  AssignHighFields (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
}


/*
   UnboundedVarLinkToArray - links an array, ArraySym, to an unbounded array,
                             UnboundedSym. The parameter is a VAR variety.
*/

static void UnboundedVarLinkToArray (unsigned int tok, unsigned int Sym, unsigned int ArraySym, unsigned int UnboundedSym, unsigned int ParamType, unsigned int dim)
{
  unsigned int SymType;
  unsigned int Field;

  SymType = SymbolTable_GetSType (Sym);
  /* Unbounded.ArrayAddress := ADR(Sym)  */
  M2Quads_PushTFtok (UnboundedSym, SymbolTable_GetSType (UnboundedSym), tok);
  Field = SymbolTable_GetUnboundedAddressOffset (SymbolTable_GetSType (UnboundedSym));
  M2Quads_PushTFtok (Field, SymbolTable_GetSType (Field), tok);
  M2Quads_PushT (static_cast<unsigned int> (1));
  M2Quads_BuildDesignatorRecord (tok);
  M2Quads_PushTFtok (M2System_Adr, M2System_Address, tok);  /* ADR (Sym).  */
  if ((SymbolTable_IsUnbounded (SymType)) && (dim == 0))  /* ADR (Sym).  */
    {
      PushTFADtok (Sym, SymType, UnboundedSym, dim, tok);
    }
  else
    {
      PushTFADtok (Sym, SymType, ArraySym, dim, tok);
    }
  M2Quads_PushT (static_cast<unsigned int> (1));  /* 1 parameter for ADR().  */
  M2Quads_BuildFunctionCall (false);  /* 1 parameter for ADR().  */
  BuildAssignmentWithoutBounds (tok, false, true);
  AssignHighFields (tok, Sym, ArraySym, UnboundedSym, ParamType, dim);
}


/*
   BuildPseudoProcedureCall - builds a pseudo procedure call.
                              This procedure does not directly alter the
                              stack, but by calling routines the stack
                              will change in the following way when this
                              procedure returns.

                              The Stack:


                              Entry                      Exit

                       Ptr ->
                              +----------------+
                              | NoOfParam      |
                              |----------------|
                              | Param 1        |
                              |----------------|
                              | Param 2        |
                              |----------------|
                              .                .
                              .                .
                              .                .
                              |----------------|
                              | Param #        |
                              |----------------|
                              | ProcSym | Type |         Empty
                              |----------------|
*/

static void BuildPseudoProcedureCall (unsigned int tokno)
{
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  M2Quads_PushT (NoOfParam);
  /* Compile time stack restored to entry state  */
  if (ProcSym == M2Base_New)
    {
      BuildNewProcedure (tokno);
    }
  else if (ProcSym == M2Base_Dispose)
    {
      /* avoid dangling else.  */
      BuildDisposeProcedure (tokno);
    }
  else if (ProcSym == M2Base_Inc)
    {
      /* avoid dangling else.  */
      BuildIncProcedure (tokno);
    }
  else if (ProcSym == M2Base_Dec)
    {
      /* avoid dangling else.  */
      BuildDecProcedure (tokno);
    }
  else if (ProcSym == M2Base_Incl)
    {
      /* avoid dangling else.  */
      BuildInclProcedure (tokno);
    }
  else if (ProcSym == M2Base_Excl)
    {
      /* avoid dangling else.  */
      BuildExclProcedure (tokno);
    }
  else if (ProcSym == M2System_Throw)
    {
      /* avoid dangling else.  */
      BuildThrowProcedure (tokno);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "pseudo procedure not implemented yet", 36);
    }
}


/*
   GetItemPointedTo - returns the symbol type that is being pointed to
                      by Sym.
*/

static unsigned int GetItemPointedTo (unsigned int Sym)
{
  if (SymbolTable_IsPointer (Sym))
    {
      return SymbolTable_GetSType (Sym);
    }
  else if ((SymbolTable_IsVar (Sym)) || (SymbolTable_IsType (Sym)))
    {
      /* avoid dangling else.  */
      return GetItemPointedTo (SymbolTable_GetSType (Sym));
    }
  else
    {
      /* avoid dangling else.  */
      return SymbolTable_NulSym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildThrowProcedure - builds the pseudo procedure call M2RTS.Throw.
                         The Stack:


                         Entry                      Exit

                Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |
                         |----------------|
                         .                .
                         .                .
                         .                .
                         |----------------|
                         | Param #        |
                         |----------------|
                         | ProcSym | Type |         Empty
                         |----------------|
*/

static void BuildThrowProcedure (unsigned int functok)
{
  unsigned int op;
  unsigned int NoOfParam;

  M2Quads_PopT (&NoOfParam);
  if (NoOfParam == 1)
    {
      op = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));
      GenQuadO (functok, M2Quads_ThrowOp, SymbolTable_NulSym, SymbolTable_NulSym, op, false);
    }
  else
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo procedure %{1Ea} takes one INTEGER parameter", 55, M2System_Throw);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   BuildNewProcedure - builds the pseudo procedure call NEW.
                       This procedure is traditionally a "macro" for
                       NEW(x, ...) --> ALLOCATE(x, TSIZE(x^, ...))
                       One method of implementation is to emulate a "macro"
                       processor by pushing the relevant input tokens
                       back onto the input stack.
                       However this causes two problems:

                       (i)  Unnecessary code is produced for x^
                       (ii) SIZE must be imported from SYSTEM
                       Therefore we chose an alternative method of
                       implementation;
                       generate quadruples for ALLOCATE(x, TSIZE(x^, ...))
                       this, although slightly more efficient,
                       is more complex and circumvents problems (i) and (ii).

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildNewProcedure (unsigned int functok)
{
  unsigned int NoOfParam;
  unsigned int SizeSym;
  unsigned int PtrSym;
  unsigned int ProcSym;
  unsigned int paramtok;
  unsigned int combinedtok;

  M2Quads_PopT (&NoOfParam);
  if (NoOfParam >= 1)
    {
      ProcSym = SymbolTable_RequestSym (functok, NameKey_MakeKey ((const char *) "ALLOCATE", 8));
      if ((ProcSym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (ProcSym)))
        {
          PtrSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));
          paramtok = OperandTtok (1);
          if (IsReallyPointer (PtrSym))
            {
              combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
              /* 
               Build macro: ALLOCATE( PtrSym, SIZE(PtrSym^) )
  */
              M2Quads_PushTFtok (M2System_TSize, M2Base_Cardinal, paramtok);  /* Procedure  */
              /* x^  */
              M2Quads_PushTtok (GetItemPointedTo (PtrSym), paramtok);
              M2Quads_PushT (static_cast<unsigned int> (1));  /* One parameter  */
              M2Quads_BuildFunctionCall (false);  /* One parameter  */
              M2Quads_PopT (&SizeSym);
              M2Quads_PushTtok (ProcSym, combinedtok);  /* ALLOCATE  */
              M2Quads_PushTtok (PtrSym, paramtok);  /* x  */
              M2Quads_PushTtok (SizeSym, paramtok);  /* TSIZE(x^)  */
              M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
              M2Quads_BuildProcedureCall (combinedtok);  /* Two parameters  */
            }
          else
            {
              M2MetaError_MetaErrorT0 (paramtok, (const char *) "parameter to {%EkNEW} must be a pointer", 39);
            }
        }
      else
        {
          M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}ALLOCATE procedure not found for NEW substitution", 53);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (functok, (const char *) "the pseudo procedure {%EkNEW} has one or more parameters", 56);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   BuildDisposeProcedure - builds the pseudo procedure call DISPOSE.
                           This procedure is traditionally a "macro" for
                           DISPOSE(x) --> DEALLOCATE(x, TSIZE(x^))
                           One method of implementation is to emulate a "macro"
                           processor by pushing the relevant input tokens
                           back onto the input stack.
                           However this causes two problems:

                           (i)  Unnecessary code is produced for x^
                           (ii) TSIZE must be imported from SYSTEM
                           Therefore we chose an alternative method of
                           implementation;
                           generate quadruples for DEALLOCATE(x, TSIZE(x^))
                           this, although slightly more efficient,
                           is more complex and circumvents problems (i)
                           and (ii).

                           The Stack:


                           Entry                      Exit

                    Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |
                           |----------------|
                           | ProcSym | Type |         Empty
                           |----------------|
*/

static void BuildDisposeProcedure (unsigned int functok)
{
  unsigned int NoOfParam;
  unsigned int SizeSym;
  unsigned int PtrSym;
  unsigned int ProcSym;
  unsigned int combinedtok;
  unsigned int paramtok;

  M2Quads_PopT (&NoOfParam);
  if (NoOfParam >= 1)
    {
      ProcSym = SymbolTable_RequestSym (functok, NameKey_MakeKey ((const char *) "DEALLOCATE", 10));
      if ((ProcSym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (ProcSym)))
        {
          PtrSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));
          paramtok = OperandTtok (1);
          if (IsReallyPointer (PtrSym))
            {
              combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
              /* 
               Build macro: DEALLOCATE( PtrSym, TSIZE(PtrSym^) )
  */
              M2Quads_PushTFtok (M2System_TSize, M2Base_Cardinal, paramtok);  /* Procedure  */
              /* x^  */
              M2Quads_PushTtok (GetItemPointedTo (PtrSym), paramtok);
              M2Quads_PushT (static_cast<unsigned int> (1));  /* One parameter  */
              M2Quads_BuildFunctionCall (false);  /* One parameter  */
              M2Quads_PopT (&SizeSym);
              M2Quads_PushTtok (ProcSym, combinedtok);  /* DEALLOCATE  */
              M2Quads_PushTtok (PtrSym, paramtok);  /* x  */
              M2Quads_PushTtok (SizeSym, paramtok);  /* TSIZE(x^)  */
              M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
              M2Quads_BuildProcedureCall (combinedtok);  /* Two parameters  */
            }
          else
            {
              M2MetaError_MetaErrorT0 (paramtok, (const char *) "argument to {%EkDISPOSE} must be a pointer", 42);
            }
        }
      else
        {
          M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}DEALLOCATE procedure not found for DISPOSE substitution", 59);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (functok, (const char *) "the pseudo procedure {%EkDISPOSE} has one or more parameters", 60);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   CheckRangeIncDec - performs des := des <tok> expr
                      with range checking (if enabled).

                               Stack
                      Entry              Exit

                                     +------------+
                      empty          | des + expr |
                                     |------------|
*/

static void CheckRangeIncDec (unsigned int tokenpos, unsigned int des, unsigned int expr, NameKey_Name tok)
{
  unsigned int dtype;
  unsigned int etype;

  dtype = SymbolTable_GetDType (des);
  etype = SymbolTable_GetDType (expr);
  if ((etype == SymbolTable_NulSym) && (SymbolTable_IsPointer (SymbolTable_GetTypeMode (des))))
    {
      expr = ConvertToAddress (tokenpos, expr);
      etype = M2System_Address;
    }
  if (M2Options_WholeValueChecking && ! MustNotCheckBounds)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (tok == M2Reserved_PlusTok)
        {
          BuildRange (M2Range_InitIncRangeCheck (des, expr));
        }
      else
        {
          BuildRange (M2Range_InitDecRangeCheck (des, expr));
        }
    }
  if (M2Base_IsExpressionCompatible (dtype, etype))
    {
      /* the easy case simulate a straightforward macro  */
      M2Quads_PushTFtok (des, dtype, tokenpos);
      M2Quads_PushT (tok);
      M2Quads_PushTFtok (expr, etype, tokenpos);
      doBuildBinaryOp (false, true);
    }
  else
    {
      if ((((M2Base_IsOrdinalType (dtype)) || (dtype == M2System_Address)) || (SymbolTable_IsPointer (dtype))) && (((M2Base_IsOrdinalType (etype)) || (etype == M2System_Address)) || (SymbolTable_IsPointer (etype))))
        {
          M2Quads_PushTFtok (des, dtype, tokenpos);
          M2Quads_PushT (tok);
          M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), tokenpos);
          M2Quads_PushTtok (dtype, tokenpos);
          M2Quads_PushTtok (expr, tokenpos);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, false);  /* Two parameters  */
          doBuildBinaryOp (false, true);
        }
      else
        {
          if (tok == M2Reserved_PlusTok)
            {
              M2MetaError_MetaError0 ((const char *) "cannot perform {%EkINC} using non ordinal types", 47);
            }
          else
            {
              M2MetaError_MetaError0 ((const char *) "cannot perform {%EkDEC} using non ordinal types", 47);
            }
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (tokenpos, NameKey_MakeKey ((const char *) "0", 1), SymbolTable_NulSym), static_cast<unsigned int> (SymbolTable_NulSym), tokenpos);
        }
    }
}


/*
   BuildIncProcedure - builds the pseudo procedure call INC.
                       INC is a procedure which increments a variable.
                       It takes one or two parameters:
                       INC(a, b)  or  INC(a)
                       a := a+b   or  a := a+1

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildIncProcedure (unsigned int proctok)
{
  unsigned int NoOfParam;
  unsigned int dtype;
  unsigned int OperandSym;
  unsigned int VarSym;
  unsigned int TempSym;

  M2Quads_PopT (&NoOfParam);
  if ((NoOfParam == 1) || (NoOfParam == 2))
    {
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));  /* Bottom/first parameter.  */
      if (SymbolTable_IsVar (VarSym))  /* Bottom/first parameter.  */
        {
          dtype = SymbolTable_GetDType (VarSym);
          if (NoOfParam == 2)
            {
              OperandSym = DereferenceLValue (proctok, M2Quads_OperandT (1));
            }
          else
            {
              PushOne (proctok, dtype, (const char *) "the {%EkINC} will cause an overflow {%1ad}", 42);
              M2Quads_PopT (&OperandSym);
            }
          M2Quads_PushTtok (VarSym, proctok);
          TempSym = DereferenceLValue (proctok, VarSym);
          CheckRangeIncDec (proctok, TempSym, OperandSym, M2Reserved_PlusTok);  /* TempSym + OperandSym.  */
          BuildAssignmentWithoutBounds (proctok, false, true);  /* VarSym := TempSym + OperandSym.  */
        }
      else
        {
          M2MetaError_MetaErrorT1 (proctok, (const char *) "base procedure {%EkINC} expects a variable as a parameter but was given {%1Ed}", 78, VarSym);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (proctok, (const char *) "the base procedure {%EkINC} expects 1 or 2 parameters", 53);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   BuildDecProcedure - builds the pseudo procedure call DEC.
                       DEC is a procedure which decrements a variable.
                       It takes one or two parameters:
                       DEC(a, b)  or  DEC(a)
                       a := a-b   or  a := a-1

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildDecProcedure (unsigned int proctok)
{
  unsigned int NoOfParam;
  unsigned int dtype;
  unsigned int OperandSym;
  unsigned int VarSym;
  unsigned int TempSym;

  M2Quads_PopT (&NoOfParam);
  if ((NoOfParam == 1) || (NoOfParam == 2))
    {
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));  /* Bottom/first parameter.  */
      if (SymbolTable_IsVar (VarSym))  /* Bottom/first parameter.  */
        {
          dtype = SymbolTable_GetDType (VarSym);
          if (NoOfParam == 2)
            {
              OperandSym = DereferenceLValue (proctok, M2Quads_OperandT (1));
            }
          else
            {
              PushOne (proctok, dtype, (const char *) "the {%EkDEC} will cause an overflow {%1ad}", 42);
              M2Quads_PopT (&OperandSym);
            }
          M2Quads_PushTtok (VarSym, proctok);
          TempSym = DereferenceLValue (M2Quads_OperandTok (NoOfParam), VarSym);
          CheckRangeIncDec (proctok, TempSym, OperandSym, M2Reserved_MinusTok);  /* TempSym - OperandSym.  */
          BuildAssignmentWithoutBounds (proctok, false, true);  /* VarSym := TempSym - OperandSym.  */
        }
      else
        {
          M2MetaError_MetaErrorT1 (proctok, (const char *) "base procedure {%EkDEC} expects a variable as a parameter but was given {%1Ed}", 78, VarSym);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (proctok, (const char *) "the base procedure {%EkDEC} expects 1 or 2 parameters", 53);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   DereferenceLValue - checks to see whether, operand, is declare as an LValue
                       and if so it dereferences it.
*/

static unsigned int DereferenceLValue (unsigned int tok, unsigned int operand)
{
  unsigned int sym;

  if ((SymbolTable_GetMode (operand)) == SymbolTable_LeftValue)
    {
      /* dereference the pointer  */
      sym = SymbolTable_MakeTemporary (tok, AreConstant (SymbolTable_IsConst (operand)));
      SymbolTable_PutVar (sym, SymbolTable_GetSType (operand));
      M2Quads_PushTtok (sym, tok);
      M2Quads_PushTtok (operand, tok);
      BuildAssignmentWithoutBounds (tok, false, true);
      return sym;
    }
  else
    {
      return operand;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildInclProcedure - builds the pseudo procedure call INCL.
                        INCL is a procedure which adds bit b into a BITSET a.
                        It takes two parameters:
                        INCL(a, b)

                        a := a + {b}

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildInclProcedure (unsigned int proctok)
{
  unsigned int optok;
  unsigned int NoOfParam;
  unsigned int DerefSym;
  unsigned int OperandSym;
  unsigned int VarSym;

  M2Quads_PopT (&NoOfParam);
  if (NoOfParam == 2)
    {
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (2));
      MarkArrayWritten (M2Quads_OperandA (2));
      OperandSym = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      if (SymbolTable_IsVar (VarSym))
        {
          if (SymbolTable_IsSet (SymbolTable_GetDType (VarSym)))
            {
              DerefSym = DereferenceLValue (optok, OperandSym);
              BuildRange (M2Range_InitInclCheck (VarSym, DerefSym));
              GenQuadO (proctok, M2Quads_InclOp, VarSym, SymbolTable_NulSym, DerefSym, false);
            }
          else
            {
              M2MetaError_MetaErrorT1 (proctok, (const char *) "the first parameter to {%EkINCL} must be a set variable but is {%1Ed}", 69, VarSym);
            }
        }
      else
        {
          M2MetaError_MetaErrorT1 (proctok, (const char *) "base procedure {%EkINCL} expects a variable as a parameter but is {%1Ed}", 72, VarSym);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (proctok, (const char *) "the base procedure {%EkINCL} expects 1 or 2 parameters", 54);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   BuildExclProcedure - builds the pseudo procedure call EXCL.
                        INCL is a procedure which removes bit b from SET a.
                        It takes two parameters:
                        EXCL(a, b)

                        a := a - {b}

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildExclProcedure (unsigned int proctok)
{
  unsigned int optok;
  unsigned int NoOfParam;
  unsigned int DerefSym;
  unsigned int OperandSym;
  unsigned int VarSym;

  M2Quads_PopT (&NoOfParam);
  if (NoOfParam == 2)
    {
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (2));
      MarkArrayWritten (M2Quads_OperandA (2));
      OperandSym = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      if (SymbolTable_IsVar (VarSym))
        {
          if (SymbolTable_IsSet (SymbolTable_GetDType (VarSym)))
            {
              DerefSym = DereferenceLValue (optok, OperandSym);
              BuildRange (M2Range_InitExclCheck (VarSym, DerefSym));
              GenQuadO (proctok, M2Quads_ExclOp, VarSym, SymbolTable_NulSym, DerefSym, false);
            }
          else
            {
              M2MetaError_MetaErrorT1 (proctok, (const char *) "the first parameter to {%EkEXCL} must be a set variable but is {%1Ed}", 69, VarSym);
            }
        }
      else
        {
          M2MetaError_MetaErrorT1 (proctok, (const char *) "base procedure {%EkEXCL} expects a variable as a parameter but is {%1Ed}", 72, VarSym);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (proctok, (const char *) "the base procedure {%EkEXCL} expects 1 or 2 parameters", 54);
    }
  M2Quads_PopN (NoOfParam+1);
}


/*
   BuildTypeCoercion - builds the type coersion.
                       Modula-2 allows types to be coersed with no runtime
                       penility.
                       It insists that the TSIZE(t1)=TSIZE(t2) where
                       t2 variable := t2(variable of type t1).
                       The ReturnVar on the stack is of type t2.

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|

                       Quadruples:

                       CoerceOp  ReturnVar  Type  Param1

                       A type coercion will only be legal if the different
                       types have exactly the same size.
                       Since we can only decide this after M2Eval has processed
                       the symbol table then we create a quadruple explaining
                       the coercion taking place, the code generator can test
                       this assertion and report an error if the type sizes
                       differ.
*/

static void BuildTypeCoercion (bool ConstExpr)
{
  unsigned int resulttok;
  unsigned int proctok;
  unsigned int exptok;
  unsigned int r;
  unsigned int exp;
  unsigned int NoOfParam;
  unsigned int ReturnVar;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  proctok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (! (SymbolTable_IsAModula2Type (ProcSym)))
    {
      M2MetaError_MetaError1 ((const char *) "coersion expecting a type, seen {%1Ea} which is {%1Ed}", 54, ProcSym);
    }
  if (NoOfParam == 1)
    {
      PopTrwtok (&exp, &r, &exptok);
      MarkAsRead (r);
      resulttok = M2LexBuf_MakeVirtual2Tok (proctok, exptok);
      M2Quads_PopN (1);  /* Pop procedure.  */
      if (ConstExprError (ProcSym, exp, exptok, ConstExpr))  /* Pop procedure.  */
        {
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          SymbolTable_PutVar (ReturnVar, ProcSym);  /* Set ReturnVar's TYPE.  */
        }
       /* Set ReturnVar's TYPE.  */
      else if ((SymbolTable_IsConst (exp)) || (SymbolTable_IsVar (exp)))
        {
          /* avoid dangling else.  */
          ReturnVar = SymbolTable_MakeTemporary (resulttok, AreConstant (SymbolTable_IsConst (exp)));
          SymbolTable_PutVar (ReturnVar, ProcSym);  /* Set ReturnVar's TYPE.  */
          GenQuad (M2Quads_CoerceOp, ReturnVar, ProcSym, exp);  /* Set ReturnVar's TYPE.  */
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError2 ((const char *) "trying to coerse {%1EMRad} which is not a variable or constant into {%2ad}", 74, exp, ProcSym);
          M2MetaError_MetaError2 ((const char *) "trying to coerse {%1ECad} which is not a variable or constant into {%2ad}", 73, exp, ProcSym);
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_RightValue);
          SymbolTable_PutVar (ReturnVar, ProcSym);  /* Set ReturnVar's TYPE.  */
        }
      M2Quads_PushTFtok (ReturnVar, ProcSym, resulttok);
    }
  else
    {
      M2MetaError_MetaError0 ((const char *) "{%E}only one parameter expected in a TYPE coersion", 50);
    }
}


/*
   BuildRealFunctionCall - builds a function call.
                           The Stack:


                           Entry                      Exit

                    Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |                        <- Ptr
                           |----------------|         +------------+
                           | ProcSym | Type |         | ReturnVar  |
                           |----------------|         |------------|
*/

static void BuildRealFunctionCall (unsigned int tokno, bool ConstExpr)
{
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  M2Quads_PushT (NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+2));
  ProcSym = PCSymBuild_SkipConst (ProcSym);
  if (SymbolTable_IsVar (ProcSym))
    {
      /* Procedure Variable therefore get its type to see if it is a FOR "C" call.  */
      ProcSym = SymbolTable_SkipType (M2Quads_OperandF (NoOfParam+2));
    }
  if ((SymbolTable_IsDefImp (SymbolTable_GetScope (ProcSym))) && (SymbolTable_IsDefinitionForC (SymbolTable_GetScope (ProcSym))))
    {
      BuildRealFuncProcCall (tokno, true, true, ConstExpr);
    }
  else
    {
      BuildRealFuncProcCall (tokno, true, false, ConstExpr);
    }
}


/*
   BuildPseudoFunctionCall - builds the pseudo function
                             The Stack:


                             Entry                      Exit

                      Ptr ->
                             +----------------+
                             | NoOfParam      |
                             |----------------|
                             | Param 1        |
                             |----------------|
                             | Param 2        |
                             |----------------|
                             .                .
                             .                .
                             .                .
                             |----------------|
                             | Param #        |                        <- Ptr
                             |----------------|         +------------+
                             | ProcSym | Type |         | ReturnVar  |
                             |----------------|         |------------|

*/

static void BuildPseudoFunctionCall (bool ConstExpr)
{
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  ProcSym = PCSymBuild_SkipConst (ProcSym);
  M2Quads_PushT (NoOfParam);
  /* Compile time stack restored to entry state.  */
  if (ProcSym == M2Base_High)
    {
      BuildHighFunction ();
    }
  else if (ProcSym == M2Base_LengthS)
    {
      /* avoid dangling else.  */
      BuildLengthFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2System_Adr)
    {
      /* avoid dangling else.  */
      BuildAdrFunction ();
    }
  else if (ProcSym == M2Size_Size)
    {
      /* avoid dangling else.  */
      BuildSizeFunction ();
    }
  else if (ProcSym == M2System_TSize)
    {
      /* avoid dangling else.  */
      BuildTSizeFunction ();
    }
  else if (ProcSym == M2System_TBitSize)
    {
      /* avoid dangling else.  */
      BuildTBitSizeFunction ();
    }
  else if (ProcSym == M2Base_Convert)
    {
      /* avoid dangling else.  */
      BuildConvertFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Odd)
    {
      /* avoid dangling else.  */
      BuildOddFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Abs)
    {
      /* avoid dangling else.  */
      BuildAbsFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Cap)
    {
      /* avoid dangling else.  */
      BuildCapFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Val)
    {
      /* avoid dangling else.  */
      BuildValFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Chr)
    {
      /* avoid dangling else.  */
      BuildChrFunction (ProcSym, ConstExpr);
    }
  else if (M2Base_IsOrd (ProcSym))
    {
      /* avoid dangling else.  */
      BuildOrdFunction (ProcSym, ConstExpr);
    }
  else if (M2Base_IsInt (ProcSym))
    {
      /* avoid dangling else.  */
      BuildIntFunction (ProcSym, ConstExpr);
    }
  else if (M2Base_IsTrunc (ProcSym))
    {
      /* avoid dangling else.  */
      BuildTruncFunction (ProcSym, ConstExpr);
    }
  else if (M2Base_IsFloat (ProcSym))
    {
      /* avoid dangling else.  */
      BuildFloatFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Min)
    {
      /* avoid dangling else.  */
      BuildMinFunction ();
    }
  else if (ProcSym == M2Base_Max)
    {
      /* avoid dangling else.  */
      BuildMaxFunction ();
    }
  else if (ProcSym == M2System_AddAdr)
    {
      /* avoid dangling else.  */
      BuildAddAdrFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2System_SubAdr)
    {
      /* avoid dangling else.  */
      BuildSubAdrFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2System_DifAdr)
    {
      /* avoid dangling else.  */
      BuildDifAdrFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2System_Cast)
    {
      /* avoid dangling else.  */
      BuildCastFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2System_Shift)
    {
      /* avoid dangling else.  */
      BuildShiftFunction ();
    }
  else if (ProcSym == M2System_Rotate)
    {
      /* avoid dangling else.  */
      BuildRotateFunction ();
    }
  else if (ProcSym == M2System_MakeAdr)
    {
      /* avoid dangling else.  */
      BuildMakeAdrFunction ();
    }
  else if (ProcSym == M2Base_Re)
    {
      /* avoid dangling else.  */
      BuildReFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Im)
    {
      /* avoid dangling else.  */
      BuildImFunction (ProcSym, ConstExpr);
    }
  else if (ProcSym == M2Base_Cmplx)
    {
      /* avoid dangling else.  */
      BuildCmplxFunction (ProcSym, ConstExpr);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "pseudo function not implemented yet", 35);
    }
}


/*
   BuildAddAdrFunction - builds the pseudo procedure call ADDADR.

                         PROCEDURE ADDADR (addr: ADDRESS; offset: CARDINAL): ADDRESS ;

                         Which returns address given by (addr + offset),
                         [ the standard says that it _may_
                           "raise an exception if this address is not valid."
                           currently we do not generate any exception code ]

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildAddAdrFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int vartok;
  unsigned int optok;
  unsigned int opa;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int OperandSym;
  unsigned int VarSym;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam == 2)
    {
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (2));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (2));
      OperandSym = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
      M2Quads_PopN (NoOfParam+1);
      if ((ConstExprError (ProcSym, VarSym, vartok, ConstExpr)) || (ConstExprError (ProcSym, OperandSym, optok, ConstExpr)))
        {
          /* Fake return result.  */
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, combinedtok);
        }
      else if (SymbolTable_IsVar (VarSym))
        {
          /* avoid dangling else.  */
          if ((IsReallyPointer (VarSym)) || ((SymbolTable_GetSType (VarSym)) == M2System_Address))
            {
              ReturnVar = SymbolTable_MakeTemporary (combinedtok, SymbolTable_RightValue);
              SymbolTable_PutVar (ReturnVar, M2System_Address);
              opa = ConvertToAddress (optok, DereferenceLValue (optok, OperandSym));
              GenQuadOtok (combinedtok, M2Quads_AddOp, ReturnVar, VarSym, opa, true, combinedtok, combinedtok, combinedtok);
              M2Quads_PushTFtok (ReturnVar, M2System_Address, combinedtok);
            }
          else
            {
              M2MetaError_MetaErrorT1 (functok, (const char *) "the first parameter to ADDADR {%1Ea} must be a variable of type ADDRESS or a {%EkPOINTER}, rather than a {%1Etsd}", 113, VarSym);
              M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, combinedtok);
            }
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}SYSTEM procedure ADDADR expects a variable of type ADDRESS or POINTER as its first parameter", 96);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, combinedtok);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}SYSTEM procedure {%EkADDADR} expects 2 parameters", 53);
      M2Quads_PopN (NoOfParam+1);
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, functok);
    }
}


/*
   BuildSubAdrFunction - builds the pseudo procedure call ADDADR.

                         PROCEDURE SUBADR (addr: ADDRESS; offset: CARDINAL): ADDRESS ;

                         Which returns address given by (addr - offset),
                         [ the standard says that it _may_
                           "raise an exception if this address is not valid."
                           currently we do not generate any exception code ]

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildSubAdrFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int functok;
  unsigned int combinedtok;
  unsigned int optok;
  unsigned int vartok;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int OperandSym;
  unsigned int opa;
  unsigned int VarSym;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam == 2)
    {
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      OperandSym = static_cast<unsigned int> (M2Quads_OperandT (1));
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (2));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (2));
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, optok);
      M2Quads_PopN (NoOfParam+1);
      if ((ConstExprError (ProcSym, VarSym, vartok, ConstExpr)) || (ConstExprError (ProcSym, OperandSym, optok, ConstExpr)))
        {
          /* Fake return result.  */
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, combinedtok);
        }
      else if (SymbolTable_IsVar (VarSym))
        {
          /* avoid dangling else.  */
          if ((IsReallyPointer (VarSym)) || ((SymbolTable_GetSType (VarSym)) == M2System_Address))
            {
              ReturnVar = SymbolTable_MakeTemporary (combinedtok, SymbolTable_RightValue);
              SymbolTable_PutVar (ReturnVar, M2System_Address);
              opa = ConvertToAddress (optok, DereferenceLValue (optok, OperandSym));
              GenQuadOtok (combinedtok, M2Quads_SubOp, ReturnVar, VarSym, opa, true, combinedtok, combinedtok, combinedtok);
              M2Quads_PushTFtok (ReturnVar, M2System_Address, combinedtok);
            }
          else
            {
              M2MetaError_MetaErrorT1 (functok, (const char *) "the first parameter to {%EkSUBADR} {%1Ea} must be a variable of type ADDRESS or a {%EkPOINTER}, rather than a {%1Etsd}", 118, VarSym);
              M2Quads_PushTFtok (SymbolTable_MakeConstLit (vartok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, vartok);
            }
        }
      else
        {
          /* avoid dangling else.  */
          combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, optok);
          M2MetaError_MetaErrorT0 (combinedtok, (const char *) "{%E}SYSTEM procedure {%EkSUBADR} expects a variable of type ADDRESS or POINTER as its first parameter", 101);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, combinedtok);
        }
    }
  else
    {
      M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}SYSTEM procedure {%EkSUBADR} expects 2 parameters", 53);
      M2Quads_PopN (NoOfParam+1);
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2System_Address), M2System_Address, functok);
    }
}


/*
   BuildDifAdrFunction - builds the pseudo procedure call DIFADR.

                         PROCEDURE DIFADR (addr1, addr2: ADDRESS): INTEGER ;

                         Which returns address given by (addr1 - addr2),
                         [ the standard says that it _may_
                           "raise an exception if this address is invalid or
                            address space is non-contiguous."
                           currently we do not generate any exception code ]

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildDifAdrFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int functok;
  unsigned int optok;
  unsigned int vartok;
  unsigned int combinedtok;
  unsigned int TempVar;
  unsigned int NoOfParam;
  unsigned int OperandSym;
  unsigned int opa;
  unsigned int VarSym;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam >= 1)
    {
      OperandSym = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
    }
  else
    {
      optok = functok;
    }
  if (NoOfParam == 2)
    {
      VarSym = static_cast<unsigned int> (M2Quads_OperandT (2));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (2));
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, optok);
      M2Quads_PopN (NoOfParam+1);
      if ((ConstExprError (ProcSym, VarSym, vartok, ConstExpr)) || (ConstExprError (ProcSym, OperandSym, optok, ConstExpr)))
        {
          /* Fake return result.  */
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Integer), M2Base_Integer, combinedtok);
        }
      else if (SymbolTable_IsVar (VarSym))
        {
          /* avoid dangling else.  */
          if ((IsReallyPointer (VarSym)) || ((SymbolTable_GetSType (VarSym)) == M2System_Address))
            {
              if ((IsReallyPointer (OperandSym)) || ((SymbolTable_GetSType (OperandSym)) == M2System_Address))
                {
                  TempVar = SymbolTable_MakeTemporary (vartok, SymbolTable_RightValue);
                  SymbolTable_PutVar (TempVar, M2System_Address);
                  opa = ConvertToAddress (optok, DereferenceLValue (optok, OperandSym));
                  GenQuadOtok (combinedtok, M2Quads_SubOp, TempVar, VarSym, opa, true, combinedtok, combinedtok, combinedtok);
                  /* 
                  Build macro: CONVERT( INTEGER, TempVar )
  */
                  M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), functok);
                  M2Quads_PushTtok (M2Base_Integer, functok);
                  M2Quads_PushTtok (TempVar, vartok);
                  M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
                  BuildConvertFunction (M2Base_Convert, ConstExpr);  /* Two parameters  */
                }
              else
                {
                  M2MetaError_MetaError1 ((const char *) "the second parameter to {%EkDIFADR} {%1Ea} must be a variable of type ADDRESS or a {%EkPOINTER}, rather than a {%1Etsd}", 119, OperandSym);
                  M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Integer), M2Base_Integer, combinedtok);
                }
            }
          else
            {
              M2MetaError_MetaErrorT1 (vartok, (const char *) "the first parameter to {%EkDIFADR} {%1Ea} must be a variable of type ADDRESS or a {%EkPOINTER}, rather than a {%1Etsd}", 118, VarSym);
              M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Integer), M2Base_Integer, combinedtok);
            }
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError0 ((const char *) "{%E}SYSTEM procedure {%EkDIFADR} expects a variable of type ADDRESS or POINTER as its first parameter", 101);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Integer), M2Base_Integer, combinedtok);
        }
    }
  else
    {
      combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
      M2MetaError_MetaErrorT0 (combinedtok, (const char *) "{%E}SYSTEM procedure {%EkDIFADR} expects 2 parameters", 53);
      M2Quads_PopN (NoOfParam+1);
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Integer), M2Base_Integer, combinedtok);
    }
}


/*
   BuildHighFunction - checks the stack in preparation for generating
                       quadruples which perform HIGH.
                       This procedure does not alter the stack but
                       determines whether, a, in HIGH(a) is an ArraySym
                       or UnboundedSym.
                       Both cases are different and appropriate quadruple
                       generating routines are called.

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|

*/

static void BuildHighFunction (void)
{
  unsigned int functok;
  unsigned int combinedtok;
  unsigned int paramtok;
  unsigned int ProcSym;
  unsigned int Type;
  unsigned int NoOfParam;
  unsigned int Param;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  BuildSizeCheckEnd (ProcSym);  /* quadruple generation now on  */
  if (NoOfParam == 1)  /* quadruple generation now on  */
    {
      Param = static_cast<unsigned int> (M2Quads_OperandT (1));
      paramtok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      combinedtok = M2LexBuf_MakeVirtualTok (paramtok, functok, paramtok);
      Type = SymbolTable_GetDType (Param);
      /* Restore stack to original form  */
      M2Quads_PushT (NoOfParam);
      if (((! (SymbolTable_IsVar (Param))) && (! (SymbolTable_IsConstString (Param)))) && (! (SymbolTable_IsConst (Param))))
        {
          /* we cannot test for IsConst(Param) AND (GetSType(Param)=Char)  as the type might not be assigned yet  */
          M2MetaError_MetaError1 ((const char *) "base procedure {%EkHIGH} expects a variable or string constant as its parameter {%1d:rather than {%1d}} {%1asa}", 111, Param);
        }
      else if ((Type != SymbolTable_NulSym) && (SymbolTable_IsUnbounded (Type)))
        {
          /* avoid dangling else.  */
          BuildHighFromUnbounded (combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          BuildConstHighFromSym (combinedtok);
        }
    }
  else
    {
      M2MetaError_MetaError0 ((const char *) "base procedure {%EkHIGH} requires one parameter", 47);
      M2Quads_PopN (2);
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal), M2Base_Cardinal, functok);
    }
}


/*
   BuildConstHighFromSym - builds the pseudo function HIGH from an Sym.
                           Sym is a constant or an array which has constant bounds
                           and therefore it can be calculated at compile time.

                           The Stack:


                           Entry                      Exit

                   Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |                        <- Ptr
                           |----------------|         +------------+
                           | ProcSym | Type |         | ReturnVar  |
                           |----------------|         |------------|
*/

static void BuildConstHighFromSym (unsigned int tok)
{
  unsigned int NoOfParam;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  ReturnVar = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
  SymbolTable_PutConst (ReturnVar, M2Base_Cardinal);
  GenHigh (tok, ReturnVar, 1, M2Quads_OperandT (1));
  M2Quads_PopN (NoOfParam+1);
  M2Quads_PushTtok (ReturnVar, tok);
}


/*
   BuildHighFromUnbounded - builds the pseudo function HIGH from an
                            UnboundedSym.

                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param #        |                        <- Ptr
                            |----------------|         +------------+
                            | ProcSym | Type |         | ReturnVar  |
                            |----------------|         |------------|

*/

static void BuildHighFromUnbounded (unsigned int tok)
{
  unsigned int Dim;
  unsigned int NoOfParam;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  M2Debug_Assert (NoOfParam == 1);
  ReturnVar = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
  SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
  Dim = static_cast<unsigned int> (OperandD (1));
  Dim += 1;
  if (Dim > 1)
    {
      GenHigh (tok, ReturnVar, Dim, M2Quads_OperandA (1));
    }
  else
    {
      GenHigh (tok, ReturnVar, Dim, M2Quads_OperandT (1));
    }
  M2Quads_PopN (2);
  M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (ReturnVar), tok);
}


/*
   GetQualidentImport - returns the symbol as if it were qualified from, module.n.
                        This is used to reference runtime support procedures and an
                        error is generated if the symbol cannot be obtained.
*/

static unsigned int GetQualidentImport (unsigned int tokno, NameKey_Name n, NameKey_Name module)
{
  unsigned int ModSym;

  ModSym = M2Batch_MakeDefinitionSource (tokno, module);
  if (ModSym == SymbolTable_NulSym)
    {
      M2MetaError_MetaErrorNT2 (tokno, (const char *) "module %a cannot be found and is needed to import %a", 52, module, n);
      M2Error_FlushErrors ();
      return SymbolTable_NulSym;
    }
  M2Debug_Assert (SymbolTable_IsDefImp (ModSym));
  if (((SymbolTable_GetExported (tokno, ModSym, n)) == SymbolTable_NulSym) || (SymbolTable_IsUnknown (SymbolTable_GetExported (tokno, ModSym, n))))
    {
      M2MetaError_MetaErrorN2 ((const char *) "module %a does not export procedure %a which is a necessary component of the runtime system, hint check the path and library/language variant", 141, module, n);
      M2Error_FlushErrors ();
      return SymbolTable_NulSym;
    }
  return SymbolTable_GetExported (tokno, M2Batch_MakeDefinitionSource (tokno, module), n);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConstExprError - return TRUE if a constant expression is being built and Var is a variable.
*/

static bool ConstExprError (unsigned int Func, unsigned int Var, unsigned int optok, bool ConstExpr)
{
  if (ConstExpr && (SymbolTable_IsVar (Var)))
    {
      M2MetaError_MetaErrorT2 (optok, (const char *) "the procedure function {%1Ea} is being called from within a constant expression and therefore the parameter {%2a} must be a constant, seen a {%2da}", 147, Func, Var);
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeferMakeLengthConst - creates a constant which contains the length of string, sym.
*/

static unsigned int DeferMakeLengthConst (unsigned int tok, unsigned int sym)
{
  unsigned int const_;

  const_ = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
  SymbolTable_PutVar (const_, M2Base_ZType);
  GenQuadO (tok, M2Quads_StringLengthOp, const_, 0, sym, false);
  return const_;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildLengthFunction - builds the inline standard function LENGTH.

                         The Stack:


                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|

*/

static void BuildLengthFunction (unsigned int Function, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int paramtok;
  unsigned int functok;
  unsigned int ProcSym;
  unsigned int Type;
  unsigned int NoOfParam;
  unsigned int Param;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  Param = static_cast<unsigned int> (M2Quads_OperandT (1));
  paramtok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  /* Restore stack to origional form.  */
  M2Quads_PushT (NoOfParam);
  Type = SymbolTable_GetSType (Param);  /* Get the type from the symbol, not the stack.  */
  if (NoOfParam != 1)  /* Get the type from the symbol, not the stack.  */
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "base procedure {%1EkLENGTH} expects 1 parameter, seen {%1n} parameters", 70, NoOfParam);
    }
  if (NoOfParam >= 1)
    {
      combinedtok = M2LexBuf_MakeVirtual2Tok (functok, paramtok);
      if ((SymbolTable_IsConst (Param)) && ((SymbolTable_GetSType (Param)) == M2Base_Char))
        {
          M2Quads_PopT (&NoOfParam);
          M2Quads_PopN (NoOfParam+1);
          ReturnVar = SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "1", 1), M2Base_Cardinal);
          M2Quads_PushTtok (ReturnVar, combinedtok);
        }
      else if (SymbolTable_IsConstString (Param))
        {
          /* avoid dangling else.  */
          M2Quads_PopT (&NoOfParam);
          ReturnVar = DeferMakeLengthConst (combinedtok, M2Quads_OperandT (1));
          M2Quads_PopN (NoOfParam+1);
          M2Quads_PushTtok (ReturnVar, combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          ProcSym = GetQualidentImport (functok, NameKey_MakeKey ((const char *) "Length", 6), NameKey_MakeKey ((const char *) "M2RTS", 5));
          if ((ProcSym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (ProcSym)))
            {
              M2Quads_PopT (&NoOfParam);
              if (SymbolTable_IsConst (Param))
                {
                  /* This can be folded in M2GenGCC.  */
                  ReturnVar = SymbolTable_MakeTemporary (combinedtok, SymbolTable_ImmediateValue);
                  SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
                  GenQuad (M2Quads_StandardFunctionOp, ReturnVar, ProcSym, Param);
                  M2Quads_PopN (NoOfParam+1);
                  M2Quads_PushTtok (ReturnVar, combinedtok);
                }
              else if (ConstExprError (Function, Param, paramtok, ConstExpr))
                {
                  /* avoid dangling else.  */
                  /* Fake a result as we have detected and reported an error.  */
                  M2Quads_PopN (NoOfParam+1);
                  ReturnVar = SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "1", 1), M2Base_Cardinal);
                  M2Quads_PushTtok (ReturnVar, combinedtok);
                }
              else
                {
                  /* avoid dangling else.  */
                  /* We must resolve this at runtime or in the GCC optimizer.  */
                  M2Quads_PopTF (&Param, &Type);
                  M2Quads_PopN (NoOfParam);
                  M2Quads_PushTtok (ProcSym, functok);
                  M2Quads_PushTFtok (Param, Type, paramtok);
                  M2Quads_PushT (NoOfParam);
                  BuildRealFunctionCall (functok, false);
                }
            }
          else
            {
              M2Quads_PopT (&NoOfParam);
              M2Quads_PopN (NoOfParam+1);
              M2Quads_PushTtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal), combinedtok);
              M2MetaError_MetaErrorT0 (functok, (const char *) "no procedure Length found for substitution to the standard function {%1EkLENGTH} which is required to calculate non constant string lengths", 139);
            }
        }
    }
  else
    {
      /* NoOfParam is _very_ wrong, we flush all outstanding errors  */
      M2Error_FlushErrors ();
    }
}


/*
   BuildOddFunction - builds the pseudo procedure call ODD.
                      This procedure is actually a "macro" for
                      ORD(x) --> VAL(BOOLEAN, x MOD 2)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildOddFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int optok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int Res;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, optok);
      if (ConstExprError (ProcSym, Var, optok, ConstExpr))
        {
          /* Nothing to do.  */
          M2Quads_PushTtok (M2Base_False, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          M2Quads_PopN (NoOfParam+1);
          /* compute (x MOD 2)  */
          M2Quads_PushTFtok (Var, SymbolTable_GetSType (Var), optok);
          M2Quads_PushT (M2Reserved_ModTok);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (optok, NameKey_MakeKey ((const char *) "2", 1), M2Base_ZType), M2Base_ZType, optok);
          M2Quads_BuildBinaryOp ();
          M2Quads_PopT (&Res);
          /* compute IF ...=0  */
          M2Quads_PushTtok (Res, optok);
          M2Quads_PushT (M2Reserved_EqualTok);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (optok, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType), M2Base_ZType, optok);
          M2Quads_BuildRelOp (combinedtok);
          M2Quads_BuildThenIf ();
          Res = SymbolTable_MakeTemporary (combinedtok, SymbolTable_RightValue);
          SymbolTable_PutVar (Res, M2Base_Boolean);
          M2Quads_PushTtok (Res, combinedtok);
          M2Quads_PushTtok (M2Base_False, combinedtok);
          M2Quads_BuildAssignment (combinedtok);
          M2Quads_BuildElse ();
          M2Quads_PushTtok (Res, combinedtok);
          M2Quads_PushTtok (M2Base_True, combinedtok);
          M2Quads_BuildAssignment (combinedtok);
          M2Quads_BuildEndIf ();
          M2Quads_PushTtok (Res, combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (optok, (const char *) "the parameter to {%1EkODD} must be a variable or constant, seen {%1ad}", 70, Var);
          M2Quads_PushTtok (M2Base_False, combinedtok);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo procedure {%E1kODD} only has one parameter, seen {%1n} parameters", 76, NoOfParam);
      M2Quads_PushTtok (M2Base_False, functok);
    }
}


/*
   BuildAbsFunction - builds a call to the standard function ABS.

                      We cannot implement it as a macro or inline an
                      IF THEN statement as the IF THEN ELSE requires
                      we write the value to the same variable (or constant)
                      twice. The macro implementation will fail as
                      the compiler maybe building a function
                      call and expecting a ReturnVar on the stack.
                      The only method to implement this is to pass it to the
                      gcc backend.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildAbsFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int vartok;
  unsigned int functok;
  unsigned int combinedtok;
  unsigned int NoOfParam;
  unsigned int Res;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, vartok);
      if (ConstExprError (ProcSym, Var, vartok, ConstExpr))
        {
          /* Create fake result.  */
          Res = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (Res, SymbolTable_GetSType (Var));
          M2Quads_PushTFtok (Res, SymbolTable_GetSType (Var), combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          Res = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (Res, SymbolTable_GetSType (Var));
          GenQuadO (combinedtok, M2Quads_StandardFunctionOp, Res, ProcSym, Var, false);
          M2Quads_PushTFtok (Res, SymbolTable_GetSType (Var), combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (vartok, (const char *) "the parameter to {%AkABS} must be a variable or constant, seen {%1ad}", 69, Var);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo procedure {%AkABS} only has one parameter, seen {%1n} parameters", 75, NoOfParam);
    }
}


/*
   BuildCapFunction - builds the pseudo procedure call CAP.
                      We generate a the following quad:


                      StandardFunctionOp  ReturnVal  Cap  Param1

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam = 1  |
                      |----------------|
                      | Param 1        |
                      |----------------|         +-------------+
                      | ProcSym | Type |         | ReturnVal   |
                      |----------------|         |-------------|
*/

static void BuildCapFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int optok;
  unsigned int functok;
  unsigned int combinedtok;
  unsigned int NoOfParam;
  unsigned int Res;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);
      if (ConstExprError (ProcSym, Var, optok, ConstExpr))
        {
          /* Create fake result.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
          Res = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (Res, M2Base_Char);
          M2Quads_PushTFtok (Res, M2Base_Char, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
          Res = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (Res, M2Base_Char);
          GenQuadO (combinedtok, M2Quads_StandardFunctionOp, Res, ProcSym, Var, false);
          M2Quads_PushTFtok (Res, M2Base_Char, combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (optok, (const char *) "the parameter to {%AkCAP} must be a variable or constant, seen {%1ad}", 69, Var);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo procedure {%AkCAP} only has one parameter, seen {%1n} parameters", 75, NoOfParam);
    }
}


/*
   BuildChrFunction - builds the pseudo procedure call CHR.
                      This procedure is actually a "macro" for
                      CHR(x) --> CONVERT(CHAR, x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildChrFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int functok;
  unsigned int combinedtok;
  unsigned int optok;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);
      if (ConstExprError (ProcSym, Var, optok, ConstExpr))
        {
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, M2Base_Char);
          M2Quads_PushTFtok (ReturnVar, M2Base_Char, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          /* 
            Build macro: CONVERT( CHAR, Var )
  */
          M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), functok);
          M2Quads_PushTtok (M2Base_Char, functok);
          M2Quads_PushTtok (Var, optok);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, ConstExpr);  /* Two parameters  */
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (optok, (const char *) "the parameter to {%AkCHR} must be a variable or constant, seen {%1ad}", 69, Var);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo procedure {%AkCHR} only has one parameter, seen {%1n} parameters", 75, NoOfParam);
    }
}


/*
   BuildOrdFunction - builds the pseudo procedure call ORD.
                      This procedure is actually a "macro" for
                      ORD(x) --> CONVERT(GetSType(sym), x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildOrdFunction (unsigned int Sym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int optok;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int Type;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);
      if (ConstExprError (Sym, Var, optok, ConstExpr))
        {
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
          M2Quads_PushTFtok (ReturnVar, M2Base_Cardinal, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          Type = SymbolTable_GetSType (Sym);
          /* 
            Build macro: CONVERT( CARDINAL, Var )
  */
          M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), functok);
          M2Quads_PushTtok (Type, optok);
          M2Quads_PushTtok (Var, optok);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, ConstExpr);  /* Two parameters  */
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT2 (optok, (const char *) "the parameter to {%1Aa} must be a variable or constant, seen {%2ad}", 67, Sym, Var);
        }
    }
  else
    {
      M2MetaError_MetaErrorT2 (functok, (const char *) "the pseudo procedure {%1Aa} only has one parameter, seen {%2n} parameters", 73, Sym, NoOfParam);
    }
}


/*
   BuildIntFunction - builds the pseudo procedure call INT.
                      This procedure is actually a "macro" for
                      INT(x) --> CONVERT(INTEGER, x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildIntFunction (unsigned int Sym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int optok;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int Type;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      optok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);
      if (ConstExprError (Sym, Var, optok, ConstExpr))
        {
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, optok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, M2Base_Integer);
          M2Quads_PushTFtok (ReturnVar, M2Base_Integer, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          Type = SymbolTable_GetSType (Sym);  /* return type of function  */
          /* Build macro: CONVERT( CARDINAL, Var ).  */
          M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), functok);
          M2Quads_PushTtok (Type, functok);
          M2Quads_PushTtok (Var, optok);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, ConstExpr);  /* Two parameters  */
        }
      else
        {
          /* avoid dangling else.  */
          combinedtok = M2LexBuf_MakeVirtualTok (functok, optok, optok);
          M2MetaError_MetaErrorT2 (optok, (const char *) "the parameter to {%1Ea} must be a variable or constant, seen {%2ad}", 67, Sym, Var);
          M2Quads_PushTtok (combinedtok, SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType));
        }
    }
  else
    {
      M2MetaError_MetaErrorT2 (functok, (const char *) "the pseudo procedure {%1Ea} only has one parameter, seen {%2n} parameters", 73, Sym, NoOfParam);
      M2Quads_PushTtok (functok, SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2Base_ZType));
    }
}


/*
   BuildMakeAdrFunction - builds the pseudo procedure call MAKEADR.

                          The Stack:


                          Entry                      Exit

                   Ptr ->
                          +----------------+
                          | NoOfParam      |
                          |----------------|
                          | Param 1        |
                          |----------------|
                          | Param 2        |
                          |----------------|
                          .                .
                          .                .
                          .                .
                          |----------------|
                          | Param #        |
                          |----------------|
                          | ProcSym | Type |         Empty
                          |----------------|
*/

static void BuildMakeAdrFunction (void)
{
  unsigned int functok;
  unsigned int starttok;
  unsigned int endtok;
  unsigned int resulttok;
  bool AreConst;
  unsigned int i;
  unsigned int pi;
  unsigned int NoOfParameters;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParameters);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParameters+1));
  if (NoOfParameters > 0)
    {
      starttok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParameters+1));  /* ADR token.  */
      endtok = static_cast<unsigned int> (M2Quads_OperandTok (1));  /* last parameter.  */
      GenQuad (M2Quads_ParamOp, 0, M2System_MakeAdr, M2System_MakeAdr);  /* last parameter.  */
      i = NoOfParameters;
      /* stack index referencing stacked parameter, i  */
      pi = 1;
      while (i > 0)
        {
          GenQuadO (M2Quads_OperandTok (pi), M2Quads_ParamOp, i, M2System_MakeAdr, M2Quads_OperandT (pi), true);
          i -= 1;
          pi += 1;
        }
      AreConst = true;
      i = 1;
      while (i <= NoOfParameters)
        {
          if (SymbolTable_IsVar (M2Quads_OperandT (i)))
            {
              AreConst = false;
            }
          else if (! (SymbolTable_IsConst (M2Quads_OperandT (i))))
            {
              /* avoid dangling else.  */
              M2MetaError_MetaError1 ((const char *) "problem in the {%1EN} argument for {%kMAKEADR}, all arguments to {%kMAKEADR} must be either variables or constants", 114, i);
            }
          i += 1;
        }
      /* ReturnVar - will have the type of the procedure  */
      resulttok = M2LexBuf_MakeVirtualTok (starttok, starttok, endtok);
      ReturnVar = SymbolTable_MakeTemporary (resulttok, AreConstant (AreConst));
      SymbolTable_PutVar (ReturnVar, SymbolTable_GetSType (M2System_MakeAdr));
      GenQuadO (resulttok, M2Quads_FunctValueOp, ReturnVar, SymbolTable_NulSym, M2System_MakeAdr, true);
      M2Quads_PopN (NoOfParameters+1);
      M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (M2System_MakeAdr), resulttok);
    }
  else
    {
      M2MetaError_MetaError1 ((const char *) "the pseudo procedure {%EkMAKEADR} requires at least one parameter, seen {%1n}", 77, NoOfParameters);
      M2Quads_PopN (1);
      M2Quads_PushTFtok (M2Base_Nil, SymbolTable_GetSType (M2System_MakeAdr), functok);
    }
}


/*
   BuildShiftFunction - builds the pseudo procedure call SHIFT.

                        PROCEDURE SHIFT (val: <any type>;
                                         num: INTEGER): <any type> ;

                       "Returns a bit sequence obtained from val by
                        shifting up or down (left or right) by the
                        absolute value of num, introducing
                        zeros as necessary.  The direction is down if
                        the sign of num is negative, otherwise the
                        direction is up."

                        The Stack:

                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |                        <- Ptr
                        |----------------|         +------------+
                        | ProcSym | Type |         | ReturnVar  |
                        |----------------|         |------------|
*/

static void BuildShiftFunction (void)
{
  unsigned int combinedtok;
  unsigned int paramtok;
  unsigned int functok;
  unsigned int vartok;
  unsigned int exptok;
  unsigned int r;
  unsigned int procSym;
  unsigned int returnVar;
  unsigned int NoOfParam;
  unsigned int derefExp;
  unsigned int Exp;
  unsigned int varSet;

  M2Quads_PopT (&NoOfParam);
  paramtok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 2)
    {
      PopTrwtok (&Exp, &r, &exptok);
      MarkAsRead (r);
      M2Quads_PopTtok (&varSet, &vartok);
      M2Quads_PopT (&procSym);
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, exptok);
      if (((SymbolTable_GetSType (varSet)) != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_GetDType (varSet))))
        {
          derefExp = DereferenceLValue (exptok, Exp);
          BuildRange (M2Range_InitShiftCheck (varSet, derefExp));
          returnVar = SymbolTable_MakeTemporary (combinedtok, SymbolTable_RightValue);
          SymbolTable_PutVar (returnVar, SymbolTable_GetSType (varSet));
          GenQuadO (combinedtok, M2Quads_LogicalShiftOp, returnVar, varSet, derefExp, true);
          M2Quads_PushTFtok (returnVar, SymbolTable_GetSType (varSet), combinedtok);
        }
      else
        {
          M2MetaError_MetaErrorT1 (vartok, (const char *) "SYSTEM procedure {%1EkSHIFT} expects a constant or variable which has a type of SET as its first parameter, seen {%1ad}", 119, varSet);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal), M2Base_Cardinal, combinedtok);
        }
    }
  else
    {
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo procedure {%kSHIFT} requires at least two parameters, seen {%1En}", 76, NoOfParam);
      M2Quads_PopN (NoOfParam+1);
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal), M2Base_Cardinal, combinedtok);
    }
}


/*
   BuildRotateFunction - builds the pseudo procedure call ROTATE.

                         PROCEDURE ROTATE (val: <any type>;
                                           num: INTEGER): <any type> ;

                        "Returns a bit sequence obtained from val
                         by rotating up or down (left or right) by
                         the absolute value of num.  The direction is
                         down if the sign of num is negative, otherwise
                         the direction is up."

                         The Stack:

                         Entry                      Exit

                  Ptr ->
                         +----------------+
                         | NoOfParam      |
                         |----------------|
                         | Param 1        |
                         |----------------|
                         | Param 2        |                        <- Ptr
                         |----------------|         +------------+
                         | ProcSym | Type |         | ReturnVar  |
                         |----------------|         |------------|
*/

static void BuildRotateFunction (void)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int vartok;
  unsigned int exptok;
  unsigned int r;
  unsigned int procSym;
  unsigned int returnVar;
  unsigned int NoOfParam;
  unsigned int derefExp;
  unsigned int Exp;
  unsigned int varSet;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 2)
    {
      PopTrwtok (&Exp, &r, &exptok);
      MarkAsRead (r);
      M2Quads_PopTtok (&varSet, &vartok);
      M2Quads_PopT (&procSym);
      if (((SymbolTable_GetSType (varSet)) != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_GetDType (varSet))))
        {
          combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, exptok);
          derefExp = DereferenceLValue (exptok, Exp);
          BuildRange (M2Range_InitRotateCheck (varSet, derefExp));
          returnVar = SymbolTable_MakeTemporary (combinedtok, SymbolTable_RightValue);
          SymbolTable_PutVar (returnVar, SymbolTable_GetSType (varSet));
          GenQuadO (combinedtok, M2Quads_LogicalRotateOp, returnVar, varSet, derefExp, true);
          M2Quads_PushTFtok (returnVar, SymbolTable_GetSType (varSet), combinedtok);
        }
      else
        {
          M2MetaError_MetaErrorT1 (vartok, (const char *) "SYSTEM procedure {%EkROTATE} expects a constant or variable which has a type of SET as its first parameter, seen {%1ad}", 119, varSet);
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal), M2Base_Cardinal, functok);
        }
    }
  else
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "SYSTEM procedure {%EkROTATE} expects 2 parameters and was given {%1n} parameters", 80, NoOfParam);
      M2Quads_PopN (NoOfParam+1);
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal), M2Base_Cardinal, functok);
    }
}


/*
   BuildValFunction - builds the pseudo procedure call VAL.
                      This procedure is actually a "macro" for
                      VAL(Type, x) --> CONVERT(Type, x)
                      However we cannot push tokens back onto the input stack
                      because the compiler is currently building a function
                      call and expecting a ReturnVar on the stack.
                      Hence we manipulate the stack and call
                      BuildConvertFunction.

                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildValFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int Exp;
  unsigned int Type;
  unsigned int tok;
  unsigned int r;
  unsigned int typetok;
  unsigned int exptok;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 2)
    {
      PopTrwtok (&Exp, &r, &exptok);
      MarkAsRead (r);
      M2Quads_PopTtok (&Type, &typetok);
      M2Quads_PopTtok (&ProcSym, &tok);
      if (SymbolTable_IsUnknown (Type))
        {
          /* non recoverable error.  */
          M2MetaError_MetaErrorT1 (typetok, (const char *) "undeclared type found in builtin procedure function {%AkVAL} {%1ad}", 67, Type);
        }
      else if (ConstExprError (ProcSym, Exp, exptok, ConstExpr))
        {
          /* avoid dangling else.  */
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, exptok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Exp)));
          SymbolTable_PutVar (ReturnVar, Type);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else if (((((((SymbolTable_IsSet (Type)) || (SymbolTable_IsEnumeration (Type))) || (SymbolTable_IsSubrange (Type))) || (SymbolTable_IsType (Type))) || (SymbolTable_IsPointer (Type))) || (SymbolTable_IsProcType (Type))) && (((SymbolTable_IsVar (Exp)) || (SymbolTable_IsConst (Exp))) || (SymbolTable_IsProcedure (Exp))))
        {
          /* avoid dangling else.  */
          /* 
            Build macro: CONVERT( Type, Var )
  */
          M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), tok);
          M2Quads_PushTtok (Type, typetok);
          M2Quads_PushTtok (Exp, exptok);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, ConstExpr);
        }
      else
        {
          /* avoid dangling else.  */
          /* non recoverable error.  */
          M2MetaError_MetaErrorT0 (functok, (const char *) "the builtin procedure {%AkVAL} has the following formal parameter declaration {%kVAL} (type, expression)", 104);
        }
    }
  else
    {
      /* non recoverable error.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the builtin procedure {%AkVAL} expects 2 parameters, a type and an expression, but was given {%1n} parameters", 109, NoOfParam);
    }
}


/*
   BuildCastFunction - builds the pseudo procedure call CAST.
                       This procedure is actually a "macro" for
                       CAST(Type, x) --> Type(x)
                       However we cannot push tokens back onto the input stack
                       because the compiler is currently building a function
                       call and expecting a ReturnVar on the stack.
                       Hence we manipulate the stack and call
                       BuildConvertFunction.

                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |
                       |----------------|
                       | ProcSym | Type |         Empty
                       |----------------|
*/

static void BuildCastFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int exptok;
  unsigned int typetok;
  unsigned int functok;
  unsigned int ReturnVar;
  unsigned int NoOfParam;
  unsigned int Exp;
  unsigned int Type;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 2)
    {
      Type = static_cast<unsigned int> (M2Quads_OperandT (2));
      typetok = static_cast<unsigned int> (M2Quads_OperandTok (2));
      Exp = static_cast<unsigned int> (M2Quads_OperandT (1));
      exptok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      if (SymbolTable_IsUnknown (Type))
        {
          /* non recoverable error.  */
          M2MetaError_MetaErrorT1 (typetok, (const char *) "undeclared type {%1Aad} found in {%kCAST}", 41, Type);
        }
      else if (ConstExprError (ProcSym, Exp, exptok, ConstExpr))
        {
          /* avoid dangling else.  */
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, exptok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Exp)));
          SymbolTable_PutVar (ReturnVar, Type);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else if (((((((SymbolTable_IsSet (Type)) || (SymbolTable_IsEnumeration (Type))) || (SymbolTable_IsSubrange (Type))) || (SymbolTable_IsType (Type))) || (SymbolTable_IsPointer (Type))) || (SymbolTable_IsArray (Type))) || (SymbolTable_IsProcType (Type)))
        {
          /* avoid dangling else.  */
          if (SymbolTable_IsConst (Exp))
            {
              M2Quads_PopN (NoOfParam+1);
              /* 
               Build macro: Type( Var )
  */
              M2Quads_PushTFtok (Type, static_cast<unsigned int> (SymbolTable_NulSym), typetok);
              M2Quads_PushTtok (Exp, exptok);
              M2Quads_PushT (static_cast<unsigned int> (1));  /* one parameter  */
              BuildTypeCoercion (ConstExpr);  /* one parameter  */
            }
          else if ((SymbolTable_IsVar (Exp)) || (SymbolTable_IsProcedure (Exp)))
            {
              /* avoid dangling else.  */
              M2Quads_PopN (NoOfParam+1);
              combinedtok = M2LexBuf_MakeVirtual2Tok (functok, exptok);
              ReturnVar = SymbolTable_MakeTemporary (combinedtok, SymbolTable_RightValue);
              SymbolTable_PutVar (ReturnVar, Type);
              GenQuadO (combinedtok, M2Quads_CastOp, ReturnVar, Type, Exp, false);
              M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
            }
          else
            {
              /* avoid dangling else.  */
              /* non recoverable error.  */
              M2MetaError_MetaErrorT0 (functok, (const char *) "the second parameter to the builtin procedure {%AkCAST} must either be a variable, constant or a procedure.  The formal parameters to cast are {%kCAST} (type, variable or constant or procedure)", 193);
            }
        }
      else
        {
          /* avoid dangling else.  */
          /* non recoverable error.  */
          M2MetaError_MetaErrorT0 (functok, (const char *) "the builtin procedure {%AkCAST} has the following formal parameter declaration {%kCAST} (type, expression)", 106);
        }
    }
  else
    {
      /* non recoverable error.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the builtin procedure {%AkCAST} `expects 2 parameters, a type and an expression, but was given {%1n} parameters", 111, NoOfParam);
    }
}


/*
   BuildConvertFunction - builds the pseudo function CONVERT.
                          CONVERT( Type, Variable ) ;

                          The Stack:


                          Entry                      Exit

                   Ptr ->
                          +----------------+
                          | NoOfParam      |
                          |----------------|
                          | Param 1        |
                          |----------------|
                          | Param 2        |
                          |----------------|
                          .                .
                          .                .
                          .                .
                          |----------------|
                          | Param #        |                                 <- Ptr
                          |----------------|         +---------------------+
                          | ProcSym | Type |         | ReturnVar | Param1  |
                          |----------------|         |---------------------|

                          Quadruples:

                          ConvertOp  ReturnVar  Param1  Param2

                          Converts variable Param2 into a variable Param1
                          with a type Param1.
*/

static void BuildConvertFunction (unsigned int ProcSym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int typetok;
  unsigned int exptok;
  unsigned int t;
  unsigned int r;
  unsigned int Exp;
  unsigned int Type;
  unsigned int NoOfParam;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  functok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfParam+1));
  if (NoOfParam == 2)
    {
      PopTrwtok (&Exp, &r, &exptok);
      MarkAsRead (r);
      M2Quads_PopTtok (&Type, &typetok);
      M2Quads_PopT (&ProcSym);
      if (SymbolTable_IsUnknown (Type))
        {
          /* non recoverable error.  */
          M2MetaError_MetaErrorT1 (typetok, (const char *) "undeclared type {%1Aad} found in {%kCONVERT}", 44, Type);
        }
      else if (SymbolTable_IsUnknown (Exp))
        {
          /* avoid dangling else.  */
          /* non recoverable error.  */
          M2MetaError_MetaErrorT1 (typetok, (const char *) "unknown {%1Ad} {%1ad} found in {%kCONVERT}", 42, Exp);
        }
      else if (ConstExprError (ProcSym, Exp, exptok, ConstExpr))
        {
          /* avoid dangling else.  */
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, exptok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Exp)));
          SymbolTable_PutVar (ReturnVar, Type);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else if ((((((((SymbolTable_IsSet (Type)) || (SymbolTable_IsEnumeration (Type))) || (SymbolTable_IsSubrange (Type))) || (SymbolTable_IsType (Type))) || (SymbolTable_IsPointer (Type))) || (SymbolTable_IsProcType (Type))) || (SymbolTable_IsRecord (Type))) && (((SymbolTable_IsVar (Exp)) || (SymbolTable_IsConst (Exp))) || (SymbolTable_IsProcedure (Exp))))
        {
          /* avoid dangling else.  */
          /* firstly dereference Var  */
          if ((SymbolTable_GetMode (Exp)) == SymbolTable_LeftValue)
            {
              t = SymbolTable_MakeTemporary (exptok, SymbolTable_RightValue);
              SymbolTable_PutVar (t, SymbolTable_GetSType (Exp));
              CheckPointerThroughNil (exptok, Exp);
              doIndrX (exptok, t, Exp);
              Exp = t;
            }
          combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, exptok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Exp)));
          SymbolTable_PutVar (ReturnVar, Type);
          GenQuadO (combinedtok, M2Quads_ConvertOp, ReturnVar, Type, Exp, true);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          /* non recoverable error.  */
          M2MetaError_MetaErrorT0 (functok, (const char *) "the builtin procedure {%AkCONVERT} has the following formal parameter declaration {%kCONVERT} (type, expression)", 112);
        }
    }
  else
    {
      /* non recoverable error.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the builtin procedure {%AkCONVERT} expects 2 parameters, a type and an expression, but was given {%1n} parameters", 113, NoOfParam);
    }
}


/*
   CheckBaseTypeValue - checks to see whether the value, min, really exists.
*/

static unsigned int CheckBaseTypeValue (unsigned int tok, unsigned int type, unsigned int min, unsigned int func)
{
  if (((type == M2Base_Real) || (type == M2Base_LongReal)) || (type == M2Base_ShortReal))
    {
      SymbolTable_PushValue (min);
      if (! (M2ALU_IsValueAndTreeKnown ()))
        {
          M2MetaError_MetaErrorT2 (tok, (const char *) "{%1Ead} ({%2ad}) cannot be calculated at compile time for the target architecture", 81, func, type);
          return SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_RType);
        }
    }
  return min;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeMin - returns the minimium value of type and generate an error
                if this is unavailable.
*/

static unsigned int GetTypeMin (unsigned int tok, unsigned int func, unsigned int type)
{
  unsigned int min;

  min = GetTypeMinLower (tok, func, type);
  if (min == SymbolTable_NulSym)
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "unable to obtain the {%AkMIN} value for type {%1ad}", 51, type);
    }
  return min;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeMinLower - obtain the maximum value for type.
*/

static unsigned int GetTypeMinLower (unsigned int tok, unsigned int func, unsigned int type)
{
  unsigned int min;
  unsigned int max;

  if (SymbolTable_IsSubrange (type))
    {
      min = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
      SymbolTable_PutVar (min, type);
      GenQuad (M2Quads_SubrangeLowOp, min, SymbolTable_NulSym, type);
      return min;
    }
  else if (SymbolTable_IsSet (SymbolTable_SkipType (type)))
    {
      /* avoid dangling else.  */
      return GetTypeMin (tok, func, SymbolTable_GetSType (SymbolTable_SkipType (type)));
    }
  else if ((M2Base_IsBaseType (type)) || (SymbolTable_IsEnumeration (type)))
    {
      /* avoid dangling else.  */
      M2Base_GetBaseTypeMinMax (type, &min, &max);
      min = CheckBaseTypeValue (tok, type, min, func);
      return min;
    }
  else if (M2System_IsSystemType (type))
    {
      /* avoid dangling else.  */
      M2System_GetSystemTypeMinMax (type, &min, &max);
      return min;
    }
  else if ((SymbolTable_GetSType (type)) == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      return SymbolTable_NulSym;
    }
  else
    {
      /* avoid dangling else.  */
      return GetTypeMin (tok, func, SymbolTable_GetSType (type));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeMax - returns the maximum value of type and generate an error
                if this is unavailable.
*/

static unsigned int GetTypeMax (unsigned int tok, unsigned int func, unsigned int type)
{
  unsigned int max;

  max = GetTypeMaxLower (tok, func, type);
  if (max == SymbolTable_NulSym)
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "unable to obtain the {%AkMAX} value for type {%1ad}", 51, type);
    }
  return max;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeMaxLower - obtain the maximum value for type.
*/

static unsigned int GetTypeMaxLower (unsigned int tok, unsigned int func, unsigned int type)
{
  unsigned int min;
  unsigned int max;

  if (SymbolTable_IsSubrange (type))
    {
      max = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
      SymbolTable_PutVar (max, type);
      GenQuad (M2Quads_SubrangeHighOp, max, SymbolTable_NulSym, type);
      return max;
    }
  else if (SymbolTable_IsSet (SymbolTable_SkipType (type)))
    {
      /* avoid dangling else.  */
      return GetTypeMax (tok, func, SymbolTable_GetSType (SymbolTable_SkipType (type)));
    }
  else if ((M2Base_IsBaseType (type)) || (SymbolTable_IsEnumeration (type)))
    {
      /* avoid dangling else.  */
      M2Base_GetBaseTypeMinMax (type, &min, &max);
      min = CheckBaseTypeValue (tok, type, min, func);
      return max;
    }
  else if (M2System_IsSystemType (type))
    {
      /* avoid dangling else.  */
      M2System_GetSystemTypeMinMax (type, &min, &max);
      return max;
    }
  else if ((SymbolTable_GetSType (type)) == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      return SymbolTable_NulSym;
    }
  else
    {
      /* avoid dangling else.  */
      return GetTypeMax (tok, func, SymbolTable_GetSType (type));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildMinFunction - builds the pseudo function call Min.

                      The Stack:

                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam=1    |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildMinFunction (void)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int vartok;
  unsigned int func;
  unsigned int min;
  unsigned int NoOfParam;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  func = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, vartok);  /* destroy arguments to this function  */
      if (SymbolTable_IsAModula2Type (Var))
        {
          min = GetTypeMin (vartok, func, Var);
          M2Quads_PushTFtok (min, SymbolTable_GetSType (min), combinedtok);
        }
      else if (SymbolTable_IsVar (Var))
        {
          /* avoid dangling else.  */
          min = GetTypeMin (vartok, func, SymbolTable_GetSType (Var));
          M2Quads_PushTFtok (min, SymbolTable_GetSType (Var), combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          /* non recoverable error.  */
          M2MetaError_MetaErrorT1 (vartok, (const char *) "parameter to {%AkMIN} must be a type or a variable, seen {%1ad}", 63, Var);
        }
    }
  else
    {
      /* non recoverable error.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo builtin procedure function {%AkMIN} only has one parameter, seen  {%1n}", 82, NoOfParam);
    }
}


/*
   BuildMaxFunction - builds the pseudo function call Max.

                      The Stack:

                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam=1    |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | ProcSym | Type |         Empty
                      |----------------|
*/

static void BuildMaxFunction (void)
{
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int vartok;
  unsigned int func;
  unsigned int max;
  unsigned int NoOfParam;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  func = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, vartok);  /* destroy arguments to this function  */
      if (SymbolTable_IsAModula2Type (Var))
        {
          max = GetTypeMax (vartok, func, Var);
          M2Quads_PushTFtok (max, SymbolTable_GetSType (max), combinedtok);
        }
      else if (SymbolTable_IsVar (Var))
        {
          /* avoid dangling else.  */
          max = GetTypeMax (vartok, func, SymbolTable_GetSType (Var));
          M2Quads_PushTFtok (max, SymbolTable_GetSType (Var), combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          /* non recoverable error.  */
          M2MetaError_MetaErrorT1 (vartok, (const char *) "parameter to {%AkMAX} must be a type or a variable, seen {%1ad}", 63, Var);
        }
    }
  else
    {
      /* non recoverable error.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo builtin procedure function {%AkMAX} only has one parameter, seen {%1n}", 81, NoOfParam);
    }
}


/*
   BuildTruncFunction - builds the pseudo procedure call TRUNC.
                        This procedure is actually a "macro" for
                        TRUNC(x) --> CONVERT(INTEGER, x)
                        However we cannot push tokens back onto the input stack
                        because the compiler is currently building a function
                        call and expecting a ReturnVar on the stack.
                        Hence we manipulate the stack and call
                        BuildConvertFunction.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildTruncFunction (unsigned int Sym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int vartok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ReturnVar;
  unsigned int ProcSym;
  unsigned int Type;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  M2Debug_Assert (M2Base_IsTrunc (M2Quads_OperandT (NoOfParam+1)));
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam == 1)
    {
      ProcSym = SymbolTable_RequestSym (functok, NameKey_MakeKey ((const char *) "CONVERT", 7));
      if ((ProcSym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (ProcSym)))
        {
          Var = static_cast<unsigned int> (M2Quads_OperandT (1));
          vartok = OperandTtok (1);
          Type = SymbolTable_GetSType (Sym);
          M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
          if (ConstExprError (Sym, Var, vartok, ConstExpr))
            {
              /* Generate fake result.  */
              combinedtok = M2LexBuf_MakeVirtual2Tok (functok, vartok);
              ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
              SymbolTable_PutVar (ReturnVar, Type);
              M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
            }
          else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
            {
              /* avoid dangling else.  */
              if (M2Base_IsRealType (SymbolTable_GetSType (Var)))
                {
                  /* build macro: CONVERT( INTEGER, Var ).  */
                  M2Quads_PushTFtok (ProcSym, static_cast<unsigned int> (SymbolTable_NulSym), functok);
                  M2Quads_PushTtok (Type, functok);
                  M2Quads_PushTtok (Var, vartok);
                  M2Quads_PushT (static_cast<unsigned int> (2));  /* two parameters  */
                  BuildConvertFunction (M2Base_Convert, ConstExpr);  /* two parameters  */
                }
              else
                {
                  M2MetaError_MetaErrorT1 (functok, (const char *) "argument to {%1Ead} must be a float point type", 46, Sym);
                  M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), Type), Type, functok);
                }
            }
          else
            {
              /* avoid dangling else.  */
              M2MetaError_MetaErrorT2 (vartok, (const char *) "argument to {%1Ead} must be a variable or constant, seen {%2ad}", 63, Sym, Var);
              M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), Type), Type, functok);
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "CONVERT procedure not found for TRUNC substitution", 50);
        }
    }
  else
    {
      /* non recoverable error.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the pseudo builtin procedure function {%AkTRUNC} only has one parameter, seen  {%1n}", 84, NoOfParam);
    }
}


/*
   BuildFloatFunction - builds the pseudo procedure call FLOAT.
                        This procedure is actually a "macro" for
                        FLOAT(x) --> CONVERT(REAL, x)
                        However we cannot push tokens back onto the input stack
                        because the compiler is currently building a function
                        call and expecting a ReturnVar on the stack.
                        Hence we manipulate the stack and call
                        BuildConvertFunction.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildFloatFunction (unsigned int Sym, bool ConstExpr)
{
  unsigned int combinedtok;
  unsigned int vartok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ReturnVar;
  unsigned int Type;
  unsigned int Var;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  Type = SymbolTable_GetSType (Sym);
  if (NoOfParam == 1)
    {
      ProcSym = SymbolTable_RequestSym (functok, NameKey_MakeKey ((const char *) "CONVERT", 7));
      if ((ProcSym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (ProcSym)))
        {
          Var = static_cast<unsigned int> (M2Quads_OperandT (1));
          vartok = OperandTtok (1);
          M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function.  */
          if (ConstExprError (Sym, Var, vartok, ConstExpr))
            {
              /* Generate fake result.  */
              combinedtok = M2LexBuf_MakeVirtual2Tok (functok, vartok);
              ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
              SymbolTable_PutVar (ReturnVar, Type);
              M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
            }
          else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
            {
              /* avoid dangling else.  */
              /* build macro: CONVERT (REAL, Var).  */
              M2Quads_PushTFtok (ProcSym, static_cast<unsigned int> (SymbolTable_NulSym), functok);
              M2Quads_PushTtok (Type, functok);
              M2Quads_PushTtok (Var, vartok);
              M2Quads_PushT (static_cast<unsigned int> (2));  /* two parameters.  */
              BuildConvertFunction (ProcSym, ConstExpr);  /* two parameters.  */
            }
          else
            {
              /* avoid dangling else.  */
              M2MetaError_MetaErrorT1 (vartok, (const char *) "argument to {%1Ead} must be a variable or constant", 50, ProcSym);
              M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0.0", 3), Type), Type, functok);
            }
        }
      else
        {
          M2Error_InternalError ((const char *) "CONVERT procedure not found for FLOAT substitution", 50);
        }
    }
  else
    {
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function.  */
      M2MetaError_MetaErrorT1 (functok, (const char *) "the builtin procedure function {%1Ead} only has one parameter", 61, Sym);  /* destroy arguments to this function.  */
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0.0", 3), Type), Type, functok);
    }
}


/*
   BuildReFunction - builds the pseudo procedure call RE.

                     The Stack:


                         Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildReFunction (unsigned int Sym, bool ConstExpr)
{
  unsigned int func;
  unsigned int combinedtok;
  unsigned int vartok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ReturnVar;
  unsigned int Type;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  func = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, vartok);
      Type = M2Base_ComplexToScalar (SymbolTable_GetDType (Var));
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      if (ConstExprError (Sym, Var, vartok, ConstExpr))
        {
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, vartok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, Type);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, Type);
          GenQuadO (combinedtok, M2Quads_StandardFunctionOp, ReturnVar, M2Base_Re, Var, false);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_RType), M2Base_RType, combinedtok);
          M2MetaError_MetaErrorT2 (vartok, (const char *) "the parameter to the builtin procedure function {%1Ead} must be a constant or a variable, seen {%2ad}", 101, func, Var);
        }
    }
  else
    {
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_RType), M2Base_RType, functok);  /* destroy arguments to this function  */
      M2MetaError_MetaErrorT2 (functok, (const char *) "the builtin procedure function {%1Ead} only has one parameter, seen {%2n}", 73, func, NoOfParam);
    }
}


/*
   BuildImFunction - builds the pseudo procedure call IM.

                     The Stack:


                         Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildImFunction (unsigned int Sym, bool ConstExpr)
{
  unsigned int func;
  unsigned int combinedtok;
  unsigned int vartok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ReturnVar;
  unsigned int Type;
  unsigned int Var;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  func = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  if (NoOfParam == 1)
    {
      Var = static_cast<unsigned int> (M2Quads_OperandT (1));
      vartok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      Type = M2Base_ComplexToScalar (SymbolTable_GetDType (Var));
      combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, vartok);
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      if (ConstExprError (Sym, Var, vartok, ConstExpr))
        {
          /* Generate fake result.  */
          combinedtok = M2LexBuf_MakeVirtual2Tok (functok, vartok);
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, Type);
          M2Quads_PushTFtok (ReturnVar, Type, combinedtok);
        }
      else if ((SymbolTable_IsVar (Var)) || (SymbolTable_IsConst (Var)))
        {
          /* avoid dangling else.  */
          ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant (SymbolTable_IsConst (Var)));
          SymbolTable_PutVar (ReturnVar, M2Base_ComplexToScalar (SymbolTable_GetDType (Var)));
          GenQuadO (combinedtok, M2Quads_StandardFunctionOp, ReturnVar, M2Base_Im, Var, false);
          M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (ReturnVar), combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_RType), M2Base_RType, combinedtok);
          M2MetaError_MetaErrorT2 (vartok, (const char *) "the parameter to the builtin procedure function {%1Ead} must be a constant or a variable, seen {%2ad}", 101, func, Var);
        }
    }
  else
    {
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_RType), M2Base_RType, functok);  /* destroy arguments to this function  */
      M2MetaError_MetaErrorT2 (functok, (const char *) "the builtin procedure function {%1Ead} only has one parameter, seen {%2n}", 73, func, NoOfParam);
    }
}


/*
   BuildCmplxFunction - builds the pseudo procedure call CMPLX.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

static void BuildCmplxFunction (unsigned int func, bool ConstExpr)
{
  bool failure;
  unsigned int functok;
  unsigned int rtok;
  unsigned int ltok;
  unsigned int combinedtok;
  unsigned int NoOfParam;
  unsigned int type;
  unsigned int ReturnVar;
  unsigned int l;
  unsigned int r;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam == 2)
    {
      l = static_cast<unsigned int> (M2Quads_OperandT (2));
      ltok = OperandTtok (2);
      r = static_cast<unsigned int> (M2Quads_OperandT (1));
      rtok = OperandTtok (1);
      combinedtok = M2LexBuf_MakeVirtual2Tok (functok, rtok);
      M2Quads_PopN (NoOfParam+1);  /* Destroy arguments to this function.  */
      type = M2Base_GetCmplxReturnType (SymbolTable_GetDType (l), SymbolTable_GetDType (r));  /* Destroy arguments to this function.  */
      ReturnVar = SymbolTable_MakeTemporary (combinedtok, AreConstant ((SymbolTable_IsConst (l)) && (SymbolTable_IsConst (r))));
      SymbolTable_PutVar (ReturnVar, type);
      failure = false;
      if (ConstExprError (func, l, ltok, ConstExpr))
        {
          /* ConstExprError has generated an error message we will fall through
            and check the right operand.  */
          failure = true;
        }
      if (ConstExprError (func, r, rtok, ConstExpr))
        {
          /* Right operand is in error as a variable.  */
          failure = true;
        }
      if (failure)
        {
          /* Generate a fake result if either operand was a variable (and we
            are in a const expression).  */
          M2Quads_PushTFtok (ReturnVar, type, combinedtok);
        }
      else if (((SymbolTable_IsVar (l)) || (SymbolTable_IsConst (l))) && ((SymbolTable_IsVar (r)) || (SymbolTable_IsConst (r))))
        {
          /* avoid dangling else.  */
          M2Base_CheckExpressionCompatible (combinedtok, SymbolTable_GetSType (l), SymbolTable_GetSType (r));
          GenQuadO (combinedtok, M2Quads_StandardFunctionOp, ReturnVar, M2Base_Cmplx, SymbolTable_Make2Tuple (l, r), true);
          M2Quads_PushTFtok (ReturnVar, type, combinedtok);
        }
      else
        {
          /* avoid dangling else.  */
          if ((SymbolTable_IsVar (l)) || (SymbolTable_IsConst (l)))
            {
              M2MetaError_MetaErrorT2 (functok, (const char *) "the builtin procedure {%1Ead} requires two parameters, both must be variables or constants but the second parameter is {%2d}", 124, func, r);
            }
          else
            {
              M2MetaError_MetaErrorT2 (functok, (const char *) "the builtin procedure {%1Ead} requires two parameters, both must be variables or constants but the first parameter is {%2d}", 123, func, l);
            }
          M2Quads_PushTFtok (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_CType), M2Base_CType, combinedtok);
        }
    }
  else
    {
      M2MetaError_MetaErrorT2 (functok, (const char *) "the builtin procedure {%1Ead} requires two parameters, seen {%2n}", 65, func, NoOfParam);
      M2Quads_PopN (NoOfParam+1);  /* destroy arguments to this function  */
      M2Quads_PushTFtok (SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "1.0", 3), M2Base_CType), M2Base_CType, functok);  /* destroy arguments to this function  */
    }
}


/*
   BuildAdrFunction - builds the pseudo function ADR
                      The Stack:


                      Entry                      Exit

               Ptr ->
                      +----------------+
                      | NoOfParam      |
                      |----------------|
                      | Param 1        |
                      |----------------|
                      | Param 2        |
                      |----------------|
                      .                .
                      .                .
                      .                .
                      |----------------|
                      | Param #        |                        <- Ptr
                      |----------------|         +------------+
                      | ProcSym | Type |         | ReturnVar  |
                      |----------------|         |------------|

*/

static void BuildAdrFunction (void)
{
  unsigned int endtok;
  unsigned int combinedTok;
  unsigned int procTok;
  unsigned int t;
  unsigned int UnboundedSym;
  unsigned int Dim;
  unsigned int Field;
  unsigned int noOfParameters;
  unsigned int procSym;
  unsigned int returnVar;
  unsigned int Type;
  unsigned int rw;

  M2Quads_DisplayStack ();
  M2Quads_PopT (&noOfParameters);
  procSym = static_cast<unsigned int> (M2Quads_OperandT (noOfParameters+1));
  procTok = static_cast<unsigned int> (M2Quads_OperandTok (noOfParameters+1));  /* token of procedure ADR.  */
  endtok = static_cast<unsigned int> (M2Quads_OperandTok (1));  /* last parameter.  */
  combinedTok = M2LexBuf_MakeVirtualTok (procTok, procTok, endtok);  /* last parameter.  */
  if (noOfParameters != 1)
    {
      M2MetaError_MetaErrorNT0 (combinedTok, (const char *) "SYSTEM procedure ADR expects 1 parameter", 40);
      M2Quads_PopN (noOfParameters+1);  /* destroy the arguments and function  */
      M2Quads_PushTF (M2Base_Nil, M2System_Address);  /* destroy the arguments and function  */
    }
  else if (SymbolTable_IsConstString (M2Quads_OperandT (1)))
    {
      /* avoid dangling else.  */
      returnVar = MakeLeftValue (combinedTok, M2Quads_OperandT (1), SymbolTable_RightValue, SymbolTable_GetSType (procSym));
      M2Quads_PopN (noOfParameters+1);  /* destroy the arguments and function  */
      M2Quads_PushTFtok (returnVar, SymbolTable_GetSType (returnVar), combinedTok);  /* destroy the arguments and function  */
    }
  else if ((! (SymbolTable_IsVar (M2Quads_OperandT (1)))) && (! (SymbolTable_IsProcedure (M2Quads_OperandT (1)))))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorNT0 (combinedTok, (const char *) "SYSTEM procedure ADR expects a variable, procedure or a constant string as its parameter", 88);
      M2Quads_PopN (noOfParameters+1);  /* destroy the arguments and function  */
      M2Quads_PushTFtok (M2Base_Nil, M2System_Address, combinedTok);  /* destroy the arguments and function  */
    }
  else if (SymbolTable_IsProcedure (M2Quads_OperandT (1)))
    {
      /* avoid dangling else.  */
      returnVar = MakeLeftValue (combinedTok, M2Quads_OperandT (1), SymbolTable_RightValue, SymbolTable_GetSType (procSym));
      M2Quads_PopN (noOfParameters+1);  /* destroy the arguments and function  */
      M2Quads_PushTFtok (returnVar, SymbolTable_GetSType (returnVar), combinedTok);  /* destroy the arguments and function  */
    }
  else
    {
      /* avoid dangling else.  */
      Type = SymbolTable_GetSType (M2Quads_OperandT (1));
      Dim = static_cast<unsigned int> (OperandD (1));
      MarkArrayWritten (M2Quads_OperandT (1));
      MarkArrayWritten (M2Quads_OperandA (1));
      /* if the operand is an unbounded which has not been indexed
         then we will lookup its address from the unbounded record.
         Otherwise we obtain the address of the operand.
  */
      if ((SymbolTable_IsUnbounded (Type)) && (Dim == 0))
        {
          /* we will reference the address field of the unbounded structure  */
          UnboundedSym = static_cast<unsigned int> (M2Quads_OperandT (1));
          rw = static_cast<unsigned int> (OperandRW (1));
          PushTFrw (UnboundedSym, SymbolTable_GetSType (UnboundedSym), rw);
          Field = SymbolTable_GetUnboundedAddressOffset (SymbolTable_GetSType (UnboundedSym));
          M2Quads_PushTF (Field, SymbolTable_GetSType (Field));
          M2Quads_PushT (static_cast<unsigned int> (1));
          M2Quads_BuildDesignatorRecord (combinedTok);
          PopTrw (&returnVar, &rw);
          if ((SymbolTable_GetMode (returnVar)) == SymbolTable_LeftValue)
            {
              t = SymbolTable_MakeTemporary (combinedTok, SymbolTable_RightValue);
              SymbolTable_PutVar (t, SymbolTable_GetSType (procSym));
              doIndrX (combinedTok, t, returnVar);
              returnVar = t;
            }
          else
            {
              /* we need to cast returnVar into ADDRESS  */
              t = SymbolTable_MakeTemporary (combinedTok, SymbolTable_RightValue);
              SymbolTable_PutVar (t, SymbolTable_GetSType (procSym));
              GenQuadO (combinedTok, M2Quads_ConvertOp, t, SymbolTable_GetSType (procSym), returnVar, false);
              returnVar = t;
            }
        }
      else
        {
          returnVar = SymbolTable_MakeTemporary (combinedTok, SymbolTable_RightValue);
          SymbolTable_PutVar (returnVar, SymbolTable_GetSType (procSym));
          if ((SymbolTable_GetMode (M2Quads_OperandT (1))) == SymbolTable_LeftValue)
            {
              SymbolTable_PutVar (returnVar, SymbolTable_GetSType (procSym));
              GenQuadO (combinedTok, M2Quads_ConvertOp, returnVar, SymbolTable_GetSType (procSym), M2Quads_OperandT (1), false);
            }
          else
            {
              GenQuadO (combinedTok, M2Quads_AddrOp, returnVar, SymbolTable_NulSym, M2Quads_OperandT (1), false);
            }
          SymbolTable_PutWriteQuad (M2Quads_OperandT (1), SymbolTable_GetMode (M2Quads_OperandT (1)), NextQuad-1);
          rw = static_cast<unsigned int> (OperandMergeRW (1));
          M2Debug_Assert (SymbolTable_IsLegal (rw));
        }
      M2Quads_PopN (noOfParameters+1);  /* destroy the arguments and function  */
      PushTFrwtok (returnVar, SymbolTable_GetSType (returnVar), rw, combinedTok);  /* destroy the arguments and function  */
    }
}


/*
   BuildSizeFunction - builds the pseudo function SIZE
                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|
*/

static void BuildSizeFunction (void)
{
  unsigned int resulttok;
  unsigned int paramtok;
  unsigned int functok;
  unsigned int dim;
  unsigned int Type;
  unsigned int NoOfParam;
  unsigned int ProcSym;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = OperandTtok (NoOfParam+1);
  if (NoOfParam != 1)
    {
      M2MetaError_MetaErrorT1 (functok, (const char *) "{%E} SYSTEM procedure function {%kSIZE} requires one parameter, seen {%1n}", 74, NoOfParam);
      resulttok = functok;
      ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
    }
  else if (SymbolTable_IsAModula2Type (M2Quads_OperandT (1)))
    {
      /* avoid dangling else.  */
      paramtok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
      BuildSizeCheckEnd (ProcSym);  /* Quadruple generation now on.  */
      ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);  /* Quadruple generation now on.  */
      GenQuadO (resulttok, M2Quads_SizeOp, ReturnVar, SymbolTable_NulSym, M2Quads_OperandT (1), true);
    }
  else if (SymbolTable_IsVar (M2Quads_OperandT (1)))
    {
      /* avoid dangling else.  */
      BuildSizeCheckEnd (ProcSym);  /* Quadruple generation now on.  */
      Type = SymbolTable_GetSType (M2Quads_OperandT (1));  /* Quadruple generation now on.  */
      paramtok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
      if (SymbolTable_IsUnbounded (Type))
        {
          /* Eg. SIZE(a) ; where a is unbounded dereference HIGH and multiply by the TYPE.  */
          dim = static_cast<unsigned int> (OperandD (1));
          if (dim == 0)
            {
              ReturnVar = calculateMultipicand (resulttok, M2Quads_OperandT (1), Type, dim);
            }
          else
            {
              ReturnVar = calculateMultipicand (resulttok, M2Quads_OperandA (1), Type, dim);
            }
        }
      else
        {
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          if (Type == SymbolTable_NulSym)
            {
              M2MetaError_MetaErrorT1 (resulttok, (const char *) "cannot get the type and size of {%1Ead}", 39, M2Quads_OperandT (1));
            }
          GenQuadO (resulttok, M2Quads_SizeOp, ReturnVar, SymbolTable_NulSym, Type, true);
        }
    }
  else
    {
      /* avoid dangling else.  */
      resulttok = functok;
      M2MetaError_MetaErrorT1 (resulttok, (const char *) "{%E}SYSTEM procedure {%kSIZE} expects a variable as its parameter, seen {%1Ed}", 78, M2Quads_OperandT (1));
      ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
    }
  M2Quads_PopN (NoOfParam+1);  /* Destroy the arguments and function.  */
  M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (ProcSym), resulttok);  /* Destroy the arguments and function.  */
}


/*
   BuildTSizeFunction - builds the pseudo function TSIZE
                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |                        <- Ptr
                        |----------------|         +------------+
                        | ProcSym | Type |         | ReturnVar  |
                        |----------------|         |------------|

*/

static void BuildTSizeFunction (void)
{
  unsigned int resulttok;
  unsigned int paramtok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ProcSym;
  unsigned int Record;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = OperandTtok (NoOfParam);
  BuildSizeCheckEnd (ProcSym);  /* quadruple generation now on  */
  if (NoOfParam == 1)  /* quadruple generation now on  */
    {
      paramtok = OperandTtok (1);
      resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
      if (SymbolTable_IsAModula2Type (M2Quads_OperandT (1)))
        {
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
          GenQuadO (resulttok, M2Quads_SizeOp, ReturnVar, SymbolTable_NulSym, M2Quads_OperandT (1), false);
        }
      else if (SymbolTable_IsVar (M2Quads_OperandT (1)))
        {
          /* avoid dangling else.  */
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
          GenQuadO (resulttok, M2Quads_SizeOp, ReturnVar, SymbolTable_NulSym, SymbolTable_GetSType (M2Quads_OperandT (1)), false);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (resulttok, (const char *) "{%E}SYSTEM procedure function {%kTSIZE} expects a variable as its first parameter, seen {%1Ed}", 94, M2Quads_OperandT (1));
          ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
        }
    }
  else if (NoOfParam == 0)
    {
      /* avoid dangling else.  */
      resulttok = functok;
      M2MetaError_MetaErrorT0 (resulttok, (const char *) "{%E}SYSTEM procedure function {%kTSIZE} expects either one or two parameters, seen none", 87);
      ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
    }
  else
    {
      /* avoid dangling else.  */
      Record = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));
      paramtok = OperandTtok (1);
      resulttok = OperandTtok (NoOfParam);
      if (SymbolTable_IsRecord (Record))
        {
          paramtok = OperandTtok (1);
          resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          SymbolTable_PutVar (ReturnVar, M2Base_Cardinal);
          GenQuadO (resulttok, M2Quads_SizeOp, ReturnVar, SymbolTable_NulSym, Record, false);
        }
      else
        {
          resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
          M2MetaError_MetaErrorT1 (resulttok, (const char *) "{%E}SYSTEM procedure function {%kTSIZE} expects the first parameter to be a record type, seen {%1d}", 99, Record);
          ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
        }
    }
  M2Quads_PopN (NoOfParam+1);  /* destroy the arguments and function  */
  M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (ProcSym), resulttok);  /* destroy the arguments and function  */
}


/*
   BuildTBitSizeFunction - builds the pseudo function TBITSIZE
                           The Stack:


                           Entry                      Exit

                   Ptr ->
                           +----------------+
                           | NoOfParam      |
                           |----------------|
                           | Param 1        |
                           |----------------|
                           | Param 2        |
                           |----------------|
                           .                .
                           .                .
                           .                .
                           |----------------|
                           | Param #        |                        <- Ptr
                           |----------------|         +------------+
                           | ProcSym | Type |         | ReturnVar  |
                           |----------------|         |------------|

*/

static void BuildTBitSizeFunction (void)
{
  unsigned int resulttok;
  unsigned int paramtok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ProcSym;
  unsigned int Record;
  unsigned int ReturnVar;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = OperandTtok (NoOfParam);
  BuildSizeCheckEnd (ProcSym);  /* quadruple generation now on  */
  if (NoOfParam == 1)  /* quadruple generation now on  */
    {
      paramtok = OperandTtok (1);
      resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
      if (SymbolTable_IsAModula2Type (M2Quads_OperandT (1)))
        {
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          GenQuadO (resulttok, M2Quads_StandardFunctionOp, ReturnVar, ProcSym, M2Quads_OperandT (1), false);
        }
      else if (SymbolTable_IsVar (M2Quads_OperandT (1)))
        {
          /* avoid dangling else.  */
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          GenQuadO (resulttok, M2Quads_StandardFunctionOp, ReturnVar, ProcSym, M2Quads_OperandT (1), false);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (resulttok, (const char *) "{%E}SYSTEM procedure function {%kTBITSIZE} expects a variable as its first parameter, seen {%1d}", 96, M2Quads_OperandT (1));
          ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
        }
    }
  else if (NoOfParam == 0)
    {
      /* avoid dangling else.  */
      resulttok = functok;
      M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}SYSTEM procedure function {%kTBITSIZE} expects either one or two parameters, seen none", 90);
      ReturnVar = SymbolTable_MakeConstLit (functok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
    }
  else
    {
      /* avoid dangling else.  */
      Record = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam));
      paramtok = OperandTtok (1);
      resulttok = OperandTtok (NoOfParam);
      if (SymbolTable_IsRecord (Record))
        {
          paramtok = OperandTtok (1);
          resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
          ReturnVar = SymbolTable_MakeTemporary (resulttok, SymbolTable_ImmediateValue);
          GenQuad (M2Quads_StandardFunctionOp, ReturnVar, ProcSym, M2Quads_OperandT (1));
        }
      else
        {
          resulttok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
          M2MetaError_MetaErrorT1 (resulttok, (const char *) "{%E}SYSTEM procedure function {%kTBITSIZE} expects the first parameter to be a record type, seen {%1d}", 102, Record);
          ReturnVar = SymbolTable_MakeConstLit (resulttok, NameKey_MakeKey ((const char *) "0", 1), M2Base_Cardinal);
        }
    }
  M2Quads_PopN (NoOfParam+1);  /* destroy the arguments and function  */
  M2Quads_PushTFtok (ReturnVar, SymbolTable_GetSType (ProcSym), resulttok);  /* destroy the arguments and function  */
}


/*
   ExpectingParameterType -
*/

static void ExpectingParameterType (unsigned int BlockSym, unsigned int Type)
{
  if (! (SymbolTable_IsAModula2Type (Type)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (((Type == SymbolTable_NulSym) || (SymbolTable_IsPartialUnbounded (Type))) || (SymbolTable_IsUnknown (Type)))
        {
          M2MetaError_MetaError1 ((const char *) "the type used in the formal parameter declaration in {%1Md} {%1a} is unknown", 76, BlockSym);
        }
      else
        {
          M2MetaError_MetaError2 ((const char *) "the type {%1Ead} used in the formal parameter declaration in {%2Md} {%2a} was not declared as a type", 100, Type, BlockSym);
        }
    }
}


/*
   ExpectingVariableType -
*/

static void ExpectingVariableType (unsigned int BlockSym, unsigned int Type)
{
  if (! (SymbolTable_IsAModula2Type (Type)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (Type == SymbolTable_NulSym)
        {
          M2MetaError_MetaError1 ((const char *) "the type used during the variable declaration section in procedure {%1EMad} is unknown", 86, BlockSym);
          M2MetaError_MetaError1 ((const char *) "the type used during the variable declaration section in procedure {%1Ead} is unknown", 85, BlockSym);
        }
      else if ((SymbolTable_IsPartialUnbounded (Type)) || (SymbolTable_IsUnknown (Type)))
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError2 ((const char *) "the type {%1EMad} used during variable declaration section in procedure {%2ad} is unknown", 89, Type, BlockSym);
          M2MetaError_MetaError2 ((const char *) "the type {%1Ead} used during variable declaration section in procedure {%2Mad} is unknown", 89, Type, BlockSym);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError2 ((const char *) "the {%1d} {%1Ea} is not a type and therefore cannot be used to declare a variable in {%2d} {%2a}", 96, Type, BlockSym);
        }
    }
}


/*
   CheckVariablesAndParameterTypesInBlock - checks to make sure that block, BlockSym, has
                                            parameters types and variable types which are legal.
*/

static void CheckVariablesAndParameterTypesInBlock (unsigned int BlockSym)
{
  unsigned int i;
  unsigned int n;
  unsigned int ParamNo;

  if (SymbolTable_IsProcedure (BlockSym))
    {
      ParamNo = SymbolTable_NoOfParamAny (BlockSym);
    }
  else
    {
      ParamNo = 0;
    }
  i = 1;
  do {
    n = SymbolTable_GetNth (BlockSym, i);
    if (((n != SymbolTable_NulSym) && (! (SymbolTable_IsTemporary (n)))) && ((SymbolTable_IsProcedure (BlockSym)) || (((SymbolTable_IsDefImp (BlockSym)) && ((SymbolTable_GetMainModule ()) == BlockSym)) || (SymbolTable_IsModule (BlockSym)))))
      {
        /* avoid gcc warning by using compound statement even if not strictly necessary.  */
        if (i <= ParamNo)
          {
            /* n is a parameter  */
            ExpectingParameterType (BlockSym, SymbolTable_GetSType (n));
          }
        else
          {
            /* n is a local variable  */
            ExpectingVariableType (BlockSym, SymbolTable_GetSType (n));
          }
      }
    i += 1;
  } while (! (n == SymbolTable_NulSym));
}


/*
   IsNeverAltered - returns TRUE if variable, sym, is never altered
                    between quadruples: Start..End
*/

static bool IsNeverAltered (unsigned int sym, unsigned int Start, unsigned int End)
{
  unsigned int WriteStart;
  unsigned int WriteEnd;

  SymbolTable_GetWriteLimitQuads (sym, SymbolTable_GetMode (sym), Start, End, &WriteStart, &WriteEnd);
  return (WriteStart == 0) && (WriteEnd == 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConditionVariable - returns TRUE if the condition at quadruple, q, is variable.
*/

static bool IsConditionVariable (unsigned int q, unsigned int Start, unsigned int End)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  bool LeftFixed;
  bool RightFixed;

  M2Quads_GetQuad (q, &op, &op1, &op2, &op3);
  if (op == M2Quads_GotoOp)
    {
      return false;
    }
  else
    {
      LeftFixed = SymbolTable_IsConst (op1);
      RightFixed = SymbolTable_IsConst (op2);
      if (! LeftFixed)
        {
          LeftFixed = IsNeverAltered (op1, Start, End);
        }
      if (! RightFixed)
        {
          RightFixed = IsNeverAltered (op2, Start, End);
        }
      return ! (LeftFixed && RightFixed);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsInfiniteLoop - returns TRUE if an infinite loop is found.
                    Given a backwards jump at, End, it returns a BOOLEAN which depends on
                    whether a jump is found to jump beyond, End. If a conditonal jump is found
                    to pass over, End, the condition is tested for global variables, procedure variables and
                    constants.

                         constant        - ignored
                         variables       - tested to see whether they are altered inside the loop
                         global variable - the procedure tests to see whether it is altered as above
                                           but will also test to see whether this loop calls a procedure
                                           in which case it believes the loop NOT to be infinite
                                           (as this procedure call might alter the global variable)

                    Note that this procedure can easily be fooled by the user altering variables
                    with pointers.
*/

static bool IsInfiniteLoop (unsigned int End)
{
  bool SeenCall;
  bool IsGlobal;
  unsigned int Current;
  unsigned int Start;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  SeenCall = false;
  IsGlobal = false;
  M2Quads_GetQuad (End, &op, &op1, &op2, &Start);
  Current = Start;
  while (Current != End)
    {
      M2Quads_GetQuad (Current, &op, &op1, &op2, &op3);
      /* remember that this function is only called once we have optimized the redundant gotos and conditionals  */
      if ((M2Quads_IsConditional (Current)) && ! IsGlobal)
        {
          IsGlobal = ((SymbolTable_IsVar (op1)) && (! (SymbolTable_IsProcedure (SymbolTable_GetVarScope (op1))))) || ((SymbolTable_IsVar (op2)) && (! (SymbolTable_IsProcedure (SymbolTable_GetVarScope (op2)))));
        }
      if (op == M2Quads_CallOp)
        {
          SeenCall = true;
        }
      if ((op == M2Quads_GotoOp) || ((M2Quads_IsConditional (Current)) && (IsConditionVariable (Current, Start, End))))
        {
          if ((op3 > End) || (op3 < Start))
            {
              return false;  /* may jump out of this loop, good  */
            }
        }
      Current = M2Quads_GetNextQuad (Current);
    }
  M2Quads_GetQuad (End, &op, &op1, &op2, &op3);
  if (M2Quads_IsConditional (End))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (IsConditionVariable (End, Start, End))
        {
          return false;
        }
      else
        {
          if (! IsGlobal)
            {
              IsGlobal = ((SymbolTable_IsVar (op1)) && (! (SymbolTable_IsProcedure (SymbolTable_GetVarScope (op1))))) || ((SymbolTable_IsVar (op2)) && (! (SymbolTable_IsProcedure (SymbolTable_GetVarScope (op2)))));
            }
        }
    }
  /* we have found a likely infinite loop if no conditional uses a global and no procedure call was seen  */
  return ! (IsGlobal && SeenCall);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckVariablesInBlock - given a block, BlockSym, check whether all variables are used.
*/

static void CheckVariablesInBlock (unsigned int BlockSym)
{
  CheckVariablesAndParameterTypesInBlock (BlockSym);
}


/*
   CheckFunctionReturn - checks to see that a RETURN statement was present in a function.
*/

static void CheckFunctionReturn (unsigned int ProcSym)
{
  M2Quads_QuadOperator Op;
  unsigned int Op1;
  unsigned int Op2;
  unsigned int Op3;
  unsigned int Scope;
  unsigned int Start;
  unsigned int End;

  if ((SymbolTable_GetSType (ProcSym)) != SymbolTable_NulSym)
    {
      /* yes it is a function  */
      SymbolTable_GetProcedureQuads (ProcSym, &Scope, &Start, &End);
      M2Quads_GetQuad (Start, &Op, &Op1, &Op2, &Op3);
      if (Start == 0)
        {
          M2Error_InternalError ((const char *) "incorrect start quad", 20);
        }
      while (((Start != End) && (Op != M2Quads_ReturnValueOp)) && (Op != M2Quads_InlineOp))
        {
          Start = M2Quads_GetNextQuad (Start);
          M2Quads_GetQuad (Start, &Op, &Op1, &Op2, &Op3);
        }
      if ((Op != M2Quads_ReturnValueOp) && (Op != M2Quads_InlineOp))
        {
          /* an InlineOp can always be used to emulate a RETURN  */
          M2MetaError_MetaError1 ((const char *) "procedure function {%1Ea} does not RETURN a value", 49, ProcSym);
        }
    }
}


/*
   CheckReturnType - checks to see that the return type from currentProc is
                     assignment compatible with actualType.
*/

static void CheckReturnType (unsigned int tokno, unsigned int currentProc, unsigned int actualVal, unsigned int actualType)
{
  unsigned int procType;
  DynamicStrings_String s1;
  DynamicStrings_String s2;
  NameKey_Name n1;
  NameKey_Name n2;

  procType = SymbolTable_GetSType (currentProc);
  if (procType == SymbolTable_NulSym)
    {
      M2MetaError_MetaError1 ((const char *) "attempting to RETURN a value from procedure {%1Ea} which was not a declared as a procedure function", 99, currentProc);
    }
  else if (M2Base_AssignmentRequiresWarning (actualType, SymbolTable_GetSType (currentProc)))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError2 ((const char *) "attempting to RETURN a value {%1Wa} with an incompatible type {%1Wtsa} from a procedure function {%1a} which returns {%1tsa}", 124, actualVal, currentProc);
    }
  else if (! (M2Base_IsAssignmentCompatible (actualType, procType)))
    {
      /* avoid dangling else.  */
      n1 = SymbolTable_GetSymName (actualType);
      n2 = SymbolTable_GetSymName (procType);
      M2Error_WriteFormat2 ((const char *) "attempting to RETURN a value with an incompatible type (%a) from a function which returns (%a)", 94, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
    }
  else if ((SymbolTable_IsProcedure (actualVal)) && (! (M2Base_IsAssignmentCompatible (actualVal, procType))))
    {
      /* avoid dangling else.  */
      /* 
      MetaWarnings2('attempting to RETURN a value with an incompatible type {%1ad} from function {%2a} which returns {%2ta}',
                    actualVal, currentProc)

      --fixme--  introduce MetaWarning, MetaWarning2, MetaWarning3 into M2MetaError
  */
      s1 = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (actualVal)));
      s2 = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (procType)));
      M2Error_ErrorString (M2Error_NewWarning (M2LexBuf_GetTokenNo ()), FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "attempting to RETURN a value with a (possibly on other targets) incompatible type (%s) from a function which returns (%s)", 121)), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) &s2, (sizeof (s2)-1)));
    }
  else if ((SymbolTable_IsProcedure (actualVal)) && (! (M2Base_IsAssignmentCompatible (actualVal, SymbolTable_GetSType (CurrentProc)))))
    {
      /* avoid dangling else.  */
      n1 = SymbolTable_GetSymName (actualVal);
      n2 = SymbolTable_GetSymName (SymbolTable_GetSType (currentProc));
      M2Error_WriteFormat2 ((const char *) "attempting to RETURN a value with an incompatible type (%a) from a function which returns (%a)", 94, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
    }
  else
    {
      /* avoid dangling else.  */
      /* this checks the types are compatible, not the data contents.  */
      BuildRange (M2Range_InitTypesReturnTypeCheck (tokno, currentProc, actualVal));
    }
}


/*
   BuildReturnLower - check the return type and value to ensure type
                      compatibility and no range overflow will occur.
*/

static void BuildReturnLower (unsigned int tokcombined, unsigned int tokexpr, unsigned int e1, unsigned int t1)
{
  unsigned int e2;
  unsigned int t2;

  /* This will check that the type returned is compatible with
      the formal return type of the procedure.  */
  CheckReturnType (tokcombined, CurrentProc, e1, t1);
  /* Dereference LeftValue if necessary.  */
  if ((SymbolTable_GetMode (e1)) == SymbolTable_LeftValue)
    {
      t2 = SymbolTable_GetSType (CurrentProc);
      e2 = SymbolTable_MakeTemporary (tokexpr, SymbolTable_RightValue);
      SymbolTable_PutVar (e2, t2);
      CheckPointerThroughNil (tokexpr, e1);
      doIndrX (tokexpr, e2, e1);
      e1 = e2;
    }
  /* Here we check the data contents to ensure no overflow.  */
  BuildRange (M2Range_InitReturnRangeCheck (tokcombined, CurrentProc, e1));
  GenQuadOtok (tokcombined, M2Quads_ReturnValueOp, e1, SymbolTable_NulSym, CurrentProc, false, tokcombined, M2LexBuf_UnknownTokenNo, SymbolTable_GetDeclaredMod (CurrentProc));
}


/*
   IsReadOnly - a helper procedure function to detect constants.
*/

static bool IsReadOnly (unsigned int sym)
{
  return (SymbolTable_IsConst (sym)) || ((SymbolTable_IsVar (sym)) && (SymbolTable_IsVarConst (sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildDesignatorError - removes the designator from the stack and replaces
                          it with an error symbol.
*/

static void BuildDesignatorError (const char *message_, unsigned int _message_high)
{
  unsigned int combinedTok;
  unsigned int arrayTok;
  unsigned int exprTok;
  unsigned int e;
  unsigned int d;
  unsigned int error;
  unsigned int Sym;
  unsigned int Type;
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  M2Quads_PopTtok (&e, &exprTok);
  PopTFDtok (&Sym, &Type, &d, &arrayTok);
  combinedTok = M2LexBuf_MakeVirtualTok (arrayTok, arrayTok, exprTok);
  error = SymbolTable_MakeError (combinedTok, NameKey_MakeKey ((const char *) message, _message_high));
  PushTFDtok (error, Type, d, arrayTok);
}


/*
   BuildDesignatorPointerError - removes the designator from the stack and replaces
                                 it with an error symbol.
*/

static void BuildDesignatorPointerError (unsigned int type, unsigned int rw, unsigned int tokpos, const char *message_, unsigned int _message_high)
{
  unsigned int error;
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  error = SymbolTable_MakeError (tokpos, NameKey_MakeKey ((const char *) message, _message_high));
  if ((SymbolTable_GetSType (type)) != SymbolTable_NulSym)
    {
      type = SymbolTable_GetSType (type);
    }
  PushTFrwtok (error, type, rw, tokpos);
}


/*
   BuildDesignatorArrayStaticDynamic - Builds the array referencing.
                                       The purpose of this procedure is to work out
                                       whether the DesignatorArray is a static or
                                       dynamic array and to call the appropriate
                                       BuildRoutine.

                                       The Stack is expected to contain:


                                       Entry                   Exit
                                       =====                   ====

                                Ptr ->
                                       +--------------+
                                       | e            |                        <- Ptr
                                       |--------------|        +------------+
                                       | Sym  | Type  |        | S    | T   |
                                       |--------------|        |------------|
*/

static void BuildDesignatorArrayStaticDynamic (void)
{
  unsigned int combinedTok;
  unsigned int arrayTok;
  unsigned int exprTok;
  unsigned int e;
  unsigned int type;
  unsigned int dim;
  unsigned int result;
  unsigned int Sym;
  unsigned int Type;

  if (SymbolTable_IsConst (M2Quads_OperandT (2)))
    {
      type = SymbolTable_GetDType (M2Quads_OperandT (2));
      if ((type != SymbolTable_NulSym) && (SymbolTable_IsArray (type)))
        {
          M2Quads_PopTtok (&e, &exprTok);
          PopTFDtok (&Sym, &Type, &dim, &arrayTok);
          result = SymbolTable_MakeTemporary (exprTok, SymbolTable_RightValue);
          SymbolTable_PutVar (result, Type);
          M2Quads_PushTFtok (result, SymbolTable_GetSType (result), exprTok);
          M2Quads_PushTtok (Sym, arrayTok);
          combinedTok = M2LexBuf_MakeVirtualTok (arrayTok, arrayTok, exprTok);
          SymbolTable_PutVarConst (result, true);
          M2Quads_BuildAssignConstant (combinedTok);
          PushTFDtok (result, SymbolTable_GetDType (result), dim, arrayTok);
          M2Quads_PushTtok (e, exprTok);
        }
    }
  if ((! (SymbolTable_IsVar (M2Quads_OperandT (2)))) && (! (SymbolTable_IsTemporary (M2Quads_OperandT (2)))))
    {
      M2MetaError_MetaErrorT1 (OperandTtok (2), (const char *) "can only access arrays using constants, variables or formal parameters not {%1Ead}", 82, M2Quads_OperandT (2));
      BuildDesignatorError ((const char *) "bad array access", 16);
    }
  Sym = static_cast<unsigned int> (M2Quads_OperandT (2));
  Type = SymbolTable_GetDType (Sym);
  arrayTok = OperandTtok (2);
  if (Type == SymbolTable_NulSym)
    {
      if ((arrayTok == M2LexBuf_UnknownTokenNo) || (arrayTok == M2LexBuf_BuiltinTokenNo))
        {
          arrayTok = M2LexBuf_GetTokenNo ();
        }
      M2MetaError_MetaErrorT0 (arrayTok, (const char *) "type of array is undefined", 26);
      BuildDesignatorError ((const char *) "bad array access", 16);
    }
  else if (SymbolTable_IsUnbounded (Type))
    {
      /* avoid dangling else.  */
      BuildDynamicArray ();
    }
  else if (SymbolTable_IsArray (Type))
    {
      /* avoid dangling else.  */
      BuildStaticArray ();
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (arrayTok, (const char *) "can only index static or dynamic arrays, {%1Ead} is not an array but a {%tad}", 77, Sym);
      BuildDesignatorError ((const char *) "bad array access", 16);
    }
}


/*
   BuildStaticArray - Builds the array referencing for static arrays.
                      The Stack is expected to contain:


                      Entry                   Exit
                      =====                   ====

              Ptr ->
                      +--------------+
                      | e            |                       <- Ptr
                      |--------------|        +------------+
                      | Sym  | Type  |        | S    | T   |
                      |--------------|        |------------|
*/

static void BuildStaticArray (void)
{
  unsigned int combinedTok;
  unsigned int indexTok;
  unsigned int arrayTok;
  unsigned int rw;
  unsigned int Dim;
  unsigned int Array;
  unsigned int Index;
  unsigned int BackEndType;
  unsigned int Type;
  unsigned int Adr;

  Index = static_cast<unsigned int> (M2Quads_OperandT (1));
  indexTok = OperandTtok (1);
  Array = static_cast<unsigned int> (M2Quads_OperandT (2));
  arrayTok = OperandTtok (2);
  Type = SymbolTable_SkipType (M2Quads_OperandF (2));
  rw = static_cast<unsigned int> (OperandMergeRW (2));
  M2Debug_Assert (SymbolTable_IsLegal (rw));
  Dim = static_cast<unsigned int> (OperandD (2));
  Dim += 1;
  if ((SymbolTable_GetMode (Index)) == SymbolTable_LeftValue)
    {
      Index = MakeRightValue (indexTok, Index, SymbolTable_GetSType (Index));
    }
  BuildRange (M2Range_InitStaticArraySubscriptRangeCheck (SymbolTable_GetArraySubscript (Type), Index, Dim));
  /* now make Adr point to the address of the indexed element  */
  combinedTok = M2LexBuf_MakeVirtualTok (arrayTok, arrayTok, indexTok);
  Adr = SymbolTable_MakeTemporary (combinedTok, SymbolTable_LeftValue);
  if (SymbolTable_IsVar (Array))
    {
      /* BuildDesignatorArray may have detected des is a constant.  */
      SymbolTable_PutVarConst (Adr, SymbolTable_IsVarConst (Array));
    }
  SymbolTable_PutVarArrayRef (Adr, true);
  /* 
      From now on it must reference the array element by its lvalue
      - so we create the type of the referenced entity
  */
  BackEndType = SymbolTable_MakePointer (combinedTok, NameKey_NulName);
  SymbolTable_PutPointer (BackEndType, SymbolTable_GetDType (Type));
  /* PutVar(Adr, BackEndType) ;  */
  SymbolTable_PutLeftValueFrontBackType (Adr, SymbolTable_GetDType (Type), BackEndType);
  GenQuadO (combinedTok, M2Quads_ArrayOp, Adr, Index, Array, true);
  M2Quads_PopN (2);  /* remove all parameters to this procedure  */
  PushTFDrwtok (Adr, SymbolTable_GetSType (Adr), Dim, rw, combinedTok);  /* remove all parameters to this procedure  */
}


/*
   calculateMultipicand - generates quadruples which calculate the
                          multiplicand for the array at dimension, dim.
*/

static unsigned int calculateMultipicand (unsigned int tok, unsigned int arraySym, unsigned int arrayType, unsigned int dim)
{
  unsigned int ti;
  unsigned int tj;
  unsigned int tk;
  unsigned int tl;

  if (dim == (SymbolTable_GetDimension (arrayType)))
    {
      /* ti has no type since constant  */
      ti = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
      SymbolTable_PutVar (ti, M2Base_Cardinal);
      GenQuadO (tok, M2Quads_ElementSizeOp, ti, arrayType, 1, true);
    }
  else
    {
      dim += 1;
      tk = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (tk, M2Base_Cardinal);
      GenHigh (tok, tk, dim, arraySym);
      tl = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (tl, M2Base_Cardinal);
      GenQuadOtok (tok, M2Quads_AddOp, tl, tk, SymbolTable_MakeConstLit (tok, NameKey_MakeKey ((const char *) "1", 1), M2Base_Cardinal), true, tok, tok, tok);
      tj = calculateMultipicand (tok, arraySym, arrayType, dim);
      ti = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
      SymbolTable_PutVar (ti, M2Base_Cardinal);
      GenQuadO (tok, M2Quads_MultOp, ti, tj, tl, true);
    }
  return ti;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertToAddress - convert sym to an address.
*/

static unsigned int ConvertToAddress (unsigned int tokpos, unsigned int sym)
{
  unsigned int adr;

  if ((SymbolTable_GetSType (sym)) == M2System_Address)
    {
      return sym;
    }
  else
    {
      M2Quads_PushTF (SymbolTable_RequestSym (tokpos, NameKey_MakeKey ((const char *) "CONVERT", 7)), static_cast<unsigned int> (SymbolTable_NulSym));
      M2Quads_PushT (M2System_Address);
      M2Quads_PushTtok (sym, tokpos);
      M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
      BuildConvertFunction (M2Base_Convert, false);  /* Two parameters  */
      M2Quads_PopT (&adr);
      return adr;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildDynamicArray - Builds the array referencing for dynamic arrays.
                       The Stack is expected to contain:


                       Entry                          Exit
                       =====                          ====

               Ptr ->
                       +-----------------------+
                       | Index                 |                                    <- Ptr
                       |-----------------------|      +---------------------------+
                       | ArraySym | Type | Dim |      | S  | T | ArraySym | Dim+1 |
                       |-----------------------|      |---------------------------|


   if Dim=1
   then
      S := base of ArraySym + TSIZE(Type)*Index
   else
      S := S + TSIZE(Type)*Index
   fi
*/

static void BuildDynamicArray (void)
{
  unsigned int combinedTok;
  unsigned int arrayTok;
  unsigned int indexTok;
  unsigned int Sym;
  unsigned int idx;
  unsigned int Type;
  unsigned int Adr;
  unsigned int ArraySym;
  unsigned int BackEndType;
  unsigned int UnboundedType;
  unsigned int PtrToBase;
  unsigned int Base;
  unsigned int Dim;
  unsigned int rw;
  unsigned int ti;
  unsigned int tj;
  unsigned int tk;
  unsigned int tka;

  M2Quads_DisplayStack ();
  Sym = static_cast<unsigned int> (M2Quads_OperandT (2));
  Type = SymbolTable_SkipType (M2Quads_OperandF (2));
  arrayTok = static_cast<unsigned int> (M2Quads_OperandTok (2));
  indexTok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  combinedTok = M2LexBuf_MakeVirtualTok (arrayTok, arrayTok, indexTok);
  Dim = static_cast<unsigned int> (OperandD (2));
  rw = static_cast<unsigned int> (OperandMergeRW (2));
  M2Debug_Assert (SymbolTable_IsLegal (rw));
  Dim += 1;
  if (Dim == 1)
    {
      /* 
         Base has type address since
         BuildDesignatorRecord references by address.

         Build a record for retrieving the address of dynamic array.
         BuildDesignatorRecord will generate the required quadruples,
         therefore build sets up the stack for BuildDesignatorRecord
         which will generate the quads to access the record.
  */
      ArraySym = Sym;
      UnboundedType = SymbolTable_GetUnboundedRecordType (SymbolTable_GetSType (Sym));
      PushTFrwtok (Sym, UnboundedType, rw, arrayTok);
      M2Quads_PushTF (SymbolTable_GetUnboundedAddressOffset (SymbolTable_GetSType (Sym)), SymbolTable_GetSType (SymbolTable_GetUnboundedAddressOffset (SymbolTable_GetSType (Sym))));
      M2Quads_PushT (static_cast<unsigned int> (1));  /* One record field to dereference  */
      M2Quads_BuildDesignatorRecord (combinedTok);  /* One record field to dereference  */
      M2Quads_PopT (&PtrToBase);
      M2Quads_DisplayStack ();
      /* Now actually copy Unbounded.ArrayAddress into base  */
      if ((SymbolTable_GetMode (PtrToBase)) == SymbolTable_LeftValue)
        {
          Base = SymbolTable_MakeTemporary (arrayTok, SymbolTable_RightValue);
          SymbolTable_PutVar (Base, M2System_Address);  /* has type ADDRESS  */
          CheckPointerThroughNil (arrayTok, PtrToBase);  /* has type ADDRESS  */
          GenQuad (M2Quads_IndrXOp, Base, M2System_Address, PtrToBase);  /* Base = *PtrToBase  */
        }
      else
        {
          M2Debug_Assert ((SymbolTable_GetMode (PtrToBase)) != SymbolTable_ImmediateValue);
          Base = PtrToBase;
        }
    }
  else
    {
      /* Base already calculated previously and pushed to stack  */
      UnboundedType = SymbolTable_SkipType (M2Quads_OperandF (2));
      Base = Sym;
      ArraySym = static_cast<unsigned int> (M2Quads_OperandA (2));
    }
  M2Debug_Assert ((SymbolTable_GetSType (Sym)) == Type);
  ti = calculateMultipicand (indexTok, Sym, Type, Dim);
  idx = static_cast<unsigned int> (M2Quads_OperandT (1));
  if ((SymbolTable_IsConst (idx)) && (SymbolTable_IsConst (ti)))
    {
      /* tj has no type since constant  */
      tj = SymbolTable_MakeTemporary (indexTok, SymbolTable_ImmediateValue);
      tk = SymbolTable_MakeTemporary (indexTok, SymbolTable_ImmediateValue);
      SymbolTable_PutVar (tj, M2Base_Cardinal);
      SymbolTable_PutVar (tk, M2Base_Cardinal);
    }
  else
    {
      /* tj has Cardinal type since we have multiplied array indices  */
      tj = SymbolTable_MakeTemporary (indexTok, SymbolTable_RightValue);
      if ((SymbolTable_GetSType (idx)) != M2Base_Cardinal)
        {
          M2Quads_PushTF (SymbolTable_RequestSym (indexTok, NameKey_MakeKey ((const char *) "CONVERT", 7)), static_cast<unsigned int> (SymbolTable_NulSym));
          M2Quads_PushT (M2Base_Cardinal);
          M2Quads_PushTtok (idx, indexTok);
          M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
          BuildConvertFunction (M2Base_Convert, false);  /* Two parameters  */
          M2Quads_PopT (&idx);
        }
      SymbolTable_PutVar (tj, M2Base_Cardinal);
      tk = SymbolTable_MakeTemporary (indexTok, SymbolTable_RightValue);
      SymbolTable_PutVar (tk, M2Base_Cardinal);
    }
  BuildRange (M2Range_InitDynamicArraySubscriptRangeCheck (ArraySym, idx, Dim));
  M2Quads_PushTtok (tj, indexTok);
  M2Quads_PushTtok (idx, indexTok);
  BuildAssignmentWithoutBounds (indexTok, false, true);
  GenQuad (M2Quads_MultOp, tk, ti, tj);
  Adr = SymbolTable_MakeTemporary (combinedTok, SymbolTable_LeftValue);
  SymbolTable_PutVarArrayRef (Adr, true);
  /* 
      Ok must reference by address
      - but we contain the type of the referenced entity
  */
  BackEndType = SymbolTable_MakePointer (combinedTok, NameKey_NulName);
  SymbolTable_PutPointer (BackEndType, SymbolTable_GetSType (Type));
  /* Create a temporary pointer for addition.  */
  tka = ConvertToAddress (combinedTok, tk);
  if (Dim == (SymbolTable_GetDimension (Type)))
    {
      SymbolTable_PutLeftValueFrontBackType (Adr, SymbolTable_GetSType (Type), BackEndType);
      GenQuadOtok (combinedTok, M2Quads_AddOp, Adr, Base, tka, false, combinedTok, combinedTok, combinedTok);
      M2Quads_PopN (2);
      PushTFADrwtok (Adr, SymbolTable_GetSType (Adr), ArraySym, Dim, rw, combinedTok);
    }
  else
    {
      /* more to index  */
      SymbolTable_PutLeftValueFrontBackType (Adr, Type, BackEndType);
      GenQuadOtok (combinedTok, M2Quads_AddOp, Adr, Base, tka, false, combinedTok, combinedTok, combinedTok);
      M2Quads_PopN (2);
      PushTFADrwtok (Adr, SymbolTable_GetSType (Adr), ArraySym, Dim, rw, combinedTok);
    }
}


/*
   DebugLocation -
*/

static void DebugLocation (unsigned int tok, const char *message_, unsigned int _message_high)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (DebugTokPos)
    {
      M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) message, _message_high), tok);
    }
}


/*
   PushWith - pushes sym and type onto the with stack. It checks for
              previous declaration of this record type.
*/

static void PushWith (unsigned int Sym, unsigned int Type, unsigned int Ref, unsigned int Tok)
{
  unsigned int i;
  unsigned int n;
  M2Quads_WithFrame f;

  if (M2Options_Pedantic)
    {
      n = M2StackAddress_NoOfItemsInStackAddress (WithStack);
      i = 1;  /* Top of the stack.  */
      /* Search for other declarations of the with using Type.  */
      while (i <= n)
        {
          f = static_cast<M2Quads_WithFrame> (M2StackAddress_PeepAddress (WithStack, i));
          if (f->RecordSym == Type)
            {
              M2MetaError_MetaErrorT1 (Tok, (const char *) "cannot have nested {%kWITH} statements referencing the same {%kRECORD} {%1Ead}", 78, Sym);
              M2MetaError_MetaErrorT1 (f->RecordTokPos, (const char *) "cannot have nested {%kWITH} statements referencing the same {%kRECORD} {%1Ead}", 78, f->RecordSym);
            }
          i += 1;
        }
    }
  Storage_ALLOCATE ((void **) &f, sizeof (M2Quads__T4));
  f->RecordSym = Sym;
  f->RecordType = Type;
  f->RecordRef = Ref;
  f->rw = Sym;
  f->RecordTokPos = Tok;
  M2StackAddress_PushAddress (WithStack, reinterpret_cast <void *> (f));
}

static void PopWith (void)
{
  M2Quads_WithFrame f;

  f = static_cast<M2Quads_WithFrame> (M2StackAddress_PopAddress (WithStack));
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T4));
}


/*
   BuildAccessWithField - similar to BuildDesignatorRecord except it
                          does not perform the address operation.
                          The address will have been computed at the
                          beginning of the WITH statement.
                          It also stops the GenQuad procedure from examining the
                          with stack.

                          The Stack

                          Entry

                   Ptr ->
                          +--------------+
                          | Field | Type1|                          <- Ptr
                          |-------|------|          +-------------+
                          | Adr   | Type2|          | Sym  | Type1|
                          |--------------|          |-------------|
*/

static void BuildAccessWithField (void)
{
  unsigned int rectok;
  unsigned int fieldtok;
  bool OldSuppressWith;
  unsigned int rw;
  unsigned int Field;
  unsigned int FieldType;
  unsigned int Record;
  unsigned int RecordType;
  unsigned int Ref;

  OldSuppressWith = SuppressWith;
  SuppressWith = true;
  /* 
      now the WITH cannot look at the stack of outstanding WITH records.
  */
  M2Quads_PopTFtok (&Field, &FieldType, &fieldtok);
  PopTFrwtok (&Record, &RecordType, &rw, &rectok);
  Ref = SymbolTable_MakeComponentRef (SymbolTable_MakeComponentRecord (fieldtok, SymbolTable_RightValue, Record), Field);
  SymbolTable_PutVarConst (Ref, IsReadOnly (Record));
  GenQuadO (fieldtok, M2Quads_RecordFieldOp, Ref, Record, Field, true);
  PushTFrwtok (Ref, FieldType, rw, fieldtok);
  SuppressWith = OldSuppressWith;
}


/*
   PushConstructor -
*/

static void PushConstructor (unsigned int sym)
{
  M2Quads_ConstructorFrame c;

  Storage_ALLOCATE ((void **) &c, sizeof (M2Quads__T1));
  c->type = SymbolTable_SkipType (sym);
  c->index = 1;
  M2StackAddress_PushAddress (ConstructorStack, reinterpret_cast <void *> (c));
}


/*
   AddFieldTo - adds field, e, to, value.
*/

static unsigned int AddFieldTo (unsigned int value, unsigned int e)
{
  if (SymbolTable_IsSet (SymbolTable_GetDType (value)))
    {
      SymbolTable_PutConstSet (value);
      M2Quads_PushT (value);
      M2Quads_PushT (e);
      M2Quads_BuildInclBit ();
      M2Quads_PopT (&value);
    }
  else
    {
      SymbolTable_PushValue (value);
      M2ALU_AddField (M2LexBuf_GetTokenNo (), e);
      SymbolTable_PopValue (value);
    }
  return value;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckLogicalOperator - returns a logical operator if the operands imply
                          a logical operation should be performed.
*/

static NameKey_Name CheckLogicalOperator (NameKey_Name Tok, unsigned int left, unsigned int lefttype)
{
  if ((((Tok == M2Reserved_PlusTok) || (Tok == M2Reserved_TimesTok)) || (Tok == M2Reserved_DivideTok)) || (Tok == M2Reserved_MinusTok))
    {
      /* --fixme-- when we add complex arithmetic, we must check constructor is not a complex constant.  */
      if ((((lefttype != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_SkipType (lefttype)))) || (SymbolTable_IsConstSet (left))) || (SymbolTable_IsConstructor (left)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if (Tok == M2Reserved_PlusTok)
            {
              return LogicalOrTok;
            }
          else if (Tok == M2Reserved_DivideTok)
            {
              /* avoid dangling else.  */
              return LogicalXorTok;
            }
          else if (Tok == M2Reserved_TimesTok)
            {
              /* avoid dangling else.  */
              return LogicalAndTok;
            }
          else if (Tok == M2Reserved_MinusTok)
            {
              /* avoid dangling else.  */
              return LogicalDifferenceTok;
            }
        }
    }
  return Tok;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckDivModRem - initiates calls to check the divisor for DIV, MOD, REM
                    expressions.
*/

static void CheckDivModRem (unsigned int TokPos, NameKey_Name tok, unsigned int d, unsigned int e)
{
  if (tok == M2Reserved_DivTok)
    {
      BuildRange (M2Range_InitWholeZeroDivisionCheck (TokPos, d, e));
    }
  else if (tok == M2Reserved_ModTok)
    {
      /* avoid dangling else.  */
      BuildRange (M2Range_InitWholeZeroDivisionCheck (TokPos, d, e));
    }
  else if (tok == M2Reserved_RemTok)
    {
      /* avoid dangling else.  */
      BuildRange (M2Range_InitWholeZeroRemainderCheck (TokPos, d, e));
    }
}


/*
   doConvert - convert, sym, to a new symbol with, type.
               Return the new symbol.
*/

static unsigned int doConvert (unsigned int type, unsigned int sym)
{
  if ((SymbolTable_GetSType (sym)) != type)
    {
      M2Quads_PushTF (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym));
      M2Quads_PushT (type);
      M2Quads_PushT (sym);
      M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters  */
      BuildConvertFunction (M2Base_Convert, false);  /* Two parameters  */
      M2Quads_PopT (&sym);
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doBuildBinaryOp - build the binary op, with or without type
                     checking.
*/

static void doBuildBinaryOp (bool checkTypes, bool checkOverflow)
{
  DynamicStrings_String s;
  NameKey_Name NewOp;
  NameKey_Name Operator;
  unsigned int OperatorPos;
  unsigned int OldPos;
  unsigned int leftrw;
  unsigned int rightrw;
  unsigned int t1;
  unsigned int f1;
  unsigned int t2;
  unsigned int f2;
  unsigned int lefttype;
  unsigned int righttype;
  unsigned int left;
  unsigned int right;
  unsigned int leftpos;
  unsigned int rightpos;
  unsigned int value;

  Operator = static_cast<NameKey_Name> (M2Quads_OperandT (2));
  if (Operator == M2Reserved_OrTok)
    {
      CheckBooleanId ();
      PopBooltok (&t1, &f1, &rightpos);
      M2Quads_PopTtok (&Operator, &OperatorPos);
      PopBooltok (&t2, &f2, &leftpos);
      M2Debug_Assert (f2 == 0);
      OperatorPos = M2LexBuf_MakeVirtualTok (OperatorPos, leftpos, rightpos);
      PushBooltok (Merge (t1, t2), f1, OperatorPos);
    }
  else if ((Operator == M2Reserved_AndTok) || (Operator == M2Reserved_AmbersandTok))
    {
      /* avoid dangling else.  */
      CheckBooleanId ();
      PopBooltok (&t1, &f1, &rightpos);
      M2Quads_PopTtok (&Operator, &OperatorPos);
      PopBooltok (&t2, &f2, &leftpos);
      M2Debug_Assert (t2 == 0);
      OperatorPos = M2LexBuf_MakeVirtualTok (OperatorPos, leftpos, rightpos);
      PushBooltok (t1, Merge (f1, f2), OperatorPos);
    }
  else
    {
      /* avoid dangling else.  */
      PopTFrwtok (&right, &righttype, &rightrw, &rightpos);
      M2Quads_PopTtok (&Operator, &OperatorPos);
      PopTFrwtok (&left, &lefttype, &leftrw, &leftpos);
      MarkAsRead (rightrw);
      MarkAsRead (leftrw);
      NewOp = CheckLogicalOperator (Operator, left, lefttype);  /* right, righttype,  */
      if (NewOp == Operator)
        {
          /* avoid dangling else.  */
          /* 
            BinaryOps and UnaryOps only work with immediate and
            offset addressing.  This is fine for calculating
            array and record offsets but we need to get the real
            values to perform normal arithmetic. Not address
            arithmetic.

            However the set operators will dereference LValues
            (to optimize large set arithemetic)
  */
          if ((SymbolTable_GetMode (right)) == SymbolTable_LeftValue)
            {
              value = SymbolTable_MakeTemporary (rightpos, SymbolTable_RightValue);
              SymbolTable_PutVar (value, righttype);
              CheckPointerThroughNil (rightpos, right);
              doIndrX (rightpos, value, right);
              right = value;
            }
          if ((SymbolTable_GetMode (left)) == SymbolTable_LeftValue)
            {
              value = SymbolTable_MakeTemporary (leftpos, SymbolTable_RightValue);
              SymbolTable_PutVar (value, lefttype);
              CheckPointerThroughNil (leftpos, left);
              doIndrX (leftpos, value, left);
              left = value;
            }
        }
      /* CheckForGenericNulSet(e1, e2, t1, t2)  */
      OldPos = OperatorPos;
      OperatorPos = M2LexBuf_MakeVirtualTok (OperatorPos, leftpos, rightpos);
      if (((Operator == M2Reserved_PlusTok) && (SymbolTable_IsConstString (left))) && (SymbolTable_IsConstString (right)))
        {
          value = SymbolTable_MakeConstString (OperatorPos, NameKey_NulName);
          SymbolTable_PutConstStringKnown (OperatorPos, value, NameKey_NulName, false, false);
          GenQuadOtok (OperatorPos, MakeOp (M2Reserved_PlusTok), value, left, right, false, OperatorPos, leftpos, rightpos);
        }
      else
        {
          if (checkTypes)
            {
              BuildRange (M2Range_InitTypesExpressionCheck (OperatorPos, left, right, false, false));
            }
          value = SymbolTable_MakeTemporaryFromExpressions (OperatorPos, right, left, AreConstant ((SymbolTable_IsConst (left)) && (SymbolTable_IsConst (right))));
          CheckDivModRem (OperatorPos, NewOp, value, right);
          if (DebugTokPos)
            {
              s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (M2LexBuf_GetTokenName (Operator)));
              M2Error_WarnStringAt (s, OldPos);
              s = DynamicStrings_InitString ((const char *) "left", 4);
              M2Error_WarnStringAt (s, leftpos);
              s = DynamicStrings_InitString ((const char *) "right", 5);
              M2Error_WarnStringAt (s, rightpos);
              s = DynamicStrings_InitString ((const char *) "caret", 5);
              M2Error_WarnStringAt (s, OldPos);
              s = DynamicStrings_InitString ((const char *) "combined", 8);
              M2Error_WarnStringAt (s, OperatorPos);
            }
          /* MetaErrorT1 (GetDeclaredMod (t), 'in binary with a {%1a}', t)  */
          GenQuadOtok (OperatorPos, MakeOp (NewOp), value, left, right, checkOverflow, OperatorPos, leftpos, rightpos);
        }
      M2Quads_PushTFtok (value, SymbolTable_GetSType (value), OperatorPos);
    }
}


/*
   AreConstant - returns immediate addressing mode if b is true else
                 offset mode is returned. b determines whether the
                 operands are all constant - in which case we can use
                 a constant temporary variable.
*/

static SymbolTable_ModeOfAddr AreConstant (bool b)
{
  if (b)
    {
      return SymbolTable_ImmediateValue;
    }
  else
    {
      return SymbolTable_RightValue;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertBooleanToVariable - converts a BoolStack(i) from a Boolean True|False
                              exit pair into a variable containing the value TRUE or
                              FALSE.  The parameter i is relative to the top
                              of the stack.
*/

static void ConvertBooleanToVariable (unsigned int tok, unsigned int i)
{
  unsigned int Des;
  M2Quads_BoolFrame f;

  M2Debug_Assert (IsBoolean (i));
  /* We need to convert the boolean top of stack into a variable or
      constant boolean.  */
  Des = SymbolTable_MakeTemporary (tok, AreConstant (M2Quads_IsInConstExpression ()));
  SymbolTable_PutVar (Des, M2Base_Boolean);
  SymbolTable_PutVarConditional (Des, true);
  M2Quads_PushTtok (Des, tok);  /* we have just increased the stack so we must use i+1  */
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, i+1));  /* we have just increased the stack so we must use i+1  */
  PushBool (f->TrueExit, f->FalseExit);
  BuildAssignmentWithoutBounds (tok, false, true);
  /* Restored stack after the BuildAssign... above.  */
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, i));
  f->TrueExit = Des;  /* Alter Stack(i) to contain the variable.  */
  f->FalseExit = M2Base_Boolean;  /* Alter Stack(i) to contain the variable.  */
  f->BooleanOp = false;  /* No longer a Boolean True|False pair.  */
  f->Unbounded = SymbolTable_NulSym;  /* No longer a Boolean True|False pair.  */
  f->Dimension = 0;
  f->ReadWrite = SymbolTable_NulSym;
  f->tokenno = tok;
  f->Annotation = DynamicStrings_KillString (f->Annotation);
  f->Annotation = DynamicStrings_InitString ((const char *) "%1s(%1d)|%2s(%2d)||boolean var|type", 35);
  f->RangeDep = 0;
}


/*
   DumpQuadSummary -
*/

static void DumpQuadSummary (unsigned int quad)
{
  M2Quads_QuadFrame f;

  if (quad != 0)
    {
      f = GetQF (quad);
      M2Printf_printf2 ((const char *) "%d  op3 = %d\\n", 14, (const unsigned char *) &quad, (sizeof (quad)-1), (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
    }
}


/*
   BuildRelOpFromBoolean - builds a relational operator sequence of quadruples
                           instead of using a temporary boolean variable.
                           This function can only be used when we perform
                           the following translation:

                           (a=b) # (c=d)  alternatively   (a=b) = (c=d)
                                 ^                              ^

                           it only allows # = to be used as >= <= > < all
                           assume a particular value for TRUE and FALSE.
                           (In which case the user should specify ORD)


                           before

                           q      if r1      op1     op2     t2
                           q+1    Goto                       f2
                           ...
                           q+n    if r2      op3     op4     t1
                           q+n+1  Goto                       f1

                           after (in case of =)

                           q    if r1      op1     op2     q+2
                           q+1  Goto                       q+4
                           q+2  if r2      op3     op4     t
                           q+3  Goto                       f
                           q+4  if r2      op3     op4     f
                           q+5  Goto                       t

                           after (in case of #)

                           q      if r1      op1     op2     q+2
                           q+1    Goto                       q+n+2
                           q+2    ...
                           ...    ...
                           q+n    if r2      op3     op4     f
                           q+n+1  Goto                       t
                           q+n+2  if r2      op3     op4     t
                           q+n+3  Goto                       f

                           The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                    Ptr ->
                           +------------+
                           | t1 | f1    |
                           |------------|
                           | Operator   |                          <- Ptr
                           |------------|          +------------+
                           | t2 | f2    |          | t    | f   |
                           |------------|          |------------|


*/

static void BuildRelOpFromBoolean (unsigned int tokpos)
{
  unsigned int Tok;
  unsigned int t1;
  unsigned int f1;
  unsigned int t2;
  unsigned int f2;
  M2Quads_QuadFrame f;

  M2Debug_Assert ((IsBoolean (1)) && (IsBoolean (3)));
  if ((M2Quads_OperandT (2)) == M2Reserved_EqualTok)
    {
      /* Are the two boolean expressions the same?  */
      PopBool (&t1, &f1);
      M2Quads_PopT (&Tok);
      PopBool (&t2, &f2);
      /* Give the false exit a second chance.  */
      BackPatch (t2, t1);  /* q    if   _     _    q+2  */
      BackPatch (f2, NextQuad);  /* q+1  if   _     _    q+4  */
      M2Debug_Assert (NextQuad == (f1+1));  /* q+1  if   _     _    q+4  */
      f = GetQF (t1);
      GenQuadO (tokpos, f->Operator, f->Operand1, f->Operand2, 0, false);
      GenQuadO (tokpos, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0, false);
      PushBooltok (Merge (NextQuad-1, t1), Merge (NextQuad-2, f1), tokpos);
    }
  else if (((M2Quads_OperandT (2)) == M2Reserved_HashTok) || ((M2Quads_OperandT (2)) == M2Reserved_LessGreaterTok))
    {
      /* avoid dangling else.  */
      if (M2Options_CompilerDebugging)
        {
          M2Printf_printf0 ((const char *) "BuildRelOpFromBoolean (NotEqualTok)\\n", 37);
          M2Quads_DisplayStack ();
        }
      /* Are the two boolean expressions different?  */
      PopBool (&t1, &f1);
      M2Quads_PopT (&Tok);
      PopBool (&t2, &f2);
      if (M2Options_CompilerDebugging)
        {
          M2Printf_printf2 ((const char *) "t1 = %d, f1 = %d\\n", 18, (const unsigned char *) &t1, (sizeof (t1)-1), (const unsigned char *) &f1, (sizeof (f1)-1));
          M2Printf_printf2 ((const char *) "t2 = %d, f2 = %d\\n", 18, (const unsigned char *) &t2, (sizeof (t2)-1), (const unsigned char *) &f2, (sizeof (f2)-1));
          DumpQuadSummary (t1);
          DumpQuadSummary (f1);
          DumpQuadSummary (t2);
          DumpQuadSummary (f2);
        }
      /* Give the false exit a second chance.  */
      BackPatch (t2, t1);  /* q    if   _     _    q+2  */
      BackPatch (f2, NextQuad);  /* q+1  if   _     _    q+4  */
      M2Debug_Assert (NextQuad == (f1+1));  /* q+1  if   _     _    q+4  */
      f = GetQF (t1);
      GenQuadO (tokpos, f->Operator, f->Operand1, f->Operand2, 0, false);
      GenQuadO (tokpos, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0, false);
      PushBooltok (Merge (NextQuad-2, f1), Merge (NextQuad-1, t1), tokpos);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError0 ((const char *) "only allowed to use the relation operators {%Ek=} {%Ek#} rather than {%Ek<} or {%Ek>} on {%EkBOOLEAN} expressions as these do not imply an ordinal value for {%kTRUE} or {%kFALSE}", 178);
    }
}


/*
   CheckVariableOrConstantOrProcedure - checks to make sure sym is a variable, constant or procedure.
*/

static void CheckVariableOrConstantOrProcedure (unsigned int tokpos, unsigned int sym)
{
  unsigned int type;

  type = SymbolTable_GetSType (sym);
  if (SymbolTable_IsUnknown (sym))
    {
      M2MetaError_MetaErrorT1 (tokpos, (const char *) "{%1EUad} has not been declared", 30, sym);
      SymbolTable_UnknownReported (sym);
    }
  else if ((M2System_IsPseudoSystemFunction (sym)) || (M2Base_IsPseudoBaseFunction (sym)))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (tokpos, (const char *) "{%1Ead} expected a variable, procedure, constant or expression, not an intrinsic procedure function", 99, sym);
    }
  else if (((((! (SymbolTable_IsConst (sym))) && (! (SymbolTable_IsVar (sym)))) && (! (SymbolTable_IsProcedure (sym)))) && (! (SymbolTable_IsTemporary (sym)))) && ! MustNotCheckBounds)
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorsT1 (tokpos, (const char *) "{%1Ead} expected a variable, procedure, constant or expression", 62, (const char *) "and it was declared as a {%1Dd}", 31, sym);
    }
  else if ((type != SymbolTable_NulSym) && (SymbolTable_IsArray (type)))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorsT1 (tokpos, (const char *) "{%1EU} not expecting an array variable as an operand for either comparison or binary operation", 94, (const char *) "it was declared as a {%1Dd}", 27, sym);
    }
  else if (((SymbolTable_IsConstString (sym)) && (SymbolTable_IsConstStringKnown (sym))) && ((SymbolTable_GetStringLength (tokpos, sym)) > 1))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorT1 (tokpos, (const char *) "{%1EU} not expecting a string constant as an operand for either comparison or binary operation", 94, sym);
    }
}


/*
   MakeOp - returns the equalent quadruple operator to a token, t.
*/

static M2Quads_QuadOperator MakeOp (NameKey_Name t)
{
  if (t == ArithPlusTok)
    {
      return M2Quads_ArithAddOp;
    }
  else if (t == M2Reserved_PlusTok)
    {
      /* avoid dangling else.  */
      return M2Quads_AddOp;
    }
  else if (t == M2Reserved_MinusTok)
    {
      /* avoid dangling else.  */
      return M2Quads_SubOp;
    }
  else if (t == M2Reserved_DivTok)
    {
      /* avoid dangling else.  */
      return M2Quads_DivM2Op;
    }
  else if (t == M2Reserved_DivideTok)
    {
      /* avoid dangling else.  */
      return M2Quads_DivTruncOp;
    }
  else if (t == M2Reserved_RemTok)
    {
      /* avoid dangling else.  */
      return M2Quads_ModTruncOp;
    }
  else if (t == M2Reserved_ModTok)
    {
      /* avoid dangling else.  */
      return M2Quads_ModM2Op;
    }
  else if (t == M2Reserved_TimesTok)
    {
      /* avoid dangling else.  */
      return M2Quads_MultOp;
    }
  else if (t == M2Reserved_HashTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfNotEquOp;
    }
  else if (t == M2Reserved_LessGreaterTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfNotEquOp;
    }
  else if (t == M2Reserved_GreaterEqualTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfGreEquOp;
    }
  else if (t == M2Reserved_LessEqualTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfLessEquOp;
    }
  else if (t == M2Reserved_EqualTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfEquOp;
    }
  else if (t == M2Reserved_LessTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfLessOp;
    }
  else if (t == M2Reserved_GreaterTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfGreOp;
    }
  else if (t == M2Reserved_InTok)
    {
      /* avoid dangling else.  */
      return M2Quads_IfInOp;
    }
  else if (t == LogicalOrTok)
    {
      /* avoid dangling else.  */
      return M2Quads_LogicalOrOp;
    }
  else if (t == LogicalAndTok)
    {
      /* avoid dangling else.  */
      return M2Quads_LogicalAndOp;
    }
  else if (t == LogicalXorTok)
    {
      /* avoid dangling else.  */
      return M2Quads_LogicalXorOp;
    }
  else if (t == LogicalDifferenceTok)
    {
      /* avoid dangling else.  */
      return M2Quads_LogicalDiffOp;
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "binary operation not implemented yet", 36);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Quads.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GenQuadO - generate a quadruple with Operation, Op1, Op2, Op3, overflow.
*/

static void GenQuadO (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow)
{
  GenQuadOTrash (TokPos, Operation, Op1, Op2, Op3, overflow, SymbolTable_NulSym);
}


/*
   GenQuadOTrash - generate a quadruple with Operation, Op1, Op2, Op3, overflow.
*/

static void GenQuadOTrash (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow, unsigned int trash)
{
  M2Quads_QuadFrame f;

  /* WriteString('Potential Quad: ') ;  */
  if (QuadrupleGeneration)
    {
      if (NextQuad != Head)
        {
          f = GetQF (NextQuad-1);
          f->Next = NextQuad;
        }
      PutQuadO (NextQuad, Operation, Op1, Op2, Op3, overflow);
      f = GetQF (NextQuad);
      f->Trash = trash;
      f->Next = 0;
      f->LineNo = M2LexBuf_GetLineNo ();
      if (TokPos == M2LexBuf_UnknownTokenNo)
        {
          f->TokenNo = M2LexBuf_GetTokenNo ();
        }
      else
        {
          f->TokenNo = TokPos;
        }
      if (M2Options_GetDebugTraceQuad ())
        {
          M2Printf_printf0 ((const char *) "generating: ", 12);
          M2Quads_DisplayQuad (NextQuad);
        }
      /* MetaErrorT1 (TokenNo, '{%1On}', NextQuad)  */
      CheckBreak (NextQuad);
      NewQuad (&NextQuad);
    }
}


/*
   GenQuad - Generate a quadruple with Operation, Op1, Op2, Op3.
*/

static void GenQuad (M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3)
{
  GenQuadO (M2LexBuf_UnknownTokenNo, Operation, Op1, Op2, Op3, true);
}


/*
   GenQuadOtok - generate a quadruple with Operation, Op1, Op2, Op3, overflow.
*/

static void GenQuadOtok (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos)
{
  GenQuadOTypetok (TokPos, Operation, Op1, Op2, Op3, overflow, true, Op1Pos, Op2Pos, Op3Pos);
}


/*
   GenQuadOTypetok - assigns the fields of the quadruple with
                     the parameters.
*/

static void GenQuadOTypetok (unsigned int TokPos, M2Quads_QuadOperator Operation, unsigned int Op1, unsigned int Op2, unsigned int Op3, bool overflow, bool typecheck, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos)
{
  M2Quads_QuadFrame f;

  /* WriteString('Potential Quad: ') ;  */
  if (QuadrupleGeneration)
    {
      if (NextQuad != Head)
        {
          f = GetQF (NextQuad-1);
          f->Next = NextQuad;
        }
      PutQuadOType (NextQuad, Operation, Op1, Op2, Op3, overflow, typecheck);
      f = GetQF (NextQuad);
      f->Next = 0;
      f->LineNo = M2LexBuf_GetLineNo ();
      if (TokPos == M2LexBuf_UnknownTokenNo)
        {
          f->TokenNo = M2LexBuf_GetTokenNo ();
        }
      else
        {
          f->TokenNo = TokPos;
        }
      f->op1pos = Op1Pos;
      f->op2pos = Op2Pos;
      f->op3pos = Op3Pos;
      if (M2Options_GetDebugTraceQuad ())
        {
          M2Printf_printf0 ((const char *) "generating: ", 12);
          M2Quads_DisplayQuad (NextQuad);
        }
      /* MetaErrorT1 (TokenNo, '{%1On}', NextQuad)  */
      CheckBreak (NextQuad);
      NewQuad (&NextQuad);
    }
}


/*
   DumpUntil - dump all quadruples until we seen the ending quadruple
               with procsym in the third operand.
               Return the quad number containing the match.
*/

static unsigned int DumpUntil (M2Quads_QuadOperator ending, unsigned int procsym, unsigned int quad)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;
  M2Quads_QuadFrame f;

  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n...\\n\\n", 9);
  do {
    M2Quads_GetQuad (quad, &op, &op1, &op2, &op3);
    M2Quads_DisplayQuad (quad);
    f = GetQF (quad);
    quad = f->Next;
  } while (! ((op == ending) && (op3 == procsym)));
  return quad;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCtorInit - return the init procedure for the module.
*/

static unsigned int GetCtorInit (unsigned int sym)
{
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  SymbolTable_GetModuleCtors (sym, &ctor, &init, &fini, &dep);
  return init;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCtorFini - return the fini procedure for the module.
*/

static unsigned int GetCtorFini (unsigned int sym)
{
  unsigned int ctor;
  unsigned int init;
  unsigned int fini;
  unsigned int dep;

  SymbolTable_GetModuleCtors (sym, &ctor, &init, &fini, &dep);
  return fini;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DumpQuadrupleFilter -
*/

static void DumpQuadrupleFilter (void)
{
  M2Quads_QuadFrame f;
  unsigned int i;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  i = Head;
  while (i != 0)
    {
      M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
      if ((op == M2Quads_ProcedureScopeOp) && (M2LangDump_IsDumpRequired (op3, true)))
        {
          i = DumpUntil (M2Quads_KillLocalVarOp, op3, i);
        }
      else if ((op == M2Quads_InitStartOp) && (M2LangDump_IsDumpRequired (GetCtorInit (op3), true)))
        {
          /* avoid dangling else.  */
          i = DumpUntil (M2Quads_InitEndOp, op3, i);
        }
      else if ((op == M2Quads_FinallyStartOp) && (M2LangDump_IsDumpRequired (GetCtorFini (op3), true)))
        {
          /* avoid dangling else.  */
          i = DumpUntil (M2Quads_FinallyEndOp, op3, i);
        }
      else
        {
          /* avoid dangling else.  */
          f = GetQF (i);
          i = f->Next;
        }
    }
}


/*
   DumpQuadrupleAll - dump all quadruples.
*/

static void DumpQuadrupleAll (void)
{
  M2Quads_QuadFrame f;
  unsigned int i;

  i = Head;
  while (i != 0)
    {
      M2Quads_DisplayQuad (i);
      f = GetQF (i);
      i = f->Next;
    }
}


/*
   BackPatch - Makes each of the quadruples on the list pointed to by
               QuadNo take quadruple Value as a target.
*/

static void BackPatch (unsigned int QuadNo, unsigned int Value)
{
  unsigned int i;
  M2Quads_QuadFrame f;

  if (QuadrupleGeneration)
    {
      while (QuadNo != 0)
        {
          f = GetQF (QuadNo);
          i = f->Operand3;  /* Next Link along the BackPatch  */
          ManipulateReference (QuadNo, Value);  /* Filling in the BackPatch.  */
          QuadNo = i;
        }
    }
}


/*
   Merge - joins two quad lists, QuadList2 to the end of QuadList1.
           A QuadList of value zero is a nul list.
*/

static unsigned int Merge (unsigned int QuadList1, unsigned int QuadList2)
{
  unsigned int i;
  unsigned int j;
  M2Quads_QuadFrame f;

  if (QuadList1 == 0)
    {
      return QuadList2;
    }
  else if (QuadList2 == 0)
    {
      /* avoid dangling else.  */
      return QuadList1;
    }
  else
    {
      /* avoid dangling else.  */
      i = QuadList1;
      do {
        j = i;
        f = GetQF (i);
        i = f->Operand3;
      } while (! (i == 0));
      ManipulateReference (j, QuadList2);
      return QuadList1;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisplayProcedureAttributes -
*/

static void DisplayProcedureAttributes (unsigned int proc)
{
  if (SymbolTable_IsCtor (proc))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " (ctor)", 7);
    }
  if (SymbolTable_IsPublic (proc))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " (public)", 9);
    }
  if (SymbolTable_IsExtern (proc))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " (extern)", 9);
    }
  if (SymbolTable_IsMonoName (proc))
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " (mononame)", 11);
    }
}


/*
   WriteQuad - Writes out the Quad BufferQuad.
*/

static void WriteQuad (unsigned int BufferQuad)
{
  NameKey_Name n1;
  NameKey_Name n2;
  M2Quads_QuadFrame f;
  NameKey_Name n;
  unsigned int l;

  f = GetQF (BufferQuad);
  M2Quads_WriteOperator (f->Operator);
  M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) " [%d]", 5, (const unsigned char *) &f->NoOfTimesReferenced, (sizeof (f->NoOfTimesReferenced)-1));
  if (f->ConstExpr)
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) " const ", 7);
    }
  else
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "       ", 7);
    }
  switch (f->Operator)
    {
      case M2Quads_LastForIteratorOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand2);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_HighOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "  %4d  ", 7, (const unsigned char *) &f->Operand2, (sizeof (f->Operand2)-1));
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_InitAddressOp:
      case M2Quads_SavePriorityOp:
      case M2Quads_RestorePriorityOp:
      case M2Quads_SubrangeLowOp:
      case M2Quads_SubrangeHighOp:
      case M2Quads_BecomesOp:
      case M2Quads_InclOp:
      case M2Quads_ExclOp:
      case M2Quads_UnboundedOp:
      case M2Quads_ReturnValueOp:
      case M2Quads_FunctValueOp:
      case M2Quads_NegateOp:
      case M2Quads_AddrOp:
      case M2Quads_StringConvertCnulOp:
      case M2Quads_StringConvertM2nulOp:
      case M2Quads_StringLengthOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_ElementSizeOp:
      case M2Quads_IfInOp:
      case M2Quads_IfNotInOp:
      case M2Quads_IfNotEquOp:
      case M2Quads_IfEquOp:
      case M2Quads_IfLessOp:
      case M2Quads_IfGreOp:
      case M2Quads_IfLessEquOp:
      case M2Quads_IfGreEquOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand2);
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "  %4d", 5, (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_InlineOp:
      case M2Quads_RetryOp:
      case M2Quads_TryOp:
      case M2Quads_GotoOp:
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%4d", 3, (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_StatementNoteOp:
        l = M2LexBuf_TokenToLineNo (f->Operand3, 0);
        n = M2LexBuf_GetTokenName (f->Operand3);
        M2Printf_fprintf4 (M2LangDump_GetDumpFile (), (const char *) "%a:%d:%a (tokenno %d)", 21, (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_LineNumberOp:
        M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "%a:%d", 5, (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1), (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_EndFileOp:
        n1 = SymbolTable_GetSymName (f->Operand3);
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%a", 2, (const unsigned char *) &n1, (sizeof (n1)-1));
        break;

      case M2Quads_ThrowOp:
      case M2Quads_ReturnOp:
      case M2Quads_CallOp:
      case M2Quads_KillLocalVarOp:
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_ProcedureScopeOp:
        n1 = SymbolTable_GetSymName (f->Operand2);
        n2 = SymbolTable_GetSymName (f->Operand3);
        M2Printf_fprintf4 (M2LangDump_GetDumpFile (), (const char *) "  %4d  %a  %a(%d)", 17, (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1), (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        DisplayProcedureAttributes (f->Operand3);
        break;

      case M2Quads_NewLocalVarOp:
      case M2Quads_FinallyStartOp:
      case M2Quads_FinallyEndOp:
      case M2Quads_InitEndOp:
      case M2Quads_InitStartOp:
        n1 = SymbolTable_GetSymName (f->Operand2);
        n2 = SymbolTable_GetSymName (f->Operand3);
        M2Printf_fprintf3 (M2LangDump_GetDumpFile (), (const char *) "  %4d  %a  %a", 13, (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        break;

      case M2Quads_ModuleScopeOp:
      case M2Quads_StartModFileOp:
        n1 = SymbolTable_GetSymName (f->Operand3);
        M2Printf_fprintf4 (M2LangDump_GetDumpFile (), (const char *) "%a:%d  %a(%d)", 13, (const unsigned char *) &f->Operand2, (sizeof (f->Operand2)-1), (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1), (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_StartDefFileOp:
        n1 = SymbolTable_GetSymName (f->Operand3);
        M2Printf_fprintf2 (M2LangDump_GetDumpFile (), (const char *) "  %4d  %a", 9, (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1), (const unsigned char *) &n1, (sizeof (n1)-1));
        break;

      case M2Quads_OptParamOp:
      case M2Quads_ParamOp:
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%4d  ", 5, (const unsigned char *) &f->Operand1, (sizeof (f->Operand1)-1));
        M2Quads_WriteOperand (f->Operand2);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_SizeOp:
      case M2Quads_RecordFieldOp:
      case M2Quads_IndrXOp:
      case M2Quads_XIndrOp:
      case M2Quads_ArrayOp:
      case M2Quads_LogicalShiftOp:
      case M2Quads_LogicalRotateOp:
      case M2Quads_LogicalOrOp:
      case M2Quads_LogicalAndOp:
      case M2Quads_LogicalXorOp:
      case M2Quads_LogicalDiffOp:
      case M2Quads_ArithAddOp:
      case M2Quads_CoerceOp:
      case M2Quads_ConvertOp:
      case M2Quads_CastOp:
      case M2Quads_AddOp:
      case M2Quads_SubOp:
      case M2Quads_MultOp:
      case M2Quads_DivM2Op:
      case M2Quads_ModM2Op:
      case M2Quads_ModFloorOp:
      case M2Quads_DivCeilOp:
      case M2Quads_ModCeilOp:
      case M2Quads_DivFloorOp:
      case M2Quads_ModTruncOp:
      case M2Quads_DivTruncOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand2);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_DummyOp:
      case M2Quads_CodeOnOp:
      case M2Quads_CodeOffOp:
      case M2Quads_ProfileOnOp:
      case M2Quads_ProfileOffOp:
      case M2Quads_OptimizeOnOp:
      case M2Quads_OptimizeOffOp:
        break;

      case M2Quads_BuiltinConstOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "   %a", 5, (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_BuiltinTypeInfoOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "   %a", 5, (const unsigned char *) &f->Operand2, (sizeof (f->Operand2)-1));
        M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "   %a", 5, (const unsigned char *) &f->Operand3, (sizeof (f->Operand3)-1));
        break;

      case M2Quads_StandardFunctionOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand2);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand3);
        break;

      case M2Quads_CatchBeginOp:
      case M2Quads_CatchEndOp:
        break;

      case M2Quads_RangeCheckOp:
      case M2Quads_ErrorOp:
        M2Range_WriteRangeCheck (f->Operand3);
        break;

      case M2Quads_SaveExceptionOp:
      case M2Quads_RestoreExceptionOp:
        M2Quads_WriteOperand (f->Operand1);
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "  ", 2);
        M2Quads_WriteOperand (f->Operand3);
        break;


      default:
        M2Error_InternalError ((const char *) "quadruple not recognised", 24);
        break;
    }
}


/*
   WriteOperand - displays the operands name, symbol id and mode of addressing.
*/

static void WriteMode (SymbolTable_ModeOfAddr Mode)
{
  switch (Mode)
    {
      case SymbolTable_ImmediateValue:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "i", 1);
        break;

      case SymbolTable_NoValue:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "n", 1);
        break;

      case SymbolTable_RightValue:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "r", 1);
        break;

      case SymbolTable_LeftValue:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "l", 1);
        break;


      default:
        M2Error_InternalError ((const char *) "unrecognised mode", 17);
        break;
    }
}


/*
   PushExit - pushes the exit value onto the EXIT stack.
*/

static void PushExit (unsigned int Exit)
{
  M2StackWord_PushWord (ExitStack, Exit);
}


/*
   PopExit - pops the exit value from the EXIT stack.
*/

static unsigned int PopExit (void)
{
  return M2StackWord_PopWord (ExitStack);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushFor - pushes the exit value onto the FOR stack.
*/

static void PushFor (unsigned int Exit)
{
  M2StackWord_PushWord (ForStack, Exit);
}


/*
   PopFor - pops the exit value from the FOR stack.
*/

static unsigned int PopFor (void)
{
  return M2StackWord_PopWord (ForStack);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandTno - returns the ident operand stored in the true position
                on the boolean stack.  This is exactly the same as
                OperandT but it has no IsBoolean checking.
*/

static unsigned int OperandTno (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return static_cast<unsigned int> (f->TrueExit);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandFno - returns the ident operand stored in the false position
                on the boolean stack.  This is exactly the same as
                OperandF but it has no IsBoolean checking.
*/

static unsigned int OperandFno (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return static_cast<unsigned int> (f->FalseExit);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandTtok - returns the token associated with the position, pos
                 on the boolean stack.
*/

static unsigned int OperandTtok (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return f->tokenno;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PopBooltok - Pops a True and a False exit quad number from the True/False
                stack.
*/

static void PopBooltok (unsigned int *True, unsigned int *False, unsigned int *tokno)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = f->TrueExit;
  (*False) = f->FalseExit;
  (*tokno) = f->tokenno;
  M2Debug_Assert (f->BooleanOp);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PushBooltok - Push a True and a False exit quad numbers onto the
                 True/False stack.
*/

static void PushBooltok (unsigned int True, unsigned int False, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (True <= NextQuad);
  M2Debug_Assert (False <= NextQuad);
  f = newBoolFrame ();
  f->TrueExit = True;
  f->FalseExit = False;
  f->BooleanOp = true;
  f->tokenno = tokno;
  f->Annotation = static_cast<DynamicStrings_String> (NULL);
  f->RangeDep = 0;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
  M2Quads_Annotate ((const char *) "<q%1d>|<q%2d>||true quad|false quad", 35);
}


/*
   PopBool - Pops a True and a False exit quad number from the True/False
             stack.
*/

static void PopBool (unsigned int *True, unsigned int *False)
{
  unsigned int tokno;

  PopBooltok (True, False, &tokno);
}


/*
   PushBool - Push a True and a False exit quad numbers onto the
              True/False stack.
*/

static void PushBool (unsigned int True, unsigned int False)
{
  PushBooltok (True, False, M2LexBuf_UnknownTokenNo);
}


/*
   IsBoolean - returns true is the Stack position pos contains a Boolean
               Exit. False is returned if an Ident is stored.
*/

static bool IsBoolean (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return f->BooleanOp;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandD - returns possible array dimension associated with the ident
              operand stored on the boolean stack.
*/

static unsigned int OperandD (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  M2Debug_Assert (! (IsBoolean (pos)));
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return static_cast<unsigned int> (f->Dimension);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandRW - returns the rw operand stored on the boolean stack.
*/

static unsigned int OperandRW (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  M2Debug_Assert (! (IsBoolean (pos)));
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return static_cast<unsigned int> (f->ReadWrite);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandMergeRW - returns the rw operand if not NulSym else it
                    returns True.
*/

static unsigned int OperandMergeRW (unsigned int pos)
{
  if ((OperandRW (pos)) == SymbolTable_NulSym)
    {
      return M2Quads_OperandT (pos);
    }
  else
    {
      return OperandRW (pos);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandRangeDep - return the range dependant associated with the quad stack.
*/

static unsigned int OperandRangeDep (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (! (IsBoolean (pos)));
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return f->RangeDep;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRangeDep - assigns the quad stack pos RangeDep to dep.
*/

static void PutRangeDep (unsigned int pos, unsigned int dep)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (! (IsBoolean (pos)));
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  f->RangeDep = dep;
}


/*
   UseLineNote - uses the line note and returns it to the free list.
*/

static void UseLineNote (M2Quads_LineNote l)
{
  M2Quads_QuadFrame f;

  f = GetQF (NextQuad-1);
  if ((f->Operator == M2Quads_LineNumberOp) && (f->Operand1 == ((unsigned int ) (l->File))))
    {}  /* empty.  */
  else
    {
      /* do nothing  */
      if (false)
        {
          GenQuad (M2Quads_LineNumberOp, (unsigned int ) (l->File), SymbolTable_NulSym, (unsigned int ) (l->Line));
        }
    }
  l->Next = FreeLineList;
  FreeLineList = l;
}


/*
   PopLineNo - pops a line note from the line stack.
*/

static M2Quads_LineNote PopLineNo (void)
{
  M2Quads_LineNote l;

  l = static_cast<M2Quads_LineNote> (M2StackAddress_PopAddress (LineStack));
  if (l == NULL)
    {
      M2Error_InternalError ((const char *) "no line note available", 22);
    }
  return l;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitLineNote - creates a line note and initializes it to
                  contain, file, line.
*/

static M2Quads_LineNote InitLineNote (NameKey_Name file, unsigned int line)
{
  M2Quads_LineNote l;

  if (FreeLineList == NULL)
    {
      Storage_ALLOCATE ((void **) &l, sizeof (M2Quads__T6));
    }
  else
    {
      l = FreeLineList;
      FreeLineList = FreeLineList->Next;
    }
  l->File = file;
  l->Line = line;
  return l;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushLineNote -
*/

static void PushLineNote (M2Quads_LineNote l)
{
  M2StackAddress_PushAddress (LineStack, reinterpret_cast <void *> (l));
}


/*
   BuildStmtNoteTok - adds a nop (with an assigned tokenno location) to the code.
*/

static void BuildStmtNoteTok (unsigned int tokenno)
{
  NameKey_Name filename;
  M2Quads_QuadFrame f;

  f = GetQF (NextQuad-1);
  /* no need to have multiple notes at the same position.  */
  if ((f->Operator != M2Quads_StatementNoteOp) || (f->Operand3 != tokenno))
    {
      filename = NameKey_makekey (DynamicStrings_string (M2LexBuf_GetFileName ()));
      GenQuad (M2Quads_StatementNoteOp, (unsigned int ) (filename), SymbolTable_NulSym, tokenno);
    }
}


/*
   GetRecordOrField -
*/

static unsigned int GetRecordOrField (void)
{
  unsigned int f;

  VarientFieldNo += 1;
  f = static_cast<unsigned int> (Lists_GetItemFromList (VarientFields, VarientFieldNo));
  if (DebugVarients)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsRecord (f))
        {
          M2Printf_printf2 ((const char *) "out list: record %d is %d\\n", 27, (const unsigned char *) &VarientFieldNo, (sizeof (VarientFieldNo)-1), (const unsigned char *) &f, (sizeof (f)-1));
        }
      else
        {
          M2Printf_printf2 ((const char *) "out list: varient field %d is %d\\n", 34, (const unsigned char *) &VarientFieldNo, (sizeof (VarientFieldNo)-1), (const unsigned char *) &f, (sizeof (f)-1));
        }
    }
  return f;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushTFAD - Push True, False, Array, Dim, numbers onto the
              True/False stack.  True and False are assumed to
              contain Symbols or Ident etc.
*/

static void PushTFAD (unsigned int True, unsigned int False, unsigned int Array, unsigned int Dim)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Unbounded = static_cast<unsigned int> (Array);
  f->Dimension = static_cast<unsigned int> (Dim);
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PushTFADtok - Push True, False, Array, Dim, numbers onto the
                 True/False stack.  True and False are assumed to
                 contain Symbols or Ident etc.
*/

static void PushTFADtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int Dim, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Unbounded = static_cast<unsigned int> (Array);
  f->Dimension = static_cast<unsigned int> (Dim);
  f->tokenno = tokno;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PushTFADrwtok - Push True, False, Array, Dim, rw, numbers onto the
                   True/False stack.  True and False are assumed to
                   contain Symbols or Ident etc.
*/

static void PushTFADrwtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int Dim, unsigned int rw, unsigned int Tok)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Unbounded = static_cast<unsigned int> (Array);
  f->Dimension = static_cast<unsigned int> (Dim);
  f->ReadWrite = static_cast<unsigned int> (rw);
  f->tokenno = Tok;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTFrwtok - Pop a True and False number from the True/False stack.
                True and False are assumed to contain Symbols or Ident etc.
*/

static void PopTFrwtok (unsigned int *True, unsigned int *False, unsigned int *rw, unsigned int *tokno)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*False) = static_cast<unsigned int> (f->FalseExit);
  M2Debug_Assert (! f->BooleanOp);
  (*rw) = static_cast<unsigned int> (f->ReadWrite);
  (*tokno) = f->tokenno;
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PushTFrwtok - Push an item onto the stack in the T (true) position,
                 it is assummed to be a token and its token location is recorded.
*/

static void PushTFrwtok (unsigned int True, unsigned int False, unsigned int rw, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->ReadWrite = static_cast<unsigned int> (rw);
  f->tokenno = tokno;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PushTFDtok - Push True, False, Dim, numbers onto the
                True/False stack.  True and False are assumed to
                contain Symbols or Ident etc.
*/

static void PushTFDtok (unsigned int True, unsigned int False, unsigned int Dim, unsigned int Tok)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Dimension = static_cast<unsigned int> (Dim);
  f->tokenno = Tok;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTFDtok - Pop a True, False, Dim number from the True/False stack.
               True and False are assumed to contain Symbols or Ident etc.
*/

static void PopTFDtok (unsigned int *True, unsigned int *False, unsigned int *Dim, unsigned int *Tok)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*False) = static_cast<unsigned int> (f->FalseExit);
  (*Dim) = static_cast<unsigned int> (f->Dimension);
  (*Tok) = f->tokenno;
  M2Debug_Assert (! f->BooleanOp);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PushTFDrwtok - Push True, False, Dim, numbers onto the
                  True/False stack.  True and False are assumed to
                  contain Symbols or Ident etc.
*/

static void PushTFDrwtok (unsigned int True, unsigned int False, unsigned int Dim, unsigned int rw, unsigned int Tok)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Dimension = static_cast<unsigned int> (Dim);
  f->ReadWrite = static_cast<unsigned int> (rw);
  f->tokenno = Tok;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PushTFrw - Push a True and False numbers onto the True/False stack.
              True and False are assumed to contain Symbols or Ident etc.
              It also pushes the higher level symbol which is associated
              with the True symbol.  Eg record variable or array variable.
*/

static void PushTFrw (unsigned int True, unsigned int False, unsigned int rw)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->ReadWrite = rw;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTFrw - Pop a True and False number from the True/False stack.
             True and False are assumed to contain Symbols or Ident etc.
*/

static void PopTFrw (unsigned int *True, unsigned int *False, unsigned int *rw)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*False) = static_cast<unsigned int> (f->FalseExit);
  M2Debug_Assert (! f->BooleanOp);
  (*rw) = static_cast<unsigned int> (f->ReadWrite);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   newBoolFrame - creates a new BoolFrame with all fields initialised to their defaults.
*/

static M2Quads_BoolFrame newBoolFrame (void)
{
  M2Quads_BoolFrame f;

  Storage_ALLOCATE ((void **) &f, sizeof (M2Quads__T2));
  f->TrueExit = 0;
  f->FalseExit = 0;
  f->Unbounded = SymbolTable_NulSym;
  f->BooleanOp = false;
  f->Dimension = 0;
  f->ReadWrite = SymbolTable_NulSym;
  f->name = SymbolTable_NulSym;
  f->Annotation = static_cast<DynamicStrings_String> (NULL);
  f->tokenno = M2LexBuf_UnknownTokenNo;
  return f;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushTrwtok - Push an item onto the True/False stack. The False value will be zero.
*/

static void PushTrwtok (unsigned int True, unsigned int rw, unsigned int tok)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->ReadWrite = static_cast<unsigned int> (rw);
  f->tokenno = tok;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTrw - Pop a True field and rw symbol from the stack.
*/

static void PopTrw (unsigned int *True, unsigned int *rw)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  M2Debug_Assert (! f->BooleanOp);
  (*rw) = static_cast<unsigned int> (f->ReadWrite);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PopTrwtok - Pop a True field and rw symbol from the stack.
*/

static void PopTrwtok (unsigned int *True, unsigned int *rw, unsigned int *tok)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  M2Debug_Assert (! f->BooleanOp);
  (*rw) = static_cast<unsigned int> (f->ReadWrite);
  (*tok) = f->tokenno;
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   gdbhook - a debugger convenience hook.
*/

static void gdbhook (void)
{
}


/*
   BreakWhenQuadCreated - to be called interactively by gdb.
*/

static void BreakWhenQuadCreated (unsigned int quad)
{
  BreakQuad = quad;
}


/*
   CheckBreak - if quad = BreakQuad then call gdbhook.
*/

static void CheckBreak (unsigned int quad)
{
  if (quad == BreakQuad)
    {
      gdbhook ();
    }
}


/*
   Init - initialize the M2Quads module, all the stacks, all the lists
          and the quads list.
*/

static void Init (void)
{
  BreakWhenQuadCreated (0);  /* Disable the intereactive quad watch.  */
  /* To examine the quad table when a quad is created run cc1gm2 from gdb
      and set a break point on gdbhook.
      (gdb) break gdbhook
      (gdb) run
      Now below interactively call BreakWhenQuadCreated with the quad
      under investigation.  */
  gdbhook ();
  /* Now is the time to interactively call gdb, for example:
      (gdb) print BreakWhenQuadCreated (1234)
      (gdb) cont
      and you will arrive at gdbhook when this quad is created.  */
  LogicalOrTok = NameKey_MakeKey ((const char *) "_LOR", 4);
  LogicalAndTok = NameKey_MakeKey ((const char *) "_LAND", 5);
  LogicalXorTok = NameKey_MakeKey ((const char *) "_LXOR", 5);
  LogicalDifferenceTok = NameKey_MakeKey ((const char *) "_LDIFF", 6);
  ArithPlusTok = NameKey_MakeKey ((const char *) "_ARITH_+", 8);
  QuadArray = Indexing_InitIndexTuned (1, (1024*1024) / 16, 16);
  FreeList = 1;
  NewQuad (&NextQuad);
  M2Debug_Assert (NextQuad == 1);
  BoolStack = M2StackAddress_InitStackAddress ();
  ExitStack = M2StackWord_InitStackWord ();
  RepeatStack = M2StackWord_InitStackWord ();
  WhileStack = M2StackWord_InitStackWord ();
  ForStack = M2StackWord_InitStackWord ();
  WithStack = M2StackAddress_InitStackAddress ();
  ReturnStack = M2StackWord_InitStackWord ();
  LineStack = M2StackAddress_InitStackAddress ();
  PriorityStack = M2StackWord_InitStackWord ();
  TryStack = M2StackWord_InitStackWord ();
  CatchStack = M2StackWord_InitStackWord ();
  ExceptStack = M2StackWord_InitStackWord ();
  ConstructorStack = M2StackAddress_InitStackAddress ();
  ConstParamStack = M2StackWord_InitStackWord ();
  ConstExprStack = M2StackWord_InitStackWord ();
  /* StressStack ;  */
  SuppressWith = false;
  Head = 1;
  LastQuadNo = 0;
  MustNotCheckBounds = false;
  InitQuad = 0;
  GrowInitialization = 0;
  ForInfo = Indexing_InitIndex (1);
  QuadrupleGeneration = true;
  BuildingHigh = false;
  BuildingSize = false;
  AutoStack = M2StackWord_InitStackWord ();
  IsAutoOn = true;
  InConstExpression = false;
  InConstParameters = false;
  FreeLineList = NULL;
  Lists_InitList (&VarientFields);
  VarientFieldNo = 0;
  NoOfQuads = 0;
}


/*
   SetOptionCoding - builds a code quadruple if the profiling
                     option was given to the compiler.
*/

extern "C" void M2Quads_SetOptionCoding (bool b)
{
  if (b != M2Options_Coding)
    {
      if (b)
        {
          M2Quads_BuildCodeOn ();
        }
      else
        {
          M2Quads_BuildCodeOff ();
        }
      M2Options_Coding = b;
    }
}


/*
   SetOptionProfiling - builds a profile quadruple if the profiling
                        option was given to the compiler.
*/

extern "C" void M2Quads_SetOptionProfiling (bool b)
{
  if (b != M2Options_Profiling)
    {
      if (b)
        {
          M2Quads_BuildProfileOn ();
        }
      else
        {
          M2Quads_BuildProfileOff ();
        }
      M2Options_Profiling = b;
    }
}


/*
   SetOptionOptimizing - builds a quadruple to say that the optimization option
                         has been found in a comment.
*/

extern "C" void M2Quads_SetOptionOptimizing (bool b)
{
  if (b)
    {
      M2Quads_BuildOptimizeOn ();
    }
  else
    {
      M2Quads_BuildOptimizeOff ();
    }
}


/*
   Opposite - returns the opposite comparison operator.
*/

extern "C" M2Quads_QuadOperator M2Quads_Opposite (M2Quads_QuadOperator Operator)
{
  M2Quads_QuadOperator Op;

  switch (Operator)
    {
      case M2Quads_IfNotEquOp:
        Op = M2Quads_IfEquOp;
        break;

      case M2Quads_IfEquOp:
        Op = M2Quads_IfNotEquOp;
        break;

      case M2Quads_IfLessEquOp:
        Op = M2Quads_IfGreOp;
        break;

      case M2Quads_IfGreOp:
        Op = M2Quads_IfLessEquOp;
        break;

      case M2Quads_IfGreEquOp:
        Op = M2Quads_IfLessOp;
        break;

      case M2Quads_IfLessOp:
        Op = M2Quads_IfGreEquOp;
        break;

      case M2Quads_IfInOp:
        Op = M2Quads_IfNotInOp;
        break;

      case M2Quads_IfNotInOp:
        Op = M2Quads_IfInOp;
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected operator", 19);
        break;
    }
  return Op;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsReferenced - returns true if QuadNo is referenced by another quadruple.
*/

extern "C" bool M2Quads_IsReferenced (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return ((f->Operator == M2Quads_ProcedureScopeOp) || (f->Operator == M2Quads_NewLocalVarOp)) || (f->NoOfTimesReferenced > 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBackReference - returns TRUE if quadruple, q, is referenced from a quad further on.
*/

extern "C" bool M2Quads_IsBackReference (unsigned int q)
{
  unsigned int i;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  i = q;
  while (i != 0)
    {
      M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
      switch (op)
        {
          case M2Quads_NewLocalVarOp:
          case M2Quads_KillLocalVarOp:
          case M2Quads_FinallyStartOp:
          case M2Quads_FinallyEndOp:
          case M2Quads_InitEndOp:
          case M2Quads_InitStartOp:
          case M2Quads_EndFileOp:
          case M2Quads_StartDefFileOp:
          case M2Quads_StartModFileOp:
            return false;  /* run into end of procedure or module  */
            break;

          case M2Quads_GotoOp:
          case M2Quads_IfEquOp:
          case M2Quads_IfLessEquOp:
          case M2Quads_IfGreEquOp:
          case M2Quads_IfGreOp:
          case M2Quads_IfLessOp:
          case M2Quads_IfNotEquOp:
          case M2Quads_IfInOp:
          case M2Quads_IfNotInOp:
            if (op3 == q)  /* run into end of procedure or module  */
              {
                return true;
              }
            break;


          default:
            break;
        }
      i = M2Quads_GetNextQuad (i);
    }
  M2Error_InternalError ((const char *) "fix this for the sake of efficiency..", 37);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Quads.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsUnConditional - returns true if QuadNo is an unconditional jump.
*/

extern "C" bool M2Quads_IsUnConditional (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  switch (f->Operator)
    {
      case M2Quads_ThrowOp:
      case M2Quads_RetryOp:
      case M2Quads_CallOp:
      case M2Quads_ReturnOp:
      case M2Quads_GotoOp:
        return true;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConditional - returns true if QuadNo is a conditional jump.
*/

extern "C" bool M2Quads_IsConditional (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  switch (f->Operator)
    {
      case M2Quads_IfInOp:
      case M2Quads_IfNotInOp:
      case M2Quads_IfEquOp:
      case M2Quads_IfNotEquOp:
      case M2Quads_IfLessOp:
      case M2Quads_IfLessEquOp:
      case M2Quads_IfGreOp:
      case M2Quads_IfGreEquOp:
        return true;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBackReferenceConditional - returns TRUE if quadruple, q, is referenced from
                                a conditional quad further on.
*/

extern "C" bool M2Quads_IsBackReferenceConditional (unsigned int q)
{
  unsigned int i;
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  i = q;
  while (i != 0)
    {
      M2Quads_GetQuad (i, &op, &op1, &op2, &op3);
      switch (op)
        {
          case M2Quads_NewLocalVarOp:
          case M2Quads_KillLocalVarOp:
          case M2Quads_FinallyStartOp:
          case M2Quads_FinallyEndOp:
          case M2Quads_InitEndOp:
          case M2Quads_InitStartOp:
          case M2Quads_EndFileOp:
          case M2Quads_StartDefFileOp:
          case M2Quads_StartModFileOp:
            return false;  /* run into end of procedure or module  */
            break;

          case M2Quads_TryOp:
          case M2Quads_RetryOp:
          case M2Quads_GotoOp:
          case M2Quads_IfEquOp:
          case M2Quads_IfLessEquOp:
          case M2Quads_IfGreEquOp:
          case M2Quads_IfGreOp:
          case M2Quads_IfLessOp:
          case M2Quads_IfNotEquOp:
          case M2Quads_IfInOp:
          case M2Quads_IfNotInOp:
            if ((op3 == q) && (M2Quads_IsConditional (q)))  /* run into end of procedure or module  */
              {
                return true;
              }
            break;


          default:
            return false;
            break;
        }
      i = M2Quads_GetNextQuad (i);
    }
  M2Error_InternalError ((const char *) "fix this for the sake of efficiency..", 37);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Quads.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsGoto - returns true if QuadNo is a goto operation.
*/

extern "C" bool M2Quads_IsGoto (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_GotoOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsCall - returns true if QuadNo is a call operation.
*/

extern "C" bool M2Quads_IsCall (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_CallOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsReturn - returns true if QuadNo is a return operation.
*/

extern "C" bool M2Quads_IsReturn (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_ReturnOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProcedureScope - returns true if QuadNo is a ProcedureScope operation.
*/

extern "C" bool M2Quads_IsProcedureScope (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_ProcedureScopeOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsNewLocalVar - returns true if QuadNo is a NewLocalVar operation.
*/

extern "C" bool M2Quads_IsNewLocalVar (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_NewLocalVarOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsKillLocalVar - returns true if QuadNo is a KillLocalVar operation.
*/

extern "C" bool M2Quads_IsKillLocalVar (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_KillLocalVarOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsCatchBegin - returns true if QuadNo is a catch begin quad.
*/

extern "C" bool M2Quads_IsCatchBegin (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_CatchBeginOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsCatchEnd - returns true if QuadNo is a catch end quad.
*/

extern "C" bool M2Quads_IsCatchEnd (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_CatchEndOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsInitStart - returns true if QuadNo is a init start quad.
*/

extern "C" bool M2Quads_IsInitStart (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_InitStartOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsInitEnd - returns true if QuadNo is a init end quad.
*/

extern "C" bool M2Quads_IsInitEnd (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_InitEndOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFinallyStart - returns true if QuadNo is a finally start quad.
*/

extern "C" bool M2Quads_IsFinallyStart (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_FinallyStartOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFinallyEnd - returns true if QuadNo is a finally end quad.
*/

extern "C" bool M2Quads_IsFinallyEnd (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_FinallyEndOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBecomes - return TRUE if QuadNo is a BecomesOp.
*/

extern "C" bool M2Quads_IsBecomes (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_BecomesOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDummy - return TRUE if QuadNo is a DummyOp.
*/

extern "C" bool M2Quads_IsDummy (unsigned int QuadNo)
{
  return IsQuadA (QuadNo, M2Quads_DummyOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsQuadConstExpr - returns TRUE if QuadNo is part of a constant expression.
*/

extern "C" bool M2Quads_IsQuadConstExpr (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return f->ConstExpr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetQuadConstExpr - sets the constexpr field to value.
*/

extern "C" void M2Quads_SetQuadConstExpr (unsigned int QuadNo, bool value)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  f->ConstExpr = value;
}


/*
   GetQuadDest - returns the jump destination associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadDest (unsigned int QuadNo)
{
  return M2Quads_GetQuadOp3 (QuadNo);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetQuadOp1 - returns the 1st operand associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadOp1 (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return f->Operand1;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetQuadOp2 - returns the 2nd operand associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadOp2 (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return f->Operand2;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetQuadOp3 - returns the 3rd operand associated with quad.
*/

extern "C" unsigned int M2Quads_GetQuadOp3 (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return f->Operand3;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsInitialisingConst - returns TRUE if the quadruple is setting
                         a const (op1) with a value.
*/

extern "C" bool M2Quads_IsInitialisingConst (unsigned int QuadNo)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  M2Quads_GetQuad (QuadNo, &op, &op1, &op2, &op3);
  return (OpUsesOp1 (op)) && (SymbolTable_IsConst (op1));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstQuad - return TRUE if the quadruple is marked as a constexpr.
*/

extern "C" bool M2Quads_IsConstQuad (unsigned int quad)
{
  M2Quads_QuadFrame f;

  f = GetQF (quad);
  return f->ConstExpr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConditionalBooleanQuad - return TRUE if operand 1 is a boolean result.
*/

extern "C" bool M2Quads_IsConditionalBooleanQuad (unsigned int quad)
{
  M2Quads_QuadFrame f;

  f = GetQF (quad);
  return ((OpUsesOp1 (f->Operator)) && ((SymbolTable_IsVar (f->Operand1)) || (SymbolTable_IsConst (f->Operand1)))) && (SymbolTable_IsVarConditional (f->Operand1));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsOptimizeOn - returns true if the Optimize flag was true at QuadNo.
*/

extern "C" bool M2Quads_IsOptimizeOn (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;
  unsigned int n;
  unsigned int q;
  bool On;

  On = M2Options_Optimizing;
  q = Head;
  while ((q != 0) && (q != QuadNo))
    {
      f = GetQF (q);
      if (f->Operator == M2Quads_OptimizeOnOp)
        {
          On = true;
        }
      else if (f->Operator == M2Quads_OptimizeOffOp)
        {
          /* avoid dangling else.  */
          On = false;
        }
      n = f->Next;
      q = n;
    }
  return On;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProfileOn - returns true if the Profile flag was true at QuadNo.
*/

extern "C" bool M2Quads_IsProfileOn (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;
  unsigned int n;
  unsigned int q;
  bool On;

  On = M2Options_Profiling;
  q = Head;
  while ((q != 0) && (q != QuadNo))
    {
      f = GetQF (q);
      if (f->Operator == M2Quads_ProfileOnOp)
        {
          On = true;
        }
      else if (f->Operator == M2Quads_ProfileOffOp)
        {
          /* avoid dangling else.  */
          On = false;
        }
      n = f->Next;
      q = n;
    }
  return On;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsCodeOn - returns true if the Code flag was true at QuadNo.
*/

extern "C" bool M2Quads_IsCodeOn (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;
  unsigned int n;
  unsigned int q;
  bool On;

  On = M2Options_Coding;
  q = Head;
  while ((q != 0) && (q != QuadNo))
    {
      f = GetQF (q);
      if (f->Operator == M2Quads_CodeOnOp)
        {
          On = true;
        }
      else if (f->Operator == M2Quads_CodeOffOp)
        {
          /* avoid dangling else.  */
          On = false;
        }
      n = f->Next;
      q = n;
    }
  return On;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPseudoQuad - returns true if QuadNo is a compiler directive.
                  ie code, profile and optimize.
                     StartFile, EndFile,
*/

extern "C" bool M2Quads_IsPseudoQuad (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return ((((((((f->Operator == M2Quads_CodeOnOp) || (f->Operator == M2Quads_CodeOffOp)) || (f->Operator == M2Quads_ProfileOnOp)) || (f->Operator == M2Quads_ProfileOffOp)) || (f->Operator == M2Quads_OptimizeOnOp)) || (f->Operator == M2Quads_OptimizeOffOp)) || (f->Operator == M2Quads_EndFileOp)) || (f->Operator == M2Quads_StartDefFileOp)) || (f->Operator == M2Quads_StartModFileOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDefOrModFile - returns TRUE if QuadNo is a start of Module or Def file
                    directive.
*/

extern "C" bool M2Quads_IsDefOrModFile (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return (f->Operator == M2Quads_StartDefFileOp) || (f->Operator == M2Quads_StartModFileOp);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DumpQuadruples - dump all quadruples providing the -fq, -fdump-lang-quad,
                    -fdump-lang-quad= or -fdump-lang-all were issued to the
                    command line.
*/

extern "C" void M2Quads_DumpQuadruples (const char *title_, unsigned int _title_high)
{
  char title[_title_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (title, title_, _title_high+1);

  if (M2Options_GetDumpQuad ())
    {
      M2LangDump_CreateDumpQuad ((const char *) title, _title_high);
      if ((M2Options_GetM2DumpFilter ()) == NULL)
        {
          DumpQuadrupleAll ();
        }
      else
        {
          DumpQuadrupleFilter ();
        }
      M2LangDump_CloseDumpQuad ();
    }
}


/*
   DisplayQuadRange - displays all quads in list range, start..end.
*/

extern "C" void M2Quads_DisplayQuadRange (unsigned int scope, unsigned int start, unsigned int end)
{
  M2Quads_QuadFrame f;

  M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "Quadruples for scope: %d\\n", 26, (const unsigned char *) &scope, (sizeof (scope)-1));
  while ((start <= end) && (start != 0))
    {
      M2Quads_DisplayQuad (start);
      f = GetQF (start);
      start = f->Next;
    }
}


/*
   DisplayQuad - displays a quadruple, QuadNo.
*/

extern "C" void M2Quads_DisplayQuad (unsigned int QuadNo)
{
  DSdbEnter ();
  M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%4d  ", 5, (const unsigned char *) &QuadNo, (sizeof (QuadNo)-1));
  WriteQuad (QuadNo);
  M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "\\n", 2);
  DSdbExit ();
}


/*
   GetLastFileQuad - returns the Quadruple number of the last StartDefFile or
                     StartModFile quadruple.
*/

extern "C" unsigned int M2Quads_GetLastFileQuad (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;
  unsigned int q;
  unsigned int i;
  unsigned int FileQuad;

  q = Head;
  FileQuad = 0;
  do {
    f = GetQF (q);
    if ((f->Operator == M2Quads_StartModFileOp) || (f->Operator == M2Quads_StartDefFileOp))
      {
        FileQuad = q;
      }
    i = f->Next;
    q = i;
  } while (! ((i == QuadNo) || (i == 0)));
  M2Debug_Assert (i != 0);
  M2Debug_Assert (FileQuad != 0);
  return FileQuad;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLastQuadNo - returns the last quadruple number referenced
                   by a GetQuad.
*/

extern "C" unsigned int M2Quads_GetLastQuadNo (void)
{
  return LastQuadNo;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   QuadToTokenNo - Converts a QuadNo into the approprate token number of the
                   source file, the line number is returned.

                   This may be used to yield an idea where abouts in the
                   source file the code generetion is
                   processing.
*/

extern "C" unsigned int M2Quads_QuadToTokenNo (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  if ((((LastQuadNo == 0) && (! (M2Pass_IsNoPass ()))) && (! (M2Pass_IsPassCodeGeneration ()))) || (! (Indexing_InBounds (QuadArray, QuadNo))))
    {
      return 0;
    }
  else
    {
      f = GetQF (QuadNo);
      return f->TokenNo;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   QuadToLineNo - Converts a QuadNo into the approprate line number of the
                  source file, the line number is returned.

                  This may be used to yield an idea where abouts in the
                  source file the code generetion is
                  processing.
*/

extern "C" unsigned int M2Quads_QuadToLineNo (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  if ((((LastQuadNo == 0) && (! (M2Pass_IsNoPass ()))) && (! (M2Pass_IsPassCodeGeneration ()))) || (! (Indexing_InBounds (QuadArray, QuadNo))))
    {
      return 0;
    }
  else
    {
      f = GetQF (QuadNo);
      return f->LineNo;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetQuad - returns the Quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuad (unsigned int QuadNo, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  LastQuadNo = QuadNo;
  (*Op) = f->Operator;
  (*Oper1) = f->Operand1;
  (*Oper2) = f->Operand2;
  (*Oper3) = f->Operand3;
}


/*
   GetQuadOp - returns the operator for quad.
*/

extern "C" M2Quads_QuadOperator M2Quads_GetQuadOp (unsigned int quad)
{
  M2Quads_QuadFrame f;

  f = GetQF (quad);
  return f->Operator;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetM2OperatorDesc - returns the Modula-2 string associated with the quad operator
                       (if possible).  It returns NIL if no there is not an obvious match
                       in Modula-2.  It is assummed that the string will be used during
                       construction of error messages and therefore keywords are
                       wrapped with a format specifier.
*/

extern "C" DynamicStrings_String M2Quads_GetM2OperatorDesc (M2Quads_QuadOperator op)
{
  switch (op)
    {
      case M2Quads_NegateOp:
        return DynamicStrings_InitString ((const char *) "-", 1);
        break;

      case M2Quads_AddOp:
        return DynamicStrings_InitString ((const char *) "+", 1);
        break;

      case M2Quads_SubOp:
        return DynamicStrings_InitString ((const char *) "-", 1);
        break;

      case M2Quads_MultOp:
        return DynamicStrings_InitString ((const char *) "*", 1);
        break;

      case M2Quads_DivM2Op:
      case M2Quads_DivCeilOp:
      case M2Quads_DivFloorOp:
      case M2Quads_DivTruncOp:
        return DynamicStrings_InitString ((const char *) "{%kDIV}", 7);
        break;

      case M2Quads_ModM2Op:
      case M2Quads_ModCeilOp:
      case M2Quads_ModFloorOp:
        return DynamicStrings_InitString ((const char *) "{%kMOD}", 7);
        break;

      case M2Quads_ModTruncOp:
        return DynamicStrings_InitString ((const char *) "{%kREM}", 7);
        break;

      case M2Quads_LogicalOrOp:
        return DynamicStrings_InitString ((const char *) "{%kOR}", 6);
        break;

      case M2Quads_LogicalAndOp:
        return DynamicStrings_InitString ((const char *) "{%kAND}", 7);
        break;

      case M2Quads_InclOp:
        return DynamicStrings_InitString ((const char *) "{%kINCL}", 8);
        break;

      case M2Quads_ExclOp:
        return DynamicStrings_InitString ((const char *) "{%kEXCL}", 8);
        break;

      case M2Quads_IfEquOp:
        return DynamicStrings_InitString ((const char *) "=", 1);
        break;

      case M2Quads_IfLessEquOp:
        return DynamicStrings_InitString ((const char *) "<=", 2);
        break;

      case M2Quads_IfGreEquOp:
        return DynamicStrings_InitString ((const char *) ">=", 2);
        break;

      case M2Quads_IfGreOp:
        return DynamicStrings_InitString ((const char *) ">", 1);
        break;

      case M2Quads_IfLessOp:
        return DynamicStrings_InitString ((const char *) "<", 1);
        break;

      case M2Quads_IfNotEquOp:
        return DynamicStrings_InitString ((const char *) "#", 1);
        break;

      case M2Quads_IfInOp:
        return DynamicStrings_InitString ((const char *) "IN", 2);
        break;

      case M2Quads_IfNotInOp:
        return DynamicStrings_InitString ((const char *) "NOT IN", 6);
        break;


      default:
        return static_cast<DynamicStrings_String> (NULL);
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetQuadtok - returns the Quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuadtok (unsigned int QuadNo, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  LastQuadNo = QuadNo;
  (*Op) = f->Operator;
  (*Oper1) = f->Operand1;
  (*Oper2) = f->Operand2;
  (*Oper3) = f->Operand3;
  (*Op1Pos) = f->op1pos;
  (*Op2Pos) = f->op2pos;
  (*Op3Pos) = f->op3pos;
}


/*
   GetQuadOtok - returns the Quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuadOtok (unsigned int QuadNo, unsigned int *tok, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, bool *overflowChecking, bool *constExpr, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  LastQuadNo = QuadNo;
  (*Op) = f->Operator;
  (*Oper1) = f->Operand1;
  (*Oper2) = f->Operand2;
  (*Oper3) = f->Operand3;
  (*Op1Pos) = f->op1pos;
  (*Op2Pos) = f->op2pos;
  (*Op3Pos) = f->op3pos;
  (*tok) = f->TokenNo;
  (*overflowChecking) = f->CheckOverflow;
  (*constExpr) = f->ConstExpr;
}


/*
   GetQuadOTypetok - returns the fields associated with quadruple QuadNo.
*/

extern "C" void M2Quads_GetQuadOTypetok (unsigned int QuadNo, unsigned int *tok, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, bool *overflowChecking, bool *typeChecking, bool *constExpr, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  LastQuadNo = QuadNo;
  (*Op) = f->Operator;
  (*Oper1) = f->Operand1;
  (*Oper2) = f->Operand2;
  (*Oper3) = f->Operand3;
  (*Op1Pos) = f->op1pos;
  (*Op2Pos) = f->op2pos;
  (*Op3Pos) = f->op3pos;
  (*tok) = f->TokenNo;
  (*overflowChecking) = f->CheckOverflow;
  (*typeChecking) = f->CheckType;
  (*constExpr) = f->ConstExpr;
}


/*
   PutQuadOtok - alters a quadruple QuadNo with Op, Oper1, Oper2, Oper3, and
                 sets a boolean to determinine whether overflow should be checked.
*/

extern "C" void M2Quads_PutQuadOtok (unsigned int QuadNo, unsigned int tok, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflowChecking, bool constExpr, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos)
{
  M2Quads_QuadFrame f;

  if (QuadrupleGeneration)
    {
      M2Quads_EraseQuad (QuadNo);
      AddQuadInformation (QuadNo, Op, Oper1, Oper2, Oper3);
      f = GetQF (QuadNo);
      f->Operator = Op;
      f->Operand1 = Oper1;
      f->Operand2 = Oper2;
      f->Operand3 = Oper3;
      f->CheckOverflow = overflowChecking;
      f->op1pos = Op1Pos;
      f->op2pos = Op2Pos;
      f->op3pos = Op3Pos;
      f->TokenNo = tok;
      f->ConstExpr = constExpr;
    }
}


/*
   PutQuad - overwrites a quadruple QuadNo with Op, Oper1, Oper2, Oper3
*/

extern "C" void M2Quads_PutQuad (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3)
{
  PutQuadO (QuadNo, Op, Oper1, Oper2, Oper3, true);
}


/*
   GetFirstQuad - returns the first quadruple.
*/

extern "C" unsigned int M2Quads_GetFirstQuad (void)
{
  return Head;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetNextQuad - returns the Quadruple number following QuadNo.
*/

extern "C" unsigned int M2Quads_GetNextQuad (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  f = GetQF (QuadNo);
  return f->Next;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetRealQuad - returns the Quadruple number of the real quadruple
                 at QuadNo or beyond.
*/

extern "C" unsigned int M2Quads_GetRealQuad (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  while (QuadNo != 0)
    {
      if (Indexing_InBounds (QuadArray, QuadNo))
        {
          f = GetQF (QuadNo);
          if ((((! (M2Quads_IsPseudoQuad (QuadNo))) && (f->Operator != M2Quads_DummyOp)) && (f->Operator != M2Quads_LineNumberOp)) && (f->Operator != M2Quads_StatementNoteOp))
            {
              return QuadNo;
            }
          QuadNo += 1;
        }
      else
        {
          return 0;
        }
    }
  return 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SubQuad - subtracts a quadruple QuadNo from a list Head.
*/

extern "C" void M2Quads_SubQuad (unsigned int QuadNo)
{
  unsigned int i;
  M2Quads_QuadFrame f;
  M2Quads_QuadFrame g;

  CheckBreak (QuadNo);
  f = GetQF (QuadNo);
  AlterReference (Head, QuadNo, f->Next);
  UndoReadWriteInfo (QuadNo, f->Operator, f->Operand1, f->Operand2, f->Operand3);
  if (Head == QuadNo)
    {
      Head = f->Next;
    }
  else
    {
      i = Head;
      g = GetQF (i);
      while (g->Next != QuadNo)
        {
          i = g->Next;
          g = GetQF (i);
        }
      g->Next = f->Next;
    }
  f->Operator = M2Quads_DummyOp;
  NoOfQuads -= 1;
}


/*
   EraseQuad - erases a quadruple QuadNo, the quadruple is still in the list
               but wiped clean.
*/

extern "C" void M2Quads_EraseQuad (unsigned int QuadNo)
{
  M2Quads_QuadFrame f;

  CheckBreak (QuadNo);
  f = GetQF (QuadNo);
  UndoReadWriteInfo (QuadNo, f->Operator, f->Operand1, f->Operand2, f->Operand3);
  f->Operator = M2Quads_DummyOp;  /* finally blank it out  */
  f->Operand1 = 0;  /* finally blank it out  */
  f->Operand2 = 0;
  f->Operand3 = 0;
  f->Trash = 0;
  f->op1pos = M2LexBuf_UnknownTokenNo;
  f->op2pos = M2LexBuf_UnknownTokenNo;
  f->op3pos = M2LexBuf_UnknownTokenNo;
  f->ConstExpr = false;
}


/*
   CountQuads - returns the number of quadruples.
*/

extern "C" unsigned int M2Quads_CountQuads (void)
{
  return NoOfQuads;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildScaffold - generate the main, init, finish functions if
                   no -c and this is the application module.
*/

extern "C" void M2Quads_BuildScaffold (unsigned int tok, unsigned int moduleSym)
{
  if ((SymbolTable_GetMainModule ()) == moduleSym)
    {
      M2Scaffold_DeclareScaffold (tok);
      if (M2Options_ScaffoldMain || ! M2Options_cflag)
        {
          /* There are module init/fini functions and
            application init/fini functions.
            Here we create the application pair.  */
          BuildM2LinkFunction (tok);
          BuildM2MainFunction (tok);
          BuildM2InitFunction (tok, moduleSym);  /* Application init.  */
          BuildM2FiniFunction (tok, moduleSym);  /* Application fini.  */
        }
       /* Application fini.  */
      BuildM2DepFunction (tok, moduleSym);  /* Per module dependency.  */
      /* Each module needs a ctor to register the module
         init/finish/dep with M2RTS.  */
      BuildM2CtorFunction (tok, moduleSym);
    }
  else if (M2Options_WholeProgram)
    {
      /* avoid dangling else.  */
      M2Scaffold_DeclareScaffold (tok);
      BuildM2DepFunction (tok, moduleSym);  /* Per module dependency.  */
      /* Each module needs a ctor to register the module
         init/finish/dep with M2RTS.  */
      BuildM2CtorFunction (tok, moduleSym);
    }
}


/*
   StartBuildDefFile - generates a StartFileDefOp quadruple indicating the file
                       that has produced the subsequent quadruples.
                       The code generator uses the StartDefFileOp quadruples
                       to relate any error to the appropriate file.


                       Entry                   Exit
                       =====                   ====


                Ptr ->                                        <- Ptr
                       +------------+          +------------+
                       | ModuleName |          | ModuleName |
                       |------------|          |------------|


                       Quadruples Produced

                       q     StartDefFileOp  _  _  ModuleSym
*/

extern "C" void M2Quads_StartBuildDefFile (unsigned int tok)
{
  NameKey_Name ModuleName;

  M2Quads_PopT (&ModuleName);
  M2Quads_PushT (ModuleName);
  GenQuadO (tok, M2Quads_StartDefFileOp, tok, SymbolTable_NulSym, SymbolTable_GetModule (ModuleName), false);
}


/*
   StartBuildModFile - generates a StartModFileOp quadruple indicating the file
                       that has produced the subsequent quadruples.
                       The code generator uses the StartModFileOp quadruples
                       to relate any error to the appropriate file.


                       Entry                   Exit
                       =====                   ====


                Ptr ->                                        <- Ptr
                       +------------+          +------------+
                       | ModuleName |          | ModuleName |
                       |------------|          |------------|


                       Quadruples Produced

                       q     StartModFileOp  lineno  filename  ModuleSym
*/

extern "C" void M2Quads_StartBuildModFile (unsigned int tok)
{
  GenQuadO (tok, M2Quads_StartModFileOp, tok, (unsigned int ) (NameKey_makekey (DynamicStrings_string (M2LexBuf_GetFileName ()))), SymbolTable_GetFileModule (), false);
}


/*
   EndBuildFile - generates an EndFileOp quadruple indicating the file
                  that has produced the previous quadruples has ended.

                  Entry                   Exit
                  =====                   ====


           Ptr ->                                        <- Ptr
                  +------------+          +------------+
                  | ModuleName |          | ModuleName |
                  |------------|          |------------|


                  Quadruples Produced

                  q     EndFileOp  _  _  ModuleSym
*/

extern "C" void M2Quads_EndBuildFile (unsigned int tok)
{
  NameKey_Name ModuleName;

  ModuleName = static_cast<NameKey_Name> (M2Quads_OperandT (1));
  GenQuadO (tok, M2Quads_EndFileOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_GetModule (ModuleName), false);
}


/*
   StartBuildInit - Sets the start of initialization code of the
                    current module to the next quadruple.
*/

extern "C" void M2Quads_StartBuildInit (unsigned int tok)
{
  NameKey_Name name;
  unsigned int ModuleSym;

  M2Quads_PopT (&name);
  ModuleSym = SymbolTable_GetCurrentModule ();
  M2Debug_Assert ((SymbolTable_IsModule (ModuleSym)) || (SymbolTable_IsDefImp (ModuleSym)));
  M2Debug_Assert ((SymbolTable_GetSymName (ModuleSym)) == name);
  SymbolTable_PutModuleStartQuad (ModuleSym, NextQuad);
  GenQuad (M2Quads_InitStartOp, tok, SymbolTable_GetFileModule (), ModuleSym);
  M2StackWord_PushWord (ReturnStack, static_cast<unsigned int> (0));
  M2Quads_PushT (name);
  CheckVariablesAt (ModuleSym);
  CheckNeedPriorityBegin (tok, ModuleSym, ModuleSym);
  M2StackWord_PushWord (TryStack, NextQuad);
  M2StackWord_PushWord (CatchStack, static_cast<unsigned int> (0));
  if (SymbolTable_HasExceptionBlock (ModuleSym))
    {
      GenQuad (M2Quads_TryOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
    }
}


/*
   EndBuildInit - Sets the end initialization code of a module.
*/

extern "C" void M2Quads_EndBuildInit (unsigned int tok)
{
  if (SymbolTable_HasExceptionBlock (SymbolTable_GetCurrentModule ()))
    {
      BuildRTExceptLeave (tok, true);
      GenQuadO (tok, M2Quads_CatchEndOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym, false);
    }
  BackPatch (M2StackWord_PopWord (ReturnStack), NextQuad);
  CheckNeedPriorityEnd (tok, SymbolTable_GetCurrentModule (), SymbolTable_GetCurrentModule ());
  SymbolTable_PutModuleEndQuad (SymbolTable_GetCurrentModule (), NextQuad);
  CheckVariablesInBlock (SymbolTable_GetCurrentModule ());
  GenQuadO (tok, M2Quads_InitEndOp, tok, SymbolTable_GetFileModule (), SymbolTable_GetCurrentModule (), false);
}


/*
   StartBuildFinally - Sets the start of finalization code of the
                       current module to the next quadruple.
*/

extern "C" void M2Quads_StartBuildFinally (unsigned int tok)
{
  NameKey_Name name;
  unsigned int ModuleSym;

  M2Quads_PopT (&name);
  ModuleSym = SymbolTable_GetCurrentModule ();
  M2Debug_Assert ((SymbolTable_IsModule (ModuleSym)) || (SymbolTable_IsDefImp (ModuleSym)));
  M2Debug_Assert ((SymbolTable_GetSymName (ModuleSym)) == name);
  SymbolTable_PutModuleFinallyStartQuad (ModuleSym, NextQuad);
  GenQuadO (tok, M2Quads_FinallyStartOp, tok, SymbolTable_GetFileModule (), ModuleSym, false);
  M2StackWord_PushWord (ReturnStack, static_cast<unsigned int> (0));
  M2Quads_PushT (name);
  /* CheckVariablesAt(ModuleSym) ;  */
  CheckNeedPriorityBegin (tok, ModuleSym, ModuleSym);
  M2StackWord_PushWord (TryStack, NextQuad);
  M2StackWord_PushWord (CatchStack, static_cast<unsigned int> (0));
  if (SymbolTable_HasExceptionFinally (ModuleSym))
    {
      GenQuadO (tok, M2Quads_TryOp, SymbolTable_NulSym, SymbolTable_NulSym, 0, false);
    }
}


/*
   EndBuildFinally - Sets the end finalization code of a module.
*/

extern "C" void M2Quads_EndBuildFinally (unsigned int tok)
{
  if (SymbolTable_HasExceptionFinally (SymbolTable_GetCurrentModule ()))
    {
      BuildRTExceptLeave (tok, true);
      GenQuadO (tok, M2Quads_CatchEndOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym, false);
    }
  BackPatch (M2StackWord_PopWord (ReturnStack), NextQuad);
  CheckNeedPriorityEnd (tok, SymbolTable_GetCurrentModule (), SymbolTable_GetCurrentModule ());
  SymbolTable_PutModuleFinallyEndQuad (SymbolTable_GetCurrentModule (), NextQuad);
  CheckVariablesInBlock (SymbolTable_GetCurrentModule ());
  GenQuadO (tok, M2Quads_FinallyEndOp, tok, SymbolTable_GetFileModule (), SymbolTable_GetCurrentModule (), false);
}


/*
   BuildExceptInitial - adds an CatchBeginOp, CatchEndOp quadruple
                        in the current block.
*/

extern "C" void M2Quads_BuildExceptInitial (unsigned int tok)
{
  unsigned int previous;

  /* we have finished the 'try' block, so now goto the return
      section which will tidy up (any) priorities before returning.
  */
  GenQuadO (tok, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, M2StackWord_PopWord (ReturnStack), false);
  M2StackWord_PushWord (ReturnStack, NextQuad-1);
  /* 
      this is the 'catch' block.
  */
  BackPatch (M2StackWord_PeepWord (TryStack, 1), NextQuad);
  GenQuadO (tok, M2Quads_CatchBeginOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym, false);
  previous = static_cast<unsigned int> (M2StackWord_PopWord (CatchStack));
  if (previous != 0)
    {
      M2MetaError_MetaErrorT0 (tok, (const char *) "{%E}only allowed one EXCEPT statement in a procedure or module", 62);
    }
  M2StackWord_PushWord (CatchStack, NextQuad-1);
  BuildRTExceptEnter (tok);
}


/*
   BuildExceptFinally - adds an ExceptOp quadruple in a modules
                        finally block.
*/

extern "C" void M2Quads_BuildExceptFinally (unsigned int tok)
{
  M2Quads_BuildExceptInitial (tok);
}


/*
   BuildExceptProcedure - adds an ExceptOp quadruple in a procedure
                          block.
*/

extern "C" void M2Quads_BuildExceptProcedure (unsigned int tok)
{
  M2Quads_BuildExceptInitial (tok);
}


/*
   BuildRetry - adds an RetryOp quadruple.
*/

extern "C" void M2Quads_BuildRetry (unsigned int tok)
{
  if ((M2StackWord_PeepWord (CatchStack, 1)) == 0)
    {
      M2MetaError_MetaErrorT0 (tok, (const char *) "{%E}the {%kRETRY} statement must occur after an {%kEXCEPT} statement in the same module or procedure block", 106);
    }
  else
    {
      BuildRTExceptLeave (tok, false);
      GenQuadO (tok, M2Quads_RetryOp, SymbolTable_NulSym, SymbolTable_NulSym, M2StackWord_PeepWord (TryStack, 1), false);
    }
}


/*
   BuildReThrow - creates a ThrowOp _ _ NulSym, indicating that
                  the exception needs to be rethrown.  The stack
                  is unaltered.
*/

extern "C" void M2Quads_BuildReThrow (unsigned int tokenno)
{
  GenQuadO (tokenno, M2Quads_ThrowOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym, false);
}


/*
   StartBuildInnerInit - Sets the start of initialization code of the
                         inner module to the next quadruple.
*/

extern "C" void M2Quads_StartBuildInnerInit (unsigned int tok)
{
  SymbolTable_PutModuleStartQuad (SymbolTable_GetCurrentModule (), NextQuad);
  GenQuadO (tok, M2Quads_InitStartOp, tok, SymbolTable_NulSym, SymbolTable_GetCurrentModule (), false);
  M2StackWord_PushWord (ReturnStack, static_cast<unsigned int> (0));
  CheckNeedPriorityBegin (tok, SymbolTable_GetCurrentModule (), SymbolTable_GetCurrentModule ());
  M2StackWord_PushWord (TryStack, NextQuad);
  M2StackWord_PushWord (CatchStack, static_cast<unsigned int> (0));
  if (SymbolTable_HasExceptionFinally (SymbolTable_GetCurrentModule ()))
    {
      GenQuadO (tok, M2Quads_TryOp, SymbolTable_NulSym, SymbolTable_NulSym, 0, false);
    }
}


/*
   EndBuildInnerInit - Sets the end initialization code of a module.
*/

extern "C" void M2Quads_EndBuildInnerInit (unsigned int tok)
{
  if (SymbolTable_HasExceptionBlock (SymbolTable_GetCurrentModule ()))
    {
      BuildRTExceptLeave (tok, true);
      GenQuadO (tok, M2Quads_CatchEndOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym, false);
    }
  SymbolTable_PutModuleEndQuad (SymbolTable_GetCurrentModule (), NextQuad);
  CheckVariablesInBlock (SymbolTable_GetCurrentModule ());
  BackPatch (M2StackWord_PopWord (ReturnStack), NextQuad);
  CheckNeedPriorityEnd (tok, SymbolTable_GetCurrentModule (), SymbolTable_GetCurrentModule ());
  GenQuadO (tok, M2Quads_InitEndOp, tok, SymbolTable_NulSym, SymbolTable_GetCurrentModule (), false);
}


/*
   BuildBuiltinConst - makes reference to a builtin constant within gm2.

                              Entry                 Exit

                       Ptr ->
                              +------------+        +------------+
                              | Ident      |        | Sym        |
                              |------------|        |------------|

                       Quadruple produced:

                       q    Sym  BuiltinConstOp  Ident
*/

extern "C" void M2Quads_BuildBuiltinConst (void)
{
  unsigned int idtok;
  unsigned int Id;
  unsigned int Sym;

  M2Quads_PopTtok (&Id, &idtok);
  Sym = SymbolTable_MakeTemporary (idtok, SymbolTable_ImmediateValue);
  SymbolTable_PutVar (Sym, M2Base_Integer);
  /* 
   CASE GetBuiltinConstType(KeyToCharStar(Name(Id))) OF

   0:  ErrorFormat1(NewError(GetTokenNo()),
                    '%a unrecognised builtin constant', Id) |
   1:  PutVar(Sym, Integer) |
   2:  PutVar(Sym, Real)

   ELSE
      InternalError ('unrecognised value')
   END ;
  */
  GenQuadO (idtok, M2Quads_BuiltinConstOp, Sym, SymbolTable_NulSym, Id, false);
  M2Quads_PushTtok (Sym, idtok);
}


/*
   BuildBuiltinTypeInfo - make reference to a builtin typeinfo function
                          within gm2.

                                 Entry                 Exit

                          Ptr ->
                                 +-------------+
                                 | Type        |
                                 |-------------|       +------------+
                                 | Ident       |       | Sym        |
                                 |-------------|       |------------|

                          Quadruple produced:

                          q    Sym  BuiltinTypeInfoOp  Type Ident
*/

extern "C" void M2Quads_BuildBuiltinTypeInfo (void)
{
  unsigned int idtok;
  unsigned int Ident;
  unsigned int Type;
  unsigned int Sym;

  M2Quads_PopTtok (&Ident, &idtok);
  M2Quads_PopT (&Type);
  Sym = SymbolTable_MakeTemporary (M2LexBuf_BuiltinTokenNo, SymbolTable_ImmediateValue);
  switch (m2builtins_GetBuiltinTypeInfoType (const_cast <const char * > (static_cast <char * > (NameKey_KeyToCharStar ((NameKey_Name) (Ident))))))
    {
      case 0:
        M2Error_ErrorFormat1 (M2Error_NewError (idtok), (const char *) "%a unrecognised builtin constant", 32, (const unsigned char *) &Ident, (sizeof (Ident)-1));
        break;

      case 1:
        SymbolTable_PutVar (Sym, M2Base_Boolean);
        break;

      case 2:
        SymbolTable_PutVar (Sym, M2Base_ZType);
        break;

      case 3:
        SymbolTable_PutVar (Sym, M2Base_RType);
        break;


      default:
        M2Error_InternalError ((const char *) "unrecognised value", 18);
        break;
    }
  GenQuadO (idtok, M2Quads_BuiltinTypeInfoOp, Sym, Type, Ident, false);
  M2Quads_PushTtok (Sym, idtok);
}


/*
   BuildAssignment - Builds an assignment from the values given on the
                     quad stack. Either an assignment to an
                     arithmetic expression or an assignment to a
                     boolean expression.  This procedure should not
                     be called in CONST declarations.
                     The Stack is expected to contain:


       Either

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Expression |
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  Expression

       OR

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | True |False|
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  TRUE
                     q+1   GotoOp                    q+3
                     q+2   BecomesOp  Designator  _  FALSE

*/

extern "C" void M2Quads_BuildAssignment (unsigned int becomesTokNo)
{
  unsigned int des;
  unsigned int exp;
  unsigned int destok;
  unsigned int exptok;
  unsigned int combinedtok;

  des = static_cast<unsigned int> (M2Quads_OperandT (2));
  if (IsReadOnly (des))
    {
      destok = static_cast<unsigned int> (M2Quads_OperandTok (2));
      exptok = static_cast<unsigned int> (M2Quads_OperandTok (1));
      exp = static_cast<unsigned int> (M2Quads_OperandT (1));
      if (DebugTokPos)
        {
          M2MetaError_MetaErrorT1 (destok, (const char *) "destok {%1Ead}", 14, des);
          M2MetaError_MetaErrorT1 (exptok, (const char *) "exptok {%1Ead}", 14, exp);
        }
      combinedtok = M2LexBuf_MakeVirtualTok (becomesTokNo, destok, exptok);
      if (DebugTokPos)
        {
          M2MetaError_MetaErrorT1 (combinedtok, (const char *) "combined {%1Ead}", 16, des);
        }
      if (IsBoolean (1))
        {
          M2MetaError_MetaErrorT1 (combinedtok, (const char *) "cannot assign expression to a constant designator {%1Ead}", 57, des);
        }
      else
        {
          exp = static_cast<unsigned int> (M2Quads_OperandT (1));
          M2MetaError_MetaErrorT2 (combinedtok, (const char *) "cannot assign a constant designator {%1Ead} with an expression {%2Ead}", 70, des, exp);
        }
      M2Quads_PopN (2);  /* Remove both parameters.  */
    }
  else if (SymbolTable_IsError (des))
    {
      /* avoid dangling else.  */
      M2Quads_PopN (2);  /* Remove both parameters.  */
    }
  else
    {
      /* avoid dangling else.  */
      doBuildAssignment (becomesTokNo, true, true);
    }
}


/*
   BuildAssignConstant - used to create constant in the CONST declaration.
                         The stack is expected to contain:

       Either

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Expression |
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  Expression

       OR

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | True |False|
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  TRUE
                     q+1   GotoOp                    q+3
                     q+2   BecomesOp  Designator  _  FALSE
*/

extern "C" void M2Quads_BuildAssignConstant (unsigned int equalsTokNo)
{
  doBuildAssignment (equalsTokNo, true, true);
}


/*
   BuildAlignment - builds an assignment to an alignment constant.

                    The Stack is expected to contain:


                            Entry                   Exit
                            =====                   ====

                    Ptr ->
                            +---------------+
                            | Expression    |
                            |---------------|
                            | bytealignment |
                            |---------------|       empty
*/

extern "C" void M2Quads_BuildAlignment (unsigned int tokno)
{
  NameKey_Name name;
  unsigned int expr;
  unsigned int align;

  M2Quads_PopT (&expr);
  M2Quads_PopT (&name);
  if (name != (NameKey_MakeKey ((const char *) "bytealignment", 13)))
    {
      M2MetaError_MetaError1 ((const char *) "expecting bytealignment identifier, rather than {%1Ea}", 54, SymbolTable_MakeError (tokno, name));
    }
  FifoQueue_GetConstFromFifoQueue (&align);
  M2Quads_PushT (align);
  M2Quads_PushT (expr);
  M2Quads_BuildAssignConstant (tokno);
}


/*
   BuildBitLength - builds an assignment to a bit length constant.

                    The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                    Ptr ->
                           +------------+
                           | Expression |
                           |------------|          empty
*/

extern "C" void M2Quads_BuildBitLength (unsigned int tokno)
{
  unsigned int expr;
  unsigned int length;

  M2Quads_PopT (&expr);
  FifoQueue_GetConstFromFifoQueue (&length);
  M2Quads_PushT (length);
  M2Quads_PushT (expr);
  M2Quads_BuildAssignConstant (tokno);
}


/*
   BuildPragmaField - builds an assignment to an alignment constant.

                      The Stack is expected to contain:


                      Entry                   Exit
                      =====                   ====

               Ptr ->
                      +------------+
                      | Expression |
                      |------------|          empty
*/

extern "C" void M2Quads_BuildPragmaField (void)
{
  unsigned int expr;
  unsigned int const_;
  NameKey_Name name;

  M2Quads_PopT (&expr);
  M2Quads_PopT (&name);
  if ((name != (NameKey_MakeKey ((const char *) "unused", 6))) && (name != (NameKey_MakeKey ((const char *) "bytealignment", 13))))
    {
      M2MetaError_MetaError0 ((const char *) "only allowed to use the attribute {%Ekbytealignment} in the default record field alignment pragma", 97);
    }
  if (expr != SymbolTable_NulSym)
    {
      FifoQueue_GetConstFromFifoQueue (&const_);
      M2Quads_PushT (const_);
      M2Quads_PushT (expr);
      M2Quads_BuildAssignConstant (M2LexBuf_GetTokenNo ());
    }
}


/*
   BuildDefaultFieldAlignment - builds an assignment to an alignment constant.

                                The Stack is expected to contain:


                                       Entry                   Exit
                                       =====                   ====

                                Ptr ->
                                       +------------+
                                       | Expression |
                                       |------------|          empty
*/

extern "C" void M2Quads_BuildDefaultFieldAlignment (void)
{
  unsigned int expr;
  unsigned int align;
  NameKey_Name name;

  M2Quads_PopT (&expr);
  M2Quads_PopT (&name);
  if (name != (NameKey_MakeKey ((const char *) "bytealignment", 13)))
    {
      M2MetaError_MetaError0 ((const char *) "{%E}only allowed to use the attribute {%kbytealignment} in the default record field alignment pragma", 100);
    }
  FifoQueue_GetConstFromFifoQueue (&align);
  M2Quads_PushT (align);
  M2Quads_PushT (expr);
  M2Quads_BuildAssignConstant (M2LexBuf_GetTokenNo ());
}


/*
   BuildRepeat - Builds the repeat statement from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====


                 Empty
                                                        <- Ptr
                                         +------------+
                                         | RepeatQuad |
                                         |------------|

*/

extern "C" void M2Quads_BuildRepeat (void)
{
  M2Quads_PushT (NextQuad);
}


/*
   BuildUntil - Builds the until part of the repeat statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

        Ptr ->
                +------------+
                | t   | f    |
                |------------|
                | RepeatQuad |          Empty
                |------------|
*/

extern "C" void M2Quads_BuildUntil (void)
{
  unsigned int t;
  unsigned int f;
  unsigned int Repeat;

  CheckBooleanId ();
  PopBool (&t, &f);
  M2Quads_PopT (&Repeat);
  BackPatch (f, Repeat);  /* If False then keep on repeating  */
  BackPatch (t, NextQuad);  /* If True then exit repeat  */
}


/*
   BuildWhile - Builds the While part of the While statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

                                                       <- Ptr
                                        |------------|
                Empty                   | WhileQuad  |
                                        |------------|
*/

extern "C" void M2Quads_BuildWhile (void)
{
  M2Quads_PushT (NextQuad);
}


/*
   BuildDoWhile - Builds the Do part of the while statement
                  from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

          Ptr ->
                  +------------+          +------------+
                  | t   | f    |          | 0    | f   |
                  |------------|          |------------|
                  | WhileQuad  |          | WhileQuad  |
                  |------------|          |------------|

                  Quadruples

                  BackPatch t exit to the NextQuad
*/

extern "C" void M2Quads_BuildDoWhile (void)
{
  unsigned int t;
  unsigned int f;

  CheckBooleanId ();
  PopBool (&t, &f);
  BackPatch (t, NextQuad);
  PushBool (0, f);
}


/*
   BuildEndWhile - Builds the end part of the while statement
                   from the quad stack.
                   The Stack is expected to contain:


                   Entry                   Exit
                   =====                   ====

           Ptr ->
                   +------------+
                   | t   | f    |
                   |------------|
                   | WhileQuad  |          Empty
                   |------------|

                   Quadruples

                   q    GotoOp  WhileQuad
                   False exit is backpatched with q+1
*/

extern "C" void M2Quads_BuildEndWhile (int reltokpos)
{
  unsigned int tok;
  unsigned int While;
  unsigned int t;
  unsigned int f;

  tok = M2LexBuf_GetTokenNo ();
  tok = ((int ) (tok))+reltokpos;
  PopBool (&t, &f);
  M2Debug_Assert (t == 0);
  M2Quads_PopT (&While);
  GenQuadO (tok, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, While, false);
  BackPatch (f, NextQuad);
}


/*
   BuildLoop - Builds the Loop part of the Loop statement
               from the quad stack.
               The Stack is expected to contain:


               Entry                   Exit
               =====                   ====

                                                      <- Ptr
               Empty                   +------------+
                                       | LoopQuad   |
                                       |------------|
*/

extern "C" void M2Quads_BuildLoop (void)
{
  M2Quads_PushT (NextQuad);
  PushExit (0);  /* Seperate Exit Stack for loop end  */
}


/*
   BuildExit - Builds the Exit part of the Loop statement.
*/

extern "C" void M2Quads_BuildExit (void)
{
  if (M2StackWord_IsEmptyWord (ExitStack))
    {
      M2MetaError_MetaError0 ((const char *) "{%EkEXIT} is only allowed in a {%kLOOP} statement", 49);
    }
  else
    {
      GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
      PushExit (Merge (PopExit (), NextQuad-1));
    }
}


/*
   BuildEndLoop - Builds the End part of the Loop statement
                  from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

          Ptr ->
                  +------------+
                  | LoopQuad   |          Empty
                  |------------|

                  Quadruples

                  Goto  _  _  LoopQuad
*/

extern "C" void M2Quads_BuildEndLoop (void)
{
  unsigned int Loop;

  M2Quads_PopT (&Loop);
  GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, Loop);
  BackPatch (PopExit (), NextQuad);
}


/*
   BuildThenIf - Builds the Then part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->                                          <- Ptr
                 +------------+          +------------+
                 | t   | f    |          | 0    | f   |
                 |------------|          |------------|

                 Quadruples

                 The true exit is BackPatched to point to
                 the NextQuad.
*/

extern "C" void M2Quads_BuildThenIf (void)
{
  unsigned int t;
  unsigned int f;

  CheckBooleanId ();
  PopBool (&t, &f);
  BackPatch (t, NextQuad);
  PushBool (0, f);
}


/*
   BuildElse - Builds the Else part of the If statement
               from the quad stack.
               The Stack is expected to contain:


               Entry                   Exit
               =====                   ====

       Ptr ->
               +------------+          +------------+
               | t   | f    |          | t+q  | 0   |
               |------------|          |------------|

               Quadruples

               q    GotoOp  _  _  0
               q+1  <- BackPatched from f
*/

extern "C" void M2Quads_BuildElse (void)
{
  unsigned int t;
  unsigned int f;

  GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
  PopBool (&t, &f);
  BackPatch (f, NextQuad);
  PushBool (Merge (t, NextQuad-1), 0);  /* NextQuad-1 = Goto Quad  */
}


/*
   BuildEndIf - Builds the End part of the If statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

        Ptr ->
                +------------+
                | t   | f    |          Empty
                |------------|

                Quadruples

                Both t and f are backpatched to point to the NextQuad
*/

extern "C" void M2Quads_BuildEndIf (void)
{
  unsigned int t;
  unsigned int f;

  PopBool (&t, &f);
  BackPatch (t, NextQuad);
  BackPatch (f, NextQuad);
}


/*
   BuildElsif1 - Builds the Elsif part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+          +------------+
                 | t   | f    |          | t+q  | 0   |
                 |------------|          |------------|

                 Quadruples

                 q    GotoOp  _  _  0
                 q+1  <- BackPatched from f
*/

extern "C" void M2Quads_BuildElsif1 (void)
{
  unsigned int t;
  unsigned int f;

  GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
  PopBool (&t, &f);
  BackPatch (f, NextQuad);
  PushBool (Merge (t, NextQuad-1), 0);  /* NextQuad-1 = Goto Quad  */
}


/*
   BuildElsif2 - Builds the Elsif until part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

          Ptr ->
                 +--------------+
                 | 0    | f1    |                            <- Ptr
                 |--------------|          +---------------+
                 | t2   | f2    |          | t2    | f1+f2 |
                 |--------------|          |---------------|
*/

extern "C" void M2Quads_BuildElsif2 (void)
{
  unsigned int t1;
  unsigned int f1;
  unsigned int t2;
  unsigned int f2;

  PopBool (&t1, &f1);
  M2Debug_Assert (t1 == 0);
  PopBool (&t2, &f2);
  PushBool (t2, Merge (f1, f2));
}


/*
   BuildForToByDo - Builds the For To By Do part of the For statement
                    from the quad stack.
                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

                                                               <- Ptr
                                            +----------------+
             Ptr ->                         | RangeId        |
                    +----------------+      |----------------|
                    | BySym | ByType |      | ForQuad        |
                    |----------------|      |----------------|
                    | e2             |      | LastValue      |
                    |----------------|      |----------------|
                    | e1             |      | BySym | ByType |
                    |----------------|      |----------------|
                    | Ident          |      | IdentSym       |
                    |----------------|      |----------------|


                    x := e1 ;
                    Note that LASTVALUE is calculated during M2GenGCC
                         after all the types have been resolved.
                    LASTVALUE := ((e2-e1) DIV BySym) * BySym + e1
                    IF BySym<0
                    THEN
                       IF e1<e2
                       THEN
                          goto exit
                       END
                    ELSE
                       IF e1>e2
                       THEN
                          goto exit
                       END
                    END ;
                    LOOP
                       body
                       IF x=LASTVALUE
                       THEN
                          goto exit
                       END ;
                       INC(x, BySym)
                    END

                    Quadruples:

                    q     BecomesOp  IdentSym  _  e1
                    q+    LastForIteratorOp  LastValue  := ((e1-e2) DIV by) * by + e1
                    q+1   if >=      by        0  q+..2
                    q+2   GotoOp                  q+3
                    q+3   If >=      e1  e2       q+5
                    q+4   GotoOp                  exit
                    q+5   ..
                    q+..1 Goto                    q+..5
                    q+..2 If >=      e2  e1       q+..4
                    q+..3 GotoOp                  exit
                    q+..4 ..

                    The For Loop is regarded:

                    For ident := e1 To e2 By by Do

                    End
*/

extern "C" void M2Quads_BuildForToByDo (void)
{
  M2Quads_LineNote l1;
  M2Quads_LineNote l2;
  NameKey_Name e1;
  NameKey_Name e2;
  NameKey_Name Id;
  unsigned int e1tok;
  unsigned int e2tok;
  unsigned int idtok;
  unsigned int bytok;
  unsigned int LastIterator;
  unsigned int exit1;
  unsigned int IdSym;
  unsigned int BySym;
  unsigned int ByType;
  unsigned int ForLoop;
  unsigned int RangeId;
  unsigned int t;
  unsigned int f;
  unsigned int etype;
  unsigned int t1;

  l2 = PopLineNo ();
  l1 = PopLineNo ();
  UseLineNote (l1);
  PushFor (0);
  M2Quads_PopTFtok (&BySym, &ByType, &bytok);
  M2Quads_PopTtok (&e2, &e2tok);
  M2Quads_PopTtok (&e1, &e1tok);
  M2Quads_PopTtok (&Id, &idtok);
  IdSym = SymbolTable_RequestSym (idtok, Id);
  RangeId = M2Range_InitForLoopBeginRangeCheck (IdSym, idtok, e1, e1tok, e2, e2tok, BySym, bytok);
  BuildRange (RangeId);
  M2Quads_PushTtok (IdSym, idtok);
  M2Quads_PushTtok (e1, e1tok);
  BuildAssignmentWithoutBounds (idtok, true, true);
  UseLineNote (l2);
  LastIterator = SymbolTable_MakeTemporary (e2tok, AreConstant (((SymbolTable_IsConst (e1)) && (SymbolTable_IsConst (e2))) && (SymbolTable_IsConst (BySym))));
  SymbolTable_PutVar (LastIterator, SymbolTable_GetSType (IdSym));
  etype = M2Base_MixTypes (SymbolTable_GetSType (e1), SymbolTable_GetSType (e2), e2tok);
  e1 = doConvert (etype, e1);
  e2 = doConvert (etype, e2);
  ForLoopLastIterator (LastIterator, e1, e2, BySym, e1tok, e2tok, bytok);
  /* q+2 GotoOp                  q+3  */
  M2Quads_PushTFtok (BySym, ByType, bytok);  /* BuildRelOp  1st parameter.  */
  M2Quads_PushT (M2Reserved_GreaterEqualTok);  /* 2nd parameter.  */
  /* 3rd parameter.  */
  PushZero (bytok, ByType);
  M2Quads_BuildRelOp (e2tok);  /* Choose final expression position.  */
  PopBool (&t, &f);  /* Choose final expression position.  */
  BackPatch (f, NextQuad);
  /* q+4 GotoOp                  Exit  */
  M2Quads_PushTFtok (e1, SymbolTable_GetSType (e1), e1tok);  /* BuildRelOp  1st parameter  */
  M2Quads_PushT (M2Reserved_GreaterEqualTok);  /* 2nd parameter  */
  M2Quads_PushTFtok (e2, SymbolTable_GetSType (e2), e2tok);  /* 3rd parameter  */
  M2Quads_BuildRelOp (e2tok);  /* Choose final expression position.  */
  PopBool (&t1, &exit1);  /* Choose final expression position.  */
  BackPatch (t1, NextQuad);
  PushFor (Merge (PopFor (), exit1));  /* Merge exit1.  */
  GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);  /* Merge exit1.  */
  ForLoop = NextQuad-1;
  /* ELSE.  */
  BackPatch (t, NextQuad);
  M2Quads_PushTFtok (e2, SymbolTable_GetSType (e2), e2tok);  /* BuildRelOp  1st parameter  */
  M2Quads_PushT (M2Reserved_GreaterEqualTok);  /* 2nd parameter  */
  M2Quads_PushTFtok (e1, SymbolTable_GetSType (e1), e1tok);  /* 3rd parameter  */
  M2Quads_BuildRelOp (e2tok);  /* 3rd parameter  */
  PopBool (&t1, &exit1);
  BackPatch (t1, NextQuad);
  PushFor (Merge (PopFor (), exit1));  /* Merge exit1.  */
  BackPatch (ForLoop, NextQuad);  /* Fixes the start of the for loop.  */
  ForLoop = NextQuad;
  /* And set up the stack.  */
  M2Quads_PushTFtok (IdSym, SymbolTable_GetSym (IdSym), idtok);
  M2Quads_PushTFtok (BySym, ByType, bytok);
  M2Quads_PushTFtok (LastIterator, SymbolTable_GetSType (LastIterator), e2tok);
  M2Quads_PushT (ForLoop);
  M2Quads_PushT (RangeId);
}


/*
   BuildPseudoBy - Builds the Non existant part of the By
                   clause of the For statement
                   from the quad stack.
                   The Stack is expected to contain:


                   Entry                   Exit
                   =====                   ====

                                                           <- Ptr
                                           +------------+
            Ptr ->                         | BySym | t  |
                   +------------+          |------------|
                   | e    | t   |          | e     | t  |
                   |------------|          |------------|
*/

extern "C" void M2Quads_BuildPseudoBy (void)
{
  unsigned int expr;
  unsigned int type;
  unsigned int dotok;

  /* As there is no BY token this position is the DO at the end of the last expression.  */
  M2Quads_PopTFtok (&expr, &type, &dotok);
  M2Quads_PushTFtok (expr, type, dotok);
  if (type == SymbolTable_NulSym)
    {}  /* empty.  */
  /* Use type.  */
  else if ((SymbolTable_IsEnumeration (SymbolTable_SkipType (type))) || ((SymbolTable_SkipType (type)) == M2Base_Char))
    {
      /* avoid dangling else.  */
    }
  else if (M2Base_IsOrdinalType (SymbolTable_SkipType (type)))
    {
      /* avoid dangling else.  */
      type = M2Base_ZType;
    }
  PushOne (dotok, type, (const char *) "the implied {%kFOR} loop increment will cause an overflow {%1ad}", 64);
}


/*
   BuildEndFor - Builds the End part of the For statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +----------------+
                 | RangeId        |
                 |----------------|
                 | ForQuad        |
                 |----------------|
                 | LastValue      |
                 |----------------|
                 | BySym | ByType |
                 |----------------|
                 | IdSym          |      Empty
                 |----------------|
*/

extern "C" void M2Quads_BuildEndFor (unsigned int endpostok)
{
  unsigned int t;
  unsigned int f;
  unsigned int tsym;
  unsigned int RangeId;
  unsigned int IncQuad;
  unsigned int ForQuad;
  unsigned int LastSym;
  unsigned int ByType;
  unsigned int BySym;
  unsigned int bytok;
  unsigned int IdSym;
  unsigned int idtok;

  M2Quads_PopT (&RangeId);
  M2Quads_PopT (&ForQuad);
  M2Quads_PopT (&LastSym);
  M2Quads_PopTFtok (&BySym, &ByType, &bytok);
  M2Quads_PopTtok (&IdSym, &idtok);
  /* IF IdSym=LastSym THEN exit END  */
  M2Quads_PushTF (IdSym, SymbolTable_GetSType (IdSym));
  M2Quads_PushT (M2Reserved_EqualTok);
  M2Quads_PushTF (LastSym, SymbolTable_GetSType (LastSym));
  M2Quads_BuildRelOp (endpostok);
  PopBool (&t, &f);
  BackPatch (t, NextQuad);
  GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
  PushFor (Merge (PopFor (), NextQuad-1));
  BackPatch (f, NextQuad);
  if ((SymbolTable_GetMode (IdSym)) == SymbolTable_LeftValue)
    {
      /* index variable is a LeftValue, therefore we must dereference it  */
      tsym = SymbolTable_MakeTemporary (idtok, SymbolTable_RightValue);
      SymbolTable_PutVar (tsym, SymbolTable_GetSType (IdSym));
      CheckPointerThroughNil (idtok, IdSym);
      doIndrX (endpostok, tsym, IdSym);
      BuildRange (M2Range_InitForLoopEndRangeCheck (tsym, BySym));  /* --fixme-- pass endpostok.  */
      IncQuad = NextQuad;
      /* we have explicitly checked using the above and also
         this addition can legitimately overflow if a cardinal type
         is counting down.  The above test will generate a more
         precise error message, so we suppress overflow detection
         here.  */
      GenQuadOTypetok (bytok, M2Quads_AddOp, tsym, tsym, BySym, false, false, idtok, idtok, bytok);
      CheckPointerThroughNil (idtok, IdSym);
      GenQuadOtok (idtok, M2Quads_XIndrOp, IdSym, SymbolTable_GetSType (IdSym), tsym, false, idtok, idtok, idtok);
    }
  else
    {
      BuildRange (M2Range_InitForLoopEndRangeCheck (IdSym, BySym));
      IncQuad = NextQuad;
      /* we have explicitly checked using the above and also
         this addition can legitimately overflow if a cardinal type
         is counting down.  The above test will generate a more
         precise error message, so we suppress overflow detection
         here.

         This quadruple suppresses the generic binary op type
         check (performed in M2GenGCC.mod) as there
         will be a more informative/exhaustive check performed by the
         InitForLoopBeginRangeCheck setup in BuildForToByDo and
         performed by M2Range.mod.  */
      GenQuadOTypetok (idtok, M2Quads_AddOp, IdSym, IdSym, BySym, false, false, idtok, idtok, bytok);
    }
  GenQuadO (endpostok, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, ForQuad, false);
  BackPatch (PopFor (), NextQuad);
  AddForInfo (ForQuad, NextQuad-1, IncQuad, IdSym, idtok);
  M2Range_PutRangeForIncrement (RangeId, IncQuad);
}


/*
   BuildCaseStart - starts the case statement.
                    It initializes a backpatch list on the compile
                    time stack, the list is used to contain all
                    case break points. The list is later backpatched
                    and contains all positions of the case statement
                    which jump to the end of the case statement.
                    The stack also contains room for a boolean
                    expression, this is needed to allow , operator
                    in the CaseField alternatives.

                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

                                                           <- Ptr
                                            +------------+
                                            | 0    | 0   |
                                            |------------|
                                            | 0    | 0   |
                    +-------------+         |------------|
                    | Expr |      |         | Expr |     |
                    |-------------|         |------------|
*/

extern "C" void M2Quads_BuildCaseStart (void)
{
  BuildRange (M2Range_InitCaseBounds (M2CaseList_PushCase (SymbolTable_NulSym, SymbolTable_NulSym, M2Quads_OperandT (1))));
  PushBool (0, 0);  /* BackPatch list initialized  */
  PushBool (0, 0);  /* Room for a boolean expression  */
}


/*
   BuildCaseStartStatementSequence - starts the statement sequence
                                     inside a case clause.
                                     BackPatches the true exit to the
                                     NextQuad.
                                     The Stack:

                                     Entry             Exit

                              Ptr ->                                  <- Ptr
                                     +-----------+     +------------+
                                     | t   | f   |     | 0   | f    |
                                     |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseStartStatementSequence (void)
{
  unsigned int t;
  unsigned int f;

  PopBool (&t, &f);
  BackPatch (t, NextQuad);
  PushBool (0, f);
}


/*
   BuildCaseEndStatementSequence - ends the statement sequence
                                   inside a case clause.
                                   BackPatches the false exit f1 to the
                                   NextQuad.
                                   Asserts that t1 and f2 is 0
                                   Pushes t2+q and 0

                                   Quadruples:

                                   q  GotoOp  _  _  0

                                   The Stack:

                                   Entry             Exit

                            Ptr ->                                  <- Ptr
                                   +-----------+     +------------+
                                   | t1  | f1  |     | 0    | 0   |
                                   |-----------|     |------------|
                                   | t2  | f2  |     | t2+q | 0   |
                                   |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseEndStatementSequence (void)
{
  unsigned int t1;
  unsigned int f1;
  unsigned int t2;
  unsigned int f2;

  GenQuad (M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
  PopBool (&t1, &f1);
  PopBool (&t2, &f2);  /* t2 contains the break list for the case  */
  BackPatch (f1, NextQuad);  /* f1 no longer needed  */
  M2Debug_Assert (t1 == 0);  /* f1 no longer needed  */
  M2Debug_Assert (f2 == 0);
  PushBool (Merge (t2, NextQuad-1), 0);  /* NextQuad-1 = Goto Quad  */
  PushBool (0, 0);  /* Room for boolean expression  */
}


/*
   BuildCaseRange - builds the range testing quaruples for
                    a case clause.

                    IF (e1>=ce1) AND (e1<=ce2)
                    THEN

                    ELS..

                    The Stack:

                    Entry             Exit

             Ptr ->
                    +-----------+
                    | ce2       |                   <- Ptr
                    |-----------|     +-----------+
                    | ce1       |     | t   | f   |
                    |-----------|     |-----------|
                    | t1  | f1  |     | t1  | f1  |
                    |-----------|     |-----------|
                    | t2  | f2  |     | t2  | f2  |
                    |-----------|     |-----------|
                    | e1        |     | e1        |
                    |-----------|     |-----------|
*/

extern "C" void M2Quads_BuildCaseRange (void)
{
  unsigned int ce1;
  unsigned int ce2;
  unsigned int combinedtok;
  unsigned int ce1tok;
  unsigned int ce2tok;
  unsigned int e1tok;
  unsigned int e1;
  unsigned int t2;
  unsigned int f2;
  unsigned int t1;
  unsigned int f1;

  M2Quads_PopTtok (&ce2, &ce2tok);
  M2Quads_PopTtok (&ce1, &ce1tok);
  combinedtok = M2LexBuf_MakeVirtualTok (ce2tok, ce2tok, ce1tok);
  M2CaseList_AddRange (ce1, ce2, combinedtok);
  PopBool (&t1, &f1);
  PopBool (&t2, &f2);
  M2Quads_PopTtok (&e1, &e1tok);
  M2Quads_PushTtok (e1, e1tok);  /* leave e1 on bottom of stack when exit procedure  */
  PushBool (t2, f2);  /* leave e1 on bottom of stack when exit procedure  */
  PushBool (t1, f1);  /* also leave t1 and f1 on the bottom of the stack  */
  M2Quads_PushTtok (e1, e1tok);  /* also leave t1 and f1 on the bottom of the stack  */
  M2Quads_PushT (M2Reserved_GreaterEqualTok);
  M2Quads_PushTtok (ce1, ce1tok);
  M2Quads_BuildRelOp (combinedtok);
  M2Quads_PushT (M2Reserved_AndTok);
  M2Quads_RecordOp ();
  M2Quads_PushTtok (e1, e1tok);
  M2Quads_PushT (M2Reserved_LessEqualTok);
  M2Quads_PushTtok (ce2, ce2tok);
  M2Quads_BuildRelOp (combinedtok);
  M2Quads_BuildBinaryOp ();
}


/*
   BuildCaseEquality - builds the range testing quadruples for
                       a case clause.

                       IF e1=ce1
                       THEN

                       ELS..

                       The Stack:

                       Entry             Exit

                Ptr ->
                       +-----------+     +-----------+
                       | ce1       |     | t   | f   |
                       |-----------|     |-----------|
                       | t1  | f1  |     | t1  | f1  |
                       |-----------|     |-----------|
                       | t2  | f2  |     | t2  | f2  |
                       |-----------|     |-----------|
                       | e1        |     | e1        |
                       |-----------|     |-----------|
*/

extern "C" void M2Quads_BuildCaseEquality (void)
{
  unsigned int ce1tok;
  unsigned int e1tok;
  unsigned int ce1;
  unsigned int e1;
  unsigned int t2;
  unsigned int f2;
  unsigned int t1;
  unsigned int f1;

  M2Quads_PopTtok (&ce1, &ce1tok);
  M2CaseList_AddRange (ce1, SymbolTable_NulSym, ce1tok);
  PopBool (&t1, &f1);
  PopBool (&t2, &f2);
  M2Quads_PopTtok (&e1, &e1tok);
  M2Quads_PushTtok (e1, e1tok);  /* leave e1 on bottom of stack when exit procedure  */
  PushBool (t2, f2);  /* also leave t2 and f2 on the bottom of the stack  */
  PushBool (t1, f1);  /* also leave t2 and f2 on the bottom of the stack  */
  M2Quads_PushTtok (e1, e1tok);
  M2Quads_PushT (M2Reserved_EqualTok);
  M2Quads_PushTtok (ce1, ce1tok);
  M2Quads_BuildRelOp (ce1tok);
}


/*
   BuildCaseList - merges two case tests into one

                   The Stack:

                   Entry             Exit

            Ptr ->
                   +-----------+
                   | t2  | f2  |
                   |-----------|     +-------------+
                   | t1  | f1  |     | t1+t2| f1+f2|
                   |-----------|     |-------------|
*/

extern "C" void M2Quads_BuildCaseList (void)
{
  unsigned int t2;
  unsigned int f2;
  unsigned int t1;
  unsigned int f1;

  PopBool (&t2, &f2);
  PopBool (&t1, &f1);
  PushBool (Merge (t1, t2), Merge (f1, f2));
}


/*
   BuildCaseOr - builds the , in the case clause.

                 The Stack:

                 Entry             Exit

          Ptr ->                                  <- Ptr
                 +-----------+     +------------+
                 | t   | f   |     | t    | 0   |
                 |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseOr (void)
{
  unsigned int t;
  unsigned int f;

  PopBool (&t, &f);
  BackPatch (f, NextQuad);
  PushBool (t, 0);
}


/*
   BuildCaseElse - builds the else of case clause.

                  The Stack:

                  Entry             Exit

           Ptr ->                                  <- Ptr
                  +-----------+     +------------+
                  | t   | f   |     | t    | 0   |
                  |-----------|     |------------|
*/

extern "C" void M2Quads_BuildCaseElse (void)
{
  unsigned int t;
  unsigned int f;

  PopBool (&t, &f);
  BackPatch (f, NextQuad);
  PushBool (t, 0);
}


/*
   BuildCaseEnd - builds the end of case clause.

                  The Stack:

                  Entry             Exit

           Ptr ->
                  +-----------+
                  | t1  | f1  |
                  |-----------|
                  | t2  | f2  |
                  |-----------|
                  | e1        |
                  |-----------|     Empty
*/

extern "C" void M2Quads_BuildCaseEnd (void)
{
  unsigned int e1;
  unsigned int t;
  unsigned int f;

  PopBool (&t, &f);
  BackPatch (f, NextQuad);
  BackPatch (t, NextQuad);
  PopBool (&t, &f);
  BackPatch (f, NextQuad);
  BackPatch (t, NextQuad);
  M2Quads_PopT (&e1);
  M2CaseList_PopCase ();
}


/*
   BuildCaseCheck - builds the case checking code to ensure that
                    the program does not need an else clause at runtime.
                    The stack is unaltered.
*/

extern "C" void M2Quads_BuildCaseCheck (void)
{
  BuildError (M2Range_InitNoElseRangeCheck ());
}


/*
   BuildNulParam - Builds a nul parameter on the stack.
                   The Stack:

                   Entry             Exit

                                                    <- Ptr
                   Empty             +------------+
                                     | 0          |
                                     |------------|
*/

extern "C" void M2Quads_BuildNulParam (void)
{
  M2Quads_PushT (static_cast<unsigned int> (0));
}


/*
   BuildProcedureCall - builds a procedure call.
                        Although this procedure does not directly
                        destroy the procedure parameters, it calls
                        routine which will manipulate the stack and
                        so the entry and exit states of the stack are shown.

                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

extern "C" void M2Quads_BuildProcedureCall (unsigned int tokno)
{
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  M2Quads_PushT (NoOfParam);  /* Compile time stack restored to entry state  */
  if ((M2Base_IsPseudoBaseProcedure (ProcSym)) || (M2System_IsPseudoSystemProcedure (ProcSym)))  /* Compile time stack restored to entry state  */
    {
      M2Quads_DisplayStack ();
      ManipulatePseudoCallParameters ();
      M2Quads_DisplayStack ();
      BuildPseudoProcedureCall (tokno);
      M2Quads_DisplayStack ();
    }
  else if (SymbolTable_IsUnknown (ProcSym))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "{%1Ua} is not recognised as a procedure, check declaration or import", 68, ProcSym);
      M2Quads_PopN (NoOfParam+2);
    }
  else
    {
      /* avoid dangling else.  */
      M2Quads_DisplayStack ();
      BuildRealProcedureCall (tokno);
      M2Quads_DisplayStack ();
    }
}


/*
   CheckBuildFunction - checks to see whether ProcSym is a function
                        and if so it adds a TempSym value which will
                        hold the return value once the function finishes.
                        This procedure also generates an error message
                        if the user is calling a function and ignoring
                        the return result.  The additional TempSym
                        is not created if ProcSym is a procedure
                        and the stack is unaltered.

                        The Stack:


                       Entry                      Exit

                Ptr ->

                                                  +----------------+
                                                  | ProcSym | Type |
                       +----------------+         |----------------|
                       | ProcSym | Type |         | TempSym | Type |
                       |----------------|         |----------------|
*/

extern "C" bool M2Quads_CheckBuildFunction (void)
{
  unsigned int tokpos;
  unsigned int TempSym;
  unsigned int ProcSym;
  unsigned int Type;

  M2Quads_PopTFtok (&ProcSym, &Type, &tokpos);
  if ((SymbolTable_IsVar (ProcSym)) && (SymbolTable_IsProcType (Type)))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_GetSType (Type)) != SymbolTable_NulSym)
        {
          TempSym = SymbolTable_MakeTemporary (tokpos, SymbolTable_RightValue);
          SymbolTable_PutVar (TempSym, SymbolTable_GetSType (Type));
          M2Quads_PushTFtok (TempSym, SymbolTable_GetSType (Type), tokpos);
          M2Quads_PushTFtok (ProcSym, Type, tokpos);
          if (! (SymbolTable_IsReturnOptionalAny (Type)))
            {
              M2MetaError_MetaErrorT1 (tokpos, (const char *) "function {%1Ea} is called but its return value is ignored", 57, ProcSym);
            }
          return true;
        }
    }
  else if ((SymbolTable_IsProcedure (ProcSym)) && (Type != SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      TempSym = SymbolTable_MakeTemporary (tokpos, SymbolTable_RightValue);
      SymbolTable_PutVar (TempSym, Type);
      M2Quads_PushTFtok (TempSym, Type, tokpos);
      M2Quads_PushTFtok (ProcSym, Type, tokpos);
      if (! (SymbolTable_IsReturnOptionalAny (ProcSym)))
        {
          M2MetaError_MetaErrorT1 (tokpos, (const char *) "function {%1Ea} is called but its return value is ignored", 57, ProcSym);
        }
      return true;
    }
  M2Quads_PushTFtok (ProcSym, Type, tokpos);
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildFunctionCall - builds a function call.
                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|
*/

extern "C" void M2Quads_BuildFunctionCall (bool ConstExpr)
{
  unsigned int paramtok;
  unsigned int combinedtok;
  unsigned int functok;
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfParam);
  functok = OperandTtok (NoOfParam+1);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  ProcSym = PCSymBuild_SkipConst (ProcSym);
  M2Quads_PushT (NoOfParam);
  /* Compile time stack restored to entry state.  */
  if (SymbolTable_IsUnknown (ProcSym))
    {
      paramtok = OperandTtok (1);
      combinedtok = M2LexBuf_MakeVirtual2Tok (functok, paramtok);
      M2MetaError_MetaErrorT1 (functok, (const char *) "procedure function {%1Ea} is undefined", 38, ProcSym);
      M2Quads_PopN (NoOfParam+2);
      /* Fake return value to continue compiling.  */
      M2Quads_PushT (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), SymbolTable_NulSym));
    }
  else if (SymbolTable_IsAModula2Type (ProcSym))
    {
      /* avoid dangling else.  */
      ManipulatePseudoCallParameters ();
      BuildTypeCoercion (ConstExpr);
    }
  else if ((M2System_IsPseudoSystemFunction (ProcSym)) || (M2Base_IsPseudoBaseFunction (ProcSym)))
    {
      /* avoid dangling else.  */
      ManipulatePseudoCallParameters ();
      BuildPseudoFunctionCall (ConstExpr);
    }
  else
    {
      /* avoid dangling else.  */
      BuildRealFunctionCall (functok, ConstExpr);
    }
}


/*
   BuildConstFunctionCall - builds a function call and checks that this function can be
                            called inside a ConstExpression.

                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |                        <- Ptr
                            |----------------|         +------------+
                            | ProcSym | Type |         | ReturnVar  |
                            |----------------|         |------------|

*/

extern "C" void M2Quads_BuildConstFunctionCall (void)
{
  unsigned int functok;
  unsigned int combinedtok;
  unsigned int paramtok;
  unsigned int ConstExpression;
  unsigned int NoOfParam;
  unsigned int ProcSym;

  M2Quads_DisplayStack ();
  M2Quads_PopT (&NoOfParam);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
  functok = OperandTtok (NoOfParam+1);
  if (M2Options_CompilerDebugging)
    {
      M2Printf_printf2 ((const char *) "procsym = %d  token = %d\\n", 26, (const unsigned char *) &ProcSym, (sizeof (ProcSym)-1), (const unsigned char *) &functok, (sizeof (functok)-1));
    }
  /* ErrorStringAt (InitString ('constant function'), functok).  */
  M2Quads_PushT (NoOfParam);
  if ((ProcSym != M2Base_Convert) && (((M2Base_IsPseudoBaseFunction (ProcSym)) || (M2System_IsPseudoSystemFunctionConstExpression (ProcSym))) || ((SymbolTable_IsProcedure (ProcSym)) && (SymbolTable_IsProcedureBuiltin (ProcSym)))))
    {
      M2Quads_BuildFunctionCall (true);
    }
  else
    {
      if (SymbolTable_IsAModula2Type (ProcSym))
        {
          /* Type conversion.  */
          if (NoOfParam == 1)
            {
              ConstExpression = static_cast<unsigned int> (M2Quads_OperandT (NoOfParam+1));
              paramtok = OperandTtok (NoOfParam+1);
              M2Quads_PopN (NoOfParam+2);
              /* Build macro: CONVERT( ProcSym, ConstExpression ).  */
              M2Quads_PushTFtok (M2Base_Convert, static_cast<unsigned int> (SymbolTable_NulSym), functok);
              M2Quads_PushTtok (ProcSym, functok);
              M2Quads_PushTtok (ConstExpression, paramtok);
              M2Quads_PushT (static_cast<unsigned int> (2));  /* Two parameters.  */
              BuildConvertFunction (M2Base_Convert, true);  /* Two parameters.  */
            }
          else
            {
              M2MetaError_MetaErrorT0 (functok, (const char *) "{%E}a constant type conversion can only have one argument", 57);
            }
        }
      else
        {
          /* Error issue message and fake return stack.  */
          if (M2Options_Iso)
            {
              M2MetaError_MetaErrorT0 (functok, (const char *) "the only functions permissible in a constant expression are: {%kCAP}, {%kCHR}, {%kCMPLX}, {%kFLOAT}, {%kHIGH}, {%kIM}, {%kLENGTH}, {%kMAX}, {%kMIN}, {%kODD}, {%kORD}, {%kRE}, {%kSIZE}, {%kTSIZE}, {%kTRUNC}, {%kVAL} and gcc builtins", 231);
            }
          else
            {
              M2MetaError_MetaErrorT0 (functok, (const char *) "the only functions permissible in a constant expression are: {%kCAP}, {%kCHR}, {%kFLOAT}, {%kHIGH}, {%kMAX}, {%kMIN}, {%kODD}, {%kORD}, {%kSIZE}, {%kTSIZE}, {%kTRUNC}, {%kVAL} and gcc builtins", 192);
            }
          if (NoOfParam > 0)
            {
              paramtok = OperandTtok (NoOfParam+1);
              combinedtok = M2LexBuf_MakeVirtualTok (functok, functok, paramtok);
            }
          else
            {
              combinedtok = functok;
            }
          M2Quads_PopN (NoOfParam+2);
          M2Quads_PushT (SymbolTable_MakeConstLit (combinedtok, NameKey_MakeKey ((const char *) "0", 1), SymbolTable_NulSym));  /* Fake return value to continue compiling.  */
        }
    }
}


/*
   BuildBooleanVariable - tests to see whether top of stack is a boolean
                          conditional and if so it converts it into a boolean
                          variable.
*/

extern "C" void M2Quads_BuildBooleanVariable (void)
{
  if (IsBoolean (1))
    {
      ConvertBooleanToVariable (OperandTtok (1), 1);
    }
}


/*
   BuildModuleStart - starts current module scope.
*/

extern "C" void M2Quads_BuildModuleStart (unsigned int tok)
{
  GenQuadO (tok, M2Quads_ModuleScopeOp, tok, (unsigned int ) (NameKey_makekey (DynamicStrings_string (M2LexBuf_GetFileName ()))), SymbolTable_GetCurrentModule (), false);
}


/*
   BuildProcedureStart - Builds start of the procedure. Generates a
                         quadruple which indicated the start of
                         this procedure declarations scope.
                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
                        | Name       |          | Name      |
                        |------------|          |-----------|


                        Quadruples:

                        q   ProcedureScopeOp  Line#  Scope  ProcSym
*/

extern "C" void M2Quads_BuildProcedureStart (void)
{
  unsigned int ProcSym;

  M2Quads_PopT (&ProcSym);
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  SymbolTable_PutProcedureScopeQuad (ProcSym, NextQuad);
  GenQuad (M2Quads_ProcedureScopeOp, M2LexBuf_GetPreviousTokenLineNo (), SymbolTable_GetScope (ProcSym), ProcSym);
  M2Quads_PushT (ProcSym);
}


/*
   BuildProcedureBegin - determines the start of the BEGIN END block of
                         the procedure.
                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
                        | Name       |          | Name      |
                        |------------|          |-----------|


                        Quadruples:

                        q   NewLocalVarOp  TokenNo(BEGIN)  _  ProcSym
*/

extern "C" void M2Quads_BuildProcedureBegin (void)
{
  unsigned int ProcSym;

  M2Quads_PopT (&ProcSym);
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  SymbolTable_PutProcedureStartQuad (ProcSym, NextQuad);
  SymbolTable_PutProcedureBegin (ProcSym, M2LexBuf_GetTokenNo ());
  GenQuad (M2Quads_NewLocalVarOp, M2LexBuf_GetTokenNo (), SymbolTable_GetScope (ProcSym), ProcSym);
  CurrentProc = ProcSym;
  M2StackWord_PushWord (ReturnStack, static_cast<unsigned int> (0));
  M2Quads_PushT (ProcSym);
  CheckVariablesAt (ProcSym);
  CheckNeedPriorityBegin (M2LexBuf_GetTokenNo (), ProcSym, SymbolTable_GetCurrentModule ());
  M2StackWord_PushWord (TryStack, NextQuad);
  M2StackWord_PushWord (CatchStack, static_cast<unsigned int> (0));
  if (SymbolTable_HasExceptionBlock (ProcSym))
    {
      GenQuad (M2Quads_TryOp, SymbolTable_NulSym, SymbolTable_NulSym, 0);
    }
}


/*
   BuildProcedureEnd - Builds end of the procedure. Destroys space for
                       the local variables.
                       The Stack is expected to contain:


                       Entry                   Exit
                       =====                   ====

                Ptr ->                                       <- Ptr
                       +------------+          +-----------+
                       | ProcSym    |          | ProcSym   |
                       |------------|          |-----------|
                       | Name       |          | Name      |
                       |------------|          |-----------|


                       Quadruples:

                       q   KillLocalVarOp  TokenNo(END)  _  ProcSym
*/

extern "C" void M2Quads_BuildProcedureEnd (void)
{
  unsigned int tok;
  unsigned int ProcSym;

  M2Quads_PopTtok (&ProcSym, &tok);
  if (SymbolTable_HasExceptionBlock (ProcSym))
    {
      BuildRTExceptLeave (tok, true);
      GenQuad (M2Quads_CatchEndOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
    }
  if ((SymbolTable_GetSType (ProcSym)) != SymbolTable_NulSym)
    {
      BuildError (M2Range_InitNoReturnRangeCheck ());
    }
  BackPatch (M2StackWord_PopWord (ReturnStack), NextQuad);
  CheckNeedPriorityEnd (tok, ProcSym, SymbolTable_GetCurrentModule ());
  CurrentProc = SymbolTable_NulSym;
  SymbolTable_PutProcedureEnd (ProcSym, (M2LexBuf_GetTokenNo ())-1);  /* --fixme--  */
  GenQuad (M2Quads_KillLocalVarOp, (M2LexBuf_GetTokenNo ())-1, SymbolTable_NulSym, ProcSym);  /* --fixme--  */
  SymbolTable_PutProcedureEndQuad (ProcSym, NextQuad);
  GenQuad (M2Quads_ReturnOp, SymbolTable_NulSym, SymbolTable_NulSym, ProcSym);
  CheckFunctionReturn (ProcSym);
  CheckVariablesInBlock (ProcSym);
  /* Call PutProcedureEndQuad so that any runtime procedure will be
      seen as defined even if it not seen during pass 2 (which will also
      call PutProcedureEndQuad).  */
  SymbolTable_PutProcedureParametersDefined (ProcSym, SymbolTable_ProperProcedure);
  SymbolTable_PutProcedureDefined (ProcSym, SymbolTable_ProperProcedure);
  M2StackWord_RemoveTop (CatchStack);
  M2StackWord_RemoveTop (TryStack);
  M2Quads_PushT (ProcSym);
}


/*
   BuildReturn - Builds the Return part of the procedure.
                 tokreturn is the location of the RETURN keyword.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+
                 | e1         |          Empty
                 |------------|
*/

extern "C" void M2Quads_BuildReturn (unsigned int tokreturn)
{
  unsigned int tokcombined;
  unsigned int tokexpr;
  unsigned int e1;
  unsigned int t1;
  unsigned int t;
  unsigned int f;
  unsigned int Des;

  if (IsBoolean (1))
    {
      PopBooltok (&t, &f, &tokexpr);
      /* Des will be a boolean type  */
      Des = SymbolTable_MakeTemporary (tokexpr, SymbolTable_RightValue);
      SymbolTable_PutVar (Des, M2Base_Boolean);
      M2Quads_PushTFtok (Des, M2Base_Boolean, tokexpr);
      PushBooltok (t, f, tokexpr);
      BuildAssignmentWithoutBounds (tokreturn, false, true);
      M2Quads_PushTFtok (Des, M2Base_Boolean, tokexpr);
    }
  M2Quads_PopTFtok (&e1, &t1, &tokexpr);
  tokcombined = M2LexBuf_MakeVirtualTok (tokreturn, tokreturn, tokexpr);
  if (e1 != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      /* Check we are in a procedure scope and that the procedure has a return type.  */
      if (CurrentProc == SymbolTable_NulSym)
        {
          M2MetaError_MetaErrorT0 (tokcombined, (const char *) "{%1E} attempting to return a value when not in a procedure scope", 64);
        }
      else if ((SymbolTable_GetSType (CurrentProc)) == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (tokcombined, (const char *) "attempting to return a value from procedure {%1Ea} which does not have a return type", 84, CurrentProc);
        }
      else
        {
          /* avoid dangling else.  */
          BuildReturnLower (tokcombined, tokexpr, e1, t1);
        }
    }
  GenQuadO (tokcombined, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, M2StackWord_PopWord (ReturnStack), false);
  M2StackWord_PushWord (ReturnStack, NextQuad-1);
}


/*
   BuildModulePriority - assigns the current module with a priority
                         from the top of stack.

                         Entry                   Exit
                         =====                   ====


                  Ptr ->                         Empty
                         +------------+
                         | Priority   |
                         |------------|
*/

extern "C" void M2Quads_BuildModulePriority (void)
{
  unsigned int Priority;

  M2Quads_PopT (&Priority);
  SymbolTable_PutPriority (SymbolTable_GetCurrentModule (), Priority);
}


/*
   StartBuildWith - performs the with statement.
                    The Stack:

                    Entry                    Exit

                    +------------+
                    | Sym | Type |           Empty
                    |------------|
*/

extern "C" void M2Quads_StartBuildWith (unsigned int withTok)
{
  unsigned int tok;
  unsigned int Sym;
  unsigned int Type;
  unsigned int Ref;

  DebugLocation (static_cast<unsigned int> (M2Reserved_withtok), (const char *) "with", 4);
  BuildStmtNoteTok (withTok);
  M2Quads_DisplayStack ();
  M2Quads_PopTFtok (&Sym, &Type, &tok);
  DebugLocation (tok, (const char *) "expression", 10);
  Type = SymbolTable_SkipType (Type);
  if (Type == SymbolTable_NulSym)
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "{%1Aa} {%1d} has a no type, the {%kWITH} statement requires a variable or parameter of a {%kRECORD} type", 104, Sym);
    }
  else
    {
      Ref = SymbolTable_MakeTemporary (tok, SymbolTable_LeftValue);
      SymbolTable_PutVar (Ref, Type);
      if ((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue)
        {
          /* Copy LeftValue.  */
          GenQuadO (tok, M2Quads_BecomesOp, Ref, SymbolTable_NulSym, Sym, true);
        }
      else
        {
          /* Calculate the address of Sym.  */
          GenQuadO (tok, M2Quads_AddrOp, Ref, SymbolTable_NulSym, Sym, true);
        }
      PushWith (Sym, Type, Ref, tok);
      DebugLocation (tok, (const char *) "with ref", 8);
      if (! (SymbolTable_IsRecord (Type)))
        {
          M2MetaError_MetaErrorT1 (tok, (const char *) "the {%kWITH} statement requires that {%1Ea} {%1d} be of a {%kRECORD} {%1tsa:type rather than {%1tsa}}", 101, Sym);
        }
      SymbolTable_StartScope (Type);
    }
  M2Quads_DisplayStack ();
}


/*
   EndBuildWith - terminates the innermost with scope.
*/

extern "C" void M2Quads_EndBuildWith (void)
{
  M2Quads_DisplayStack ();
  SymbolTable_EndScope ();
  PopWith ();
  M2Quads_DisplayStack ();
}


/*
   CheckWithReference - performs the with statement.
                        The Stack:

                        Entry                    Exit

                        +------------+           +------------+
                        | Sym | Type |           | Sym | Type |
                        |------------|           |------------|
*/

extern "C" void M2Quads_CheckWithReference (void)
{
  M2Quads_WithFrame f;
  unsigned int tokpos;
  unsigned int i;
  unsigned int n;
  unsigned int rw;
  unsigned int Sym;
  unsigned int Type;

  n = M2StackAddress_NoOfItemsInStackAddress (WithStack);
  if ((n > 0) && ! SuppressWith)
    {
      PopTFrwtok (&Sym, &Type, &rw, &tokpos);
      M2Debug_Assert (tokpos != M2LexBuf_UnknownTokenNo);
      /* inner WITH always has precidence  */
      i = 1;  /* top of stack  */
      /* WriteString('Checking for a with') ;  */
      while (i <= n)
        {
          f = static_cast<M2Quads_WithFrame> (M2StackAddress_PeepAddress (WithStack, i));
          if ((SymbolTable_IsRecordField (Sym)) && ((SymbolTable_GetRecord (SymbolTable_GetParent (Sym))) == f->RecordType))
            {
              if (SymbolTable_IsUnused (Sym))
                {
                  M2MetaError_MetaError1 ((const char *) "record field {%1Dad} was declared as unused by a pragma", 55, Sym);
                }
              /* Fake a RecordSym.op  */
              PushTFrwtok (f->RecordRef, f->RecordType, f->rw, f->RecordTokPos);
              M2Quads_PushTFtok (Sym, Type, tokpos);
              BuildAccessWithField ();
              PopTFrw (&Sym, &Type, &f->rw);
              i = n+1;  /* Finish loop.  */
            }
          else
            {
              i += 1;
            }
        }
      PushTFrwtok (Sym, Type, rw, tokpos);
    }
}


/*
   BuildDesignatorRecord - Builds the record referencing.
                           The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                   Ptr ->
                           +--------------+
                           | n            |
                           |--------------|
                           | fld1 | type1 |
                           |--------------|
                           .              .
                           .              .
                           .              .
                           |--------------|
                           | fldn | typen |                        <- Ptr
                           |--------------|        +-------------+
                           | Sym  | Type  |        | S    | type1|
                           |--------------|        |-------------|
*/

extern "C" void M2Quads_BuildDesignatorRecord (unsigned int dottok)
{
  unsigned int RecordTok;
  unsigned int FieldTok;
  unsigned int combinedtok;
  unsigned int n;
  unsigned int rw;
  unsigned int Field;
  unsigned int FieldType;
  unsigned int RecordSym;
  unsigned int Res;

  M2Quads_PopT (&n);
  RecordSym = static_cast<unsigned int> (M2Quads_OperandT (n+1));
  /* RecordType could be found by:  SkipType (OperandF (n+1)).  */
  RecordTok = static_cast<unsigned int> (M2Quads_OperandTok (n+1));
  rw = static_cast<unsigned int> (OperandMergeRW (n+1));
  M2Debug_Assert (SymbolTable_IsLegal (rw));
  Field = static_cast<unsigned int> (M2Quads_OperandT (n));
  FieldType = SymbolTable_SkipType (M2Quads_OperandF (n));
  FieldTok = static_cast<unsigned int> (M2Quads_OperandTok (n));
  combinedtok = M2LexBuf_MakeVirtualTok (dottok, RecordTok, FieldTok);
  if (n > 1)
    {
      M2Error_InternalError ((const char *) "not expecting to see n>1", 24);
    }
  if (SymbolTable_IsUnused (Field))
    {
      M2MetaError_MetaErrors1 ((const char *) "record field {%1Dad} was declared as unused by a pragma", 55, (const char *) "record field {%1ad} is being used after being declared as unused by a pragma", 76, Field);
    }
  Res = SymbolTable_MakeComponentRef (SymbolTable_MakeComponentRecord (combinedtok, SymbolTable_RightValue, RecordSym), Field);
  SymbolTable_PutVarConst (Res, IsReadOnly (RecordSym));
  GenQuadO (combinedtok, M2Quads_RecordFieldOp, Res, RecordSym, Field, false);
  M2Quads_PopN (n+1);
  PushTFrwtok (Res, FieldType, rw, combinedtok);
}


/*
   BuildDesignatorArray - Builds the array referencing.
                          The purpose of this procedure is to work out
                          whether the DesignatorArray is a constant string or
                          dynamic array/static array and to call the appropriate
                          BuildRoutine.

                          The Stack is expected to contain:

                          Entry                   Exit
                          =====                   ====

                  Ptr ->
                          +--------------+
                          | e            |                        <- Ptr
                          |--------------|        +------------+
                          | Sym  | Type  |        | S    | T   |
                          |--------------|        |------------|
*/

extern "C" void M2Quads_BuildDesignatorArray (void)
{
  if ((SymbolTable_IsConst (M2Quads_OperandT (2))) && (SymbolTable_IsConstString (M2Quads_OperandT (2))))
    {
      M2MetaError_MetaErrorT1 (OperandTtok (2), (const char *) "{%1Ead} is not an array, but a constant string.  Hint use a string constant created with an array constructor", 109, M2Quads_OperandT (2));
      BuildDesignatorError ((const char *) "bad array access", 16);
    }
  else
    {
      BuildDesignatorArrayStaticDynamic ();
    }
}


/*
   BuildDesignatorPointer - Builds a pointer reference.
                            The Stack is expected to contain:


                            Entry                   Exit
                            =====                   ====

                    Ptr ->                                           <- Ptr
                            +--------------+        +--------------+
                            | Sym1  | Type1|        | Sym2  | Type2|
                            |--------------|        |--------------|
*/

extern "C" void M2Quads_BuildDesignatorPointer (unsigned int ptrtok)
{
  unsigned int combinedtok;
  unsigned int destok;
  unsigned int rw;
  unsigned int Sym1;
  unsigned int Type1;
  unsigned int Sym2;
  unsigned int Type2;

  PopTFrwtok (&Sym1, &Type1, &rw, &destok);
  DebugLocation (destok, (const char *) "des ptr expression", 18);
  Type1 = SymbolTable_SkipType (Type1);
  if (Type1 == SymbolTable_NulSym)
    {
      M2MetaError_MetaErrorT1 (ptrtok, (const char *) "{%1ad} has no type and therefore cannot be dereferenced by ^", 60, Sym1);
    }
  else if (SymbolTable_IsUnknown (Sym1))
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "{%1EMad} is undefined and therefore {%1ad}^ cannot be resolved", 62, Sym1);
    }
  else
    {
      /* avoid dangling else.  */
      combinedtok = M2LexBuf_MakeVirtual2Tok (destok, ptrtok);
      if (SymbolTable_IsPointer (Type1))
        {
          Type2 = SymbolTable_GetSType (Type1);
          Sym2 = SymbolTable_MakeTemporary (ptrtok, SymbolTable_LeftValue);
          /* 
          Ok must reference by address
          - but we contain the type of the referenced entity
  */
          MarkAsRead (rw);
          SymbolTable_PutVarPointerCheck (Sym1, true);
          CheckPointerThroughNil (ptrtok, Sym1);
          if ((SymbolTable_GetMode (Sym1)) == SymbolTable_LeftValue)
            {
              rw = SymbolTable_NulSym;
              SymbolTable_PutLeftValueFrontBackType (Sym2, Type2, Type1);
              GenQuadO (ptrtok, M2Quads_IndrXOp, Sym2, Type1, Sym1, false);  /* Sym2 := *Sym1.  */
            }
          else
            {
              SymbolTable_PutLeftValueFrontBackType (Sym2, Type2, SymbolTable_NulSym);
              GenQuadO (ptrtok, M2Quads_BecomesOp, Sym2, SymbolTable_NulSym, Sym1, false);  /* Sym2 :=  Sym1.  */
            }
          /* We should check this for Sym2 later on (pointer via NIL).  */
          SymbolTable_PutVarPointerCheck (Sym2, true);
          PushTFrwtok (Sym2, Type2, rw, combinedtok);
          DebugLocation (combinedtok, (const char *) "pointer expression", 18);
        }
      else if ((SymbolTable_IsHiddenType (Type1)) && ((SymbolTable_GetModuleScope (Type1)) != (SymbolTable_GetCurrentModuleScope ())))
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (ptrtok, (const char *) "{%1Ead} is declared with an opaque type from a different module and cannot be dereferenced", 90, Sym1);
          MarkAsRead (rw);
          BuildDesignatorPointerError (Type1, rw, combinedtok, (const char *) "bad opaque pointer dereference", 30);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError2 ((const char *) "{%1Ead} is not a pointer type but a {%2d}", 41, Sym1, Type1);
          MarkAsRead (rw);
          BuildDesignatorPointerError (Type1, rw, combinedtok, (const char *) "bad pointer dereference", 23);
        }
    }
}


/*
   BuildNulExpression - Builds a nul expression on the stack.
                        The Stack:

                        Entry             Exit

                                                         <- Ptr
                        Empty             +------------+
                                          | NulSym     |
                                          |------------|
   tokpos is the position of the RETURN token.
*/

extern "C" void M2Quads_BuildNulExpression (unsigned int tokpos)
{
  M2Quads_PushTtok (static_cast<unsigned int> (SymbolTable_NulSym), tokpos);
}


/*
   BuildSetStart - Pushes a Bitset type on the stack.

                      The Stack:

                      Entry             Exit

               Ptr ->                                        <- Ptr

                      Empty             +--------------+
                                        | Bitset       |
                                        |--------------|
*/

extern "C" void M2Quads_BuildSetStart (unsigned int tokpos)
{
  M2Quads_PushTtok (M2Bitset_Bitset, tokpos);
}


/*
   BuildSetEnd - pops the set value and type from the stack
                 and pushes the value,type pair.

                    Entry                   Exit

             Ptr ->
                    +--------------+
                    | Set Value    |                         <- Ptr
                    |--------------|        +--------------+
                    | Set Type     |        | Value | Type |
                    |--------------|        |--------------|
*/

extern "C" void M2Quads_BuildSetEnd (void)
{
  unsigned int valuepos;
  unsigned int typepos;
  unsigned int combined;
  unsigned int value;
  unsigned int type;

  M2Quads_PopTtok (&value, &valuepos);
  M2Quads_PopTtok (&type, &typepos);
  combined = M2LexBuf_MakeVirtual2Tok (typepos, valuepos);
  M2Quads_PushTFtok (value, type, combined);
  M2Debug_Assert (SymbolTable_IsSet (type));
}


/*
   BuildEmptySet - Builds an empty set on the stack.
                   The Stack:

                   Entry             Exit

                                                     <- Ptr
                                     +-------------+
            Ptr ->                   | Value       |
                   +-----------+     |-------------|
      	       	   | SetType   |     | SetType     |
                   |-----------|     |-------------|

   tokpos points to the opening '{'.
*/

extern "C" void M2Quads_BuildEmptySet (unsigned int tokpos)
{
  NameKey_Name n;
  unsigned int typepos;
  unsigned int Type;
  unsigned int NulSet;

  M2Quads_PopTtok (&Type, &typepos);  /* type of set we are building  */
  if ((Type == SymbolTable_NulSym) && M2Options_Pim)
    {
      /* allowed generic {} in PIM Modula-2  */
      typepos = tokpos;
    }
  else if (SymbolTable_IsUnknown (Type))
    {
      /* avoid dangling else.  */
      n = SymbolTable_GetSymName (Type);
      M2Error_WriteFormat1 ((const char *) "set type %a is undefined", 24, (const unsigned char *) &n, (sizeof (n)-1));
      Type = M2Bitset_Bitset;
    }
  else if (! (SymbolTable_IsSet (SymbolTable_SkipType (Type))))
    {
      /* avoid dangling else.  */
      n = SymbolTable_GetSymName (Type);
      M2Error_WriteFormat1 ((const char *) "expecting a set type %a", 23, (const unsigned char *) &n, (sizeof (n)-1));
      Type = M2Bitset_Bitset;
    }
  else
    {
      /* avoid dangling else.  */
      Type = SymbolTable_SkipType (Type);
      M2Debug_Assert (Type != SymbolTable_NulSym);
    }
  NulSet = SymbolTable_MakeTemporary (typepos, SymbolTable_ImmediateValue);
  SymbolTable_PutVar (NulSet, Type);
  SymbolTable_PutConstSet (NulSet);
  if (M2Options_CompilerDebugging)
    {
      n = SymbolTable_GetSymName (Type);
      M2Printf_printf1 ((const char *) "set type = %a\\n", 15, (const unsigned char *) &n, (sizeof (n)-1));
    }
  M2ALU_PushNulSet (Type);  /* onto the ALU stack  */
  SymbolTable_PopValue (NulSet);  /* ALU -> symbol table  */
  /* and now construct the M2Quads stack as defined by the comments above  */
  M2Quads_PushTtok (Type, typepos);
  M2Quads_PushTtok (NulSet, typepos);
  if (M2Options_CompilerDebugging)
    {
      n = SymbolTable_GetSymName (Type);
      M2Printf_printf2 ((const char *) "Type = %a  (%d)  built empty set\\n", 34, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &Type, (sizeof (Type)-1));
      M2Quads_DisplayStack ();  /* Debugging info  */
    }
}


/*
   BuildInclRange - includes a set range with a set.


                          Entry                   Exit
                          =====                   ====


                   Ptr ->
                          +------------+
                          | El2        |
                          |------------|
                          | El1        |                                 <- Ptr
                          |------------|           +-------------------+
                          | Set Value  |           | Value + {El1..El2}|
                          |------------|           |-------------------|

                   No quadruples produced as the range info is contained within
                   the set value.
*/

extern "C" void M2Quads_BuildInclRange (void)
{
  NameKey_Name n;
  unsigned int el1;
  unsigned int el2;
  unsigned int value;

  M2Quads_PopT (&el2);
  M2Quads_PopT (&el1);
  M2Quads_PopT (&value);
  if (! (SymbolTable_IsConstSet (value)))
    {
      n = SymbolTable_GetSymName (el1);
      M2Error_WriteFormat1 ((const char *) "can only add bit ranges to a constant set, %a is not a constant set", 67, (const unsigned char *) &n, (sizeof (n)-1));
    }
  if ((SymbolTable_IsConst (el1)) && (SymbolTable_IsConst (el2)))
    {
      SymbolTable_PushValue (value);  /* onto ALU stack  */
      M2ALU_AddBitRange (M2LexBuf_GetTokenNo (), el1, el2);  /* onto ALU stack  */
      SymbolTable_PopValue (value);  /* ALU -> symboltable  */
    }
  else
    {
      if (! (SymbolTable_IsConst (el1)))
        {
          n = SymbolTable_GetSymName (el1);
          M2Error_WriteFormat1 ((const char *) "must use constants as ranges when defining a set constant, problem with the low value %a", 88, (const unsigned char *) &n, (sizeof (n)-1));
        }
      if (! (SymbolTable_IsConst (el2)))
        {
          n = SymbolTable_GetSymName (el2);
          M2Error_WriteFormat1 ((const char *) "must use constants as ranges when defining a set constant, problem with the high value %a", 89, (const unsigned char *) &n, (sizeof (n)-1));
        }
    }
  M2Quads_PushT (value);
}


/*
   BuildInclBit - includes a bit into the set.

                         Entry                   Exit
                         =====                   ====


                  Ptr ->
                         +------------+
                         | Element    |                         <- Ptr
                         |------------|          +------------+
                         | Value      |          | Value      |
                         |------------|          |------------|

*/

extern "C" void M2Quads_BuildInclBit (void)
{
  unsigned int tok;
  unsigned int el;
  unsigned int value;
  unsigned int t;

  M2Quads_PopT (&el);
  M2Quads_PopT (&value);
  tok = M2LexBuf_GetTokenNo ();
  if (SymbolTable_IsConst (el))
    {
      SymbolTable_PushValue (value);  /* onto ALU stack  */
      M2ALU_AddBit (tok, el);  /* onto ALU stack  */
      SymbolTable_PopValue (value);  /* ALU -> symboltable  */
    }
  else
    {
      if ((SymbolTable_GetMode (el)) == SymbolTable_LeftValue)
        {
          t = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
          SymbolTable_PutVar (t, SymbolTable_GetSType (el));
          CheckPointerThroughNil (tok, el);
          doIndrX (tok, t, el);
          el = t;
        }
      if (SymbolTable_IsConst (value))
        {
          /* move constant into a variable to achieve the include  */
          t = SymbolTable_MakeTemporary (tok, SymbolTable_RightValue);
          SymbolTable_PutVar (t, SymbolTable_GetSType (value));
          GenQuad (M2Quads_BecomesOp, t, SymbolTable_NulSym, value);
          value = t;
        }
      GenQuad (M2Quads_InclOp, value, SymbolTable_NulSym, el);
    }
  M2Quads_PushT (value);
}


/*
   SilentBuildConstructor - places NulSym into the constructor fifo queue.
*/

extern "C" void M2Quads_SilentBuildConstructor (void)
{
  FifoQueue_PutConstructorIntoFifoQueue (SymbolTable_NulSym);
}


/*
   SilentBuildConstructorStart - removes an entry from the constructor fifo queue.
*/

extern "C" void M2Quads_SilentBuildConstructorStart (void)
{
  unsigned int constValue;

  FifoQueue_GetConstructorFromFifoQueue (&constValue);
}


/*
   BuildConstructor - builds a constructor.
                      Stack

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | Type       |                <- Ptr
                      |------------+
*/

extern "C" void M2Quads_BuildConstructor (unsigned int tokcbrpos)
{
  unsigned int tok;
  unsigned int constValue;
  unsigned int type;

  M2Quads_PopTtok (&type, &tok);
  constValue = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
  SymbolTable_PutVar (constValue, type);
  SymbolTable_PutConstructor (constValue);
  SymbolTable_PushValue (constValue);
  if (type == SymbolTable_NulSym)
    {
      M2MetaError_MetaErrorT0 (tokcbrpos, (const char *) "{%E}constructor requires a type before the opening %{", 53);
    }
  else
    {
      M2ALU_ChangeToConstructor (tok, type);
      SymbolTable_PutConstructorFrom (constValue, type);
      SymbolTable_PopValue (constValue);
      FifoQueue_PutConstructorIntoFifoQueue (constValue);
    }
  PushConstructor (type);
}


/*
   BuildConstructorStart - builds a constructor.
                           Stack

                           Entry                 Exit

                    Ptr ->                                          <- Ptr
                           +------------+        +----------------+
                           | Type       |        | ConstructorSym |
                           |------------+        |----------------|
*/

extern "C" void M2Quads_BuildConstructorStart (unsigned int cbratokpos)
{
  unsigned int typepos;
  unsigned int constValue;
  unsigned int type;

  M2Quads_PopTtok (&type, &typepos);  /* we ignore the type as we already have the constructor symbol from pass C  */
  FifoQueue_GetConstructorFromFifoQueue (&constValue);  /* we ignore the type as we already have the constructor symbol from pass C  */
  if (type != (SymbolTable_GetSType (constValue)))
    {
      M2MetaError_MetaErrorT3 (cbratokpos, (const char *) "{%E}the constructor type is {%1ad} and this is different from the constant {%2ad} which has a type {%2tad}", 106, type, constValue, constValue);
    }
  M2Quads_PushTtok (constValue, cbratokpos);
  PushConstructor (type);
}


/*
   BuildConstructorEnd - removes the current constructor frame from the
                         constructor stack (it does not effect the quad
                         stack)

                         Entry                 Exit

                  Ptr ->                                      <- Ptr
                         +------------+        +------------+
                         | const      |        | const      |
                         |------------|        |------------|

   startpos is the start of the constructor, either the typename or '{'
   cbratokpos is the '}'.
*/

extern "C" void M2Quads_BuildConstructorEnd (unsigned int startpos, unsigned int cbratokpos)
{
  unsigned int value;
  unsigned int valtok;

  if (DebugTokPos)
    {
      M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) "startpos", 8), startpos);
      M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) "cbratokpos", 10), cbratokpos);
    }
  M2Quads_PopTtok (&value, &valtok);
  if (DebugTokPos)
    {
      M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) "value valtok", 12), valtok);
    }
  valtok = M2LexBuf_MakeVirtual2Tok (startpos, cbratokpos);
  SymbolTable_PutDeclared (valtok, value);
  M2Quads_PushTtok (value, valtok);  /* Use valtok as we now know it was a constructor.  */
  M2Quads_PopConstructor ();  /* Use valtok as we now know it was a constructor.  */
  if (DebugTokPos)
    {
      M2Error_WarnStringAt (DynamicStrings_InitString ((const char *) "aggregate constant", 18), valtok);
    }
}


/*
   NextConstructorField - increments the top of constructor stacks index by one.
*/

extern "C" void M2Quads_NextConstructorField (void)
{
  M2Quads_ConstructorFrame c;

  c = static_cast<M2Quads_ConstructorFrame> (M2StackAddress_PeepAddress (ConstructorStack, 1));
  c->index += 1;
}


/*
   BuildTypeForConstructor - pushes the type implied by the current constructor.
                             If no constructor is currently being built then
                             it Pushes a Bitset type.
*/

extern "C" void M2Quads_BuildTypeForConstructor (unsigned int tokpos)
{
  M2Quads_ConstructorFrame c;

  if ((M2StackAddress_NoOfItemsInStackAddress (ConstructorStack)) == 0)
    {
      M2Quads_PushTtok (M2Bitset_Bitset, tokpos);
    }
  else
    {
      c = static_cast<M2Quads_ConstructorFrame> (M2StackAddress_PeepAddress (ConstructorStack, 1));
      if ((SymbolTable_IsArray (c->type)) || (SymbolTable_IsSet (c->type)))
        {
          M2Quads_PushTtok (SymbolTable_GetSType (c->type), tokpos);
        }
      else if (SymbolTable_IsRecord (c->type))
        {
          /* avoid dangling else.  */
          M2Quads_PushTtok (SymbolTable_GetSType (SymbolTable_GetNth (c->type, c->index)), tokpos);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError1 ((const char *) "{%1ad} is not a set, record or array type which is expected when constructing an aggregate entity", 97, c->type);
        }
    }
}


/*
   BuildComponentValue -  builds a component value.

                          Entry                 Exit

                   Ptr ->                                      <- Ptr


                          +------------+        +------------+
                          | const      |        | const      |
                          |------------|        |------------|
*/

extern "C" void M2Quads_BuildComponentValue (void)
{
  unsigned int const_;
  unsigned int e1;
  unsigned int e2;
  NameKey_Name nuldotdot;
  NameKey_Name nulby;

  M2Quads_PopT (&nulby);
  if (nulby == M2Reserved_NulTok)
    {
      M2Quads_PopT (&nuldotdot);
      if (nuldotdot == M2Reserved_NulTok)
        {
          M2Quads_PopT (&e1);
          M2Quads_PopT (&const_);
          M2Quads_PushT (AddFieldTo (const_, e1));
        }
      else
        {
          M2Quads_PopT (&e2);
          M2Quads_PopT (&e1);
          M2Quads_PopT (&const_);
          SymbolTable_PushValue (const_);
          M2ALU_AddBitRange (M2LexBuf_GetTokenNo (), e1, e2);
          SymbolTable_PopValue (const_);
          M2Quads_PushT (const_);
        }
    }
  else
    {
      M2Quads_PopT (&e1);
      M2Quads_PopT (&nuldotdot);
      if (nuldotdot == M2Reserved_NulTok)
        {
          M2Quads_PopT (&e2);
          M2Quads_PopT (&const_);
          SymbolTable_PushValue (const_);
          M2ALU_AddElements (M2LexBuf_GetTokenNo (), e2, e1);
          SymbolTable_PopValue (const_);
          M2Quads_PushT (const_);
        }
      else
        {
          M2Quads_PopT (&e2);
          M2Quads_PopT (&e1);
          M2Quads_PopT (&const_);
          M2Error_WriteFormat0 ((const char *) "the constant must be either an array constructor or a set constructor", 69);
          M2Quads_PushT (const_);
        }
    }
}


/*
   PopConstructor - removes the top constructor from the top of stack.
*/

extern "C" void M2Quads_PopConstructor (void)
{
  M2Quads_ConstructorFrame c;

  c = static_cast<M2Quads_ConstructorFrame> (M2StackAddress_PopAddress (ConstructorStack));
  Storage_DEALLOCATE ((void **) &c, sizeof (M2Quads__T1));
}


/*
   BuildNot   - Builds a NOT operation from the quad stack.
                The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

           Ptr ->                                        <- Ptr
                  +------------+          +------------+
                  | t    | f   |          | f    | t   |
                  |------------|          |------------|
*/

extern "C" void M2Quads_BuildNot (unsigned int notTokPos)
{
  unsigned int combinedTok;
  unsigned int exprTokPos;
  unsigned int t;
  unsigned int f;

  CheckBooleanId ();
  PopBooltok (&t, &f, &exprTokPos);
  combinedTok = M2LexBuf_MakeVirtualTok (notTokPos, notTokPos, exprTokPos);
  PushBooltok (f, t, combinedTok);
}


/*
   RecordOp - Records the operator passed on the stack.
              This is called when a boolean operator is found in an
              expression.  It is called just after the lhs has been built
              and pushed to the quad stack and prior to the rhs build.
              It checks to see if AND OR or equality tests are required.
              It will short circuit AND and OR expressions.  It also
              converts a lhs to a boolean variable if an xor comparison
              is about to be performed.

              Checks for AND operator or OR operator
              if either of these operators are found then BackPatching
              takes place.
              The Expected Stack:

              Entry                        Exit

       Ptr ->                                               <- Ptr
              +-------------+               +-------------+
              | OperatorTok |               | OperatorTok |
              |-------------|               |-------------|
              | t    | f    |               | t    | f    |
              |-------------|               |-------------|


              If OperatorTok=AndTok
              Then
                 BackPatch(f, NextQuad)
              Elsif OperatorTok=OrTok
              Then
                 BackPatch(t, NextQuad)
              End
*/

extern "C" void M2Quads_RecordOp (void)
{
  NameKey_Name Op;
  unsigned int tokno;
  unsigned int t;
  unsigned int f;

  M2Quads_PopTtok (&Op, &tokno);
  if ((Op == M2Reserved_AndTok) || (Op == M2Reserved_AmbersandTok))
    {
      CheckBooleanId ();
      PopBool (&t, &f);
      BackPatch (t, NextQuad);
      PushBool (0, f);
    }
  else if (Op == M2Reserved_OrTok)
    {
      /* avoid dangling else.  */
      CheckBooleanId ();
      PopBool (&t, &f);
      BackPatch (f, NextQuad);
      PushBool (t, 0);
    }
  else if ((IsBoolean (1)) && ((((Op == M2Reserved_EqualTok) || (Op == M2Reserved_LessGreaterTok)) || (Op == M2Reserved_HashTok)) || (Op == M2Reserved_InTok)))
    {
      /* avoid dangling else.  */
      ConvertBooleanToVariable (tokno, 1);
    }
  M2Quads_PushTtok (Op, tokno);
}


/*
   BuildRelOp   - Builds a relative operation from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

           Ptr ->
                  +------------+
                  | e1         |
                  |------------|                          <- Ptr
                  | Operator   |
                  |------------|          +------------+
                  | e2         |          | t    | f   |
                  |------------|          |------------|


                    Quadruples Produced

                    q     IFOperator  e2  e1  TrueExit    ; e2  e1 since
                    q+1   GotoOp              FalseExit   ; relation > etc
                                                          ; requires order.
*/

extern "C" void M2Quads_BuildRelOp (unsigned int optokpos)
{
  unsigned int combinedTok;
  unsigned int rightpos;
  unsigned int leftpos;
  NameKey_Name Op;
  unsigned int t;
  unsigned int rightType;
  unsigned int leftType;
  unsigned int right;
  unsigned int left;
  DynamicStrings_String s;

  if (M2Options_CompilerDebugging)
    {
      M2Quads_DisplayStack ();  /* Debugging info  */
    }
  if (((M2Quads_IsInConstExpression ()) && (IsBoolean (1))) && (IsBoolean (3)))
    {
      /* 
         we allow # and = to be used with Boolean expressions.
         we do not allow >  <  >=  <=  though.  We only examine
         this case if we are in a const expression as there will be
         no dereferencing of operands.
  */
      BuildRelOpFromBoolean (optokpos);
    }
  else
    {
      if (IsBoolean (1))
        {
          ConvertBooleanToVariable (OperandTtok (1), 1);
        }
      if (IsBoolean (3))
        {
          ConvertBooleanToVariable (OperandTtok (3), 3);
        }
      M2Quads_PopTFtok (&right, &rightType, &rightpos);
      M2Quads_PopT (&Op);
      M2Quads_PopTFtok (&left, &leftType, &leftpos);
      CheckVariableOrConstantOrProcedure (rightpos, right);
      CheckVariableOrConstantOrProcedure (leftpos, left);
      combinedTok = M2LexBuf_MakeVirtualTok (optokpos, leftpos, rightpos);
      if ((left != SymbolTable_NulSym) && (right != SymbolTable_NulSym))
        {
          /* BuildRange will check the expression later on once gcc knows about all data types.  */
          BuildRange (M2Range_InitTypesExpressionCheck (combinedTok, left, right, true, Op == M2Reserved_InTok));
        }
      /* Must dereference LeftValue operands.  */
      if ((SymbolTable_GetMode (right)) == SymbolTable_LeftValue)
        {
          t = SymbolTable_MakeTemporary (rightpos, SymbolTable_RightValue);
          SymbolTable_PutVar (t, SymbolTable_GetSType (right));
          CheckPointerThroughNil (rightpos, right);
          doIndrX (rightpos, t, right);
          right = t;
        }
      if ((SymbolTable_GetMode (left)) == SymbolTable_LeftValue)
        {
          t = SymbolTable_MakeTemporary (leftpos, SymbolTable_RightValue);
          SymbolTable_PutVar (t, SymbolTable_GetSType (left));
          CheckPointerThroughNil (leftpos, left);
          doIndrX (leftpos, t, left);
          left = t;
        }
      if (DebugTokPos)
        {
          s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (M2LexBuf_GetTokenName (Op)));
          M2Error_WarnStringAt (s, optokpos);
          s = DynamicStrings_InitString ((const char *) "left", 4);
          M2Error_WarnStringAt (s, leftpos);
          s = DynamicStrings_InitString ((const char *) "right", 5);
          M2Error_WarnStringAt (s, rightpos);
          s = DynamicStrings_InitString ((const char *) "caret", 5);
          M2Error_WarnStringAt (s, optokpos);
          s = DynamicStrings_InitString ((const char *) "combined", 8);
          M2Error_WarnStringAt (s, combinedTok);
        }
      GenQuadOtok (combinedTok, MakeOp (Op), left, right, 0, false, leftpos, rightpos, M2LexBuf_UnknownTokenNo);  /* True  Exit  */
      GenQuadO (combinedTok, M2Quads_GotoOp, SymbolTable_NulSym, SymbolTable_NulSym, 0, false);  /* False Exit  */
      PushBooltok (NextQuad-2, NextQuad-1, combinedTok);  /* False Exit  */
    }
}


/*
   BuildBinaryOp   - Builds a binary operation from the quad stack.
                     Be aware that this procedure will check for
                     the overloading of the bitset operators + - \ *.
                     So do NOT call this procedure if you are building
                     a reference to an array which has a bitset type or
                     the address arithmetic will be wrongly coersed into
                     logical ORs.

                     The Stack is expected to contain:


                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Sym1       |
                     |------------|
                     | Operator   |                          <- Ptr
                     |------------|          +------------+
                     | Sym2       |          | Temporary  |
                     |------------|          |------------|


                     Quadruples Produced

                     q     Operator  Temporary  Sym1  Sym2


                OR


                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | T1   | F1  |
                     |------------|
                     | OrTok      |                          <- Ptr
                     |------------|          +------------+
                     | T2   | F2  |          | T1+T2| F1  |
                     |------------|          |------------|


                     Quadruples Produced

*/

extern "C" void M2Quads_BuildBinaryOp (void)
{
  doBuildBinaryOp (true, true);
}


/*
   BuildUnaryOp   - Builds a unary operation from the quad stack.
                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

             Ptr ->
                    +------------+
                    | Sym        |
                    |------------|          +------------+
                    | Operator   |          | Temporary  | <- Ptr
                    |------------|          |------------|


                    Quadruples Produced

                    q     Operator  Temporary  _ Sym

*/

extern "C" void M2Quads_BuildUnaryOp (void)
{
  unsigned int sympos;
  unsigned int tokpos;
  NameKey_Name Tok;
  unsigned int type;
  unsigned int Sym;
  unsigned int SymT;
  unsigned int r;
  unsigned int t;

  PopTrwtok (&Sym, &r, &sympos);
  M2Quads_PopTtok (&Tok, &tokpos);
  if (Tok == M2Reserved_MinusTok)
    {
      MarkAsRead (r);
      type = M2Base_NegateType (SymbolTable_GetSType (Sym));  /* , sympos  */
      tokpos = M2LexBuf_MakeVirtualTok (tokpos, tokpos, sympos);
      t = SymbolTable_MakeTemporary (tokpos, AreConstant (SymbolTable_IsConst (Sym)));
      SymbolTable_PutVar (t, type);
      /* 
         variables must have a type and REAL/LONGREAL constants must
         be typed
  */
      if (! (SymbolTable_IsConst (Sym)))
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if ((type != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_SkipType (type))))
            {}  /* empty.  */
          /* do not dereference set variables  */
          else if ((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue)
            {
              /* avoid dangling else.  */
              /* dereference symbols which are not sets and which are variables  */
              SymT = SymbolTable_MakeTemporary (sympos, SymbolTable_RightValue);
              SymbolTable_PutVar (SymT, SymbolTable_GetSType (Sym));
              CheckPointerThroughNil (sympos, Sym);
              doIndrX (sympos, SymT, Sym);
              Sym = SymT;
            }
        }
      GenQuadO (tokpos, M2Quads_NegateOp, t, SymbolTable_NulSym, Sym, true);
      M2Quads_PushTtok (t, tokpos);
    }
  else if (Tok == M2Reserved_PlusTok)
    {
      /* avoid dangling else.  */
      tokpos = M2LexBuf_MakeVirtualTok (tokpos, tokpos, sympos);
      PushTrwtok (Sym, r, tokpos);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaErrorNT1 (tokpos, (const char *) "expecting an unary operator, seen {%Ek%a}", 41, Tok);
    }
}


/*
   OperandT - returns the ident operand stored in the true position on the boolean stack.
*/

extern "C" unsigned int M2Quads_OperandT (unsigned int pos)
{
  M2Debug_Assert (! (IsBoolean (pos)));
  return OperandTno (pos);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandF - returns the ident operand stored in the false position on the boolean stack.
*/

extern "C" unsigned int M2Quads_OperandF (unsigned int pos)
{
  M2Debug_Assert (! (IsBoolean (pos)));
  return OperandFno (pos);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushTF - Push a True and False numbers onto the True/False stack.
            True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTF (unsigned int True, unsigned int False)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTF - Pop a True and False number from the True/False stack.
           True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PopTF (unsigned int *True, unsigned int *False)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*False) = static_cast<unsigned int> (f->FalseExit);
  M2Debug_Assert (! f->BooleanOp);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PushT - Push an item onto the stack in the T (true) position.
*/

extern "C" void M2Quads_PushT (unsigned int True)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopT - Pops the T value from the stack.
*/

extern "C" void M2Quads_PopT (unsigned int *True)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  M2Debug_Assert (! f->BooleanOp);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PushTtok - Push an item onto the stack in the T (true) position,
              it is assummed to be a token and its token location is recorded.
*/

extern "C" void M2Quads_PushTtok (unsigned int True, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  /* PrintTokenNo (tokno) ;  */
  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->tokenno = tokno;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PushTFtok - Push an item onto the stack in the T (true) position,
               it is assummed to be a token and its token location is recorded.
*/

extern "C" void M2Quads_PushTFtok (unsigned int True, unsigned int False, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->tokenno = tokno;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTFtok - Pop T/F/tok from the stack.
*/

extern "C" void M2Quads_PopTFtok (unsigned int *True, unsigned int *False, unsigned int *tokno)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*False) = static_cast<unsigned int> (f->FalseExit);
  (*tokno) = f->tokenno;
}


/*
   PushTFAtok - Push T/F/A/tok to the stack.
*/

extern "C" void M2Quads_PushTFAtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Unbounded = static_cast<unsigned int> (Array);
  f->tokenno = tokno;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTtok - Pops the T value from the stack and token position.
*/

extern "C" void M2Quads_PopTtok (unsigned int *True, unsigned int *tok)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*tok) = f->tokenno;
  M2Debug_Assert (! f->BooleanOp);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PushTFn - Push a True and False numbers onto the True/False stack.
             True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTFn (unsigned int True, unsigned int False, unsigned int n)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->name = static_cast<unsigned int> (n);
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PushTFntok - Push a True and False numbers onto the True/False stack.
                True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTFntok (unsigned int True, unsigned int False, unsigned int n, unsigned int tokno)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->name = static_cast<unsigned int> (n);
  f->tokenno = tokno;
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   PopTFn - Pop a True and False number from the True/False stack.
            True and False are assumed to contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PopTFn (unsigned int *True, unsigned int *False, unsigned int *n)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  (*True) = static_cast<unsigned int> (f->TrueExit);
  (*False) = static_cast<unsigned int> (f->FalseExit);
  (*n) = static_cast<unsigned int> (f->name);
  M2Debug_Assert (! f->BooleanOp);
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PopNothing - pops the top element on the boolean stack.
*/

extern "C" void M2Quads_PopNothing (void)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  Storage_DEALLOCATE ((void **) &f, sizeof (M2Quads__T2));
}


/*
   PopN - pops multiple elements from the BoolStack.
*/

extern "C" void M2Quads_PopN (unsigned int n)
{
  while (n > 0)
    {
      M2Quads_PopNothing ();
      n -= 1;
    }
}


/*
   PushTFA - Push True, False, Array, numbers onto the
             True/False stack.  True and False are assumed to
             contain Symbols or Ident etc.
*/

extern "C" void M2Quads_PushTFA (unsigned int True, unsigned int False, unsigned int Array)
{
  M2Quads_BoolFrame f;

  f = newBoolFrame ();
  f->TrueExit = static_cast<unsigned int> (True);
  f->FalseExit = static_cast<unsigned int> (False);
  f->Unbounded = static_cast<unsigned int> (Array);
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
}


/*
   OperandTok - returns the token associated with pos, on the stack.
*/

extern "C" unsigned int M2Quads_OperandTok (unsigned int pos)
{
  M2Debug_Assert (! (IsBoolean (pos)));
  return static_cast<unsigned int> (OperandTtok (pos));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandA - returns possible array symbol associated with the ident
              operand stored on the boolean stack.
*/

extern "C" unsigned int M2Quads_OperandA (unsigned int pos)
{
  M2Quads_BoolFrame f;

  M2Debug_Assert (pos > 0);
  M2Debug_Assert (! (IsBoolean (pos)));
  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, pos));
  return static_cast<unsigned int> (f->Unbounded);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OperandAnno - returns the annotation string associated with the
                 position, n, on the stack.
*/

extern "C" DynamicStrings_String M2Quads_OperandAnno (unsigned int n)
{
  M2Quads_BoolFrame f;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, n));
  return f->Annotation;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Annotate - annotate the top of stack.
*/

extern "C" void M2Quads_Annotate (const char *a_, unsigned int _a_high)
{
  M2Quads_BoolFrame f;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if ((DebugStackOn && M2Options_CompilerDebugging) && ((M2StackAddress_NoOfItemsInStackAddress (BoolStack)) > 0))
    {
      f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PeepAddress (BoolStack, 1));  /* top of stack  */
      if (f->Annotation != NULL)  /* top of stack  */
        {
          f->Annotation = DynamicStrings_KillString (f->Annotation);
        }
      f->Annotation = DynamicStrings_InitString ((const char *) a, _a_high);
    }
}


/*
   DisplayStack - displays the compile time symbol stack.
*/

extern "C" void M2Quads_DisplayStack (void)
{
  if (DebugStackOn && M2Options_CompilerDebugging)
    {
      M2DebugStack_DebugStack (M2StackAddress_NoOfItemsInStackAddress (BoolStack), (M2DebugStack_ProcedureWord) {(M2DebugStack_ProcedureWord_t) OperandTno}, (M2DebugStack_ProcedureWord) {(M2DebugStack_ProcedureWord_t) OperandFno}, (M2DebugStack_ProcedureWord) {(M2DebugStack_ProcedureWord_t) M2Quads_OperandA}, (M2DebugStack_ProcedureWord) {(M2DebugStack_ProcedureWord_t) OperandD}, (M2DebugStack_ProcedureWord) {(M2DebugStack_ProcedureWord_t) OperandRW}, (M2DebugStack_ProcedureWord) {(M2DebugStack_ProcedureWord_t) M2Quads_OperandTok}, (M2DebugStack_ProcedureString) {(M2DebugStack_ProcedureString_t) M2Quads_OperandAnno});
    }
}


/*
   Top - returns the no of items held in the stack.
*/

extern "C" unsigned int M2Quads_Top (void)
{
  return M2StackAddress_NoOfItemsInStackAddress (BoolStack);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DupFrame - duplicate the top of stack and push the new frame.
*/

extern "C" void M2Quads_DupFrame (void)
{
  M2Quads_BoolFrame f;
  M2Quads_BoolFrame newf;

  f = static_cast<M2Quads_BoolFrame> (M2StackAddress_PopAddress (BoolStack));
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (f));
  newf = newBoolFrame ();
  (*newf) = (*f);
  M2StackAddress_PushAddress (BoolStack, reinterpret_cast <void *> (newf));
}


/*
   WriteOperand - displays the operands name, symbol id and mode of addressing.
*/

extern "C" void M2Quads_WriteOperand (unsigned int Sym)
{
  NameKey_Name n;

  if (Sym == SymbolTable_NulSym)
    {
      M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "<nulsym>", 8);
    }
  else
    {
      n = SymbolTable_GetSymName (Sym);
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "%a", 2, (const unsigned char *) &n, (sizeof (n)-1));
      if ((SymbolTable_IsVar (Sym)) || (SymbolTable_IsConst (Sym)))
        {
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "[", 1);
          WriteMode (SymbolTable_GetMode (Sym));
          M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "]", 1);
        }
      M2Printf_fprintf1 (M2LangDump_GetDumpFile (), (const char *) "(%d)", 4, (const unsigned char *) &Sym, (sizeof (Sym)-1));
    }
}


/*
   BeginVarient - begin a varient record.
*/

extern "C" void M2Quads_BeginVarient (void)
{
  unsigned int r;
  unsigned int v;

  r = GetRecordOrField ();
  M2Debug_Assert ((SymbolTable_IsRecord (r)) || (SymbolTable_IsFieldVarient (r)));
  v = GetRecordOrField ();
  M2Debug_Assert (SymbolTable_IsVarient (v));
  BuildRange (M2Range_InitCaseBounds (M2CaseList_PushCase (r, v, SymbolTable_NulSym)));
}


/*
   EndVarient - end a varient record.
*/

extern "C" void M2Quads_EndVarient (void)
{
  M2CaseList_PopCase ();
}


/*
   ElseVarient - associate an ELSE clause with a varient record.
*/

extern "C" void M2Quads_ElseVarient (void)
{
  unsigned int f;

  f = GetRecordOrField ();
  M2Debug_Assert (SymbolTable_IsFieldVarient (f));
  M2CaseList_ElseCase (f);
}


/*
   BeginVarientList - begin an ident list containing ranges belonging to a
                      varient list.
*/

extern "C" void M2Quads_BeginVarientList (void)
{
  unsigned int f;

  f = GetRecordOrField ();
  M2Debug_Assert (SymbolTable_IsFieldVarient (f));
  M2CaseList_BeginCaseList (f);
}


/*
   EndVarientList - end a range list for a varient field.
*/

extern "C" void M2Quads_EndVarientList (void)
{
  M2CaseList_EndCaseList ();
}


/*
   AddRecordToList - adds the record held on the top of stack to the
                     list of records and varient fields.
*/

extern "C" void M2Quads_AddRecordToList (void)
{
  unsigned int r;
  unsigned int n;

  r = static_cast<unsigned int> (M2Quads_OperandT (1));
  M2Debug_Assert ((SymbolTable_IsRecord (r)) || (SymbolTable_IsFieldVarient (r)));
  /* 
      r might be a field varient if the declaration consists of nested
      varients.  However ISO TSIZE can only utilise record types, we store
      a varient field anyway as the next pass would not know whether to
      ignore a varient field.
  */
  Lists_PutItemIntoList (VarientFields, r);
  if (DebugVarients)
    {
      n = Lists_NoOfItemsInList (VarientFields);
      if (SymbolTable_IsRecord (r))
        {
          M2Printf_printf2 ((const char *) "in list: record %d is %d\\n", 26, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &r, (sizeof (r)-1));
        }
      else
        {
          M2Printf_printf2 ((const char *) "in list: varient field %d is %d\\n", 33, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &r, (sizeof (r)-1));
        }
    }
}


/*
   AddVarientToList - adds varient held on the top of stack to the list.
*/

extern "C" void M2Quads_AddVarientToList (void)
{
  unsigned int v;
  unsigned int n;

  v = static_cast<unsigned int> (M2Quads_OperandT (1));
  M2Debug_Assert (SymbolTable_IsVarient (v));
  Lists_PutItemIntoList (VarientFields, v);
  if (DebugVarients)
    {
      n = Lists_NoOfItemsInList (VarientFields);
      M2Printf_printf2 ((const char *) "in list: varient %d is %d\\n", 27, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &v, (sizeof (v)-1));
    }
}


/*
   AddVarientFieldToList - adds varient field, f, to the list of all varient
                           fields created.
*/

extern "C" void M2Quads_AddVarientFieldToList (unsigned int f)
{
  unsigned int n;

  M2Debug_Assert (SymbolTable_IsFieldVarient (f));
  Lists_PutItemIntoList (VarientFields, f);
  if (DebugVarients)
    {
      n = Lists_NoOfItemsInList (VarientFields);
      M2Printf_printf2 ((const char *) "in list: varient field %d is %d\\n", 33, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &f, (sizeof (f)-1));
    }
}


/*
   AddVarientRange - creates a range from the top two contant expressions
                     on the stack which are recorded with the current
                     varient field.  The stack is unaltered.
*/

extern "C" void M2Quads_AddVarientRange (void)
{
  unsigned int r1;
  unsigned int r2;

  M2Quads_PopT (&r2);
  M2Quads_PopT (&r1);
  M2CaseList_AddRange (r1, r2, M2LexBuf_GetTokenNo ());
}


/*
   AddVarientEquality - adds the contant expression on the top of the stack
                        to the current varient field being recorded.
                        The stack is unaltered.
*/

extern "C" void M2Quads_AddVarientEquality (void)
{
  unsigned int r1;

  M2Quads_PopT (&r1);
  M2CaseList_AddRange (r1, SymbolTable_NulSym, M2LexBuf_GetTokenNo ());
}


/*
   BuildCodeOn - generates a quadruple declaring that code should be
                 emmitted from henceforth.

                 The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildCodeOn (void)
{
  GenQuad (M2Quads_CodeOnOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
}


/*
   BuildCodeOff - generates a quadruple declaring that code should not be
                  emmitted from henceforth.

                  The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildCodeOff (void)
{
  GenQuad (M2Quads_CodeOffOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
}


/*
   BuildProfileOn - generates a quadruple declaring that profile timings
                    should be emmitted from henceforth.

                    The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildProfileOn (void)
{
  GenQuad (M2Quads_ProfileOnOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
}

extern "C" void M2Quads_BuildProfileOff (void)
{
  /* 
   BuildProfileOn - generates a quadruple declaring that profile timings
                    should be emmitted from henceforth.

                    The Stack is unnaffected.
  */
  GenQuad (M2Quads_ProfileOffOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
}


/*
   BuildOptimizeOn - generates a quadruple declaring that optimization
                     should occur from henceforth.

                     The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildOptimizeOn (void)
{
  GenQuad (M2Quads_OptimizeOnOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
}


/*
   BuildOptimizeOff - generates a quadruple declaring that optimization
                      should not occur from henceforth.

                      The Stack is unnaffected.
*/

extern "C" void M2Quads_BuildOptimizeOff (void)
{
  GenQuad (M2Quads_OptimizeOffOp, SymbolTable_NulSym, SymbolTable_NulSym, SymbolTable_NulSym);
}


/*
   BuildAsm - builds an Inline pseudo quadruple operator.
              The inline interface, Sym, is stored as the operand
              to the operator InlineOp.

              The stack is expected to contain:


                        Entry                   Exit
                        =====                   ====

              Ptr ->
                     +--------------+
                     | Sym          |        Empty
                     |--------------|
*/

extern "C" void M2Quads_BuildAsm (unsigned int tok)
{
  unsigned int Sym;

  M2Quads_PopT (&Sym);
  GenQuadO (tok, M2Quads_InlineOp, SymbolTable_NulSym, SymbolTable_NulSym, Sym, false);
}


/*
   BuildLineNo - builds a LineNumberOp pseudo quadruple operator.
                 This quadruple indicates which source line has been
                 processed, these quadruples are only generated if we
                 are producing runtime debugging information.

                 The stack is not affected, read or altered in any way.


                        Entry                   Exit
                        =====                   ====

                 Ptr ->                              <- Ptr
*/

extern "C" void M2Quads_BuildLineNo (void)
{
  NameKey_Name filename;
  M2Quads_QuadFrame f;

  if (((NextQuad != Head) && (M2Options_GenerateLineDebug || M2Options_GenerateDebugging)) && false)
    {
      filename = NameKey_makekey (DynamicStrings_string (M2LexBuf_GetFileName ()));
      f = GetQF (NextQuad-1);
      if (! ((f->Operator == M2Quads_LineNumberOp) && (f->Operand1 == ((unsigned int ) (filename)))))
        {
          GenQuad (M2Quads_LineNumberOp, (unsigned int ) (filename), SymbolTable_NulSym, (unsigned int ) (M2LexBuf_GetLineNo ()));
        }
    }
}


/*
   PushLineNo - pushes the current file and line number to the stack.
*/

extern "C" void M2Quads_PushLineNo (void)
{
  PushLineNote (InitLineNote (NameKey_makekey (DynamicStrings_string (M2LexBuf_GetFileName ())), M2LexBuf_GetLineNo ()));
}


/*
   BuildStmtNote - builds a StatementNoteOp pseudo quadruple operator.
                   This quadruple indicates which source line has been
                   processed and it represents the start of a statement
                   sequence.
                   It differs from LineNumberOp in that multiple successive
                   LineNumberOps will be removed and the final one is attached to
                   the next real GCC tree.  Whereas a StatementNoteOp is always left
                   alone.  Depending upon the debugging level it will issue a nop
                   instruction to ensure that the gdb single step will step into
                   this line.  Practically it allows pedalogical debugging to
                   occur when there is syntax sugar such as:


                         END   step 
                      END   step 
                   END ;  step 
		   a := 1 ;  step 

                   REPEAT  step 
		      i := 1   step 

                   The stack is not affected, read or altered in any way.


                        Entry                   Exit
                        =====                   ====

                 Ptr ->                              <- Ptr
*/

extern "C" void M2Quads_BuildStmtNote (int offset)
{
  int tokenno;

  if (NextQuad != Head)
    {
      tokenno = offset;
      tokenno += M2LexBuf_GetTokenNo ();
      BuildStmtNoteTok ((unsigned int ) (tokenno));
    }
}


/*
   LoopAnalysis - checks whether an infinite loop exists.
*/

extern "C" void M2Quads_LoopAnalysis (unsigned int Scope, unsigned int Current, unsigned int End)
{
  M2Quads_QuadOperator op;
  unsigned int op1;
  unsigned int op2;
  unsigned int op3;

  if (M2Options_Pedantic)
    {
      while ((Current <= End) && (Current != 0))
        {
          M2Quads_GetQuad (Current, &op, &op1, &op2, &op3);
          if ((op == M2Quads_GotoOp) || (M2Quads_IsConditional (Current)))
            {
              if (op3 <= Current)
                {
                  /* found a loop - ie a branch which goes back in quadruple numbers  */
                  if (IsInfiniteLoop (Current))
                    {
                      M2MetaError_MetaErrorT1 (M2Quads_QuadToTokenNo (op3), (const char *) "it is very likely (although not absolutely certain) that the top of an infinite loop exists here in {%1Wad}", 107, Scope);
                      M2MetaError_MetaErrorT1 (M2Quads_QuadToTokenNo (Current), (const char *) "and the bottom of the infinite loop is ends here in {%1Wad} or alternatively a component of this loop is never executed", 119, Scope);
                    }
                  /* 
                  WarnStringAt(InitString('it is very likely (although not absolutely certain) that the top of an infinite loop is here'),
                               QuadToTokenNo(op3)) ;
                  WarnStringAt(InitString('and the bottom of the infinite loop is ends here or alternatively a component of this loop is never executed'),
                               QuadToTokenNo(Current))
  */
                }
            }
          Current = M2Quads_GetNextQuad (Current);
        }
    }
}


/*
   ForLoopAnalysis - checks all the FOR loops for index variable manipulation
                     and dangerous usage outside the loop.
*/

extern "C" void M2Quads_ForLoopAnalysis (void)
{
  unsigned int i;
  unsigned int n;
  M2Quads_ForLoopInfo forDesc;

  if (M2Options_Pedantic)
    {
      n = Indexing_HighIndice (ForInfo);
      i = 1;
      while (i <= n)
        {
          forDesc = static_cast<M2Quads_ForLoopInfo> (Indexing_GetIndice (ForInfo, i));
          CheckForIndex (forDesc);
          i += 1;
        }
    }
}


/*
   BuildSizeCheckStart - switches off all quadruple generation if the function SIZE or HIGH
                         is being "called".  This should be done as SIZE only requires the
                         actual type of the expression, not its value.  Consider the problem of
                         SIZE(UninitializedPointer^) which is quite legal and it must
                         also be safe!
                         ISO Modula-2 also allows HIGH(a[0]) for a two dimensional array
                         and there is no need to compute a[0], we just need to follow the
                         type and count dimensions.  However if SIZE(a) or HIGH(a) occurs
                         and, a, is an unbounded array then we turn on quadruple generation.

                         The Stack is expected to contain:


                         Entry                       Exit
                         =====                       ====

                 Ptr ->                                                       <- Ptr
                        +----------------------+     +----------------------+
                        | ProcSym | Type | tok |     | ProcSym | Type | tok |
                        |----------------------|     |----------------------|
*/

extern "C" void M2Quads_BuildSizeCheckStart (void)
{
  unsigned int ProcSym;
  unsigned int Type;
  unsigned int tok;

  M2Quads_PopTFtok (&ProcSym, &Type, &tok);
  if (((ProcSym == M2Size_Size) || (ProcSym == M2System_TSize)) || (ProcSym == M2System_TBitSize))
    {
      QuadrupleGeneration = false;
      BuildingSize = true;
    }
  else if (ProcSym == M2Base_High)
    {
      /* avoid dangling else.  */
      QuadrupleGeneration = false;
      BuildingHigh = true;
    }
  M2Quads_PushTFtok (ProcSym, Type, tok);
}


/*
   BackPatchSubrangesAndOptParam - runs through all the quadruples and finds SubrangeLow or SubrangeHigh
                                   quadruples and replaces it by an assignment to the Low or High component
                                   of the subrange type.

                                   Input:
                                   SubrangeLow    op1     op3          op3 is a subrange 

                                   Output:
                                   Becomes        op1     low

                                   Input:
                                   SubrangeHigh   op1     op3          op3 is a subrange 

                                   Output:
                                   Becomes        op1     high

                                   Input:
                                   OptParam       op1     op2    op3

                                   Output:
                                   Param          op1     op2    GetOptArgInit(op3)
*/

extern "C" void M2Quads_BackPatchSubrangesAndOptParam (void)
{
  M2Quads_QuadFrame f;
  unsigned int q;

  q = M2Quads_GetFirstQuad ();
  if (q != 0)
    {
      do {
        f = GetQF (q);
        switch (f->Operator)
          {
            case M2Quads_SubrangeLowOp:
              f->Operand3 = CollectLow (f->Operand3);
              f->Operator = M2Quads_BecomesOp;
              f->ConstExpr = false;
              break;

            case M2Quads_SubrangeHighOp:
              f->Operand3 = CollectHigh (f->Operand3);
              f->Operator = M2Quads_BecomesOp;
              f->ConstExpr = false;
              break;

            case M2Quads_OptParamOp:
              f->Operand3 = SymbolTable_GetOptArgInit (f->Operand3);
              f->Operator = M2Quads_ParamOp;
              break;


            default:
              break;
          }
        q = f->Next;
      } while (! (q == 0));
    }
}


/*
   WriteOperator - writes the name of the quadruple operator.
*/

extern "C" void M2Quads_WriteOperator (M2Quads_QuadOperator Operator)
{
  switch (Operator)
    {
      case M2Quads_ArithAddOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Arith +           ", 18);
        break;

      case M2Quads_InitAddressOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "InitAddress       ", 18);
        break;

      case M2Quads_LastForIteratorOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "LastForIterator   ", 18);
        break;

      case M2Quads_LogicalOrOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Or                ", 18);
        break;

      case M2Quads_LogicalAndOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "And               ", 18);
        break;

      case M2Quads_LogicalXorOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Xor               ", 18);
        break;

      case M2Quads_LogicalDiffOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Ldiff             ", 18);
        break;

      case M2Quads_LogicalShiftOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Shift             ", 18);
        break;

      case M2Quads_LogicalRotateOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Rotate            ", 18);
        break;

      case M2Quads_BecomesOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Becomes           ", 18);
        break;

      case M2Quads_IndrXOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "IndrX             ", 18);
        break;

      case M2Quads_XIndrOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "XIndr             ", 18);
        break;

      case M2Quads_ArrayOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Array             ", 18);
        break;

      case M2Quads_ElementSizeOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "ElementSize       ", 18);
        break;

      case M2Quads_RecordFieldOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "RecordField       ", 18);
        break;

      case M2Quads_AddrOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Addr              ", 18);
        break;

      case M2Quads_SizeOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Size              ", 18);
        break;

      case M2Quads_IfInOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If IN             ", 18);
        break;

      case M2Quads_IfNotInOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If NOT IN         ", 18);
        break;

      case M2Quads_IfNotEquOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If <>             ", 18);
        break;

      case M2Quads_IfEquOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If =              ", 18);
        break;

      case M2Quads_IfLessEquOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If <=             ", 18);
        break;

      case M2Quads_IfGreEquOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If >=             ", 18);
        break;

      case M2Quads_IfGreOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If >              ", 18);
        break;

      case M2Quads_IfLessOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "If <              ", 18);
        break;

      case M2Quads_GotoOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Goto              ", 18);
        break;

      case M2Quads_DummyOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Dummy             ", 18);
        break;

      case M2Quads_ModuleScopeOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "ModuleScopeOp     ", 18);
        break;

      case M2Quads_StartDefFileOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StartDefFile      ", 18);
        break;

      case M2Quads_StartModFileOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StartModFile      ", 18);
        break;

      case M2Quads_EndFileOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "EndFileOp         ", 18);
        break;

      case M2Quads_InitStartOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "InitStart         ", 18);
        break;

      case M2Quads_InitEndOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "InitEnd           ", 18);
        break;

      case M2Quads_FinallyStartOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "FinallyStart      ", 18);
        break;

      case M2Quads_FinallyEndOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "FinallyEnd        ", 18);
        break;

      case M2Quads_RetryOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Retry             ", 18);
        break;

      case M2Quads_TryOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Try               ", 18);
        break;

      case M2Quads_ThrowOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Throw             ", 18);
        break;

      case M2Quads_CatchBeginOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "CatchBegin        ", 18);
        break;

      case M2Quads_CatchEndOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "CatchEnd          ", 18);
        break;

      case M2Quads_AddOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "+                 ", 18);
        break;

      case M2Quads_SubOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "-                 ", 18);
        break;

      case M2Quads_DivM2Op:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "DIV M2            ", 18);
        break;

      case M2Quads_ModM2Op:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "MOD M2            ", 18);
        break;

      case M2Quads_DivCeilOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "DIV ceil          ", 18);
        break;

      case M2Quads_ModCeilOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "MOD ceil          ", 18);
        break;

      case M2Quads_DivFloorOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "DIV floor         ", 18);
        break;

      case M2Quads_ModFloorOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "MOD floor         ", 18);
        break;

      case M2Quads_DivTruncOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "DIV trunc         ", 18);
        break;

      case M2Quads_ModTruncOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "MOD trunc         ", 18);
        break;

      case M2Quads_MultOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "*                 ", 18);
        break;

      case M2Quads_NegateOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Negate            ", 18);
        break;

      case M2Quads_InclOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Incl              ", 18);
        break;

      case M2Quads_ExclOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Excl              ", 18);
        break;

      case M2Quads_ReturnOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Return            ", 18);
        break;

      case M2Quads_ReturnValueOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "ReturnValue       ", 18);
        break;

      case M2Quads_FunctValueOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "FunctValue        ", 18);
        break;

      case M2Quads_CallOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Call              ", 18);
        break;

      case M2Quads_ParamOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Param             ", 18);
        break;

      case M2Quads_OptParamOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "OptParam          ", 18);
        break;

      case M2Quads_NewLocalVarOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "NewLocalVar       ", 18);
        break;

      case M2Quads_KillLocalVarOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "KillLocalVar      ", 18);
        break;

      case M2Quads_ProcedureScopeOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "ProcedureScope    ", 18);
        break;

      case M2Quads_UnboundedOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Unbounded         ", 18);
        break;

      case M2Quads_CoerceOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Coerce            ", 18);
        break;

      case M2Quads_ConvertOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Convert           ", 18);
        break;

      case M2Quads_CastOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Cast              ", 18);
        break;

      case M2Quads_HighOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "High              ", 18);
        break;

      case M2Quads_CodeOnOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "CodeOn            ", 18);
        break;

      case M2Quads_CodeOffOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "CodeOff           ", 18);
        break;

      case M2Quads_ProfileOnOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "ProfileOn         ", 18);
        break;

      case M2Quads_ProfileOffOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "ProfileOff        ", 18);
        break;

      case M2Quads_OptimizeOnOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "OptimizeOn        ", 18);
        break;

      case M2Quads_OptimizeOffOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "OptimizeOff       ", 18);
        break;

      case M2Quads_InlineOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Inline            ", 18);
        break;

      case M2Quads_StatementNoteOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StatementNote     ", 18);
        break;

      case M2Quads_LineNumberOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "LineNumber        ", 18);
        break;

      case M2Quads_BuiltinConstOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "BuiltinConst      ", 18);
        break;

      case M2Quads_BuiltinTypeInfoOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "BuiltinTypeInfo   ", 18);
        break;

      case M2Quads_StandardFunctionOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StandardFunction  ", 18);
        break;

      case M2Quads_SavePriorityOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "SavePriority      ", 18);
        break;

      case M2Quads_RestorePriorityOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "RestorePriority   ", 18);
        break;

      case M2Quads_RangeCheckOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "RangeCheck        ", 18);
        break;

      case M2Quads_ErrorOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "Error             ", 18);
        break;

      case M2Quads_SaveExceptionOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "SaveException     ", 18);
        break;

      case M2Quads_RestoreExceptionOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "RestoreException  ", 18);
        break;

      case M2Quads_StringConvertCnulOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StringConvertCnul ", 18);
        break;

      case M2Quads_StringConvertM2nulOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StringConvertM2nul", 18);
        break;

      case M2Quads_StringLengthOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "StringLength      ", 18);
        break;

      case M2Quads_SubrangeHighOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "SubrangeHigh      ", 18);
        break;

      case M2Quads_SubrangeLowOp:
        M2Printf_fprintf0 (M2LangDump_GetDumpFile (), (const char *) "SubrangeLow       ", 18);
        break;


      default:
        M2Error_InternalError ((const char *) "operator not expected", 21);
        break;
    }
}


/*
   PushAutoOn - push the auto flag and then set it to TRUE.
                Any call to ident in the parser will result in the token being pushed.
*/

extern "C" void M2Quads_PushAutoOn (void)
{
  M2StackWord_PushWord (AutoStack, static_cast<unsigned int> (IsAutoOn));
  IsAutoOn = true;
}


/*
   PushAutoOff - push the auto flag and then set it to FALSE.
*/

extern "C" void M2Quads_PushAutoOff (void)
{
  M2StackWord_PushWord (AutoStack, static_cast<unsigned int> (IsAutoOn));
  IsAutoOn = false;
}


/*
   IsAutoPushOn - returns the value of the current Auto ident push flag.
*/

extern "C" bool M2Quads_IsAutoPushOn (void)
{
  return IsAutoOn;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PopAuto - restores the previous value of the Auto flag.
*/

extern "C" void M2Quads_PopAuto (void)
{
  IsAutoOn = static_cast<bool> (M2StackWord_PopWord (AutoStack));
}


/*
   MustCheckOverflow - returns TRUE if the quadruple should test for overflow.
*/

extern "C" bool M2Quads_MustCheckOverflow (unsigned int q)
{
  M2Quads_QuadFrame f;

  f = GetQF (q);
  return f->CheckOverflow;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushInConstExpression - push the InConstExpression flag and then set it to TRUE.
*/

extern "C" void M2Quads_PushInConstExpression (void)
{
  M2StackWord_PushWord (ConstExprStack, static_cast<unsigned int> (InConstExpression));
  InConstExpression = true;
}


/*
   PopInConstExpression - restores the previous value of the InConstExpression.
*/

extern "C" void M2Quads_PopInConstExpression (void)
{
  InConstExpression = static_cast<bool> (M2StackWord_PopWord (ConstExprStack));
}


/*
   IsInConstExpression - returns the value of the InConstExpression.
*/

extern "C" bool M2Quads_IsInConstExpression (void)
{
  return InConstExpression;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushInConstParameters - push the InConstParameters flag and then set it to TRUE.
*/

extern "C" void M2Quads_PushInConstParameters (void)
{
  M2StackWord_PushWord (ConstParamStack, static_cast<unsigned int> (InConstParameters));
  InConstParameters = true;
}


/*
   PopInConstParameters - restores the previous value of the InConstParameters.
*/

extern "C" void M2Quads_PopInConstParameters (void)
{
  InConstParameters = static_cast<bool> (M2StackWord_PopWord (ConstParamStack));
}


/*
   IsInConstParameters - returns the value of the InConstParameters.
*/

extern "C" bool M2Quads_IsInConstParameters (void)
{
  return InConstParameters;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildAsmElement - the stack is expected to contain:


                        Entry                      Exit
                        =====                      ====

                 Ptr ->
                        +------------------+
                        | expr | tokpos    |
                        |------------------|
                        | str              |
                        |------------------|
                        | name             |
                        |------------------|       +------------------+
                        | CurrentInterface |       | CurrentInterface |
                        |------------------|       |------------------|
                        | CurrentAsm       |       | CurrentAsm       |
                        |------------------|       |------------------|
                        | n                |       | n                |
                        |------------------|       |------------------|
*/

extern "C" void M2Quads_BuildAsmElement (bool input, bool output)
{
  DynamicStrings_String s;
  unsigned int n;
  unsigned int str;
  unsigned int expr;
  unsigned int tokpos;
  unsigned int CurrentInterface;
  unsigned int CurrentAsm;
  unsigned int name;

  M2Quads_PopTtok (&expr, &tokpos);
  M2Quads_PopT (&str);
  M2Quads_PopT (&name);
  M2Quads_PopT (&CurrentInterface);
  M2Quads_PopT (&CurrentAsm);
  M2Debug_Assert ((SymbolTable_IsGnuAsm (CurrentAsm)) || (SymbolTable_IsGnuAsmVolatile (CurrentAsm)));
  M2Quads_PopT (&n);
  n += 1;
  if (CurrentInterface == SymbolTable_NulSym)
    {
      CurrentInterface = SymbolTable_MakeRegInterface ();
    }
  if (input)
    {
      SymbolTable_PutRegInterface (tokpos, CurrentInterface, n, name, str, expr, NextQuad, 0);
      if (DebugAsmTokPos)
        {
          s = DynamicStrings_InitString ((const char *) "input expression", 16);
          M2Error_WarnStringAt (s, tokpos);
        }
    }
  if (output)
    {
      SymbolTable_PutRegInterface (tokpos, CurrentInterface, n, name, str, expr, 0, NextQuad);
      if (DebugAsmTokPos)
        {
          s = DynamicStrings_InitString ((const char *) "output expression", 17);
          M2Error_WarnStringAt (s, tokpos);
        }
    }
  M2Quads_PushT (n);
  M2Quads_PushT (CurrentAsm);
  M2Quads_PushT (CurrentInterface);
}


/*
   BuildAsmTrash - the stack is expected to contain:


                        Entry                      Exit
                        =====                      ====

                 Ptr ->
                        +------------------+
                        | expr | tokpos    |
                        |------------------|       +------------------+
                        | CurrentInterface |       | CurrentInterface |
                        |------------------|       |------------------|
                        | CurrentAsm       |       | CurrentAsm       |
                        |------------------|       |------------------|
                        | n                |       | n                |
                        |------------------|       |------------------|
*/

extern "C" void M2Quads_BuildAsmTrash (void)
{
  unsigned int n;
  unsigned int expr;
  unsigned int tokpos;
  unsigned int CurrentInterface;
  unsigned int CurrentAsm;

  M2Quads_PopTtok (&expr, &tokpos);
  M2Quads_PopT (&CurrentInterface);
  M2Quads_PopT (&CurrentAsm);
  M2Debug_Assert ((SymbolTable_IsGnuAsm (CurrentAsm)) || (SymbolTable_IsGnuAsmVolatile (CurrentAsm)));
  M2Quads_PopT (&n);
  n += 1;
  if (CurrentInterface == SymbolTable_NulSym)
    {
      CurrentInterface = SymbolTable_MakeRegInterface ();
    }
  SymbolTable_PutRegInterface (tokpos, CurrentInterface, n, NameKey_NulName, SymbolTable_NulSym, expr, 0, NextQuad);
  M2Quads_PushT (n);
  M2Quads_PushT (CurrentAsm);
  M2Quads_PushT (CurrentInterface);
}


/*
   GetQuadTrash - return the symbol associated with the trashed operand.
*/

extern "C" unsigned int M2Quads_GetQuadTrash (unsigned int quad)
{
  M2Quads_QuadFrame f;

  f = GetQF (quad);
  LastQuadNo = quad;
  return f->Trash;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Quads_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2Quads_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
