/* do not edit automatically generated by mc from M2Preprocess.  */
/* M2Preprocess.def provides a mechanism to invoke the C preprocessor.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Preprocess_H)
#   define _M2Preprocess_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"

#   if defined (_M2Preprocess_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   PreprocessModule - preprocess a file, filename, returning the new filename
                      of the preprocessed file.
                      Preprocessing will only occur if requested by the user.
                      If no preprocessing was requested then filename is returned.
                      If preprocessing occurs then a temporary file is created
                      and its name is returned.
                      All temporary files will be deleted when the compiler exits.
                      outputdep is the filename which will contain the dependency
                      info if -M, -MM is provided.  outputdep can be NIL in which case
                      it is ignored.
*/

EXTERN DynamicStrings_String M2Preprocess_PreprocessModule (DynamicStrings_String filename, bool topSource, bool deleteDep, DynamicStrings_String outputDep);

/*
   MakeSaveTempsFileNameExt - creates and return the temporary filename.ext.
                              in the current working directory unless
                              SaveTempsDir = obj, when we put it in the dumpdir
                              if that is specified (or fallback to '.' if not).
*/

EXTERN DynamicStrings_String M2Preprocess_MakeSaveTempsFileNameExt (DynamicStrings_String filename, DynamicStrings_String ext);

/*
   OnExitDelete - when the application finishes delete filename.
*/

EXTERN DynamicStrings_String M2Preprocess_OnExitDelete (DynamicStrings_String filename);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
