/* SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTEX_TYPE_FIND_BAR             (gtex_find_bar_get_type ())
#define GTEX_FIND_BAR(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTEX_TYPE_FIND_BAR, GtexFindBar))
#define GTEX_FIND_BAR_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTEX_TYPE_FIND_BAR, GtexFindBarClass))
#define GTEX_IS_FIND_BAR(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTEX_TYPE_FIND_BAR))
#define GTEX_IS_FIND_BAR_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTEX_TYPE_FIND_BAR))
#define GTEX_FIND_BAR_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTEX_TYPE_FIND_BAR, GtexFindBarClass))

typedef struct _GtexFindBar         GtexFindBar;
typedef struct _GtexFindBarClass    GtexFindBarClass;
typedef struct _GtexFindBarPrivate  GtexFindBarPrivate;

struct _GtexFindBar
{
	GtkBin parent;

	GtexFindBarPrivate *priv;
};

struct _GtexFindBarClass
{
	GtkBinClass parent_class;
};

/**
 * GtexFindBarMode:
 * @GTEX_FIND_BAR_MODE_FIND_ONLY: Only the find component is shown.
 * @GTEX_FIND_BAR_MODE_FIND_AND_REPLACE: Both the find and replace components
 *   are shown.
 *
 * The #GtexFindBar mode.
 */
typedef enum
{
	GTEX_FIND_BAR_MODE_FIND_ONLY,
	GTEX_FIND_BAR_MODE_FIND_AND_REPLACE,
} GtexFindBarMode;

GType			gtex_find_bar_get_type				(void);

GtexFindBar *		gtex_find_bar_new				(void);

void			gtex_find_bar_set_mode				(GtexFindBar     *find_bar,
									 GtexFindBarMode  new_mode);

GtkSearchEntry *	gtex_find_bar_get_find_entry			(GtexFindBar *find_bar);

GtkButton *		gtex_find_bar_get_previous_button		(GtexFindBar *find_bar);

GtkButton *		gtex_find_bar_get_next_button			(GtexFindBar *find_bar);

GtkButton *		gtex_find_bar_get_close_button			(GtexFindBar *find_bar);

GtkLabel *		gtex_find_bar_get_info_label			(GtexFindBar *find_bar);

GtkCheckMenuItem *	gtex_find_bar_get_check_menu_item		(GtexFindBar *find_bar,
									 const gchar *item_name);

GtkGrid *		gtex_find_bar_get_replace_grid			(GtexFindBar *find_bar);

GtkSearchEntry *	gtex_find_bar_get_replace_entry			(GtexFindBar *find_bar);

GtkButton *		gtex_find_bar_get_replace_button		(GtexFindBar *find_bar);

GtkButton *		gtex_find_bar_get_replace_all_button		(GtexFindBar *find_bar);

G_END_DECLS
