/* sound_input.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from sound_input.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "org.buddiesofbudgie.budgie-desktop.raven.widget.SoundInput.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "raven-plugin.h"
#include <glib-object.h>
#include <pulse/pulseaudio.h>
#include <gvc-mixer-control.h>
#include <gtk/gtk.h>
#include <gvc-mixer-stream.h>
#include <float.h>
#include <math.h>
#include <gvc-mixer-card.h>
#include <gvc-mixer-ui-device.h>
#include <pango/pango.h>
#include <libpeas.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_INPUT_RAVEN_PLUGIN_0_PROPERTY,
	SOUND_INPUT_RAVEN_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* sound_input_raven_plugin_properties[SOUND_INPUT_RAVEN_PLUGIN_NUM_PROPERTIES];
enum  {
	SOUND_INPUT_RAVEN_WIDGET_0_PROPERTY,
	SOUND_INPUT_RAVEN_WIDGET_NUM_PROPERTIES
};
static GParamSpec* sound_input_raven_widget_properties[SOUND_INPUT_RAVEN_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL,
	SOUND_INPUT_RAVEN_WIDGET_NUM_SIGNALS
};
static guint sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_NUM_SIGNALS] = {0};
enum  {
	SOUND_INPUT_RAVEN_WIDGET_SETTINGS_0_PROPERTY,
	SOUND_INPUT_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* sound_input_raven_widget_settings_properties[SOUND_INPUT_RAVEN_WIDGET_SETTINGS_NUM_PROPERTIES];

struct _SoundInputRavenWidgetPrivate {
	GSettings* budgie_settings;
	gulong scale_id;
	GvcMixerControl* mixer;
	GHashTable* derpers;
	GHashTable* devices;
	gulong primary_notify_id;
	GvcMixerStream* primary_stream;
	GtkBox* main_box;
	GtkListBox* devices_list;
	GtkBox* header;
	GtkButton* header_icon;
	GtkButton* header_reveal_button;
	GtkRevealer* content_revealer;
	GtkBox* content;
	GtkScale* volume_slider;
};

struct _SoundInputRavenWidgetSettingsPrivate {
	GtkSwitch* switch_allow_volume_overdrive;
};

static gpointer sound_input_raven_plugin_parent_class = NULL;
static BudgieRavenPluginIface * sound_input_raven_plugin_budgie_raven_plugin_parent_iface = NULL;
static GType sound_input_raven_plugin_type_id = 0;
static gint SoundInputRavenWidget_private_offset;
static gpointer sound_input_raven_widget_parent_class = NULL;
static GType sound_input_raven_widget_type_id = 0;
static gint SoundInputRavenWidgetSettings_private_offset;
static gpointer sound_input_raven_widget_settings_parent_class = NULL;
static GType sound_input_raven_widget_settings_type_id = 0;

static BudgieRavenWidget* sound_input_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                                      const gchar* uuid,
                                                                      GSettings* settings);
static gboolean sound_input_raven_plugin_real_supports_settings (BudgieRavenPlugin* base);
static void __lambda4_ (SoundInputRavenWidget* self);
static void ___lambda4__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda5_ (SoundInputRavenWidget* self,
                 guint id);
static void ___lambda5__gvc_mixer_control_card_added (GvcMixerControl* _sender,
                                               guint id,
                                               gpointer self);
static void __lambda6_ (SoundInputRavenWidget* self,
                 guint id);
static void ___lambda6__gvc_mixer_control_card_removed (GvcMixerControl* _sender,
                                                 guint id,
                                                 gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void sound_input_raven_widget_on_device_selected (SoundInputRavenWidget* self,
                                                  GtkListBoxRow* list_item);
static void _sound_input_raven_widget_on_device_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                             GtkListBoxRow* row,
                                                                             gpointer self);
static void sound_input_raven_widget_on_scale_change (SoundInputRavenWidget* self);
static void _sound_input_raven_widget_on_scale_change_gtk_range_value_changed (GtkRange* _sender,
                                                                        gpointer self);
static void __lambda7_ (SoundInputRavenWidget* self);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void sound_input_raven_widget_on_device_changed (SoundInputRavenWidget* self,
                                                 guint id);
static void _sound_input_raven_widget_on_device_changed_gvc_mixer_control_default_source_changed (GvcMixerControl* _sender,
                                                                                           guint id,
                                                                                           gpointer self);
static void sound_input_raven_widget_on_state_changed (SoundInputRavenWidget* self,
                                                guint id);
static void _sound_input_raven_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                                 guint new_state,
                                                                                 gpointer self);
static void sound_input_raven_widget_on_device_added (SoundInputRavenWidget* self,
                                               guint id);
static void _sound_input_raven_widget_on_device_added_gvc_mixer_control_input_added (GvcMixerControl* _sender,
                                                                              guint id,
                                                                              gpointer self);
static void sound_input_raven_widget_on_device_removed (SoundInputRavenWidget* self,
                                                 guint id);
static void _sound_input_raven_widget_on_device_removed_gvc_mixer_control_input_removed (GvcMixerControl* _sender,
                                                                                  guint id,
                                                                                  gpointer self);
static void sound_input_raven_widget_settings_updated (SoundInputRavenWidget* self,
                                                const gchar* key);
static void _sound_input_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                                    const gchar* key,
                                                                    gpointer self);
static void __lambda8_ (SoundInputRavenWidget* self,
                 GObject* n,
                 GParamSpec* p);
static void sound_input_raven_widget_update_volume (SoundInputRavenWidget* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void sound_input_raven_widget_set_slider_range_on_max (SoundInputRavenWidget* self,
                                                       gboolean allow_overdrive);
static void sound_input_raven_widget_update_input_draw_markers (SoundInputRavenWidget* self);
static GtkWidget* sound_input_raven_widget_real_build_settings_ui (BudgieRavenWidget* base);
static void sound_input_raven_widget_finalize (GObject * obj);
static void sound_input_raven_widget_settings_finalize (GObject * obj);

static BudgieRavenWidget*
sound_input_raven_plugin_real_new_widget_instance (BudgieRavenPlugin* base,
                                                   const gchar* uuid,
                                                   GSettings* settings)
{
	SoundInputRavenPlugin * self;
	SoundInputRavenWidget* _tmp0_;
	BudgieRavenWidget* result;
	self = (SoundInputRavenPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = sound_input_raven_widget_new (uuid, settings);
	g_object_ref_sink (_tmp0_);
	result = (BudgieRavenWidget*) _tmp0_;
	return result;
}

static gboolean
sound_input_raven_plugin_real_supports_settings (BudgieRavenPlugin* base)
{
	SoundInputRavenPlugin * self;
	gboolean result;
	self = (SoundInputRavenPlugin*) base;
	result = TRUE;
	return result;
}

SoundInputRavenPlugin*
sound_input_raven_plugin_construct (GType object_type)
{
	SoundInputRavenPlugin * self = NULL;
	self = (SoundInputRavenPlugin*) g_object_new (object_type, NULL);
	return self;
}

SoundInputRavenPlugin*
sound_input_raven_plugin_new (void)
{
	return sound_input_raven_plugin_construct (TYPE_SOUND_INPUT_RAVEN_PLUGIN);
}

static void
sound_input_raven_plugin_class_init (SoundInputRavenPluginClass * klass,
                                     gpointer klass_data)
{
	sound_input_raven_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
sound_input_raven_plugin_budgie_raven_plugin_interface_init (BudgieRavenPluginIface * iface,
                                                             gpointer iface_data)
{
	sound_input_raven_plugin_budgie_raven_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->new_widget_instance = (BudgieRavenWidget* (*) (BudgieRavenPlugin*, const gchar*, GSettings*)) sound_input_raven_plugin_real_new_widget_instance;
	iface->supports_settings = (gboolean (*) (BudgieRavenPlugin*)) sound_input_raven_plugin_real_supports_settings;
}

static void
sound_input_raven_plugin_instance_init (SoundInputRavenPlugin * self,
                                        gpointer klass)
{
}

GType
sound_input_raven_plugin_get_type (void)
{
	return sound_input_raven_plugin_type_id;
}

GType
sound_input_raven_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundInputRavenPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_input_raven_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundInputRavenPlugin), 0, (GInstanceInitFunc) sound_input_raven_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_raven_plugin_info = { (GInterfaceInitFunc) sound_input_raven_plugin_budgie_raven_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	sound_input_raven_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "SoundInputRavenPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, sound_input_raven_plugin_type_id, budgie_raven_plugin_get_type (), &budgie_raven_plugin_info);
	return sound_input_raven_plugin_type_id;
}

static inline gpointer
sound_input_raven_widget_get_instance_private (SoundInputRavenWidget* self)
{
	return G_STRUCT_MEMBER_P (self, SoundInputRavenWidget_private_offset);
}

static void
__lambda4_ (SoundInputRavenWidget* self)
{
	GvcMixerStream* _tmp0_;
	_tmp0_ = self->priv->primary_stream;
	if (_tmp0_ != NULL) {
		GvcMixerStream* _tmp1_;
		GvcMixerStream* _tmp2_;
		_tmp1_ = self->priv->primary_stream;
		_tmp2_ = self->priv->primary_stream;
		gvc_mixer_stream_change_is_muted (_tmp1_, !gvc_mixer_stream_get_is_muted (_tmp2_));
	}
}

static void
___lambda4__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda4_ ((SoundInputRavenWidget*) self);
}

static void
__lambda5_ (SoundInputRavenWidget* self,
            guint id)
{
	g_signal_emit (self, sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda5__gvc_mixer_control_card_added (GvcMixerControl* _sender,
                                          guint id,
                                          gpointer self)
{
	__lambda5_ ((SoundInputRavenWidget*) self, id);
}

static void
__lambda6_ (SoundInputRavenWidget* self,
            guint id)
{
	g_signal_emit (self, sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

static void
___lambda6__gvc_mixer_control_card_removed (GvcMixerControl* _sender,
                                            guint id,
                                            gpointer self)
{
	__lambda6_ ((SoundInputRavenWidget*) self, id);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_sound_input_raven_widget_on_device_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self)
{
	sound_input_raven_widget_on_device_selected ((SoundInputRavenWidget*) self, row);
}

static void
_sound_input_raven_widget_on_scale_change_gtk_range_value_changed (GtkRange* _sender,
                                                                   gpointer self)
{
	sound_input_raven_widget_on_scale_change ((SoundInputRavenWidget*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda7_ (SoundInputRavenWidget* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkImage* image = NULL;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkImage* _tmp6_;
	GtkRevealer* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	_tmp0_ = self->priv->content_revealer;
	_tmp1_ = self->priv->content_revealer;
	_tmp2_ = gtk_revealer_get_child_revealed (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->header_reveal_button;
	_tmp5_ = gtk_button_get_image (_tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage));
	image = _tmp6_;
	_tmp7_ = self->priv->content_revealer;
	_tmp8_ = gtk_revealer_get_reveal_child (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GtkImage* _tmp10_;
		_tmp10_ = image;
		gtk_image_set_from_icon_name (_tmp10_, "pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	} else {
		GtkImage* _tmp11_;
		_tmp11_ = image;
		gtk_image_set_from_icon_name (_tmp11_, "pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	}
	_g_object_unref0 (image);
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ ((SoundInputRavenWidget*) self);
}

static void
_sound_input_raven_widget_on_device_changed_gvc_mixer_control_default_source_changed (GvcMixerControl* _sender,
                                                                                      guint id,
                                                                                      gpointer self)
{
	sound_input_raven_widget_on_device_changed ((SoundInputRavenWidget*) self, id);
}

static void
_sound_input_raven_widget_on_state_changed_gvc_mixer_control_state_changed (GvcMixerControl* _sender,
                                                                            guint new_state,
                                                                            gpointer self)
{
	sound_input_raven_widget_on_state_changed ((SoundInputRavenWidget*) self, new_state);
}

static void
_sound_input_raven_widget_on_device_added_gvc_mixer_control_input_added (GvcMixerControl* _sender,
                                                                         guint id,
                                                                         gpointer self)
{
	sound_input_raven_widget_on_device_added ((SoundInputRavenWidget*) self, id);
}

static void
_sound_input_raven_widget_on_device_removed_gvc_mixer_control_input_removed (GvcMixerControl* _sender,
                                                                             guint id,
                                                                             gpointer self)
{
	sound_input_raven_widget_on_device_removed ((SoundInputRavenWidget*) self, id);
}

static void
_sound_input_raven_widget_settings_updated_g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self)
{
	sound_input_raven_widget_settings_updated ((SoundInputRavenWidget*) self, key);
}

SoundInputRavenWidget*
sound_input_raven_widget_construct (GType object_type,
                                    const gchar* uuid,
                                    GSettings* settings)
{
	SoundInputRavenWidget * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkBox* _tmp15_;
	GtkButton* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkRevealer* _tmp20_;
	GtkRevealer* _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkRevealer* _tmp24_;
	GtkStyleContext* _tmp25_;
	GvcMixerControl* _tmp26_;
	GvcMixerControl* _tmp27_;
	GvcMixerControl* _tmp28_;
	GHashFunc _tmp29_;
	GEqualFunc _tmp30_;
	GHashTable* _tmp31_;
	GHashTable* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GHashTable* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GHashFunc _tmp38_;
	GEqualFunc _tmp39_;
	GHashTable* _tmp40_;
	GtkListBox* _tmp41_;
	GtkListBox* _tmp42_;
	GtkStyleContext* _tmp43_;
	GtkListBox* _tmp44_;
	GtkStyleContext* _tmp45_;
	GtkListBox* _tmp46_;
	GtkListBox* _tmp47_;
	GtkScale* _tmp48_;
	GtkScale* _tmp49_;
	GtkScale* _tmp50_;
	GtkScale* _tmp51_;
	GtkBox* _tmp52_;
	GtkScale* _tmp53_;
	GtkButton* _tmp54_;
	GtkButton* _tmp55_;
	GtkStyleContext* _tmp56_;
	GtkButton* _tmp57_;
	GtkStyleContext* _tmp58_;
	GtkButton* _tmp59_;
	GtkButton* _tmp60_;
	GtkButton* _tmp61_;
	GtkBox* _tmp62_;
	GtkButton* _tmp63_;
	GSettings* _tmp64_;
	GvcMixerControl* _tmp65_;
	GvcMixerControl* _tmp66_;
	GvcMixerControl* _tmp67_;
	GvcMixerControl* _tmp68_;
	GtkBox* _tmp69_;
	GtkListBox* _tmp70_;
	GvcMixerControl* _tmp71_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (SoundInputRavenWidget*) g_object_new (object_type, NULL);
	budgie_raven_widget_initialize ((BudgieRavenWidget*) self, uuid, settings);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->main_box);
	self->priv->main_box = _tmp0_;
	_tmp1_ = self->priv->main_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp2_;
	_tmp3_ = self->priv->header;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, "raven-header");
	_tmp5_ = self->priv->main_box;
	_tmp6_ = self->priv->header;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("microphone-sensitivity-muted-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->header_icon);
	self->priv->header_icon = _tmp7_;
	_tmp8_ = self->priv->header_icon;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	gtk_style_context_add_class (_tmp9_, "flat");
	_tmp10_ = self->priv->header_icon;
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_CENTER);
	_tmp11_ = self->priv->header_icon;
	g_object_set ((GtkWidget*) _tmp11_, "margin", 4, NULL);
	_tmp12_ = self->priv->header_icon;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp12_, 8);
	_tmp13_ = self->priv->header_icon;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp13_, 4);
	_tmp14_ = self->priv->header_icon;
	g_signal_connect_object (_tmp14_, "clicked", (GCallback) ___lambda4__gtk_button_clicked, self, 0);
	_tmp15_ = self->priv->header;
	_tmp16_ = self->priv->header_icon;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->content);
	self->priv->content = _tmp17_;
	_tmp18_ = self->priv->content;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, "raven-background");
	_tmp20_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->content_revealer);
	self->priv->content_revealer = _tmp20_;
	_tmp21_ = self->priv->content_revealer;
	_tmp22_ = self->priv->content;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->main_box;
	_tmp24_ = self->priv->content_revealer;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp25_, "audio-widget");
	_tmp26_ = gvc_mixer_control_new ("Budgie Volume Control");
	_g_object_unref0 (self->priv->mixer);
	self->priv->mixer = _tmp26_;
	_tmp27_ = self->priv->mixer;
	g_signal_connect_object (_tmp27_, "card-added", (GCallback) ___lambda5__gvc_mixer_control_card_added, self, 0);
	_tmp28_ = self->priv->mixer;
	g_signal_connect_object (_tmp28_, "card-removed", (GCallback) ___lambda6__gvc_mixer_control_card_removed, self, 0);
	_tmp29_ = g_str_hash;
	_tmp30_ = g_str_equal;
	_tmp31_ = g_hash_table_new_full (_tmp29_, _tmp30_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->derpers);
	self->priv->derpers = _tmp31_;
	_tmp32_ = self->priv->derpers;
	_tmp33_ = g_strdup ("Vivaldi");
	_tmp34_ = g_strdup ("vivaldi");
	g_hash_table_insert (_tmp32_, _tmp33_, _tmp34_);
	_tmp35_ = self->priv->derpers;
	_tmp36_ = g_strdup ("Vivaldi Snapshot");
	_tmp37_ = g_strdup ("vivaldi-snapshot");
	g_hash_table_insert (_tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = g_direct_hash;
	_tmp39_ = g_direct_equal;
	_tmp40_ = g_hash_table_new_full (_tmp38_, _tmp39_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->devices);
	self->priv->devices = _tmp40_;
	_tmp41_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->devices_list);
	self->priv->devices_list = _tmp41_;
	_tmp42_ = self->priv->devices_list;
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) _tmp42_);
	gtk_style_context_add_class (_tmp43_, "devices-list");
	_tmp44_ = self->priv->devices_list;
	_tmp45_ = gtk_widget_get_style_context ((GtkWidget*) _tmp44_);
	gtk_style_context_add_class (_tmp45_, "sound-devices");
	_tmp46_ = self->priv->devices_list;
	gtk_list_box_set_selection_mode (_tmp46_, GTK_SELECTION_SINGLE);
	_tmp47_ = self->priv->devices_list;
	g_signal_connect_object (_tmp47_, "row-selected", (GCallback) _sound_input_raven_widget_on_device_selected_gtk_list_box_row_selected, self, 0);
	_tmp48_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 100, (gdouble) 10);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->volume_slider);
	self->priv->volume_slider = _tmp48_;
	_tmp49_ = self->priv->volume_slider;
	gtk_scale_set_draw_value (_tmp49_, FALSE);
	_tmp50_ = self->priv->volume_slider;
	g_signal_connect_object ((GtkRange*) _tmp50_, "value-changed", (GCallback) _sound_input_raven_widget_on_scale_change_gtk_range_value_changed, self, 0);
	_tmp51_ = self->priv->volume_slider;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp51_, TRUE);
	_tmp52_ = self->priv->header;
	_tmp53_ = self->priv->volume_slider;
	gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = (GtkButton*) gtk_button_new_from_icon_name ("pan-end-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->header_reveal_button);
	self->priv->header_reveal_button = _tmp54_;
	_tmp55_ = self->priv->header_reveal_button;
	_tmp56_ = gtk_widget_get_style_context ((GtkWidget*) _tmp55_);
	gtk_style_context_add_class (_tmp56_, "flat");
	_tmp57_ = self->priv->header_reveal_button;
	_tmp58_ = gtk_widget_get_style_context ((GtkWidget*) _tmp57_);
	gtk_style_context_add_class (_tmp58_, "expander-button");
	_tmp59_ = self->priv->header_reveal_button;
	g_object_set ((GtkWidget*) _tmp59_, "margin", 4, NULL);
	_tmp60_ = self->priv->header_reveal_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp60_, GTK_ALIGN_CENTER);
	_tmp61_ = self->priv->header_reveal_button;
	g_signal_connect_object (_tmp61_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp62_ = self->priv->header;
	_tmp63_ = self->priv->header_reveal_button;
	gtk_box_pack_end (_tmp62_, (GtkWidget*) _tmp63_, FALSE, FALSE, (guint) 0);
	_tmp64_ = g_settings_new ("com.solus-project.budgie-panel");
	_g_object_unref0 (self->priv->budgie_settings);
	self->priv->budgie_settings = _tmp64_;
	_tmp65_ = self->priv->mixer;
	g_signal_connect_object (_tmp65_, "default-source-changed", (GCallback) _sound_input_raven_widget_on_device_changed_gvc_mixer_control_default_source_changed, self, 0);
	_tmp66_ = self->priv->mixer;
	g_signal_connect_object (_tmp66_, "state-changed", (GCallback) _sound_input_raven_widget_on_state_changed_gvc_mixer_control_state_changed, self, 0);
	_tmp67_ = self->priv->mixer;
	g_signal_connect_object (_tmp67_, "input-added", (GCallback) _sound_input_raven_widget_on_device_added_gvc_mixer_control_input_added, self, 0);
	_tmp68_ = self->priv->mixer;
	g_signal_connect_object (_tmp68_, "input-removed", (GCallback) _sound_input_raven_widget_on_device_removed_gvc_mixer_control_input_removed, self, 0);
	_tmp69_ = self->priv->content;
	_tmp70_ = self->priv->devices_list;
	gtk_box_pack_start (_tmp69_, (GtkWidget*) _tmp70_, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (settings, "changed", (GCallback) _sound_input_raven_widget_settings_updated_g_settings_changed, self, 0);
	sound_input_raven_widget_settings_updated (self, "allow-volume-overdrive");
	_tmp71_ = self->priv->mixer;
	gvc_mixer_control_open (_tmp71_);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

SoundInputRavenWidget*
sound_input_raven_widget_new (const gchar* uuid,
                              GSettings* settings)
{
	return sound_input_raven_widget_construct (TYPE_SOUND_INPUT_RAVEN_WIDGET, uuid, settings);
}

/**
 * has_devices will check if we have devices associated with this type
 */
static inline gboolean
vala_g_slist_is_empty (GSList* self)
{
	gboolean result;
	result = ((GSList*) self) == NULL;
	return result;
}

gboolean
sound_input_raven_widget_has_devices (SoundInputRavenWidget* self)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->devices;
	if (g_hash_table_size (_tmp1_) != ((guint) 0)) {
		GvcMixerControl* _tmp2_;
		GSList* _tmp3_;
		GSList* _tmp4_;
		_tmp2_ = self->priv->mixer;
		_tmp3_ = gvc_mixer_control_get_cards (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_g_slist_is_empty (_tmp4_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_slist_free (_tmp4_), NULL));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * on_device_added will handle when an input or output device has been added
 */
static void
sound_input_raven_widget_on_device_added (SoundInputRavenWidget* self,
                                          guint id)
{
	GHashTable* _tmp0_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp1_;
	GvcMixerUIDevice* _tmp2_;
	GvcMixerUIDevice* _tmp3_;
	GvcMixerUIDevice* _tmp4_;
	GvcMixerUIDevice* _tmp5_;
	void* _tmp6_;
	void* _tmp7_;
	GvcMixerCard* card = NULL;
	GvcMixerUIDevice* _tmp8_;
	void* _tmp9_;
	void* _tmp10_;
	GvcMixerCard* _tmp11_;
	GtkBox* box = NULL;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkBox* _tmp16_;
	GtkLabel* label = NULL;
	GvcMixerUIDevice* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GvcMixerCard* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GtkLabel* _tmp27_ = NULL;
	GtkLabel* _tmp28_;
	GtkBox* _tmp29_;
	GtkLabel* _tmp30_;
	GtkListBoxRow* list_item = NULL;
	GtkListBoxRow* _tmp31_;
	GtkListBoxRow* _tmp32_;
	GtkBox* _tmp33_;
	GtkListBoxRow* _tmp34_;
	GtkListBox* _tmp35_;
	GtkListBoxRow* _tmp36_;
	GHashTable* _tmp37_;
	GtkListBoxRow* _tmp38_;
	GtkListBoxRow* _tmp39_;
	GtkListBoxRow* _tmp40_;
	GtkListBox* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	if (g_hash_table_contains (_tmp0_, (gpointer) ((guintptr) id))) {
		return;
	}
	_tmp1_ = self->priv->mixer;
	_tmp2_ = gvc_mixer_control_lookup_input_id (_tmp1_, id);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	device = _tmp3_;
	_tmp4_ = device;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp5_ = device;
	g_object_get (_tmp5_, "card", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (device);
		return;
	}
	_tmp8_ = device;
	g_object_get (_tmp8_, "card", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gvc_mixer_card_get_type ()) ? ((GvcMixerCard*) _tmp10_) : NULL);
	card = _tmp11_;
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp12_);
	box = _tmp12_;
	_tmp13_ = box;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp13_, 6);
	_tmp14_ = box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp14_, 6);
	_tmp15_ = box;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 3);
	_tmp16_ = box;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 3);
	_tmp17_ = device;
	g_object_get (_tmp17_, "description", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = card;
	g_object_get (_tmp21_, "name", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("%s - %s", _tmp20_, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = (GtkLabel*) gtk_label_new (_tmp26_);
	gtk_widget_set_valign ((GtkWidget*) _tmp27_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp27_, 0.0f);
	gtk_label_set_max_width_chars (_tmp27_, 1);
	gtk_label_set_ellipsize (_tmp27_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp27_, TRUE);
	g_object_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp20_);
	label = _tmp28_;
	_tmp29_ = box;
	_tmp30_ = label;
	gtk_box_pack_start (_tmp29_, (GtkWidget*) _tmp30_, FALSE, TRUE, (guint) 0);
	_tmp31_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	g_object_ref_sink (_tmp31_);
	list_item = _tmp31_;
	_tmp32_ = list_item;
	_tmp33_ = box;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = list_item;
	g_object_set_data_full ((GObject*) _tmp34_, "device_id", (gpointer) ((guintptr) id), NULL);
	_tmp35_ = self->priv->devices_list;
	_tmp36_ = list_item;
	gtk_list_box_insert (_tmp35_, (GtkWidget*) _tmp36_, -1);
	_tmp37_ = self->priv->devices;
	_tmp38_ = list_item;
	_tmp39_ = _g_object_ref0 (_tmp38_);
	g_hash_table_insert (_tmp37_, (gpointer) ((guintptr) id), _tmp39_);
	_tmp40_ = list_item;
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
	_tmp41_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp41_);
	g_signal_emit (self, sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	_g_object_unref0 (card);
	_g_object_unref0 (device);
}

/**
 * on_device_changed will handle when a Gvc.MixerUIDevice has been changed
 */
static void
__lambda8_ (SoundInputRavenWidget* self,
            GObject* n,
            GParamSpec* p)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = p->name;
	if (g_strcmp0 (_tmp1_, "volume") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = p->name;
		_tmp0_ = g_strcmp0 (_tmp2_, "is-muted") == 0;
	}
	if (_tmp0_) {
		sound_input_raven_widget_update_volume (self);
	}
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((SoundInputRavenWidget*) self, _sender, pspec);
}

static void
sound_input_raven_widget_on_device_changed (SoundInputRavenWidget* self,
                                            guint id)
{
	GvcMixerStream* stream = NULL;
	GvcMixerControl* _tmp0_;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp2_;
	GvcMixerStream* _tmp3_;
	GvcMixerStream* _tmp4_;
	GvcMixerStream* _tmp5_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp6_;
	GvcMixerStream* _tmp7_;
	GvcMixerUIDevice* _tmp8_;
	GvcMixerUIDevice* _tmp9_;
	GtkListBoxRow* list_item = NULL;
	GHashTable* _tmp10_;
	GvcMixerUIDevice* _tmp11_;
	gconstpointer _tmp12_;
	GtkListBoxRow* _tmp13_;
	GtkListBoxRow* _tmp14_;
	GvcMixerStream* _tmp17_;
	GvcMixerStream* _tmp19_;
	gulong _tmp20_;
	GvcMixerStream* _tmp21_;
	GvcMixerStream* _tmp22_;
	GtkListBox* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mixer;
	_tmp1_ = gvc_mixer_control_get_default_source (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	stream = _tmp2_;
	_tmp3_ = stream;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (stream);
		return;
	}
	_tmp4_ = stream;
	_tmp5_ = self->priv->primary_stream;
	if (_tmp4_ == _tmp5_) {
		_g_object_unref0 (stream);
		return;
	}
	_tmp6_ = self->priv->mixer;
	_tmp7_ = stream;
	_tmp8_ = gvc_mixer_control_lookup_device_from_stream (_tmp6_, _tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	device = _tmp9_;
	_tmp10_ = self->priv->devices;
	_tmp11_ = device;
	_tmp12_ = g_hash_table_lookup (_tmp10_, (gpointer) ((guintptr) gvc_mixer_ui_device_get_id (_tmp11_)));
	_tmp13_ = _g_object_ref0 ((GtkListBoxRow*) _tmp12_);
	list_item = _tmp13_;
	_tmp14_ = list_item;
	if (_tmp14_ != NULL) {
		GtkListBox* _tmp15_;
		GtkListBoxRow* _tmp16_;
		_tmp15_ = self->priv->devices_list;
		_tmp16_ = list_item;
		gtk_list_box_select_row (_tmp15_, _tmp16_);
	}
	_tmp17_ = self->priv->primary_stream;
	if (_tmp17_ != NULL) {
		GvcMixerStream* _tmp18_;
		_tmp18_ = self->priv->primary_stream;
		g_signal_handler_disconnect ((GObject*) _tmp18_, self->priv->primary_notify_id);
		self->priv->primary_notify_id = (gulong) 0;
	}
	_tmp19_ = stream;
	_tmp20_ = g_signal_connect_object ((GObject*) _tmp19_, "notify", (GCallback) ___lambda8__g_object_notify, self, 0);
	self->priv->primary_notify_id = _tmp20_;
	_tmp21_ = stream;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (self->priv->primary_stream);
	self->priv->primary_stream = _tmp22_;
	sound_input_raven_widget_update_volume (self);
	_tmp23_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
	g_signal_emit (self, sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
	_g_object_unref0 (device);
	_g_object_unref0 (stream);
}

/**
 * on_device_removed will handle when a Gvc.MixerUIDevice has been removed
 */
static void
sound_input_raven_widget_on_device_removed (SoundInputRavenWidget* self,
                                            guint id)
{
	GtkListBoxRow* list_item = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	GHashTable* _tmp4_;
	GtkListBoxRow* _tmp5_;
	GtkListBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((guintptr) id));
	_tmp2_ = _g_object_ref0 ((GtkListBoxRow*) _tmp1_);
	list_item = _tmp2_;
	_tmp3_ = list_item;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (list_item);
		return;
	}
	_tmp4_ = self->priv->devices;
	g_hash_table_steal (_tmp4_, (gpointer) ((guintptr) id));
	_tmp5_ = list_item;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->devices_list;
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
	g_signal_emit (self, sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
	_g_object_unref0 (list_item);
}

/**
 * on_device_selected will handle when a checkbox related to an input or output device is selected
 */
static void
sound_input_raven_widget_on_device_selected (SoundInputRavenWidget* self,
                                             GtkListBoxRow* list_item)
{
	GtkListBox* _tmp0_;
	guint id = 0U;
	gconstpointer _tmp1_;
	GvcMixerUIDevice* device = NULL;
	GvcMixerControl* _tmp2_;
	GvcMixerUIDevice* _tmp3_;
	GvcMixerUIDevice* _tmp4_;
	GvcMixerUIDevice* _tmp5_;
	GtkListBox* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices_list;
	g_signal_handlers_block_by_func ((void*) _tmp0_, (void*) sound_input_raven_widget_on_device_selected, self);
	_tmp1_ = g_object_get_data ((GObject*) list_item, "device_id");
	id = (guint) ((guintptr) _tmp1_);
	_tmp2_ = self->priv->mixer;
	_tmp3_ = gvc_mixer_control_lookup_input_id (_tmp2_, id);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	device = _tmp4_;
	_tmp5_ = device;
	if (_tmp5_ != NULL) {
		GvcMixerControl* _tmp6_;
		GvcMixerUIDevice* _tmp7_;
		_tmp6_ = self->priv->mixer;
		_tmp7_ = device;
		gvc_mixer_control_change_input (_tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->devices_list;
	g_signal_handlers_unblock_by_func ((void*) _tmp8_, (void*) sound_input_raven_widget_on_device_selected, self);
	_g_object_unref0 (device);
}

/**
 * When our volume slider has changed
 */
static void
sound_input_raven_widget_on_scale_change (SoundInputRavenWidget* self)
{
	gboolean _tmp0_ = FALSE;
	GvcMixerStream* _tmp1_;
	GvcMixerStream* _tmp3_;
	GtkScale* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->primary_stream;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GvcMixerStream* _tmp2_;
		_tmp2_ = self->priv->primary_stream;
		_tmp0_ = gvc_mixer_stream_get_is_muted (_tmp2_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->primary_stream;
	_tmp4_ = self->priv->volume_slider;
	if (gvc_mixer_stream_set_volume (_tmp3_, (guint32) gtk_range_get_value ((GtkRange*) _tmp4_))) {
		GvcMixerStream* _tmp5_;
		_tmp5_ = self->priv->primary_stream;
		gvc_mixer_stream_push_volume (_tmp5_);
	}
}

/**
 * on_state_changed will handle when the state of our Mixer or its streams have changed
 */
static void
sound_input_raven_widget_on_state_changed (SoundInputRavenWidget* self,
                                           guint id)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL], 0);
}

/**
 * update_volume will handle updating our volume slider and output header during device change
 */
static void
sound_input_raven_widget_update_volume (SoundInputRavenWidget* self)
{
	guint32 vol = 0U;
	GvcMixerStream* _tmp0_;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp1_;
	gint n = 0;
	gchar* image_name = NULL;
	gchar* icon_prefix = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GvcMixerStream* _tmp4_;
	GtkImage* header_image = NULL;
	GtkButton* _tmp9_;
	GtkWidget* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->primary_stream;
	vol = gvc_mixer_stream_get_volume (_tmp0_);
	_tmp1_ = self->priv->mixer;
	vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	n = ((gint) floor ((3 * vol) / vol_max)) + 1;
	_tmp2_ = g_strdup ("microphone-sensitivity");
	icon_prefix = _tmp2_;
	_tmp4_ = self->priv->primary_stream;
	if (gvc_mixer_stream_get_is_muted (_tmp4_)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vol <= ((guint32) 0);
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("muted");
		_g_free0 (image_name);
		image_name = _tmp5_;
	} else {
		switch (n) {
			case 1:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("low");
				_g_free0 (image_name);
				image_name = _tmp6_;
				break;
			}
			case 2:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("medium");
				_g_free0 (image_name);
				image_name = _tmp7_;
				break;
			}
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("high");
				_g_free0 (image_name);
				image_name = _tmp8_;
				break;
			}
		}
	}
	_tmp9_ = self->priv->header_icon;
	_tmp10_ = gtk_button_get_image (_tmp9_);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_image_get_type (), GtkImage));
	header_image = _tmp11_;
	_tmp12_ = header_image;
	_tmp13_ = icon_prefix;
	_tmp14_ = image_name;
	_tmp15_ = g_strdup_printf ("%s-%s-symbolic", _tmp13_, _tmp14_);
	_tmp16_ = _tmp15_;
	gtk_image_set_from_icon_name (_tmp12_, _tmp16_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	_g_free0 (_tmp16_);
	if (self->priv->scale_id > ((gulong) 0)) {
		GtkScale* _tmp17_;
		_tmp17_ = self->priv->volume_slider;
		g_signal_handler_block (_tmp17_, self->priv->scale_id);
	}
	if (self->priv->scale_id > ((gulong) 0)) {
		GtkScale* _tmp18_;
		_tmp18_ = self->priv->volume_slider;
		g_signal_handler_unblock (_tmp18_, self->priv->scale_id);
	}
	_g_object_unref0 (header_image);
	_g_free0 (icon_prefix);
	_g_free0 (image_name);
}

static void
sound_input_raven_widget_set_slider_range_on_max (SoundInputRavenWidget* self,
                                                  gboolean allow_overdrive)
{
	gdouble current_volume = 0.0;
	GtkScale* _tmp0_;
	gdouble vol_max = 0.0;
	GvcMixerControl* _tmp1_;
	gdouble vol_max_above = 0.0;
	GvcMixerControl* _tmp2_;
	gdouble step_size = 0.0;
	gint slider_start = 0;
	gint slider_end = 0;
	GtkScale* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume_slider;
	current_volume = gtk_range_get_value ((GtkRange*) _tmp0_);
	_tmp1_ = self->priv->mixer;
	vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
	_tmp2_ = self->priv->mixer;
	vol_max_above = gvc_mixer_control_get_vol_max_amplified (_tmp2_);
	step_size = vol_max / 20;
	slider_start = 0;
	slider_end = 0;
	_tmp3_ = self->priv->volume_slider;
	gtk_range_get_slider_range ((GtkRange*) _tmp3_, &_tmp4_, &_tmp5_);
	slider_start = _tmp4_;
	slider_end = _tmp5_;
	if (allow_overdrive) {
		_tmp6_ = ((gdouble) slider_end) != vol_max_above;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkScale* _tmp7_;
		GtkScale* _tmp8_;
		GtkScale* _tmp9_;
		_tmp7_ = self->priv->volume_slider;
		gtk_range_set_increments ((GtkRange*) _tmp7_, step_size, step_size);
		_tmp8_ = self->priv->volume_slider;
		gtk_range_set_range ((GtkRange*) _tmp8_, (gdouble) 0, vol_max_above);
		_tmp9_ = self->priv->volume_slider;
		gtk_range_set_value ((GtkRange*) _tmp9_, current_volume);
	} else {
		gboolean _tmp10_ = FALSE;
		if (!allow_overdrive) {
			_tmp10_ = ((gdouble) slider_end) != vol_max;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GtkScale* _tmp11_;
			GtkScale* _tmp12_;
			GtkScale* _tmp13_;
			_tmp11_ = self->priv->volume_slider;
			gtk_range_set_increments ((GtkRange*) _tmp11_, step_size, step_size);
			_tmp12_ = self->priv->volume_slider;
			gtk_range_set_range ((GtkRange*) _tmp12_, (gdouble) 0, vol_max);
			_tmp13_ = self->priv->volume_slider;
			gtk_range_set_value ((GtkRange*) _tmp13_, current_volume);
		}
	}
	sound_input_raven_widget_update_input_draw_markers (self);
}

/**
 * update_input_draw_markers will update our draw markers
 */
static void
sound_input_raven_widget_update_input_draw_markers (SoundInputRavenWidget* self)
{
	gboolean allow_higher_than_max = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
	allow_higher_than_max = g_settings_get_boolean (_tmp0_, "allow-volume-overdrive");
	if (allow_higher_than_max) {
		gdouble vol_max = 0.0;
		GvcMixerControl* _tmp1_;
		GtkScale* _tmp2_;
		_tmp1_ = self->priv->mixer;
		vol_max = gvc_mixer_control_get_vol_max_norm (_tmp1_);
		_tmp2_ = self->priv->volume_slider;
		gtk_scale_add_mark (_tmp2_, vol_max, GTK_POS_BOTTOM, "");
	} else {
		GtkScale* _tmp3_;
		_tmp3_ = self->priv->volume_slider;
		gtk_scale_clear_marks (_tmp3_);
	}
}

static void
sound_input_raven_widget_settings_updated (SoundInputRavenWidget* self,
                                           const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "allow-volume-overdrive") == 0) {
		GSettings* _tmp0_;
		_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
		sound_input_raven_widget_set_slider_range_on_max (self, g_settings_get_boolean (_tmp0_, key));
	}
}

static GtkWidget*
sound_input_raven_widget_real_build_settings_ui (BudgieRavenWidget* base)
{
	SoundInputRavenWidget * self;
	GSettings* _tmp0_;
	SoundInputRavenWidgetSettings* _tmp1_;
	GtkWidget* result;
	self = (SoundInputRavenWidget*) base;
	_tmp0_ = budgie_raven_widget_get_instance_settings ((BudgieRavenWidget*) self);
	_tmp1_ = sound_input_raven_widget_settings_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (GtkWidget*) _tmp1_;
	return result;
}

static void
sound_input_raven_widget_class_init (SoundInputRavenWidgetClass * klass,
                                     gpointer klass_data)
{
	sound_input_raven_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundInputRavenWidget_private_offset);
	((BudgieRavenWidgetClass *) klass)->build_settings_ui = (GtkWidget* (*) (BudgieRavenWidget*)) sound_input_raven_widget_real_build_settings_ui;
	G_OBJECT_CLASS (klass)->finalize = sound_input_raven_widget_finalize;
	/**
	 * Signals
	 */
	sound_input_raven_widget_signals[SOUND_INPUT_RAVEN_WIDGET_DEVICES_STATE_CHANGED_SIGNAL] = g_signal_new ("devices-state-changed", TYPE_SOUND_INPUT_RAVEN_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sound_input_raven_widget_instance_init (SoundInputRavenWidget * self,
                                        gpointer klass)
{
	self->priv = sound_input_raven_widget_get_instance_private (self);
	self->priv->budgie_settings = NULL;
	self->priv->scale_id = (gulong) 0;
	self->priv->mixer = NULL;
	self->priv->primary_notify_id = (gulong) 0;
	self->priv->primary_stream = NULL;
	self->priv->main_box = NULL;
	self->priv->devices_list = NULL;
	self->priv->header = NULL;
	self->priv->header_icon = NULL;
	self->priv->header_reveal_button = NULL;
	self->priv->content_revealer = NULL;
	self->priv->content = NULL;
	self->priv->volume_slider = NULL;
}

static void
sound_input_raven_widget_finalize (GObject * obj)
{
	SoundInputRavenWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND_INPUT_RAVEN_WIDGET, SoundInputRavenWidget);
	_g_object_unref0 (self->priv->budgie_settings);
	_g_object_unref0 (self->priv->mixer);
	_g_hash_table_unref0 (self->priv->derpers);
	_g_hash_table_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->primary_stream);
	_g_object_unref0 (self->priv->main_box);
	_g_object_unref0 (self->priv->devices_list);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->header_icon);
	_g_object_unref0 (self->priv->header_reveal_button);
	_g_object_unref0 (self->priv->content_revealer);
	_g_object_unref0 (self->priv->content);
	_g_object_unref0 (self->priv->volume_slider);
	G_OBJECT_CLASS (sound_input_raven_widget_parent_class)->finalize (obj);
}

GType
sound_input_raven_widget_get_type (void)
{
	return sound_input_raven_widget_type_id;
}

GType
sound_input_raven_widget_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundInputRavenWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_input_raven_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundInputRavenWidget), 0, (GInstanceInitFunc) sound_input_raven_widget_instance_init, NULL };
	sound_input_raven_widget_type_id = g_type_module_register_type (module, budgie_raven_widget_get_type (), "SoundInputRavenWidget", &g_define_type_info, 0);
	SoundInputRavenWidget_private_offset = sizeof (SoundInputRavenWidgetPrivate);
	return sound_input_raven_widget_type_id;
}

static inline gpointer
sound_input_raven_widget_settings_get_instance_private (SoundInputRavenWidgetSettings* self)
{
	return G_STRUCT_MEMBER_P (self, SoundInputRavenWidgetSettings_private_offset);
}

SoundInputRavenWidgetSettings*
sound_input_raven_widget_settings_construct (GType object_type,
                                             GSettings* settings)
{
	SoundInputRavenWidgetSettings * self = NULL;
	GtkSwitch* _tmp0_;
	self = (SoundInputRavenWidgetSettings*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->switch_allow_volume_overdrive;
	g_settings_bind (settings, "allow-volume-overdrive", (GObject*) _tmp0_, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

SoundInputRavenWidgetSettings*
sound_input_raven_widget_settings_new (GSettings* settings)
{
	return sound_input_raven_widget_settings_construct (TYPE_SOUND_INPUT_RAVEN_WIDGET_SETTINGS, settings);
}

static void
sound_input_raven_widget_settings_class_init (SoundInputRavenWidgetSettingsClass * klass,
                                              gpointer klass_data)
{
	sound_input_raven_widget_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundInputRavenWidgetSettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = sound_input_raven_widget_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/buddiesofbudgie/budgie-desktop/raven/widget/SoundInput/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "switch_allow_volume_overdrive", FALSE, SoundInputRavenWidgetSettings_private_offset + G_STRUCT_OFFSET (SoundInputRavenWidgetSettingsPrivate, switch_allow_volume_overdrive));
}

static void
sound_input_raven_widget_settings_instance_init (SoundInputRavenWidgetSettings * self,
                                                 gpointer klass)
{
	self->priv = sound_input_raven_widget_settings_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sound_input_raven_widget_settings_finalize (GObject * obj)
{
	SoundInputRavenWidgetSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SOUND_INPUT_RAVEN_WIDGET_SETTINGS, SoundInputRavenWidgetSettings);
	G_OBJECT_CLASS (sound_input_raven_widget_settings_parent_class)->finalize (obj);
}

GType
sound_input_raven_widget_settings_get_type (void)
{
	return sound_input_raven_widget_settings_type_id;
}

GType
sound_input_raven_widget_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundInputRavenWidgetSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_input_raven_widget_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundInputRavenWidgetSettings), 0, (GInstanceInitFunc) sound_input_raven_widget_settings_instance_init, NULL };
	sound_input_raven_widget_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "SoundInputRavenWidgetSettings", &g_define_type_info, 0);
	SoundInputRavenWidgetSettings_private_offset = sizeof (SoundInputRavenWidgetSettingsPrivate);
	return sound_input_raven_widget_settings_type_id;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	sound_input_raven_plugin_register_type (module);
	sound_input_raven_widget_register_type (module);
	sound_input_raven_widget_settings_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_raven_plugin_get_type (), TYPE_SOUND_INPUT_RAVEN_PLUGIN);
	_g_object_unref0 (objmodule);
}

